"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderUsage;

var _prettyCode = require("./pretty-code");

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function renderUsage(_) {
  try {
    return [_.title && (0, _prettyCode.title)(_.title), _.intro && (0, _prettyCode.intro)(_.intro), _.usages && (0, _prettyCode.usage)(_.usages), _.examples && (0, _prettyCode.examples)(_.examples), _.options && (0, _prettyCode.options)(_.options), _.related && (0, _prettyCode.related)(_.related)].filter(_ => _).join('\n');
  } catch (err) {
    console.error('Internal error formatting usage', err);
  }
}