"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.command = command;
exports.intro = intro;
exports.option = option;
exports.title = title;
exports.pipeline = pipeline;
exports.usage = usage;
exports.examples = examples;
exports.related = related;
exports.options = options;

var _colors = _interopRequireDefault(require("colors"));

var _wordWrap = _interopRequireDefault(require("word-wrap"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function command(cmdline) {
  return `${_colors.default.cyan(cmdline)}`;
}

function intro(paragraph) {
  return (0, _wordWrap.default)(paragraph, {
    width: 100,
    indent: '  '
  }) + '\n';
}

function option(opts) {
  return typeof opts === 'string' ? _colors.default.bold(opts) : opts.map(_ => _colors.default.bold(_)).join(', ');
}

function title(_) {
  return `${_colors.default.bold.yellow(_.command)} ${_.doc}
`;
}
/** @return pretty-printed version of the given bash pipeline */


function pipeline(code) {
  return code.replace(/(\s+\|\s+)(\w+)/g, (_, p1, p2) => `${p1}${_colors.default.cyan(p2)}`).replace(/(\s+--\s+)(\w+)/g, (_, p1, p2) => `${p1}${_colors.default.cyan(p2)}`).replace(/\[[^\]]*options[^\]]*\]/, _ => _colors.default.gray(_)).replace(/\[[^\]]*name[^\]]*\]/, _ => _colors.default.gray(_)).replace(/\/s3\/aws\/commoncrawl\/[./\-{},\w]+/, _ => _colors.default.dim(_)).replace(/ \|/g, _ => _colors.default.magenta(_)).replace(/ \\/g, _ => _colors.default.dim(_)).replace(/kiwi super/, _ => _colors.default.yellow(_));
} // \u2063 is "invisible separator" https://www.fileformat.info/info/unicode/char/2063/index.htm
// needed for columnify, which deletes whitespace


const indent = '  ';
const indentedLines = '\n  ';

function usage(usages) {
  return `Usage:
  ${usages.map(pipeline).join(indentedLines)}
`;
}

function examples(examples, sectionTitle = 'Examples') {
  const data = examples.map(_ => ({
    command: `${indent}${command(_.command)}`,
    doc: _.doc
  }));
  return `${sectionTitle}:
${require('columnify')(data, {
    showHeaders: false
  })} 
`;
}

function related(related) {
  return `Related:
  ${_colors.default.dim(related.map(command).join(', '))}
`;
}

function options(options) {
  const data = options.map(_ => ({
    option: `${indent}${option(_.flags)}`,
    doc: `${_.doc}${_.default ? ` ${_colors.default.gray('default: ' + _.default)}` : ''}`
  }));
  return `Options:
${require('columnify')(data, {
    showHeaders: false
  })}
`;
}