/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { getCurrentTab } from '@kui-shell/core';
function hasFraction(props) {
    return typeof props.fraction === 'number';
}
/** Format as a "xy%" string */
function fractionString(props) {
    return hasFraction(props) ? 100 * props.fraction + '%' : props.fractionString;
}
/**
 * Create a bar, and place it in the given container. If the optional
 * initialFraction is given, then set the bar's width to that value.
 * |    >   |
 *
 * where, in the code below:
 * - `bar` is |        |
 * - `live` is the region of `bar` up to the >
 */
export function Bar(props) {
    const liveStyle = {
        backgroundColor: props.color,
        bodrerRight: '1px solid var(--color-stripe-02)',
        width: fractionString(props)
    };
    return (React.createElement("div", { style: { display: 'flex', backgroundColor: 'var(--color-stripe-01)', height: '1em', width: '5em' } },
        React.createElement("div", { style: liveStyle })));
}
/**
 * Create a container for one or more bars.
 *
 * @param alignment for singleton bars, probably 'center'; for
 * multi-bar content, probably 'space-between'
 *
 * @return the container DOM
 *
 */
export function BarContainer(props) {
    const style = {
        display: 'flex',
        flexDirection: props.flexDirection || 'column',
        justifyContent: props.alignment || 'space-between'
    };
    return props.onClick ? (React.createElement("a", { style: style, href: "#", onClick: () => getCurrentTab().REPL.pexec(props.onClick) }, props.children)) : (React.createElement("div", { style: style }, props.children));
}
export function SingletonBar(props) {
    return (React.createElement(BarContainer, { alignment: "center", flexDirection: "row" },
        React.createElement(Bar, Object.assign({}, props)),
        props.text && React.createElement("span", { className: "even-smaller-text sub-text small-left-pad" }, fractionString(props))));
}
export function singletonBar(props) {
    return React.createElement(SingletonBar, Object.assign({}, props));
}
//# sourceMappingURL=bar.js.map