"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Bar = Bar;
exports.BarContainer = BarContainer;
exports.SingletonBar = SingletonBar;
exports.singletonBar = singletonBar;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function hasFraction(props) {
  return typeof props.fraction === 'number';
}
/** Format as a "xy%" string */


function fractionString(props) {
  return hasFraction(props) ? 100 * props.fraction + '%' : props.fractionString;
}
/**
 * Create a bar, and place it in the given container. If the optional
 * initialFraction is given, then set the bar's width to that value.
 * |    >   |
 *
 * where, in the code below:
 * - `bar` is |        |
 * - `live` is the region of `bar` up to the >
 */


function Bar(props) {
  const liveStyle = {
    backgroundColor: props.color,
    bodrerRight: '1px solid var(--color-stripe-02)',
    width: fractionString(props)
  };
  return _react.default.createElement("div", {
    style: {
      display: 'flex',
      backgroundColor: 'var(--color-stripe-01)',
      height: '1em',
      width: '5em'
    }
  }, _react.default.createElement("div", {
    style: liveStyle
  }));
}
/**
 * Create a container for one or more bars.
 *
 * @param alignment for singleton bars, probably 'center'; for
 * multi-bar content, probably 'space-between'
 *
 * @return the container DOM
 *
 */


function BarContainer(props) {
  const style = {
    display: 'flex',
    flexDirection: props.flexDirection || 'column',
    justifyContent: props.alignment || 'space-between'
  };
  return props.onClick ? _react.default.createElement("a", {
    style: style,
    href: "#",
    onClick: () => (0, _core.getCurrentTab)().REPL.pexec(props.onClick)
  }, props.children) : _react.default.createElement("div", {
    style: style
  }, props.children);
}

function SingletonBar(props) {
  return _react.default.createElement(BarContainer, {
    alignment: "center",
    flexDirection: "row"
  }, _react.default.createElement(Bar, Object.assign({}, props)), props.text && _react.default.createElement("span", {
    className: "even-smaller-text sub-text small-left-pad"
  }, fractionString(props)));
}

function singletonBar(props) {
  return _react.default.createElement(SingletonBar, Object.assign({}, props));
}