/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { getNamespace, isKubeResource, doExecWithStdout, doExecWithRadioTable } from '@kui-shell/plugin-kubectl';
/** onSelect handler for the RadioTable view model */
function onSelectProject(name) {
    return __awaiter(this, void 0, void 0, function* () {
        yield this.pexec(`odo project set ${this.encodeComponent(name)}`);
    });
}
/**
 * Transform the KubeItems<Project> resource to a RadioTable view model.
 *
 */
export function projectListView(args, response) {
    if (args.parsedOptions.o !== 'json' && isKubeResource(response)) {
        // the user requested a RadioTable view
        const projects = JSON.parse(response.kuiRawData).items;
        const defaultSelectedIdx = projects.findIndex(_ => _.status.active);
        const opts = {
            title: 'Projects',
            nameColumnTitle: 'PROJECT'
        };
        return doExecWithRadioTable(projects, defaultSelectedIdx, onSelectProject.bind(args.REPL), opts) || response;
    }
    else {
        // otherwise, the user did not request a RadioTable view
        return response;
    }
}
/**
 * Always fetch the JSON data, even if the user did not request it.
 *
 * We will then transform the JSON KubeItems<Project> model into a
 * `RadioTable` view model via the `projectListView` viewTransformer.
 *
 */
function getRawData(args) {
    if (args.parsedOptions.o !== 'json') {
        args.command += ' -o json';
        args.argv.push('-o');
        args.argv.push('-json');
        args.argvNoOptions.push('-o');
        args.argvNoOptions.push('-json');
    }
    return doExecWithStdout(args, undefined, 'odo');
}
/** Fetch the KubeItems<Project> model */
export function projectList(args) {
    return __awaiter(this, void 0, void 0, function* () {
        const kuiRawData = yield getRawData(args);
        const list = JSON.parse(kuiRawData);
        return Object.assign(list, {
            metadata: {
                name: args.command,
                namespace: yield getNamespace(args)
            },
            modes: [],
            kuiRawData,
            isSimulacrum: true,
            isKubeResource: true,
            originatingCommand: args
        });
    });
}
//# sourceMappingURL=list.js.map