/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors, Util } from '@kui-shell/test';
import { createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubectl/tests/lib/k8s/utils';
import { readFileSync } from 'fs';
import { dirname, join } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubectl/tests/package.json'));
const inputBuffer = readFileSync(join(ROOT, 'data/k8s/event-generator.yaml'));
const inputEncoded = inputBuffer.toString('base64');
const wdescribe = !process.env.USE_WATCH_PANE ? describe : xdescribe;
const podName = 'eventgen';
const commands = ['kubectl'];
if (process.env.NEEDS_OC) {
    commands.push('oc');
}
commands.forEach(command => {
    wdescribe(`${command} get events via table ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
        before(Common.before(this));
        after(Common.after(this));
        const ns = createNS();
        allocateNS(this, ns);
        /** error handling starts */
        it('should create pod that generates events', () => CLI.command(`echo ${inputEncoded} | base64 --decode | ${command} create -f - -n ${ns}`, this.app)
            .then(ReplExpect.okWithPtyOutput(podName))
            .catch(Common.oops(this, true)));
        it('should click on Show Involved Object', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const res = yield CLI.command(`k get events -o wide -n ${ns}`, this.app);
                const table = `${Selectors.OUTPUT_N(res.count)} table`;
                const clickOn = `${table} tr:first-child .clickable`;
                const resAfter = yield Util.openSidecarByClick(this, clickOn, podName);
                // click the involvedObject button
                yield Util.clickSidecarModeButton(this, resAfter, 'involvedObject');
                yield SidecarExpect.openInBlockAfter(resAfter)
                    .then(SidecarExpect.showing(podName))
                    .then(SidecarExpect.kind('Pod'));
            }
            catch (err) {
                yield Common.oops(this, true)(err);
            }
        }));
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=events-via-table.js.map