/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { execSync } from 'child_process';
import { Common, CLI } from '@kui-shell/test';
function getProxyPids() {
    return execSync(`ps aux | grep --color=never 'kubectl proxy --keepalive' | grep -v grep | awk '{print $2}'`)
        .toString()
        .split(/\n/)
        .filter(_ => _)
        .map(_ => parseInt(_, 10));
}
describe(`kubectl managed proxy ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    let pidsA;
    it('should wait until we have one live kubectl proxy', () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                pidsA = getProxyPids();
                return pidsA.length > 0;
            }), { timeout: CLI.waitTimeout });
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    it('should reload, and have a different set of proxy pids', () => __awaiter(this, void 0, void 0, function* () {
        yield Common.refresh(this);
        let idx = 0;
        yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            const pidsB = getProxyPids();
            const nBNotInA = pidsB.reduce((N, pidB) => (pidsA.includes(pidB) ? N : N + 1), 0);
            if (++idx > 5) {
                console.error(`still waiting for a different set of proxy pids; pidsA=${pidsA} pidsB=${pidsB} nBNotInA=${nBNotInA}`);
            }
            return nBNotInA > 0;
        }), { timeout: CLI.waitTimeout });
    }));
});
//# sourceMappingURL=managed-proxy.js.map