/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/* eslint-disable no-unmodified-loop-condition */
import Debug from 'debug';
import { encodeComponent, getTab, isTopLevelTab, registerTabState } from '@kui-shell/core';
import kubectl from './controller/cli';
import { getCurrentDefaultContextName, getCurrentDefaultNamespace } from './controller/kubectl/contexts';
const debug = Debug('plugins/plugin-kubectl/tab-state');
const name = 'plugins/plugin-kubectl';
const apiVersion = 'v1';
export function getTabState(tab, key) {
    try {
        return tab.getState(name, apiVersion, key);
    }
    catch (err) {
        return undefined;
    }
}
function setTabState(tab, key, value) {
    tab.setState(name, apiVersion, key, value);
}
function capture(tabState) {
    return __awaiter(this, void 0, void 0, function* () {
        const tab = getTab(parseInt(tabState.uuid));
        if (tab) {
            try {
                const [currentContext, currentNamespace] = yield Promise.all([
                    getCurrentDefaultContextName(tab),
                    getCurrentDefaultNamespace(tab)
                ]);
                const context = getTabState(tabState, 'context');
                const namespace = getTabState(tabState, 'namespace');
                if (!context || currentContext !== context) {
                    setTabState(tabState, 'context', currentContext);
                }
                if (!namespace || currentNamespace !== namespace) {
                    setTabState(tabState, 'namespace', currentNamespace);
                }
                debug('captured tab state', tab.uuid, currentContext, currentNamespace);
            }
            catch (err) {
                if (!/command not found/.test(err)) {
                    console.error(`plugin-kubectl: failed to capture tab-state`, err, tabState);
                }
                // clear state
                setTabState(tabState, 'context', '');
                setTabState(tabState, 'namespace', '');
            }
        }
    });
}
function restore(tabState) {
    return __awaiter(this, void 0, void 0, function* () {
        const tab = getTab(parseInt(tabState.uuid));
        const namespace = getTabState(tabState, 'namespace');
        const context = getTabState(tabState, 'context');
        try {
            const [currentContext, currentNamespace] = yield Promise.all([
                getCurrentDefaultContextName(tab),
                getCurrentDefaultNamespace(tab)
            ]);
            if (currentContext !== context || currentNamespace !== namespace) {
                yield tab.REPL.qexec(`${kubectl} config set-context ${encodeComponent(context)} --namespace=${namespace}`);
                yield tab.REPL.qexec(`${kubectl} config use-context ${encodeComponent(context)}`);
            }
            debug('restored tab state', tab.uuid, context, namespace);
        }
        catch (err) {
            if (!/command not found/.test(err)) {
                console.error(`plugin-kubectl: failed to restore tab-state`, err, tabState);
            }
        }
    });
}
const switchTo = (currentTabState, nextTabState) => __awaiter(void 0, void 0, void 0, function* () {
    if (isTopLevelTab(currentTabState)) {
        try {
            yield capture(currentTabState);
            yield restore(nextTabState);
        }
        catch (err) {
            console.error(`plugin-kubectl: failed to switch tab`, err, currentTabState, nextTabState);
        }
    }
});
export default function () {
    return registerTabState({ name, apiVersion, capture, restore, switchTo });
}
//# sourceMappingURL=tab-state.js.map