import { Tab } from '@kui-shell/core';
import { KubeResource } from '../../model/resource';
/** Mode identifier. Not a UI string. Only for internal referencing. */
export declare const mode = "last applied";
export declare const label: string;
export declare const order = 998;
/**
 * @return whether the given resource has a last applied configuration annotation
 *
 */
export declare function hasLastApplied(resource: KubeResource): boolean;
/**
 * The main work here is to extract and parse the JSON, and turn it
 * into something we want to display: a yaml string.
 *
 */
export declare const renderLastApplied: (tab: Tab, resource: KubeResource) => Promise<{
    content: string;
    contentType: string;
}>;
declare const _default: {
    when: typeof hasLastApplied;
    mode: {
        mode: string;
        label: string;
        order: number;
        content: (tab: Tab, resource: KubeResource<import("../../model/resource").KubeStatus, import("../../model/resource").KubeMetadata>) => Promise<{
            content: string;
            contentType: string;
        }>;
    };
};
/**
 * This is our mode model for the Last Applied tab.
 *
 */
export default _default;
