/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { i18n } from '@kui-shell/core';
import { isPod } from '../../model/resource';
import { getCommandFromArgs } from '../../../lib/util/util';
const strings = i18n('plugin-kubectl');
/**
 * Extract the events
 *
 */
function command(tab, pod, args) {
    return `${getCommandFromArgs(args)} get node ${pod.spec.nodeName} -o yaml`;
}
/**
 * Add an Involved Object mode button
 *
 */
const mode = {
    when: isPod,
    mode: {
        mode: 'show-node',
        kind: 'drilldown',
        showRelatedResource: true,
        label: strings('Show Node'),
        command
    }
};
export default mode;
//# sourceMappingURL=ShowNodeOfPodButton.js.map