import React from 'react';
import { Arguments, Button, ParsedOptions, Job, Tab, ToolbarProps, ToolbarText } from '@kui-shell/core';
import { Pod } from '../../model/resource';
/**
 * We will wait this many milliseconds after the PTY is ready for log
 * data to arrive before proclaiming No log data.
 *
 */
export declare const HYSTERESIS = 1500;
export declare type StreamingStatus = 'Live' | 'Paused' | 'Stopped' | 'Error' | 'Idle';
export interface ContainerProps {
    args: {
        argsForMode?: Arguments;
        argvNoOptions: string[];
        parsedOptions: ParsedOptions;
    };
    tab: Tab;
    pod: Pod;
    toolbarController: ToolbarProps;
}
export interface ContainerState {
    /** Are we focused on one container? `undefined` means all containers. */
    container: string;
    /** The underlying PTY streaming job. */
    job: Job;
    /**
     * To help with races, e.g. switch to container A, then B, then A;
     * we need to distinguish the PTYs for the first and last, despite
     * them targeting the same container
     *
     */
    streamUUID: string;
}
export declare abstract class ContainerComponent<State extends ContainerState> extends React.PureComponent<ContainerProps, State> {
    protected abstract toolbarText(status: StreamingStatus): ToolbarText;
    protected toolbarButtonsForError(status: StreamingStatus): Button[];
    protected toolbarButtonsForStreaming(status: StreamingStatus): Button[];
    /** Buttons to display in the Toolbar. */
    protected toolbarButtons(status: StreamingStatus): Button[];
    protected supportsAllContainers(): boolean;
    /** When we are going away, make sure to abort the streaming job. */
    componentWillUnmount(): void;
    /** Update Toolbar text and Toolbar buttons. */
    protected updateToolbar(status: StreamingStatus): void;
    protected showContainer(container: string): void;
    /** Render a selection component that allows user to select a container. */
    private containerOptions;
    /** Are we focusing on all containers? */
    protected isAllContainers(): boolean;
    /** List of containers that is compatible with toolbar buttons model */
    protected containerList(): Button<import("@kui-shell/core").ResourceWithMetadata<void>>[];
}
