import { Table, Arguments, Abortable, Watchable, Watcher, WatchPusher } from '@kui-shell/core';
import { KubeOptions } from '../options';
export declare class EventWatcher implements Abortable, Watcher {
    private readonly args;
    private readonly command;
    private readonly kindByUser;
    private readonly name;
    private readonly namespace;
    private readonly watchOnly;
    private readonly pusher;
    /**
     * We may get an `abort()` call before we've finished initializing
     * the PTY. This bit protects against that race. https://github.com/IBM/kui/issues/5149
     */
    private shouldAbort;
    private ptyJob; /** the pty job we spawned to capture --watch output */
    private eventLeftover;
    /** Timestamp when we started up */
    private now;
    constructor(args: Arguments, command: string, kindByUser: string, name: string[], namespace: string, watchOnly: boolean, pusher: WatchPusher);
    abort(): void;
    private onPTYEventInit;
    private onPTYInitDone;
    init(): Promise<void>;
}
/**
 * Start watching for changes to the resources of the given table.
 *
 */
export default function doGetWatchTable(args: Arguments<KubeOptions>): Promise<string | (Table & Watchable)>;
