import { Arguments, Breadcrumb, Registrar } from '@kui-shell/core';
import { KubeOptions } from './options';
export declare const doExplain: (command?: string) => (args: Arguments<KubeOptions>) => Promise<string | number | boolean | Error | import("@kui-shell/core").NavResponse | HTMLElement | import("@kui-shell/core/mdist/models/entity").MarkdownResponse | import("@kui-shell/core").ReactResponse | import("@kui-shell/core").MixedResponse | import("@kui-shell/core").CommentaryResponse | import("@kui-shell/core/mdist/models/TabLayoutModificationResponse").default<import("@kui-shell/core").NewSplitRequest> | import("@kui-shell/core").XtermResponse | {
    code: string;
} | {
    errno: string | number;
} | (import("@kui-shell/core").Table<import("@kui-shell/core").Row> & Partial<import("@kui-shell/core").WithSourceReferences>) | (import("@kui-shell/core").Abortable & {
    response: import("@kui-shell/core").ScalarResponse<import("@kui-shell/core").Row>;
}) | import("@kui-shell/core/mdist/models/RadioTable").default | import("@kui-shell/core").UsageModel | import("@kui-shell/core").ResourceWithMetadata<any> | import("@kui-shell/core").RawResponse<any> | import("@kui-shell/core").ResourceWithMetadata<any>[] | {
    apiVersion: string;
    kind: string;
    breadcrumbs: Breadcrumb[];
    menus: {
        label: string;
        items: {
            mode: string;
            contentType: string;
            content: string;
        }[];
    }[];
}>;
export interface Explained {
    /** e.g. Deployment */
    kind: string;
    /** e.g. apps/v1 */
    version: string;
    /** Is this resource kind cluster-scoped (versus namespace-scoped)? */
    isClusterScoped: boolean;
}
export declare function getKindAndVersion(command: string, args: Arguments, kindAsProvidedByUser: string): Promise<Explained>;
/**
 * @param kindAsProvidedByUser e.g. pod or po
 * @return e.g. Pod
 *
 */
export declare function getKind(command: string, args: Arguments, kindAsProvidedByUser: string): Promise<string>;
declare const _default: (registrar: Registrar) => void;
export default _default;
