/**
 * Notes: this file covers the three (as of this writing) subcommands
 * of apply:
 *  - view-last-applied
 *  - set-last-applied
 *  - edit-last-applied
 *
 */
import { Arguments, Registrar } from '@kui-shell/core';
import { KubeOptions } from './options';
import KubeResource from '../../lib/model/resource';
/** View Transformer for view-last-applied and edit-last-applied */
export declare const viewLastApplied: (subcommand: 'view-last-applied' | 'edit-last-applied') => (args: Arguments<KubeOptions>, response: KubeResource) => Promise<import("@kui-shell/core").ResourceWithMetadata<void> & import("../../lib/model/resource").WithRawData<void> & {
    apiVersion: string;
    kind: string;
    metadata?: import("../../lib/model/resource").KubeMetadata;
    status?: import("../../lib/model/resource").KubeStatus;
    spec?: any;
    originatingCommand: Arguments<KubeOptions>;
    isSimulacrum?: boolean;
    isKubeResource: true;
} & import("@kui-shell/core/mdist/models/mmr/types").View<KubeResource<import("../../lib/model/resource").KubeStatus, import("../../lib/model/resource").KubeMetadata>> & {
    defaultMode: string;
}>;
export declare function registerApplySubcommands(registrar: Registrar, cmd: string): void;
export default function registerForKubectl(registrar: Registrar): void;
