import { Arguments } from '@kui-shell/core';
import { Explained } from '../../kubectl/explain';
import { KubeOptions } from '../../kubectl/options';
export declare type URLFormatter = (includeKind?: boolean, includeQueries?: boolean, name?: string, overrides?: {
    version?: string;
    kind?: string;
}) => string;
/**
 * @return a function that returns a URL string that can be used as a
 * curl endpoint for accessing a kubernetes apiServer
 *
 * @param command e.g. kubectl or oc
 */
export declare function urlFormatterFor(command: string, namespace: string, { parsedOptions }: Pick<Arguments<KubeOptions>, 'parsedOptions'>, { kind, version, isClusterScoped }: Explained): URLFormatter;
export declare function urlFormatterForArgs(args: Arguments<KubeOptions>, explainedKind: Explained): Promise<URLFormatter>;
export default URLFormatter;
