"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _get = _interopRequireDefault(require("./controller/helm/get"));

var _raw = _interopRequireDefault(require("./controller/helm/raw"));

var _list = _interopRequireDefault(require("./controller/helm/list"));

var _repo = _interopRequireDefault(require("./controller/helm/repo"));

var _search = _interopRequireDefault(require("./controller/helm/search"));

var _status = _interopRequireDefault(require("./controller/helm/status"));

var _install = _interopRequireDefault(require("./controller/helm/install"));

var _history = _interopRequireDefault(require("./controller/helm/history"));

var _catchall = _interopRequireDefault(require("./controller/helm/catchall"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

var _default = registrar => __awaiter(void 0, void 0, void 0, function* () {
  (0, _get.default)(registrar);
  (0, _raw.default)(registrar);
  (0, _list.default)(registrar);
  (0, _repo.default)(registrar);
  (0, _search.default)(registrar);
  (0, _status.default)(registrar);
  (0, _install.default)(registrar);
  (0, _history.default)(registrar);
  (0, _catchall.default)(registrar);
});

exports.default = _default;