"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _release = require("../models/release");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-kubectl', 'helm');
var _default = {
  when: _release.isHelmRelease,
  mode: {
    mode: 'manifest',
    label: strings('Manifest'),
    content: (_, resource) => ({
      contentFrom: `helm get manifest ${resource.metadata.name}`,
      contentType: 'yaml'
    })
  }
};
exports.default = _default;