"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

var _usage = _interopRequireDefault(require("./usage"));

var _exec = _interopRequireDefault(require("./exec"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function doRepoList(args) {
  return __awaiter(this, void 0, void 0, function* () {
    if ((0, _usage.default)(args, 'repo')) {
      return (0, _pluginKubectl.doHelp)('helm', args);
    }

    const response = yield (0, _exec.default)(args);
    const preTables = (0, _pluginKubectl.preprocessTable)(response.split(/^(?=LAST SEEN|NAMESPACE|NAME\s+)/m));
    return (0, _pluginKubectl.formatTable)('helm', undefined, undefined, args, preTables[0]);
  });
}

var _default = registrar => {
  registrar.listen('/helm/repo/ls', doRepoList);
  registrar.listen('/helm/repo/list', doRepoList);
};

exports.default = _default;