"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _apiResources = _interopRequireDefault(require("./controller/kubectl/api-resources"));

var _contexts = _interopRequireDefault(require("./controller/kubectl/contexts"));

var _create = _interopRequireDefault(require("./controller/kubectl/create"));

var _deployment = _interopRequireDefault(require("./controller/kubectl/deployment"));

var _describe = _interopRequireDefault(require("./controller/kubectl/describe"));

var _diff = _interopRequireDefault(require("./controller/kubectl/diff"));

var _edit = _interopRequireDefault(require("./controller/kubectl/edit"));

var _explain = _interopRequireDefault(require("./controller/kubectl/explain"));

var _delete = _interopRequireDefault(require("./controller/kubectl/delete"));

var _get = _interopRequireDefault(require("./controller/kubectl/get"));

var _getNamespaces = _interopRequireDefault(require("./controller/kubectl/get-namespaces"));

var _kustomize = _interopRequireDefault(require("./controller/kubectl/kustomize"));

var _raw = _interopRequireDefault(require("./controller/kubectl/raw"));

var _run = _interopRequireDefault(require("./controller/kubectl/run"));

var _top = _interopRequireDefault(require("./controller/kubectl/top"));

var _config = _interopRequireDefault(require("./controller/kubectl/config"));

var _list = _interopRequireDefault(require("./controller/kubectl/job/list"));

var _applySubcommands = _interopRequireDefault(require("./controller/kubectl/apply-subcommands"));

var _fetchFile = _interopRequireDefault(require("./controller/fetch-file"));

var _catchall = _interopRequireDefault(require("./controller/kubectl/catchall"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

var _default = registrar => __awaiter(void 0, void 0, void 0, function* () {
  (0, _apiResources.default)(registrar);
  (0, _contexts.default)(registrar);
  (0, _create.default)(registrar);
  (0, _describe.default)(registrar);
  (0, _diff.default)(registrar);
  (0, _explain.default)(registrar);
  (0, _edit.default)(registrar);
  (0, _delete.default)(registrar);
  (0, _list.default)(registrar);
  (0, _get.default)(registrar);
  (0, _getNamespaces.default)(registrar);
  (0, _deployment.default)(registrar);
  (0, _kustomize.default)(registrar);
  (0, _raw.default)(registrar);
  (0, _run.default)(registrar);
  (0, _top.default)(registrar);
  (0, _config.default)(registrar);
  (0, _applySubcommands.default)(registrar);
  (0, _fetchFile.default)(registrar);
  (0, _catchall.default)(registrar);
});

exports.default = _default;