"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.mode = void 0;

var _core = require("@kui-shell/core");

var _resource = require("../../model/resource");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-kubectl', 'logs');
const mode = {
  mode: 'logs',
  label: strings('Logs'),
  // hack workaround to defer loading of plugin-client-common; needs update to babel-plugin-ignore-html-and-css-imports
  content: (tab, pod, args) => Promise.resolve().then(() => require('./logs')).then(_ => _.content(tab, pod, args))
};
/**
 * The Summary mode applies to all KubeResources, and uses
 * `renderContent` to render the view.
 *
 */

exports.mode = mode;
const logsReg = {
  when: _resource.isPod,
  mode
};
var _default = logsReg;
exports.default = _default;