"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _fqn = require("../../../controller/kubectl/fqn");

var _resource = require("../../model/resource");

var _ = require("../../..");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl');
/**
 * Extract the events
 *
 */

function command(tab, {
  involvedObject: {
    apiVersion,
    kind,
    name,
    namespace
  }
}, args) {
  return __awaiter(this, void 0, void 0, function* () {
    return `${(0, _.getCommandFromArgs)(args)} get ${(0, _fqn.fqn)(apiVersion, (0, _core.encodeComponent)(kind), (0, _core.encodeComponent)(name), (0, _core.encodeComponent)(namespace || (yield (0, _.getCurrentDefaultNamespace)(tab))))} -o yaml`;
  });
}
/**
 * Add an Involved Object mode button
 *
 */


const mode = {
  when: _resource.hasInvolvedObject,
  mode: {
    mode: 'involvedObject',
    label: strings('Show Involved Object'),
    command,
    kind: 'drilldown'
  }
};
var _default = mode;
exports.default = _default;