"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = NamespaceSummary;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

var _Generic = require("./Generic");

var _options = require("../../../../../controller/kubectl/options");

var _tableToMap = _interopRequireDefault(require("../../table-to-map"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
/**
 * Name: default
 * Status: Active
 * Age: 562d
 *
 */


const debug = (0, _debug.default)('plugin-kubectl/view/modes/Summary');

function NamespaceSummary(ns, repl) {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      metadata,
      status
    } = ns;
    const summary = {
      Name: metadata.name,
      Status: status.phase,
      Age: (0, _Generic.age)(ns)
    };

    try {
      const quota = yield repl.qexec((0, _options.withKubeconfigFrom)(ns.originatingCommand, `kubectl get quota -n ${ns.metadata.name}`));

      if ((0, _core.isTable)(quota) && quota.body.length >= 1) {
        const map = quota.body.map(row => (0, _tableToMap.default)({
          body: [row]
        }));
        Object.assign(summary, {
          quota: map
        });
      }
    } catch (err) {
      debug('no quota found');
    }

    return summary;
  });
}