"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toTrafficLight = toTrafficLight;
exports.default = void 0;

/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * A rollup of State to "traffic light" model
 *
 */
var TrafficLight;

(function (TrafficLight) {
  TrafficLight["Gray"] = "gray-background";
  TrafficLight["Red"] = "red-background";
  TrafficLight["Yellow"] = "yellow-background";
  TrafficLight["Blue"] = "blue-background";
  TrafficLight["Green"] = "green-background";
})(TrafficLight || (TrafficLight = {}));

function toTrafficLight(str) {
  if (str.indexOf(TrafficLight.Red) >= 0) {
    return TrafficLight.Red;
  } else if (str.indexOf(TrafficLight.Yellow) >= 0) {
    return TrafficLight.Yellow;
  } else if (str.indexOf(TrafficLight.Blue) >= 0) {
    return TrafficLight.Blue;
  } else if (str.indexOf(TrafficLight.Green) >= 0) {
    return TrafficLight.Green;
  } else {
    return TrafficLight.Gray;
  }
}

var _default = TrafficLight;
exports.default = _default;