"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.doSummarizeNamedNamespace = doSummarizeNamedNamespace;
exports.default = void 0;

var _contexts = require("./contexts");

var _get = require("./get");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * Summarize the resources in the namespace indicated by the last
 * positional argument into a table, where resources are histogrammed
 * by kind.
 *
 */
function doSummarizeNamedNamespace(tab, ns) {
  return __awaiter(this, void 0, void 0, function* () {
    // otherwise, summarize resource count by kind in a table
    const response = yield tab.REPL.qexec(`kubectl get all -n ${ns} -o custom-columns=KIND:.kind`);
    const resources = response.body;
    const histogram = resources.reduce((M, {
      name: kind
    }) => {
      M[kind] = (M[kind] || 0) + 1;
      return M;
    }, {});
    const header = {
      name: 'KIND',
      attributes: [{
        key: 'COUNT',
        value: 'COUNT'
      }]
    };
    const body = Object.keys(histogram).map(kind => ({
      name: kind,
      onclick: `kubectl get ${kind} -n ${ns}`,
      attributes: [{
        key: 'COUNT',
        value: histogram[kind].toLocaleString()
      }]
    })).sort((a, b) => histogram[b.name] - histogram[a.name]); // sort be decreasing count

    return {
      header,
      body
    };
  });
}
/**
 * Summarize the resources in the namespace indicated by the last
 * positional argument into a table, where resources are histogrammed
 * by kind.
 *
 */


function doSummarizeNamespace(args) {
  // summarize this namespace
  const ns = args.argvNoOptions[args.argvNoOptions.length - 1];
  return doSummarizeNamedNamespace(args.tab, ns);
}
/**
 * @return the currently active namespace in the currently selected context
 *
 */


function doGetCurrentNamespace({
  tab
}) {
  return __awaiter(this, void 0, void 0, function* () {
    return (yield (0, _contexts.getCurrentContext)(tab)).metadata.namespace;
  });
}

var _default = commandTree => {
  commandTree.listen('/namespace/current', doGetCurrentNamespace, _get.getFlags);
  commandTree.listen('/namespace/summarize', doSummarizeNamespace, _get.getFlags);
};

exports.default = _default;