"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.describer = describer;
exports.default = void 0;

var _path = require("path");

var _core = require("@kui-shell/core");

var _options = require("./options");

var _help = require("../../lib/util/help");

var _util = require("../../lib/util/util");

var _resource = require("../../lib/model/resource");

var _exec = require("./exec");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-kubectl');

const doDiff = command => function (args) {
  return __awaiter(this, void 0, void 0, function* () {
    if ((0, _help.isUsage)(args)) {
      return (0, _help.doHelp)(command, args);
    } else {
      try {
        const {
          REPL
        } = args;
        const filepath = (0, _options.getFileFromArgv)(args);
        const fullpath = (0, _core.findFile)((0, _core.expandHomeDir)(filepath));
        const name = (0, _path.basename)(filepath);
        const enclosingDirectory = (0, _path.dirname)(filepath);
        const packageName = enclosingDirectory === '.' ? undefined : enclosingDirectory;
        const [previous, current] = yield Promise.all([REPL.qexec((0, _options.withKubeconfigFrom)(args, `${command} get ${(0, _options.getFileForArgv)(args)} -o yaml`)), REPL.qexec((0, _options.withKubeconfigFrom)(args, `${command} apply ${(0, _options.getFileForArgv)(args)} --dry-run=server -o yaml`))]);
        console.error('previous', previous);
        console.error('current', current);

        if ((0, _resource.isKubeResource)(previous) && (0, _resource.isKubeResource)(current)) {
          const mode = {
            mode: 'diff',
            label: strings('Pending Changes'),
            content: {
              a: (0, _util.removeLastAppliedConfig)(previous.kuiRawData),
              b: (0, _util.removeLastAppliedConfig)(current.kuiRawData)
            },
            contentType: 'yaml'
          };
          const response = {
            apiVersion: 'kui-shell/v1',
            kind: 'File',
            metadata: {
              name,
              namespace: packageName
            },
            toolbarText: {
              type: 'info',
              text: strings('Showing changes between the working tree and previous commit.')
            },
            modes: [mode],
            spec: {
              filepath,
              fullpath,
              size: 0
            }
          };
          return response;
        } else {
          throw new Error('failed to get resources');
        }
      } catch (err) {
        console.error('error at kubectl diff', err);
        return (0, _exec.exec)(args, undefined, command);
      }
    }
  });
};
/** Register a command listener */


function describer(registrar, command, cli = command) {
  registrar.listen(`/${command}/diff`, doDiff(cli));
}

var _default = registrar => {
  describer(registrar, 'kubectl');
  describer(registrar, 'k', 'kubectl');
};

exports.default = _default;