"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = deleteDirect;

var _debug = _interopRequireDefault(require("debug"));

var _core = require("@kui-shell/core");

var _fetchFile = require("../../../lib/util/fetch-file");

var _explain = require("../../kubectl/explain");

var _options = require("../../kubectl/options");

var _status = _interopRequireDefault(require("./status"));

var _errors = _interopRequireDefault(require("./errors"));

var _url = require("./url");

var _states = require("../../../lib/model/states");

var _util = require("../../../lib/util/util");

var _headers = require("./headers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugin-kubectl/controller/client/direct/delete');

function deleteDirect(args, _kind) {
  return __awaiter(this, void 0, void 0, function* () {
    // For now, we only handle delete-by-name
    // re: context and kubeconfig, see https://github.com/IBM/kui/issues/7023
    if (!(0, _options.getFileFromArgv)(args) && !(0, _options.getLabel)(args) && !args.parsedOptions['dry-run'] && !args.parsedOptions['field-selector'] && !args.parsedOptions.context && !args.parsedOptions.kubeconfig) {
      const explainedKind = yield _kind || (0, _explain.getKindAndVersion)((0, _util.getCommandFromArgs)(args), args, args.argvNoOptions[args.argvNoOptions.indexOf('delete') + 1]);
      const {
        kind
      } = explainedKind;
      const formatUrl = yield (0, _url.urlFormatterForArgs)(args, explainedKind); // this tells the apiServer that we want the delete to return right away

      const data = {
        propagationPolicy: 'Background'
      };
      const kindIdx = args.argvNoOptions.indexOf('delete') + 1;
      const names = args.argvNoOptions.slice(kindIdx + 1);

      if (kind && names.length > 0) {
        const urls = names.map(formatUrl.bind(undefined, true, false)).join(',');
        debug('attempting delete direct', urls);
        const responses = yield (0, _fetchFile.fetchFile)(args.REPL, urls, {
          method: 'delete',
          headers: _headers.headersForPlainRequest,
          returnErrors: true,
          data
        }); // then dissect it into errors and non-errors

        const {
          errors,
          ok
        } = yield (0, _errors.default)(responses, formatUrl, kind, args.REPL);

        if (ok.length === 0) {
          // all 404 errors? then tell the user about them (no need to re-invoke the CLI)
          if (errors.length > 0 && errors.every(_core.is404)) {
            return errors.map(_ => _.message).join('\n');
          } // otherwise: intentional fall-through, returning void; let
          // kubectl CLI handle the errors for now

        } else {
          // success!
          const groups = [{
            names,
            namespace: yield (0, _options.getNamespace)(args),
            explainedKind
          }];
          return (0, _status.default)(args, groups, _states.FinalState.OfflineLike);
        }
      }
    }
  });
}