"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.evaluate = evaluate;
exports.toKuiTableForUpdateFromCustomColumns = toKuiTableForUpdateFromCustomColumns;
exports.toKuiTableFromCustomColumns = toKuiTableFromCustomColumns;
exports.default = void 0;

var _jsonpath = _interopRequireDefault(require("@kui-shell/jsonpath"));

var _core = require("@kui-shell/core");

var _trafficLight = _interopRequireDefault(require("../../../lib/model/traffic-light"));

var _options = require("../../kubectl/options");

var _resource = require("../../../lib/model/resource");

var _formatTable = require("../../../lib/view/formatTable");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Interpret a custom-columns spec-as-string
 *
 */
function parse(spec) {
  const match = spec.match(/custom-columns=(.+)/);

  if (!match) {
    throw new Error('Invalid custom column specification' + spec);
  }

  return match[1].split(/,/).map(column => {
    const idx = column.indexOf(':');

    if (idx >= 0) {
      const key = column.slice(0, idx);
      const query = column.slice(idx + 1);

      if (key && query) {
        return {
          key,
          query: _jsonpath.default.parse('$' + query) // the jsonpath npm needs a leading "$"

        };
      }
    }

    throw new Error('Invalid custom column: ' + column);
  }).filter(_ => _);
}
/**
 * Generate a table Row for the given resource, using the queries from
 * the given CustomColumns.
 *
 */


function evaluate(resource, args, drilldownCommand, kind, custo) {
  const attributes = custo.map(({
    key,
    query
  }) => {
    const value = _jsonpath.default.value(resource, query); // bad typing in @types/jsonpath


    return {
      key,
      value,
      tag: _formatTable.tagForKey[key] || _formatTable.tagsForKind[kind] && _formatTable.tagsForKind[kind][key],
      outerCSS: _formatTable.outerCSSForKey[key],
      css: [_formatTable.cssForKey[key], _formatTable.cssForValue[value], /Ready/i.test(key) ? (0, _formatTable.cssForReadyCount)(value) : '', /failed/i.test(value) ? _trafficLight.default.Red : ''].join(' ')
    };
  });
  return {
    key: attributes[0].key,
    rowKey: (0, _formatTable.rowKeyFor)(resource.metadata, kind),
    name: attributes[0].value,
    attributes: attributes.slice(1),
    onclick: (0, _options.withKubeconfigFrom)(args, `${drilldownCommand} get ${kind} ${(0, _core.encodeComponent)(resource.metadata.name)} -o yaml -n ${resource.metadata.namespace}`)
  };
}
/** See ./watch.ts; it will send row updates here for parsing */


function toKuiTableForUpdateFromCustomColumns(resource, args, drilldownCommand, kind, spec) {
  const custo = parse(spec);
  const header = {
    name: custo[0].key,
    attributes: custo.slice(1).map(_ => ({
      key: _.key,
      value: _.key
    }))
  };
  const body = [evaluate(resource, args, drilldownCommand, kind, custo)];
  return (0, _formatTable.computeDurations)({
    header,
    body
  });
}
/** See ./get.ts; it will send full table (as KubeItems) here for parsing */


function toKuiTableFromCustomColumns(list, args, drilldownCommand, kind, spec) {
  const custo = parse(spec);
  const header = {
    name: custo[0].key,
    attributes: custo.slice(1).map(_ => ({
      key: _.key,
      value: _.key
    }))
  };
  const body = (0, _resource.isKubeItems)(list) ? list.items.map(_ => evaluate(_, args, drilldownCommand, kind, custo)) : [evaluate(list, args, drilldownCommand, kind, custo)];
  return (0, _formatTable.computeDurations)({
    header,
    body,
    resourceVersion: list.metadata.resourceVersion
  });
}

var _default = toKuiTableFromCustomColumns;
exports.default = _default;