(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('prop-types'), require('react'), require('react-dom'), require('carbon-icons')) :
  typeof define === 'function' && define.amd ? define(['exports', 'prop-types', 'react', 'react-dom', 'carbon-icons'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CarbonComponentsReact = {}, global.PropTypes, global.React, global.ReactDOM));
}(this, (function (exports, PropTypes, React, ReactDOM) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var PropTypes__default = /*#__PURE__*/_interopDefaultLegacy(PropTypes);
  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
  var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);

  function ownKeys$2(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2$2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys$2(Object(source), true).forEach(function (key) {
          _defineProperty$2(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$2(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";

    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function (obj) {
        return typeof obj;
      };
    } else {
      _typeof = function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _defineProperty$2(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends$3() {
    _extends$3 = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends$3.apply(this, arguments);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf$1(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf$1(o, p) {
    _setPrototypeOf$1 = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf$1(o, p);
  }

  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct) return false;
    if (Reflect.construct.sham) return false;
    if (typeof Proxy === "function") return true;

    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
      return true;
    } catch (e) {
      return false;
    }
  }

  function _objectWithoutPropertiesLoose$3(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties$2(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose$3(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _assertThisInitialized$1(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized$1(self);
  }

  function _createSuper(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct();

    return function _createSuperInternal() {
      var Super = _getPrototypeOf(Derived),
          result;

      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf(this).constructor;

        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }

      return _possibleConstructorReturn(this, result);
    };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) return _arrayLikeToArray(arr);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _iterableToArray(iter) {
    if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
  }

  function _iterableToArrayLimit(arr, i) {
    var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]);

    if (_i == null) return;
    var _arr = [];
    var _n = true;
    var _d = false;

    var _s, _e;

    try {
      for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return _arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
  }

  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;

    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

    return arr2;
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }

  function _createForOfIteratorHelper(o, allowArrayLike) {
    var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];

    if (!it) {
      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it) o = it;
        var i = 0;

        var F = function () {};

        return {
          s: F,
          n: function () {
            if (i >= o.length) return {
              done: true
            };
            return {
              done: false,
              value: o[i++]
            };
          },
          e: function (e) {
            throw e;
          },
          f: F
        };
      }

      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    var normalCompletion = true,
        didErr = false,
        err;
    return {
      s: function () {
        it = it.call(o);
      },
      n: function () {
        var step = it.next();
        normalCompletion = step.done;
        return step;
      },
      e: function (e) {
        didErr = true;
        err = e;
      },
      f: function () {
        try {
          if (!normalCompletion && it.return != null) it.return();
        } finally {
          if (didErr) throw err;
        }
      }
    };
  }

  /**
   * Settings.
   * @exports CarbonComponents.settings
   * @type Object
   * @property {boolean} [disableAutoInit]
   *   Disables automatic instantiation of components.
   *   By default (`CarbonComponents.disableAutoInit` is `false`),
   *   carbon-components attempts to instantiate components automatically
   *   by searching for elements with `data-component-name` (e.g. `data-loading`) attribute
   *   or upon DOM events (e.g. clicking) on such elements.
   *   See each components' static `.init()` methods for details.
   * @property {string} [prefix=bx]
   *   Brand prefix. Should be in sync with `$prefix` Sass variable in carbon-components/src/globals/scss/_vars.scss.
   * // @todo given that the default value is so long, is it appropriate to put in the JSDoc?
   * @property {string} [selectorTabbable]
   *   A selector selecting tabbable/focusable nodes.
   *   By default selectorTabbable references links, areas, inputs, buttons, selects, textareas,
   *   iframes, objects, embeds, or elements explicitly using tabindex or contenteditable attributes
   *   as long as the element is not `disabled` or the `tabindex="-1"`.
   * @property {string} [selectorFocusable]
   *   CSS selector that selects major nodes that are click focusable
   *   This property is identical to selectorTabbable with the exception of
   *   the `:not([tabindex='-1'])` pseudo class
   */
  var settings = {
    prefix: 'bx',
    selectorTabbable: "\n    a[href], area[href], input:not([disabled]):not([tabindex='-1']),\n    button:not([disabled]):not([tabindex='-1']),select:not([disabled]):not([tabindex='-1']),\n    textarea:not([disabled]):not([tabindex='-1']),\n    iframe, object, embed, *[tabindex]:not([tabindex='-1']), *[contenteditable=true]\n  ",
    selectorFocusable: "\n    a[href], area[href], input:not([disabled]),\n    button:not([disabled]),select:not([disabled]),\n    textarea:not([disabled]),\n    iframe, object, embed, *[tabindex], *[contenteditable=true]\n  "
  };
  var settings_1 = settings;

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function getAugmentedNamespace(n) {
  	if (n.__esModule) return n;
  	var a = Object.defineProperty({}, '__esModule', {value: true});
  	Object.keys(n).forEach(function (k) {
  		var d = Object.getOwnPropertyDescriptor(n, k);
  		Object.defineProperty(a, k, d.get ? d : {
  			enumerable: true,
  			get: function () {
  				return n[k];
  			}
  		});
  	});
  	return a;
  }

  function createCommonjsModule(fn) {
    var module = { exports: {} };
  	return fn(module, module.exports), module.exports;
  }

  /** Used as the `TypeError` message for "Functions" methods. */

  var FUNC_ERROR_TEXT$1 = 'Expected a function';
  /** Used as references for various `Number` constants. */

  var NAN$1 = 0 / 0;
  /** `Object#toString` result references. */

  var symbolTag$2 = '[object Symbol]';
  /** Used to match leading and trailing whitespace. */

  var reTrim$1 = /^\s+|\s+$/g;
  /** Used to detect bad signed hexadecimal string values. */

  var reIsBadHex$1 = /^[-+]0x[0-9a-f]+$/i;
  /** Used to detect binary string values. */

  var reIsBinary$1 = /^0b[01]+$/i;
  /** Used to detect octal string values. */

  var reIsOctal$1 = /^0o[0-7]+$/i;
  /** Built-in method references without a dependency on `root`. */

  var freeParseInt$1 = parseInt;
  /** Detect free variable `global` from Node.js. */

  var freeGlobal$2 = _typeof(commonjsGlobal) == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
  /** Detect free variable `self`. */

  var freeSelf$2 = (typeof self === "undefined" ? "undefined" : _typeof(self)) == 'object' && self && self.Object === Object && self;
  /** Used as a reference to the global object. */

  var root$2 = freeGlobal$2 || freeSelf$2 || Function('return this')();
  /** Used for built-in method references. */

  var objectProto$2 = Object.prototype;
  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */

  var objectToString$2 = objectProto$2.toString;
  /* Built-in method references for those with the same name as other `lodash` methods. */

  var nativeMax$2 = Math.max,
      nativeMin$1 = Math.min;
  /**
   * Gets the timestamp of the number of milliseconds that have elapsed since
   * the Unix epoch (1 January 1970 00:00:00 UTC).
   *
   * @static
   * @memberOf _
   * @since 2.4.0
   * @category Date
   * @returns {number} Returns the timestamp.
   * @example
   *
   * _.defer(function(stamp) {
   *   console.log(_.now() - stamp);
   * }, _.now());
   * // => Logs the number of milliseconds it took for the deferred invocation.
   */

  var now$1 = function now() {
    return root$2.Date.now();
  };
  /**
   * Creates a debounced function that delays invoking `func` until after `wait`
   * milliseconds have elapsed since the last time the debounced function was
   * invoked. The debounced function comes with a `cancel` method to cancel
   * delayed `func` invocations and a `flush` method to immediately invoke them.
   * Provide `options` to indicate whether `func` should be invoked on the
   * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
   * with the last arguments provided to the debounced function. Subsequent
   * calls to the debounced function return the result of the last `func`
   * invocation.
   *
   * **Note:** If `leading` and `trailing` options are `true`, `func` is
   * invoked on the trailing edge of the timeout only if the debounced function
   * is invoked more than once during the `wait` timeout.
   *
   * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
   * until to the next tick, similar to `setTimeout` with a timeout of `0`.
   *
   * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
   * for details over the differences between `_.debounce` and `_.throttle`.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Function
   * @param {Function} func The function to debounce.
   * @param {number} [wait=0] The number of milliseconds to delay.
   * @param {Object} [options={}] The options object.
   * @param {boolean} [options.leading=false]
   *  Specify invoking on the leading edge of the timeout.
   * @param {number} [options.maxWait]
   *  The maximum time `func` is allowed to be delayed before it's invoked.
   * @param {boolean} [options.trailing=true]
   *  Specify invoking on the trailing edge of the timeout.
   * @returns {Function} Returns the new debounced function.
   * @example
   *
   * // Avoid costly calculations while the window size is in flux.
   * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
   *
   * // Invoke `sendMail` when clicked, debouncing subsequent calls.
   * jQuery(element).on('click', _.debounce(sendMail, 300, {
   *   'leading': true,
   *   'trailing': false
   * }));
   *
   * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
   * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
   * var source = new EventSource('/stream');
   * jQuery(source).on('message', debounced);
   *
   * // Cancel the trailing debounced invocation.
   * jQuery(window).on('popstate', debounced.cancel);
   */


  function debounce$3(func, wait, options) {
    var lastArgs,
        lastThis,
        maxWait,
        result,
        timerId,
        lastCallTime,
        lastInvokeTime = 0,
        leading = false,
        maxing = false,
        trailing = true;

    if (typeof func != 'function') {
      throw new TypeError(FUNC_ERROR_TEXT$1);
    }

    wait = toNumber$1(wait) || 0;

    if (isObject$2(options)) {
      leading = !!options.leading;
      maxing = 'maxWait' in options;
      maxWait = maxing ? nativeMax$2(toNumber$1(options.maxWait) || 0, wait) : maxWait;
      trailing = 'trailing' in options ? !!options.trailing : trailing;
    }

    function invokeFunc(time) {
      var args = lastArgs,
          thisArg = lastThis;
      lastArgs = lastThis = undefined;
      lastInvokeTime = time;
      result = func.apply(thisArg, args);
      return result;
    }

    function leadingEdge(time) {
      // Reset any `maxWait` timer.
      lastInvokeTime = time; // Start the timer for the trailing edge.

      timerId = setTimeout(timerExpired, wait); // Invoke the leading edge.

      return leading ? invokeFunc(time) : result;
    }

    function remainingWait(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime,
          result = wait - timeSinceLastCall;
      return maxing ? nativeMin$1(result, maxWait - timeSinceLastInvoke) : result;
    }

    function shouldInvoke(time) {
      var timeSinceLastCall = time - lastCallTime,
          timeSinceLastInvoke = time - lastInvokeTime; // Either this is the first call, activity has stopped and we're at the
      // trailing edge, the system time has gone backwards and we're treating
      // it as the trailing edge, or we've hit the `maxWait` limit.

      return lastCallTime === undefined || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }

    function timerExpired() {
      var time = now$1();

      if (shouldInvoke(time)) {
        return trailingEdge(time);
      } // Restart the timer.


      timerId = setTimeout(timerExpired, remainingWait(time));
    }

    function trailingEdge(time) {
      timerId = undefined; // Only invoke if we have `lastArgs` which means `func` has been
      // debounced at least once.

      if (trailing && lastArgs) {
        return invokeFunc(time);
      }

      lastArgs = lastThis = undefined;
      return result;
    }

    function cancel() {
      if (timerId !== undefined) {
        clearTimeout(timerId);
      }

      lastInvokeTime = 0;
      lastArgs = lastCallTime = lastThis = timerId = undefined;
    }

    function flush() {
      return timerId === undefined ? result : trailingEdge(now$1());
    }

    function debounced() {
      var time = now$1(),
          isInvoking = shouldInvoke(time);
      lastArgs = arguments;
      lastThis = this;
      lastCallTime = time;

      if (isInvoking) {
        if (timerId === undefined) {
          return leadingEdge(lastCallTime);
        }

        if (maxing) {
          // Handle invocations in a tight loop.
          timerId = setTimeout(timerExpired, wait);
          return invokeFunc(lastCallTime);
        }
      }

      if (timerId === undefined) {
        timerId = setTimeout(timerExpired, wait);
      }

      return result;
    }

    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
  }
  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */


  function isObject$2(value) {
    var type = _typeof(value);

    return !!value && (type == 'object' || type == 'function');
  }
  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */


  function isObjectLike$2(value) {
    return !!value && _typeof(value) == 'object';
  }
  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */


  function isSymbol$2(value) {
    return _typeof(value) == 'symbol' || isObjectLike$2(value) && objectToString$2.call(value) == symbolTag$2;
  }
  /**
   * Converts `value` to a number.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to process.
   * @returns {number} Returns the number.
   * @example
   *
   * _.toNumber(3.2);
   * // => 3.2
   *
   * _.toNumber(Number.MIN_VALUE);
   * // => 5e-324
   *
   * _.toNumber(Infinity);
   * // => Infinity
   *
   * _.toNumber('3.2');
   * // => 3.2
   */


  function toNumber$1(value) {
    if (typeof value == 'number') {
      return value;
    }

    if (isSymbol$2(value)) {
      return NAN$1;
    }

    if (isObject$2(value)) {
      var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
      value = isObject$2(other) ? other + '' : other;
    }

    if (typeof value != 'string') {
      return value === 0 ? value : +value;
    }

    value = value.replace(reTrim$1, '');
    var isBinary = reIsBinary$1.test(value);
    return isBinary || reIsOctal$1.test(value) ? freeParseInt$1(value.slice(2), isBinary ? 2 : 8) : reIsBadHex$1.test(value) ? NAN$1 : +value;
  }

  var lodash_debounce = debounce$3;

  var classnames = createCommonjsModule(function (module) {
    /* global define */
    (function () {

      var hasOwn = {}.hasOwnProperty;

      function classNames() {
        var classes = [];

        for (var i = 0; i < arguments.length; i++) {
          var arg = arguments[i];
          if (!arg) continue;

          var argType = _typeof(arg);

          if (argType === 'string' || argType === 'number') {
            classes.push(arg);
          } else if (Array.isArray(arg)) {
            if (arg.length) {
              var inner = classNames.apply(null, arg);

              if (inner) {
                classes.push(inner);
              }
            }
          } else if (argType === 'object') {
            if (arg.toString === Object.prototype.toString) {
              for (var key in arg) {
                if (hasOwn.call(arg, key) && arg[key]) {
                  classes.push(key);
                }
              }
            } else {
              classes.push(arg.toString());
            }
          }
        }

        return classes.join(' ');
      }

      if (module.exports) {
        classNames.default = classNames;
        module.exports = classNames;
      } else {
        window.classNames = classNames;
      }
    })();
  });

  var prefix$2G = settings_1.prefix;

  function Accordion(_ref) {
    var _cx;

    var align = _ref.align,
        children = _ref.children,
        customClassName = _ref.className,
        disabled = _ref.disabled,
        size = _ref.size,
        rest = _objectWithoutProperties$2(_ref, ["align", "children", "className", "disabled", "size"]);

    var className = classnames("".concat(prefix$2G, "--accordion"), customClassName, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2G, "--accordion--").concat(align), align), _defineProperty$2(_cx, "".concat(prefix$2G, "--accordion--").concat(size), size), _cx));
    return /*#__PURE__*/React__default['default'].createElement("ul", _extends$3({
      className: className
    }, rest), disabled ? React__default['default'].Children.toArray(children).map(function (child) {
      return /*#__PURE__*/React__default['default'].cloneElement(child, {
        disabled: disabled
      });
    }) : children);
  }

  Accordion.defaultProps = {
    align: 'end'
  };
  Accordion.propTypes = {
    /**
     * Specify the alignment of the accordion heading title and chevron.
     */
    align: PropTypes__default['default'].oneOf(['start', 'end']),

    /**
     * Pass in the children that will be rendered within the Accordion
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether an individual AccordionItem should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify the size of the Accordion. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
     * TODO V11: remove `xl` (replaced with lg)
     */
    size: PropTypes__default['default'].oneOf(['sm', 'md', 'lg', 'xl'])
  };

  function ownKeys$1(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2$1(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys$1(Object(source), true).forEach(function (key) {
          _defineProperty$1(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$1(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty$1(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _objectWithoutPropertiesLoose$2(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties$1(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose$2(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }
  /**
   * Copyright IBM Corp. 2018, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */


  var defaultAttributes = {
    // Reference:
    // https://github.com/IBM/carbon-components-react/issues/1392
    // https://github.com/PolymerElements/iron-iconset-svg/pull/47
    // `focusable` is a string attribute which is why we do not use a boolean here
    focusable: 'false',
    preserveAspectRatio: 'xMidYMid meet'
  };
  /**
   * Get supplementary HTML attributes for a given <svg> element based on existing
   * attributes.
   */

  function getAttributes() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        width = _ref.width,
        height = _ref.height,
        _ref$viewBox = _ref.viewBox,
        viewBox = _ref$viewBox === void 0 ? "0 0 ".concat(width, " ").concat(height) : _ref$viewBox,
        attributes = _objectWithoutProperties$1(_ref, ["width", "height", "viewBox"]);

    var tabindex = attributes.tabindex,
        rest = _objectWithoutProperties$1(attributes, ["tabindex"]);

    var iconAttributes = _objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, defaultAttributes), rest), {}, {
      width: width,
      height: height,
      viewBox: viewBox
    }); // TODO: attributes.title assumes that the consumer will implement <title> and
    // correctly set `aria-labelledby`.


    if (iconAttributes['aria-label'] || iconAttributes['aria-labelledby'] || iconAttributes.title) {
      iconAttributes.role = 'img'; // Reference:
      // https://allyjs.io/tutorials/focusing-in-svg.html

      if (tabindex !== undefined && tabindex !== null) {
        iconAttributes.focusable = 'true';
        iconAttributes.tabindex = tabindex;
      }
    } else {
      iconAttributes['aria-hidden'] = true;
    }

    return iconAttributes;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);

      if (enumerableOnly) {
        symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });
      }

      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends$2() {
    _extends$2 = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends$2.apply(this, arguments);
  }

  function _objectWithoutPropertiesLoose$1(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose$1(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  var Icon$1 = /*#__PURE__*/React__default['default'].forwardRef(function Icon(_ref, ref) {
    var className = _ref.className,
        children = _ref.children,
        tabIndex = _ref.tabIndex,
        rest = _objectWithoutProperties(_ref, ["className", "children", "tabIndex"]);

    var _getAttributes = getAttributes(_objectSpread2(_objectSpread2({}, rest), {}, {
      tabindex: tabIndex
    })),
        tabindex = _getAttributes.tabindex,
        props = _objectWithoutProperties(_getAttributes, ["tabindex"]);

    if (className) {
      props.className = className;
    }

    if (tabindex !== undefined && tabindex !== null) {
      props.tabIndex = tabindex;
    }

    if (ref) {
      props.ref = ref;
    }

    return /*#__PURE__*/React__default['default'].createElement('svg', props, children);
  });
  Icon$1.displayName = 'Icon';
  Icon$1.propTypes = {
    'aria-hidden': PropTypes__default['default'].string,
    'aria-label': PropTypes__default['default'].string,
    'aria-labelledby': PropTypes__default['default'].string,
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string,
    height: PropTypes__default['default'].oneOfType([PropTypes__default['default'].number, PropTypes__default['default'].string]),
    preserveAspectRatio: PropTypes__default['default'].string,
    tabIndex: PropTypes__default['default'].string,
    viewBox: PropTypes__default['default'].string,
    width: PropTypes__default['default'].oneOfType([PropTypes__default['default'].number, PropTypes__default['default'].string]),
    xmlns: PropTypes__default['default'].string
  };
  Icon$1.defaultProps = {
    xmlns: 'http://www.w3.org/2000/svg',
    preserveAspectRatio: 'xMidYMid meet'
  };

  var _path140, _path155, _path156;
  var Add16 = /*#__PURE__*/React__default['default'].forwardRef(function Add16(_ref92, ref) {
    var children = _ref92.children,
        rest = _objectWithoutProperties(_ref92, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path140 || (_path140 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M17 15L17 8 15 8 15 15 8 15 8 17 15 17 15 24 17 24 17 17 24 17 24 15z"
    })), children);
  });
  var AddFilled16 = /*#__PURE__*/React__default['default'].forwardRef(function AddFilled16(_ref100, ref) {
    var children = _ref100.children,
        rest = _objectWithoutProperties(_ref100, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path155 || (_path155 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M16,2A14.1725,14.1725,0,0,0,2,16,14.1725,14.1725,0,0,0,16,30,14.1725,14.1725,0,0,0,30,16,14.1725,14.1725,0,0,0,16,2Zm8,15H17v7H15V17H8V15h7V8h2v7h7Z"
    })), _path156 || (_path156 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M24 17L17 17 17 24 15 24 15 17 8 17 8 15 15 15 15 8 17 8 17 15 24 15 24 17z",
      "data-icon-path": "inner-path"
    })), children);
  });

  var _path135, _path159;
  var ArrowUp20 = /*#__PURE__*/React__default['default'].forwardRef(function ArrowUp20(_ref101, ref) {
    var children = _ref101.children,
        rest = _objectWithoutProperties(_ref101, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path135 || (_path135 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M16 4L6 14 7.41 15.41 15 7.83 15 28 17 28 17 7.83 24.59 15.41 26 14 16 4z"
    })), children);
  });
  var ArrowsVertical20 = /*#__PURE__*/React__default['default'].forwardRef(function ArrowsVertical20(_ref125, ref) {
    var children = _ref125.children,
        rest = _objectWithoutProperties(_ref125, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path159 || (_path159 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M27.6 20.6L24 24.2 24 4 22 4 22 24.2 18.4 20.6 17 22 23 28 29 22zM9 4L3 10 4.4 11.4 8 7.8 8 28 10 28 10 7.8 13.6 11.4 15 10z"
    })), children);
  });

  var _path460, _path532, _path537, _path542;
  var Calendar16 = /*#__PURE__*/React__default['default'].forwardRef(function Calendar16(_ref156, ref) {
    var children = _ref156.children,
        rest = _objectWithoutProperties(_ref156, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path460 || (_path460 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"
    })), children);
  });
  var CaretDown16 = /*#__PURE__*/React__default['default'].forwardRef(function CaretDown16(_ref200, ref) {
    var children = _ref200.children,
        rest = _objectWithoutProperties(_ref200, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path532 || (_path532 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M24 12L16 22 8 12z"
    })), children);
  });
  var CaretLeft16 = /*#__PURE__*/React__default['default'].forwardRef(function CaretLeft16(_ref205, ref) {
    var children = _ref205.children,
        rest = _objectWithoutProperties(_ref205, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path537 || (_path537 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M20 24L10 16 20 8z"
    })), children);
  });
  var CaretRight16 = /*#__PURE__*/React__default['default'].forwardRef(function CaretRight16(_ref210, ref) {
    var children = _ref210.children,
        rest = _objectWithoutProperties(_ref210, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path542 || (_path542 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M12 8L22 16 12 24z"
    })), children);
  });

  var _path76, _path91, _path92, _path125, _path130, _path131, _path132, _path133, _path164, _path165, _path196, _path197, _path202, _path210, _path211, _circle80, _path249, _path300, _path301;
  var Checkbox16 = /*#__PURE__*/React__default['default'].forwardRef(function Checkbox16(_ref64, ref) {
    var children = _ref64.children,
        rest = _objectWithoutProperties(_ref64, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path76 || (_path76 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"
    })), children);
  });
  var CheckboxCheckedFilled16 = /*#__PURE__*/React__default['default'].forwardRef(function CheckboxCheckedFilled16(_ref72, ref) {
    var children = _ref72.children,
        rest = _objectWithoutProperties(_ref72, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path91 || (_path91 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z"
    })), _path92 || (_path92 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M14,21.5,9,16.5427,10.5908,15,14,18.3456,21.4087,11l1.5918,1.5772Z",
      "data-icon-path": "inner-path"
    })), children);
  });
  var Checkmark16 = /*#__PURE__*/React__default['default'].forwardRef(function Checkmark16(_ref92, ref) {
    var children = _ref92.children,
        rest = _objectWithoutProperties(_ref92, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path125 || (_path125 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M13 24L4 15 5.414 13.586 13 21.171 26.586 7.586 28 9 13 24z"
    })), children);
  });
  var CheckmarkFilled20 = /*#__PURE__*/React__default['default'].forwardRef(function CheckmarkFilled20(_ref95, ref) {
    var children = _ref95.children,
        rest = _objectWithoutProperties(_ref95, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 20 20",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path130 || (_path130 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M10,1c-4.9,0-9,4.1-9,9s4.1,9,9,9s9-4,9-9S15,1,10,1z M8.7,13.5l-3.2-3.2l1-1l2.2,2.2l4.8-4.8l1,1L8.7,13.5z"
    })), _path131 || (_path131 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M8.7,13.5l-3.2-3.2l1-1l2.2,2.2l4.8-4.8l1,1L8.7,13.5z",
      "data-icon-path": "inner-path",
      opacity: "0"
    })), children);
  });
  var CheckmarkFilled16 = /*#__PURE__*/React__default['default'].forwardRef(function CheckmarkFilled16(_ref96, ref) {
    var children = _ref96.children,
        rest = _objectWithoutProperties(_ref96, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path132 || (_path132 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8,1C4.1,1,1,4.1,1,8c0,3.9,3.1,7,7,7s7-3.1,7-7C15,4.1,11.9,1,8,1z M7,11L4.3,8.3l0.9-0.8L7,9.3l4-3.9l0.9,0.8L7,11z"
    })), _path133 || (_path133 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M7,11L4.3,8.3l0.9-0.8L7,9.3l4-3.9l0.9,0.8L7,11z",
      "data-icon-path": "inner-path",
      opacity: "0"
    })), children);
  });
  var CheckmarkOutline16 = /*#__PURE__*/React__default['default'].forwardRef(function CheckmarkOutline16(_ref108, ref) {
    var children = _ref108.children,
        rest = _objectWithoutProperties(_ref108, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path164 || (_path164 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M14 21.414L9 16.413 10.413 15 14 18.586 21.585 11 23 12.415 14 21.414z"
    })), _path165 || (_path165 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"
    })), children);
  });
  var ChevronDown20 = /*#__PURE__*/React__default['default'].forwardRef(function ChevronDown20(_ref127, ref) {
    var children = _ref127.children,
        rest = _objectWithoutProperties(_ref127, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path196 || (_path196 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M16 22L6 12 7.4 10.6 16 19.2 24.6 10.6 26 12z"
    })), children);
  });
  var ChevronDown16 = /*#__PURE__*/React__default['default'].forwardRef(function ChevronDown16(_ref128, ref) {
    var children = _ref128.children,
        rest = _objectWithoutProperties(_ref128, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path197 || (_path197 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8 11L3 6 3.7 5.3 8 9.6 12.3 5.3 13 6z"
    })), children);
  });
  var ChevronLeft16 = /*#__PURE__*/React__default['default'].forwardRef(function ChevronLeft16(_ref133, ref) {
    var children = _ref133.children,
        rest = _objectWithoutProperties(_ref133, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path202 || (_path202 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M5 8L10 3 10.7 3.7 6.4 8 10.7 12.3 10 13z"
    })), children);
  });
  var ChevronRight20 = /*#__PURE__*/React__default['default'].forwardRef(function ChevronRight20(_ref141, ref) {
    var children = _ref141.children,
        rest = _objectWithoutProperties(_ref141, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path210 || (_path210 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M22 16L12 26 10.6 24.6 19.2 16 10.6 7.4 12 6z"
    })), children);
  });
  var ChevronRight16 = /*#__PURE__*/React__default['default'].forwardRef(function ChevronRight16(_ref142, ref) {
    var children = _ref142.children,
        rest = _objectWithoutProperties(_ref142, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path211 || (_path211 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M11 8L6 13 5.3 12.3 9.6 8 5.3 3.7 6 3z"
    })), children);
  });
  var CircleFilled16 = /*#__PURE__*/React__default['default'].forwardRef(function CircleFilled16(_ref176, ref) {
    var children = _ref176.children,
        rest = _objectWithoutProperties(_ref176, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _circle80 || (_circle80 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "16",
      cy: "16",
      r: "10"
    })), _path249 || (_path249 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"
    })), children);
  });
  var Close20 = /*#__PURE__*/React__default['default'].forwardRef(function Close20(_ref207, ref) {
    var children = _ref207.children,
        rest = _objectWithoutProperties(_ref207, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path300 || (_path300 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M24 9.4L22.6 8 16 14.6 9.4 8 8 9.4 14.6 16 8 22.6 9.4 24 16 17.4 22.6 24 24 22.6 17.4 16 24 9.4z"
    })), children);
  });
  var Close16 = /*#__PURE__*/React__default['default'].forwardRef(function Close16(_ref208, ref) {
    var children = _ref208.children,
        rest = _objectWithoutProperties(_ref208, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path301 || (_path301 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M24 9.4L22.6 8 16 14.6 9.4 8 8 9.4 14.6 16 8 22.6 9.4 24 16 17.4 22.6 24 24 22.6 17.4 16 24 9.4z"
    })), children);
  });

  var _path273$1, _path274$1;
  var Copy16 = /*#__PURE__*/React__default['default'].forwardRef(function Copy16(_ref182, ref) {
    var children = _ref182.children,
        rest = _objectWithoutProperties(_ref182, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path273$1 || (_path273$1 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M28,10V28H10V10H28m0-2H10a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2Z"
    })), _path274$1 || (_path274$1 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M4,18H2V4A2,2,0,0,1,4,2H18V4H4Z"
    })), children);
  });

  var _path304, _path361, _path362, _path363$1, _path364$1;
  var EditOff16 = /*#__PURE__*/React__default['default'].forwardRef(function EditOff16(_ref188, ref) {
    var children = _ref188.children,
        rest = _objectWithoutProperties(_ref188, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path304 || (_path304 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M30 28.6L3.4 2 2 3.4l10.1 10.1L4 21.6V28h6.4l8.1-8.1L28.6 30 30 28.6zM9.6 26H6v-3.6l7.5-7.5 3.6 3.6L9.6 26zM29.4 6.2L29.4 6.2l-3.6-3.6c-.8-.8-2-.8-2.8 0l0 0 0 0-8 8 1.4 1.4L20 8.4l3.6 3.6L20 15.6l1.4 1.4 8-8C30.2 8.2 30.2 7 29.4 6.2L29.4 6.2zM25 10.6L21.4 7l3-3L28 7.6 25 10.6z"
    })), children);
  });
  var ErrorFilled20 = /*#__PURE__*/React__default['default'].forwardRef(function ErrorFilled20(_ref231, ref) {
    var children = _ref231.children,
        rest = _objectWithoutProperties(_ref231, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 20 20",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path361 || (_path361 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M10,1c-5,0-9,4-9,9s4,9,9,9s9-4,9-9S15,1,10,1z M13.5,14.5l-8-8l1-1l8,8L13.5,14.5z"
    })), _path362 || (_path362 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M13.5,14.5l-8-8l1-1l8,8L13.5,14.5z",
      "data-icon-path": "inner-path",
      opacity: "0"
    })), children);
  });
  var ErrorFilled16 = /*#__PURE__*/React__default['default'].forwardRef(function ErrorFilled16(_ref232, ref) {
    var children = _ref232.children,
        rest = _objectWithoutProperties(_ref232, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path363$1 || (_path363$1 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M10.7,11.5L4.5,5.3l0.8-0.8l6.2,6.2L10.7,11.5z"
    })), _path364$1 || (_path364$1 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M10.7,11.5L4.5,5.3l0.8-0.8l6.2,6.2L10.7,11.5z",
      "data-icon-path": "inner-path",
      opacity: "0"
    })), children);
  });

  var _path190;
  var Filter16 = /*#__PURE__*/React__default['default'].forwardRef(function Filter16(_ref134, ref) {
    var children = _ref134.children,
        rest = _objectWithoutProperties(_ref134, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path190 || (_path190 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M18,28H14a2,2,0,0,1-2-2V18.41L4.59,11A2,2,0,0,1,4,9.59V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2V9.59A2,2,0,0,1,27.41,11L20,18.41V26A2,2,0,0,1,18,28ZM6,6V9.59l8,8V26h4V17.59l8-8V6Z"
    })), children);
  });

  var _path292;
  var Grid16 = /*#__PURE__*/React__default['default'].forwardRef(function Grid16(_ref188, ref) {
    var children = _ref188.children,
        rest = _objectWithoutProperties(_ref188, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path292 || (_path292 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M12 4H6A2 2 0 004 6v6a2 2 0 002 2h6a2 2 0 002-2V6A2 2 0 0012 4zm0 8H6V6h6zM26 4H20a2 2 0 00-2 2v6a2 2 0 002 2h6a2 2 0 002-2V6A2 2 0 0026 4zm0 8H20V6h6zM12 18H6a2 2 0 00-2 2v6a2 2 0 002 2h6a2 2 0 002-2V20A2 2 0 0012 18zm0 8H6V20h6zM26 18H20a2 2 0 00-2 2v6a2 2 0 002 2h6a2 2 0 002-2V20A2 2 0 0026 18zm0 8H20V20h6z"
    })), children);
  });

  var _path289, _path290, _path295, _path296, _path311, _path312;
  var Information16 = /*#__PURE__*/React__default['default'].forwardRef(function Information16(_ref194, ref) {
    var children = _ref194.children,
        rest = _objectWithoutProperties(_ref194, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path289 || (_path289 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8.5 11L8.5 6.5 6.5 6.5 6.5 7.5 7.5 7.5 7.5 11 6 11 6 12 10 12 10 11zM8 3.5c-.4 0-.8.3-.8.8S7.6 5 8 5c.4 0 .8-.3.8-.8S8.4 3.5 8 3.5z"
    })), _path290 || (_path290 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8,15c-3.9,0-7-3.1-7-7s3.1-7,7-7s7,3.1,7,7S11.9,15,8,15z M8,2C4.7,2,2,4.7,2,8s2.7,6,6,6s6-2.7,6-6S11.3,2,8,2z"
    })), children);
  });
  var InformationFilled20 = /*#__PURE__*/React__default['default'].forwardRef(function InformationFilled20(_ref197, ref) {
    var children = _ref197.children,
        rest = _objectWithoutProperties(_ref197, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path295 || (_path295 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M16,8a1.5,1.5,0,1,1-1.5,1.5A1.5,1.5,0,0,1,16,8Zm4,13.875H17.125v-8H13v2.25h1.875v5.75H12v2.25h8Z"
    })), _path296 || (_path296 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,6a1.5,1.5,0,1,1-1.5,1.5A1.5,1.5,0,0,1,16,8Zm4,16.125H12v-2.25h2.875v-5.75H13v-2.25h4.125v8H20Z"
    })), children);
  });
  var InformationSquareFilled20 = /*#__PURE__*/React__default['default'].forwardRef(function InformationSquareFilled20(_ref205, ref) {
    var children = _ref205.children,
        rest = _objectWithoutProperties(_ref205, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path311 || (_path311 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M16,8a1.5,1.5,0,1,1-1.5,1.5A1.5,1.5,0,0,1,16,8Zm4,13.875H17.125v-8H13v2.25h1.875v5.75H12v2.25h8Z"
    })), _path312 || (_path312 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM16,8a1.5,1.5,0,1,1-1.5,1.5A1.5,1.5,0,0,1,16,8Zm4,16.125H12v-2.25h2.875v-5.75H13v-2.25h4.125v8H20Z"
    })), children);
  });

  var _circle7, _circle8, _path22;
  var ListBulleted16 = /*#__PURE__*/React__default['default'].forwardRef(function ListBulleted16(_ref18, ref) {
    var children = _ref18.children,
        rest = _objectWithoutProperties(_ref18, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _circle7 || (_circle7 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "3.5",
      cy: "4.5",
      r: "1.5"
    })), _circle8 || (_circle8 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "3.5",
      cy: "11.5",
      r: "1.5"
    })), _path22 || (_path22 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8 11H15V12H8zM8 4H15V5H8z"
    })), children);
  });

  var _path119;
  var Menu20 = /*#__PURE__*/React__default['default'].forwardRef(function Menu20(_ref63, ref) {
    var children = _ref63.children,
        rest = _objectWithoutProperties(_ref63, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 20 20",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path119 || (_path119 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M2 14.8H18V16H2zM2 11.2H18V12.399999999999999H2zM2 7.6H18V8.799999999999999H2zM2 4H18V5.2H2z"
    })), children);
  });

  var _circle10, _circle11, _circle12, _circle22, _circle23, _circle24;
  var OverflowMenuHorizontal16 = /*#__PURE__*/React__default['default'].forwardRef(function OverflowMenuHorizontal16(_ref68, ref) {
    var children = _ref68.children,
        rest = _objectWithoutProperties(_ref68, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _circle10 || (_circle10 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "8",
      cy: "16",
      r: "2"
    })), _circle11 || (_circle11 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "16",
      cy: "16",
      r: "2"
    })), _circle12 || (_circle12 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "24",
      cy: "16",
      r: "2"
    })), children);
  });
  var OverflowMenuVertical16 = /*#__PURE__*/React__default['default'].forwardRef(function OverflowMenuVertical16(_ref72, ref) {
    var children = _ref72.children,
        rest = _objectWithoutProperties(_ref72, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _circle22 || (_circle22 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "16",
      cy: "8",
      r: "2"
    })), _circle23 || (_circle23 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "16",
      cy: "16",
      r: "2"
    })), _circle24 || (_circle24 = /*#__PURE__*/React__default['default'].createElement("circle", {
      cx: "16",
      cy: "24",
      r: "2"
    })), children);
  });

  var _path4;
  var RadioButton16 = /*#__PURE__*/React__default['default'].forwardRef(function RadioButton16(_ref4, ref) {
    var children = _ref4.children,
        rest = _objectWithoutProperties(_ref4, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path4 || (_path4 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"
    })), children);
  });

  var _path218, _path273, _path274;
  var Search16 = /*#__PURE__*/React__default['default'].forwardRef(function Search16(_ref154, ref) {
    var children = _ref154.children,
        rest = _objectWithoutProperties(_ref154, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path218 || (_path218 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M15,14.3L10.7,10c1.9-2.3,1.6-5.8-0.7-7.7S4.2,0.7,2.3,3S0.7,8.8,3,10.7c2,1.7,5,1.7,7,0l4.3,4.3L15,14.3z M2,6.5\tC2,4,4,2,6.5,2S11,4,11,6.5S9,11,6.5,11S2,9,2,6.5z"
    })), children);
  });
  var Settings16 = /*#__PURE__*/React__default['default'].forwardRef(function Settings16(_ref202, ref) {
    var children = _ref202.children,
        rest = _objectWithoutProperties(_ref202, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path273 || (_path273 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M13.5,8.4c0-0.1,0-0.3,0-0.4c0-0.1,0-0.3,0-0.4l1-0.8c0.4-0.3,0.4-0.9,0.2-1.3l-1.2-2C13.3,3.2,13,3,12.6,3\tc-0.1,0-0.2,0-0.3,0.1l-1.2,0.4c-0.2-0.1-0.4-0.3-0.7-0.4l-0.3-1.3C10.1,1.3,9.7,1,9.2,1H6.8c-0.5,0-0.9,0.3-1,0.8L5.6,3.1\tC5.3,3.2,5.1,3.3,4.9,3.4L3.7,3C3.6,3,3.5,3,3.4,3C3,3,2.7,3.2,2.5,3.5l-1.2,2C1.1,5.9,1.2,6.4,1.6,6.8l0.9,0.9c0,0.1,0,0.3,0,0.4\tc0,0.1,0,0.3,0,0.4L1.6,9.2c-0.4,0.3-0.5,0.9-0.2,1.3l1.2,2C2.7,12.8,3,13,3.4,13c0.1,0,0.2,0,0.3-0.1l1.2-0.4\tc0.2,0.1,0.4,0.3,0.7,0.4l0.3,1.3c0.1,0.5,0.5,0.8,1,0.8h2.4c0.5,0,0.9-0.3,1-0.8l0.3-1.3c0.2-0.1,0.4-0.2,0.7-0.4l1.2,0.4\tc0.1,0,0.2,0.1,0.3,0.1c0.4,0,0.7-0.2,0.9-0.5l1.1-2c0.2-0.4,0.2-0.9-0.2-1.3L13.5,8.4z M12.6,12l-1.7-0.6c-0.4,0.3-0.9,0.6-1.4,0.8\tL9.2,14H6.8l-0.4-1.8c-0.5-0.2-0.9-0.5-1.4-0.8L3.4,12l-1.2-2l1.4-1.2c-0.1-0.5-0.1-1.1,0-1.6L2.2,6l1.2-2l1.7,0.6\tC5.5,4.2,6,4,6.5,3.8L6.8,2h2.4l0.4,1.8c0.5,0.2,0.9,0.5,1.4,0.8L12.6,4l1.2,2l-1.4,1.2c0.1,0.5,0.1,1.1,0,1.6l1.4,1.2L12.6,12z"
    })), _path274 || (_path274 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8,11c-1.7,0-3-1.3-3-3s1.3-3,3-3s3,1.3,3,3C11,9.6,9.7,11,8,11C8,11,8,11,8,11z M8,6C6.9,6,6,6.8,6,7.9C6,7.9,6,8,6,8\tc0,1.1,0.8,2,1.9,2c0,0,0.1,0,0.1,0c1.1,0,2-0.8,2-1.9c0,0,0-0.1,0-0.1C10,6.9,9.2,6,8,6C8.1,6,8,6,8,6z"
    })), children);
  });

  var _path146;
  var Subtract16 = /*#__PURE__*/React__default['default'].forwardRef(function Subtract16(_ref114, ref) {
    var children = _ref114.children,
        rest = _objectWithoutProperties(_ref114, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path146 || (_path146 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8 15H24V17H8z"
    })), children);
  });

  var _path187, _path188, _path207, _path208, _path363, _path364, _path377, _path378, _path379, _path380, _path401, _path402, _path403, _path404;
  var View16 = /*#__PURE__*/React__default['default'].forwardRef(function View16(_ref116, ref) {
    var children = _ref116.children,
        rest = _objectWithoutProperties(_ref116, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path187 || (_path187 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M15.5,7.8C14.3,4.7,11.3,2.6,8,2.5C4.7,2.6,1.7,4.7,0.5,7.8c0,0.1,0,0.2,0,0.3c1.2,3.1,4.1,5.2,7.5,5.3\tc3.3-0.1,6.3-2.2,7.5-5.3C15.5,8.1,15.5,7.9,15.5,7.8z M8,12.5c-2.7,0-5.4-2-6.5-4.5c1-2.5,3.8-4.5,6.5-4.5s5.4,2,6.5,4.5\tC13.4,10.5,10.6,12.5,8,12.5z"
    })), _path188 || (_path188 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8,5C6.3,5,5,6.3,5,8s1.3,3,3,3s3-1.3,3-3S9.7,5,8,5z M8,10c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S9.1,10,8,10z"
    })), children);
  });
  var ViewOff16 = /*#__PURE__*/React__default['default'].forwardRef(function ViewOff16(_ref132, ref) {
    var children = _ref132.children,
        rest = _objectWithoutProperties(_ref132, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path207 || (_path207 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M2.6,11.3l0.7-0.7C2.6,9.8,1.9,9,1.5,8c1-2.5,3.8-4.5,6.5-4.5c0.7,0,1.4,0.1,2,0.4l0.8-0.8C9.9,2.7,9,2.5,8,2.5\tC4.7,2.6,1.7,4.7,0.5,7.8c0,0.1,0,0.2,0,0.3C1,9.3,1.7,10.4,2.6,11.3z"
    })), _path208 || (_path208 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M6 7.9c.1-1 .9-1.8 1.8-1.8l.9-.9C7.2 4.7 5.5 5.6 5.1 7.2 5 7.7 5 8.3 5.1 8.8L6 7.9zM15.5 7.8c-.6-1.5-1.6-2.8-2.9-3.7L15 1.7 14.3 1 1 14.3 1.7 15l2.6-2.6c1.1.7 2.4 1 3.7 1.1 3.3-.1 6.3-2.2 7.5-5.3C15.5 8.1 15.5 7.9 15.5 7.8zM10 8c0 1.1-.9 2-2 2-.3 0-.7-.1-1-.3L9.7 7C9.9 7.3 10 7.6 10 8zM8 12.5c-1 0-2.1-.3-3-.8l1.3-1.3c1.4.9 3.2.6 4.2-.8.7-1 .7-2.4 0-3.4l1.4-1.4c1.1.8 2 1.9 2.6 3.2C13.4 10.5 10.6 12.5 8 12.5z"
    })), children);
  });
  var Warning16 = /*#__PURE__*/React__default['default'].forwardRef(function Warning16(_ref228, ref) {
    var children = _ref228.children,
        rest = _objectWithoutProperties(_ref228, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path363 || (_path363 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M8,14c-3.3,0-6-2.7-6-6s2.7-6,6-6s6,2.7,6,6S11.3,14,8,14z"
    })), _path364 || (_path364 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M7.5 4H8.5V9H7.5zM8 10.2c-.4 0-.8.3-.8.8s.3.8.8.8c.4 0 .8-.3.8-.8S8.4 10.2 8 10.2z"
    })), children);
  });
  var WarningAltFilled20 = /*#__PURE__*/React__default['default'].forwardRef(function WarningAltFilled20(_ref235, ref) {
    var children = _ref235.children,
        rest = _objectWithoutProperties(_ref235, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path377 || (_path377 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M14.875,11h2.25V21h-2.25ZM16,27a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,16,27Z"
    })), _path378 || (_path378 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M29.8872,28.5386l-13-25a1,1,0,0,0-1.7744,0l-13,25A1,1,0,0,0,3,30H29a1,1,0,0,0,.8872-1.4614ZM14.875,11h2.25V21h-2.25ZM16,27a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,16,27Z"
    })), children);
  });
  var WarningAltFilled16 = /*#__PURE__*/React__default['default'].forwardRef(function WarningAltFilled16(_ref236, ref) {
    var children = _ref236.children,
        rest = _objectWithoutProperties(_ref236, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 32 32",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path379 || (_path379 = /*#__PURE__*/React__default['default'].createElement("path", {
      fill: "none",
      d: "M14.875,11h2.25V21h-2.25ZM16,27a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,16,27Z"
    })), _path380 || (_path380 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M29.8872,28.5386l-13-25a1,1,0,0,0-1.7744,0l-13,25A1,1,0,0,0,3,30H29a1,1,0,0,0,.8872-1.4614ZM14.875,11h2.25V21h-2.25ZM16,27a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,16,27Z"
    })), children);
  });
  var WarningFilled20 = /*#__PURE__*/React__default['default'].forwardRef(function WarningFilled20(_ref247, ref) {
    var children = _ref247.children,
        rest = _objectWithoutProperties(_ref247, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 20,
      height: 20,
      viewBox: "0 0 20 20",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path401 || (_path401 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M10,1c-5,0-9,4-9,9s4,9,9,9s9-4,9-9S15,1,10,1z M9.2,5h1.5v7H9.2V5z M10,16c-0.6,0-1-0.4-1-1s0.4-1,1-1\ts1,0.4,1,1S10.6,16,10,16z"
    })), _path402 || (_path402 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M9.2,5h1.5v7H9.2V5z M10,16c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S10.6,16,10,16z",
      "data-icon-path": "inner-path",
      opacity: "0"
    })), children);
  });
  var WarningFilled16 = /*#__PURE__*/React__default['default'].forwardRef(function WarningFilled16(_ref248, ref) {
    var children = _ref248.children,
        rest = _objectWithoutProperties(_ref248, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(Icon$1, _extends$2({
      width: 16,
      height: 16,
      viewBox: "0 0 16 16",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      ref: ref
    }, rest), _path403 || (_path403 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M8,1C4.2,1,1,4.2,1,8s3.2,7,7,7s7-3.1,7-7S11.9,1,8,1z M7.5,4h1v5h-1C7.5,9,7.5,4,7.5,4z M8,12.2\tc-0.4,0-0.8-0.4-0.8-0.8s0.3-0.8,0.8-0.8c0.4,0,0.8,0.4,0.8,0.8S8.4,12.2,8,12.2z"
    })), _path404 || (_path404 = /*#__PURE__*/React__default['default'].createElement("path", {
      d: "M7.5,4h1v5h-1C7.5,9,7.5,4,7.5,4z M8,12.2c-0.4,0-0.8-0.4-0.8-0.8s0.3-0.8,0.8-0.8\tc0.4,0,0.8,0.4,0.8,0.8S8.4,12.2,8,12.2z",
      "data-icon-path": "inner-path",
      opacity: "0"
    })), children);
  });

  var Enter = {
    key: 'Enter',
    which: 13,
    keyCode: 13
  };
  var Escape = {
    key: ['Escape', // IE11 Escape
    'Esc'],
    which: 27,
    keyCode: 27
  };
  var Space = {
    key: ' ',
    which: 32,
    keyCode: 32
  };
  var End = {
    key: 'End',
    which: 35,
    keyCode: 35
  };
  var Home = {
    key: 'Home',
    which: 36,
    keyCode: 36
  };
  var ArrowLeft = {
    key: 'ArrowLeft',
    which: 37,
    keyCode: 37
  };
  var ArrowUp = {
    key: 'ArrowUp',
    which: 38,
    keyCode: 38
  };
  var ArrowRight = {
    key: 'ArrowRight',
    which: 39,
    keyCode: 39
  };
  var ArrowDown = {
    key: 'ArrowDown',
    which: 40,
    keyCode: 40
  };
  var Delete = {
    key: 'Delete',
    which: 8 ,
    keyCode: 8 
  };

  /**
   * @typedef Key
   * @property key {Array<string>|string}
   * @property which {number}
   * @property keyCode {number}
   */

  /**
   * Check to see if at least one key code matches the key code of the
   * given event.
   *
   * @example
   * import * as keys from '../keys';
   * import { matches } from '../match';
   *
   * function handleOnKeyDown(event) {
   *   if (matches(event, [keys.Enter, keys.Space]) {
   *     // ...
   *   }
   * }
   *
   * @param {Event} event
   * @param {Array<Key>} keysToMatch
   * @returns {boolean}
   */
  function matches(event, keysToMatch) {
    for (var i = 0; i < keysToMatch.length; i++) {
      if (match(event, keysToMatch[i])) {
        return true;
      }
    }

    return false;
  }
  /**
   * Check to see if the given key matches the corresponding keyboard event. Also
   * supports passing in the value directly if you can't used the given event.
   *
   * @example
   * import * as keys from '../keys';
   * import { matches } from '../match';
   *
   * function handleOnKeyDown(event) {
   *   if (match(event, keys.Enter) {
   *     // ...
   *   }
   * }
   *
   * @param {Event|number|string} eventOrCode
   * @param {Key} key
   * @returns {boolean}
   */

  function match(eventOrCode) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        key = _ref.key,
        which = _ref.which,
        keyCode = _ref.keyCode;

    if (typeof eventOrCode === 'string') {
      return eventOrCode === key;
    }

    if (typeof eventOrCode === 'number') {
      return eventOrCode === which || eventOrCode === keyCode;
    }

    if (eventOrCode.key && Array.isArray(key)) {
      return key.indexOf(eventOrCode.key) !== -1;
    }

    return eventOrCode.key === key || eventOrCode.which === which || eventOrCode.keyCode === keyCode;
  }

  /**
   * Various utilities to help with a11y work
   */

  /**
   * A "ring buffer" function that takes an array and depending on an ArrowRight
   * or ArrowLeft key input loops from last index to first or first index to last.
   *
   * @param {string} key - the left or right arrow keys
   * @param {number} index - the current index in a given array
   * @param {number} arrayLength - the total length of the array
   *
   * @example
   * 	getNextIndex(keyCodes.RIGHT, 0, 4)
   */

  var getNextIndex = function getNextIndex(key, index, arrayLength) {
    if (match(key, ArrowRight)) {
      return (index + 1) % arrayLength;
    }

    if (match(key, ArrowLeft)) {
      return (index + arrayLength - 1) % arrayLength;
    }
  };
  /**
   * A flag `node.compareDocumentPosition(target)` returns,
   * that indicates `target` is located earlier than `node` in the document or `target` contains `node`.
   */

  var DOCUMENT_POSITION_BROAD_PRECEDING = // Checks `typeof Node` for `react-docgen`
  typeof Node !== 'undefined' && Node.DOCUMENT_POSITION_PRECEDING | Node.DOCUMENT_POSITION_CONTAINS;
  /**
   * A flag `node.compareDocumentPosition(target)` returns,
   * that indicates `target` is located later than `node` in the document or `node` contains `target`.
   */

  var DOCUMENT_POSITION_BROAD_FOLLOWING = // Checks `typeof Node` for `react-docgen`
  typeof Node !== 'undefined' && Node.DOCUMENT_POSITION_FOLLOWING | Node.DOCUMENT_POSITION_CONTAINED_BY;
  /**
   * CSS selector that selects major nodes that are sequential-focusable.
   */

  var selectorTabbable = "\n  a[href], area[href], input:not([disabled]):not([tabindex='-1']),\n  button:not([disabled]):not([tabindex='-1']),select:not([disabled]):not([tabindex='-1']),\n  textarea:not([disabled]):not([tabindex='-1']),\n  iframe, object, embed, *[tabindex]:not([tabindex='-1']):not([disabled]), *[contenteditable=true]\n";
  /**
   * CSS selector that selects major nodes that are click focusable
   */

  var selectorFocusable = "\n  a[href], area[href], input:not([disabled]),\n  button:not([disabled]),select:not([disabled]),\n  textarea:not([disabled]),\n  iframe, object, embed, *[tabindex]:not([disabled]), *[contenteditable=true]\n";

  /**
   * Generic utility to initialize a method that will return a unique instance id
   * for a component.
   */
  function setupGetInstanceId$1() {
    var instanceId = 0;
    return function getInstanceId() {
      return ++instanceId;
    };
  }

  /**
   * Indicate whether current execution environment can access the DOM.
   *
   * @see https://github.com/facebook/fbjs/blob/4d1751311d3f67af2dcce2e40df8512a23c7b9c6/packages/fbjs/src/core/ExecutionEnvironment.js#L12
   */
  var canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);

  var getId = setupGetInstanceId$1();
  var useIsomorphicLayoutEffect = canUseDOM ? React.useLayoutEffect : React.useEffect;
  var serverHandoffCompleted = false;
  /**
   * Generate a unique ID with an optional prefix prepended to it
   * @param {string} [prefix]
   * @returns {string}
   */

  function useId() {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';

    var _useState = React.useState(function () {
      if (serverHandoffCompleted) {
        return "".concat(prefix, "-").concat(getId());
      }

      return null;
    }),
        _useState2 = _slicedToArray(_useState, 2),
        id = _useState2[0],
        setId = _useState2[1];

    useIsomorphicLayoutEffect(function () {
      if (id === null) {
        setId("".concat(prefix, "-").concat(getId()));
      }
    }, [getId]);
    React.useEffect(function () {
      if (serverHandoffCompleted === false) {
        serverHandoffCompleted = true;
      }
    }, []);
    return id;
  }

  var warning = function warning(condition, format) {
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }

    if (format === undefined) {
      throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'format argument');
    }

    if (!condition) {
      var index = 0;
      var message = format.replace(/%s/g, function () {
        return args[index++];
      });
      console.warn('Warning: ' + message);
    }
  } ;

  var didWarnAboutDeprecation$6 = {};
  function deprecate(propType, message) {
    function checker(props, propName, componentName) {
      if (props[propName] === undefined) {
        return;
      }

      if (!didWarnAboutDeprecation$6[componentName] || !didWarnAboutDeprecation$6[componentName][propName]) {
        didWarnAboutDeprecation$6[componentName] = _objectSpread2$2(_objectSpread2$2({}, didWarnAboutDeprecation$6[componentName]), {}, _defineProperty$2({}, propName, true));
        warning(false, message || "The prop `".concat(propName, "` has been deprecated for the ") + "".concat(componentName, " component. It will be removed in the next major ") + "release") ;
      }

      for (var _len = arguments.length, rest = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
        rest[_key - 3] = arguments[_key];
      }

      return propType.apply(void 0, [props, propName, componentName].concat(rest));
    }

    return checker;
  }

  var prefix$2F = settings_1.prefix;

  var defaultRenderExpando = function defaultRenderExpando(props) {
    return /*#__PURE__*/React__default['default'].createElement("button", _extends$3({
      type: "button"
    }, props));
  };

  function AccordionItem(_ref) {
    var _cx;

    var children = _ref.children,
        customClassName = _ref.className;
        _ref.iconDescription;
        var _ref$open = _ref.open,
        open = _ref$open === void 0 ? false : _ref$open,
        onHeadingClick = _ref.onHeadingClick,
        _ref$renderExpando = _ref.renderExpando,
        Expando = _ref$renderExpando === void 0 ? defaultRenderExpando : _ref$renderExpando,
        _ref$title = _ref.title,
        title = _ref$title === void 0 ? 'title' : _ref$title,
        disabled = _ref.disabled,
        rest = _objectWithoutProperties$2(_ref, ["children", "className", "iconDescription", "open", "onHeadingClick", "renderExpando", "title", "disabled"]);

    var _useState = React.useState(open),
        _useState2 = _slicedToArray(_useState, 2),
        isOpen = _useState2[0],
        setIsOpen = _useState2[1];

    var _useState3 = React.useState(open),
        _useState4 = _slicedToArray(_useState3, 2),
        prevIsOpen = _useState4[0],
        setPrevIsOpen = _useState4[1];

    var _useState5 = React.useState(''),
        _useState6 = _slicedToArray(_useState5, 2),
        animation = _useState6[0],
        setAnimation = _useState6[1];

    var id = useId('accordion-item');
    var className = classnames((_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2F, "--accordion__item"), true), _defineProperty$2(_cx, "".concat(prefix$2F, "--accordion__item--active"), isOpen), _defineProperty$2(_cx, "".concat(prefix$2F, "--accordion__item--").concat(animation), animation), _defineProperty$2(_cx, "".concat(prefix$2F, "--accordion__item--disabled"), disabled), _defineProperty$2(_cx, customClassName, !!customClassName), _cx));

    if (open !== prevIsOpen) {
      setAnimation(isOpen ? 'collapsing' : 'expanding');
      setIsOpen(open);
      setPrevIsOpen(open);
    } // When the AccordionItem heading is clicked, toggle the open state of the
    // panel


    function onClick(event) {
      var nextValue = !isOpen;
      setAnimation(isOpen ? 'collapsing' : 'expanding');
      setIsOpen(nextValue);

      if (onHeadingClick) {
        // TODO: normalize signature, potentially:
        // onHeadingClick :: (event: Event, state: { isOpen: Boolean }) => any
        onHeadingClick({
          isOpen: nextValue,
          event: event
        });
      }
    } // If the AccordionItem is open, and the user hits the ESC key, then close it


    function onKeyDown(event) {
      if (isOpen && match(event, Escape)) {
        setIsOpen(false);
      }
    }

    function handleAnimationEnd(event) {
      if (rest.handleAnimationEnd) {
        rest.handleAnimationEnd(event);
      }

      setAnimation('');
    }

    return /*#__PURE__*/React__default['default'].createElement("li", _extends$3({
      className: className
    }, rest, {
      onAnimationEnd: handleAnimationEnd
    }), /*#__PURE__*/React__default['default'].createElement(Expando, {
      disabled: disabled,
      "aria-controls": id,
      "aria-expanded": isOpen,
      className: "".concat(prefix$2F, "--accordion__heading"),
      onClick: onClick,
      onKeyDown: onKeyDown,
      type: "button"
    }, /*#__PURE__*/React__default['default'].createElement(ChevronRight16, {
      className: "".concat(prefix$2F, "--accordion__arrow")
    }), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2F, "--accordion__title")
    }, title)), /*#__PURE__*/React__default['default'].createElement("div", {
      id: id,
      className: "".concat(prefix$2F, "--accordion__content")
    }, children));
  }

  AccordionItem.propTypes = {
    /**
     * Provide the contents of your AccordionItem
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether an individual AccordionItem should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * The description of the expando icon.
     */
    iconDescription: deprecate(PropTypes__default['default'].string, 'The `iconDescription` prop has been deprecated as it is no longer ' + 'required. Feel free to remove this prop from <AccordionItem>. This ' + 'prop will be removed in the next major release of ' + '`carbon-components-react`'),

    /**
     * The handler of the massaged `click` event.
     */
    onClick: PropTypes__default['default'].func,

    /**
     * The handler of the massaged `click` event on the heading.
     */
    onHeadingClick: PropTypes__default['default'].func,

    /**
     * `true` to open the expando.
     */
    open: PropTypes__default['default'].bool,

    /**
     * The callback function to render the expando button.
     * Can be a React component class.
     */
    renderExpando: PropTypes__default['default'].func,

    /**
     * The accordion title.
     */
    title: PropTypes__default['default'].node
  };

  var prefix$2E = settings_1.prefix;
  var randoms = [0.973051493507435, 0.15334737213558558, 0.5671034553053769];

  function getRandomInt(min, max, n) {
    return Math.floor(randoms[n % 3] * (max - min + 1)) + min;
  }

  var SkeletonText = function SkeletonText(_ref) {
    var _classNames;

    var paragraph = _ref.paragraph,
        lineCount = _ref.lineCount,
        width = _ref.width,
        heading = _ref.heading,
        className = _ref.className,
        other = _objectWithoutProperties$2(_ref, ["paragraph", "lineCount", "width", "heading", "className"]);

    var skeletonTextClasses = classnames((_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$2E, "--skeleton__text"), true), _defineProperty$2(_classNames, "".concat(prefix$2E, "--skeleton__heading"), heading), _defineProperty$2(_classNames, className, className), _classNames));
    var widthNum = parseInt(width, 10);
    var widthPx = width.includes('px');
    var widthPercent = width.includes('%');

    if (widthPercent && paragraph) {
      var lines = [];

      for (var i = 0; i < lineCount; i++) {
        var randomWidth = getRandomInt(0, 75, i) + 'px';
        lines.push( /*#__PURE__*/React__default['default'].createElement("p", _extends$3({
          className: skeletonTextClasses,
          style: {
            width: "calc(".concat(width, " - ").concat(randomWidth, ")")
          },
          key: i
        }, other)));
      }

      return /*#__PURE__*/React__default['default'].createElement("div", null, lines);
    }

    if (widthPx && paragraph) {
      var _lines = [];

      for (var j = 0; j < lineCount; j++) {
        var _randomWidth = getRandomInt(widthNum - 75, widthNum, j) + 'px';

        _lines.push( /*#__PURE__*/React__default['default'].createElement("p", _extends$3({
          className: skeletonTextClasses,
          style: {
            width: _randomWidth
          },
          key: j
        }, other)));
      }

      return /*#__PURE__*/React__default['default'].createElement("div", null, _lines);
    }

    return /*#__PURE__*/React__default['default'].createElement("p", _extends$3({
      className: skeletonTextClasses,
      style: {
        width: width
      }
    }, other));
  };

  SkeletonText.propTypes = {
    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * generates skeleton text at a larger size
     */
    heading: PropTypes__default['default'].bool,

    /**
     * the number of lines in a paragraph
     */
    lineCount: PropTypes__default['default'].number,

    /**
     * will generate multiple lines of text
     */
    paragraph: PropTypes__default['default'].bool,

    /**
     * width (in px or %) of single line of text or max-width of paragraph lines
     */
    width: PropTypes__default['default'].string
  };
  SkeletonText.defaultProps = {
    paragraph: false,
    width: '100%',
    heading: false,
    lineCount: 3
  };

  var prefix$2D = settings_1.prefix;

  function AccordionSkeleton(_ref) {
    var align = _ref.align,
        open = _ref.open,
        count = _ref.count,
        className = _ref.className,
        rest = _objectWithoutProperties$2(_ref, ["align", "open", "count", "className"]);

    var classes = classnames("".concat(prefix$2D, "--accordion"), "".concat(prefix$2D, "--skeleton"), className, _defineProperty$2({}, "".concat(prefix$2D, "--accordion--").concat(align), align));
    var numSkeletonItems = open ? count - 1 : count;
    return /*#__PURE__*/React__default['default'].createElement("ul", _extends$3({
      className: classes
    }, rest), open && /*#__PURE__*/React__default['default'].createElement("li", {
      className: "".concat(prefix$2D, "--accordion__item ").concat(prefix$2D, "--accordion__item--active")
    }, /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$2D, "--accordion__heading")
    }, /*#__PURE__*/React__default['default'].createElement(ChevronRight16, {
      className: "".concat(prefix$2D, "--accordion__arrow")
    }), /*#__PURE__*/React__default['default'].createElement(SkeletonText, {
      className: "".concat(prefix$2D, "--accordion__title")
    })), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2D, "--accordion__content")
    }, /*#__PURE__*/React__default['default'].createElement(SkeletonText, {
      width: "90%"
    }), /*#__PURE__*/React__default['default'].createElement(SkeletonText, {
      width: "80%"
    }), /*#__PURE__*/React__default['default'].createElement(SkeletonText, {
      width: "95%"
    }))), Array.from({
      length: numSkeletonItems
    }).map(function (_, i) {
      return /*#__PURE__*/React__default['default'].createElement(AccordionSkeletonItem, {
        key: i
      });
    }));
  }

  AccordionSkeleton.propTypes = {
    /**
     * Specify the alignment of the accordion heading title and chevron.
     */
    align: PropTypes__default['default'].oneOf(['start', 'end']),

    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string,

    /**
     * Set number of items to render
     */
    count: PropTypes__default['default'].number,

    /**
     * `false` to not display the first item opened
     */
    open: PropTypes__default['default'].bool,

    /**
     * Set unique identifier to generate unique item keys
     */
    uid: deprecate(PropTypes__default['default'].any)
  };
  AccordionSkeleton.defaultProps = {
    open: true,
    count: 4,
    align: 'end'
  };

  function AccordionSkeletonItem() {
    return /*#__PURE__*/React__default['default'].createElement("li", {
      className: "".concat(prefix$2D, "--accordion__item")
    }, /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$2D, "--accordion__heading")
    }, /*#__PURE__*/React__default['default'].createElement(ChevronRight16, {
      className: "".concat(prefix$2D, "--accordion__arrow")
    }), /*#__PURE__*/React__default['default'].createElement(SkeletonText, {
      className: "".concat(prefix$2D, "--accordion__title")
    })));
  }

  var prefix$2C = settings_1.prefix;
  /**
   * The AspectRatio component provides a `ratio` prop that will be used to
   * specify the aspect ratio that the children you provide will be displayed in.
   * This is often useful alongside our grid components, or for media assets like
   * images or videos.
   */

  function AspectRatio(_ref) {
    var _ref$as = _ref.as,
        BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
        containerClassName = _ref.className,
        children = _ref.children,
        _ref$ratio = _ref.ratio,
        ratio = _ref$ratio === void 0 ? '1x1' : _ref$ratio,
        rest = _objectWithoutProperties$2(_ref, ["as", "className", "children", "ratio"]);

    var className = classnames(containerClassName, "".concat(prefix$2C, "--aspect-ratio"), "".concat(prefix$2C, "--aspect-ratio--").concat(ratio));
    return /*#__PURE__*/React__default['default'].createElement(BaseComponent, _extends$3({
      className: className
    }, rest), children);
  }

  AspectRatio.propTypes = {
    /**
     * Provide a custom component or string to be rendered as the outermost node
     * of the component. This is useful if you want to deviate from the default
     * `div` tag, where you could specify `section` or `article` instead.
     *
     * ```jsx
     * <AspectRatio as="article">My content</AspectRatio>
     * ```
     */
    as: PropTypes__default['default'].elementType,

    /**
     * Specify the content that will be placed in the aspect ratio
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify a class name for the outermost node of the component
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the ratio to be used by the aspect ratio container. This will
     * determine what aspect ratio your content will be displayed in.
     */
    ratio: PropTypes__default['default'].oneOf(['16x9', '9x16', '2x1', '1x2', '4x3', '3x4', '1x1'])
  };

  var prefix$2B = settings_1.prefix;
  var Breadcrumb = /*#__PURE__*/React__default['default'].forwardRef(function Breadcrumb(_ref, ref) {
    var _cx;

    var ariaLabel = _ref['aria-label'],
        children = _ref.children,
        customClassNameNav = _ref.className,
        noTrailingSlash = _ref.noTrailingSlash,
        rest = _objectWithoutProperties$2(_ref, ["aria-label", "children", "className", "noTrailingSlash"]);

    var className = classnames((_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2B, "--breadcrumb"), true), _defineProperty$2(_cx, "".concat(prefix$2B, "--breadcrumb--no-trailing-slash"), noTrailingSlash), _cx));
    return /*#__PURE__*/React__default['default'].createElement("nav", _extends$3({
      className: customClassNameNav,
      "aria-label": ariaLabel ? ariaLabel : 'Breadcrumb',
      ref: ref
    }, rest), /*#__PURE__*/React__default['default'].createElement("ol", {
      className: className
    }, children));
  });
  Breadcrumb.displayName = 'Breadcrumb';
  Breadcrumb.propTypes = {
    /**
     * Specify the label for the breadcrumb container
     */
    'aria-label': PropTypes__default['default'].string,

    /**
     * Pass in the BreadcrumbItem's for your Breadcrumb
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Optional prop to omit the trailing slash for the breadcrumbs
     */
    noTrailingSlash: PropTypes__default['default'].bool
  };

  var prefix$2A = settings_1.prefix;

  var Link$1 = function Link(_ref) {
    var _classnames;

    var children = _ref.children,
        className = _ref.className,
        href = _ref.href,
        disabled = _ref.disabled,
        inline = _ref.inline,
        visited = _ref.visited,
        Icon = _ref.renderIcon,
        size = _ref.size,
        other = _objectWithoutProperties$2(_ref, ["children", "className", "href", "disabled", "inline", "visited", "renderIcon", "size"]);

    var classNames = classnames("".concat(prefix$2A, "--link"), className, (_classnames = {}, _defineProperty$2(_classnames, "".concat(prefix$2A, "--link--disabled"), disabled), _defineProperty$2(_classnames, "".concat(prefix$2A, "--link--inline"), inline), _defineProperty$2(_classnames, "".concat(prefix$2A, "--link--visited"), visited), _defineProperty$2(_classnames, "".concat(prefix$2A, "--link--").concat(size), size), _classnames));
    var Tag = disabled ? 'p' : 'a';
    var rel = other.target === '_blank' ? 'noopener' : null;
    return /*#__PURE__*/React__default['default'].createElement(Tag, _extends$3({
      href: disabled ? null : href,
      className: classNames,
      rel: rel
    }, other), children, !inline && Icon && /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2A, "--link__icon")
    }, /*#__PURE__*/React__default['default'].createElement(Icon, null)));
  };

  Link$1.propTypes = {
    /**
     * Provide the content for the Link
     */
    children: PropTypes__default['default'].node,

    /**
     * Provide a custom className to be applied to the containing `<a>` node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify if the control should be disabled, or not
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Provide the `href` attribute for the `<a>` node
     */
    href: PropTypes__default['default'].string,

    /**
     * Specify whether you want the inline version of this control
     */
    inline: PropTypes__default['default'].bool,

    /**
     * Optional prop to render an icon next to the link.
     * Can be a React component class
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object]),

    /**
     * Specify the size of the Link. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
     */
    size: PropTypes__default['default'].oneOf(['sm', 'md', 'lg']),

    /**
     * Specify whether you want the link to receive visited styles after the link has been clicked
     */
    visited: PropTypes__default['default'].bool
  };

  var prefix$2z = settings_1.prefix;
  var BreadcrumbItem = /*#__PURE__*/React__default['default'].forwardRef(function BreadcrumbItem(_ref, ref) {
    var _cx;

    var ariaCurrent = _ref['aria-current'],
        children = _ref.children,
        customClassName = _ref.className,
        href = _ref.href,
        isCurrentPage = _ref.isCurrentPage,
        rest = _objectWithoutProperties$2(_ref, ["aria-current", "children", "className", "href", "isCurrentPage"]);

    var className = classnames((_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2z, "--breadcrumb-item"), true), _defineProperty$2(_cx, "".concat(prefix$2z, "--breadcrumb-item--current"), isCurrentPage && ariaCurrent !== 'page'), _defineProperty$2(_cx, customClassName, !!customClassName), _cx));

    if (children.type && children.type.displayName !== undefined && children.type.displayName === 'OverflowMenu') {
      var horizontalOverflowIcon = /*#__PURE__*/React__default['default'].createElement(OverflowMenuHorizontal16, {
        className: "".concat(prefix$2z, "--overflow-menu__icon")
      });
      return /*#__PURE__*/React__default['default'].createElement("li", _extends$3({
        className: className
      }, rest), /*#__PURE__*/React__default['default'].cloneElement(children, {
        menuOptionsClass: "".concat(prefix$2z, "--breadcrumb-menu-options"),
        menuOffset: {
          top: 10,
          left: 59
        },
        renderIcon: function renderIcon() {
          return horizontalOverflowIcon;
        }
      }));
    }

    if (typeof children === 'string' && href) {
      return /*#__PURE__*/React__default['default'].createElement("li", _extends$3({
        className: className,
        ref: ref
      }, rest), /*#__PURE__*/React__default['default'].createElement(Link$1, {
        href: href,
        "aria-current": ariaCurrent
      }, children));
    }

    return /*#__PURE__*/React__default['default'].createElement("li", _extends$3({
      className: className,
      ref: ref
    }, rest), /*#__PURE__*/React__default['default'].cloneElement(children, {
      'aria-current': ariaCurrent,
      className: classnames("".concat(prefix$2z, "--link"), children.props.className)
    }));
  });
  BreadcrumbItem.displayName = 'BreadcrumbItem';
  BreadcrumbItem.propTypes = {
    'aria-current': PropTypes__default['default'].oneOfType([PropTypes__default['default'].string, PropTypes__default['default'].bool]),

    /**
     * Pass in content that will be inside of the BreadcrumbItem
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Optional string representing the link location for the BreadcrumbItem
     */
    href: PropTypes__default['default'].string,

    /**
     * Provide if this breadcrumb item represents the current page
     */
    isCurrentPage: PropTypes__default['default'].bool
  };

  var prefix$2y = settings_1.prefix;
  var item = /*#__PURE__*/React__default['default'].createElement("div", {
    className: "".concat(prefix$2y, "--breadcrumb-item")
  }, /*#__PURE__*/React__default['default'].createElement("span", {
    className: "".concat(prefix$2y, "--link")
  }, "\xA0"));

  function BreadcrumbSkeleton(_ref) {
    var className = _ref.className,
        rest = _objectWithoutProperties$2(_ref, ["className"]);

    var classes = classnames("".concat(prefix$2y, "--breadcrumb"), "".concat(prefix$2y, "--skeleton"), className);
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: classes
    }, rest), item, item, item);
  }

  BreadcrumbSkeleton.propTypes = {
    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string
  };

  var prefix$2x = settings_1.prefix;

  var ButtonSkeleton = function ButtonSkeleton(_ref) {
    var _cx;

    var className = _ref.className,
        small = _ref.small,
        href = _ref.href,
        rest = _objectWithoutProperties$2(_ref, ["className", "small", "href"]);

    var buttonClasses = classnames(className, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2x, "--skeleton"), true), _defineProperty$2(_cx, "".concat(prefix$2x, "--btn"), true), _defineProperty$2(_cx, "".concat(prefix$2x, "--btn--sm"), small), _cx));

    var commonProps = _objectSpread2$2({
      className: buttonClasses
    }, rest);

    var button = /*#__PURE__*/React__default['default'].createElement("div", commonProps);
    var anchor = /*#__PURE__*/React__default['default'].createElement("a", _extends$3({}, commonProps, {
      href: href,
      role: "button"
    })); // eslint-disable-line

    return href ? anchor : button;
  };

  ButtonSkeleton.propTypes = {
    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string,

    /**
     * Optionally specify an href for your Button to become an `<a>` element
     */
    href: PropTypes__default['default'].string,

    /**
     * Specify whether the Button should be a small variant
     */
    small: PropTypes__default['default'].bool
  };
  ButtonSkeleton.defaultProps = {
    small: false
  };

  var ButtonKinds = ['primary', 'secondary', 'danger', 'ghost', 'danger--primary', 'danger--ghost', 'danger--tertiary', 'tertiary'];

  /**
   * Generic utility to compose event handlers so that consumers can supply their
   * own event listeners on table components. The default heuristic here is to
   * iterate through the given functions until `preventDefault` is called on the
   * given event.
   *
   * @param {Array<Function>} fns array of functions to apply to the event
   * @returns {Function}
   */
  var composeEventHandlers = function composeEventHandlers(fns) {
    return function (event) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      for (var i = 0; i < fns.length; i++) {
        if (event.defaultPrevented) {
          break;
        }

        if (typeof fns[i] === 'function') {
          fns[i].apply(fns, [event].concat(args));
        }
      }
    };
  };

  function toggleClass$1(element, name, add) {
    if (element.classList.contains(name) === !add) {
      element.classList[add ? 'add' : 'remove'](name);
    }
  }

  /**
   * Copyright IBM Corp. 2015, 2020
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var enabled$1 = {};

  try {
    if (process.env.CARBON_ENABLE_CSS_CUSTOM_PROPERTIES) {
      if (process.env.CARBON_ENABLE_CSS_CUSTOM_PROPERTIES === 'true') {
        enabled$1.enableCssCustomProperties = true;
      } else {
        enabled$1.enableCssCustomProperties = false;
      }
    } else {
      enabled$1.enableCssCustomProperties = false;
    }

    if (process.env.CARBON_ENABLE_USE_CONTROLLED_STATE_WITH_VALUE) {
      if (process.env.CARBON_ENABLE_USE_CONTROLLED_STATE_WITH_VALUE === 'true') {
        enabled$1.enableUseControlledStateWithValue = true;
      } else {
        enabled$1.enableUseControlledStateWithValue = false;
      }
    } else {
      enabled$1.enableUseControlledStateWithValue = false;
    }

    if (process.env.CARBON_ENABLE_CSS_GRID) {
      if (process.env.CARBON_ENABLE_CSS_GRID === 'true') {
        enabled$1.enableCssGrid = true;
      } else {
        enabled$1.enableCssGrid = false;
      }
    } else {
      enabled$1.enableCssGrid = false;
    }

    if (process.env.CARBON_ENABLE_V11_RELEASE) {
      if (process.env.CARBON_ENABLE_V11_RELEASE === 'true') {
        enabled$1.enableV11Release = true;
      } else {
        enabled$1.enableV11Release = false;
      }
    } else {
      enabled$1.enableV11Release = false;
    }
  } catch (error) {
    enabled$1.enableCssCustomProperties = false;
    enabled$1.enableUseControlledStateWithValue = false;
    enabled$1.enableCssGrid = false;
    enabled$1.enableV11Release = false;
  }

  var featureFlagInfo = [{
    name: "enable-css-custom-properties",
    description: "Describe what the flag does",
    enabled: enabled$1.enableCssCustomProperties
  }, {
    name: "enable-use-controlled-state-with-value",
    description: "Enable components to be created in either a controlled or uncontrolled mode\n",
    enabled: enabled$1.enableUseControlledStateWithValue
  }, {
    name: "enable-css-grid",
    description: "Enable CSS Grid Layout in the Grid and Column React components\n",
    enabled: enabled$1.enableCssGrid
  }, {
    name: "enable-v11-release",
    description: "Enable the features and functionality for the v11 Release\n",
    enabled: enabled$1.enableV11Release
  }];

  var FeatureFlagScope = /*#__PURE__*/function () {
    function FeatureFlagScope(flags) {
      var _this = this;

      _classCallCheck(this, FeatureFlagScope);

      this.flags = new Map();

      if (flags) {
        Object.keys(flags).forEach(function (key) {
          _this.flags.set(key, flags[key]);
        });
      }
    }
    /**
     * Check to see if a flag exists
     * @param {string} name
     */


    _createClass(FeatureFlagScope, [{
      key: "checkForFlag",
      value: function checkForFlag(name) {
        if (!this.flags.has(name)) {
          throw new Error("Unable to find a feature flag with the name: `".concat(name, "`"));
        }
      }
      /**
       * Add a feature flag
       * @param {string} name
       * @param {boolean} enabled
       */

    }, {
      key: "add",
      value: function add(name, enabled) {
        if (this.flags.has(name)) {
          throw new Error("The feature flag: ".concat(name, " already exists"));
        }

        this.flags.set(name, enabled);
      }
      /**
       * Enable a feature flag
       * @param {string} name
       */

    }, {
      key: "enable",
      value: function enable(name) {
        this.checkForFlag(name);
        this.flags.set(name, true);
      }
      /**
       * Disable a feature flag
       * @param {string} name
       */

    }, {
      key: "disable",
      value: function disable(name) {
        this.checkForFlag(name);
        this.flags.set(name, false);
      }
      /**
       * Merge the given feature flags with the current set of feature flags.
       * Duplicate keys will be set to the value in the given feature flags.
       * @param {object} flags
       */

    }, {
      key: "merge",
      value: function merge(flags) {
        var _this2 = this;

        Object.keys(flags).forEach(function (key) {
          _this2.flags.set(key, flags[key]);
        });
      }
      /**
       * @param {FeatureFlagScope} scope
       */

    }, {
      key: "mergeWithScope",
      value: function mergeWithScope(scope) {
        var _iterator = _createForOfIteratorHelper(scope.flags),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var _step$value = _slicedToArray(_step.value, 2),
                key = _step$value[0],
                value = _step$value[1];

            if (this.flags.has(key)) {
              continue;
            }

            this.flags.set(key, value);
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
      /**
       * Check if a feature flag is enabled
       * @param {string} name
       * @returns {boolean}
       */

    }, {
      key: "enabled",
      value: function enabled(name) {
        this.checkForFlag(name);
        return this.flags.get(name);
      }
    }]);

    return FeatureFlagScope;
  }();

  var FeatureFlags$1 = createScope();

  for (var i = 0; i < featureFlagInfo.length; i++) {
    var featureFlag = featureFlagInfo[i];
    FeatureFlags$1.add(featureFlag.name, featureFlag.enabled);
  }

  function createScope(flags) {
    return new FeatureFlagScope(flags);
  }

  function enabled() {
    return FeatureFlags$1.enabled.apply(FeatureFlags$1, arguments);
  }

  /**
   * Our FeatureFlagContext is used alongside the FeatureFlags component to enable
   * or disable feature flags in a given React tree
   */

  var FeatureFlagContext = /*#__PURE__*/React.createContext(FeatureFlags$1);
  /**
   * Supports an object of feature flag values with the `flags` prop, merging them
   * along with the current `FeatureFlagContext` to provide consumers to check if
   * a feature flag is enabled or disabled in a given React tree
   */

  function FeatureFlags(_ref) {
    var children = _ref.children,
        _ref$flags = _ref.flags,
        flags = _ref$flags === void 0 ? {} : _ref$flags;
    var parentScope = React.useContext(FeatureFlagContext);

    var _useState = React.useState(parentScope),
        _useState2 = _slicedToArray(_useState, 2),
        prevParentScope = _useState2[0],
        setPrevParentScope = _useState2[1];

    var _useState3 = React.useState(function () {
      var scope = createScope(flags);
      scope.mergeWithScope(parentScope);
      return scope;
    }),
        _useState4 = _slicedToArray(_useState3, 2),
        scope = _useState4[0],
        updateScope = _useState4[1];

    if (parentScope !== prevParentScope) {
      var _scope = createScope(flags);

      _scope.mergeWithScope(parentScope);

      updateScope(_scope);
      setPrevParentScope(parentScope);
    } // We use a custom hook to detect if any of the keys or their values change
    // for flags that are passed in. If they have changed, then we re-create the
    // FeatureFlagScope using the new flags


    useChangedValue(flags, isEqual, function (changedFlags) {
      var scope = createScope(changedFlags);
      scope.mergeWithScope(parentScope);
      updateScope(scope);
    });
    return /*#__PURE__*/React__default['default'].createElement(FeatureFlagContext.Provider, {
      value: scope
    }, children);
  }

  FeatureFlags.propTypes = {
    children: PropTypes__default['default'].node,

    /**
     * Provide the feature flags to enabled or disabled in the current React tree
     */
    flags: PropTypes__default['default'].objectOf(PropTypes__default['default'].bool)
  };
  /**
   * This hook will store previous versions of the given `value` and compare the
   * current value to the previous one using the `compare` function. If the
   * compare function returns true, then the given `callback` is invoked in an
   * effect.
   *
   * @param {any} value
   * @param {Function} compare
   * @param {Function} callback
   */

  function useChangedValue(value, compare, callback) {
    var initialRender = React.useRef(false);
    var savedCallback = React.useRef(callback);

    var _useState5 = React.useState(value),
        _useState6 = _slicedToArray(_useState5, 2),
        prevValue = _useState6[0],
        setPrevValue = _useState6[1];

    if (!compare(prevValue, value)) {
      setPrevValue(value);
    }

    React.useEffect(function () {
      savedCallback.current = callback;
    });
    React.useEffect(function () {
      // We only want the callback triggered after the first render
      if (initialRender.current) {
        savedCallback.current(prevValue);
      }
    }, [prevValue]);
    React.useEffect(function () {
      initialRender.current = true;
    }, []);
  }
  /**
   * Access whether a given flag is enabled or disabled in a given
   * FeatureFlagContext
   *
   * @returns {boolean}
   */


  function useFeatureFlag(flag) {
    var scope = React.useContext(FeatureFlagContext);
    return scope.enabled(flag);
  }
  /**
   * Access all feature flag information for the given FeatureFlagContext
   *
   * @returns {FeatureFlagScope}
   */


  function useFeatureFlags() {
    return React.useContext(FeatureFlagContext);
  }
  /**
   * Compare two objects and determine if they are equal. This is a shallow
   * comparison since the objects we are comparing are objects with boolean flags
   * from the flags prop in the `FeatureFlags` component
   *
   * @param {object} a
   * @param {object} b
   * @returns {boolean}
   */


  function isEqual(a, b) {
    if (a === b) {
      return true;
    }

    for (var _i = 0, _Object$keys = Object.keys(a); _i < _Object$keys.length; _i++) {
      var key = _Object$keys[_i];

      if (a[key] !== b[key]) {
        return false;
      }
    }

    for (var _i2 = 0, _Object$keys2 = Object.keys(b); _i2 < _Object$keys2.length; _i2++) {
      var _key = _Object$keys2[_i2];

      if (b[_key] !== a[_key]) {
        return false;
      }
    }

    return true;
  }

  var prefix$2w = settings_1.prefix;
  var Button = /*#__PURE__*/React__default['default'].forwardRef(function Button(_ref, ref) {
    var _classNames;

    var children = _ref.children,
        as = _ref.as,
        className = _ref.className,
        disabled = _ref.disabled,
        small = _ref.small,
        size = _ref.size,
        kind = _ref.kind,
        href = _ref.href,
        isExpressive = _ref.isExpressive,
        isSelected = _ref.isSelected,
        tabIndex = _ref.tabIndex,
        type = _ref.type,
        ButtonImageElement = _ref.renderIcon,
        dangerDescription = _ref.dangerDescription,
        iconDescription = _ref.iconDescription,
        hasIconOnly = _ref.hasIconOnly,
        tooltipPosition = _ref.tooltipPosition,
        tooltipAlignment = _ref.tooltipAlignment,
        onClick = _ref.onClick,
        onBlur = _ref.onBlur,
        onFocus = _ref.onFocus,
        onMouseEnter = _ref.onMouseEnter,
        onMouseLeave = _ref.onMouseLeave,
        other = _objectWithoutProperties$2(_ref, ["children", "as", "className", "disabled", "small", "size", "kind", "href", "isExpressive", "isSelected", "tabIndex", "type", "renderIcon", "dangerDescription", "iconDescription", "hasIconOnly", "tooltipPosition", "tooltipAlignment", "onClick", "onBlur", "onFocus", "onMouseEnter", "onMouseLeave"]);

    var _useState = React.useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        allowTooltipVisibility = _useState2[0],
        setAllowTooltipVisibility = _useState2[1];

    var _useState3 = React.useState(false),
        _useState4 = _slicedToArray(_useState3, 2),
        isHovered = _useState4[0],
        setIsHovered = _useState4[1];

    var _useState5 = React.useState(false),
        _useState6 = _slicedToArray(_useState5, 2),
        isFocused = _useState6[0],
        setIsFocused = _useState6[1];

    var tooltipRef = React.useRef(null);
    var tooltipTimeout = React.useRef(null);

    var closeTooltips = function closeTooltips(evt) {
      var _document;

      var tooltipNode = (_document = document) === null || _document === void 0 ? void 0 : _document.querySelectorAll(".".concat(prefix$2w, "--tooltip--a11y"));

      _toConsumableArray(tooltipNode).map(function (node) {
        toggleClass$1(node, "".concat(prefix$2w, "--tooltip--hidden"), node !== evt.currentTarget);
      });
    };

    var handleFocus = function handleFocus(evt) {
      if (hasIconOnly) {
        closeTooltips(evt);
        setIsHovered(!isHovered);
        setIsFocused(true);
        setAllowTooltipVisibility(true);
      }
    };

    var handleBlur = function handleBlur() {
      if (hasIconOnly) {
        setIsHovered(false);
        setIsFocused(false);
        setAllowTooltipVisibility(false);
      }
    };

    var handleMouseEnter = function handleMouseEnter(evt) {
      if (hasIconOnly) {
        setIsHovered(true);
        tooltipTimeout.current && clearTimeout(tooltipTimeout.current);

        if (evt.target === tooltipRef.current) {
          setAllowTooltipVisibility(true);
          return;
        }

        closeTooltips(evt);
        setAllowTooltipVisibility(true);
      }
    };

    var handleMouseLeave = function handleMouseLeave() {
      if (!isFocused && hasIconOnly) {
        tooltipTimeout.current = setTimeout(function () {
          setAllowTooltipVisibility(false);
          setIsHovered(false);
        }, 100);
      }
    };

    var handleClick = function handleClick(evt) {
      // Prevent clicks on the tooltip from triggering the button click event
      if (evt.target === tooltipRef.current) {
        evt.preventDefault();
        return;
      }
    };

    React.useEffect(function () {
      var handleEscKeyDown = function handleEscKeyDown(event) {
        if (matches(event, [Escape])) {
          setAllowTooltipVisibility(false);
          setIsHovered(false);
        }
      };

      document.addEventListener('keydown', handleEscKeyDown);
      return function () {
        return document.removeEventListener('keydown', handleEscKeyDown);
      };
    }, []);
    var enabled = useFeatureFlag('enable-v11-release');
    var buttonClasses = classnames(className, (_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn"), true), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--sm"), size === 'small' && !isExpressive || size === 'sm' && !isExpressive || small && !isExpressive), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--md"), size === 'field' && !isExpressive || size === 'md' && !isExpressive), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--lg"), enabled ? size === 'xl' : size === 'lg'), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--xl"), enabled ? size === '2xl' : size === 'xl'), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--").concat(kind), kind), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--disabled"), disabled), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--expressive"), isExpressive), _defineProperty$2(_classNames, "".concat(prefix$2w, "--tooltip--hidden"), hasIconOnly && !allowTooltipVisibility), _defineProperty$2(_classNames, "".concat(prefix$2w, "--tooltip--visible"), isHovered), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--icon-only"), hasIconOnly), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--selected"), hasIconOnly && isSelected && kind === 'ghost'), _defineProperty$2(_classNames, "".concat(prefix$2w, "--tooltip__trigger"), hasIconOnly), _defineProperty$2(_classNames, "".concat(prefix$2w, "--tooltip--a11y"), hasIconOnly), _defineProperty$2(_classNames, "".concat(prefix$2w, "--btn--icon-only--").concat(tooltipPosition), hasIconOnly && tooltipPosition), _defineProperty$2(_classNames, "".concat(prefix$2w, "--tooltip--align-").concat(tooltipAlignment), hasIconOnly && tooltipAlignment), _classNames));
    var commonProps = {
      tabIndex: tabIndex,
      className: buttonClasses,
      ref: ref
    };
    var buttonImage = !ButtonImageElement ? null : /*#__PURE__*/React__default['default'].createElement(ButtonImageElement, {
      "aria-label": iconDescription,
      className: "".concat(prefix$2w, "--btn__icon"),
      "aria-hidden": "true"
    });
    var dangerButtonVariants = ['danger', 'danger--tertiary', 'danger--ghost'];
    var component = 'button';
    var assistiveId = useId('danger-description');
    var otherProps = {
      disabled: disabled,
      type: type,
      'aria-describedby': dangerButtonVariants.includes(kind) ? assistiveId : null,
      'aria-pressed': hasIconOnly && kind === 'ghost' ? isSelected : null
    };
    var anchorProps = {
      href: href
    };
    var assistiveText;

    if (hasIconOnly) {
      assistiveText = /*#__PURE__*/React__default['default'].createElement("div", {
        ref: tooltipRef,
        onMouseEnter: handleMouseEnter,
        className: "".concat(prefix$2w, "--assistive-text")
      }, iconDescription);
    } else if (dangerButtonVariants.includes(kind)) {
      assistiveText = /*#__PURE__*/React__default['default'].createElement("span", {
        id: assistiveId,
        className: "".concat(prefix$2w, "--visually-hidden")
      }, dangerDescription);
    } else {
      assistiveText = null;
    }

    if (as) {
      component = as;
      otherProps = _objectSpread2$2(_objectSpread2$2({}, otherProps), anchorProps);
    } else if (href && !disabled) {
      component = 'a';
      otherProps = anchorProps;
    }

    return /*#__PURE__*/React__default['default'].createElement(component, _objectSpread2$2(_objectSpread2$2(_objectSpread2$2({
      onMouseEnter: composeEventHandlers([onMouseEnter, handleMouseEnter]),
      onMouseLeave: composeEventHandlers([onMouseLeave, handleMouseLeave]),
      onFocus: composeEventHandlers([onFocus, handleFocus]),
      onBlur: composeEventHandlers([onBlur, handleBlur]),
      onClick: composeEventHandlers([handleClick, onClick])
    }, other), commonProps), otherProps), assistiveText, children, buttonImage);
  });
  Button.displayName = 'Button';
  Button.propTypes = {
    /**
     * Specify how the button itself should be rendered.
     * Make sure to apply all props to the root node and render children appropriately
     */
    as: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].string, PropTypes__default['default'].elementType]),

    /**
     * Specify the content of your Button
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be added to your Button
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the message read by screen readers for the danger button variant
     */
    dangerDescription: PropTypes__default['default'].string,

    /**
     * Specify whether the Button should be disabled, or not
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify if the button is an icon-only button
     */
    hasIconOnly: PropTypes__default['default'].bool,

    /**
     * Optionally specify an href for your Button to become an `<a>` element
     */
    href: PropTypes__default['default'].string,

    /**
     * If specifying the `renderIcon` prop, provide a description for that icon that can
     * be read by screen readers
     */
    iconDescription: function iconDescription(props) {
      if (props.renderIcon && !props.children && !props.iconDescription) {
        return new Error('renderIcon property specified without also providing an iconDescription property.');
      }

      return undefined;
    },

    /**
     * Specify whether the Button is expressive, or not
     */
    isExpressive: PropTypes__default['default'].bool,

    /**
     * Specify whether the Button is currently selected
     */
    isSelected: PropTypes__default['default'].bool,

    /**
     * Specify the kind of Button you want to create
     */
    kind: PropTypes__default['default'].oneOf(ButtonKinds).isRequired,

    /**
     * Provide an optional function to be called when the button element
     * loses focus
     */
    onBlur: PropTypes__default['default'].func,

    /**
     * Provide an optional function to be called when the button element
     * is clicked
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Provide an optional function to be called when the button element
     * receives focus
     */
    onFocus: PropTypes__default['default'].func,

    /**
     * Provide an optional function to be called when the mouse
     * enters the button element
     */
    onMouseEnter: PropTypes__default['default'].func,

    /**
     * Provide an optional function to be called when the mouse
     * leaves the button element
     */
    onMouseLeave: PropTypes__default['default'].func,

    /**
     * Optional prop to allow overriding the icon rendering.
     * Can be a React component class
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object]),

    /**
     * Optional prop to specify the role of the Button
     */
    role: PropTypes__default['default'].string,

    /**
     * Specify the size of the button, from a list of available sizes.
     * For `default` buttons, this prop can remain unspecified or use `default`.
     * In the next major release of Carbon, `default`, `field`, and `small` will be removed
     */
    size: PropTypes__default['default'].oneOf(['default', 'field', 'small', 'sm', 'md', 'lg', 'xl', '2xl']),

    /**
     * Deprecated in v10 in favor of `size`.
     * Specify whether the Button should be a small variant
     */
    small: deprecate(PropTypes__default['default'].bool, "\nThe prop `small` for Button has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

    /**
     * Optional prop to specify the tabIndex of the Button
     */
    tabIndex: PropTypes__default['default'].number,

    /**
     * Specify the alignment of the tooltip to the icon-only button.
     * Can be one of: start, center, or end.
     */
    tooltipAlignment: PropTypes__default['default'].oneOf(['start', 'center', 'end']),

    /**
     * Specify the direction of the tooltip for icon-only buttons.
     * Can be either top, right, bottom, or left.
     */
    tooltipPosition: PropTypes__default['default'].oneOf(['top', 'right', 'bottom', 'left']),

    /**
     * Optional prop to specify the type of the Button
     */
    type: PropTypes__default['default'].oneOf(['button', 'reset', 'submit'])
  };
  Button.defaultProps = {
    tabIndex: 0,
    type: 'button',
    disabled: false,
    kind: 'primary',
    size: 'default',
    dangerDescription: 'danger',
    tooltipAlignment: 'center',
    tooltipPosition: 'top',
    isExpressive: false
  };

  var prefix$2v = settings_1.prefix;
  var ButtonSet = /*#__PURE__*/React__default['default'].forwardRef(function ButtonSet(_ref, ref) {
    var children = _ref.children,
        className = _ref.className,
        stacked = _ref.stacked,
        rest = _objectWithoutProperties$2(_ref, ["children", "className", "stacked"]);

    var buttonSetClasses = classnames(className, "".concat(prefix$2v, "--btn-set"), _defineProperty$2({}, "".concat(prefix$2v, "--btn-set--stacked"), stacked));
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, rest, {
      className: buttonSetClasses,
      ref: ref
    }), children);
  });
  ButtonSet.displayName = 'ButtonSet';
  ButtonSet.propTypes = {
    /**
     * Specify the content of your ButtonSet
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be added to your ButtonSet
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the button arrangement of the set (vertically stacked or
     * horizontal)
     */
    stacked: PropTypes__default['default'].bool
  };

  var prefix$2u = settings_1.prefix;

  var CheckboxSkeleton = function CheckboxSkeleton(_ref) {
    var className = _ref.className,
        rest = _objectWithoutProperties$2(_ref, ["className"]);

    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: classnames("".concat(prefix$2u, "--form-item"), "".concat(prefix$2u, "--checkbox-wrapper"), "".concat(prefix$2u, "--checkbox-label"), className)
    }, rest), /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$2u, "--checkbox-label-text ").concat(prefix$2u, "--skeleton")
    }));
  };

  CheckboxSkeleton.propTypes = {
    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string
  };

  var prefix$2t = settings_1.prefix;
  var Checkbox = /*#__PURE__*/React__default['default'].forwardRef(function Checkbox(_ref, _ref2) {
    var className = _ref.className,
        id = _ref.id,
        labelText = _ref.labelText,
        _onChange = _ref.onChange,
        indeterminate = _ref.indeterminate,
        hideLabel = _ref.hideLabel,
        wrapperClassName = _ref.wrapperClassName,
        _ref$title = _ref.title,
        title = _ref$title === void 0 ? '' : _ref$title,
        other = _objectWithoutProperties$2(_ref, ["className", "id", "labelText", "onChange", "indeterminate", "hideLabel", "wrapperClassName", "title"]);

    var labelClasses = classnames("".concat(prefix$2t, "--checkbox-label"), className);
    var innerLabelClasses = classnames("".concat(prefix$2t, "--checkbox-label-text"), _defineProperty$2({}, "".concat(prefix$2t, "--visually-hidden"), hideLabel));
    var wrapperClasses = classnames("".concat(prefix$2t, "--form-item"), "".concat(prefix$2t, "--checkbox-wrapper"), wrapperClassName);
    var enabled = useFeatureFlag('enable-v11-release');
    return /*#__PURE__*/React__default['default'].createElement("div", {
      className: wrapperClasses
    }, /*#__PURE__*/React__default['default'].createElement("input", _extends$3({}, other, {
      type: "checkbox",
      onChange: function onChange(evt) {
        if (enabled) {
          _onChange(evt, {
            checked: evt.target.checked,
            id: id
          });
        } else {
          _onChange(evt.target.checked, id, evt);
        }
      },
      className: "".concat(prefix$2t, "--checkbox"),
      id: id,
      ref: function ref(el) {
        if (el) {
          el.indeterminate = indeterminate;
        }

        if (typeof _ref2 === 'function') {
          _ref2(el);
        } else if (Object(_ref2) === _ref2) {
          _ref2.current = el;
        }
      }
    })), /*#__PURE__*/React__default['default'].createElement("label", {
      htmlFor: id,
      className: labelClasses,
      title: title || null
    }, /*#__PURE__*/React__default['default'].createElement("span", {
      className: innerLabelClasses
    }, labelText)));
  });
  Checkbox.propTypes = {
    /**
     * Specify whether the underlying input should be checked
     */
    checked: PropTypes__default['default'].bool,

    /**
     * Specify an optional className to be applied to the <label> node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether the underlying input should be checked by default
     */
    defaultChecked: PropTypes__default['default'].bool,

    /**
     * Specify whether the Checkbox should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify whether the label should be hidden, or not
     */
    hideLabel: PropTypes__default['default'].bool,

    /**
     * Provide an `id` to uniquely identify the Checkbox input
     */
    id: PropTypes__default['default'].string.isRequired,

    /**
     * Specify whether the Checkbox is in an indeterminate state
     */
    indeterminate: PropTypes__default['default'].bool,

    /**
     * Provide a label to provide a description of the Checkbox input that you are
     * exposing to the user
     */
    labelText: PropTypes__default['default'].node.isRequired,

    /**
     * Receives three arguments: true/false, the checkbox's id, and the dom event.
     * `(value, id, event) => console.log({value, id, event})`
     */
    onChange: PropTypes__default['default'].func,

    /**
     * Specify a title for the <label> node for the Checkbox
     */
    title: PropTypes__default['default'].string,

    /**
     * The CSS class name to be placed on the wrapping element
     */
    wrapperClassName: PropTypes__default['default'].string
  };
  Checkbox.defaultProps = {
    onChange: function onChange() {},
    indeterminate: false
  };
  Checkbox.displayName = 'Checkbox';

  var prefix$2s = settings_1.prefix;

  function CodeSnippetSkeleton(_ref) {
    var _cx;

    var containerClassName = _ref.className,
        _ref$type = _ref.type,
        type = _ref$type === void 0 ? 'single' : _ref$type,
        rest = _objectWithoutProperties$2(_ref, ["className", "type"]);

    var className = classnames(containerClassName, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2s, "--snippet"), true), _defineProperty$2(_cx, "".concat(prefix$2s, "--skeleton"), true), _defineProperty$2(_cx, "".concat(prefix$2s, "--snippet--single"), type === 'single'), _defineProperty$2(_cx, "".concat(prefix$2s, "--snippet--multi"), type === 'multi'), _cx));

    if (type === 'single') {
      return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
        className: className
      }, rest), /*#__PURE__*/React__default['default'].createElement("div", {
        className: "".concat(prefix$2s, "--snippet-container")
      }, /*#__PURE__*/React__default['default'].createElement("span", null)));
    }

    if (type === 'multi') {
      return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
        className: className
      }, rest), /*#__PURE__*/React__default['default'].createElement("div", {
        className: "".concat(prefix$2s, "--snippet-container")
      }, /*#__PURE__*/React__default['default'].createElement("span", null), /*#__PURE__*/React__default['default'].createElement("span", null), /*#__PURE__*/React__default['default'].createElement("span", null)));
    }
  }

  CodeSnippetSkeleton.propTypes = {
    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * The type of the code snippet, including single or multi
     */
    type: PropTypes__default['default'].oneOf(['single', 'multi'])
  };

  /* eslint-disable require-jsdoc, valid-jsdoc */
  var MapShim = function () {
    if (typeof Map !== 'undefined') {
      return Map;
    }
    /**
     * Returns index in provided array that matches the specified key.
     *
     * @param {Array<Array>} arr
     * @param {*} key
     * @returns {number}
     */


    function getIndex(arr, key) {
      var result = -1;
      arr.some(function (entry, index) {
        if (entry[0] === key) {
          result = index;
          return true;
        }

        return false;
      });
      return result;
    }

    return (
      /** @class */
      function () {
        function class_1() {
          this.__entries__ = [];
        }

        Object.defineProperty(class_1.prototype, "size", {
          /**
           * @returns {boolean}
           */
          get: function get() {
            return this.__entries__.length;
          },
          enumerable: true,
          configurable: true
        });
        /**
         * @param {*} key
         * @returns {*}
         */

        class_1.prototype.get = function (key) {
          var index = getIndex(this.__entries__, key);
          var entry = this.__entries__[index];
          return entry && entry[1];
        };
        /**
         * @param {*} key
         * @param {*} value
         * @returns {void}
         */


        class_1.prototype.set = function (key, value) {
          var index = getIndex(this.__entries__, key);

          if (~index) {
            this.__entries__[index][1] = value;
          } else {
            this.__entries__.push([key, value]);
          }
        };
        /**
         * @param {*} key
         * @returns {void}
         */


        class_1.prototype.delete = function (key) {
          var entries = this.__entries__;
          var index = getIndex(entries, key);

          if (~index) {
            entries.splice(index, 1);
          }
        };
        /**
         * @param {*} key
         * @returns {void}
         */


        class_1.prototype.has = function (key) {
          return !!~getIndex(this.__entries__, key);
        };
        /**
         * @returns {void}
         */


        class_1.prototype.clear = function () {
          this.__entries__.splice(0);
        };
        /**
         * @param {Function} callback
         * @param {*} [ctx=null]
         * @returns {void}
         */


        class_1.prototype.forEach = function (callback, ctx) {
          if (ctx === void 0) {
            ctx = null;
          }

          for (var _i = 0, _a = this.__entries__; _i < _a.length; _i++) {
            var entry = _a[_i];
            callback.call(ctx, entry[1], entry[0]);
          }
        };

        return class_1;
      }()
    );
  }();
  /**
   * Detects whether window and document objects are available in current environment.
   */


  var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined' && window.document === document; // Returns global object of a current environment.

  var global$1 = function () {
    if (typeof global !== 'undefined' && global.Math === Math) {
      return global;
    }

    if (typeof self !== 'undefined' && self.Math === Math) {
      return self;
    }

    if (typeof window !== 'undefined' && window.Math === Math) {
      return window;
    } // eslint-disable-next-line no-new-func


    return Function('return this')();
  }();
  /**
   * A shim for the requestAnimationFrame which falls back to the setTimeout if
   * first one is not supported.
   *
   * @returns {number} Requests' identifier.
   */


  var requestAnimationFrame$1 = function () {
    if (typeof requestAnimationFrame === 'function') {
      // It's required to use a bounded function because IE sometimes throws
      // an "Invalid calling object" error if rAF is invoked without the global
      // object on the left hand side.
      return requestAnimationFrame.bind(global$1);
    }

    return function (callback) {
      return setTimeout(function () {
        return callback(Date.now());
      }, 1000 / 60);
    };
  }(); // Defines minimum timeout before adding a trailing call.


  var trailingTimeout = 2;
  /**
   * Creates a wrapper function which ensures that provided callback will be
   * invoked only once during the specified delay period.
   *
   * @param {Function} callback - Function to be invoked after the delay period.
   * @param {number} delay - Delay after which to invoke callback.
   * @returns {Function}
   */

  function throttle$1(callback, delay) {
    var leadingCall = false,
        trailingCall = false,
        lastCallTime = 0;
    /**
     * Invokes the original callback function and schedules new invocation if
     * the "proxy" was called during current request.
     *
     * @returns {void}
     */

    function resolvePending() {
      if (leadingCall) {
        leadingCall = false;
        callback();
      }

      if (trailingCall) {
        proxy();
      }
    }
    /**
     * Callback invoked after the specified delay. It will further postpone
     * invocation of the original function delegating it to the
     * requestAnimationFrame.
     *
     * @returns {void}
     */


    function timeoutCallback() {
      requestAnimationFrame$1(resolvePending);
    }
    /**
     * Schedules invocation of the original function.
     *
     * @returns {void}
     */


    function proxy() {
      var timeStamp = Date.now();

      if (leadingCall) {
        // Reject immediately following calls.
        if (timeStamp - lastCallTime < trailingTimeout) {
          return;
        } // Schedule new call to be in invoked when the pending one is resolved.
        // This is important for "transitions" which never actually start
        // immediately so there is a chance that we might miss one if change
        // happens amids the pending invocation.


        trailingCall = true;
      } else {
        leadingCall = true;
        trailingCall = false;
        setTimeout(timeoutCallback, delay);
      }

      lastCallTime = timeStamp;
    }

    return proxy;
  } // Minimum delay before invoking the update of observers.


  var REFRESH_DELAY = 20; // A list of substrings of CSS properties used to find transition events that
  // might affect dimensions of observed elements.

  var transitionKeys = ['top', 'right', 'bottom', 'left', 'width', 'height', 'size', 'weight']; // Check if MutationObserver is available.

  var mutationObserverSupported = typeof MutationObserver !== 'undefined';
  /**
   * Singleton controller class which handles updates of ResizeObserver instances.
   */

  var ResizeObserverController =
  /** @class */
  function () {
    /**
     * Creates a new instance of ResizeObserverController.
     *
     * @private
     */
    function ResizeObserverController() {
      /**
       * Indicates whether DOM listeners have been added.
       *
       * @private {boolean}
       */
      this.connected_ = false;
      /**
       * Tells that controller has subscribed for Mutation Events.
       *
       * @private {boolean}
       */

      this.mutationEventsAdded_ = false;
      /**
       * Keeps reference to the instance of MutationObserver.
       *
       * @private {MutationObserver}
       */

      this.mutationsObserver_ = null;
      /**
       * A list of connected observers.
       *
       * @private {Array<ResizeObserverSPI>}
       */

      this.observers_ = [];
      this.onTransitionEnd_ = this.onTransitionEnd_.bind(this);
      this.refresh = throttle$1(this.refresh.bind(this), REFRESH_DELAY);
    }
    /**
     * Adds observer to observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be added.
     * @returns {void}
     */


    ResizeObserverController.prototype.addObserver = function (observer) {
      if (!~this.observers_.indexOf(observer)) {
        this.observers_.push(observer);
      } // Add listeners if they haven't been added yet.


      if (!this.connected_) {
        this.connect_();
      }
    };
    /**
     * Removes observer from observers list.
     *
     * @param {ResizeObserverSPI} observer - Observer to be removed.
     * @returns {void}
     */


    ResizeObserverController.prototype.removeObserver = function (observer) {
      var observers = this.observers_;
      var index = observers.indexOf(observer); // Remove observer if it's present in registry.

      if (~index) {
        observers.splice(index, 1);
      } // Remove listeners if controller has no connected observers.


      if (!observers.length && this.connected_) {
        this.disconnect_();
      }
    };
    /**
     * Invokes the update of observers. It will continue running updates insofar
     * it detects changes.
     *
     * @returns {void}
     */


    ResizeObserverController.prototype.refresh = function () {
      var changesDetected = this.updateObservers_(); // Continue running updates if changes have been detected as there might
      // be future ones caused by CSS transitions.

      if (changesDetected) {
        this.refresh();
      }
    };
    /**
     * Updates every observer from observers list and notifies them of queued
     * entries.
     *
     * @private
     * @returns {boolean} Returns "true" if any observer has detected changes in
     *      dimensions of it's elements.
     */


    ResizeObserverController.prototype.updateObservers_ = function () {
      // Collect observers that have active observations.
      var activeObservers = this.observers_.filter(function (observer) {
        return observer.gatherActive(), observer.hasActive();
      }); // Deliver notifications in a separate cycle in order to avoid any
      // collisions between observers, e.g. when multiple instances of
      // ResizeObserver are tracking the same element and the callback of one
      // of them changes content dimensions of the observed target. Sometimes
      // this may result in notifications being blocked for the rest of observers.

      activeObservers.forEach(function (observer) {
        return observer.broadcastActive();
      });
      return activeObservers.length > 0;
    };
    /**
     * Initializes DOM listeners.
     *
     * @private
     * @returns {void}
     */


    ResizeObserverController.prototype.connect_ = function () {
      // Do nothing if running in a non-browser environment or if listeners
      // have been already added.
      if (!isBrowser || this.connected_) {
        return;
      } // Subscription to the "Transitionend" event is used as a workaround for
      // delayed transitions. This way it's possible to capture at least the
      // final state of an element.


      document.addEventListener('transitionend', this.onTransitionEnd_);
      window.addEventListener('resize', this.refresh);

      if (mutationObserverSupported) {
        this.mutationsObserver_ = new MutationObserver(this.refresh);
        this.mutationsObserver_.observe(document, {
          attributes: true,
          childList: true,
          characterData: true,
          subtree: true
        });
      } else {
        document.addEventListener('DOMSubtreeModified', this.refresh);
        this.mutationEventsAdded_ = true;
      }

      this.connected_ = true;
    };
    /**
     * Removes DOM listeners.
     *
     * @private
     * @returns {void}
     */


    ResizeObserverController.prototype.disconnect_ = function () {
      // Do nothing if running in a non-browser environment or if listeners
      // have been already removed.
      if (!isBrowser || !this.connected_) {
        return;
      }

      document.removeEventListener('transitionend', this.onTransitionEnd_);
      window.removeEventListener('resize', this.refresh);

      if (this.mutationsObserver_) {
        this.mutationsObserver_.disconnect();
      }

      if (this.mutationEventsAdded_) {
        document.removeEventListener('DOMSubtreeModified', this.refresh);
      }

      this.mutationsObserver_ = null;
      this.mutationEventsAdded_ = false;
      this.connected_ = false;
    };
    /**
     * "Transitionend" event handler.
     *
     * @private
     * @param {TransitionEvent} event
     * @returns {void}
     */


    ResizeObserverController.prototype.onTransitionEnd_ = function (_a) {
      var _b = _a.propertyName,
          propertyName = _b === void 0 ? '' : _b; // Detect whether transition may affect dimensions of an element.

      var isReflowProperty = transitionKeys.some(function (key) {
        return !!~propertyName.indexOf(key);
      });

      if (isReflowProperty) {
        this.refresh();
      }
    };
    /**
     * Returns instance of the ResizeObserverController.
     *
     * @returns {ResizeObserverController}
     */


    ResizeObserverController.getInstance = function () {
      if (!this.instance_) {
        this.instance_ = new ResizeObserverController();
      }

      return this.instance_;
    };
    /**
     * Holds reference to the controller's instance.
     *
     * @private {ResizeObserverController}
     */


    ResizeObserverController.instance_ = null;
    return ResizeObserverController;
  }();
  /**
   * Defines non-writable/enumerable properties of the provided target object.
   *
   * @param {Object} target - Object for which to define properties.
   * @param {Object} props - Properties to be defined.
   * @returns {Object} Target object.
   */


  var defineConfigurable = function defineConfigurable(target, props) {
    for (var _i = 0, _a = Object.keys(props); _i < _a.length; _i++) {
      var key = _a[_i];
      Object.defineProperty(target, key, {
        value: props[key],
        enumerable: false,
        writable: false,
        configurable: true
      });
    }

    return target;
  };
  /**
   * Returns the global object associated with provided element.
   *
   * @param {Object} target
   * @returns {Object}
   */


  var getWindowOf = function getWindowOf(target) {
    // Assume that the element is an instance of Node, which means that it
    // has the "ownerDocument" property from which we can retrieve a
    // corresponding global object.
    var ownerGlobal = target && target.ownerDocument && target.ownerDocument.defaultView; // Return the local global object if it's not possible extract one from
    // provided element.

    return ownerGlobal || global$1;
  }; // Placeholder of an empty content rectangle.


  var emptyRect = createRectInit(0, 0, 0, 0);
  /**
   * Converts provided string to a number.
   *
   * @param {number|string} value
   * @returns {number}
   */

  function toFloat(value) {
    return parseFloat(value) || 0;
  }
  /**
   * Extracts borders size from provided styles.
   *
   * @param {CSSStyleDeclaration} styles
   * @param {...string} positions - Borders positions (top, right, ...)
   * @returns {number}
   */


  function getBordersSize(styles) {
    var positions = [];

    for (var _i = 1; _i < arguments.length; _i++) {
      positions[_i - 1] = arguments[_i];
    }

    return positions.reduce(function (size, position) {
      var value = styles['border-' + position + '-width'];
      return size + toFloat(value);
    }, 0);
  }
  /**
   * Extracts paddings sizes from provided styles.
   *
   * @param {CSSStyleDeclaration} styles
   * @returns {Object} Paddings box.
   */


  function getPaddings(styles) {
    var positions = ['top', 'right', 'bottom', 'left'];
    var paddings = {};

    for (var _i = 0, positions_1 = positions; _i < positions_1.length; _i++) {
      var position = positions_1[_i];
      var value = styles['padding-' + position];
      paddings[position] = toFloat(value);
    }

    return paddings;
  }
  /**
   * Calculates content rectangle of provided SVG element.
   *
   * @param {SVGGraphicsElement} target - Element content rectangle of which needs
   *      to be calculated.
   * @returns {DOMRectInit}
   */


  function getSVGContentRect(target) {
    var bbox = target.getBBox();
    return createRectInit(0, 0, bbox.width, bbox.height);
  }
  /**
   * Calculates content rectangle of provided HTMLElement.
   *
   * @param {HTMLElement} target - Element for which to calculate the content rectangle.
   * @returns {DOMRectInit}
   */


  function getHTMLElementContentRect(target) {
    // Client width & height properties can't be
    // used exclusively as they provide rounded values.
    var clientWidth = target.clientWidth,
        clientHeight = target.clientHeight; // By this condition we can catch all non-replaced inline, hidden and
    // detached elements. Though elements with width & height properties less
    // than 0.5 will be discarded as well.
    //
    // Without it we would need to implement separate methods for each of
    // those cases and it's not possible to perform a precise and performance
    // effective test for hidden elements. E.g. even jQuery's ':visible' filter
    // gives wrong results for elements with width & height less than 0.5.

    if (!clientWidth && !clientHeight) {
      return emptyRect;
    }

    var styles = getWindowOf(target).getComputedStyle(target);
    var paddings = getPaddings(styles);
    var horizPad = paddings.left + paddings.right;
    var vertPad = paddings.top + paddings.bottom; // Computed styles of width & height are being used because they are the
    // only dimensions available to JS that contain non-rounded values. It could
    // be possible to utilize the getBoundingClientRect if only it's data wasn't
    // affected by CSS transformations let alone paddings, borders and scroll bars.

    var width = toFloat(styles.width),
        height = toFloat(styles.height); // Width & height include paddings and borders when the 'border-box' box
    // model is applied (except for IE).

    if (styles.boxSizing === 'border-box') {
      // Following conditions are required to handle Internet Explorer which
      // doesn't include paddings and borders to computed CSS dimensions.
      //
      // We can say that if CSS dimensions + paddings are equal to the "client"
      // properties then it's either IE, and thus we don't need to subtract
      // anything, or an element merely doesn't have paddings/borders styles.
      if (Math.round(width + horizPad) !== clientWidth) {
        width -= getBordersSize(styles, 'left', 'right') + horizPad;
      }

      if (Math.round(height + vertPad) !== clientHeight) {
        height -= getBordersSize(styles, 'top', 'bottom') + vertPad;
      }
    } // Following steps can't be applied to the document's root element as its
    // client[Width/Height] properties represent viewport area of the window.
    // Besides, it's as well not necessary as the <html> itself neither has
    // rendered scroll bars nor it can be clipped.


    if (!isDocumentElement(target)) {
      // In some browsers (only in Firefox, actually) CSS width & height
      // include scroll bars size which can be removed at this step as scroll
      // bars are the only difference between rounded dimensions + paddings
      // and "client" properties, though that is not always true in Chrome.
      var vertScrollbar = Math.round(width + horizPad) - clientWidth;
      var horizScrollbar = Math.round(height + vertPad) - clientHeight; // Chrome has a rather weird rounding of "client" properties.
      // E.g. for an element with content width of 314.2px it sometimes gives
      // the client width of 315px and for the width of 314.7px it may give
      // 314px. And it doesn't happen all the time. So just ignore this delta
      // as a non-relevant.

      if (Math.abs(vertScrollbar) !== 1) {
        width -= vertScrollbar;
      }

      if (Math.abs(horizScrollbar) !== 1) {
        height -= horizScrollbar;
      }
    }

    return createRectInit(paddings.left, paddings.top, width, height);
  }
  /**
   * Checks whether provided element is an instance of the SVGGraphicsElement.
   *
   * @param {Element} target - Element to be checked.
   * @returns {boolean}
   */


  var isSVGGraphicsElement = function () {
    // Some browsers, namely IE and Edge, don't have the SVGGraphicsElement
    // interface.
    if (typeof SVGGraphicsElement !== 'undefined') {
      return function (target) {
        return target instanceof getWindowOf(target).SVGGraphicsElement;
      };
    } // If it's so, then check that element is at least an instance of the
    // SVGElement and that it has the "getBBox" method.
    // eslint-disable-next-line no-extra-parens


    return function (target) {
      return target instanceof getWindowOf(target).SVGElement && typeof target.getBBox === 'function';
    };
  }();
  /**
   * Checks whether provided element is a document element (<html>).
   *
   * @param {Element} target - Element to be checked.
   * @returns {boolean}
   */


  function isDocumentElement(target) {
    return target === getWindowOf(target).document.documentElement;
  }
  /**
   * Calculates an appropriate content rectangle for provided html or svg element.
   *
   * @param {Element} target - Element content rectangle of which needs to be calculated.
   * @returns {DOMRectInit}
   */


  function getContentRect(target) {
    if (!isBrowser) {
      return emptyRect;
    }

    if (isSVGGraphicsElement(target)) {
      return getSVGContentRect(target);
    }

    return getHTMLElementContentRect(target);
  }
  /**
   * Creates rectangle with an interface of the DOMRectReadOnly.
   * Spec: https://drafts.fxtf.org/geometry/#domrectreadonly
   *
   * @param {DOMRectInit} rectInit - Object with rectangle's x/y coordinates and dimensions.
   * @returns {DOMRectReadOnly}
   */


  function createReadOnlyRect(_a) {
    var x = _a.x,
        y = _a.y,
        width = _a.width,
        height = _a.height; // If DOMRectReadOnly is available use it as a prototype for the rectangle.

    var Constr = typeof DOMRectReadOnly !== 'undefined' ? DOMRectReadOnly : Object;
    var rect = Object.create(Constr.prototype); // Rectangle's properties are not writable and non-enumerable.

    defineConfigurable(rect, {
      x: x,
      y: y,
      width: width,
      height: height,
      top: y,
      right: x + width,
      bottom: height + y,
      left: x
    });
    return rect;
  }
  /**
   * Creates DOMRectInit object based on the provided dimensions and the x/y coordinates.
   * Spec: https://drafts.fxtf.org/geometry/#dictdef-domrectinit
   *
   * @param {number} x - X coordinate.
   * @param {number} y - Y coordinate.
   * @param {number} width - Rectangle's width.
   * @param {number} height - Rectangle's height.
   * @returns {DOMRectInit}
   */


  function createRectInit(x, y, width, height) {
    return {
      x: x,
      y: y,
      width: width,
      height: height
    };
  }
  /**
   * Class that is responsible for computations of the content rectangle of
   * provided DOM element and for keeping track of it's changes.
   */


  var ResizeObservation =
  /** @class */
  function () {
    /**
     * Creates an instance of ResizeObservation.
     *
     * @param {Element} target - Element to be observed.
     */
    function ResizeObservation(target) {
      /**
       * Broadcasted width of content rectangle.
       *
       * @type {number}
       */
      this.broadcastWidth = 0;
      /**
       * Broadcasted height of content rectangle.
       *
       * @type {number}
       */

      this.broadcastHeight = 0;
      /**
       * Reference to the last observed content rectangle.
       *
       * @private {DOMRectInit}
       */

      this.contentRect_ = createRectInit(0, 0, 0, 0);
      this.target = target;
    }
    /**
     * Updates content rectangle and tells whether it's width or height properties
     * have changed since the last broadcast.
     *
     * @returns {boolean}
     */


    ResizeObservation.prototype.isActive = function () {
      var rect = getContentRect(this.target);
      this.contentRect_ = rect;
      return rect.width !== this.broadcastWidth || rect.height !== this.broadcastHeight;
    };
    /**
     * Updates 'broadcastWidth' and 'broadcastHeight' properties with a data
     * from the corresponding properties of the last observed content rectangle.
     *
     * @returns {DOMRectInit} Last observed content rectangle.
     */


    ResizeObservation.prototype.broadcastRect = function () {
      var rect = this.contentRect_;
      this.broadcastWidth = rect.width;
      this.broadcastHeight = rect.height;
      return rect;
    };

    return ResizeObservation;
  }();

  var ResizeObserverEntry =
  /** @class */
  function () {
    /**
     * Creates an instance of ResizeObserverEntry.
     *
     * @param {Element} target - Element that is being observed.
     * @param {DOMRectInit} rectInit - Data of the element's content rectangle.
     */
    function ResizeObserverEntry(target, rectInit) {
      var contentRect = createReadOnlyRect(rectInit); // According to the specification following properties are not writable
      // and are also not enumerable in the native implementation.
      //
      // Property accessors are not being used as they'd require to define a
      // private WeakMap storage which may cause memory leaks in browsers that
      // don't support this type of collections.

      defineConfigurable(this, {
        target: target,
        contentRect: contentRect
      });
    }

    return ResizeObserverEntry;
  }();

  var ResizeObserverSPI =
  /** @class */
  function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback function that is invoked
     *      when one of the observed elements changes it's content dimensions.
     * @param {ResizeObserverController} controller - Controller instance which
     *      is responsible for the updates of observer.
     * @param {ResizeObserver} callbackCtx - Reference to the public
     *      ResizeObserver instance which will be passed to callback function.
     */
    function ResizeObserverSPI(callback, controller, callbackCtx) {
      /**
       * Collection of resize observations that have detected changes in dimensions
       * of elements.
       *
       * @private {Array<ResizeObservation>}
       */
      this.activeObservations_ = [];
      /**
       * Registry of the ResizeObservation instances.
       *
       * @private {Map<Element, ResizeObservation>}
       */

      this.observations_ = new MapShim();

      if (typeof callback !== 'function') {
        throw new TypeError('The callback provided as parameter 1 is not a function.');
      }

      this.callback_ = callback;
      this.controller_ = controller;
      this.callbackCtx_ = callbackCtx;
    }
    /**
     * Starts observing provided element.
     *
     * @param {Element} target - Element to be observed.
     * @returns {void}
     */


    ResizeObserverSPI.prototype.observe = function (target) {
      if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
      } // Do nothing if current environment doesn't have the Element interface.


      if (typeof Element === 'undefined' || !(Element instanceof Object)) {
        return;
      }

      if (!(target instanceof getWindowOf(target).Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
      }

      var observations = this.observations_; // Do nothing if element is already being observed.

      if (observations.has(target)) {
        return;
      }

      observations.set(target, new ResizeObservation(target));
      this.controller_.addObserver(this); // Force the update of observations.

      this.controller_.refresh();
    };
    /**
     * Stops observing provided element.
     *
     * @param {Element} target - Element to stop observing.
     * @returns {void}
     */


    ResizeObserverSPI.prototype.unobserve = function (target) {
      if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
      } // Do nothing if current environment doesn't have the Element interface.


      if (typeof Element === 'undefined' || !(Element instanceof Object)) {
        return;
      }

      if (!(target instanceof getWindowOf(target).Element)) {
        throw new TypeError('parameter 1 is not of type "Element".');
      }

      var observations = this.observations_; // Do nothing if element is not being observed.

      if (!observations.has(target)) {
        return;
      }

      observations.delete(target);

      if (!observations.size) {
        this.controller_.removeObserver(this);
      }
    };
    /**
     * Stops observing all elements.
     *
     * @returns {void}
     */


    ResizeObserverSPI.prototype.disconnect = function () {
      this.clearActive();
      this.observations_.clear();
      this.controller_.removeObserver(this);
    };
    /**
     * Collects observation instances the associated element of which has changed
     * it's content rectangle.
     *
     * @returns {void}
     */


    ResizeObserverSPI.prototype.gatherActive = function () {
      var _this = this;

      this.clearActive();
      this.observations_.forEach(function (observation) {
        if (observation.isActive()) {
          _this.activeObservations_.push(observation);
        }
      });
    };
    /**
     * Invokes initial callback function with a list of ResizeObserverEntry
     * instances collected from active resize observations.
     *
     * @returns {void}
     */


    ResizeObserverSPI.prototype.broadcastActive = function () {
      // Do nothing if observer doesn't have active observations.
      if (!this.hasActive()) {
        return;
      }

      var ctx = this.callbackCtx_; // Create ResizeObserverEntry instance for every active observation.

      var entries = this.activeObservations_.map(function (observation) {
        return new ResizeObserverEntry(observation.target, observation.broadcastRect());
      });
      this.callback_.call(ctx, entries, ctx);
      this.clearActive();
    };
    /**
     * Clears the collection of active observations.
     *
     * @returns {void}
     */


    ResizeObserverSPI.prototype.clearActive = function () {
      this.activeObservations_.splice(0);
    };
    /**
     * Tells whether observer has active observations.
     *
     * @returns {boolean}
     */


    ResizeObserverSPI.prototype.hasActive = function () {
      return this.activeObservations_.length > 0;
    };

    return ResizeObserverSPI;
  }(); // Registry of internal observers. If WeakMap is not available use current shim
  // for the Map collection as it has all required methods and because WeakMap
  // can't be fully polyfilled anyway.


  var observers = typeof WeakMap !== 'undefined' ? new WeakMap() : new MapShim();
  /**
   * ResizeObserver API. Encapsulates the ResizeObserver SPI implementation
   * exposing only those methods and properties that are defined in the spec.
   */

  var ResizeObserver$1 =
  /** @class */
  function () {
    /**
     * Creates a new instance of ResizeObserver.
     *
     * @param {ResizeObserverCallback} callback - Callback that is invoked when
     *      dimensions of the observed elements change.
     */
    function ResizeObserver(callback) {
      if (!(this instanceof ResizeObserver)) {
        throw new TypeError('Cannot call a class as a function.');
      }

      if (!arguments.length) {
        throw new TypeError('1 argument required, but only 0 present.');
      }

      var controller = ResizeObserverController.getInstance();
      var observer = new ResizeObserverSPI(callback, controller, this);
      observers.set(this, observer);
    }

    return ResizeObserver;
  }(); // Expose public methods of ResizeObserver.


  ['observe', 'unobserve', 'disconnect'].forEach(function (method) {
    ResizeObserver$1.prototype[method] = function () {
      var _a;

      return (_a = observers.get(this))[method].apply(_a, arguments);
    };
  });

  var index$1 = function () {
    // Export existing implementation if available.
    if (typeof global$1.ResizeObserver !== 'undefined') {
      return global$1.ResizeObserver;
    }

    return ResizeObserver$1;
  }();

  var ResizeObserver_es = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': index$1
  });

  var require$$0 = /*@__PURE__*/getAugmentedNamespace(ResizeObserver_es);

  function _interopDefault$1(ex) {
    return ex && _typeof(ex) === 'object' && 'default' in ex ? ex['default'] : ex;
  }

  var ResizeObserver = _interopDefault$1(require$$0);

  function _extends$1() {
    _extends$1 = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends$1.apply(this, arguments);
  }

  function index(_temp) {
    var _ref = _temp === void 0 ? {} : _temp,
        ref = _ref.ref,
        onResize = _ref.onResize; // `defaultRef` Has to be non-conditionally declared here whether or not it'll
    // be used as that's how hooks work.
    // @see https://reactjs.org/docs/hooks-rules.html#explanation


    var defaultRef = React__default['default'].useRef(null);
    ref = ref || defaultRef;

    var _useState = React__default['default'].useState({
      width: undefined,
      height: undefined
    }),
        size = _useState[0],
        setSize = _useState[1]; // Using a ref to track the previous width / height to avoid unnecessary renders


    var previous = React__default['default'].useRef({
      width: undefined,
      height: undefined
    });
    React__default['default'].useEffect(function () {
      if (_typeof(ref) !== "object" || ref === null || !(ref.current instanceof Element)) {
        return;
      }

      var element = ref.current;
      var resizeObserver = new ResizeObserver(function (entries) {
        if (!Array.isArray(entries)) {
          return;
        } // Since we only observe the one element, we don't need to loop over the
        // array


        if (!entries.length) {
          return;
        }

        var entry = entries[0]; // `Math.round` is in line with how CSS resolves sub-pixel values

        var newWidth = Math.round(entry.contentRect.width);
        var newHeight = Math.round(entry.contentRect.height);

        if (previous.current.width !== newWidth || previous.current.height !== newHeight) {
          var newSize = {
            width: newWidth,
            height: newHeight
          };

          if (onResize) {
            onResize(newSize);
          } else {
            previous.current.width = newWidth;
            previous.current.height = newHeight;
            setSize(newSize);
          }
        }
      });
      resizeObserver.observe(element);
      return function () {
        return resizeObserver.unobserve(element);
      };
    }, [ref, onResize]);
    return React__default['default'].useMemo(function () {
      return _extends$1({
        ref: ref
      }, size);
    }, [ref, size ? size.width : null, size ? size.height : null]);
  }

  var polyfilled = index;

  var prefix$2r = settings_1.prefix;
  function Copy(_ref) {
    var _classnames;

    var children = _ref.children,
        className = _ref.className,
        feedback = _ref.feedback,
        feedbackTimeout = _ref.feedbackTimeout,
        onAnimationEnd = _ref.onAnimationEnd,
        onClick = _ref.onClick,
        other = _objectWithoutProperties$2(_ref, ["children", "className", "feedback", "feedbackTimeout", "onAnimationEnd", "onClick"]);

    var _useState = React.useState(''),
        _useState2 = _slicedToArray(_useState, 2),
        animation = _useState2[0],
        setAnimation = _useState2[1];

    var classNames = classnames(className, "".concat(prefix$2r, "--copy"), (_classnames = {}, _defineProperty$2(_classnames, "".concat(prefix$2r, "--copy-btn--animating"), animation), _defineProperty$2(_classnames, "".concat(prefix$2r, "--copy-btn--").concat(animation), animation), _classnames)); // eslint-disable-next-line react-hooks/exhaustive-deps

    var handleFadeOut = React.useCallback(lodash_debounce(function () {
      setAnimation('fade-out');
    }, feedbackTimeout), [feedbackTimeout]);
    var handleClick = React.useCallback(function () {
      setAnimation('fade-in');
      handleFadeOut();
    }, [handleFadeOut]);

    var handleAnimationEnd = function handleAnimationEnd(event) {
      if (event.animationName === 'hide-feedback') {
        setAnimation('');
      }
    };

    React.useEffect(function () {
      return function () {
        handleFadeOut.cancel();
      };
    }, [handleFadeOut]);
    return /*#__PURE__*/React__default['default'].createElement("button", _extends$3({
      type: "button",
      className: classNames,
      onClick: composeEventHandlers([onClick, handleClick]),
      onAnimationEnd: composeEventHandlers([onAnimationEnd, handleAnimationEnd])
    }, other, {
      "aria-live": "polite",
      "aria-label": !children && (animation ? feedback : other['aria-label']) || null
    }), children, animation ? feedback : other['aria-label'], /*#__PURE__*/React__default['default'].createElement("span", {
      "aria-hidden": "true",
      className: "".concat(prefix$2r, "--assistive-text ").concat(prefix$2r, "--copy-btn__feedback")
    }, feedback));
  }
  Copy.propTypes = {
    /**
     * Pass in content to be rendred in the underlying `<button>`
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the underlying `<button>`
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the string that is displayed when the button is clicked and the
     * content is copied
     */
    feedback: PropTypes__default['default'].string,

    /**
     * Specify the time it takes for the feedback message to timeout
     */
    feedbackTimeout: PropTypes__default['default'].number,

    /**
     * Specify an optional `onAnimationEnd` handler that is called when the underlying
     * animation ends
     */
    onAnimationEnd: PropTypes__default['default'].func,

    /**
     * Specify an optional `onClick` handler that is called when the underlying
     * `<button>` is clicked
     */
    onClick: PropTypes__default['default'].func
  };
  Copy.defaultProps = {
    feedback: 'Copied!',
    feedbackTimeout: 2000,
    onClick: function onClick() {}
  };

  var prefix$2q = settings_1.prefix;
  function CopyButton(_ref) {
    var iconDescription = _ref.iconDescription,
        className = _ref.className,
        other = _objectWithoutProperties$2(_ref, ["iconDescription", "className"]);

    return /*#__PURE__*/React__default['default'].createElement(Copy, _extends$3({
      className: classnames(className, "".concat(prefix$2q, "--copy-btn")),
      "aria-label": iconDescription,
      title: iconDescription
    }, other), /*#__PURE__*/React__default['default'].createElement(Copy16, {
      className: "".concat(prefix$2q, "--snippet__icon")
    }));
  }
  CopyButton.propTypes = {
    /**
     * Specify an optional className to be applied to the underlying `<button>`
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the string that is displayed when the button is clicked and the
     * content is copied
     */
    feedback: PropTypes__default['default'].string,

    /**
     * Specify the time it takes for the feedback message to timeout
     */
    feedbackTimeout: PropTypes__default['default'].number,

    /**
     * Provide a description for the icon representing the copy action that can
     * be read by screen readers
     */
    iconDescription: PropTypes__default['default'].string,

    /**
     * Specify an optional `onClick` handler that is called when the underlying
     * `<button>` is clicked
     */
    onClick: PropTypes__default['default'].func
  };
  CopyButton.defaultProps = {
    iconDescription: 'Copy to clipboard',
    feedback: 'Copied!',
    feedbackTimeout: 2000,
    onClick: function onClick() {}
  };

  var lastId = 0;
  function uniqueId() {
    var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';
    lastId++;
    return "".concat(prefix).concat(lastId);
  }

  var toggleSelection = function toggleSelection() {
    var selection = document.getSelection();

    if (!selection.rangeCount) {
      return function () {};
    }

    var active = document.activeElement;
    var ranges = [];

    for (var i = 0; i < selection.rangeCount; i++) {
      ranges.push(selection.getRangeAt(i));
    }

    switch (active.tagName.toUpperCase()) {
      // .toUpperCase handles XHTML
      case 'INPUT':
      case 'TEXTAREA':
        active.blur();
        break;

      default:
        active = null;
        break;
    }

    selection.removeAllRanges();
    return function () {
      selection.type === 'Caret' && selection.removeAllRanges();

      if (!selection.rangeCount) {
        ranges.forEach(function (range) {
          selection.addRange(range);
        });
      }

      active && active.focus();
    };
  };

  var clipboardToIE11Formatting = {
    "text/plain": "Text",
    "text/html": "Url",
    "default": "Text"
  };
  var defaultMessage = "Copy to clipboard: #{key}, Enter";

  function format(message) {
    var copyKey = (/mac os x/i.test(navigator.userAgent) ? "⌘" : "Ctrl") + "+C";
    return message.replace(/#{\s*key\s*}/g, copyKey);
  }

  function copy(text, options) {
    var debug,
        message,
        reselectPrevious,
        range,
        selection,
        mark,
        success = false;

    if (!options) {
      options = {};
    }

    debug = options.debug || false;

    try {
      reselectPrevious = toggleSelection();
      range = document.createRange();
      selection = document.getSelection();
      mark = document.createElement("span");
      mark.textContent = text; // reset user styles for span element

      mark.style.all = "unset"; // prevents scrolling to the end of the page

      mark.style.position = "fixed";
      mark.style.top = 0;
      mark.style.clip = "rect(0, 0, 0, 0)"; // used to preserve spaces and line breaks

      mark.style.whiteSpace = "pre"; // do not inherit user-select (it may be `none`)

      mark.style.webkitUserSelect = "text";
      mark.style.MozUserSelect = "text";
      mark.style.msUserSelect = "text";
      mark.style.userSelect = "text";
      mark.addEventListener("copy", function (e) {
        e.stopPropagation();

        if (options.format) {
          e.preventDefault();

          if (typeof e.clipboardData === "undefined") {
            // IE 11
            debug && console.warn("unable to use e.clipboardData");
            debug && console.warn("trying IE specific stuff");
            window.clipboardData.clearData();
            var format = clipboardToIE11Formatting[options.format] || clipboardToIE11Formatting["default"];
            window.clipboardData.setData(format, text);
          } else {
            // all other browsers
            e.clipboardData.clearData();
            e.clipboardData.setData(options.format, text);
          }
        }

        if (options.onCopy) {
          e.preventDefault();
          options.onCopy(e.clipboardData);
        }
      });
      document.body.appendChild(mark);
      range.selectNodeContents(mark);
      selection.addRange(range);
      var successful = document.execCommand("copy");

      if (!successful) {
        throw new Error("copy command was unsuccessful");
      }

      success = true;
    } catch (err) {
      debug && console.error("unable to copy using execCommand: ", err);
      debug && console.warn("trying IE specific stuff");

      try {
        window.clipboardData.setData(options.format || "text", text);
        options.onCopy && options.onCopy(window.clipboardData);
        success = true;
      } catch (err) {
        debug && console.error("unable to copy using clipboardData: ", err);
        debug && console.error("falling back to prompt");
        message = format("message" in options ? options.message : defaultMessage);
        window.prompt(message, text);
      }
    } finally {
      if (selection) {
        if (typeof selection.removeRange == "function") {
          selection.removeRange(range);
        } else {
          selection.removeAllRanges();
        }
      }

      if (mark) {
        document.body.removeChild(mark);
      }

      reselectPrevious();
    }

    return success;
  }

  var copyToClipboard = copy;

  var prefix$2p = settings_1.prefix;
  var rowHeightInPixels = 16;
  var defaultMaxCollapsedNumberOfRows = 15;
  var defaultMaxExpandedNumberOfRows = 0;
  var defaultMinCollapsedNumberOfRows = 3;
  var defaultMinExpandedNumberOfRows = 16;

  function CodeSnippet(_ref) {
    var _classNames;

    var className = _ref.className,
        type = _ref.type,
        children = _ref.children,
        disabled = _ref.disabled,
        feedback = _ref.feedback,
        feedbackTimeout = _ref.feedbackTimeout,
        onClick = _ref.onClick,
        ariaLabel = _ref.ariaLabel,
        copyLabel = _ref.copyLabel,
        copyButtonDescription = _ref.copyButtonDescription,
        light = _ref.light,
        showMoreText = _ref.showMoreText,
        showLessText = _ref.showLessText,
        hideCopyButton = _ref.hideCopyButton,
        wrapText = _ref.wrapText,
        _ref$maxCollapsedNumb = _ref.maxCollapsedNumberOfRows,
        maxCollapsedNumberOfRows = _ref$maxCollapsedNumb === void 0 ? defaultMaxCollapsedNumberOfRows : _ref$maxCollapsedNumb,
        _ref$maxExpandedNumbe = _ref.maxExpandedNumberOfRows,
        maxExpandedNumberOfRows = _ref$maxExpandedNumbe === void 0 ? defaultMaxExpandedNumberOfRows : _ref$maxExpandedNumbe,
        _ref$minCollapsedNumb = _ref.minCollapsedNumberOfRows,
        minCollapsedNumberOfRows = _ref$minCollapsedNumb === void 0 ? defaultMinCollapsedNumberOfRows : _ref$minCollapsedNumb,
        _ref$minExpandedNumbe = _ref.minExpandedNumberOfRows,
        minExpandedNumberOfRows = _ref$minExpandedNumbe === void 0 ? defaultMinExpandedNumberOfRows : _ref$minExpandedNumbe,
        rest = _objectWithoutProperties$2(_ref, ["className", "type", "children", "disabled", "feedback", "feedbackTimeout", "onClick", "ariaLabel", "copyLabel", "copyButtonDescription", "light", "showMoreText", "showLessText", "hideCopyButton", "wrapText", "maxCollapsedNumberOfRows", "maxExpandedNumberOfRows", "minCollapsedNumberOfRows", "minExpandedNumberOfRows"]);

    var _useState = React.useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        expandedCode = _useState2[0],
        setExpandedCode = _useState2[1];

    var _useState3 = React.useState(false),
        _useState4 = _slicedToArray(_useState3, 2),
        shouldShowMoreLessBtn = _useState4[0],
        setShouldShowMoreLessBtn = _useState4[1];

    var _useRef = React.useRef(uniqueId()),
        uid = _useRef.current;

    var codeContentRef = React.useRef();
    var codeContainerRef = React.useRef();

    var _useState5 = React.useState(false),
        _useState6 = _slicedToArray(_useState5, 2),
        hasLeftOverflow = _useState6[0],
        setHasLeftOverflow = _useState6[1];

    var _useState7 = React.useState(false),
        _useState8 = _slicedToArray(_useState7, 2),
        hasRightOverflow = _useState8[0],
        setHasRightOverflow = _useState8[1];

    var getCodeRef = React.useCallback(function () {
      if (type === 'single') {
        return codeContainerRef;
      }

      if (type === 'multi') {
        return codeContentRef;
      }
    }, [type]);
    var getCodeRefDimensions = React.useCallback(function () {
      var _getCodeRef$current = getCodeRef().current,
          codeClientWidth = _getCodeRef$current.clientWidth,
          codeScrollLeft = _getCodeRef$current.scrollLeft,
          codeScrollWidth = _getCodeRef$current.scrollWidth;
      return {
        horizontalOverflow: codeScrollWidth > codeClientWidth,
        codeClientWidth: codeClientWidth,
        codeScrollWidth: codeScrollWidth,
        codeScrollLeft: codeScrollLeft
      };
    }, [getCodeRef]);
    var handleScroll = React.useCallback(function () {
      if (type === 'inline' || type === 'single' && !(codeContainerRef !== null && codeContainerRef !== void 0 && codeContainerRef.current) || type === 'multi' && !(codeContentRef !== null && codeContentRef !== void 0 && codeContentRef.current)) {
        return;
      }

      var _getCodeRefDimensions = getCodeRefDimensions(),
          horizontalOverflow = _getCodeRefDimensions.horizontalOverflow,
          codeClientWidth = _getCodeRefDimensions.codeClientWidth,
          codeScrollWidth = _getCodeRefDimensions.codeScrollWidth,
          codeScrollLeft = _getCodeRefDimensions.codeScrollLeft;

      setHasLeftOverflow(horizontalOverflow && !!codeScrollLeft);
      setHasRightOverflow(horizontalOverflow && codeScrollLeft + codeClientWidth !== codeScrollWidth);
    }, [type, getCodeRefDimensions]);
    polyfilled({
      ref: getCodeRef(),
      onResize: function onResize() {
        if (codeContentRef !== null && codeContentRef !== void 0 && codeContentRef.current && type === 'multi') {
          var _codeContentRef$curre = codeContentRef.current.getBoundingClientRect(),
              height = _codeContentRef$curre.height;

          if (maxCollapsedNumberOfRows > 0 && (maxExpandedNumberOfRows <= 0 || maxExpandedNumberOfRows > maxCollapsedNumberOfRows) && height > maxCollapsedNumberOfRows * rowHeightInPixels) {
            setShouldShowMoreLessBtn(true);
          } else {
            setShouldShowMoreLessBtn(false);
          }

          if (expandedCode && minExpandedNumberOfRows > 0 && height <= minExpandedNumberOfRows * rowHeightInPixels) {
            setExpandedCode(false);
          }
        }

        if (codeContentRef !== null && codeContentRef !== void 0 && codeContentRef.current && type === 'multi' || codeContainerRef !== null && codeContainerRef !== void 0 && codeContainerRef.current && type === 'single') {
          lodash_debounce(handleScroll, 200);
        }
      }
    });
    React.useEffect(function () {
      handleScroll();
    }, [handleScroll]);

    var handleCopyClick = function handleCopyClick(evt) {
      copyToClipboard(children);

      if (onClick) {
        onClick(evt);
      }
    };

    var codeSnippetClasses = classnames(className, "".concat(prefix$2p, "--snippet"), (_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$2p, "--snippet--").concat(type), type), _defineProperty$2(_classNames, "".concat(prefix$2p, "--snippet--disabled"), type !== 'inline' && disabled), _defineProperty$2(_classNames, "".concat(prefix$2p, "--snippet--expand"), expandedCode), _defineProperty$2(_classNames, "".concat(prefix$2p, "--snippet--light"), light), _defineProperty$2(_classNames, "".concat(prefix$2p, "--snippet--no-copy"), hideCopyButton), _defineProperty$2(_classNames, "".concat(prefix$2p, "--snippet--wraptext"), wrapText), _classNames));
    var expandCodeBtnText = expandedCode ? showLessText : showMoreText;

    if (type === 'inline') {
      if (hideCopyButton) {
        return /*#__PURE__*/React__default['default'].createElement("span", {
          className: codeSnippetClasses
        }, /*#__PURE__*/React__default['default'].createElement("code", {
          id: uid
        }, children));
      }

      return /*#__PURE__*/React__default['default'].createElement(Copy, _extends$3({}, rest, {
        onClick: handleCopyClick,
        "aria-label": copyLabel || ariaLabel,
        "aria-describedby": uid,
        className: codeSnippetClasses,
        feedback: feedback,
        feedbackTimeout: feedbackTimeout
      }), /*#__PURE__*/React__default['default'].createElement("code", {
        id: uid
      }, children));
    }

    var containerStyle = {};

    if (type === 'multi') {
      var styles = {};

      if (expandedCode) {
        if (maxExpandedNumberOfRows > 0) {
          styles.maxHeight = maxExpandedNumberOfRows * rowHeightInPixels;
        }

        if (minExpandedNumberOfRows > 0) {
          styles.minHeight = minExpandedNumberOfRows * rowHeightInPixels;
        }
      } else {
        if (maxCollapsedNumberOfRows > 0) {
          styles.maxHeight = maxCollapsedNumberOfRows * rowHeightInPixels;
        }

        if (minCollapsedNumberOfRows > 0) {
          styles.minHeight = minCollapsedNumberOfRows * rowHeightInPixels;
        }
      }

      if (Object.keys(styles).length) {
        containerStyle.style = styles;
      }
    }

    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, rest, {
      className: codeSnippetClasses
    }), /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      ref: codeContainerRef,
      role: type === 'single' ? 'textbox' : null,
      tabIndex: type === 'single' && !disabled ? 0 : null,
      className: "".concat(prefix$2p, "--snippet-container"),
      "aria-label": ariaLabel || copyLabel || 'code-snippet',
      onScroll: type === 'single' && handleScroll || null
    }, containerStyle), /*#__PURE__*/React__default['default'].createElement("pre", {
      ref: codeContentRef,
      onScroll: type === 'multi' && handleScroll || null
    }, /*#__PURE__*/React__default['default'].createElement("code", null, children))), hasLeftOverflow && /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2p, "--snippet__overflow-indicator--left")
    }), hasRightOverflow && /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2p, "--snippet__overflow-indicator--right")
    }), !hideCopyButton && /*#__PURE__*/React__default['default'].createElement(CopyButton, {
      disabled: disabled,
      onClick: handleCopyClick,
      feedback: feedback,
      feedbackTimeout: feedbackTimeout,
      iconDescription: copyButtonDescription
    }), shouldShowMoreLessBtn && /*#__PURE__*/React__default['default'].createElement(Button, {
      kind: "ghost",
      size: "field",
      className: "".concat(prefix$2p, "--snippet-btn--expand"),
      disabled: disabled,
      onClick: function onClick() {
        return setExpandedCode(!expandedCode);
      }
    }, /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$2p, "--snippet-btn--text")
    }, expandCodeBtnText), /*#__PURE__*/React__default['default'].createElement(ChevronDown16, {
      "aria-label": expandCodeBtnText,
      className: "".concat(prefix$2p, "--icon-chevron--down ").concat(prefix$2p, "--snippet__icon"),
      name: "chevron--down",
      role: "img"
    })));
  }

  CodeSnippet.propTypes = {
    /**
     * Specify a label to be read by screen readers on the containing <textbox>
     * node
     */
    ariaLabel: PropTypes__default['default'].string,

    /**
     * Provide the content of your CodeSnippet as a string
     */
    children: PropTypes__default['default'].string,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the description for the Copy Button
     */
    copyButtonDescription: PropTypes__default['default'].string,

    /**
     * Specify a label to be read by screen readers on the containing <textbox>
     * node
     */
    copyLabel: PropTypes__default['default'].string,

    /**
     * Specify whether or not the CodeSnippet should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify the string displayed when the snippet is copied
     */
    feedback: PropTypes__default['default'].string,

    /**
     * Specify the time it takes for the feedback message to timeout
     */
    feedbackTimeout: PropTypes__default['default'].number,

    /**
     * Specify whether or not a copy button should be used/rendered.
     */
    hideCopyButton: PropTypes__default['default'].bool,

    /**
     * Specify whether you are using the light variant of the Code Snippet,
     * typically used for inline snippet to display an alternate color
     */
    light: PropTypes__default['default'].bool,

    /**
     * Specify the maximum number of rows to be shown when in collapsed view
     */
    maxCollapsedNumberOfRows: PropTypes__default['default'].number,

    /**
     * Specify the maximum number of rows to be shown when in expanded view
     */
    maxExpandedNumberOfRows: PropTypes__default['default'].number,

    /**
     * Specify the minimum number of rows to be shown when in collapsed view
     */
    minCollapsedNumberOfRows: PropTypes__default['default'].number,

    /**
     * Specify the minimum number of rows to be shown when in expanded view
     */
    minExpandedNumberOfRows: PropTypes__default['default'].number,

    /**
     * An optional handler to listen to the `onClick` even fired by the Copy
     * Button
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Specify a string that is displayed when the Code Snippet has been
     * interacted with to show more lines
     */
    showLessText: PropTypes__default['default'].string,

    /**
     * Specify a string that is displayed when the Code Snippet text is more
     * than 15 lines
     */
    showMoreText: PropTypes__default['default'].string,

    /**
     * Provide the type of Code Snippet
     */
    type: PropTypes__default['default'].oneOf(['single', 'inline', 'multi']),

    /**
     * Specify whether or not to wrap the text.
     */
    wrapText: PropTypes__default['default'].bool
  };
  CodeSnippet.defaultProps = {
    type: 'single',
    showMoreText: 'Show more',
    showLessText: 'Show less',
    wrapText: false
  };

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf(subClass, superClass);
  }

  var reactIs_development = createCommonjsModule(function (module, exports) {

    {
      (function () {

        Object.defineProperty(exports, '__esModule', {
          value: true
        }); // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
        // nor polyfill, then a plain number is used for performance.

        var hasSymbol = typeof Symbol === 'function' && Symbol.for;
        var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
        var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
        var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
        var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
        var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
        var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
        var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
        // (unstable) APIs that have been removed. Can we remove the symbols?

        var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
        var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
        var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
        var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
        var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
        var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
        var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
        var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
        var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;

        function isValidElementType(type) {
          return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
          type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || _typeof(type) === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE);
        }
        /**
         * Forked from fbjs/warning:
         * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
         *
         * Only change is we use console.warn instead of console.error,
         * and do nothing when 'console' is not supported.
         * This really simplifies the code.
         * ---
         * Similar to invariant but only logs a warning if the condition is not met.
         * This can be used to log issues in development environments in critical
         * paths. Removing the logging code for production environments will keep the
         * same logic and follow the same code paths.
         */


        var lowPriorityWarning = function lowPriorityWarning() {};

        {
          var printWarning = function printWarning(format) {
            for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }

            var argIndex = 0;
            var message = 'Warning: ' + format.replace(/%s/g, function () {
              return args[argIndex++];
            });

            if (typeof console !== 'undefined') {
              console.warn(message);
            }

            try {
              // --- Welcome to debugging React ---
              // This error was thrown as a convenience so that you can use this stack
              // to find the callsite that caused this warning to fire.
              throw new Error(message);
            } catch (x) {}
          };

          lowPriorityWarning = function lowPriorityWarning(condition, format) {
            if (format === undefined) {
              throw new Error('`lowPriorityWarning(condition, format, ...args)` requires a warning ' + 'message argument');
            }

            if (!condition) {
              for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
                args[_key2 - 2] = arguments[_key2];
              }

              printWarning.apply(undefined, [format].concat(args));
            }
          };
        }
        var lowPriorityWarning$1 = lowPriorityWarning;

        function typeOf(object) {
          if (_typeof(object) === 'object' && object !== null) {
            var $$typeof = object.$$typeof;

            switch ($$typeof) {
              case REACT_ELEMENT_TYPE:
                var type = object.type;

                switch (type) {
                  case REACT_ASYNC_MODE_TYPE:
                  case REACT_CONCURRENT_MODE_TYPE:
                  case REACT_FRAGMENT_TYPE:
                  case REACT_PROFILER_TYPE:
                  case REACT_STRICT_MODE_TYPE:
                  case REACT_SUSPENSE_TYPE:
                    return type;

                  default:
                    var $$typeofType = type && type.$$typeof;

                    switch ($$typeofType) {
                      case REACT_CONTEXT_TYPE:
                      case REACT_FORWARD_REF_TYPE:
                      case REACT_PROVIDER_TYPE:
                        return $$typeofType;

                      default:
                        return $$typeof;
                    }

                }

              case REACT_LAZY_TYPE:
              case REACT_MEMO_TYPE:
              case REACT_PORTAL_TYPE:
                return $$typeof;
            }
          }

          return undefined;
        } // AsyncMode is deprecated along with isAsyncMode


        var AsyncMode = REACT_ASYNC_MODE_TYPE;
        var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
        var ContextConsumer = REACT_CONTEXT_TYPE;
        var ContextProvider = REACT_PROVIDER_TYPE;
        var Element = REACT_ELEMENT_TYPE;
        var ForwardRef = REACT_FORWARD_REF_TYPE;
        var Fragment = REACT_FRAGMENT_TYPE;
        var Lazy = REACT_LAZY_TYPE;
        var Memo = REACT_MEMO_TYPE;
        var Portal = REACT_PORTAL_TYPE;
        var Profiler = REACT_PROFILER_TYPE;
        var StrictMode = REACT_STRICT_MODE_TYPE;
        var Suspense = REACT_SUSPENSE_TYPE;
        var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

        function isAsyncMode(object) {
          {
            if (!hasWarnedAboutDeprecatedIsAsyncMode) {
              hasWarnedAboutDeprecatedIsAsyncMode = true;
              lowPriorityWarning$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
            }
          }
          return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
        }

        function isConcurrentMode(object) {
          return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
        }

        function isContextConsumer(object) {
          return typeOf(object) === REACT_CONTEXT_TYPE;
        }

        function isContextProvider(object) {
          return typeOf(object) === REACT_PROVIDER_TYPE;
        }

        function isElement(object) {
          return _typeof(object) === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
        }

        function isForwardRef(object) {
          return typeOf(object) === REACT_FORWARD_REF_TYPE;
        }

        function isFragment(object) {
          return typeOf(object) === REACT_FRAGMENT_TYPE;
        }

        function isLazy(object) {
          return typeOf(object) === REACT_LAZY_TYPE;
        }

        function isMemo(object) {
          return typeOf(object) === REACT_MEMO_TYPE;
        }

        function isPortal(object) {
          return typeOf(object) === REACT_PORTAL_TYPE;
        }

        function isProfiler(object) {
          return typeOf(object) === REACT_PROFILER_TYPE;
        }

        function isStrictMode(object) {
          return typeOf(object) === REACT_STRICT_MODE_TYPE;
        }

        function isSuspense(object) {
          return typeOf(object) === REACT_SUSPENSE_TYPE;
        }

        exports.typeOf = typeOf;
        exports.AsyncMode = AsyncMode;
        exports.ConcurrentMode = ConcurrentMode;
        exports.ContextConsumer = ContextConsumer;
        exports.ContextProvider = ContextProvider;
        exports.Element = Element;
        exports.ForwardRef = ForwardRef;
        exports.Fragment = Fragment;
        exports.Lazy = Lazy;
        exports.Memo = Memo;
        exports.Portal = Portal;
        exports.Profiler = Profiler;
        exports.StrictMode = StrictMode;
        exports.Suspense = Suspense;
        exports.isValidElementType = isValidElementType;
        exports.isAsyncMode = isAsyncMode;
        exports.isConcurrentMode = isConcurrentMode;
        exports.isContextConsumer = isContextConsumer;
        exports.isContextProvider = isContextProvider;
        exports.isElement = isElement;
        exports.isForwardRef = isForwardRef;
        exports.isFragment = isFragment;
        exports.isLazy = isLazy;
        exports.isMemo = isMemo;
        exports.isPortal = isPortal;
        exports.isProfiler = isProfiler;
        exports.isStrictMode = isStrictMode;
        exports.isSuspense = isSuspense;
      })();
    }
  });

  var reactIs = createCommonjsModule(function (module) {

    {
      module.exports = reactIs_development;
    }
  });

  function t(t) {
    return "object" == _typeof(t) && null != t && 1 === t.nodeType;
  }

  function e(t, e) {
    return (!e || "hidden" !== t) && "visible" !== t && "clip" !== t;
  }

  function n(t, n) {
    if (t.clientHeight < t.scrollHeight || t.clientWidth < t.scrollWidth) {
      var r = getComputedStyle(t, null);
      return e(r.overflowY, n) || e(r.overflowX, n) || function (t) {
        var e = function (t) {
          if (!t.ownerDocument || !t.ownerDocument.defaultView) return null;

          try {
            return t.ownerDocument.defaultView.frameElement;
          } catch (t) {
            return null;
          }
        }(t);

        return !!e && (e.clientHeight < t.scrollHeight || e.clientWidth < t.scrollWidth);
      }(t);
    }

    return !1;
  }

  function r(t, e, n, r, i, o, l, d) {
    return o < t && l > e || o > t && l < e ? 0 : o <= t && d <= n || l >= e && d >= n ? o - t - r : l > e && d < n || o < t && d > n ? l - e + i : 0;
  }

  function computeScrollIntoView (e, i) {
    var o = window,
        l = i.scrollMode,
        d = i.block,
        u = i.inline,
        h = i.boundary,
        a = i.skipOverflowHiddenElements,
        c = "function" == typeof h ? h : function (t) {
      return t !== h;
    };
    if (!t(e)) throw new TypeError("Invalid target");

    for (var f = document.scrollingElement || document.documentElement, s = [], p = e; t(p) && c(p);) {
      if ((p = p.parentElement) === f) {
        s.push(p);
        break;
      }

      null != p && p === document.body && n(p) && !n(document.documentElement) || null != p && n(p, a) && s.push(p);
    }

    for (var m = o.visualViewport ? o.visualViewport.width : innerWidth, g = o.visualViewport ? o.visualViewport.height : innerHeight, w = window.scrollX || pageXOffset, v = window.scrollY || pageYOffset, W = e.getBoundingClientRect(), b = W.height, H = W.width, y = W.top, E = W.right, M = W.bottom, V = W.left, x = "start" === d || "nearest" === d ? y : "end" === d ? M : y + b / 2, I = "center" === u ? V + H / 2 : "end" === u ? E : V, C = [], T = 0; T < s.length; T++) {
      var k = s[T],
          B = k.getBoundingClientRect(),
          D = B.height,
          O = B.width,
          R = B.top,
          X = B.right,
          Y = B.bottom,
          L = B.left;
      if ("if-needed" === l && y >= 0 && V >= 0 && M <= g && E <= m && y >= R && M <= Y && V >= L && E <= X) return C;
      var S = getComputedStyle(k),
          j = parseInt(S.borderLeftWidth, 10),
          q = parseInt(S.borderTopWidth, 10),
          z = parseInt(S.borderRightWidth, 10),
          A = parseInt(S.borderBottomWidth, 10),
          F = 0,
          G = 0,
          J = "offsetWidth" in k ? k.offsetWidth - k.clientWidth - j - z : 0,
          K = "offsetHeight" in k ? k.offsetHeight - k.clientHeight - q - A : 0;
      if (f === k) F = "start" === d ? x : "end" === d ? x - g : "nearest" === d ? r(v, v + g, g, q, A, v + x, v + x + b, b) : x - g / 2, G = "start" === u ? I : "center" === u ? I - m / 2 : "end" === u ? I - m : r(w, w + m, m, j, z, w + I, w + I + H, H), F = Math.max(0, F + v), G = Math.max(0, G + w);else {
        F = "start" === d ? x - R - q : "end" === d ? x - Y + A + K : "nearest" === d ? r(R, Y, D, q, A + K, x, x + b, b) : x - (R + D / 2) + K / 2, G = "start" === u ? I - L - j : "center" === u ? I - (L + O / 2) + J / 2 : "end" === u ? I - X + z + J : r(L, X, O, j, z + J, I, I + H, H);
        var N = k.scrollLeft,
            P = k.scrollTop;
        x += P - (F = Math.max(0, Math.min(P + F, k.scrollHeight - D + K))), I += N - (G = Math.max(0, Math.min(N + G, k.scrollWidth - O + J)));
      }
      C.push({
        el: k,
        top: F,
        left: G
      });
    }

    return C;
  }

  var idCounter = 0;
  /**
   * Accepts a parameter and returns it if it's a function
   * or a noop function if it's not. This allows us to
   * accept a callback, but not worry about it if it's not
   * passed.
   * @param {Function} cb the callback
   * @return {Function} a function
   */

  function cbToCb(cb) {
    return typeof cb === 'function' ? cb : noop$2;
  }

  function noop$2() {}
  /**
   * Scroll node into view if necessary
   * @param {HTMLElement} node the element that should scroll into view
   * @param {HTMLElement} menuNode the menu element of the component
   */


  function scrollIntoView(node, menuNode) {
    if (node === null) {
      return;
    }

    var actions = computeScrollIntoView(node, {
      boundary: menuNode,
      block: 'nearest',
      scrollMode: 'if-needed'
    });
    actions.forEach(function (_ref) {
      var el = _ref.el,
          top = _ref.top,
          left = _ref.left;
      el.scrollTop = top;
      el.scrollLeft = left;
    });
  }
  /**
   * @param {HTMLElement} parent the parent node
   * @param {HTMLElement} child the child node
   * @return {Boolean} whether the parent is the child or the child is in the parent
   */


  function isOrContainsNode(parent, child) {
    return parent === child || parent.contains && parent.contains(child);
  }
  /**
   * Simple debounce implementation. Will call the given
   * function once after the time given has passed since
   * it was last called.
   * @param {Function} fn the function to call after the time
   * @param {Number} time the time to wait
   * @return {Function} the debounced function
   */


  function debounce$2(fn, time) {
    var timeoutId;

    function cancel() {
      if (timeoutId) {
        clearTimeout(timeoutId);
      }
    }

    function wrapper() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      cancel();
      timeoutId = setTimeout(function () {
        timeoutId = null;
        fn.apply(void 0, args);
      }, time);
    }

    wrapper.cancel = cancel;
    return wrapper;
  }
  /**
   * This is intended to be used to compose event handlers.
   * They are executed in order until one of them sets
   * `event.preventDownshiftDefault = true`.
   * @param {...Function} fns the event handler functions
   * @return {Function} the event handler to add to an element
   */


  function callAllEventHandlers() {
    for (var _len2 = arguments.length, fns = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      fns[_key2] = arguments[_key2];
    }

    return function (event) {
      for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
        args[_key3 - 1] = arguments[_key3];
      }

      return fns.some(function (fn) {
        if (fn) {
          fn.apply(void 0, [event].concat(args));
        }

        return event.preventDownshiftDefault || event.hasOwnProperty('nativeEvent') && event.nativeEvent.preventDownshiftDefault;
      });
    };
  }

  function handleRefs() {
    for (var _len4 = arguments.length, refs = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      refs[_key4] = arguments[_key4];
    }

    return function (node) {
      refs.forEach(function (ref) {
        if (typeof ref === 'function') {
          ref(node);
        } else if (ref) {
          ref.current = node;
        }
      });
    };
  }
  /**
   * This generates a unique ID for an instance of Downshift
   * @return {String} the unique ID
   */


  function generateId() {
    return String(idCounter++);
  }
  /**
   * Default implementation for status message. Only added when menu is open.
   * Will specift if there are results in the list, and if so, how many,
   * and what keys are relevant.
   *
   * @param {Object} param the downshift state and other relevant properties
   * @return {String} the a11y status message
   */


  function getA11yStatusMessage(_ref2) {
    var isOpen = _ref2.isOpen,
        resultCount = _ref2.resultCount,
        previousResultCount = _ref2.previousResultCount;

    if (!isOpen) {
      return '';
    }

    if (!resultCount) {
      return 'No results are available.';
    }

    if (resultCount !== previousResultCount) {
      return resultCount + " result" + (resultCount === 1 ? ' is' : 's are') + " available, use up and down arrow keys to navigate. Press Enter key to select.";
    }

    return '';
  }
  /**
   * Takes an argument and if it's an array, returns the first item in the array
   * otherwise returns the argument
   * @param {*} arg the maybe-array
   * @param {*} defaultValue the value if arg is falsey not defined
   * @return {*} the arg or it's first item
   */


  function unwrapArray(arg, defaultValue) {
    arg = Array.isArray(arg) ?
    /* istanbul ignore next (preact) */
    arg[0] : arg;

    if (!arg && defaultValue) {
      return defaultValue;
    } else {
      return arg;
    }
  }
  /**
   * @param {Object} element (P)react element
   * @return {Boolean} whether it's a DOM element
   */


  function isDOMElement(element) {
    // then we assume this is react
    return typeof element.type === 'string';
  }
  /**
   * @param {Object} element (P)react element
   * @return {Object} the props
   */


  function getElementProps(element) {
    return element.props;
  }
  /**
   * Throws a helpful error message for required properties. Useful
   * to be used as a default in destructuring or object params.
   * @param {String} fnName the function name
   * @param {String} propName the prop name
   */


  function requiredProp(fnName, propName) {
    // eslint-disable-next-line no-console
    console.error("The property \"" + propName + "\" is required in \"" + fnName + "\"");
  }

  var stateKeys = ['highlightedIndex', 'inputValue', 'isOpen', 'selectedItem', 'type'];
  /**
   * @param {Object} state the state object
   * @return {Object} state that is relevant to downshift
   */

  function pickState(state) {
    if (state === void 0) {
      state = {};
    }

    var result = {};
    stateKeys.forEach(function (k) {
      if (state.hasOwnProperty(k)) {
        result[k] = state[k];
      }
    });
    return result;
  }
  /**
   * This will perform a shallow merge of the given state object
   * with the state coming from props
   * (for the controlled component scenario)
   * This is used in state updater functions so they're referencing
   * the right state regardless of where it comes from.
   *
   * @param {Object} state The state of the component/hook.
   * @param {Object} props The props that may contain controlled values.
   * @returns {Object} The merged controlled state.
   */


  function getState(state, props) {
    return Object.keys(state).reduce(function (prevState, key) {
      prevState[key] = isControlledProp(props, key) ? props[key] : state[key];
      return prevState;
    }, {});
  }
  /**
   * This determines whether a prop is a "controlled prop" meaning it is
   * state which is controlled by the outside of this component rather
   * than within this component.
   *
   * @param {Object} props The props that may contain controlled values.
   * @param {String} key the key to check
   * @return {Boolean} whether it is a controlled controlled prop
   */


  function isControlledProp(props, key) {
    return props[key] !== undefined;
  }
  /**
   * Normalizes the 'key' property of a KeyboardEvent in IE/Edge
   * @param {Object} event a keyboardEvent object
   * @return {String} keyboard key
   */


  function normalizeArrowKey(event) {
    var key = event.key,
        keyCode = event.keyCode;
    /* istanbul ignore next (ie) */

    if (keyCode >= 37 && keyCode <= 40 && key.indexOf('Arrow') !== 0) {
      return "Arrow" + key;
    }

    return key;
  }
  /**
   * Simple check if the value passed is object literal
   * @param {*} obj any things
   * @return {Boolean} whether it's object literal
   */


  function isPlainObject(obj) {
    return Object.prototype.toString.call(obj) === '[object Object]';
  }
  /**
   * Returns the new index in the list, in a circular way. If next value is out of bonds from the total,
   * it will wrap to either 0 or itemCount - 1.
   *
   * @param {number} moveAmount Number of positions to move. Negative to move backwards, positive forwards.
   * @param {number} baseIndex The initial position to move from.
   * @param {number} itemCount The total number of items.
   * @param {Function} getItemNodeFromIndex Used to check if item is disabled.
   * @param {boolean} circular Specify if navigation is circular. Default is true.
   * @returns {number} The new index after the move.
   */


  function getNextWrappingIndex(moveAmount, baseIndex, itemCount, getItemNodeFromIndex, circular) {
    if (circular === void 0) {
      circular = true;
    }

    var itemsLastIndex = itemCount - 1;

    if (typeof baseIndex !== 'number' || baseIndex < 0 || baseIndex >= itemCount) {
      baseIndex = moveAmount > 0 ? -1 : itemsLastIndex + 1;
    }

    var newIndex = baseIndex + moveAmount;

    if (newIndex < 0) {
      newIndex = circular ? itemsLastIndex : 0;
    } else if (newIndex > itemsLastIndex) {
      newIndex = circular ? 0 : itemsLastIndex;
    }

    var nonDisabledNewIndex = getNextNonDisabledIndex(moveAmount, newIndex, itemCount, getItemNodeFromIndex, circular);
    return nonDisabledNewIndex === -1 ? baseIndex : nonDisabledNewIndex;
  }
  /**
   * Returns the next index in the list of an item that is not disabled.
   *
   * @param {number} moveAmount Number of positions to move. Negative to move backwards, positive forwards.
   * @param {number} baseIndex The initial position to move from.
   * @param {number} itemCount The total number of items.
   * @param {Function} getItemNodeFromIndex Used to check if item is disabled.
   * @param {boolean} circular Specify if navigation is circular. Default is true.
   * @returns {number} The new index. Returns baseIndex if item is not disabled. Returns next non-disabled item otherwise. If no non-disabled found it will return -1.
   */


  function getNextNonDisabledIndex(moveAmount, baseIndex, itemCount, getItemNodeFromIndex, circular) {
    var currentElementNode = getItemNodeFromIndex(baseIndex);

    if (!currentElementNode || !currentElementNode.hasAttribute('disabled')) {
      return baseIndex;
    }

    if (moveAmount > 0) {
      for (var index = baseIndex + 1; index < itemCount; index++) {
        if (!getItemNodeFromIndex(index).hasAttribute('disabled')) {
          return index;
        }
      }
    } else {
      for (var _index = baseIndex - 1; _index >= 0; _index--) {
        if (!getItemNodeFromIndex(_index).hasAttribute('disabled')) {
          return _index;
        }
      }
    }

    if (circular) {
      return moveAmount > 0 ? getNextNonDisabledIndex(1, 0, itemCount, getItemNodeFromIndex, false) : getNextNonDisabledIndex(-1, itemCount - 1, itemCount, getItemNodeFromIndex, false);
    }

    return -1;
  }
  /**
   * Checks if event target is within the downshift elements.
   *
   * @param {EventTarget} target Target to check.
   * @param {HTMLElement[]} downshiftElements The elements that form downshift (list, toggle button etc).
   * @param {Document} document The document.
   * @param {boolean} checkActiveElement Whether to also check activeElement.
   *
   * @returns {boolean} Whether or not the target is within downshift elements.
   */


  function targetWithinDownshift(target, downshiftElements, document, checkActiveElement) {
    if (checkActiveElement === void 0) {
      checkActiveElement = true;
    }

    return downshiftElements.some(function (contextNode) {
      return contextNode && (isOrContainsNode(contextNode, target) || checkActiveElement && isOrContainsNode(contextNode, document.activeElement));
    });
  }

  var cleanupStatus = debounce$2(function () {
    getStatusDiv().textContent = '';
  }, 500);
  /**
   * @param {String} status the status message
   * @param {Object} documentProp document passed by the user.
   */

  function setStatus(status, documentProp) {
    var div = getStatusDiv(documentProp);

    if (!status) {
      return;
    }

    div.textContent = status;
    cleanupStatus();
  }
  /**
   * Get the status node or create it if it does not already exist.
   * @param {Object} documentProp document passed by the user.
   * @return {HTMLElement} the status node.
   */


  function getStatusDiv(documentProp) {
    if (documentProp === void 0) {
      documentProp = document;
    }

    var statusDiv = documentProp.getElementById('a11y-status-message');

    if (statusDiv) {
      return statusDiv;
    }

    statusDiv = documentProp.createElement('div');
    statusDiv.setAttribute('id', 'a11y-status-message');
    statusDiv.setAttribute('role', 'status');
    statusDiv.setAttribute('aria-live', 'polite');
    statusDiv.setAttribute('aria-relevant', 'additions text');
    Object.assign(statusDiv.style, {
      border: '0',
      clip: 'rect(0 0 0 0)',
      height: '1px',
      margin: '-1px',
      overflow: 'hidden',
      padding: '0',
      position: 'absolute',
      width: '1px'
    });
    documentProp.body.appendChild(statusDiv);
    return statusDiv;
  }

  var unknown = '__autocomplete_unknown__' ;
  var mouseUp = '__autocomplete_mouseup__' ;
  var itemMouseEnter = '__autocomplete_item_mouseenter__' ;
  var keyDownArrowUp = '__autocomplete_keydown_arrow_up__' ;
  var keyDownArrowDown = '__autocomplete_keydown_arrow_down__' ;
  var keyDownEscape = '__autocomplete_keydown_escape__' ;
  var keyDownEnter = '__autocomplete_keydown_enter__' ;
  var keyDownHome = '__autocomplete_keydown_home__' ;
  var keyDownEnd = '__autocomplete_keydown_end__' ;
  var clickItem = '__autocomplete_click_item__' ;
  var blurInput = '__autocomplete_blur_input__' ;
  var changeInput = '__autocomplete_change_input__' ;
  var keyDownSpaceButton = '__autocomplete_keydown_space_button__' ;
  var clickButton = '__autocomplete_click_button__' ;
  var blurButton = '__autocomplete_blur_button__' ;
  var controlledPropUpdatedSelectedItem = '__autocomplete_controlled_prop_updated_selected_item__' ;
  var touchEnd = '__autocomplete_touchend__' ;
  var stateChangeTypes = /*#__PURE__*/Object.freeze({
    __proto__: null,
    unknown: unknown,
    mouseUp: mouseUp,
    itemMouseEnter: itemMouseEnter,
    keyDownArrowUp: keyDownArrowUp,
    keyDownArrowDown: keyDownArrowDown,
    keyDownEscape: keyDownEscape,
    keyDownEnter: keyDownEnter,
    keyDownHome: keyDownHome,
    keyDownEnd: keyDownEnd,
    clickItem: clickItem,
    blurInput: blurInput,
    changeInput: changeInput,
    keyDownSpaceButton: keyDownSpaceButton,
    clickButton: clickButton,
    blurButton: blurButton,
    controlledPropUpdatedSelectedItem: controlledPropUpdatedSelectedItem,
    touchEnd: touchEnd
  });

  var Downshift = /*#__PURE__*/function () {
    var Downshift = /*#__PURE__*/function (_Component) {
      _inheritsLoose(Downshift, _Component);

      function Downshift(_props) {
        var _this = _Component.call(this, _props) || this;

        _this.id = _this.props.id || "downshift-" + generateId();
        _this.menuId = _this.props.menuId || _this.id + "-menu";
        _this.labelId = _this.props.labelId || _this.id + "-label";
        _this.inputId = _this.props.inputId || _this.id + "-input";

        _this.getItemId = _this.props.getItemId || function (index) {
          return _this.id + "-item-" + index;
        };

        _this.input = null;
        _this.items = [];
        _this.itemCount = null;
        _this.previousResultCount = 0;
        _this.timeoutIds = [];

        _this.internalSetTimeout = function (fn, time) {
          var id = setTimeout(function () {
            _this.timeoutIds = _this.timeoutIds.filter(function (i) {
              return i !== id;
            });
            fn();
          }, time);

          _this.timeoutIds.push(id);
        };

        _this.setItemCount = function (count) {
          _this.itemCount = count;
        };

        _this.unsetItemCount = function () {
          _this.itemCount = null;
        };

        _this.setHighlightedIndex = function (highlightedIndex, otherStateToSet) {
          if (highlightedIndex === void 0) {
            highlightedIndex = _this.props.defaultHighlightedIndex;
          }

          if (otherStateToSet === void 0) {
            otherStateToSet = {};
          }

          otherStateToSet = pickState(otherStateToSet);

          _this.internalSetState(_extends({
            highlightedIndex: highlightedIndex
          }, otherStateToSet));
        };

        _this.clearSelection = function (cb) {
          _this.internalSetState({
            selectedItem: null,
            inputValue: '',
            highlightedIndex: _this.props.defaultHighlightedIndex,
            isOpen: _this.props.defaultIsOpen
          }, cb);
        };

        _this.selectItem = function (item, otherStateToSet, cb) {
          otherStateToSet = pickState(otherStateToSet);

          _this.internalSetState(_extends({
            isOpen: _this.props.defaultIsOpen,
            highlightedIndex: _this.props.defaultHighlightedIndex,
            selectedItem: item,
            inputValue: _this.props.itemToString(item)
          }, otherStateToSet), cb);
        };

        _this.selectItemAtIndex = function (itemIndex, otherStateToSet, cb) {
          var item = _this.items[itemIndex];

          if (item == null) {
            return;
          }

          _this.selectItem(item, otherStateToSet, cb);
        };

        _this.selectHighlightedItem = function (otherStateToSet, cb) {
          return _this.selectItemAtIndex(_this.getState().highlightedIndex, otherStateToSet, cb);
        };

        _this.internalSetState = function (stateToSet, cb) {
          var isItemSelected, onChangeArg;
          var onStateChangeArg = {};
          var isStateToSetFunction = typeof stateToSet === 'function'; // we want to call `onInputValueChange` before the `setState` call
          // so someone controlling the `inputValue` state gets notified of
          // the input change as soon as possible. This avoids issues with
          // preserving the cursor position.
          // See https://github.com/downshift-js/downshift/issues/217 for more info.

          if (!isStateToSetFunction && stateToSet.hasOwnProperty('inputValue')) {
            _this.props.onInputValueChange(stateToSet.inputValue, _extends({}, _this.getStateAndHelpers(), {}, stateToSet));
          }

          return _this.setState(function (state) {
            state = _this.getState(state);
            var newStateToSet = isStateToSetFunction ? stateToSet(state) : stateToSet; // Your own function that could modify the state that will be set.

            newStateToSet = _this.props.stateReducer(state, newStateToSet); // checks if an item is selected, regardless of if it's different from
            // what was selected before
            // used to determine if onSelect and onChange callbacks should be called

            isItemSelected = newStateToSet.hasOwnProperty('selectedItem'); // this keeps track of the object we want to call with setState

            var nextState = {}; // this is just used to tell whether the state changed
            // and we're trying to update that state. OR if the selection has changed and we're
            // trying to update the selection

            if (isItemSelected && newStateToSet.selectedItem !== state.selectedItem) {
              onChangeArg = newStateToSet.selectedItem;
            }

            newStateToSet.type = newStateToSet.type || unknown;
            Object.keys(newStateToSet).forEach(function (key) {
              // onStateChangeArg should only have the state that is
              // actually changing
              if (state[key] !== newStateToSet[key]) {
                onStateChangeArg[key] = newStateToSet[key];
              } // the type is useful for the onStateChangeArg
              // but we don't actually want to set it in internal state.
              // this is an undocumented feature for now... Not all internalSetState
              // calls support it and I'm not certain we want them to yet.
              // But it enables users controlling the isOpen state to know when
              // the isOpen state changes due to mouseup events which is quite handy.


              if (key === 'type') {
                return;
              }

              newStateToSet[key]; // if it's coming from props, then we don't care to set it internally

              if (!isControlledProp(_this.props, key)) {
                nextState[key] = newStateToSet[key];
              }
            }); // if stateToSet is a function, then we weren't able to call onInputValueChange
            // earlier, so we'll call it now that we know what the inputValue state will be.

            if (isStateToSetFunction && newStateToSet.hasOwnProperty('inputValue')) {
              _this.props.onInputValueChange(newStateToSet.inputValue, _extends({}, _this.getStateAndHelpers(), {}, newStateToSet));
            }

            return nextState;
          }, function () {
            // call the provided callback if it's a function
            cbToCb(cb)(); // only call the onStateChange and onChange callbacks if
            // we have relevant information to pass them.

            var hasMoreStateThanType = Object.keys(onStateChangeArg).length > 1;

            if (hasMoreStateThanType) {
              _this.props.onStateChange(onStateChangeArg, _this.getStateAndHelpers());
            }

            if (isItemSelected) {
              _this.props.onSelect(stateToSet.selectedItem, _this.getStateAndHelpers());
            }

            if (onChangeArg !== undefined) {
              _this.props.onChange(onChangeArg, _this.getStateAndHelpers());
            } // this is currently undocumented and therefore subject to change
            // We'll try to not break it, but just be warned.


            _this.props.onUserAction(onStateChangeArg, _this.getStateAndHelpers());
          });
        };

        _this.rootRef = function (node) {
          return _this._rootNode = node;
        };

        _this.getRootProps = function (_temp, _temp2) {
          var _extends2;

          var _ref = _temp === void 0 ? {} : _temp,
              _ref$refKey = _ref.refKey,
              refKey = _ref$refKey === void 0 ? 'ref' : _ref$refKey,
              ref = _ref.ref,
              rest = _objectWithoutPropertiesLoose(_ref, ["refKey", "ref"]);

          var _ref2 = _temp2 === void 0 ? {} : _temp2,
              _ref2$suppressRefErro = _ref2.suppressRefError,
              suppressRefError = _ref2$suppressRefErro === void 0 ? false : _ref2$suppressRefErro; // this is used in the render to know whether the user has called getRootProps.
          // It uses that to know whether to apply the props automatically


          _this.getRootProps.called = true;
          _this.getRootProps.refKey = refKey;
          _this.getRootProps.suppressRefError = suppressRefError;

          var _this$getState = _this.getState(),
              isOpen = _this$getState.isOpen;

          return _extends((_extends2 = {}, _extends2[refKey] = handleRefs(ref, _this.rootRef), _extends2.role = 'combobox', _extends2['aria-expanded'] = isOpen, _extends2['aria-haspopup'] = 'listbox', _extends2['aria-owns'] = isOpen ? _this.menuId : null, _extends2['aria-labelledby'] = _this.labelId, _extends2), rest);
        };

        _this.keyDownHandlers = {
          ArrowDown: function ArrowDown(event) {
            var _this2 = this;

            event.preventDefault();

            if (this.getState().isOpen) {
              var amount = event.shiftKey ? 5 : 1;
              this.moveHighlightedIndex(amount, {
                type: keyDownArrowDown
              });
            } else {
              this.internalSetState({
                isOpen: true,
                type: keyDownArrowDown
              }, function () {
                var itemCount = _this2.getItemCount();

                if (itemCount > 0) {
                  var _this2$getState = _this2.getState(),
                      highlightedIndex = _this2$getState.highlightedIndex;

                  var nextHighlightedIndex = getNextWrappingIndex(1, highlightedIndex, itemCount, function (index) {
                    return _this2.getItemNodeFromIndex(index);
                  });

                  _this2.setHighlightedIndex(nextHighlightedIndex, {
                    type: keyDownArrowDown
                  });
                }
              });
            }
          },
          ArrowUp: function ArrowUp(event) {
            var _this3 = this;

            event.preventDefault();

            if (this.getState().isOpen) {
              var amount = event.shiftKey ? -5 : -1;
              this.moveHighlightedIndex(amount, {
                type: keyDownArrowUp
              });
            } else {
              this.internalSetState({
                isOpen: true,
                type: keyDownArrowUp
              }, function () {
                var itemCount = _this3.getItemCount();

                if (itemCount > 0) {
                  var _this3$getState = _this3.getState(),
                      highlightedIndex = _this3$getState.highlightedIndex;

                  var nextHighlightedIndex = getNextWrappingIndex(-1, highlightedIndex, itemCount, function (index) {
                    return _this3.getItemNodeFromIndex(index);
                  });

                  _this3.setHighlightedIndex(nextHighlightedIndex, {
                    type: keyDownArrowUp
                  });
                }
              });
            }
          },
          Enter: function Enter(event) {
            if (event.which === 229) {
              return;
            }

            var _this$getState2 = this.getState(),
                isOpen = _this$getState2.isOpen,
                highlightedIndex = _this$getState2.highlightedIndex;

            if (isOpen && highlightedIndex != null) {
              event.preventDefault();
              var item = this.items[highlightedIndex];
              var itemNode = this.getItemNodeFromIndex(highlightedIndex);

              if (item == null || itemNode && itemNode.hasAttribute('disabled')) {
                return;
              }

              this.selectHighlightedItem({
                type: keyDownEnter
              });
            }
          },
          Escape: function Escape(event) {
            event.preventDefault();
            this.reset({
              type: keyDownEscape,
              selectedItem: null,
              inputValue: ''
            });
          }
        };
        _this.buttonKeyDownHandlers = _extends({}, _this.keyDownHandlers, {
          ' ': function _(event) {
            event.preventDefault();
            this.toggleMenu({
              type: keyDownSpaceButton
            });
          }
        });
        _this.inputKeyDownHandlers = _extends({}, _this.keyDownHandlers, {
          Home: function Home(event) {
            var _this4 = this;

            event.preventDefault();
            var itemCount = this.getItemCount();

            var _this$getState3 = this.getState(),
                isOpen = _this$getState3.isOpen;

            if (itemCount <= 0 || !isOpen) {
              return;
            } // get next non-disabled starting downwards from 0 if that's disabled.


            var newHighlightedIndex = getNextNonDisabledIndex(1, 0, itemCount, function (index) {
              return _this4.getItemNodeFromIndex(index);
            }, false);
            this.setHighlightedIndex(newHighlightedIndex, {
              type: keyDownHome
            });
          },
          End: function End(event) {
            var _this5 = this;

            event.preventDefault();
            var itemCount = this.getItemCount();

            var _this$getState4 = this.getState(),
                isOpen = _this$getState4.isOpen;

            if (itemCount <= 0 || !isOpen) {
              return;
            } // get next non-disabled starting upwards from last index if that's disabled.


            var newHighlightedIndex = getNextNonDisabledIndex(-1, itemCount - 1, itemCount, function (index) {
              return _this5.getItemNodeFromIndex(index);
            }, false);
            this.setHighlightedIndex(newHighlightedIndex, {
              type: keyDownEnd
            });
          }
        });

        _this.getToggleButtonProps = function (_temp3) {
          var _ref3 = _temp3 === void 0 ? {} : _temp3,
              onClick = _ref3.onClick;
              _ref3.onPress;
              var onKeyDown = _ref3.onKeyDown,
              onKeyUp = _ref3.onKeyUp,
              onBlur = _ref3.onBlur,
              rest = _objectWithoutPropertiesLoose(_ref3, ["onClick", "onPress", "onKeyDown", "onKeyUp", "onBlur"]);

          var _this$getState5 = _this.getState(),
              isOpen = _this$getState5.isOpen;

          var enabledEventHandlers = {
            onClick: callAllEventHandlers(onClick, _this.buttonHandleClick),
            onKeyDown: callAllEventHandlers(onKeyDown, _this.buttonHandleKeyDown),
            onKeyUp: callAllEventHandlers(onKeyUp, _this.buttonHandleKeyUp),
            onBlur: callAllEventHandlers(onBlur, _this.buttonHandleBlur)
          };
          var eventHandlers = rest.disabled ? {} : enabledEventHandlers;
          return _extends({
            type: 'button',
            role: 'button',
            'aria-label': isOpen ? 'close menu' : 'open menu',
            'aria-haspopup': true,
            'data-toggle': true
          }, eventHandlers, {}, rest);
        };

        _this.buttonHandleKeyUp = function (event) {
          // Prevent click event from emitting in Firefox
          event.preventDefault();
        };

        _this.buttonHandleKeyDown = function (event) {
          var key = normalizeArrowKey(event);

          if (_this.buttonKeyDownHandlers[key]) {
            _this.buttonKeyDownHandlers[key].call(_assertThisInitialized(_this), event);
          }
        };

        _this.buttonHandleClick = function (event) {
          event.preventDefault(); // handle odd case for Safari and Firefox which
          // don't give the button the focus properly.

          /* istanbul ignore if (can't reasonably test this) */

          if (_this.props.environment.document.activeElement === _this.props.environment.document.body) {
            event.target.focus();
          } // to simplify testing components that use downshift, we'll not wrap this in a setTimeout
          // if the NODE_ENV is test. With the proper build system, this should be dead code eliminated
          // when building for production and should therefore have no impact on production code.


          {
            // Ensure that toggle of menu occurs after the potential blur event in iOS
            _this.internalSetTimeout(function () {
              return _this.toggleMenu({
                type: clickButton
              });
            });
          }
        };

        _this.buttonHandleBlur = function (event) {
          var blurTarget = event.target; // Save blur target for comparison with activeElement later
          // Need setTimeout, so that when the user presses Tab, the activeElement is the next focused element, not body element

          _this.internalSetTimeout(function () {
            if (!_this.isMouseDown && (_this.props.environment.document.activeElement == null || _this.props.environment.document.activeElement.id !== _this.inputId) && _this.props.environment.document.activeElement !== blurTarget // Do nothing if we refocus the same element again (to solve issue in Safari on iOS)
            ) {
                _this.reset({
                  type: blurButton
                });
              }
          });
        };

        _this.getLabelProps = function (props) {
          return _extends({
            htmlFor: _this.inputId,
            id: _this.labelId
          }, props);
        };

        _this.getInputProps = function (_temp4) {
          var _ref4 = _temp4 === void 0 ? {} : _temp4,
              onKeyDown = _ref4.onKeyDown,
              onBlur = _ref4.onBlur,
              onChange = _ref4.onChange,
              onInput = _ref4.onInput;
              _ref4.onChangeText;
              var rest = _objectWithoutPropertiesLoose(_ref4, ["onKeyDown", "onBlur", "onChange", "onInput", "onChangeText"]);

          var onChangeKey;
          var eventHandlers = {};
          /* istanbul ignore next (preact) */

          onChangeKey = 'onChange';

          var _this$getState6 = _this.getState(),
              inputValue = _this$getState6.inputValue,
              isOpen = _this$getState6.isOpen,
              highlightedIndex = _this$getState6.highlightedIndex;

          if (!rest.disabled) {
            var _eventHandlers;

            eventHandlers = (_eventHandlers = {}, _eventHandlers[onChangeKey] = callAllEventHandlers(onChange, onInput, _this.inputHandleChange), _eventHandlers.onKeyDown = callAllEventHandlers(onKeyDown, _this.inputHandleKeyDown), _eventHandlers.onBlur = callAllEventHandlers(onBlur, _this.inputHandleBlur), _eventHandlers);
          }
          /* istanbul ignore if (react-native) */


          return _extends({
            'aria-autocomplete': 'list',
            'aria-activedescendant': isOpen && typeof highlightedIndex === 'number' && highlightedIndex >= 0 ? _this.getItemId(highlightedIndex) : null,
            'aria-controls': isOpen ? _this.menuId : null,
            'aria-labelledby': _this.labelId,
            // https://developer.mozilla.org/en-US/docs/Web/Security/Securing_your_site/Turning_off_form_autocompletion
            // revert back since autocomplete="nope" is ignored on latest Chrome and Opera
            autoComplete: 'off',
            value: inputValue,
            id: _this.inputId
          }, eventHandlers, {}, rest);
        };

        _this.inputHandleKeyDown = function (event) {
          var key = normalizeArrowKey(event);

          if (key && _this.inputKeyDownHandlers[key]) {
            _this.inputKeyDownHandlers[key].call(_assertThisInitialized(_this), event);
          }
        };

        _this.inputHandleChange = function (event) {
          _this.internalSetState({
            type: changeInput,
            isOpen: true,
            inputValue: event.target.value,
            highlightedIndex: _this.props.defaultHighlightedIndex
          });
        };

        _this.inputHandleBlur = function () {
          // Need setTimeout, so that when the user presses Tab, the activeElement is the next focused element, not the body element
          _this.internalSetTimeout(function () {
            var downshiftButtonIsActive = _this.props.environment.document && !!_this.props.environment.document.activeElement && !!_this.props.environment.document.activeElement.dataset && _this.props.environment.document.activeElement.dataset.toggle && _this._rootNode && _this._rootNode.contains(_this.props.environment.document.activeElement);

            if (!_this.isMouseDown && !downshiftButtonIsActive) {
              _this.reset({
                type: blurInput
              });
            }
          });
        };

        _this.menuRef = function (node) {
          _this._menuNode = node;
        };

        _this.getMenuProps = function (_temp5, _temp6) {
          var _extends3;

          var _ref5 = _temp5 === void 0 ? {} : _temp5,
              _ref5$refKey = _ref5.refKey,
              refKey = _ref5$refKey === void 0 ? 'ref' : _ref5$refKey,
              ref = _ref5.ref,
              props = _objectWithoutPropertiesLoose(_ref5, ["refKey", "ref"]);

          var _ref6 = _temp6 === void 0 ? {} : _temp6,
              _ref6$suppressRefErro = _ref6.suppressRefError,
              suppressRefError = _ref6$suppressRefErro === void 0 ? false : _ref6$suppressRefErro;

          _this.getMenuProps.called = true;
          _this.getMenuProps.refKey = refKey;
          _this.getMenuProps.suppressRefError = suppressRefError;
          return _extends((_extends3 = {}, _extends3[refKey] = handleRefs(ref, _this.menuRef), _extends3.role = 'listbox', _extends3['aria-labelledby'] = props && props['aria-label'] ? null : _this.labelId, _extends3.id = _this.menuId, _extends3), props);
        };

        _this.getItemProps = function (_temp7) {
          var _enabledEventHandlers;

          var _ref7 = _temp7 === void 0 ? {} : _temp7,
              onMouseMove = _ref7.onMouseMove,
              onMouseDown = _ref7.onMouseDown,
              onClick = _ref7.onClick;
              _ref7.onPress;
              var index = _ref7.index,
              _ref7$item = _ref7.item,
              item = _ref7$item === void 0 ? requiredProp('getItemProps', 'item') : _ref7$item,
              rest = _objectWithoutPropertiesLoose(_ref7, ["onMouseMove", "onMouseDown", "onClick", "onPress", "index", "item"]);

          if (index === undefined) {
            _this.items.push(item);

            index = _this.items.indexOf(item);
          } else {
            _this.items[index] = item;
          }

          var onSelectKey = 'onClick';
          var customClickHandler = onClick;
          var enabledEventHandlers = (_enabledEventHandlers = {
            // onMouseMove is used over onMouseEnter here. onMouseMove
            // is only triggered on actual mouse movement while onMouseEnter
            // can fire on DOM changes, interrupting keyboard navigation
            onMouseMove: callAllEventHandlers(onMouseMove, function () {
              if (index === _this.getState().highlightedIndex) {
                return;
              }

              _this.setHighlightedIndex(index, {
                type: itemMouseEnter
              }); // We never want to manually scroll when changing state based
              // on `onMouseMove` because we will be moving the element out
              // from under the user which is currently scrolling/moving the
              // cursor


              _this.avoidScrolling = true;

              _this.internalSetTimeout(function () {
                return _this.avoidScrolling = false;
              }, 250);
            }),
            onMouseDown: callAllEventHandlers(onMouseDown, function (event) {
              // This prevents the activeElement from being changed
              // to the item so it can remain with the current activeElement
              // which is a more common use case.
              event.preventDefault();
            })
          }, _enabledEventHandlers[onSelectKey] = callAllEventHandlers(customClickHandler, function () {
            _this.selectItemAtIndex(index, {
              type: clickItem
            });
          }), _enabledEventHandlers); // Passing down the onMouseDown handler to prevent redirect
          // of the activeElement if clicking on disabled items

          var eventHandlers = rest.disabled ? {
            onMouseDown: enabledEventHandlers.onMouseDown
          } : enabledEventHandlers;
          return _extends({
            id: _this.getItemId(index),
            role: 'option',
            'aria-selected': _this.getState().highlightedIndex === index
          }, eventHandlers, {}, rest);
        };

        _this.clearItems = function () {
          _this.items = [];
        };

        _this.reset = function (otherStateToSet, cb) {
          if (otherStateToSet === void 0) {
            otherStateToSet = {};
          }

          otherStateToSet = pickState(otherStateToSet);

          _this.internalSetState(function (_ref8) {
            var selectedItem = _ref8.selectedItem;
            return _extends({
              isOpen: _this.props.defaultIsOpen,
              highlightedIndex: _this.props.defaultHighlightedIndex,
              inputValue: _this.props.itemToString(selectedItem)
            }, otherStateToSet);
          }, cb);
        };

        _this.toggleMenu = function (otherStateToSet, cb) {
          if (otherStateToSet === void 0) {
            otherStateToSet = {};
          }

          otherStateToSet = pickState(otherStateToSet);

          _this.internalSetState(function (_ref9) {
            var isOpen = _ref9.isOpen;
            return _extends({
              isOpen: !isOpen
            }, isOpen && {
              highlightedIndex: _this.props.defaultHighlightedIndex
            }, {}, otherStateToSet);
          }, function () {
            var _this$getState7 = _this.getState(),
                isOpen = _this$getState7.isOpen,
                highlightedIndex = _this$getState7.highlightedIndex;

            if (isOpen) {
              if (_this.getItemCount() > 0 && typeof highlightedIndex === 'number') {
                _this.setHighlightedIndex(highlightedIndex, otherStateToSet);
              }
            }

            cbToCb(cb)();
          });
        };

        _this.openMenu = function (cb) {
          _this.internalSetState({
            isOpen: true
          }, cb);
        };

        _this.closeMenu = function (cb) {
          _this.internalSetState({
            isOpen: false
          }, cb);
        };

        _this.updateStatus = debounce$2(function () {
          var state = _this.getState();

          var item = _this.items[state.highlightedIndex];

          var resultCount = _this.getItemCount();

          var status = _this.props.getA11yStatusMessage(_extends({
            itemToString: _this.props.itemToString,
            previousResultCount: _this.previousResultCount,
            resultCount: resultCount,
            highlightedItem: item
          }, state));

          _this.previousResultCount = resultCount;
          setStatus(status, _this.props.environment.document);
        }, 200); // fancy destructuring + defaults + aliases
        // this basically says each value of state should either be set to
        // the initial value or the default value if the initial value is not provided

        var _this$props = _this.props,
            defaultHighlightedIndex = _this$props.defaultHighlightedIndex,
            _this$props$initialHi = _this$props.initialHighlightedIndex,
            _highlightedIndex = _this$props$initialHi === void 0 ? defaultHighlightedIndex : _this$props$initialHi,
            defaultIsOpen = _this$props.defaultIsOpen,
            _this$props$initialIs = _this$props.initialIsOpen,
            _isOpen = _this$props$initialIs === void 0 ? defaultIsOpen : _this$props$initialIs,
            _this$props$initialIn = _this$props.initialInputValue,
            _inputValue = _this$props$initialIn === void 0 ? '' : _this$props$initialIn,
            _this$props$initialSe = _this$props.initialSelectedItem,
            _selectedItem = _this$props$initialSe === void 0 ? null : _this$props$initialSe;

        var _state = _this.getState({
          highlightedIndex: _highlightedIndex,
          isOpen: _isOpen,
          inputValue: _inputValue,
          selectedItem: _selectedItem
        });

        if (_state.selectedItem != null && _this.props.initialInputValue === undefined) {
          _state.inputValue = _this.props.itemToString(_state.selectedItem);
        }

        _this.state = _state;
        return _this;
      }

      var _proto = Downshift.prototype;
      /**
       * Clear all running timeouts
       */

      _proto.internalClearTimeouts = function internalClearTimeouts() {
        this.timeoutIds.forEach(function (id) {
          clearTimeout(id);
        });
        this.timeoutIds = [];
      }
      /**
       * Gets the state based on internal state or props
       * If a state value is passed via props, then that
       * is the value given, otherwise it's retrieved from
       * stateToMerge
       *
       * @param {Object} stateToMerge defaults to this.state
       * @return {Object} the state
       */
      ;

      _proto.getState = function getState$1(stateToMerge) {
        if (stateToMerge === void 0) {
          stateToMerge = this.state;
        }

        return getState(stateToMerge, this.props);
      };

      _proto.getItemCount = function getItemCount() {
        // things read better this way. They're in priority order:
        // 1. `this.itemCount`
        // 2. `this.props.itemCount`
        // 3. `this.items.length`
        var itemCount = this.items.length;

        if (this.itemCount != null) {
          itemCount = this.itemCount;
        } else if (this.props.itemCount !== undefined) {
          itemCount = this.props.itemCount;
        }

        return itemCount;
      };

      _proto.getItemNodeFromIndex = function getItemNodeFromIndex(index) {
        return this.props.environment.document.getElementById(this.getItemId(index));
      };

      _proto.scrollHighlightedItemIntoView = function scrollHighlightedItemIntoView() {
        /* istanbul ignore else (react-native) */
        {
          var node = this.getItemNodeFromIndex(this.getState().highlightedIndex);
          this.props.scrollIntoView(node, this._menuNode);
        }
      };

      _proto.moveHighlightedIndex = function moveHighlightedIndex(amount, otherStateToSet) {
        var _this6 = this;

        var itemCount = this.getItemCount();

        var _this$getState8 = this.getState(),
            highlightedIndex = _this$getState8.highlightedIndex;

        if (itemCount > 0) {
          var nextHighlightedIndex = getNextWrappingIndex(amount, highlightedIndex, itemCount, function (index) {
            return _this6.getItemNodeFromIndex(index);
          });
          this.setHighlightedIndex(nextHighlightedIndex, otherStateToSet);
        }
      };

      _proto.getStateAndHelpers = function getStateAndHelpers() {
        var _this$getState9 = this.getState(),
            highlightedIndex = _this$getState9.highlightedIndex,
            inputValue = _this$getState9.inputValue,
            selectedItem = _this$getState9.selectedItem,
            isOpen = _this$getState9.isOpen;

        var itemToString = this.props.itemToString;
        var id = this.id;
        var getRootProps = this.getRootProps,
            getToggleButtonProps = this.getToggleButtonProps,
            getLabelProps = this.getLabelProps,
            getMenuProps = this.getMenuProps,
            getInputProps = this.getInputProps,
            getItemProps = this.getItemProps,
            openMenu = this.openMenu,
            closeMenu = this.closeMenu,
            toggleMenu = this.toggleMenu,
            selectItem = this.selectItem,
            selectItemAtIndex = this.selectItemAtIndex,
            selectHighlightedItem = this.selectHighlightedItem,
            setHighlightedIndex = this.setHighlightedIndex,
            clearSelection = this.clearSelection,
            clearItems = this.clearItems,
            reset = this.reset,
            setItemCount = this.setItemCount,
            unsetItemCount = this.unsetItemCount,
            setState = this.internalSetState;
        return {
          // prop getters
          getRootProps: getRootProps,
          getToggleButtonProps: getToggleButtonProps,
          getLabelProps: getLabelProps,
          getMenuProps: getMenuProps,
          getInputProps: getInputProps,
          getItemProps: getItemProps,
          // actions
          reset: reset,
          openMenu: openMenu,
          closeMenu: closeMenu,
          toggleMenu: toggleMenu,
          selectItem: selectItem,
          selectItemAtIndex: selectItemAtIndex,
          selectHighlightedItem: selectHighlightedItem,
          setHighlightedIndex: setHighlightedIndex,
          clearSelection: clearSelection,
          clearItems: clearItems,
          setItemCount: setItemCount,
          unsetItemCount: unsetItemCount,
          setState: setState,
          // props
          itemToString: itemToString,
          // derived
          id: id,
          // state
          highlightedIndex: highlightedIndex,
          inputValue: inputValue,
          isOpen: isOpen,
          selectedItem: selectedItem
        };
      } //////////////////////////// ROOT
      ;

      _proto.componentDidMount = function componentDidMount() {
        var _this7 = this;
        /* istanbul ignore if (react-native) */


        if (this.getMenuProps.called && !this.getMenuProps.suppressRefError) {
          validateGetMenuPropsCalledCorrectly(this._menuNode, this.getMenuProps);
        }
        /* istanbul ignore if (react-native) */


        {
          // this.isMouseDown helps us track whether the mouse is currently held down.
          // This is useful when the user clicks on an item in the list, but holds the mouse
          // down long enough for the list to disappear (because the blur event fires on the input)
          // this.isMouseDown is used in the blur handler on the input to determine whether the blur event should
          // trigger hiding the menu.
          var onMouseDown = function onMouseDown() {
            _this7.isMouseDown = true;
          };

          var onMouseUp = function onMouseUp(event) {
            _this7.isMouseDown = false; // if the target element or the activeElement is within a downshift node
            // then we don't want to reset downshift

            var contextWithinDownshift = targetWithinDownshift(event.target, [_this7._rootNode, _this7._menuNode], _this7.props.environment.document);

            if (!contextWithinDownshift && _this7.getState().isOpen) {
              _this7.reset({
                type: mouseUp
              }, function () {
                return _this7.props.onOuterClick(_this7.getStateAndHelpers());
              });
            }
          }; // Touching an element in iOS gives focus and hover states, but touching out of
          // the element will remove hover, and persist the focus state, resulting in the
          // blur event not being triggered.
          // this.isTouchMove helps us track whether the user is tapping or swiping on a touch screen.
          // If the user taps outside of Downshift, the component should be reset,
          // but not if the user is swiping


          var onTouchStart = function onTouchStart() {
            _this7.isTouchMove = false;
          };

          var onTouchMove = function onTouchMove() {
            _this7.isTouchMove = true;
          };

          var onTouchEnd = function onTouchEnd(event) {
            var contextWithinDownshift = targetWithinDownshift(event.target, [_this7._rootNode, _this7._menuNode], _this7.props.environment.document, false);

            if (!_this7.isTouchMove && !contextWithinDownshift && _this7.getState().isOpen) {
              _this7.reset({
                type: touchEnd
              }, function () {
                return _this7.props.onOuterClick(_this7.getStateAndHelpers());
              });
            }
          };

          var environment = this.props.environment;
          environment.addEventListener('mousedown', onMouseDown);
          environment.addEventListener('mouseup', onMouseUp);
          environment.addEventListener('touchstart', onTouchStart);
          environment.addEventListener('touchmove', onTouchMove);
          environment.addEventListener('touchend', onTouchEnd);

          this.cleanup = function () {
            _this7.internalClearTimeouts();

            _this7.updateStatus.cancel();

            environment.removeEventListener('mousedown', onMouseDown);
            environment.removeEventListener('mouseup', onMouseUp);
            environment.removeEventListener('touchstart', onTouchStart);
            environment.removeEventListener('touchmove', onTouchMove);
            environment.removeEventListener('touchend', onTouchEnd);
          };
        }
      };

      _proto.shouldScroll = function shouldScroll(prevState, prevProps) {
        var _ref10 = this.props.highlightedIndex === undefined ? this.getState() : this.props,
            currentHighlightedIndex = _ref10.highlightedIndex;

        var _ref11 = prevProps.highlightedIndex === undefined ? prevState : prevProps,
            prevHighlightedIndex = _ref11.highlightedIndex;

        var scrollWhenOpen = currentHighlightedIndex && this.getState().isOpen && !prevState.isOpen;
        return scrollWhenOpen || currentHighlightedIndex !== prevHighlightedIndex;
      };

      _proto.componentDidUpdate = function componentDidUpdate(prevProps, prevState) {
        {
          validateControlledUnchanged(prevProps, this.props);
          /* istanbul ignore if (react-native) */

          if (this.getMenuProps.called && !this.getMenuProps.suppressRefError) {
            validateGetMenuPropsCalledCorrectly(this._menuNode, this.getMenuProps);
          }
        }

        if (isControlledProp(this.props, 'selectedItem') && this.props.selectedItemChanged(prevProps.selectedItem, this.props.selectedItem)) {
          this.internalSetState({
            type: controlledPropUpdatedSelectedItem,
            inputValue: this.props.itemToString(this.props.selectedItem)
          });
        }

        if (!this.avoidScrolling && this.shouldScroll(prevState, prevProps)) {
          this.scrollHighlightedItemIntoView();
        }
        /* istanbul ignore else (react-native) */


        this.updateStatus();
      };

      _proto.componentWillUnmount = function componentWillUnmount() {
        this.cleanup(); // avoids memory leak
      };

      _proto.render = function render() {
        var children = unwrapArray(this.props.children, noop$2); // because the items are rerendered every time we call the children
        // we clear this out each render and it will be populated again as
        // getItemProps is called.

        this.clearItems(); // we reset this so we know whether the user calls getRootProps during
        // this render. If they do then we don't need to do anything,
        // if they don't then we need to clone the element they return and
        // apply the props for them.

        this.getRootProps.called = false;
        this.getRootProps.refKey = undefined;
        this.getRootProps.suppressRefError = undefined; // we do something similar for getMenuProps

        this.getMenuProps.called = false;
        this.getMenuProps.refKey = undefined;
        this.getMenuProps.suppressRefError = undefined; // we do something similar for getLabelProps

        this.getLabelProps.called = false; // and something similar for getInputProps

        this.getInputProps.called = false;
        var element = unwrapArray(children(this.getStateAndHelpers()));

        if (!element) {
          return null;
        }

        if (this.getRootProps.called || this.props.suppressRefError) {
          if (!this.getRootProps.suppressRefError && !this.props.suppressRefError) {
            validateGetRootPropsCalledCorrectly(element, this.getRootProps);
          }

          return element;
        } else if (isDOMElement(element)) {
          // they didn't apply the root props, but we can clone
          // this and apply the props ourselves
          return /*#__PURE__*/React.cloneElement(element, this.getRootProps(getElementProps(element)));
        }
        /* istanbul ignore else */


        {
          // they didn't apply the root props, but they need to
          // otherwise we can't query around the autocomplete
          throw new Error('downshift: If you return a non-DOM element, you must apply the getRootProps function');
        }
      };

      return Downshift;
    }(React.Component);

    Downshift.defaultProps = {
      defaultHighlightedIndex: null,
      defaultIsOpen: false,
      getA11yStatusMessage: getA11yStatusMessage,
      itemToString: function itemToString(i) {
        if (i == null) {
          return '';
        }

        if (isPlainObject(i) && !i.hasOwnProperty('toString')) {
          // eslint-disable-next-line no-console
          console.warn('downshift: An object was passed to the default implementation of `itemToString`. You should probably provide your own `itemToString` implementation. Please refer to the `itemToString` API documentation.', 'The object that was passed:', i);
        }

        return String(i);
      },
      onStateChange: noop$2,
      onInputValueChange: noop$2,
      onUserAction: noop$2,
      onChange: noop$2,
      onSelect: noop$2,
      onOuterClick: noop$2,
      selectedItemChanged: function selectedItemChanged(prevItem, item) {
        return prevItem !== item;
      },
      environment: typeof window === 'undefined'
      /* istanbul ignore next (ssr) */
      ? {} : window,
      stateReducer: function stateReducer(state, stateToSet) {
        return stateToSet;
      },
      suppressRefError: false,
      scrollIntoView: scrollIntoView
    };
    Downshift.stateChangeTypes = stateChangeTypes;
    return Downshift;
  }();

  Downshift.propTypes = {
    children: PropTypes__default['default'].func,
    defaultHighlightedIndex: PropTypes__default['default'].number,
    defaultIsOpen: PropTypes__default['default'].bool,
    initialHighlightedIndex: PropTypes__default['default'].number,
    initialSelectedItem: PropTypes__default['default'].any,
    initialInputValue: PropTypes__default['default'].string,
    initialIsOpen: PropTypes__default['default'].bool,
    getA11yStatusMessage: PropTypes__default['default'].func,
    itemToString: PropTypes__default['default'].func,
    onChange: PropTypes__default['default'].func,
    onSelect: PropTypes__default['default'].func,
    onStateChange: PropTypes__default['default'].func,
    onInputValueChange: PropTypes__default['default'].func,
    onUserAction: PropTypes__default['default'].func,
    onOuterClick: PropTypes__default['default'].func,
    selectedItemChanged: PropTypes__default['default'].func,
    stateReducer: PropTypes__default['default'].func,
    itemCount: PropTypes__default['default'].number,
    id: PropTypes__default['default'].string,
    environment: PropTypes__default['default'].shape({
      addEventListener: PropTypes__default['default'].func,
      removeEventListener: PropTypes__default['default'].func,
      document: PropTypes__default['default'].shape({
        getElementById: PropTypes__default['default'].func,
        activeElement: PropTypes__default['default'].any,
        body: PropTypes__default['default'].any
      })
    }),
    suppressRefError: PropTypes__default['default'].bool,
    scrollIntoView: PropTypes__default['default'].func,
    // things we keep in state for uncontrolled components
    // but can accept as props for controlled components

    /* eslint-disable react/no-unused-prop-types */
    selectedItem: PropTypes__default['default'].any,
    isOpen: PropTypes__default['default'].bool,
    inputValue: PropTypes__default['default'].string,
    highlightedIndex: PropTypes__default['default'].number,
    labelId: PropTypes__default['default'].string,
    inputId: PropTypes__default['default'].string,
    menuId: PropTypes__default['default'].string,
    getItemId: PropTypes__default['default'].func
    /* eslint-enable react/no-unused-prop-types */

  } ;

  function validateGetMenuPropsCalledCorrectly(node, _ref12) {
    var refKey = _ref12.refKey;

    if (!node) {
      // eslint-disable-next-line no-console
      console.error("downshift: The ref prop \"" + refKey + "\" from getMenuProps was not applied correctly on your menu element.");
    }
  }

  function validateGetRootPropsCalledCorrectly(element, _ref13) {
    var refKey = _ref13.refKey;
    var refKeySpecified = refKey !== 'ref';
    var isComposite = !isDOMElement(element);

    if (isComposite && !refKeySpecified && !reactIs.isForwardRef(element)) {
      // eslint-disable-next-line no-console
      console.error('downshift: You returned a non-DOM element. You must specify a refKey in getRootProps');
    } else if (!isComposite && refKeySpecified) {
      // eslint-disable-next-line no-console
      console.error("downshift: You returned a DOM element. You should not specify a refKey in getRootProps. You specified \"" + refKey + "\"");
    }

    if (!reactIs.isForwardRef(element) && !getElementProps(element)[refKey]) {
      // eslint-disable-next-line no-console
      console.error("downshift: You must apply the ref prop \"" + refKey + "\" from getRootProps onto your root element.");
    }
  }

  function validateControlledUnchanged(prevProps, nextProps) {
    var warningDescription = "This prop should not switch from controlled to uncontrolled (or vice versa). Decide between using a controlled or uncontrolled Downshift element for the lifetime of the component. More info: https://github.com/downshift-js/downshift#control-props";
    ['selectedItem', 'isOpen', 'inputValue', 'highlightedIndex'].forEach(function (propKey) {
      if (prevProps[propKey] !== undefined && nextProps[propKey] === undefined) {
        // eslint-disable-next-line no-console
        console.error("downshift: A component has changed the controlled prop \"" + propKey + "\" to be uncontrolled. " + warningDescription);
      } else if (prevProps[propKey] === undefined && nextProps[propKey] !== undefined) {
        // eslint-disable-next-line no-console
        console.error("downshift: A component has changed the uncontrolled prop \"" + propKey + "\" to be controlled. " + warningDescription);
      }
    });
  }

  var dropdownDefaultStateValues = {
    highlightedIndex: -1,
    isOpen: false,
    selectedItem: null,
    inputValue: ''
  };

  function callOnChangeProps(action, state, newState) {
    var props = action.props,
        type = action.type;
    var changes = {};
    Object.keys(state).forEach(function (key) {
      invokeOnChangeHandler(key, props, state, newState);

      if (newState[key] !== state[key]) {
        changes[key] = newState[key];
      }
    });

    if (props.onStateChange && Object.keys(changes).length) {
      props.onStateChange(_extends({
        type: type
      }, changes));
    }
  }

  function invokeOnChangeHandler(key, props, state, newState) {
    var handler = "on" + capitalizeString(key) + "Change";

    if (props[handler] && newState[key] !== undefined && newState[key] !== state[key]) {
      props[handler](newState);
    }
  }
  /**
   * Default state reducer that returns the changes.
   *
   * @param {Object} s state.
   * @param {Object} a action with changes.
   * @returns {Object} changes.
   */


  function stateReducer(s, a) {
    return a.changes;
  }
  /**
   * Returns a message to be added to aria-live region when item is selected.
   *
   * @param {Object} selectionParameters Parameters required to build the message.
   * @returns {string} The a11y message.
   */


  function getA11ySelectionMessage(selectionParameters) {
    var selectedItem = selectionParameters.selectedItem,
        itemToStringLocal = selectionParameters.itemToString;
    return selectedItem ? itemToStringLocal(selectedItem) + " has been selected." : '';
  }
  /**
   * Debounced call for updating the a11y message.
   */


  var updateA11yStatus = debounce$2(function (getA11yMessage, document) {
    setStatus(getA11yMessage(), document);
  }, 200);

  function getElementIds(_ref) {
    var id = _ref.id,
        labelId = _ref.labelId,
        menuId = _ref.menuId,
        getItemId = _ref.getItemId,
        toggleButtonId = _ref.toggleButtonId;
    var uniqueId = id === undefined ? "downshift-" + generateId() : id;
    return {
      labelId: labelId || uniqueId + "-label",
      menuId: menuId || uniqueId + "-menu",
      getItemId: getItemId || function (index) {
        return uniqueId + "-item-" + index;
      },
      toggleButtonId: toggleButtonId || uniqueId + "-toggle-button"
    };
  }

  function getItemIndex(index, item, items) {
    if (index !== undefined) {
      return index;
    }

    if (items.length === 0) {
      return -1;
    }

    return items.indexOf(item);
  }

  function itemToString$1(item) {
    return item ? String(item) : '';
  }

  function getPropTypesValidator(caller, propTypes) {
    // istanbul ignore next
    return function (options) {
      if (options === void 0) {
        options = {};
      }

      Object.keys(propTypes).forEach(function (key) {
        PropTypes__default['default'].checkPropTypes(propTypes, options, key, caller.name);
      });
    };
  }

  function isAcceptedCharacterKey(key) {
    return /^\S{1}$/.test(key);
  }

  function capitalizeString(string) {
    return "" + string.slice(0, 1).toUpperCase() + string.slice(1);
  }
  /**
   * Computes the controlled state using a the previous state, props,
   * two reducers, one from downshift and an optional one from the user.
   * Also calls the onChange handlers for state values that have changed.
   *
   * @param {Function} reducer Reducer function from downshift.
   * @param {Object} initialState Initial state of the hook.
   * @param {Object} props The hook props.
   * @returns {Array} An array with the state and an action dispatcher.
   */


  function useControlledState(reducer, initialState, props) {
    var _useState = React.useState(initialState),
        uncontrolledState = _useState[0],
        setState = _useState[1];

    var state = getState(uncontrolledState, props);

    var dispatch = function dispatch(action) {
      var stateReducerFromProps = action.props.stateReducer;
      var changes = reducer(state, action);
      var newState = stateReducerFromProps(state, _extends({}, action, {
        changes: changes
      }));
      callOnChangeProps(action, state, newState);
      setState(newState);
    };

    return [getState(state, props), function dispatchWithProps(action) {
      return dispatch(_extends({
        props: props
      }, action));
    }];
  }

  var defaultProps = {
    itemToString: itemToString$1,
    stateReducer: stateReducer,
    getA11ySelectionMessage: getA11ySelectionMessage,
    scrollIntoView: scrollIntoView,
    circularNavigation: false,
    environment: typeof window === 'undefined'
    /* istanbul ignore next (ssr) */
    ? {} : window
  };

  function getDefaultValue(props, propKey, defaultStateValues) {
    if (defaultStateValues === void 0) {
      defaultStateValues = dropdownDefaultStateValues;
    }

    var defaultPropKey = "default" + capitalizeString(propKey);

    if (defaultPropKey in props) {
      return props[defaultPropKey];
    }

    return defaultStateValues[propKey];
  }

  function getInitialValue(props, propKey, defaultStateValues) {
    if (defaultStateValues === void 0) {
      defaultStateValues = dropdownDefaultStateValues;
    }

    if (propKey in props) {
      return props[propKey];
    }

    var initialPropKey = "initial" + capitalizeString(propKey);

    if (initialPropKey in props) {
      return props[initialPropKey];
    }

    return getDefaultValue(props, propKey, defaultStateValues);
  }

  function getInitialState(props) {
    var selectedItem = getInitialValue(props, 'selectedItem');
    var isOpen = getInitialValue(props, 'isOpen');
    var highlightedIndex = getInitialValue(props, 'highlightedIndex');
    var inputValue = getInitialValue(props, 'inputValue');
    return {
      highlightedIndex: highlightedIndex < 0 && selectedItem ? props.items.indexOf(selectedItem) : highlightedIndex,
      isOpen: isOpen,
      selectedItem: selectedItem,
      inputValue: inputValue
    };
  }

  function getHighlightedIndexOnOpen(props, state, offset, getItemNodeFromIndex) {
    var items = props.items,
        initialHighlightedIndex = props.initialHighlightedIndex,
        defaultHighlightedIndex = props.defaultHighlightedIndex;
    var selectedItem = state.selectedItem,
        highlightedIndex = state.highlightedIndex; // initialHighlightedIndex will give value to highlightedIndex on initial state only.

    if (initialHighlightedIndex !== undefined && highlightedIndex === initialHighlightedIndex) {
      return initialHighlightedIndex;
    }

    if (defaultHighlightedIndex !== undefined) {
      return defaultHighlightedIndex;
    }

    if (selectedItem) {
      if (offset === 0) {
        return items.indexOf(selectedItem);
      }

      return getNextWrappingIndex(offset, items.indexOf(selectedItem), items.length, getItemNodeFromIndex, false);
    }

    if (offset === 0) {
      return -1;
    }

    return offset < 0 ? items.length - 1 : 0;
  }

  function getItemIndexByCharacterKey(keysSoFar, highlightedIndex, items, itemToStringParam, getItemNodeFromIndex) {
    var lowerCasedItemStrings = items.map(function (item) {
      return itemToStringParam(item).toLowerCase();
    });
    var lowerCasedKeysSoFar = keysSoFar.toLowerCase();

    var isValid = function isValid(itemString, index) {
      var element = getItemNodeFromIndex(index);
      return itemString.startsWith(lowerCasedKeysSoFar) && !(element && element.hasAttribute('disabled'));
    };

    for (var index = highlightedIndex + 1; index < lowerCasedItemStrings.length; index++) {
      var itemString = lowerCasedItemStrings[index];

      if (isValid(itemString, index)) {
        return index;
      }
    }

    for (var _index = 0; _index < highlightedIndex; _index++) {
      var _itemString = lowerCasedItemStrings[_index];

      if (isValid(_itemString, _index)) {
        return _index;
      }
    }

    return highlightedIndex;
  }

  var propTypes = {
    items: PropTypes__default['default'].array.isRequired,
    itemToString: PropTypes__default['default'].func,
    getA11yStatusMessage: PropTypes__default['default'].func,
    getA11ySelectionMessage: PropTypes__default['default'].func,
    circularNavigation: PropTypes__default['default'].bool,
    highlightedIndex: PropTypes__default['default'].number,
    defaultHighlightedIndex: PropTypes__default['default'].number,
    initialHighlightedIndex: PropTypes__default['default'].number,
    isOpen: PropTypes__default['default'].bool,
    defaultIsOpen: PropTypes__default['default'].bool,
    initialIsOpen: PropTypes__default['default'].bool,
    selectedItem: PropTypes__default['default'].any,
    initialSelectedItem: PropTypes__default['default'].any,
    defaultSelectedItem: PropTypes__default['default'].any,
    id: PropTypes__default['default'].string,
    labelId: PropTypes__default['default'].string,
    menuId: PropTypes__default['default'].string,
    getItemId: PropTypes__default['default'].func,
    toggleButtonId: PropTypes__default['default'].string,
    stateReducer: PropTypes__default['default'].func,
    onSelectedItemChange: PropTypes__default['default'].func,
    onHighlightedIndexChange: PropTypes__default['default'].func,
    onStateChange: PropTypes__default['default'].func,
    onIsOpenChange: PropTypes__default['default'].func,
    environment: PropTypes__default['default'].shape({
      addEventListener: PropTypes__default['default'].func,
      removeEventListener: PropTypes__default['default'].func,
      document: PropTypes__default['default'].shape({
        getElementById: PropTypes__default['default'].func,
        activeElement: PropTypes__default['default'].any,
        body: PropTypes__default['default'].any
      })
    })
  };
  /**
   * Default implementation for status message. Only added when menu is open.
   * Will specift if there are results in the list, and if so, how many,
   * and what keys are relevant.
   *
   * @param {Object} param the downshift state and other relevant properties
   * @return {String} the a11y status message
   */

  function getA11yStatusMessage$1(_ref) {
    var isOpen = _ref.isOpen,
        resultCount = _ref.resultCount,
        previousResultCount = _ref.previousResultCount;

    if (!isOpen) {
      return '';
    }

    if (!resultCount) {
      return 'No results are available.';
    }

    if (resultCount !== previousResultCount) {
      return resultCount + " result" + (resultCount === 1 ? ' is' : 's are') + " available, use up and down arrow keys to navigate. Press Enter or Space Bar keys to select.";
    }

    return '';
  }

  var defaultProps$1 = _extends({}, defaultProps, {
    getA11yStatusMessage: getA11yStatusMessage$1
  });

  var MenuKeyDownArrowDown$1 = '__menu_keydown_arrow_down__' ;
  var MenuKeyDownArrowUp$1 = '__menu_keydown_arrow_up__' ;
  var MenuKeyDownEscape$1 = '__menu_keydown_escape__' ;
  var MenuKeyDownHome = '__menu_keydown_home__' ;
  var MenuKeyDownEnd = '__menu_keydown_end__' ;
  var MenuKeyDownEnter$1 = '__menu_keydown_enter__' ;
  var MenuKeyDownSpaceButton$1 = '__menu_keydown_space_button__' ;
  var MenuKeyDownCharacter = '__menu_keydown_character__' ;
  var MenuBlur$1 = '__menu_blur__' ;
  var MenuMouseLeave = '__menu_mouse_leave__' ;
  var ItemMouseMove = '__item_mouse_move__' ;
  var ItemClick$1 = '__item_click__' ;
  var ToggleButtonClick$1 = '__togglebutton_click__' ;
  var ToggleButtonKeyDownArrowDown = '__togglebutton_keydown_arrow_down__' ;
  var ToggleButtonKeyDownArrowUp = '__togglebutton_keydown_arrow_up__' ;
  var ToggleButtonKeyDownCharacter = '__togglebutton_keydown_character__' ;
  var FunctionToggleMenu = '__function_toggle_menu__' ;
  var FunctionOpenMenu = '__function_open_menu__' ;
  var FunctionCloseMenu = '__function_close_menu__' ;
  var FunctionSetHighlightedIndex = '__function_set_highlighted_index__' ;
  var FunctionSelectItem = '__function_select_item__' ;
  var FunctionSetInputValue = '__function_set_input_value__' ;
  var FunctionReset = '__function_reset__' ;
  var stateChangeTypes$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    MenuKeyDownArrowDown: MenuKeyDownArrowDown$1,
    MenuKeyDownArrowUp: MenuKeyDownArrowUp$1,
    MenuKeyDownEscape: MenuKeyDownEscape$1,
    MenuKeyDownHome: MenuKeyDownHome,
    MenuKeyDownEnd: MenuKeyDownEnd,
    MenuKeyDownEnter: MenuKeyDownEnter$1,
    MenuKeyDownSpaceButton: MenuKeyDownSpaceButton$1,
    MenuKeyDownCharacter: MenuKeyDownCharacter,
    MenuBlur: MenuBlur$1,
    MenuMouseLeave: MenuMouseLeave,
    ItemMouseMove: ItemMouseMove,
    ItemClick: ItemClick$1,
    ToggleButtonClick: ToggleButtonClick$1,
    ToggleButtonKeyDownArrowDown: ToggleButtonKeyDownArrowDown,
    ToggleButtonKeyDownArrowUp: ToggleButtonKeyDownArrowUp,
    ToggleButtonKeyDownCharacter: ToggleButtonKeyDownCharacter,
    FunctionToggleMenu: FunctionToggleMenu,
    FunctionOpenMenu: FunctionOpenMenu,
    FunctionCloseMenu: FunctionCloseMenu,
    FunctionSetHighlightedIndex: FunctionSetHighlightedIndex,
    FunctionSelectItem: FunctionSelectItem,
    FunctionSetInputValue: FunctionSetInputValue,
    FunctionReset: FunctionReset
  });
  /* eslint-disable complexity */

  function downshiftSelectReducer(state, action) {
    var type = action.type,
        props = action.props,
        shiftKey = action.shiftKey;
    var changes;

    switch (type) {
      case ItemMouseMove:
        changes = {
          highlightedIndex: action.index
        };
        break;

      case ItemClick$1:
        changes = {
          isOpen: getDefaultValue(props, 'isOpen'),
          highlightedIndex: getDefaultValue(props, 'highlightedIndex'),
          selectedItem: props.items[action.index]
        };
        break;

      case ToggleButtonKeyDownCharacter:
        {
          var lowercasedKey = action.key;
          var inputValue = "" + state.inputValue + lowercasedKey;
          var itemIndex = getItemIndexByCharacterKey(inputValue, state.selectedItem ? props.items.indexOf(state.selectedItem) : -1, props.items, props.itemToString, action.getItemNodeFromIndex);
          changes = _extends({
            inputValue: inputValue
          }, itemIndex >= 0 && {
            selectedItem: props.items[itemIndex]
          });
        }
        break;

      case ToggleButtonKeyDownArrowDown:
        changes = {
          highlightedIndex: getHighlightedIndexOnOpen(props, state, 1, action.getItemNodeFromIndex),
          isOpen: true
        };
        break;

      case ToggleButtonKeyDownArrowUp:
        changes = {
          highlightedIndex: getHighlightedIndexOnOpen(props, state, -1, action.getItemNodeFromIndex),
          isOpen: true
        };
        break;

      case MenuKeyDownEnter$1:
      case MenuKeyDownSpaceButton$1:
        changes = _extends({
          isOpen: getDefaultValue(props, 'isOpen'),
          highlightedIndex: getDefaultValue(props, 'highlightedIndex')
        }, state.highlightedIndex >= 0 && {
          selectedItem: props.items[state.highlightedIndex]
        });
        break;

      case MenuKeyDownHome:
        changes = {
          highlightedIndex: getNextNonDisabledIndex(1, 0, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;

      case MenuKeyDownEnd:
        changes = {
          highlightedIndex: getNextNonDisabledIndex(-1, props.items.length - 1, props.items.length, action.getItemNodeFromIndex, false)
        };
        break;

      case MenuKeyDownEscape$1:
        changes = {
          isOpen: false,
          highlightedIndex: -1
        };
        break;

      case MenuBlur$1:
        changes = {
          isOpen: false,
          highlightedIndex: -1
        };
        break;

      case MenuKeyDownCharacter:
        {
          var _lowercasedKey = action.key;

          var _inputValue = "" + state.inputValue + _lowercasedKey;

          var highlightedIndex = getItemIndexByCharacterKey(_inputValue, state.highlightedIndex, props.items, props.itemToString, action.getItemNodeFromIndex);
          changes = _extends({
            inputValue: _inputValue
          }, highlightedIndex >= 0 && {
            highlightedIndex: highlightedIndex
          });
        }
        break;

      case MenuKeyDownArrowDown$1:
        changes = {
          highlightedIndex: getNextWrappingIndex(shiftKey ? 5 : 1, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, props.circularNavigation)
        };
        break;

      case MenuKeyDownArrowUp$1:
        changes = {
          highlightedIndex: getNextWrappingIndex(shiftKey ? -5 : -1, state.highlightedIndex, props.items.length, action.getItemNodeFromIndex, props.circularNavigation)
        };
        break;

      case MenuMouseLeave:
        changes = {
          highlightedIndex: -1
        };
        break;

      case ToggleButtonClick$1:
      case FunctionToggleMenu:
        changes = {
          isOpen: !state.isOpen,
          highlightedIndex: state.isOpen ? -1 : getHighlightedIndexOnOpen(props, state, 0)
        };
        break;

      case FunctionOpenMenu:
        changes = {
          isOpen: true,
          highlightedIndex: getHighlightedIndexOnOpen(props, state, 0)
        };
        break;

      case FunctionCloseMenu:
        changes = {
          isOpen: false
        };
        break;

      case FunctionSetHighlightedIndex:
        changes = {
          highlightedIndex: action.highlightedIndex
        };
        break;

      case FunctionSelectItem:
        changes = {
          selectedItem: action.selectedItem
        };
        break;

      case FunctionSetInputValue:
        changes = {
          inputValue: action.inputValue
        };
        break;

      case FunctionReset:
        changes = {
          highlightedIndex: getDefaultValue(props, 'highlightedIndex'),
          isOpen: getDefaultValue(props, 'isOpen'),
          selectedItem: getDefaultValue(props, 'selectedItem'),
          inputValue: getDefaultValue(props, 'inputValue')
        };
        break;

      default:
        throw new Error('Reducer called without proper action type.');
    }

    return _extends({}, state, {}, changes);
  }
  /* eslint-enable complexity */


  var validatePropTypes = getPropTypesValidator(useSelect, propTypes);
  useSelect.stateChangeTypes = stateChangeTypes$1;

  function useSelect(userProps) {
    if (userProps === void 0) {
      userProps = {};
    }
    /* istanbul ignore else */


    {
      validatePropTypes(userProps);
    } // Props defaults and destructuring.


    var props = _extends({}, defaultProps$1, {}, userProps);

    var items = props.items,
        scrollIntoView = props.scrollIntoView,
        environment = props.environment,
        initialIsOpen = props.initialIsOpen,
        defaultIsOpen = props.defaultIsOpen,
        itemToString = props.itemToString,
        getA11ySelectionMessage = props.getA11ySelectionMessage,
        getA11yStatusMessage = props.getA11yStatusMessage; // Initial state depending on controlled props.

    var initialState = getInitialState(props); // Reducer init.

    var _useControlledState = useControlledState(downshiftSelectReducer, initialState, props),
        _useControlledState$ = _useControlledState[0],
        isOpen = _useControlledState$.isOpen,
        highlightedIndex = _useControlledState$.highlightedIndex,
        selectedItem = _useControlledState$.selectedItem,
        inputValue = _useControlledState$.inputValue,
        dispatch = _useControlledState[1]; // Refs


    var toggleButtonRef = React.useRef(null);
    var menuRef = React.useRef(null);
    var isInitialMount = React.useRef(true);
    var shouldScroll = React.useRef(true);
    var clearTimeout = React.useRef(null);
    var mouseAndTouchTrackers = React.useRef({
      isMouseDown: false,
      isTouchMove: false
    });
    var elementIds = React.useRef(getElementIds(props));
    var previousResultCountRef = React.useRef(); // Some utils.

    var getItemNodeFromIndex = function getItemNodeFromIndex(index) {
      return environment.document.getElementById(elementIds.current.getItemId(index));
    }; // Effects.

    /* Sets a11y status message on changes in state. */


    React.useEffect(function () {
      if (isInitialMount.current) {
        return;
      }

      var previousResultCount = previousResultCountRef.current;
      updateA11yStatus(function () {
        return getA11yStatusMessage({
          isOpen: isOpen,
          highlightedIndex: highlightedIndex,
          selectedItem: selectedItem,
          inputValue: inputValue,
          highlightedItem: items[highlightedIndex],
          resultCount: items.length,
          itemToString: itemToString,
          previousResultCount: previousResultCount
        });
      }, environment.document); // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [isOpen, highlightedIndex, selectedItem, inputValue]);
    /* Sets a11y status message on changes in selectedItem. */

    React.useEffect(function () {
      if (isInitialMount.current) {
        return;
      }

      var previousResultCount = previousResultCountRef.current;
      updateA11yStatus(function () {
        return getA11ySelectionMessage({
          isOpen: isOpen,
          highlightedIndex: highlightedIndex,
          selectedItem: selectedItem,
          inputValue: inputValue,
          highlightedItem: items[highlightedIndex],
          resultCount: items.length,
          itemToString: itemToString,
          previousResultCount: previousResultCount
        });
      }, environment.document); // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [selectedItem]);
    /* Sets cleanup for the keysSoFar after 500ms. */

    React.useEffect(function () {
      // init the clean function here as we need access to dispatch.
      if (isInitialMount.current) {
        clearTimeout.current = debounce$2(function (outerDispatch) {
          outerDispatch({
            type: FunctionSetInputValue,
            inputValue: ''
          });
        }, 500);
      }

      if (!inputValue) {
        return;
      }

      clearTimeout.current(dispatch); // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [inputValue]);
    /* Controls the focus on the menu or the toggle button. */

    React.useEffect(function () {
      // Don't focus menu on first render.
      if (isInitialMount.current) {
        // Unless it was initialised as open.
        if ((initialIsOpen || defaultIsOpen || isOpen) && menuRef.current) {
          menuRef.current.focus();
        }

        return;
      } // Focus menu on open.
      // istanbul ignore next


      if (isOpen && menuRef.current) {
        menuRef.current.focus(); // Focus toggleButton on close.
      } else if (environment.document.activeElement === menuRef.current && toggleButtonRef.current) {
        toggleButtonRef.current.focus();
      } // eslint-disable-next-line react-hooks/exhaustive-deps

    }, [isOpen]);
    /* Scroll on highlighted item if change comes from keyboard. */

    React.useEffect(function () {
      if (highlightedIndex < 0 || !isOpen || !items.length) {
        return;
      }

      if (shouldScroll.current === false) {
        shouldScroll.current = true;
      } else {
        scrollIntoView(getItemNodeFromIndex(highlightedIndex), menuRef.current);
      } // eslint-disable-next-line react-hooks/exhaustive-deps

    }, [highlightedIndex]);
    React.useEffect(function () {
      if (isInitialMount.current) {
        return;
      }

      previousResultCountRef.current = items.length;
    });
    /* Make initial ref false. */

    React.useEffect(function () {
      isInitialMount.current = false;
    }, []);
    /* Add mouse/touch events to document. */

    React.useEffect(function () {
      // The same strategy for checking if a click occurred inside or outside downsift
      // as in downshift.js.
      var onMouseDown = function onMouseDown() {
        mouseAndTouchTrackers.current.isMouseDown = true;
      };

      var onMouseUp = function onMouseUp(event) {
        mouseAndTouchTrackers.current.isMouseDown = false;

        if (isOpen && !targetWithinDownshift(event.target, [toggleButtonRef.current, menuRef.current], environment.document)) {
          dispatch({
            type: MenuBlur$1
          });
        }
      };

      var onTouchStart = function onTouchStart() {
        mouseAndTouchTrackers.current.isTouchMove = false;
      };

      var onTouchMove = function onTouchMove() {
        mouseAndTouchTrackers.current.isTouchMove = true;
      };

      var onTouchEnd = function onTouchEnd(event) {
        if (isOpen && !mouseAndTouchTrackers.current.isTouchMove && !targetWithinDownshift(event.target, [toggleButtonRef.current, menuRef.current], environment.document, false)) {
          dispatch({
            type: MenuBlur$1
          });
        }
      };

      environment.addEventListener('mousedown', onMouseDown);
      environment.addEventListener('mouseup', onMouseUp);
      environment.addEventListener('touchstart', onTouchStart);
      environment.addEventListener('touchmove', onTouchMove);
      environment.addEventListener('touchend', onTouchEnd);
      return function () {
        environment.removeEventListener('mousedown', onMouseDown);
        environment.removeEventListener('mouseup', onMouseUp);
        environment.removeEventListener('touchstart', onTouchStart);
        environment.removeEventListener('touchmove', onTouchMove);
        environment.removeEventListener('touchend', onTouchEnd);
      };
    }); // Event handler functions.

    var toggleButtonKeyDownHandlers = {
      ArrowDown: function ArrowDown(event) {
        event.preventDefault();
        dispatch({
          type: ToggleButtonKeyDownArrowDown,
          getItemNodeFromIndex: getItemNodeFromIndex,
          shiftKey: event.shiftKey
        });
      },
      ArrowUp: function ArrowUp(event) {
        event.preventDefault();
        dispatch({
          type: ToggleButtonKeyDownArrowUp,
          getItemNodeFromIndex: getItemNodeFromIndex,
          shiftKey: event.shiftKey
        });
      }
    };
    var menuKeyDownHandlers = {
      ArrowDown: function ArrowDown(event) {
        event.preventDefault();
        dispatch({
          type: MenuKeyDownArrowDown$1,
          getItemNodeFromIndex: getItemNodeFromIndex,
          shiftKey: event.shiftKey
        });
      },
      ArrowUp: function ArrowUp(event) {
        event.preventDefault();
        dispatch({
          type: MenuKeyDownArrowUp$1,
          getItemNodeFromIndex: getItemNodeFromIndex,
          shiftKey: event.shiftKey
        });
      },
      Home: function Home(event) {
        event.preventDefault();
        dispatch({
          type: MenuKeyDownHome,
          getItemNodeFromIndex: getItemNodeFromIndex
        });
      },
      End: function End(event) {
        event.preventDefault();
        dispatch({
          type: MenuKeyDownEnd,
          getItemNodeFromIndex: getItemNodeFromIndex
        });
      },
      Escape: function Escape() {
        dispatch({
          type: MenuKeyDownEscape$1
        });
      },
      Enter: function Enter(event) {
        event.preventDefault();
        dispatch({
          type: MenuKeyDownEnter$1
        });
      },
      ' ': function _(event) {
        event.preventDefault();
        dispatch({
          type: MenuKeyDownSpaceButton$1
        });
      }
    }; // Event handlers.

    var menuHandleKeyDown = function menuHandleKeyDown(event) {
      var key = normalizeArrowKey(event);

      if (key && menuKeyDownHandlers[key]) {
        menuKeyDownHandlers[key](event);
      } else if (isAcceptedCharacterKey(key)) {
        dispatch({
          type: MenuKeyDownCharacter,
          key: key,
          getItemNodeFromIndex: getItemNodeFromIndex
        });
      }
    };

    var menuHandleBlur = function menuHandleBlur() {
      var shouldBlur = !mouseAndTouchTrackers.current.isMouseDown;
      /* istanbul ignore else */

      if (shouldBlur) {
        dispatch({
          type: MenuBlur$1
        });
      }
    };

    var menuHandleMouseLeave = function menuHandleMouseLeave() {
      dispatch({
        type: MenuMouseLeave
      });
    };

    var toggleButtonHandleClick = function toggleButtonHandleClick() {
      dispatch({
        type: ToggleButtonClick$1
      });
    };

    var toggleButtonHandleKeyDown = function toggleButtonHandleKeyDown(event) {
      var key = normalizeArrowKey(event);

      if (key && toggleButtonKeyDownHandlers[key]) {
        toggleButtonKeyDownHandlers[key](event);
      } else if (isAcceptedCharacterKey(key)) {
        dispatch({
          type: ToggleButtonKeyDownCharacter,
          key: key,
          getItemNodeFromIndex: getItemNodeFromIndex
        });
      }
    };

    var itemHandleMouseMove = function itemHandleMouseMove(index) {
      if (index === highlightedIndex) {
        return;
      }

      shouldScroll.current = false;
      dispatch({
        type: ItemMouseMove,
        index: index
      });
    };

    var itemHandleClick = function itemHandleClick(index) {
      dispatch({
        type: ItemClick$1,
        index: index
      });
    }; // Action functions.


    return {
      // prop getters.
      getToggleButtonProps: function getToggleButtonProps(_temp2) {
        var _extends3;

        var _ref2 = _temp2 === void 0 ? {} : _temp2,
            onClick = _ref2.onClick,
            onKeyDown = _ref2.onKeyDown,
            _ref2$refKey = _ref2.refKey,
            refKey = _ref2$refKey === void 0 ? 'ref' : _ref2$refKey,
            ref = _ref2.ref,
            rest = _objectWithoutPropertiesLoose(_ref2, ["onClick", "onKeyDown", "refKey", "ref"]);

        var toggleProps = _extends((_extends3 = {}, _extends3[refKey] = handleRefs(ref, function (toggleButtonNode) {
          toggleButtonRef.current = toggleButtonNode;
        }), _extends3.id = elementIds.current.toggleButtonId, _extends3['aria-haspopup'] = 'listbox', _extends3['aria-expanded'] = isOpen, _extends3['aria-labelledby'] = elementIds.current.labelId + " " + elementIds.current.toggleButtonId, _extends3), rest);

        if (!rest.disabled) {
          toggleProps.onClick = callAllEventHandlers(onClick, toggleButtonHandleClick);
          toggleProps.onKeyDown = callAllEventHandlers(onKeyDown, toggleButtonHandleKeyDown);
        }

        return toggleProps;
      },
      getLabelProps: function getLabelProps(labelProps) {
        return _extends({
          id: elementIds.current.labelId,
          htmlFor: elementIds.current.toggleButtonId
        }, labelProps);
      },
      getMenuProps: function getMenuProps(_temp) {
        var _extends2;

        var _ref = _temp === void 0 ? {} : _temp,
            onMouseLeave = _ref.onMouseLeave,
            _ref$refKey = _ref.refKey,
            refKey = _ref$refKey === void 0 ? 'ref' : _ref$refKey,
            onKeyDown = _ref.onKeyDown,
            onBlur = _ref.onBlur,
            ref = _ref.ref,
            rest = _objectWithoutPropertiesLoose(_ref, ["onMouseLeave", "refKey", "onKeyDown", "onBlur", "ref"]);

        return _extends((_extends2 = {}, _extends2[refKey] = handleRefs(ref, function (menuNode) {
          menuRef.current = menuNode;
        }), _extends2.id = elementIds.current.menuId, _extends2.role = 'listbox', _extends2['aria-labelledby'] = elementIds.current.labelId, _extends2.tabIndex = -1, _extends2), isOpen && highlightedIndex > -1 && {
          'aria-activedescendant': elementIds.current.getItemId(highlightedIndex)
        }, {
          onMouseLeave: callAllEventHandlers(onMouseLeave, menuHandleMouseLeave),
          onKeyDown: callAllEventHandlers(onKeyDown, menuHandleKeyDown),
          onBlur: callAllEventHandlers(onBlur, menuHandleBlur)
        }, rest);
      },
      getItemProps: function getItemProps(_temp3) {
        var _ref3 = _temp3 === void 0 ? {} : _temp3,
            item = _ref3.item,
            index = _ref3.index,
            onMouseMove = _ref3.onMouseMove,
            onClick = _ref3.onClick,
            rest = _objectWithoutPropertiesLoose(_ref3, ["item", "index", "onMouseMove", "onClick"]);

        var itemIndex = getItemIndex(index, item, items);

        if (itemIndex < 0) {
          throw new Error('Pass either item or item index in getItemProps!');
        }

        var itemProps = _extends({
          role: 'option',
          'aria-selected': "" + (itemIndex === highlightedIndex),
          id: elementIds.current.getItemId(itemIndex)
        }, rest);

        if (!rest.disabled) {
          itemProps.onMouseMove = callAllEventHandlers(onMouseMove, function () {
            return itemHandleMouseMove(itemIndex);
          });
          itemProps.onClick = callAllEventHandlers(onClick, function () {
            return itemHandleClick(itemIndex);
          });
        }

        return itemProps;
      },
      // actions.
      toggleMenu: function toggleMenu() {
        dispatch({
          type: FunctionToggleMenu
        });
      },
      openMenu: function openMenu() {
        dispatch({
          type: FunctionOpenMenu
        });
      },
      closeMenu: function closeMenu() {
        dispatch({
          type: FunctionCloseMenu
        });
      },
      setHighlightedIndex: function setHighlightedIndex(newHighlightedIndex) {
        dispatch({
          type: FunctionSetHighlightedIndex,
          highlightedIndex: newHighlightedIndex
        });
      },
      selectItem: function selectItem(newSelectedItem) {
        dispatch({
          type: FunctionSelectItem,
          selectedItem: newSelectedItem
        });
      },
      reset: function reset() {
        dispatch({
          type: FunctionReset
        });
      },
      setInputValue: function setInputValue(newInputValue) {
        dispatch({
          type: FunctionSetInputValue,
          inputValue: newInputValue
        });
      },
      // state.
      highlightedIndex: highlightedIndex,
      isOpen: isOpen,
      selectedItem: selectedItem,
      inputValue: inputValue
    };
  }

  ({
    items: PropTypes__default['default'].array.isRequired,
    itemToString: PropTypes__default['default'].func,
    getA11yStatusMessage: PropTypes__default['default'].func,
    getA11ySelectionMessage: PropTypes__default['default'].func,
    circularNavigation: PropTypes__default['default'].bool,
    highlightedIndex: PropTypes__default['default'].number,
    defaultHighlightedIndex: PropTypes__default['default'].number,
    initialHighlightedIndex: PropTypes__default['default'].number,
    isOpen: PropTypes__default['default'].bool,
    defaultIsOpen: PropTypes__default['default'].bool,
    initialIsOpen: PropTypes__default['default'].bool,
    selectedItem: PropTypes__default['default'].any,
    initialSelectedItem: PropTypes__default['default'].any,
    defaultSelectedItem: PropTypes__default['default'].any,
    inputValue: PropTypes__default['default'].string,
    defaultInputValue: PropTypes__default['default'].string,
    initialInputValue: PropTypes__default['default'].string,
    id: PropTypes__default['default'].string,
    labelId: PropTypes__default['default'].string,
    menuId: PropTypes__default['default'].string,
    getItemId: PropTypes__default['default'].func,
    inputId: PropTypes__default['default'].string,
    toggleButtonId: PropTypes__default['default'].string,
    stateReducer: PropTypes__default['default'].func,
    onSelectedItemChange: PropTypes__default['default'].func,
    onHighlightedIndexChange: PropTypes__default['default'].func,
    onStateChange: PropTypes__default['default'].func,
    onIsOpenChange: PropTypes__default['default'].func,
    onInputValueChange: PropTypes__default['default'].func,
    environment: PropTypes__default['default'].shape({
      addEventListener: PropTypes__default['default'].func,
      removeEventListener: PropTypes__default['default'].func,
      document: PropTypes__default['default'].shape({
        getElementById: PropTypes__default['default'].func,
        activeElement: PropTypes__default['default'].any,
        body: PropTypes__default['default'].any
      })
    })
  });

  _extends({}, defaultProps, {
    getA11yStatusMessage: getA11yStatusMessage,
    circularNavigation: true
  });

  ({
    selectedItems: PropTypes__default['default'].array,
    initialSelectedItems: PropTypes__default['default'].array,
    defaultSelectedItems: PropTypes__default['default'].array,
    itemToString: PropTypes__default['default'].func,
    getA11yRemovalMessage: PropTypes__default['default'].func,
    stateReducer: PropTypes__default['default'].func,
    activeIndex: PropTypes__default['default'].number,
    initialActiveIndex: PropTypes__default['default'].number,
    defaultActiveIndex: PropTypes__default['default'].number,
    onActiveIndexChange: PropTypes__default['default'].func,
    onSelectedItemsChange: PropTypes__default['default'].func,
    keyNavigationNext: PropTypes__default['default'].string,
    keyNavigationPrevious: PropTypes__default['default'].string,
    environment: PropTypes__default['default'].shape({
      addEventListener: PropTypes__default['default'].func,
      removeEventListener: PropTypes__default['default'].func,
      document: PropTypes__default['default'].shape({
        getElementById: PropTypes__default['default'].func,
        activeElement: PropTypes__default['default'].any,
        body: PropTypes__default['default'].any
      })
    })
  });

  var ListBoxType = PropTypes__default['default'].oneOf(['default', 'inline']); // TODO V11: remove xl

  var ListBoxSize = PropTypes__default['default'].oneOf(['sm', 'md', 'lg', 'xl']);

  var prefix$2o = settings_1.prefix;

  var handleOnKeyDown = function handleOnKeyDown(event) {
    if (event.keyCode === 27) {
      event.stopPropagation();
    }
  };

  var handleClick = function handleClick(event) {
    event.preventDefault();
    event.stopPropagation();
  };
  /**
   * `ListBox` is a generic container component that handles creating the
   * container class name in response to certain props.
   */


  var ListBox = /*#__PURE__*/React__default['default'].forwardRef(function ListBox(_ref, ref) {
    var _cx;

    var children = _ref.children,
        containerClassName = _ref.className,
        disabled = _ref.disabled,
        type = _ref.type,
        size = _ref.size,
        invalid = _ref.invalid,
        invalidText = _ref.invalidText,
        warn = _ref.warn,
        warnText = _ref.warnText,
        light = _ref.light,
        isOpen = _ref.isOpen,
        rest = _objectWithoutProperties$2(_ref, ["children", "className", "disabled", "type", "size", "invalid", "invalidText", "warn", "warnText", "light", "isOpen"]);

    var showWarning = !invalid && warn;
    var className = classnames((_cx = {}, _defineProperty$2(_cx, containerClassName, !!containerClassName), _defineProperty$2(_cx, "".concat(prefix$2o, "--list-box"), true), _defineProperty$2(_cx, "".concat(prefix$2o, "--list-box--").concat(size), size), _defineProperty$2(_cx, "".concat(prefix$2o, "--list-box--inline"), type === 'inline'), _defineProperty$2(_cx, "".concat(prefix$2o, "--list-box--disabled"), disabled), _defineProperty$2(_cx, "".concat(prefix$2o, "--list-box--light"), light), _defineProperty$2(_cx, "".concat(prefix$2o, "--list-box--expanded"), isOpen), _defineProperty$2(_cx, "".concat(prefix$2o, "--list-box--warning"), showWarning), _cx));
    return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, rest, {
      className: className,
      ref: ref,
      onKeyDown: handleOnKeyDown,
      onClick: handleClick,
      "data-invalid": invalid || undefined
    }), children), invalid ? /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2o, "--form-requirement")
    }, invalidText) : null, showWarning ? /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2o, "--form-requirement")
    }, warnText) : null);
  });
  ListBox.displayName = 'ListBox';
  ListBox.propTypes = {
    /**
     * Provide the contents of your ListBox
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify a class name to be applied on the containing list box node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether the ListBox is currently disabled
     */
    disabled: PropTypes__default['default'].bool.isRequired,

    /**
     * Specify whether the control is currently invalid
     */
    invalid: PropTypes__default['default'].bool,

    /**
     * Specify the text to be displayed when the control is invalid
     */
    invalidText: PropTypes__default['default'].node,

    /**
     * Specify if the control should render open
     */
    isOpen: PropTypes__default['default'].bool,

    /**
     * Specify if the control should use the light variant
     */
    light: PropTypes__default['default'].bool,

    /**
     * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
     */
    size: ListBoxSize,

    /**
     * Specify the "type" of the ListBox. Currently supports either `default` or
     * `inline` as an option.
     */
    type: ListBoxType.isRequired,

    /**
     * Specify whether the control is currently in warning state
     */
    warn: PropTypes__default['default'].bool,

    /**
     * Provide the text that is displayed when the control is in warning state
     */
    warnText: PropTypes__default['default'].node
  };
  ListBox.defaultProps = {
    disabled: false,
    type: 'default'
  };

  var prefix$2n = settings_1.prefix; // No longer used, left export for backward-compatibility
  /**
   * `ListBoxField` is responsible for creating the containing node for valid
   * elements inside of a field. It also provides a11y-related attributes like
   * `role` to make sure a user can focus the given field.
   */

  function ListBoxField(_ref) {
    var children = _ref.children,
        disabled = _ref.disabled,
        tabIndex = _ref.tabIndex,
        rest = _objectWithoutProperties$2(_ref, ["children", "disabled", "tabIndex"]);

    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: "".concat(prefix$2n, "--list-box__field"),
      tabIndex: !disabled && tabIndex || -1
    }, rest), children);
  }

  ListBoxField.propTypes = {
    /**
     * Typically set by `getToggleButtonProps`, this should specify whether the
     * field has a popup.
     */
    'aria-haspopup': PropTypes__default['default'].oneOfType([PropTypes__default['default'].string, PropTypes__default['default'].bool]),

    /**
     * Provide the contents of your ListBoxField
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify if the parent <ListBox> is disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * The role for the component, should be set by `getToggleButtonProps` coming
     * from Downshift
     */
    role: PropTypes__default['default'].string,

    /**
     * Optional prop to specify the tabIndex of the <ListBox> trigger button
     */
    tabIndex: PropTypes__default['default'].oneOfType([PropTypes__default['default'].number, PropTypes__default['default'].string])
  };

  var prefix$2m = settings_1.prefix;

  function useIsTruncated(ref) {
    var _useState = React.useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        isTruncated = _useState2[0],
        setIsTruncated = _useState2[1];

    React.useEffect(function () {
      var _ref$current = ref.current,
          offsetWidth = _ref$current.offsetWidth,
          scrollWidth = _ref$current.scrollWidth;
      setIsTruncated(offsetWidth < scrollWidth);
    }, [ref, setIsTruncated]);
    return isTruncated;
  }
  /**
   * `ListBoxMenuItem` is a helper component for managing the container class
   * name, alongside any classes for any corresponding states, for a generic list
   * box menu item.
   */


  var ListBoxMenuItem = /*#__PURE__*/React__default['default'].forwardRef(function ListBoxMenuItem(_ref, forwardedRef) {
    var _cx;

    var children = _ref.children,
        isActive = _ref.isActive,
        isHighlighted = _ref.isHighlighted,
        title = _ref.title,
        rest = _objectWithoutProperties$2(_ref, ["children", "isActive", "isHighlighted", "title"]);

    var ref = React.useRef(null);
    var isTruncated = useIsTruncated((forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref);
    var className = classnames("".concat(prefix$2m, "--list-box__menu-item"), (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2m, "--list-box__menu-item--active"), isActive), _defineProperty$2(_cx, "".concat(prefix$2m, "--list-box__menu-item--highlighted"), isHighlighted), _cx));
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, rest, {
      className: className,
      title: isTruncated ? title : undefined
    }), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2m, "--list-box__menu-item__option"),
      ref: (forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref
    }, children));
  });
  ListBoxMenuItem.propTypes = {
    /**
     * Specify any children nodes that hsould be rendered inside of the ListBox
     * Menu Item
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify whether the current menu item is "active".
     */
    isActive: PropTypes__default['default'].bool.isRequired,

    /**
     * Specify whether the current menu item is "highlighed".
     */
    isHighlighted: PropTypes__default['default'].bool.isRequired,

    /**
     * Provide an optional tooltip for the ListBoxMenuItem
     */
    title: PropTypes__default['default'].string
  };
  ListBoxMenuItem.defaultProps = {
    isActive: false,
    isHighlighted: false
  };

  var prefix$2l = settings_1.prefix;
  /**
   * `ListBoxMenu` is a simple container node that isolates the `list-box__menu`
   * class into a single component. It is also being used to validate given
   * `children` components.
   */

  var ListBoxMenu = /*#__PURE__*/React__default['default'].forwardRef(function ListBoxMenu(_ref, ref) {
    var children = _ref.children,
        id = _ref.id,
        rest = _objectWithoutProperties$2(_ref, ["children", "id"]);

    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      ref: ref,
      id: id,
      className: "".concat(prefix$2l, "--list-box__menu"),
      role: "listbox"
    }, rest), children);
  });
  ListBoxMenu.displayName = 'ListBoxMenu';
  ListBoxMenu.propTypes = {
    /**
     * Provide the contents of your ListBoxMenu
     */
    children: PropTypes__default['default'].oneOfType([PropTypes__default['default'].node, PropTypes__default['default'].arrayOf(ListBoxMenuItem),
    /**
     * allow single item using the workaround for functional components
     * https://github.com/facebook/react/issues/2979#issuecomment-222379916
     */
    PropTypes__default['default'].shape({
      type: PropTypes__default['default'].oneOf([ListBoxMenuItem])
    }), PropTypes__default['default'].bool // used in Dropdown for closed state
    ]),

    /**
     * Specify a custom `id`
     */
    id: PropTypes__default['default'].string.isRequired
  };

  var _defaultTranslations$5;
  var prefix$2k = settings_1.prefix;
  var translationIds$5 = {
    'close.menu': 'close.menu',
    'open.menu': 'open.menu'
  };
  var defaultTranslations$6 = (_defaultTranslations$5 = {}, _defineProperty$2(_defaultTranslations$5, translationIds$5['close.menu'], 'Close menu'), _defineProperty$2(_defaultTranslations$5, translationIds$5['open.menu'], 'Open menu'), _defaultTranslations$5);
  /**
   * `ListBoxMenuIcon` is used to orient the icon up or down depending on the
   * state of the menu for a given `ListBox`
   */

  var ListBoxMenuIcon = function ListBoxMenuIcon(_ref) {
    var isOpen = _ref.isOpen,
        t = _ref.translateWithId;
    var className = classnames("".concat(prefix$2k, "--list-box__menu-icon"), _defineProperty$2({}, "".concat(prefix$2k, "--list-box__menu-icon--open"), isOpen));
    var description = isOpen ? t('close.menu') : t('open.menu');
    return /*#__PURE__*/React__default['default'].createElement("div", {
      className: className
    }, /*#__PURE__*/React__default['default'].createElement(ChevronDown16, {
      name: "chevron--down",
      "aria-label": description
    }, /*#__PURE__*/React__default['default'].createElement("title", null, description)));
  };

  ListBoxMenuIcon.propTypes = {
    /**
     * Specify whether the menu is currently open, which will influence the
     * direction of the menu icon
     */
    isOpen: PropTypes__default['default'].bool.isRequired,

    /**
     * i18n hook used to provide the appropriate description for the given menu
     * icon. This function takes in an id defined in `translationIds` and should
     * return a string message for that given message id.
     */
    translateWithId: PropTypes__default['default'].func.isRequired
  };
  ListBoxMenuIcon.defaultProps = {
    translateWithId: function translateWithId(id) {
      return defaultTranslations$6[id];
    }
  };

  var _defaultTranslations$4;
  var prefix$2j = settings_1.prefix;
  /**
   * `ListBoxSelection` is used to provide controls for clearing a selection, in
   * addition to conditionally rendering a badge if the control has more than one
   * selection.
   */

  var ListBoxSelection$1 = function ListBoxSelection(_ref) {
    var _cx;

    var clearSelection = _ref.clearSelection,
        selectionCount = _ref.selectionCount,
        t = _ref.translateWithId,
        disabled = _ref.disabled,
        onClearSelection = _ref.onClearSelection;
    var className = classnames("".concat(prefix$2j, "--list-box__selection"), (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2j, "--tag--filter"), selectionCount), _defineProperty$2(_cx, "".concat(prefix$2j, "--list-box__selection--multi"), selectionCount), _cx));

    var handleOnClick = function handleOnClick(event) {
      event.stopPropagation();

      if (disabled) {
        return;
      }

      clearSelection(event);

      if (onClearSelection) {
        onClearSelection(event);
      }
    };

    var handleOnKeyDown = function handleOnKeyDown(event) {
      event.stopPropagation();

      if (disabled) {
        return;
      } // When a user hits ENTER, we'll clear the selection


      if (match(event, Enter)) {
        clearSelection(event);

        if (onClearSelection) {
          onClearSelection(event);
        }
      }
    };

    var description = selectionCount ? t('clear.all') : t('clear.selection');
    var tagClasses = classnames("".concat(prefix$2j, "--tag"), "".concat(prefix$2j, "--tag--filter"), "".concat(prefix$2j, "--tag--high-contrast"), _defineProperty$2({}, "".concat(prefix$2j, "--tag--disabled"), disabled));
    return selectionCount ? /*#__PURE__*/React__default['default'].createElement("div", {
      className: tagClasses
    }, /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$2j, "--tag__label"),
      title: selectionCount
    }, selectionCount), /*#__PURE__*/React__default['default'].createElement("div", {
      role: "button",
      tabIndex: disabled ? -1 : 0,
      className: "".concat(prefix$2j, "--tag__close-icon"),
      onClick: handleOnClick,
      onKeyDown: handleOnKeyDown,
      disabled: disabled,
      "aria-label": t('clear.all'),
      "aria-hidden": true,
      title: description
    }, /*#__PURE__*/React__default['default'].createElement(Close16, null))) : /*#__PURE__*/React__default['default'].createElement("div", {
      role: "button",
      className: className,
      tabIndex: disabled ? -1 : 0,
      onClick: handleOnClick,
      onKeyDown: handleOnKeyDown,
      "aria-label": description,
      "aria-hidden": true,
      title: description
    }, selectionCount, /*#__PURE__*/React__default['default'].createElement(Close16, null));
  };

  var translationIds$4 = {
    'clear.all': 'clear.all',
    'clear.selection': 'clear.selection'
  };
  var defaultTranslations$5 = (_defaultTranslations$4 = {}, _defineProperty$2(_defaultTranslations$4, translationIds$4['clear.all'], 'Clear all selected items'), _defineProperty$2(_defaultTranslations$4, translationIds$4['clear.selection'], 'Clear selected item'), _defaultTranslations$4);
  ListBoxSelection$1.propTypes = {
    /**
     * Specify a function to be invoked when a user interacts with the clear
     * selection element.
     */
    clearSelection: PropTypes__default['default'].func.isRequired,

    /**
     * Specify whether or not the clear selection element should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify an optional `onClearSelection` handler that is called when the underlying
     * element is cleared
     */
    onClearSelection: PropTypes__default['default'].func,

    /**
     * Specify an optional `onClick` handler that is called when the underlying
     * clear selection element is clicked
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Specify an optional `onKeyDown` handler that is called when the underlying
     * clear selection element fires a keydown event
     */
    onKeyDown: PropTypes__default['default'].func,

    /**
     * Specify an optional `selectionCount` value that will be used to determine
     * whether the selection should display a badge or a single clear icon.
     */
    selectionCount: PropTypes__default['default'].number,

    /**
     * i18n hook used to provide the appropriate description for the given menu
     * icon. This function takes in an id defined in `translationIds` and should
     * return a string message for that given message id.
     */
    translateWithId: PropTypes__default['default'].func.isRequired
  };
  ListBoxSelection$1.defaultProps = {
    translateWithId: function translateWithId(id) {
      return defaultTranslations$5[id];
    }
  };

  ListBox.Field = ListBoxField;
  ListBox.Menu = ListBoxMenu;
  ListBox.MenuIcon = ListBoxMenuIcon;
  ListBox.MenuItem = ListBoxMenuItem;
  ListBox.Selection = ListBoxSelection$1;

  var _defaultTranslations$3;
  var prefix$2i = settings_1.prefix;
  /**
   * `ListBoxSelection` is used to provide controls for clearing a selection, in
   * addition to conditionally rendering a badge if the control has more than one
   * selection.
   */

  function ListBoxSelection(_ref) {
    var _cx;

    var clearSelection = _ref.clearSelection,
        selectionCount = _ref.selectionCount,
        t = _ref.translateWithId,
        disabled = _ref.disabled,
        onClearSelection = _ref.onClearSelection,
        rest = _objectWithoutProperties$2(_ref, ["clearSelection", "selectionCount", "translateWithId", "disabled", "onClearSelection"]);

    var className = classnames("".concat(prefix$2i, "--list-box__selection"), (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2i, "--tag--filter"), selectionCount), _defineProperty$2(_cx, "".concat(prefix$2i, "--list-box__selection--multi"), selectionCount), _cx));
    var description = selectionCount ? t('clear.all') : t('clear.selection');
    var tagClasses = classnames("".concat(prefix$2i, "--tag"), "".concat(prefix$2i, "--tag--filter"), "".concat(prefix$2i, "--tag--high-contrast"), _defineProperty$2({}, "".concat(prefix$2i, "--tag--disabled"), disabled));

    function onClick(event) {
      event.stopPropagation();

      if (disabled) {
        return;
      }

      clearSelection(event);

      if (onClearSelection) {
        onClearSelection(event);
      }
    }

    function onKeyDown(event) {
      event.stopPropagation();

      if (disabled) {
        return;
      } // When a user hits ENTER, we'll clear the selection


      if (match(event, Enter)) {
        clearSelection(event);

        if (onClearSelection) {
          onClearSelection(event);
        }
      }
    }

    if (selectionCount) {
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: tagClasses
      }, /*#__PURE__*/React__default['default'].createElement("span", {
        className: "".concat(prefix$2i, "--tag__label"),
        title: selectionCount
      }, selectionCount), /*#__PURE__*/React__default['default'].createElement("button", {
        "aria-label": description,
        className: "".concat(prefix$2i, "--tag__close-icon"),
        disabled: disabled,
        onClick: onClick,
        onKeyDown: onKeyDown,
        tabIndex: disabled ? -1 : 0,
        title: description,
        type: "button"
      }, /*#__PURE__*/React__default['default'].createElement(Close16, null)));
    }

    return /*#__PURE__*/React__default['default'].createElement("button", _extends$3({}, rest, {
      "aria-label": description,
      className: className,
      onClick: onClick,
      onKeyDown: onKeyDown,
      tabIndex: disabled ? -1 : 0,
      title: description,
      type: "button"
    }), /*#__PURE__*/React__default['default'].createElement(Close16, null));
  }

  var translationIds$3 = {
    'clear.all': 'clear.all',
    'clear.selection': 'clear.selection'
  };
  var defaultTranslations$4 = (_defaultTranslations$3 = {}, _defineProperty$2(_defaultTranslations$3, translationIds$3['clear.all'], 'Clear all selected items'), _defineProperty$2(_defaultTranslations$3, translationIds$3['clear.selection'], 'Clear selected item'), _defaultTranslations$3);
  ListBoxSelection.propTypes = {
    /**
     * Specify a function to be invoked when a user interacts with the clear
     * selection element.
     */
    clearSelection: PropTypes__default['default'].func.isRequired,

    /**
     * Specify whether or not the clear selection element should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify an optional `onClearSelection` handler that is called when the underlying
     * element is cleared
     */
    onClearSelection: PropTypes__default['default'].func,

    /**
     * Specify an optional `onClick` handler that is called when the underlying
     * clear selection element is clicked
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Specify an optional `onKeyDown` handler that is called when the underlying
     * clear selection element fires a keydown event
     */
    onKeyDown: PropTypes__default['default'].func,

    /**
     * Specify an optional `selectionCount` value that will be used to determine
     * whether the selection should display a badge or a single clear icon.
     */
    selectionCount: PropTypes__default['default'].number,

    /**
     * i18n hook used to provide the appropriate description for the given menu
     * icon. This function takes in an id defined in `translationIds` and should
     * return a string message for that given message id.
     */
    translateWithId: PropTypes__default['default'].func.isRequired
  };
  ListBoxSelection.defaultProps = {
    translateWithId: function translateWithId(id) {
      return defaultTranslations$4[id];
    }
  };

  var _defaultTranslations$2;
  var prefix$2h = settings_1.prefix;
  var translationIds$2 = {
    'close.menu': 'close.menu',
    'open.menu': 'open.menu'
  };
  var defaultTranslations$3 = (_defaultTranslations$2 = {}, _defineProperty$2(_defaultTranslations$2, translationIds$2['close.menu'], 'Close'), _defineProperty$2(_defaultTranslations$2, translationIds$2['open.menu'], 'Open'), _defaultTranslations$2);
  /**
   * `ListBoxTrigger` is used to orient the icon up or down depending on the
   * state of the menu for a given `ListBox`
   */

  var ListBoxTrigger = function ListBoxTrigger(_ref) {
    var _cx;

    var isOpen = _ref.isOpen,
        t = _ref.translateWithId,
        rest = _objectWithoutProperties$2(_ref, ["isOpen", "translateWithId"]);

    var className = classnames((_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2h, "--list-box__menu-icon"), true), _defineProperty$2(_cx, "".concat(prefix$2h, "--list-box__menu-icon--open"), isOpen), _cx));
    var description = isOpen ? t('close.menu') : t('open.menu');
    return /*#__PURE__*/React__default['default'].createElement("button", _extends$3({}, rest, {
      "aria-label": description,
      title: description,
      className: className,
      type: "button",
      tabIndex: "-1"
    }), /*#__PURE__*/React__default['default'].createElement(ChevronDown16, null));
  };

  ListBoxTrigger.propTypes = {
    /**
     * Specify whether the menu is currently open, which will influence the
     * direction of the menu icon
     */
    isOpen: PropTypes__default['default'].bool.isRequired,

    /**
     * i18n hook used to provide the appropriate description for the given menu
     * icon. This function takes in an id defined in `translationIds` and should
     * return a string message for that given message id.
     */
    translateWithId: PropTypes__default['default'].func.isRequired
  };
  ListBoxTrigger.defaultProps = {
    translateWithId: function translateWithId(id) {
      return defaultTranslations$3[id];
    }
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Create an adapter that converts an object of props with potentially deprecated
   * prop names to the replacement prop names in a newer version. Useful for guarding
   * against breaking changes when a prop has been renamed
   *
   * @param {Array} spec - an array of options which specify a text or regex
   * matcher alongside a replacement if there is a match
   * @returns {Function}
   */
  function createPropAdapter(spec) {
    // if props aren't passed in we should default the prop to empty object
    return function () {
      var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var output = {};
      Object.keys(input).forEach(function (key) {
        var match = spec.find(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 1),
              regex = _ref2[0];

          return key.match(regex);
        });

        if (match) {
          var _match = _slicedToArray(match, 2),
              regex = _match[0],
              replacer = _match[1];

          output[key.replace(regex, replacer)] = input[key];
          return;
        }

        output[key] = input[key];
      });
      return output;
    };
  }
  /**
   * TODO: REMOVE IN v11
   * props staring with "default..." were changed to "initial..." in Downshift v3
   *
   * @see https://github.com/downshift-js/downshift/releases/tag/v3.0.0
   */


  var mapDownshiftProps = createPropAdapter([[/^default/g, 'initial']]);

  /**
   * @param {...Ref<Element>} refs List of React refs to merge.
   * @returns {Ref<Element>} Merged React ref.
   */
  var mergeRefs = function mergeRefs() {
    for (var _len = arguments.length, refs = new Array(_len), _key = 0; _key < _len; _key++) {
      refs[_key] = arguments[_key];
    }

    return function (el) {
      refs.forEach(function (ref) {
        // https://github.com/facebook/react/issues/13029#issuecomment-410002316
        if (typeof ref === 'function') {
          ref(el);
        } else if (Object(ref) === ref) {
          ref.current = el;
        }
      });
    };
  };

  var prefix$2g = settings_1.prefix;

  var defaultItemToString$2 = function defaultItemToString(item) {
    if (typeof item === 'string') {
      return item;
    }

    return item && item.label;
  };

  var defaultShouldFilterItem = function defaultShouldFilterItem() {
    return true;
  };

  var getInputValue = function getInputValue(_ref) {
    var initialSelectedItem = _ref.initialSelectedItem,
        inputValue = _ref.inputValue,
        itemToString = _ref.itemToString,
        selectedItem = _ref.selectedItem;

    if (selectedItem) {
      return itemToString(selectedItem);
    } // TODO: consistent `initialSelectedItem` behavior with other listbox components in v11


    if (initialSelectedItem) {
      return itemToString(initialSelectedItem);
    }

    return inputValue || '';
  };

  var findHighlightedIndex = function findHighlightedIndex(_ref2, inputValue) {
    var items = _ref2.items,
        itemToString = _ref2.itemToString;

    if (!inputValue) {
      return -1;
    }

    var searchValue = inputValue.toLowerCase();

    for (var i = 0; i < items.length; i++) {
      var item = itemToString(items[i]).toLowerCase();

      if (item.indexOf(searchValue) !== -1) {
        return i;
      }
    }

    return -1;
  };

  var getInstanceId$c = setupGetInstanceId$1();

  var ComboBox = function ComboBox(props) {
    var _cx;

    var ariaLabel = props.ariaLabel,
        containerClassName = props.className,
        direction = props.direction,
        disabled = props.disabled,
        downshiftProps = props.downshiftProps,
        helperText = props.helperText,
        id = props.id,
        initialSelectedItem = props.initialSelectedItem,
        invalid = props.invalid,
        invalidText = props.invalidText,
        items = props.items,
        itemToElement = props.itemToElement,
        itemToString = props.itemToString,
        light = props.light,
        onChange = props.onChange,
        onInputChange = props.onInputChange,
        onToggleClick = props.onToggleClick,
        placeholder = props.placeholder,
        selectedItem = props.selectedItem,
        shouldFilterItem = props.shouldFilterItem,
        size = props.size,
        titleText = props.titleText,
        translateWithId = props.translateWithId;
        props.type;
        var warn = props.warn,
        warnText = props.warnText,
        rest = _objectWithoutProperties$2(props, ["ariaLabel", "className", "direction", "disabled", "downshiftProps", "helperText", "id", "initialSelectedItem", "invalid", "invalidText", "items", "itemToElement", "itemToString", "light", "onChange", "onInputChange", "onToggleClick", "placeholder", "selectedItem", "shouldFilterItem", "size", "titleText", "translateWithId", "type", "warn", "warnText"]);

    var textInput = React.useRef();
    var comboBoxInstanceId = getInstanceId$c();

    var _useState = React.useState(getInputValue({
      initialSelectedItem: initialSelectedItem,
      inputValue: '',
      itemToString: itemToString,
      selectedItem: selectedItem
    })),
        _useState2 = _slicedToArray(_useState, 2),
        inputValue = _useState2[0],
        setInputValue = _useState2[1];

    var _useState3 = React.useState(null),
        _useState4 = _slicedToArray(_useState3, 2),
        prevSelectedItem = _useState4[0],
        setPrevSelectedItem = _useState4[1];

    var _useState5 = React.useState(null),
        _useState6 = _slicedToArray(_useState5, 2),
        doneInitialSelectedItem = _useState6[0],
        setDoneInitialSelectedItem = _useState6[1];

    var savedOnInputChange = React.useRef(onInputChange);

    if (!doneInitialSelectedItem || prevSelectedItem !== selectedItem) {
      setDoneInitialSelectedItem(true);
      setPrevSelectedItem(selectedItem);
      setInputValue(getInputValue({
        initialSelectedItem: initialSelectedItem,
        inputValue: inputValue,
        itemToString: itemToString,
        selectedItem: selectedItem
      }));
    }

    var filterItems = function filterItems(items, itemToString, inputValue) {
      return items.filter(function (item) {
        return shouldFilterItem({
          item: item,
          itemToString: itemToString,
          inputValue: inputValue
        });
      });
    };

    var handleOnChange = function handleOnChange(selectedItem) {
      if (onChange) {
        onChange({
          selectedItem: selectedItem
        });
      }
    };

    var handleOnInputValueChange = function handleOnInputValueChange(inputValue) {
      setInputValue(inputValue || '');
    };

    React.useEffect(function () {
      savedOnInputChange.current = onInputChange;
    }, [onInputChange]);
    React.useEffect(function () {
      if (savedOnInputChange.current) {
        savedOnInputChange.current(inputValue);
      }
    }, [inputValue]);

    var handleSelectionClear = function handleSelectionClear() {
      if (textInput !== null && textInput !== void 0 && textInput.current) {
        textInput.current.focus();
      }
    };

    var handleOnStateChange = function handleOnStateChange(newState, _ref3) {
      var setHighlightedIndex = _ref3.setHighlightedIndex;

      if (Object.prototype.hasOwnProperty.call(newState, 'inputValue')) {
        var _inputValue = newState.inputValue;
        var filteredItems = filterItems(items, itemToString, _inputValue);
        setHighlightedIndex(findHighlightedIndex(_objectSpread2$2(_objectSpread2$2({}, props), {}, {
          items: filteredItems
        }), _inputValue));
      }
    };

    var handleToggleClick = function handleToggleClick(isOpen) {
      return function (event) {
        if (onToggleClick) {
          onToggleClick(event);
        }

        if (event.target === textInput.current && isOpen) {
          event.preventDownshiftDefault = true;
          event.persist();
        }
      };
    };

    var showWarning = !invalid && warn;
    var className = classnames("".concat(prefix$2g, "--combo-box"), containerClassName, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2g, "--list-box--up"), direction === 'top'), _defineProperty$2(_cx, "".concat(prefix$2g, "--combo-box--warning"), showWarning), _cx));
    var titleClasses = classnames("".concat(prefix$2g, "--label"), _defineProperty$2({}, "".concat(prefix$2g, "--label--disabled"), disabled));
    var comboBoxHelperId = !helperText ? undefined : "combobox-helper-text-".concat(comboBoxInstanceId);
    var helperClasses = classnames("".concat(prefix$2g, "--form__helper-text"), _defineProperty$2({}, "".concat(prefix$2g, "--form__helper-text--disabled"), disabled));
    var wrapperClasses = classnames("".concat(prefix$2g, "--list-box__wrapper"));
    var inputClasses = classnames("".concat(prefix$2g, "--text-input"), _defineProperty$2({}, "".concat(prefix$2g, "--text-input--empty"), !inputValue)); // needs to be Capitalized for react to render it correctly

    var ItemToElement = itemToElement;
    return /*#__PURE__*/React__default['default'].createElement(Downshift, _extends$3({}, mapDownshiftProps(downshiftProps), {
      onChange: handleOnChange,
      onInputValueChange: handleOnInputValueChange,
      onStateChange: handleOnStateChange,
      inputValue: inputValue || '',
      itemToString: itemToString,
      initialSelectedItem: initialSelectedItem,
      inputId: id,
      selectedItem: selectedItem
    }), function (_ref4) {
      var getInputProps = _ref4.getInputProps,
          getItemProps = _ref4.getItemProps,
          getLabelProps = _ref4.getLabelProps,
          getMenuProps = _ref4.getMenuProps,
          getRootProps = _ref4.getRootProps,
          getToggleButtonProps = _ref4.getToggleButtonProps,
          isOpen = _ref4.isOpen,
          inputValue = _ref4.inputValue,
          selectedItem = _ref4.selectedItem,
          highlightedIndex = _ref4.highlightedIndex,
          clearSelection = _ref4.clearSelection,
          toggleMenu = _ref4.toggleMenu;
      var rootProps = getRootProps({}, {
        suppressRefError: true
      });
      var labelProps = getLabelProps();
      var buttonProps = getToggleButtonProps({
        disabled: disabled,
        onClick: handleToggleClick(isOpen),
        // When we moved the "root node" of Downshift to the <input> for
        // ARIA 1.2 compliance, we unfortunately hit this branch for the
        // "mouseup" event that downshift listens to:
        // https://github.com/downshift-js/downshift/blob/v5.2.1/src/downshift.js#L1051-L1065
        //
        // As a result, it will reset the state of the component and so we
        // stop the event from propagating to prevent this. This allows the
        // toggleMenu behavior for the toggleButton to correctly open and
        // close the menu.
        onMouseUp: function onMouseUp(event) {
          event.stopPropagation();
        }
      });
      var inputProps = getInputProps({
        // Remove excess aria `aria-labelledby`. HTML <label for> provides this aria information.
        'aria-labelledby': null,
        disabled: disabled,
        placeholder: placeholder,
        onClick: function onClick() {
          toggleMenu();
        },
        onKeyDown: function onKeyDown(event) {
          if (match(event, Space)) {
            event.stopPropagation();
          }

          if (match(event, Enter) && !inputValue) {
            toggleMenu();
          }
        }
      });
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: wrapperClasses
      }, titleText && /*#__PURE__*/React__default['default'].createElement("label", _extends$3({
        className: titleClasses
      }, labelProps), titleText), /*#__PURE__*/React__default['default'].createElement(ListBox, {
        className: className,
        disabled: disabled,
        invalid: invalid,
        invalidText: invalidText,
        isOpen: isOpen,
        light: light,
        size: size,
        warn: warn,
        warnText: warnText
      }, /*#__PURE__*/React__default['default'].createElement("div", {
        className: "".concat(prefix$2g, "--list-box__field")
      }, /*#__PURE__*/React__default['default'].createElement("input", _extends$3({
        role: "combobox",
        disabled: disabled,
        className: inputClasses,
        type: "text",
        tabIndex: "0",
        "aria-autocomplete": "list",
        "aria-expanded": rootProps['aria-expanded'],
        "aria-haspopup": "listbox",
        "aria-controls": inputProps['aria-controls']
      }, inputProps, rest, {
        ref: mergeRefs(textInput, rootProps.ref)
      })), invalid && /*#__PURE__*/React__default['default'].createElement(WarningFilled16, {
        className: "".concat(prefix$2g, "--list-box__invalid-icon")
      }), showWarning && /*#__PURE__*/React__default['default'].createElement(WarningAltFilled16, {
        className: "".concat(prefix$2g, "--list-box__invalid-icon ").concat(prefix$2g, "--list-box__invalid-icon--warning")
      }), inputValue && /*#__PURE__*/React__default['default'].createElement(ListBoxSelection, {
        clearSelection: clearSelection,
        translateWithId: translateWithId,
        disabled: disabled,
        onClearSelection: handleSelectionClear
      }), /*#__PURE__*/React__default['default'].createElement(ListBoxTrigger, _extends$3({}, buttonProps, {
        isOpen: isOpen,
        translateWithId: translateWithId
      }))), /*#__PURE__*/React__default['default'].createElement(ListBox.Menu, getMenuProps({
        'aria-label': ariaLabel
      }), isOpen ? filterItems(items, itemToString, inputValue).map(function (item, index) {
        var _getItemProps;

        var itemProps = getItemProps((_getItemProps = {
          item: item,
          index: index
        }, _defineProperty$2(_getItemProps, 'aria-current', selectedItem === item ? true : null), _defineProperty$2(_getItemProps, 'aria-selected', highlightedIndex === index ? true : null), _getItemProps));
        return /*#__PURE__*/React__default['default'].createElement(ListBox.MenuItem, _extends$3({
          key: itemProps.id,
          isActive: selectedItem === item,
          tabIndex: "-1",
          isHighlighted: highlightedIndex === index || (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) && (selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.id) === item.id || false,
          title: itemToElement ? item.text : itemToString(item)
        }, itemProps), itemToElement ? /*#__PURE__*/React__default['default'].createElement(ItemToElement, _extends$3({
          key: itemProps.id
        }, item)) : itemToString(item), selectedItem === item && /*#__PURE__*/React__default['default'].createElement(Checkmark16, {
          className: "".concat(prefix$2g, "--list-box__menu-item__selected-icon")
        }));
      }) : null)), helperText && !invalid && !warn && /*#__PURE__*/React__default['default'].createElement("div", {
        id: comboBoxHelperId,
        className: helperClasses
      }, helperText));
    });
  };

  ComboBox.propTypes = {
    /**
     * 'aria-label' of the ListBox component.
     */
    ariaLabel: PropTypes__default['default'].string,

    /**
     * An optional className to add to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the direction of the combobox dropdown. Can be either top or bottom.
     */
    direction: PropTypes__default['default'].oneOf(['top', 'bottom']),

    /**
     * Specify if the control should be disabled, or not
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Additional props passed to Downshift
     */
    downshiftProps: PropTypes__default['default'].shape(Downshift.propTypes),

    /**
     * Provide helper text that is used alongside the control label for
     * additional help
     */
    helperText: PropTypes__default['default'].string,

    /**
     * Specify a custom `id` for the input
     */
    id: PropTypes__default['default'].string.isRequired,

    /**
     * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
     * from their collection that are pre-selected
     */
    initialSelectedItem: PropTypes__default['default'].oneOfType([PropTypes__default['default'].object, PropTypes__default['default'].string]),

    /**
     * Specify if the currently selected value is invalid.
     */
    invalid: PropTypes__default['default'].bool,

    /**
     * Message which is displayed if the value is invalid.
     */
    invalidText: PropTypes__default['default'].node,

    /**
     * Optional function to render items as custom components instead of strings.
     * Defaults to null and is overriden by a getter
     */
    itemToElement: PropTypes__default['default'].func,

    /**
     * Helper function passed to downshift that allows the library to render a
     * given item to a string label. By default, it extracts the `label` field
     * from a given item to serve as the item label in the list
     */
    itemToString: PropTypes__default['default'].func,

    /**
     * We try to stay as generic as possible here to allow individuals to pass
     * in a collection of whatever kind of data structure they prefer
     */
    items: PropTypes__default['default'].array.isRequired,

    /**
     * should use "light theme" (white background)?
     */
    light: PropTypes__default['default'].bool,

    /**
     * `onChange` is a utility for this controlled component to communicate to a
     * consuming component when a specific dropdown item is selected.
     * @param {{ selectedItem }}
     */
    onChange: PropTypes__default['default'].func.isRequired,

    /**
     * Callback function to notify consumer when the text input changes.
     * This provides support to change available items based on the text.
     * @param {string} inputText
     */
    onInputChange: PropTypes__default['default'].func,

    /**
     * Callback function that fires when the combobox menu toggle is clicked
     * @param {MouseEvent} event
     */
    onToggleClick: PropTypes__default['default'].func,

    /**
     * Used to provide a placeholder text node before a user enters any input.
     * This is only present if the control has no items selected
     */
    placeholder: PropTypes__default['default'].string.isRequired,

    /**
     * For full control of the selection
     */
    selectedItem: PropTypes__default['default'].oneOfType([PropTypes__default['default'].object, PropTypes__default['default'].string]),

    /**
     * Specify your own filtering logic by passing in a `shouldFilterItem`
     * function that takes in the current input and an item and passes back
     * whether or not the item should be filtered.
     */
    shouldFilterItem: PropTypes__default['default'].func,

    /**
     * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
     */
    size: ListBoxSize,

    /**
     * Provide text to be used in a `<label>` element that is tied to the
     * combobox via ARIA attributes.
     */
    titleText: PropTypes__default['default'].node,

    /**
     * Specify a custom translation function that takes in a message identifier
     * and returns the localized string for the message
     */
    translateWithId: PropTypes__default['default'].func,

    /**
     * Currently supports either the default type, or an inline variant
     */
    type: ListBoxType,

    /**
     * Specify whether the control is currently in warning state
     */
    warn: PropTypes__default['default'].bool,

    /**
     * Provide the text that is displayed when the control is in warning state
     */
    warnText: PropTypes__default['default'].node
  };
  ComboBox.defaultProps = {
    disabled: false,
    itemToString: defaultItemToString$2,
    itemToElement: null,
    shouldFilterItem: defaultShouldFilterItem,
    type: 'default',
    ariaLabel: 'Choose an item',
    light: false,
    direction: 'bottom'
  };

  /**
   * @param {Function} name The name of the prop that must exist to validate
   * the current prop.
   * @param {Function} propType The original prop type checker.
   * @returns {Function} The new prop type checker for the current prop that
   * becomes required if the prop corresponding to the provided prop name exists.
   */
  function requiredIfGivenPropIsTruthy(name, propType) {
    return function check(props, propName, componentName) {
      if (props[name] == true && props[propName] == null) {
        return new Error("You must provide a value for `".concat(propName, "` in `").concat(componentName, "` if `").concat(name, "` exists."));
      }

      for (var _len = arguments.length, rest = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
        rest[_key - 3] = arguments[_key];
      }

      return propType.apply(void 0, [props, propName, componentName].concat(rest));
    };
  }

  var lodash_findlast = createCommonjsModule(function (module, exports) {
    /** Used as the size to enable large array optimizations. */
    var LARGE_ARRAY_SIZE = 200;
    /** Used as the `TypeError` message for "Functions" methods. */

    var FUNC_ERROR_TEXT = 'Expected a function';
    /** Used to stand-in for `undefined` hash values. */

    var HASH_UNDEFINED = '__lodash_hash_undefined__';
    /** Used to compose bitmasks for comparison styles. */

    var UNORDERED_COMPARE_FLAG = 1,
        PARTIAL_COMPARE_FLAG = 2;
    /** Used as references for various `Number` constants. */

    var INFINITY = 1 / 0,
        MAX_SAFE_INTEGER = 9007199254740991,
        MAX_INTEGER = 1.7976931348623157e+308,
        NAN = 0 / 0;
    /** `Object#toString` result references. */

    var argsTag = '[object Arguments]',
        arrayTag = '[object Array]',
        boolTag = '[object Boolean]',
        dateTag = '[object Date]',
        errorTag = '[object Error]',
        funcTag = '[object Function]',
        genTag = '[object GeneratorFunction]',
        mapTag = '[object Map]',
        numberTag = '[object Number]',
        objectTag = '[object Object]',
        promiseTag = '[object Promise]',
        regexpTag = '[object RegExp]',
        setTag = '[object Set]',
        stringTag = '[object String]',
        symbolTag = '[object Symbol]',
        weakMapTag = '[object WeakMap]';
    var arrayBufferTag = '[object ArrayBuffer]',
        dataViewTag = '[object DataView]',
        float32Tag = '[object Float32Array]',
        float64Tag = '[object Float64Array]',
        int8Tag = '[object Int8Array]',
        int16Tag = '[object Int16Array]',
        int32Tag = '[object Int32Array]',
        uint8Tag = '[object Uint8Array]',
        uint8ClampedTag = '[object Uint8ClampedArray]',
        uint16Tag = '[object Uint16Array]',
        uint32Tag = '[object Uint32Array]';
    /** Used to match property names within property paths. */

    var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
        reIsPlainProp = /^\w*$/,
        reLeadingDot = /^\./,
        rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
    /**
     * Used to match `RegExp`
     * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
     */

    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    /** Used to match leading and trailing whitespace. */

    var reTrim = /^\s+|\s+$/g;
    /** Used to match backslashes in property paths. */

    var reEscapeChar = /\\(\\)?/g;
    /** Used to detect bad signed hexadecimal string values. */

    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    /** Used to detect binary string values. */

    var reIsBinary = /^0b[01]+$/i;
    /** Used to detect host constructors (Safari). */

    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    /** Used to detect octal string values. */

    var reIsOctal = /^0o[0-7]+$/i;
    /** Used to detect unsigned integer values. */

    var reIsUint = /^(?:0|[1-9]\d*)$/;
    /** Used to identify `toStringTag` values of typed arrays. */

    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    /** Built-in method references without a dependency on `root`. */

    var freeParseInt = parseInt;
    /** Detect free variable `global` from Node.js. */

    var freeGlobal = _typeof(commonjsGlobal) == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
    /** Detect free variable `self`. */

    var freeSelf = (typeof self === "undefined" ? "undefined" : _typeof(self)) == 'object' && self && self.Object === Object && self;
    /** Used as a reference to the global object. */

    var root = freeGlobal || freeSelf || Function('return this')();
    /** Detect free variable `exports`. */

    var freeExports = exports && !exports.nodeType && exports;
    /** Detect free variable `module`. */

    var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;
    /** Detect the popular CommonJS extension `module.exports`. */

    var moduleExports = freeModule && freeModule.exports === freeExports;
    /** Detect free variable `process` from Node.js. */

    var freeProcess = moduleExports && freeGlobal.process;
    /** Used to access faster Node.js helpers. */

    var nodeUtil = function () {
      try {
        return freeProcess && freeProcess.binding('util');
      } catch (e) {}
    }();
    /* Node.js helper references. */


    var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    /**
     * A specialized version of `_.some` for arrays without support for iteratee
     * shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */

    function arraySome(array, predicate) {
      var index = -1,
          length = array ? array.length : 0;

      while (++index < length) {
        if (predicate(array[index], index, array)) {
          return true;
        }
      }

      return false;
    }
    /**
     * The base implementation of `_.findIndex` and `_.findLastIndex` without
     * support for iteratee shorthands.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Function} predicate The function invoked per iteration.
     * @param {number} fromIndex The index to search from.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */


    function baseFindIndex(array, predicate, fromIndex, fromRight) {
      var length = array.length,
          index = fromIndex + (fromRight ? 1 : -1);

      while (fromRight ? index-- : ++index < length) {
        if (predicate(array[index], index, array)) {
          return index;
        }
      }

      return -1;
    }
    /**
     * The base implementation of `_.property` without support for deep paths.
     *
     * @private
     * @param {string} key The key of the property to get.
     * @returns {Function} Returns the new accessor function.
     */


    function baseProperty(key) {
      return function (object) {
        return object == null ? undefined : object[key];
      };
    }
    /**
     * The base implementation of `_.times` without support for iteratee shorthands
     * or max array length checks.
     *
     * @private
     * @param {number} n The number of times to invoke `iteratee`.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the array of results.
     */


    function baseTimes(n, iteratee) {
      var index = -1,
          result = Array(n);

      while (++index < n) {
        result[index] = iteratee(index);
      }

      return result;
    }
    /**
     * The base implementation of `_.unary` without support for storing metadata.
     *
     * @private
     * @param {Function} func The function to cap arguments for.
     * @returns {Function} Returns the new capped function.
     */


    function baseUnary(func) {
      return function (value) {
        return func(value);
      };
    }
    /**
     * Gets the value at `key` of `object`.
     *
     * @private
     * @param {Object} [object] The object to query.
     * @param {string} key The key of the property to get.
     * @returns {*} Returns the property value.
     */


    function getValue(object, key) {
      return object == null ? undefined : object[key];
    }
    /**
     * Checks if `value` is a host object in IE < 9.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
     */


    function isHostObject(value) {
      // Many host objects are `Object` objects that can coerce to strings
      // despite having improperly defined `toString` methods.
      var result = false;

      if (value != null && typeof value.toString != 'function') {
        try {
          result = !!(value + '');
        } catch (e) {}
      }

      return result;
    }
    /**
     * Converts `map` to its key-value pairs.
     *
     * @private
     * @param {Object} map The map to convert.
     * @returns {Array} Returns the key-value pairs.
     */


    function mapToArray(map) {
      var index = -1,
          result = Array(map.size);
      map.forEach(function (value, key) {
        result[++index] = [key, value];
      });
      return result;
    }
    /**
     * Creates a unary function that invokes `func` with its argument transformed.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {Function} transform The argument transform.
     * @returns {Function} Returns the new function.
     */


    function overArg(func, transform) {
      return function (arg) {
        return func(transform(arg));
      };
    }
    /**
     * Converts `set` to an array of its values.
     *
     * @private
     * @param {Object} set The set to convert.
     * @returns {Array} Returns the values.
     */


    function setToArray(set) {
      var index = -1,
          result = Array(set.size);
      set.forEach(function (value) {
        result[++index] = value;
      });
      return result;
    }
    /** Used for built-in method references. */


    var arrayProto = Array.prototype,
        funcProto = Function.prototype,
        objectProto = Object.prototype;
    /** Used to detect overreaching core-js shims. */

    var coreJsData = root['__core-js_shared__'];
    /** Used to detect methods masquerading as native. */

    var maskSrcKey = function () {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
      return uid ? 'Symbol(src)_1.' + uid : '';
    }();
    /** Used to resolve the decompiled source of functions. */


    var funcToString = funcProto.toString;
    /** Used to check objects for own properties. */

    var hasOwnProperty = objectProto.hasOwnProperty;
    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */

    var objectToString = objectProto.toString;
    /** Used to detect if a method is native. */

    var reIsNative = RegExp('^' + funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');
    /** Built-in value references. */

    var _Symbol = root.Symbol,
        Uint8Array = root.Uint8Array,
        propertyIsEnumerable = objectProto.propertyIsEnumerable,
        splice = arrayProto.splice;
    /* Built-in method references for those with the same name as other `lodash` methods. */

    var nativeKeys = overArg(Object.keys, Object),
        nativeMax = Math.max,
        nativeMin = Math.min;
    /* Built-in method references that are verified to be native. */

    var DataView = getNative(root, 'DataView'),
        Map = getNative(root, 'Map'),
        Promise = getNative(root, 'Promise'),
        Set = getNative(root, 'Set'),
        WeakMap = getNative(root, 'WeakMap'),
        nativeCreate = getNative(Object, 'create');
    /** Used to detect maps, sets, and weakmaps. */

    var dataViewCtorString = toSource(DataView),
        mapCtorString = toSource(Map),
        promiseCtorString = toSource(Promise),
        setCtorString = toSource(Set),
        weakMapCtorString = toSource(WeakMap);
    /** Used to convert symbols to primitives and strings. */

    var symbolProto = _Symbol ? _Symbol.prototype : undefined,
        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined,
        symbolToString = symbolProto ? symbolProto.toString : undefined;
    /**
     * Creates a hash object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function Hash(entries) {
      var index = -1,
          length = entries ? entries.length : 0;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the hash.
     *
     * @private
     * @name clear
     * @memberOf Hash
     */


    function hashClear() {
      this.__data__ = nativeCreate ? nativeCreate(null) : {};
    }
    /**
     * Removes `key` and its value from the hash.
     *
     * @private
     * @name delete
     * @memberOf Hash
     * @param {Object} hash The hash to modify.
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function hashDelete(key) {
      return this.has(key) && delete this.__data__[key];
    }
    /**
     * Gets the hash value for `key`.
     *
     * @private
     * @name get
     * @memberOf Hash
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function hashGet(key) {
      var data = this.__data__;

      if (nativeCreate) {
        var result = data[key];
        return result === HASH_UNDEFINED ? undefined : result;
      }

      return hasOwnProperty.call(data, key) ? data[key] : undefined;
    }
    /**
     * Checks if a hash value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Hash
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function hashHas(key) {
      var data = this.__data__;
      return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
    }
    /**
     * Sets the hash `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Hash
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the hash instance.
     */


    function hashSet(key, value) {
      var data = this.__data__;
      data[key] = nativeCreate && value === undefined ? HASH_UNDEFINED : value;
      return this;
    } // Add methods to `Hash`.


    Hash.prototype.clear = hashClear;
    Hash.prototype['delete'] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;
    /**
     * Creates an list cache object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function ListCache(entries) {
      var index = -1,
          length = entries ? entries.length : 0;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the list cache.
     *
     * @private
     * @name clear
     * @memberOf ListCache
     */


    function listCacheClear() {
      this.__data__ = [];
    }
    /**
     * Removes `key` and its value from the list cache.
     *
     * @private
     * @name delete
     * @memberOf ListCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function listCacheDelete(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        return false;
      }

      var lastIndex = data.length - 1;

      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }

      return true;
    }
    /**
     * Gets the list cache value for `key`.
     *
     * @private
     * @name get
     * @memberOf ListCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function listCacheGet(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);
      return index < 0 ? undefined : data[index][1];
    }
    /**
     * Checks if a list cache value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf ListCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function listCacheHas(key) {
      return assocIndexOf(this.__data__, key) > -1;
    }
    /**
     * Sets the list cache `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf ListCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the list cache instance.
     */


    function listCacheSet(key, value) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }

      return this;
    } // Add methods to `ListCache`.


    ListCache.prototype.clear = listCacheClear;
    ListCache.prototype['delete'] = listCacheDelete;
    ListCache.prototype.get = listCacheGet;
    ListCache.prototype.has = listCacheHas;
    ListCache.prototype.set = listCacheSet;
    /**
     * Creates a map cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function MapCache(entries) {
      var index = -1,
          length = entries ? entries.length : 0;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the map.
     *
     * @private
     * @name clear
     * @memberOf MapCache
     */


    function mapCacheClear() {
      this.__data__ = {
        'hash': new Hash(),
        'map': new (Map || ListCache)(),
        'string': new Hash()
      };
    }
    /**
     * Removes `key` and its value from the map.
     *
     * @private
     * @name delete
     * @memberOf MapCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function mapCacheDelete(key) {
      return getMapData(this, key)['delete'](key);
    }
    /**
     * Gets the map value for `key`.
     *
     * @private
     * @name get
     * @memberOf MapCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function mapCacheGet(key) {
      return getMapData(this, key).get(key);
    }
    /**
     * Checks if a map value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf MapCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function mapCacheHas(key) {
      return getMapData(this, key).has(key);
    }
    /**
     * Sets the map `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf MapCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the map cache instance.
     */


    function mapCacheSet(key, value) {
      getMapData(this, key).set(key, value);
      return this;
    } // Add methods to `MapCache`.


    MapCache.prototype.clear = mapCacheClear;
    MapCache.prototype['delete'] = mapCacheDelete;
    MapCache.prototype.get = mapCacheGet;
    MapCache.prototype.has = mapCacheHas;
    MapCache.prototype.set = mapCacheSet;
    /**
     *
     * Creates an array cache object to store unique values.
     *
     * @private
     * @constructor
     * @param {Array} [values] The values to cache.
     */

    function SetCache(values) {
      var index = -1,
          length = values ? values.length : 0;
      this.__data__ = new MapCache();

      while (++index < length) {
        this.add(values[index]);
      }
    }
    /**
     * Adds `value` to the array cache.
     *
     * @private
     * @name add
     * @memberOf SetCache
     * @alias push
     * @param {*} value The value to cache.
     * @returns {Object} Returns the cache instance.
     */


    function setCacheAdd(value) {
      this.__data__.set(value, HASH_UNDEFINED);

      return this;
    }
    /**
     * Checks if `value` is in the array cache.
     *
     * @private
     * @name has
     * @memberOf SetCache
     * @param {*} value The value to search for.
     * @returns {number} Returns `true` if `value` is found, else `false`.
     */


    function setCacheHas(value) {
      return this.__data__.has(value);
    } // Add methods to `SetCache`.


    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
    SetCache.prototype.has = setCacheHas;
    /**
     * Creates a stack cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function Stack(entries) {
      this.__data__ = new ListCache(entries);
    }
    /**
     * Removes all key-value entries from the stack.
     *
     * @private
     * @name clear
     * @memberOf Stack
     */


    function stackClear() {
      this.__data__ = new ListCache();
    }
    /**
     * Removes `key` and its value from the stack.
     *
     * @private
     * @name delete
     * @memberOf Stack
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function stackDelete(key) {
      return this.__data__['delete'](key);
    }
    /**
     * Gets the stack value for `key`.
     *
     * @private
     * @name get
     * @memberOf Stack
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function stackGet(key) {
      return this.__data__.get(key);
    }
    /**
     * Checks if a stack value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Stack
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function stackHas(key) {
      return this.__data__.has(key);
    }
    /**
     * Sets the stack `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Stack
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the stack cache instance.
     */


    function stackSet(key, value) {
      var cache = this.__data__;

      if (cache instanceof ListCache) {
        var pairs = cache.__data__;

        if (!Map || pairs.length < LARGE_ARRAY_SIZE - 1) {
          pairs.push([key, value]);
          return this;
        }

        cache = this.__data__ = new MapCache(pairs);
      }

      cache.set(key, value);
      return this;
    } // Add methods to `Stack`.


    Stack.prototype.clear = stackClear;
    Stack.prototype['delete'] = stackDelete;
    Stack.prototype.get = stackGet;
    Stack.prototype.has = stackHas;
    Stack.prototype.set = stackSet;
    /**
     * Creates an array of the enumerable property names of the array-like `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @param {boolean} inherited Specify returning inherited property names.
     * @returns {Array} Returns the array of property names.
     */

    function arrayLikeKeys(value, inherited) {
      // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
      // Safari 9 makes `arguments.length` enumerable in strict mode.
      var result = isArray(value) || isArguments(value) ? baseTimes(value.length, String) : [];
      var length = result.length,
          skipIndexes = !!length;

      for (var key in value) {
        if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && (key == 'length' || isIndex(key, length)))) {
          result.push(key);
        }
      }

      return result;
    }
    /**
     * Gets the index at which the `key` is found in `array` of key-value pairs.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {*} key The key to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */


    function assocIndexOf(array, key) {
      var length = array.length;

      while (length--) {
        if (eq(array[length][0], key)) {
          return length;
        }
      }

      return -1;
    }
    /**
     * The base implementation of `_.get` without support for default values.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @returns {*} Returns the resolved value.
     */


    function baseGet(object, path) {
      path = isKey(path, object) ? [path] : castPath(path);
      var index = 0,
          length = path.length;

      while (object != null && index < length) {
        object = object[toKey(path[index++])];
      }

      return index && index == length ? object : undefined;
    }
    /**
     * The base implementation of `getTag`.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */


    function baseGetTag(value) {
      return objectToString.call(value);
    }
    /**
     * The base implementation of `_.hasIn` without support for deep paths.
     *
     * @private
     * @param {Object} [object] The object to query.
     * @param {Array|string} key The key to check.
     * @returns {boolean} Returns `true` if `key` exists, else `false`.
     */


    function baseHasIn(object, key) {
      return object != null && key in Object(object);
    }
    /**
     * The base implementation of `_.isEqual` which supports partial comparisons
     * and tracks traversed objects.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {Function} [customizer] The function to customize comparisons.
     * @param {boolean} [bitmask] The bitmask of comparison flags.
     *  The bitmask may be composed of the following flags:
     *     1 - Unordered comparison
     *     2 - Partial comparison
     * @param {Object} [stack] Tracks traversed `value` and `other` objects.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     */


    function baseIsEqual(value, other, customizer, bitmask, stack) {
      if (value === other) {
        return true;
      }

      if (value == null || other == null || !isObject(value) && !isObjectLike(other)) {
        return value !== value && other !== other;
      }

      return baseIsEqualDeep(value, other, baseIsEqual, customizer, bitmask, stack);
    }
    /**
     * A specialized version of `baseIsEqual` for arrays and objects which performs
     * deep comparisons and tracks traversed objects enabling objects with circular
     * references to be compared.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} [customizer] The function to customize comparisons.
     * @param {number} [bitmask] The bitmask of comparison flags. See `baseIsEqual`
     *  for more details.
     * @param {Object} [stack] Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function baseIsEqualDeep(object, other, equalFunc, customizer, bitmask, stack) {
      var objIsArr = isArray(object),
          othIsArr = isArray(other),
          objTag = arrayTag,
          othTag = arrayTag;

      if (!objIsArr) {
        objTag = getTag(object);
        objTag = objTag == argsTag ? objectTag : objTag;
      }

      if (!othIsArr) {
        othTag = getTag(other);
        othTag = othTag == argsTag ? objectTag : othTag;
      }

      var objIsObj = objTag == objectTag && !isHostObject(object),
          othIsObj = othTag == objectTag && !isHostObject(other),
          isSameTag = objTag == othTag;

      if (isSameTag && !objIsObj) {
        stack || (stack = new Stack());
        return objIsArr || isTypedArray(object) ? equalArrays(object, other, equalFunc, customizer, bitmask, stack) : equalByTag(object, other, objTag, equalFunc, customizer, bitmask, stack);
      }

      if (!(bitmask & PARTIAL_COMPARE_FLAG)) {
        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

        if (objIsWrapped || othIsWrapped) {
          var objUnwrapped = objIsWrapped ? object.value() : object,
              othUnwrapped = othIsWrapped ? other.value() : other;
          stack || (stack = new Stack());
          return equalFunc(objUnwrapped, othUnwrapped, customizer, bitmask, stack);
        }
      }

      if (!isSameTag) {
        return false;
      }

      stack || (stack = new Stack());
      return equalObjects(object, other, equalFunc, customizer, bitmask, stack);
    }
    /**
     * The base implementation of `_.isMatch` without support for iteratee shorthands.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Object} source The object of property values to match.
     * @param {Array} matchData The property names, values, and compare flags to match.
     * @param {Function} [customizer] The function to customize comparisons.
     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
     */


    function baseIsMatch(object, source, matchData, customizer) {
      var index = matchData.length,
          length = index,
          noCustomizer = !customizer;

      if (object == null) {
        return !length;
      }

      object = Object(object);

      while (index--) {
        var data = matchData[index];

        if (noCustomizer && data[2] ? data[1] !== object[data[0]] : !(data[0] in object)) {
          return false;
        }
      }

      while (++index < length) {
        data = matchData[index];
        var key = data[0],
            objValue = object[key],
            srcValue = data[1];

        if (noCustomizer && data[2]) {
          if (objValue === undefined && !(key in object)) {
            return false;
          }
        } else {
          var stack = new Stack();

          if (customizer) {
            var result = customizer(objValue, srcValue, key, object, source, stack);
          }

          if (!(result === undefined ? baseIsEqual(srcValue, objValue, customizer, UNORDERED_COMPARE_FLAG | PARTIAL_COMPARE_FLAG, stack) : result)) {
            return false;
          }
        }
      }

      return true;
    }
    /**
     * The base implementation of `_.isNative` without bad shim checks.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function,
     *  else `false`.
     */


    function baseIsNative(value) {
      if (!isObject(value) || isMasked(value)) {
        return false;
      }

      var pattern = isFunction(value) || isHostObject(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value));
    }
    /**
     * The base implementation of `_.isTypedArray` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     */


    function baseIsTypedArray(value) {
      return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[objectToString.call(value)];
    }
    /**
     * The base implementation of `_.iteratee`.
     *
     * @private
     * @param {*} [value=_.identity] The value to convert to an iteratee.
     * @returns {Function} Returns the iteratee.
     */


    function baseIteratee(value) {
      // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
      // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
      if (typeof value == 'function') {
        return value;
      }

      if (value == null) {
        return identity;
      }

      if (_typeof(value) == 'object') {
        return isArray(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
      }

      return property(value);
    }
    /**
     * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */


    function baseKeys(object) {
      if (!isPrototype(object)) {
        return nativeKeys(object);
      }

      var result = [];

      for (var key in Object(object)) {
        if (hasOwnProperty.call(object, key) && key != 'constructor') {
          result.push(key);
        }
      }

      return result;
    }
    /**
     * The base implementation of `_.matches` which doesn't clone `source`.
     *
     * @private
     * @param {Object} source The object of property values to match.
     * @returns {Function} Returns the new spec function.
     */


    function baseMatches(source) {
      var matchData = getMatchData(source);

      if (matchData.length == 1 && matchData[0][2]) {
        return matchesStrictComparable(matchData[0][0], matchData[0][1]);
      }

      return function (object) {
        return object === source || baseIsMatch(object, source, matchData);
      };
    }
    /**
     * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
     *
     * @private
     * @param {string} path The path of the property to get.
     * @param {*} srcValue The value to match.
     * @returns {Function} Returns the new spec function.
     */


    function baseMatchesProperty(path, srcValue) {
      if (isKey(path) && isStrictComparable(srcValue)) {
        return matchesStrictComparable(toKey(path), srcValue);
      }

      return function (object) {
        var objValue = get(object, path);
        return objValue === undefined && objValue === srcValue ? hasIn(object, path) : baseIsEqual(srcValue, objValue, undefined, UNORDERED_COMPARE_FLAG | PARTIAL_COMPARE_FLAG);
      };
    }
    /**
     * A specialized version of `baseProperty` which supports deep paths.
     *
     * @private
     * @param {Array|string} path The path of the property to get.
     * @returns {Function} Returns the new accessor function.
     */


    function basePropertyDeep(path) {
      return function (object) {
        return baseGet(object, path);
      };
    }
    /**
     * The base implementation of `_.toString` which doesn't convert nullish
     * values to empty strings.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {string} Returns the string.
     */


    function baseToString(value) {
      // Exit early for strings to avoid a performance hit in some environments.
      if (typeof value == 'string') {
        return value;
      }

      if (isSymbol(value)) {
        return symbolToString ? symbolToString.call(value) : '';
      }

      var result = value + '';
      return result == '0' && 1 / value == -INFINITY ? '-0' : result;
    }
    /**
     * Casts `value` to a path array if it's not one.
     *
     * @private
     * @param {*} value The value to inspect.
     * @returns {Array} Returns the cast property path array.
     */


    function castPath(value) {
      return isArray(value) ? value : stringToPath(value);
    }
    /**
     * Creates a `_.find` or `_.findLast` function.
     *
     * @private
     * @param {Function} findIndexFunc The function to find the collection index.
     * @returns {Function} Returns the new find function.
     */


    function createFind(findIndexFunc) {
      return function (collection, predicate, fromIndex) {
        var iterable = Object(collection);

        if (!isArrayLike(collection)) {
          var iteratee = baseIteratee(predicate);
          collection = keys(collection);

          predicate = function predicate(key) {
            return iteratee(iterable[key], key, iterable);
          };
        }

        var index = findIndexFunc(collection, predicate, fromIndex);
        return index > -1 ? iterable[iteratee ? collection[index] : index] : undefined;
      };
    }
    /**
     * A specialized version of `baseIsEqualDeep` for arrays with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Array} array The array to compare.
     * @param {Array} other The other array to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} customizer The function to customize comparisons.
     * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
     *  for more details.
     * @param {Object} stack Tracks traversed `array` and `other` objects.
     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
     */


    function equalArrays(array, other, equalFunc, customizer, bitmask, stack) {
      var isPartial = bitmask & PARTIAL_COMPARE_FLAG,
          arrLength = array.length,
          othLength = other.length;

      if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
        return false;
      } // Assume cyclic values are equal.


      var stacked = stack.get(array);

      if (stacked && stack.get(other)) {
        return stacked == other;
      }

      var index = -1,
          result = true,
          seen = bitmask & UNORDERED_COMPARE_FLAG ? new SetCache() : undefined;
      stack.set(array, other);
      stack.set(other, array); // Ignore non-index properties.

      while (++index < arrLength) {
        var arrValue = array[index],
            othValue = other[index];

        if (customizer) {
          var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
        }

        if (compared !== undefined) {
          if (compared) {
            continue;
          }

          result = false;
          break;
        } // Recursively compare arrays (susceptible to call stack limits).


        if (seen) {
          if (!arraySome(other, function (othValue, othIndex) {
            if (!seen.has(othIndex) && (arrValue === othValue || equalFunc(arrValue, othValue, customizer, bitmask, stack))) {
              return seen.add(othIndex);
            }
          })) {
            result = false;
            break;
          }
        } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, customizer, bitmask, stack))) {
          result = false;
          break;
        }
      }

      stack['delete'](array);
      stack['delete'](other);
      return result;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for comparing objects of
     * the same `toStringTag`.
     *
     * **Note:** This function only supports comparing values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {string} tag The `toStringTag` of the objects to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} customizer The function to customize comparisons.
     * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
     *  for more details.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function equalByTag(object, other, tag, equalFunc, customizer, bitmask, stack) {
      switch (tag) {
        case dataViewTag:
          if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
            return false;
          }

          object = object.buffer;
          other = other.buffer;

        case arrayBufferTag:
          if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
            return false;
          }

          return true;

        case boolTag:
        case dateTag:
        case numberTag:
          // Coerce booleans to `1` or `0` and dates to milliseconds.
          // Invalid dates are coerced to `NaN`.
          return eq(+object, +other);

        case errorTag:
          return object.name == other.name && object.message == other.message;

        case regexpTag:
        case stringTag:
          // Coerce regexes to strings and treat strings, primitives and objects,
          // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
          // for more details.
          return object == other + '';

        case mapTag:
          var convert = mapToArray;

        case setTag:
          var isPartial = bitmask & PARTIAL_COMPARE_FLAG;
          convert || (convert = setToArray);

          if (object.size != other.size && !isPartial) {
            return false;
          } // Assume cyclic values are equal.


          var stacked = stack.get(object);

          if (stacked) {
            return stacked == other;
          }

          bitmask |= UNORDERED_COMPARE_FLAG; // Recursively compare objects (susceptible to call stack limits).

          stack.set(object, other);
          var result = equalArrays(convert(object), convert(other), equalFunc, customizer, bitmask, stack);
          stack['delete'](object);
          return result;

        case symbolTag:
          if (symbolValueOf) {
            return symbolValueOf.call(object) == symbolValueOf.call(other);
          }

      }

      return false;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for objects with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Function} customizer The function to customize comparisons.
     * @param {number} bitmask The bitmask of comparison flags. See `baseIsEqual`
     *  for more details.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function equalObjects(object, other, equalFunc, customizer, bitmask, stack) {
      var isPartial = bitmask & PARTIAL_COMPARE_FLAG,
          objProps = keys(object),
          objLength = objProps.length,
          othProps = keys(other),
          othLength = othProps.length;

      if (objLength != othLength && !isPartial) {
        return false;
      }

      var index = objLength;

      while (index--) {
        var key = objProps[index];

        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
          return false;
        }
      } // Assume cyclic values are equal.


      var stacked = stack.get(object);

      if (stacked && stack.get(other)) {
        return stacked == other;
      }

      var result = true;
      stack.set(object, other);
      stack.set(other, object);
      var skipCtor = isPartial;

      while (++index < objLength) {
        key = objProps[index];
        var objValue = object[key],
            othValue = other[key];

        if (customizer) {
          var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
        } // Recursively compare objects (susceptible to call stack limits).


        if (!(compared === undefined ? objValue === othValue || equalFunc(objValue, othValue, customizer, bitmask, stack) : compared)) {
          result = false;
          break;
        }

        skipCtor || (skipCtor = key == 'constructor');
      }

      if (result && !skipCtor) {
        var objCtor = object.constructor,
            othCtor = other.constructor; // Non `Object` object instances with different constructors are not equal.

        if (objCtor != othCtor && 'constructor' in object && 'constructor' in other && !(typeof objCtor == 'function' && objCtor instanceof objCtor && typeof othCtor == 'function' && othCtor instanceof othCtor)) {
          result = false;
        }
      }

      stack['delete'](object);
      stack['delete'](other);
      return result;
    }
    /**
     * Gets the data for `map`.
     *
     * @private
     * @param {Object} map The map to query.
     * @param {string} key The reference key.
     * @returns {*} Returns the map data.
     */


    function getMapData(map, key) {
      var data = map.__data__;
      return isKeyable(key) ? data[typeof key == 'string' ? 'string' : 'hash'] : data.map;
    }
    /**
     * Gets the property names, values, and compare flags of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the match data of `object`.
     */


    function getMatchData(object) {
      var result = keys(object),
          length = result.length;

      while (length--) {
        var key = result[length],
            value = object[key];
        result[length] = [key, value, isStrictComparable(value)];
      }

      return result;
    }
    /**
     * Gets the native function at `key` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the method to get.
     * @returns {*} Returns the function if it's native, else `undefined`.
     */


    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : undefined;
    }
    /**
     * Gets the `toStringTag` of `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */


    var getTag = baseGetTag; // Fallback for data views, maps, sets, and weak maps in IE 11,
    // for data views in Edge < 14, and promises in Node.js.

    if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map && getTag(new Map()) != mapTag || Promise && getTag(Promise.resolve()) != promiseTag || Set && getTag(new Set()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
      getTag = function getTag(value) {
        var result = objectToString.call(value),
            Ctor = result == objectTag ? value.constructor : undefined,
            ctorString = Ctor ? toSource(Ctor) : undefined;

        if (ctorString) {
          switch (ctorString) {
            case dataViewCtorString:
              return dataViewTag;

            case mapCtorString:
              return mapTag;

            case promiseCtorString:
              return promiseTag;

            case setCtorString:
              return setTag;

            case weakMapCtorString:
              return weakMapTag;
          }
        }

        return result;
      };
    }
    /**
     * Checks if `path` exists on `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path to check.
     * @param {Function} hasFunc The function to check properties.
     * @returns {boolean} Returns `true` if `path` exists, else `false`.
     */


    function hasPath(object, path, hasFunc) {
      path = isKey(path, object) ? [path] : castPath(path);
      var result,
          index = -1,
          length = path.length;

      while (++index < length) {
        var key = toKey(path[index]);

        if (!(result = object != null && hasFunc(object, key))) {
          break;
        }

        object = object[key];
      }

      if (result) {
        return result;
      }

      var length = object ? object.length : 0;
      return !!length && isLength(length) && isIndex(key, length) && (isArray(object) || isArguments(object));
    }
    /**
     * Checks if `value` is a valid array-like index.
     *
     * @private
     * @param {*} value The value to check.
     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
     */


    function isIndex(value, length) {
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (typeof value == 'number' || reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
    }
    /**
     * Checks if `value` is a property name and not a property path.
     *
     * @private
     * @param {*} value The value to check.
     * @param {Object} [object] The object to query keys on.
     * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
     */


    function isKey(value, object) {
      if (isArray(value)) {
        return false;
      }

      var type = _typeof(value);

      if (type == 'number' || type == 'symbol' || type == 'boolean' || value == null || isSymbol(value)) {
        return true;
      }

      return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
    }
    /**
     * Checks if `value` is suitable for use as unique object key.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
     */


    function isKeyable(value) {
      var type = _typeof(value);

      return type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean' ? value !== '__proto__' : value === null;
    }
    /**
     * Checks if `func` has its source masked.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
     */


    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    /**
     * Checks if `value` is likely a prototype object.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
     */


    function isPrototype(value) {
      var Ctor = value && value.constructor,
          proto = typeof Ctor == 'function' && Ctor.prototype || objectProto;
      return value === proto;
    }
    /**
     * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` if suitable for strict
     *  equality comparisons, else `false`.
     */


    function isStrictComparable(value) {
      return value === value && !isObject(value);
    }
    /**
     * A specialized version of `matchesProperty` for source values suitable
     * for strict equality comparisons, i.e. `===`.
     *
     * @private
     * @param {string} key The key of the property to get.
     * @param {*} srcValue The value to match.
     * @returns {Function} Returns the new spec function.
     */


    function matchesStrictComparable(key, srcValue) {
      return function (object) {
        if (object == null) {
          return false;
        }

        return object[key] === srcValue && (srcValue !== undefined || key in Object(object));
      };
    }
    /**
     * Converts `string` to a property path array.
     *
     * @private
     * @param {string} string The string to convert.
     * @returns {Array} Returns the property path array.
     */


    var stringToPath = memoize(function (string) {
      string = toString(string);
      var result = [];

      if (reLeadingDot.test(string)) {
        result.push('');
      }

      string.replace(rePropName, function (match, number, quote, string) {
        result.push(quote ? string.replace(reEscapeChar, '$1') : number || match);
      });
      return result;
    });
    /**
     * Converts `value` to a string key if it's not a string or symbol.
     *
     * @private
     * @param {*} value The value to inspect.
     * @returns {string|symbol} Returns the key.
     */

    function toKey(value) {
      if (typeof value == 'string' || isSymbol(value)) {
        return value;
      }

      var result = value + '';
      return result == '0' && 1 / value == -INFINITY ? '-0' : result;
    }
    /**
     * Converts `func` to its source code.
     *
     * @private
     * @param {Function} func The function to process.
     * @returns {string} Returns the source code.
     */


    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e) {}

        try {
          return func + '';
        } catch (e) {}
      }

      return '';
    }
    /**
     * This method is like `_.findIndex` except that it iterates over elements
     * of `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {Function} [predicate=_.identity]
     *  The function invoked per iteration.
     * @param {number} [fromIndex=array.length-1] The index to search from.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * _.findLastIndex(users, function(o) { return o.user == 'pebbles'; });
     * // => 2
     *
     * // The `_.matches` iteratee shorthand.
     * _.findLastIndex(users, { 'user': 'barney', 'active': true });
     * // => 0
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.findLastIndex(users, ['active', false]);
     * // => 2
     *
     * // The `_.property` iteratee shorthand.
     * _.findLastIndex(users, 'active');
     * // => 0
     */


    function findLastIndex(array, predicate, fromIndex) {
      var length = array ? array.length : 0;

      if (!length) {
        return -1;
      }

      var index = length - 1;

      if (fromIndex !== undefined) {
        index = toInteger(fromIndex);
        index = fromIndex < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
      }

      return baseFindIndex(array, baseIteratee(predicate), index, true);
    }
    /**
     * This method is like `_.find` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to inspect.
     * @param {Function} [predicate=_.identity]
     *  The function invoked per iteration.
     * @param {number} [fromIndex=collection.length-1] The index to search from.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * _.findLast([1, 2, 3, 4], function(n) {
     *   return n % 2 == 1;
     * });
     * // => 3
     */


    var findLast = createFind(findLastIndex);
    /**
     * Creates a function that memoizes the result of `func`. If `resolver` is
     * provided, it determines the cache key for storing the result based on the
     * arguments provided to the memoized function. By default, the first argument
     * provided to the memoized function is used as the map cache key. The `func`
     * is invoked with the `this` binding of the memoized function.
     *
     * **Note:** The cache is exposed as the `cache` property on the memoized
     * function. Its creation may be customized by replacing the `_.memoize.Cache`
     * constructor with one whose instances implement the
     * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
     * method interface of `delete`, `get`, `has`, and `set`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to have its output memoized.
     * @param {Function} [resolver] The function to resolve the cache key.
     * @returns {Function} Returns the new memoized function.
     * @example
     *
     * var object = { 'a': 1, 'b': 2 };
     * var other = { 'c': 3, 'd': 4 };
     *
     * var values = _.memoize(_.values);
     * values(object);
     * // => [1, 2]
     *
     * values(other);
     * // => [3, 4]
     *
     * object.a = 2;
     * values(object);
     * // => [1, 2]
     *
     * // Modify the result cache.
     * values.cache.set(object, ['a', 'b']);
     * values(object);
     * // => ['a', 'b']
     *
     * // Replace `_.memoize.Cache`.
     * _.memoize.Cache = WeakMap;
     */

    function memoize(func, resolver) {
      if (typeof func != 'function' || resolver && typeof resolver != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }

      var memoized = function memoized() {
        var args = arguments,
            key = resolver ? resolver.apply(this, args) : args[0],
            cache = memoized.cache;

        if (cache.has(key)) {
          return cache.get(key);
        }

        var result = func.apply(this, args);
        memoized.cache = cache.set(key, result);
        return result;
      };

      memoized.cache = new (memoize.Cache || MapCache)();
      return memoized;
    } // Assign cache to `_.memoize`.


    memoize.Cache = MapCache;
    /**
     * Performs a
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * comparison between two values to determine if they are equivalent.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.eq(object, object);
     * // => true
     *
     * _.eq(object, other);
     * // => false
     *
     * _.eq('a', 'a');
     * // => true
     *
     * _.eq('a', Object('a'));
     * // => false
     *
     * _.eq(NaN, NaN);
     * // => true
     */

    function eq(value, other) {
      return value === other || value !== value && other !== other;
    }
    /**
     * Checks if `value` is likely an `arguments` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     *  else `false`.
     * @example
     *
     * _.isArguments(function() { return arguments; }());
     * // => true
     *
     * _.isArguments([1, 2, 3]);
     * // => false
     */


    function isArguments(value) {
      // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
      return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') && (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
    }
    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(document.body.children);
     * // => false
     *
     * _.isArray('abc');
     * // => false
     *
     * _.isArray(_.noop);
     * // => false
     */


    var isArray = Array.isArray;
    /**
     * Checks if `value` is array-like. A value is considered array-like if it's
     * not a function and has a `value.length` that's an integer greater than or
     * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
     * @example
     *
     * _.isArrayLike([1, 2, 3]);
     * // => true
     *
     * _.isArrayLike(document.body.children);
     * // => true
     *
     * _.isArrayLike('abc');
     * // => true
     *
     * _.isArrayLike(_.noop);
     * // => false
     */

    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    /**
     * This method is like `_.isArrayLike` except that it also checks if `value`
     * is an object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array-like object,
     *  else `false`.
     * @example
     *
     * _.isArrayLikeObject([1, 2, 3]);
     * // => true
     *
     * _.isArrayLikeObject(document.body.children);
     * // => true
     *
     * _.isArrayLikeObject('abc');
     * // => false
     *
     * _.isArrayLikeObject(_.noop);
     * // => false
     */


    function isArrayLikeObject(value) {
      return isObjectLike(value) && isArrayLike(value);
    }
    /**
     * Checks if `value` is classified as a `Function` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a function, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     *
     * _.isFunction(/abc/);
     * // => false
     */


    function isFunction(value) {
      // The use of `Object#toString` avoids issues with the `typeof` operator
      // in Safari 8-9 which returns 'object' for typed array and other constructors.
      var tag = isObject(value) ? objectToString.call(value) : '';
      return tag == funcTag || tag == genTag;
    }
    /**
     * Checks if `value` is a valid array-like length.
     *
     * **Note:** This method is loosely based on
     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
     * @example
     *
     * _.isLength(3);
     * // => true
     *
     * _.isLength(Number.MIN_VALUE);
     * // => false
     *
     * _.isLength(Infinity);
     * // => false
     *
     * _.isLength('3');
     * // => false
     */


    function isLength(value) {
      return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    /**
     * Checks if `value` is the
     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(_.noop);
     * // => true
     *
     * _.isObject(null);
     * // => false
     */


    function isObject(value) {
      var type = _typeof(value);

      return !!value && (type == 'object' || type == 'function');
    }
    /**
     * Checks if `value` is object-like. A value is object-like if it's not `null`
     * and has a `typeof` result of "object".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
     * @example
     *
     * _.isObjectLike({});
     * // => true
     *
     * _.isObjectLike([1, 2, 3]);
     * // => true
     *
     * _.isObjectLike(_.noop);
     * // => false
     *
     * _.isObjectLike(null);
     * // => false
     */


    function isObjectLike(value) {
      return !!value && _typeof(value) == 'object';
    }
    /**
     * Checks if `value` is classified as a `Symbol` primitive or object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
     * @example
     *
     * _.isSymbol(Symbol.iterator);
     * // => true
     *
     * _.isSymbol('abc');
     * // => false
     */


    function isSymbol(value) {
      return _typeof(value) == 'symbol' || isObjectLike(value) && objectToString.call(value) == symbolTag;
    }
    /**
     * Checks if `value` is classified as a typed array.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     * @example
     *
     * _.isTypedArray(new Uint8Array);
     * // => true
     *
     * _.isTypedArray([]);
     * // => false
     */


    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    /**
     * Converts `value` to a finite number.
     *
     * @static
     * @memberOf _
     * @since 4.12.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted number.
     * @example
     *
     * _.toFinite(3.2);
     * // => 3.2
     *
     * _.toFinite(Number.MIN_VALUE);
     * // => 5e-324
     *
     * _.toFinite(Infinity);
     * // => 1.7976931348623157e+308
     *
     * _.toFinite('3.2');
     * // => 3.2
     */

    function toFinite(value) {
      if (!value) {
        return value === 0 ? value : 0;
      }

      value = toNumber(value);

      if (value === INFINITY || value === -INFINITY) {
        var sign = value < 0 ? -1 : 1;
        return sign * MAX_INTEGER;
      }

      return value === value ? value : 0;
    }
    /**
     * Converts `value` to an integer.
     *
     * **Note:** This method is loosely based on
     * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted integer.
     * @example
     *
     * _.toInteger(3.2);
     * // => 3
     *
     * _.toInteger(Number.MIN_VALUE);
     * // => 0
     *
     * _.toInteger(Infinity);
     * // => 1.7976931348623157e+308
     *
     * _.toInteger('3.2');
     * // => 3
     */


    function toInteger(value) {
      var result = toFinite(value),
          remainder = result % 1;
      return result === result ? remainder ? result - remainder : result : 0;
    }
    /**
     * Converts `value` to a number.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to process.
     * @returns {number} Returns the number.
     * @example
     *
     * _.toNumber(3.2);
     * // => 3.2
     *
     * _.toNumber(Number.MIN_VALUE);
     * // => 5e-324
     *
     * _.toNumber(Infinity);
     * // => Infinity
     *
     * _.toNumber('3.2');
     * // => 3.2
     */


    function toNumber(value) {
      if (typeof value == 'number') {
        return value;
      }

      if (isSymbol(value)) {
        return NAN;
      }

      if (isObject(value)) {
        var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
        value = isObject(other) ? other + '' : other;
      }

      if (typeof value != 'string') {
        return value === 0 ? value : +value;
      }

      value = value.replace(reTrim, '');
      var isBinary = reIsBinary.test(value);
      return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
    }
    /**
     * Converts `value` to a string. An empty string is returned for `null`
     * and `undefined` values. The sign of `-0` is preserved.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to process.
     * @returns {string} Returns the string.
     * @example
     *
     * _.toString(null);
     * // => ''
     *
     * _.toString(-0);
     * // => '-0'
     *
     * _.toString([1, 2, 3]);
     * // => '1,2,3'
     */


    function toString(value) {
      return value == null ? '' : baseToString(value);
    }
    /**
     * Gets the value at `path` of `object`. If the resolved value is
     * `undefined`, the `defaultValue` is returned in its place.
     *
     * @static
     * @memberOf _
     * @since 3.7.0
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @param {*} [defaultValue] The value returned for `undefined` resolved values.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
     *
     * _.get(object, 'a[0].b.c');
     * // => 3
     *
     * _.get(object, ['a', '0', 'b', 'c']);
     * // => 3
     *
     * _.get(object, 'a.b.c', 'default');
     * // => 'default'
     */


    function get(object, path, defaultValue) {
      var result = object == null ? undefined : baseGet(object, path);
      return result === undefined ? defaultValue : result;
    }
    /**
     * Checks if `path` is a direct or inherited property of `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path to check.
     * @returns {boolean} Returns `true` if `path` exists, else `false`.
     * @example
     *
     * var object = _.create({ 'a': _.create({ 'b': 2 }) });
     *
     * _.hasIn(object, 'a');
     * // => true
     *
     * _.hasIn(object, 'a.b');
     * // => true
     *
     * _.hasIn(object, ['a', 'b']);
     * // => true
     *
     * _.hasIn(object, 'b');
     * // => false
     */


    function hasIn(object, path) {
      return object != null && hasPath(object, path, baseHasIn);
    }
    /**
     * Creates an array of the own enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects. See the
     * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
     * for more details.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keys(new Foo);
     * // => ['a', 'b'] (iteration order is not guaranteed)
     *
     * _.keys('hi');
     * // => ['0', '1']
     */


    function keys(object) {
      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
    }
    /**
     * This method returns the first argument it receives.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {*} value Any value.
     * @returns {*} Returns `value`.
     * @example
     *
     * var object = { 'a': 1 };
     *
     * console.log(_.identity(object) === object);
     * // => true
     */


    function identity(value) {
      return value;
    }
    /**
     * Creates a function that returns the value at `path` of a given object.
     *
     * @static
     * @memberOf _
     * @since 2.4.0
     * @category Util
     * @param {Array|string} path The path of the property to get.
     * @returns {Function} Returns the new accessor function.
     * @example
     *
     * var objects = [
     *   { 'a': { 'b': 2 } },
     *   { 'a': { 'b': 1 } }
     * ];
     *
     * _.map(objects, _.property('a.b'));
     * // => [2, 1]
     *
     * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
     * // => [1, 2]
     */


    function property(path) {
      return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
    }

    module.exports = findLast;
  });

  var prefix$2f = settings_1.prefix;
  /**
   * @param {Node} node A DOM node.
   * @param {string[]} selectorsFloatingMenus The CSS selectors that matches floating menus.
   * @returns {boolean} `true` of the given `node` is in a floating menu.
   */

  function elementOrParentIsFloatingMenu(node) {
    var selectorsFloatingMenus = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [".".concat(prefix$2f, "--overflow-menu-options"), ".".concat(prefix$2f, "--tooltip"), '.flatpickr-calendar'];

    if (node && typeof node.closest === 'function') {
      return selectorsFloatingMenus.some(function (selector) {
        return node.closest(selector);
      });
    }
  }
  /**
   * Ensures the focus is kept in the given `modalNode`, implementing "focus-wrap" behavior.
   * @param {object} options The options.
   * @param {Node} options.bodyNode
   * @param {Node} options.startTrapNode The DOM node of the focus sentinel the is placed earlier next to `modalNode`.
   * @param {Node} options.endTrapNode The DOM node of the focus sentinel the is placed next to `modalNode`.
   * @param {Node} options.currentActiveNode The DOM node that has focus.
   * @param {Node} options.oldActiveNode The DOM node that previously had focus.
   * @param {Node} [options.selectorsFloatingMenus] The CSS selectors that matches floating menus.
   */


  function wrapFocus(_ref) {
    var bodyNode = _ref.bodyNode,
        startTrapNode = _ref.startTrapNode,
        endTrapNode = _ref.endTrapNode,
        currentActiveNode = _ref.currentActiveNode,
        oldActiveNode = _ref.oldActiveNode,
        selectorsFloatingMenus = _ref.selectorsFloatingMenus;

    if (bodyNode && currentActiveNode && oldActiveNode && !bodyNode.contains(currentActiveNode) && !elementOrParentIsFloatingMenu(currentActiveNode, selectorsFloatingMenus)) {
      var comparisonResult = oldActiveNode.compareDocumentPosition(currentActiveNode);

      if (currentActiveNode === startTrapNode || comparisonResult & DOCUMENT_POSITION_BROAD_PRECEDING) {
        var tabbable = lodash_findlast(bodyNode.querySelectorAll(selectorTabbable), function (elem) {
          return Boolean(elem.offsetParent);
        });

        if (tabbable) {
          tabbable.focus();
        } else if (bodyNode !== oldActiveNode) {
          bodyNode.focus();
        }
      } else if (currentActiveNode === endTrapNode || comparisonResult & DOCUMENT_POSITION_BROAD_FOLLOWING) {
        var _tabbable = Array.prototype.find.call(bodyNode.querySelectorAll(selectorTabbable), function (elem) {
          return Boolean(elem.offsetParent);
        });

        if (_tabbable) {
          _tabbable.focus();
        } else if (bodyNode !== oldActiveNode) {
          bodyNode.focus();
        }
      }
    }
  }

  var _defineProperty2$4, _ModalBody$propTypes;
  var prefix$2e = settings_1.prefix;

  var ComposedModal = /*#__PURE__*/function (_Component) {
    _inherits(ComposedModal, _Component);

    var _super = _createSuper(ComposedModal);

    function ComposedModal() {
      var _this;

      _classCallCheck(this, ComposedModal);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "state", {});

      _defineProperty$2(_assertThisInitialized$1(_this), "outerModal", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "innerModal", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "button", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "startSentinel", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "endSentinel", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "handleKeyDown", function (evt) {
        // Esc key
        if (evt.which === 27) {
          _this.closeModal(evt);
        }

        _this.props.onKeyDown(evt);
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleClick", function (evt) {
        if (!_this.innerModal.current.contains(evt.target) && _this.props.preventCloseOnClickOutside) {
          return;
        }

        if (_this.innerModal.current && !_this.innerModal.current.contains(evt.target)) {
          _this.closeModal(evt);
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleBlur", function (_ref) {
        var oldActiveNode = _ref.target,
            currentActiveNode = _ref.relatedTarget;
        var _this$props = _this.props,
            open = _this$props.open,
            selectorsFloatingMenus = _this$props.selectorsFloatingMenus;

        if (open && currentActiveNode && oldActiveNode) {
          var bodyNode = _this.innerModal.current;
          var startSentinelNode = _this.startSentinel.current;
          var endSentinelNode = _this.endSentinel.current;
          wrapFocus({
            bodyNode: bodyNode,
            startSentinelNode: startSentinelNode,
            endSentinelNode: endSentinelNode,
            currentActiveNode: currentActiveNode,
            oldActiveNode: oldActiveNode,
            selectorsFloatingMenus: selectorsFloatingMenus
          });
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "focusButton", function (focusContainerElement) {
        if (focusContainerElement) {
          var primaryFocusElement = focusContainerElement.querySelector(_this.props.selectorPrimaryFocus);

          if (primaryFocusElement) {
            primaryFocusElement.focus();
            return;
          }

          if (_this.button.current) {
            _this.button.current.focus();
          }
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleTransitionEnd", function (evt) {
        if (_this.outerModal.current.offsetWidth && _this.outerModal.current.offsetHeight && _this.beingOpen) {
          _this.focusButton(evt.currentTarget);

          _this.beingOpen = false;
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "closeModal", function (evt) {
        var onClose = _this.props.onClose;

        if (!onClose || onClose(evt) !== false) {
          _this.setState({
            open: false
          });
        }
      });

      return _this;
    }

    _createClass(ComposedModal, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps, prevState) {
        if (!prevState.open && this.state.open) {
          this.beingOpen = true;
        } else if (prevState.open && !this.state.open) {
          this.beingOpen = false;
        }

        if (prevState.open !== this.state.open) {
          toggleClass$1(document.body, "".concat(prefix$2e, "--body--with-modal-open"), this.state.open);
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        toggleClass$1(document.body, "".concat(prefix$2e, "--body--with-modal-open"), false);
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        toggleClass$1(document.body, "".concat(prefix$2e, "--body--with-modal-open"), this.props.open);

        if (!this.props.open) {
          return;
        }

        if (this.innerModal.current) {
          this.focusButton(this.innerModal.current);
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames,
            _classNames2,
            _this2 = this;

        var open = this.state.open;

        var _this$props2 = this.props,
            ariaLabelledBy = _this$props2['aria-labelledby'],
            ariaLabel = _this$props2['aria-label'],
            className = _this$props2.className,
            containerClassName = _this$props2.containerClassName,
            children = _this$props2.children,
            danger = _this$props2.danger;
            _this$props2.preventCloseOnClickOutside;
            _this$props2.selectorPrimaryFocus;
            var size = _this$props2.size,
            other = _objectWithoutProperties$2(_this$props2, ["aria-labelledby", "aria-label", "className", "containerClassName", "children", "danger", "preventCloseOnClickOutside", "selectorPrimaryFocus", "size"]);

        var modalClass = classnames((_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$2e, "--modal"), true), _defineProperty$2(_classNames, 'is-visible', open), _defineProperty$2(_classNames, className, className), _defineProperty$2(_classNames, "".concat(prefix$2e, "--modal--danger"), danger), _classNames));
        var containerClass = classnames((_classNames2 = {}, _defineProperty$2(_classNames2, "".concat(prefix$2e, "--modal-container"), true), _defineProperty$2(_classNames2, "".concat(prefix$2e, "--modal-container--").concat(size), size), _defineProperty$2(_classNames2, containerClassName, containerClassName), _classNames2)); // Generate aria-label based on Modal Header label if one is not provided (L253)

        var generatedAriaLabel;
        var childrenWithProps = React__default['default'].Children.toArray(children).map(function (child) {
          switch (child.type) {
            case /*#__PURE__*/React__default['default'].createElement(ModalHeader).type:
              generatedAriaLabel = child.props.label;
              return /*#__PURE__*/React__default['default'].cloneElement(child, {
                closeModal: _this2.closeModal
              });

            case /*#__PURE__*/React__default['default'].createElement(ModalFooter).type:
              return /*#__PURE__*/React__default['default'].cloneElement(child, {
                closeModal: _this2.closeModal,
                inputref: _this2.button
              });

            default:
              return child;
          }
        });
        return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, other, {
          role: "presentation",
          ref: this.outerModal,
          onBlur: this.handleBlur,
          onClick: this.handleClick,
          onKeyDown: this.handleKeyDown,
          onTransitionEnd: open ? this.handleTransitionEnd : undefined,
          className: modalClass
        }), /*#__PURE__*/React__default['default'].createElement("span", {
          ref: this.startSentinel,
          tabIndex: "0",
          role: "link",
          className: "".concat(prefix$2e, "--visually-hidden")
        }, "Focus sentinel"), /*#__PURE__*/React__default['default'].createElement("div", {
          ref: this.innerModal,
          className: containerClass,
          role: "dialog",
          "aria-modal": "true",
          "aria-label": ariaLabel ? ariaLabel : generatedAriaLabel,
          "aria-labelledby": ariaLabelledBy
        }, childrenWithProps), /*#__PURE__*/React__default['default'].createElement("span", {
          ref: this.endSentinel,
          tabIndex: "0",
          role: "link",
          className: "".concat(prefix$2e, "--visually-hidden")
        }, "Focus sentinel"));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref2, state) {
        var open = _ref2.open;
        var prevOpen = state.prevOpen;
        return prevOpen === open ? null : {
          open: open,
          prevOpen: open
        };
      }
    }]);

    return ComposedModal;
  }(React.Component);

  _defineProperty$2(ComposedModal, "defaultProps", {
    onKeyDown: function onKeyDown() {},
    selectorPrimaryFocus: '[data-modal-primary-focus]'
  });

  _defineProperty$2(ComposedModal, "propTypes", (_defineProperty2$4 = {}, _defineProperty$2(_defineProperty2$4, 'aria-label', PropTypes__default['default'].string), _defineProperty$2(_defineProperty2$4, 'aria-labelledby', PropTypes__default['default'].string), _defineProperty$2(_defineProperty2$4, "children", PropTypes__default['default'].node), _defineProperty$2(_defineProperty2$4, "className", PropTypes__default['default'].string), _defineProperty$2(_defineProperty2$4, "containerClassName", PropTypes__default['default'].string), _defineProperty$2(_defineProperty2$4, "danger", PropTypes__default['default'].bool), _defineProperty$2(_defineProperty2$4, "onClose", PropTypes__default['default'].func), _defineProperty$2(_defineProperty2$4, "onKeyDown", PropTypes__default['default'].func), _defineProperty$2(_defineProperty2$4, "open", PropTypes__default['default'].bool), _defineProperty$2(_defineProperty2$4, "preventCloseOnClickOutside", PropTypes__default['default'].bool), _defineProperty$2(_defineProperty2$4, "selectorPrimaryFocus", PropTypes__default['default'].string), _defineProperty$2(_defineProperty2$4, "selectorsFloatingMenus", PropTypes__default['default'].string), _defineProperty$2(_defineProperty2$4, "size", PropTypes__default['default'].oneOf(['xs', 'sm', 'md', 'lg'])), _defineProperty2$4));
  var ModalHeader = /*#__PURE__*/function (_Component2) {
    _inherits(ModalHeader, _Component2);

    var _super2 = _createSuper(ModalHeader);

    function ModalHeader() {
      var _this3;

      _classCallCheck(this, ModalHeader);

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      _this3 = _super2.call.apply(_super2, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this3), "handleCloseButtonClick", function (evt) {
        _this3.props.closeModal(evt);

        _this3.props.buttonOnClick();
      });

      return _this3;
    }

    _createClass(ModalHeader, [{
      key: "render",
      value: function render() {
        var _classNames3, _classNames4, _classNames5, _classNames6, _classNames7;

        var _this$props3 = this.props,
            className = _this$props3.className,
            labelClassName = _this$props3.labelClassName,
            titleClassName = _this$props3.titleClassName,
            closeClassName = _this$props3.closeClassName,
            closeIconClassName = _this$props3.closeIconClassName,
            label = _this$props3.label,
            title = _this$props3.title,
            children = _this$props3.children,
            iconDescription = _this$props3.iconDescription;
            _this$props3.closeModal;
            _this$props3.buttonOnClick;
            _this$props3.preventCloseOnClickOutside;
            var other = _objectWithoutProperties$2(_this$props3, ["className", "labelClassName", "titleClassName", "closeClassName", "closeIconClassName", "label", "title", "children", "iconDescription", "closeModal", "buttonOnClick", "preventCloseOnClickOutside"]);

        var headerClass = classnames((_classNames3 = {}, _defineProperty$2(_classNames3, "".concat(prefix$2e, "--modal-header"), true), _defineProperty$2(_classNames3, className, className), _classNames3));
        var labelClass = classnames((_classNames4 = {}, _defineProperty$2(_classNames4, "".concat(prefix$2e, "--modal-header__label ").concat(prefix$2e, "--type-delta"), true), _defineProperty$2(_classNames4, labelClassName, labelClassName), _classNames4));
        var titleClass = classnames((_classNames5 = {}, _defineProperty$2(_classNames5, "".concat(prefix$2e, "--modal-header__heading ").concat(prefix$2e, "--type-beta"), true), _defineProperty$2(_classNames5, titleClassName, titleClassName), _classNames5));
        var closeClass = classnames((_classNames6 = {}, _defineProperty$2(_classNames6, "".concat(prefix$2e, "--modal-close"), true), _defineProperty$2(_classNames6, closeClassName, closeClassName), _classNames6));
        var closeIconClass = classnames((_classNames7 = {}, _defineProperty$2(_classNames7, "".concat(prefix$2e, "--modal-close__icon"), true), _defineProperty$2(_classNames7, closeIconClassName, closeIconClassName), _classNames7));
        return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
          className: headerClass
        }, other), label && /*#__PURE__*/React__default['default'].createElement("h2", {
          className: labelClass
        }, label), title && /*#__PURE__*/React__default['default'].createElement("h3", {
          className: titleClass
        }, title), children, /*#__PURE__*/React__default['default'].createElement("button", {
          onClick: this.handleCloseButtonClick,
          className: closeClass,
          title: iconDescription,
          "aria-label": iconDescription,
          type: "button"
        }, /*#__PURE__*/React__default['default'].createElement(Close20, {
          className: closeIconClass
        })));
      }
    }]);

    return ModalHeader;
  }(React.Component);

  _defineProperty$2(ModalHeader, "propTypes", {
    /**
     * Provide an optional function to be called when the close button is
     * clicked
     */
    buttonOnClick: PropTypes__default['default'].func,

    /**
     * Specify the content to be placed in the ModalHeader
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the modal header
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify an optional className to be applied to the modal close node
     */
    closeClassName: PropTypes__default['default'].string,

    /**
     * Specify an optional className to be applied to the modal close icon node
     */
    closeIconClassName: PropTypes__default['default'].string,

    /**
     * Provide an optional function to be called when the modal is closed
     */
    closeModal: PropTypes__default['default'].func,

    /**
     * Specify a description for the close icon that can be read by screen
     * readers
     */
    iconDescription: PropTypes__default['default'].string,

    /**
     * Specify an optional label to be displayed
     */
    label: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the modal header label
     */
    labelClassName: PropTypes__default['default'].string,

    /**
     * Specify an optional title to be displayed
     */
    title: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the modal heading
     */
    titleClassName: PropTypes__default['default'].string
  });

  _defineProperty$2(ModalHeader, "defaultProps", {
    iconDescription: 'Close',
    buttonOnClick: function buttonOnClick() {}
  });

  function ModalBody(props) {
    var _classNames8;

    var className = props.className,
        children = props.children,
        hasForm = props.hasForm,
        hasScrollingContent = props.hasScrollingContent;
        props.preventCloseOnClickOutside;
        var other = _objectWithoutProperties$2(props, ["className", "children", "hasForm", "hasScrollingContent", "preventCloseOnClickOutside"]);

    var contentClass = classnames((_classNames8 = {}, _defineProperty$2(_classNames8, "".concat(prefix$2e, "--modal-content"), true), _defineProperty$2(_classNames8, "".concat(prefix$2e, "--modal-content--with-form"), hasForm), _defineProperty$2(_classNames8, "".concat(prefix$2e, "--modal-scroll-content"), hasScrollingContent), _defineProperty$2(_classNames8, className, className), _classNames8));
    var hasScrollingContentProps = hasScrollingContent ? {
      tabIndex: 0,
      role: 'region'
    } : {};
    return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: contentClass
    }, hasScrollingContentProps, other), children), hasScrollingContent && /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2e, "--modal-content--overflow-indicator")
    }));
  }
  ModalBody.propTypes = (_ModalBody$propTypes = {}, _defineProperty$2(_ModalBody$propTypes, 'aria-label', requiredIfGivenPropIsTruthy('hasScrollingContent', PropTypes__default['default'].string)), _defineProperty$2(_ModalBody$propTypes, "children", PropTypes__default['default'].node), _defineProperty$2(_ModalBody$propTypes, "className", PropTypes__default['default'].string), _defineProperty$2(_ModalBody$propTypes, "hasForm", PropTypes__default['default'].bool), _defineProperty$2(_ModalBody$propTypes, "hasScrollingContent", PropTypes__default['default'].bool), _ModalBody$propTypes);
  var ModalFooter = /*#__PURE__*/function (_Component3) {
    _inherits(ModalFooter, _Component3);

    var _super3 = _createSuper(ModalFooter);

    function ModalFooter() {
      var _this4;

      _classCallCheck(this, ModalFooter);

      for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      _this4 = _super3.call.apply(_super3, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this4), "handleRequestClose", function (evt) {
        _this4.props.closeModal(evt);

        _this4.props.onRequestClose(evt);
      });

      return _this4;
    }

    _createClass(ModalFooter, [{
      key: "render",
      value: function render() {
        var _classNames9,
            _this5 = this;

        var _this$props4 = this.props,
            className = _this$props4.className,
            primaryClassName = _this$props4.primaryClassName,
            secondaryButtons = _this$props4.secondaryButtons,
            secondaryClassName = _this$props4.secondaryClassName,
            secondaryButtonText = _this$props4.secondaryButtonText,
            primaryButtonText = _this$props4.primaryButtonText,
            primaryButtonDisabled = _this$props4.primaryButtonDisabled;
            _this$props4.closeModal;
            _this$props4.onRequestClose;
            var onRequestSubmit = _this$props4.onRequestSubmit,
            children = _this$props4.children,
            danger = _this$props4.danger,
            inputref = _this$props4.inputref,
            other = _objectWithoutProperties$2(_this$props4, ["className", "primaryClassName", "secondaryButtons", "secondaryClassName", "secondaryButtonText", "primaryButtonText", "primaryButtonDisabled", "closeModal", "onRequestClose", "onRequestSubmit", "children", "danger", "inputref"]);

        var footerClass = classnames((_classNames9 = {}, _defineProperty$2(_classNames9, "".concat(prefix$2e, "--modal-footer"), true), _defineProperty$2(_classNames9, className, className), _defineProperty$2(_classNames9, "".concat(prefix$2e, "--modal-footer--three-button"), Array.isArray(secondaryButtons) && secondaryButtons.length === 2), _classNames9));
        var primaryClass = classnames(_defineProperty$2({}, primaryClassName, primaryClassName));
        var secondaryClass = classnames(_defineProperty$2({}, secondaryClassName, secondaryClassName));

        var SecondaryButtonSet = function SecondaryButtonSet() {
          if (Array.isArray(secondaryButtons) && secondaryButtons.length <= 2) {
            return secondaryButtons.map(function (_ref3, i) {
              var buttonText = _ref3.buttonText,
                  onButtonClick = _ref3.onClick;
              return /*#__PURE__*/React__default['default'].createElement(Button, {
                key: "".concat(buttonText, "-").concat(i),
                className: secondaryClass,
                kind: "secondary",
                onClick: onButtonClick || _this5.handleRequestClose
              }, buttonText);
            });
          }

          if (secondaryButtonText) {
            return /*#__PURE__*/React__default['default'].createElement(Button, {
              className: secondaryClass,
              onClick: _this5.handleRequestClose,
              kind: "secondary"
            }, secondaryButtonText);
          }

          return null;
        };

        return /*#__PURE__*/React__default['default'].createElement(ButtonSet, _extends$3({
          className: footerClass
        }, other), /*#__PURE__*/React__default['default'].createElement(SecondaryButtonSet, null), primaryButtonText && /*#__PURE__*/React__default['default'].createElement(Button, {
          onClick: onRequestSubmit,
          className: primaryClass,
          disabled: primaryButtonDisabled,
          kind: danger ? 'danger' : 'primary',
          ref: inputref
        }, primaryButtonText), children);
      }
    }]);

    return ModalFooter;
  }(React.Component);

  _defineProperty$2(ModalFooter, "propTypes", {
    /**
     * Pass in content that will be rendered in the Modal Footer
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify a custom className to be applied to the Modal Footer container
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify an optional function that is called whenever the modal is closed
     */
    closeModal: PropTypes__default['default'].func,

    /**
     * Specify whether the primary button should be replaced with danger button.
     * Note that this prop is not applied if you render primary/danger button by yourself
     */
    danger: PropTypes__default['default'].bool,

    /**
     * The `ref` callback for the primary button.
     */
    inputref: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].shape({
      current: PropTypes__default['default'].any
    })]),

    /**
     * Specify an optional function for when the modal is requesting to be
     * closed
     */
    onRequestClose: PropTypes__default['default'].func,

    /**
     * Specify an optional function for when the modal is requesting to be
     * submitted
     */
    onRequestSubmit: PropTypes__default['default'].func,

    /**
     * Specify whether the primary button should be disabled
     */
    primaryButtonDisabled: PropTypes__default['default'].bool,

    /**
     * Specify the text for the primary button
     */
    primaryButtonText: PropTypes__default['default'].string,

    /**
     * Specify a custom className to be applied to the primary button
     */
    primaryClassName: PropTypes__default['default'].string,

    /**
     * Specify the text for the secondary button
     */
    secondaryButtonText: PropTypes__default['default'].string,

    /**
     * Specify an array of config objects for secondary buttons
     * (`Array<{
     *   buttonText: string,
     *   onClick: function,
     * }>`).
     */
    secondaryButtons: function secondaryButtons(props, propName, componentName) {
      if (props.secondaryButtons) {
        if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
          return new Error("".concat(propName, " needs to be an array of two button config objects"));
        }

        var shape = {
          buttonText: PropTypes__default['default'].node,
          onClick: PropTypes__default['default'].func
        };
        props[propName].forEach(function (secondaryButton) {
          PropTypes__default['default'].checkPropTypes(shape, secondaryButton, propName, componentName);
        });
      }

      return null;
    },

    /**
     * Specify a custom className to be applied to the secondary button
     */
    secondaryClassName: PropTypes__default['default'].string
  });

  _defineProperty$2(ModalFooter, "defaultProps", {
    onRequestClose: function onRequestClose() {},
    onRequestSubmit: function onRequestSubmit() {}
  });

  var prefix$2d = settings_1.prefix;

  var ContentSwitcher = /*#__PURE__*/function (_React$Component) {
    _inherits(ContentSwitcher, _React$Component);

    var _super = _createSuper(ContentSwitcher);

    function ContentSwitcher() {
      var _this;

      _classCallCheck(this, ContentSwitcher);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "_switchRefs", []);

      _defineProperty$2(_assertThisInitialized$1(_this), "state", {});

      _defineProperty$2(_assertThisInitialized$1(_this), "handleItemRef", function (index) {
        return function (ref) {
          _this._switchRefs[index] = ref;
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleChildChange", function (data) {
        var selectionMode = _this.props.selectionMode; // the currently selected child index

        var selectedIndex = _this.state.selectedIndex; // the newly selected child index

        var index = data.index;
        var key = data.key;

        if (matches(data, [ArrowRight, ArrowLeft])) {
          var nextIndex = getNextIndex(key, index, _this.props.children.length);
          var children = React__default['default'].Children.toArray(_this.props.children);

          if (selectionMode === 'manual') {
            var switchRef = _this._switchRefs[nextIndex];
            switchRef && switchRef.focus();
          } else {
            _this.setState({
              selectedIndex: nextIndex
            }, function () {
              var child = children[_this.state.selectedIndex];
              var switchRef = _this._switchRefs[_this.state.selectedIndex];
              switchRef && switchRef.focus();

              _this.props.onChange(_objectSpread2$2(_objectSpread2$2({}, data), {}, {
                index: _this.state.selectedIndex,
                name: child.props.name,
                text: child.props.text
              }));
            });
          }
        } else if (selectedIndex !== index) {
          _this.setState({
            selectedIndex: index
          }, function () {
            var switchRef = _this._switchRefs[index];
            switchRef && switchRef.focus();

            _this.props.onChange(data);
          });
        }
      });

      return _this;
    }

    _createClass(ContentSwitcher, [{
      key: "render",
      value: function render() {
        var _classNames,
            _this2 = this;

        var _this$props = this.props,
            children = _this$props.children,
            className = _this$props.className,
            light = _this$props.light;
            _this$props.selectedIndex;
            _this$props.selectionMode;
            var size = _this$props.size,
            other = _objectWithoutProperties$2(_this$props, ["children", "className", "light", "selectedIndex", "selectionMode", "size"]);

        var classes = classnames("".concat(prefix$2d, "--content-switcher"), className, (_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$2d, "--content-switcher--light"), light), _defineProperty$2(_classNames, "".concat(prefix$2d, "--content-switcher--").concat(size), size), _classNames));
        return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, other, {
          className: classes,
          role: "tablist"
        }), React__default['default'].Children.map(children, function (child, index) {
          return /*#__PURE__*/React__default['default'].cloneElement(child, {
            index: index,
            onClick: composeEventHandlers([_this2.handleChildChange, child.props.onClick]),
            onKeyDown: _this2.handleChildChange,
            selected: index === _this2.state.selectedIndex,
            ref: _this2.handleItemRef(index)
          });
        }));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref, state) {
        var selectedIndex = _ref.selectedIndex;
        var prevSelectedIndex = state.prevSelectedIndex;
        return prevSelectedIndex === selectedIndex ? null : {
          selectedIndex: selectedIndex,
          prevSelectedIndex: selectedIndex
        };
      }
    }]);

    return ContentSwitcher;
  }(React__default['default'].Component);

  _defineProperty$2(ContentSwitcher, "propTypes", {
    /**
     * Pass in Switch components to be rendered in the ContentSwitcher
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be added to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * `true` to use the light variant.
     */
    light: deprecate(PropTypes__default['default'].bool, 'The `light` prop for `ContentSwitcher` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

    /**
     * Specify an `onChange` handler that is called whenever the ContentSwitcher
     * changes which item is selected
     */
    onChange: PropTypes__default['default'].func.isRequired,

    /**
     * Specify a selected index for the initially selected content
     */
    selectedIndex: PropTypes__default['default'].number,

    /**
     * Choose whether or not to automatically change selection on focus
     */
    selectionMode: PropTypes__default['default'].oneOf(['automatic', 'manual']),

    /**
     * Specify the size of the Content Switcher. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
     * TODO V11: remove `xl` (replaced with lg)
     */
    size: PropTypes__default['default'].oneOf(['sm', 'md', 'lg', 'xl'])
  });

  _defineProperty$2(ContentSwitcher, "defaultProps", {
    selectedIndex: 0,
    selectionMode: 'automatic',
    onChange: function onChange() {}
  });

  var DangerButton = function DangerButton(props) {
    return /*#__PURE__*/React__default['default'].createElement(Button, _extends$3({
      kind: "danger"
    }, props));
  };

  var lodash_isequal = createCommonjsModule(function (module, exports) {
    /** Used as the size to enable large array optimizations. */
    var LARGE_ARRAY_SIZE = 200;
    /** Used to stand-in for `undefined` hash values. */

    var HASH_UNDEFINED = '__lodash_hash_undefined__';
    /** Used to compose bitmasks for value comparisons. */

    var COMPARE_PARTIAL_FLAG = 1,
        COMPARE_UNORDERED_FLAG = 2;
    /** Used as references for various `Number` constants. */

    var MAX_SAFE_INTEGER = 9007199254740991;
    /** `Object#toString` result references. */

    var argsTag = '[object Arguments]',
        arrayTag = '[object Array]',
        asyncTag = '[object AsyncFunction]',
        boolTag = '[object Boolean]',
        dateTag = '[object Date]',
        errorTag = '[object Error]',
        funcTag = '[object Function]',
        genTag = '[object GeneratorFunction]',
        mapTag = '[object Map]',
        numberTag = '[object Number]',
        nullTag = '[object Null]',
        objectTag = '[object Object]',
        promiseTag = '[object Promise]',
        proxyTag = '[object Proxy]',
        regexpTag = '[object RegExp]',
        setTag = '[object Set]',
        stringTag = '[object String]',
        symbolTag = '[object Symbol]',
        undefinedTag = '[object Undefined]',
        weakMapTag = '[object WeakMap]';
    var arrayBufferTag = '[object ArrayBuffer]',
        dataViewTag = '[object DataView]',
        float32Tag = '[object Float32Array]',
        float64Tag = '[object Float64Array]',
        int8Tag = '[object Int8Array]',
        int16Tag = '[object Int16Array]',
        int32Tag = '[object Int32Array]',
        uint8Tag = '[object Uint8Array]',
        uint8ClampedTag = '[object Uint8ClampedArray]',
        uint16Tag = '[object Uint16Array]',
        uint32Tag = '[object Uint32Array]';
    /**
     * Used to match `RegExp`
     * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
     */

    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    /** Used to detect host constructors (Safari). */

    var reIsHostCtor = /^\[object .+?Constructor\]$/;
    /** Used to detect unsigned integer values. */

    var reIsUint = /^(?:0|[1-9]\d*)$/;
    /** Used to identify `toStringTag` values of typed arrays. */

    var typedArrayTags = {};
    typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
    typedArrayTags[argsTag] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
    /** Detect free variable `global` from Node.js. */

    var freeGlobal = _typeof(commonjsGlobal) == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
    /** Detect free variable `self`. */

    var freeSelf = (typeof self === "undefined" ? "undefined" : _typeof(self)) == 'object' && self && self.Object === Object && self;
    /** Used as a reference to the global object. */

    var root = freeGlobal || freeSelf || Function('return this')();
    /** Detect free variable `exports`. */

    var freeExports = exports && !exports.nodeType && exports;
    /** Detect free variable `module`. */

    var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;
    /** Detect the popular CommonJS extension `module.exports`. */

    var moduleExports = freeModule && freeModule.exports === freeExports;
    /** Detect free variable `process` from Node.js. */

    var freeProcess = moduleExports && freeGlobal.process;
    /** Used to access faster Node.js helpers. */

    var nodeUtil = function () {
      try {
        return freeProcess && freeProcess.binding && freeProcess.binding('util');
      } catch (e) {}
    }();
    /* Node.js helper references. */


    var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
    /**
     * A specialized version of `_.filter` for arrays without support for
     * iteratee shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     */

    function arrayFilter(array, predicate) {
      var index = -1,
          length = array == null ? 0 : array.length,
          resIndex = 0,
          result = [];

      while (++index < length) {
        var value = array[index];

        if (predicate(value, index, array)) {
          result[resIndex++] = value;
        }
      }

      return result;
    }
    /**
     * Appends the elements of `values` to `array`.
     *
     * @private
     * @param {Array} array The array to modify.
     * @param {Array} values The values to append.
     * @returns {Array} Returns `array`.
     */


    function arrayPush(array, values) {
      var index = -1,
          length = values.length,
          offset = array.length;

      while (++index < length) {
        array[offset + index] = values[index];
      }

      return array;
    }
    /**
     * A specialized version of `_.some` for arrays without support for iteratee
     * shorthands.
     *
     * @private
     * @param {Array} [array] The array to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */


    function arraySome(array, predicate) {
      var index = -1,
          length = array == null ? 0 : array.length;

      while (++index < length) {
        if (predicate(array[index], index, array)) {
          return true;
        }
      }

      return false;
    }
    /**
     * The base implementation of `_.times` without support for iteratee shorthands
     * or max array length checks.
     *
     * @private
     * @param {number} n The number of times to invoke `iteratee`.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the array of results.
     */


    function baseTimes(n, iteratee) {
      var index = -1,
          result = Array(n);

      while (++index < n) {
        result[index] = iteratee(index);
      }

      return result;
    }
    /**
     * The base implementation of `_.unary` without support for storing metadata.
     *
     * @private
     * @param {Function} func The function to cap arguments for.
     * @returns {Function} Returns the new capped function.
     */


    function baseUnary(func) {
      return function (value) {
        return func(value);
      };
    }
    /**
     * Checks if a `cache` value for `key` exists.
     *
     * @private
     * @param {Object} cache The cache to query.
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function cacheHas(cache, key) {
      return cache.has(key);
    }
    /**
     * Gets the value at `key` of `object`.
     *
     * @private
     * @param {Object} [object] The object to query.
     * @param {string} key The key of the property to get.
     * @returns {*} Returns the property value.
     */


    function getValue(object, key) {
      return object == null ? undefined : object[key];
    }
    /**
     * Converts `map` to its key-value pairs.
     *
     * @private
     * @param {Object} map The map to convert.
     * @returns {Array} Returns the key-value pairs.
     */


    function mapToArray(map) {
      var index = -1,
          result = Array(map.size);
      map.forEach(function (value, key) {
        result[++index] = [key, value];
      });
      return result;
    }
    /**
     * Creates a unary function that invokes `func` with its argument transformed.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {Function} transform The argument transform.
     * @returns {Function} Returns the new function.
     */


    function overArg(func, transform) {
      return function (arg) {
        return func(transform(arg));
      };
    }
    /**
     * Converts `set` to an array of its values.
     *
     * @private
     * @param {Object} set The set to convert.
     * @returns {Array} Returns the values.
     */


    function setToArray(set) {
      var index = -1,
          result = Array(set.size);
      set.forEach(function (value) {
        result[++index] = value;
      });
      return result;
    }
    /** Used for built-in method references. */


    var arrayProto = Array.prototype,
        funcProto = Function.prototype,
        objectProto = Object.prototype;
    /** Used to detect overreaching core-js shims. */

    var coreJsData = root['__core-js_shared__'];
    /** Used to resolve the decompiled source of functions. */

    var funcToString = funcProto.toString;
    /** Used to check objects for own properties. */

    var hasOwnProperty = objectProto.hasOwnProperty;
    /** Used to detect methods masquerading as native. */

    var maskSrcKey = function () {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
      return uid ? 'Symbol(src)_1.' + uid : '';
    }();
    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */


    var nativeObjectToString = objectProto.toString;
    /** Used to detect if a method is native. */

    var reIsNative = RegExp('^' + funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');
    /** Built-in value references. */

    var Buffer = moduleExports ? root.Buffer : undefined,
        _Symbol = root.Symbol,
        Uint8Array = root.Uint8Array,
        propertyIsEnumerable = objectProto.propertyIsEnumerable,
        splice = arrayProto.splice,
        symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;
    /* Built-in method references for those with the same name as other `lodash` methods. */

    var nativeGetSymbols = Object.getOwnPropertySymbols,
        nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
        nativeKeys = overArg(Object.keys, Object);
    /* Built-in method references that are verified to be native. */

    var DataView = getNative(root, 'DataView'),
        Map = getNative(root, 'Map'),
        Promise = getNative(root, 'Promise'),
        Set = getNative(root, 'Set'),
        WeakMap = getNative(root, 'WeakMap'),
        nativeCreate = getNative(Object, 'create');
    /** Used to detect maps, sets, and weakmaps. */

    var dataViewCtorString = toSource(DataView),
        mapCtorString = toSource(Map),
        promiseCtorString = toSource(Promise),
        setCtorString = toSource(Set),
        weakMapCtorString = toSource(WeakMap);
    /** Used to convert symbols to primitives and strings. */

    var symbolProto = _Symbol ? _Symbol.prototype : undefined,
        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;
    /**
     * Creates a hash object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function Hash(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the hash.
     *
     * @private
     * @name clear
     * @memberOf Hash
     */


    function hashClear() {
      this.__data__ = nativeCreate ? nativeCreate(null) : {};
      this.size = 0;
    }
    /**
     * Removes `key` and its value from the hash.
     *
     * @private
     * @name delete
     * @memberOf Hash
     * @param {Object} hash The hash to modify.
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function hashDelete(key) {
      var result = this.has(key) && delete this.__data__[key];
      this.size -= result ? 1 : 0;
      return result;
    }
    /**
     * Gets the hash value for `key`.
     *
     * @private
     * @name get
     * @memberOf Hash
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function hashGet(key) {
      var data = this.__data__;

      if (nativeCreate) {
        var result = data[key];
        return result === HASH_UNDEFINED ? undefined : result;
      }

      return hasOwnProperty.call(data, key) ? data[key] : undefined;
    }
    /**
     * Checks if a hash value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Hash
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function hashHas(key) {
      var data = this.__data__;
      return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
    }
    /**
     * Sets the hash `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Hash
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the hash instance.
     */


    function hashSet(key, value) {
      var data = this.__data__;
      this.size += this.has(key) ? 0 : 1;
      data[key] = nativeCreate && value === undefined ? HASH_UNDEFINED : value;
      return this;
    } // Add methods to `Hash`.


    Hash.prototype.clear = hashClear;
    Hash.prototype['delete'] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;
    /**
     * Creates an list cache object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function ListCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the list cache.
     *
     * @private
     * @name clear
     * @memberOf ListCache
     */


    function listCacheClear() {
      this.__data__ = [];
      this.size = 0;
    }
    /**
     * Removes `key` and its value from the list cache.
     *
     * @private
     * @name delete
     * @memberOf ListCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function listCacheDelete(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        return false;
      }

      var lastIndex = data.length - 1;

      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }

      --this.size;
      return true;
    }
    /**
     * Gets the list cache value for `key`.
     *
     * @private
     * @name get
     * @memberOf ListCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function listCacheGet(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);
      return index < 0 ? undefined : data[index][1];
    }
    /**
     * Checks if a list cache value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf ListCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function listCacheHas(key) {
      return assocIndexOf(this.__data__, key) > -1;
    }
    /**
     * Sets the list cache `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf ListCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the list cache instance.
     */


    function listCacheSet(key, value) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        ++this.size;
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }

      return this;
    } // Add methods to `ListCache`.


    ListCache.prototype.clear = listCacheClear;
    ListCache.prototype['delete'] = listCacheDelete;
    ListCache.prototype.get = listCacheGet;
    ListCache.prototype.has = listCacheHas;
    ListCache.prototype.set = listCacheSet;
    /**
     * Creates a map cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function MapCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;
      this.clear();

      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }
    /**
     * Removes all key-value entries from the map.
     *
     * @private
     * @name clear
     * @memberOf MapCache
     */


    function mapCacheClear() {
      this.size = 0;
      this.__data__ = {
        'hash': new Hash(),
        'map': new (Map || ListCache)(),
        'string': new Hash()
      };
    }
    /**
     * Removes `key` and its value from the map.
     *
     * @private
     * @name delete
     * @memberOf MapCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function mapCacheDelete(key) {
      var result = getMapData(this, key)['delete'](key);
      this.size -= result ? 1 : 0;
      return result;
    }
    /**
     * Gets the map value for `key`.
     *
     * @private
     * @name get
     * @memberOf MapCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function mapCacheGet(key) {
      return getMapData(this, key).get(key);
    }
    /**
     * Checks if a map value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf MapCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function mapCacheHas(key) {
      return getMapData(this, key).has(key);
    }
    /**
     * Sets the map `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf MapCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the map cache instance.
     */


    function mapCacheSet(key, value) {
      var data = getMapData(this, key),
          size = data.size;
      data.set(key, value);
      this.size += data.size == size ? 0 : 1;
      return this;
    } // Add methods to `MapCache`.


    MapCache.prototype.clear = mapCacheClear;
    MapCache.prototype['delete'] = mapCacheDelete;
    MapCache.prototype.get = mapCacheGet;
    MapCache.prototype.has = mapCacheHas;
    MapCache.prototype.set = mapCacheSet;
    /**
     *
     * Creates an array cache object to store unique values.
     *
     * @private
     * @constructor
     * @param {Array} [values] The values to cache.
     */

    function SetCache(values) {
      var index = -1,
          length = values == null ? 0 : values.length;
      this.__data__ = new MapCache();

      while (++index < length) {
        this.add(values[index]);
      }
    }
    /**
     * Adds `value` to the array cache.
     *
     * @private
     * @name add
     * @memberOf SetCache
     * @alias push
     * @param {*} value The value to cache.
     * @returns {Object} Returns the cache instance.
     */


    function setCacheAdd(value) {
      this.__data__.set(value, HASH_UNDEFINED);

      return this;
    }
    /**
     * Checks if `value` is in the array cache.
     *
     * @private
     * @name has
     * @memberOf SetCache
     * @param {*} value The value to search for.
     * @returns {number} Returns `true` if `value` is found, else `false`.
     */


    function setCacheHas(value) {
      return this.__data__.has(value);
    } // Add methods to `SetCache`.


    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
    SetCache.prototype.has = setCacheHas;
    /**
     * Creates a stack cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */

    function Stack(entries) {
      var data = this.__data__ = new ListCache(entries);
      this.size = data.size;
    }
    /**
     * Removes all key-value entries from the stack.
     *
     * @private
     * @name clear
     * @memberOf Stack
     */


    function stackClear() {
      this.__data__ = new ListCache();
      this.size = 0;
    }
    /**
     * Removes `key` and its value from the stack.
     *
     * @private
     * @name delete
     * @memberOf Stack
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */


    function stackDelete(key) {
      var data = this.__data__,
          result = data['delete'](key);
      this.size = data.size;
      return result;
    }
    /**
     * Gets the stack value for `key`.
     *
     * @private
     * @name get
     * @memberOf Stack
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */


    function stackGet(key) {
      return this.__data__.get(key);
    }
    /**
     * Checks if a stack value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Stack
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */


    function stackHas(key) {
      return this.__data__.has(key);
    }
    /**
     * Sets the stack `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Stack
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the stack cache instance.
     */


    function stackSet(key, value) {
      var data = this.__data__;

      if (data instanceof ListCache) {
        var pairs = data.__data__;

        if (!Map || pairs.length < LARGE_ARRAY_SIZE - 1) {
          pairs.push([key, value]);
          this.size = ++data.size;
          return this;
        }

        data = this.__data__ = new MapCache(pairs);
      }

      data.set(key, value);
      this.size = data.size;
      return this;
    } // Add methods to `Stack`.


    Stack.prototype.clear = stackClear;
    Stack.prototype['delete'] = stackDelete;
    Stack.prototype.get = stackGet;
    Stack.prototype.has = stackHas;
    Stack.prototype.set = stackSet;
    /**
     * Creates an array of the enumerable property names of the array-like `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @param {boolean} inherited Specify returning inherited property names.
     * @returns {Array} Returns the array of property names.
     */

    function arrayLikeKeys(value, inherited) {
      var isArr = isArray(value),
          isArg = !isArr && isArguments(value),
          isBuff = !isArr && !isArg && isBuffer(value),
          isType = !isArr && !isArg && !isBuff && isTypedArray(value),
          skipIndexes = isArr || isArg || isBuff || isType,
          result = skipIndexes ? baseTimes(value.length, String) : [],
          length = result.length;

      for (var key in value) {
        if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && ( // Safari 9 has enumerable `arguments.length` in strict mode.
        key == 'length' || // Node.js 0.10 has enumerable non-index properties on buffers.
        isBuff && (key == 'offset' || key == 'parent') || // PhantomJS 2 has enumerable non-index properties on typed arrays.
        isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset') || // Skip index properties.
        isIndex(key, length)))) {
          result.push(key);
        }
      }

      return result;
    }
    /**
     * Gets the index at which the `key` is found in `array` of key-value pairs.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {*} key The key to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */


    function assocIndexOf(array, key) {
      var length = array.length;

      while (length--) {
        if (eq(array[length][0], key)) {
          return length;
        }
      }

      return -1;
    }
    /**
     * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
     * `keysFunc` and `symbolsFunc` to get the enumerable property names and
     * symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @param {Function} symbolsFunc The function to get the symbols of `object`.
     * @returns {Array} Returns the array of property names and symbols.
     */


    function baseGetAllKeys(object, keysFunc, symbolsFunc) {
      var result = keysFunc(object);
      return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
    }
    /**
     * The base implementation of `getTag` without fallbacks for buggy environments.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */


    function baseGetTag(value) {
      if (value == null) {
        return value === undefined ? undefinedTag : nullTag;
      }

      return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    /**
     * The base implementation of `_.isArguments`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     */


    function baseIsArguments(value) {
      return isObjectLike(value) && baseGetTag(value) == argsTag;
    }
    /**
     * The base implementation of `_.isEqual` which supports partial comparisons
     * and tracks traversed objects.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {boolean} bitmask The bitmask flags.
     *  1 - Unordered comparison
     *  2 - Partial comparison
     * @param {Function} [customizer] The function to customize comparisons.
     * @param {Object} [stack] Tracks traversed `value` and `other` objects.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     */


    function baseIsEqual(value, other, bitmask, customizer, stack) {
      if (value === other) {
        return true;
      }

      if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
        return value !== value && other !== other;
      }

      return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
    }
    /**
     * A specialized version of `baseIsEqual` for arrays and objects which performs
     * deep comparisons and tracks traversed objects enabling objects with circular
     * references to be compared.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} [stack] Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
      var objIsArr = isArray(object),
          othIsArr = isArray(other),
          objTag = objIsArr ? arrayTag : getTag(object),
          othTag = othIsArr ? arrayTag : getTag(other);
      objTag = objTag == argsTag ? objectTag : objTag;
      othTag = othTag == argsTag ? objectTag : othTag;
      var objIsObj = objTag == objectTag,
          othIsObj = othTag == objectTag,
          isSameTag = objTag == othTag;

      if (isSameTag && isBuffer(object)) {
        if (!isBuffer(other)) {
          return false;
        }

        objIsArr = true;
        objIsObj = false;
      }

      if (isSameTag && !objIsObj) {
        stack || (stack = new Stack());
        return objIsArr || isTypedArray(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
      }

      if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

        if (objIsWrapped || othIsWrapped) {
          var objUnwrapped = objIsWrapped ? object.value() : object,
              othUnwrapped = othIsWrapped ? other.value() : other;
          stack || (stack = new Stack());
          return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
        }
      }

      if (!isSameTag) {
        return false;
      }

      stack || (stack = new Stack());
      return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
    }
    /**
     * The base implementation of `_.isNative` without bad shim checks.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function,
     *  else `false`.
     */


    function baseIsNative(value) {
      if (!isObject(value) || isMasked(value)) {
        return false;
      }

      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value));
    }
    /**
     * The base implementation of `_.isTypedArray` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     */


    function baseIsTypedArray(value) {
      return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
    }
    /**
     * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */


    function baseKeys(object) {
      if (!isPrototype(object)) {
        return nativeKeys(object);
      }

      var result = [];

      for (var key in Object(object)) {
        if (hasOwnProperty.call(object, key) && key != 'constructor') {
          result.push(key);
        }
      }

      return result;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for arrays with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Array} array The array to compare.
     * @param {Array} other The other array to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `array` and `other` objects.
     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
     */


    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
          arrLength = array.length,
          othLength = other.length;

      if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
        return false;
      } // Assume cyclic values are equal.


      var stacked = stack.get(array);

      if (stacked && stack.get(other)) {
        return stacked == other;
      }

      var index = -1,
          result = true,
          seen = bitmask & COMPARE_UNORDERED_FLAG ? new SetCache() : undefined;
      stack.set(array, other);
      stack.set(other, array); // Ignore non-index properties.

      while (++index < arrLength) {
        var arrValue = array[index],
            othValue = other[index];

        if (customizer) {
          var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
        }

        if (compared !== undefined) {
          if (compared) {
            continue;
          }

          result = false;
          break;
        } // Recursively compare arrays (susceptible to call stack limits).


        if (seen) {
          if (!arraySome(other, function (othValue, othIndex) {
            if (!cacheHas(seen, othIndex) && (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
            result = false;
            break;
          }
        } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
          result = false;
          break;
        }
      }

      stack['delete'](array);
      stack['delete'](other);
      return result;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for comparing objects of
     * the same `toStringTag`.
     *
     * **Note:** This function only supports comparing values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {string} tag The `toStringTag` of the objects to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
      switch (tag) {
        case dataViewTag:
          if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
            return false;
          }

          object = object.buffer;
          other = other.buffer;

        case arrayBufferTag:
          if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
            return false;
          }

          return true;

        case boolTag:
        case dateTag:
        case numberTag:
          // Coerce booleans to `1` or `0` and dates to milliseconds.
          // Invalid dates are coerced to `NaN`.
          return eq(+object, +other);

        case errorTag:
          return object.name == other.name && object.message == other.message;

        case regexpTag:
        case stringTag:
          // Coerce regexes to strings and treat strings, primitives and objects,
          // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
          // for more details.
          return object == other + '';

        case mapTag:
          var convert = mapToArray;

        case setTag:
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
          convert || (convert = setToArray);

          if (object.size != other.size && !isPartial) {
            return false;
          } // Assume cyclic values are equal.


          var stacked = stack.get(object);

          if (stacked) {
            return stacked == other;
          }

          bitmask |= COMPARE_UNORDERED_FLAG; // Recursively compare objects (susceptible to call stack limits).

          stack.set(object, other);
          var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
          stack['delete'](object);
          return result;

        case symbolTag:
          if (symbolValueOf) {
            return symbolValueOf.call(object) == symbolValueOf.call(other);
          }

      }

      return false;
    }
    /**
     * A specialized version of `baseIsEqualDeep` for objects with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */


    function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
          objProps = getAllKeys(object),
          objLength = objProps.length,
          othProps = getAllKeys(other),
          othLength = othProps.length;

      if (objLength != othLength && !isPartial) {
        return false;
      }

      var index = objLength;

      while (index--) {
        var key = objProps[index];

        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
          return false;
        }
      } // Assume cyclic values are equal.


      var stacked = stack.get(object);

      if (stacked && stack.get(other)) {
        return stacked == other;
      }

      var result = true;
      stack.set(object, other);
      stack.set(other, object);
      var skipCtor = isPartial;

      while (++index < objLength) {
        key = objProps[index];
        var objValue = object[key],
            othValue = other[key];

        if (customizer) {
          var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
        } // Recursively compare objects (susceptible to call stack limits).


        if (!(compared === undefined ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
          result = false;
          break;
        }

        skipCtor || (skipCtor = key == 'constructor');
      }

      if (result && !skipCtor) {
        var objCtor = object.constructor,
            othCtor = other.constructor; // Non `Object` object instances with different constructors are not equal.

        if (objCtor != othCtor && 'constructor' in object && 'constructor' in other && !(typeof objCtor == 'function' && objCtor instanceof objCtor && typeof othCtor == 'function' && othCtor instanceof othCtor)) {
          result = false;
        }
      }

      stack['delete'](object);
      stack['delete'](other);
      return result;
    }
    /**
     * Creates an array of own enumerable property names and symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names and symbols.
     */


    function getAllKeys(object) {
      return baseGetAllKeys(object, keys, getSymbols);
    }
    /**
     * Gets the data for `map`.
     *
     * @private
     * @param {Object} map The map to query.
     * @param {string} key The reference key.
     * @returns {*} Returns the map data.
     */


    function getMapData(map, key) {
      var data = map.__data__;
      return isKeyable(key) ? data[typeof key == 'string' ? 'string' : 'hash'] : data.map;
    }
    /**
     * Gets the native function at `key` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the method to get.
     * @returns {*} Returns the function if it's native, else `undefined`.
     */


    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : undefined;
    }
    /**
     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the raw `toStringTag`.
     */


    function getRawTag(value) {
      var isOwn = hasOwnProperty.call(value, symToStringTag),
          tag = value[symToStringTag];

      try {
        value[symToStringTag] = undefined;
        var unmasked = true;
      } catch (e) {}

      var result = nativeObjectToString.call(value);

      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag;
        } else {
          delete value[symToStringTag];
        }
      }

      return result;
    }
    /**
     * Creates an array of the own enumerable symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of symbols.
     */


    var getSymbols = !nativeGetSymbols ? stubArray : function (object) {
      if (object == null) {
        return [];
      }

      object = Object(object);
      return arrayFilter(nativeGetSymbols(object), function (symbol) {
        return propertyIsEnumerable.call(object, symbol);
      });
    };
    /**
     * Gets the `toStringTag` of `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */

    var getTag = baseGetTag; // Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.

    if (DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag || Map && getTag(new Map()) != mapTag || Promise && getTag(Promise.resolve()) != promiseTag || Set && getTag(new Set()) != setTag || WeakMap && getTag(new WeakMap()) != weakMapTag) {
      getTag = function getTag(value) {
        var result = baseGetTag(value),
            Ctor = result == objectTag ? value.constructor : undefined,
            ctorString = Ctor ? toSource(Ctor) : '';

        if (ctorString) {
          switch (ctorString) {
            case dataViewCtorString:
              return dataViewTag;

            case mapCtorString:
              return mapTag;

            case promiseCtorString:
              return promiseTag;

            case setCtorString:
              return setTag;

            case weakMapCtorString:
              return weakMapTag;
          }
        }

        return result;
      };
    }
    /**
     * Checks if `value` is a valid array-like index.
     *
     * @private
     * @param {*} value The value to check.
     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
     */


    function isIndex(value, length) {
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (typeof value == 'number' || reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
    }
    /**
     * Checks if `value` is suitable for use as unique object key.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
     */


    function isKeyable(value) {
      var type = _typeof(value);

      return type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean' ? value !== '__proto__' : value === null;
    }
    /**
     * Checks if `func` has its source masked.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
     */


    function isMasked(func) {
      return !!maskSrcKey && maskSrcKey in func;
    }
    /**
     * Checks if `value` is likely a prototype object.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
     */


    function isPrototype(value) {
      var Ctor = value && value.constructor,
          proto = typeof Ctor == 'function' && Ctor.prototype || objectProto;
      return value === proto;
    }
    /**
     * Converts `value` to a string using `Object.prototype.toString`.
     *
     * @private
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     */


    function objectToString(value) {
      return nativeObjectToString.call(value);
    }
    /**
     * Converts `func` to its source code.
     *
     * @private
     * @param {Function} func The function to convert.
     * @returns {string} Returns the source code.
     */


    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e) {}

        try {
          return func + '';
        } catch (e) {}
      }

      return '';
    }
    /**
     * Performs a
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * comparison between two values to determine if they are equivalent.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.eq(object, object);
     * // => true
     *
     * _.eq(object, other);
     * // => false
     *
     * _.eq('a', 'a');
     * // => true
     *
     * _.eq('a', Object('a'));
     * // => false
     *
     * _.eq(NaN, NaN);
     * // => true
     */


    function eq(value, other) {
      return value === other || value !== value && other !== other;
    }
    /**
     * Checks if `value` is likely an `arguments` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     *  else `false`.
     * @example
     *
     * _.isArguments(function() { return arguments; }());
     * // => true
     *
     * _.isArguments([1, 2, 3]);
     * // => false
     */


    var isArguments = baseIsArguments(function () {
      return arguments;
    }()) ? baseIsArguments : function (value) {
      return isObjectLike(value) && hasOwnProperty.call(value, 'callee') && !propertyIsEnumerable.call(value, 'callee');
    };
    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(document.body.children);
     * // => false
     *
     * _.isArray('abc');
     * // => false
     *
     * _.isArray(_.noop);
     * // => false
     */

    var isArray = Array.isArray;
    /**
     * Checks if `value` is array-like. A value is considered array-like if it's
     * not a function and has a `value.length` that's an integer greater than or
     * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
     * @example
     *
     * _.isArrayLike([1, 2, 3]);
     * // => true
     *
     * _.isArrayLike(document.body.children);
     * // => true
     *
     * _.isArrayLike('abc');
     * // => true
     *
     * _.isArrayLike(_.noop);
     * // => false
     */

    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    /**
     * Checks if `value` is a buffer.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
     * @example
     *
     * _.isBuffer(new Buffer(2));
     * // => true
     *
     * _.isBuffer(new Uint8Array(2));
     * // => false
     */


    var isBuffer = nativeIsBuffer || stubFalse;
    /**
     * Performs a deep comparison between two values to determine if they are
     * equivalent.
     *
     * **Note:** This method supports comparing arrays, array buffers, booleans,
     * date objects, error objects, maps, numbers, `Object` objects, regexes,
     * sets, strings, symbols, and typed arrays. `Object` objects are compared
     * by their own, not inherited, enumerable properties. Functions and DOM
     * nodes are compared by strict equality, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.isEqual(object, other);
     * // => true
     *
     * object === other;
     * // => false
     */

    function isEqual(value, other) {
      return baseIsEqual(value, other);
    }
    /**
     * Checks if `value` is classified as a `Function` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a function, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     *
     * _.isFunction(/abc/);
     * // => false
     */


    function isFunction(value) {
      if (!isObject(value)) {
        return false;
      } // The use of `Object#toString` avoids issues with the `typeof` operator
      // in Safari 9 which returns 'object' for typed arrays and other constructors.


      var tag = baseGetTag(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    /**
     * Checks if `value` is a valid array-like length.
     *
     * **Note:** This method is loosely based on
     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
     * @example
     *
     * _.isLength(3);
     * // => true
     *
     * _.isLength(Number.MIN_VALUE);
     * // => false
     *
     * _.isLength(Infinity);
     * // => false
     *
     * _.isLength('3');
     * // => false
     */


    function isLength(value) {
      return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    /**
     * Checks if `value` is the
     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(_.noop);
     * // => true
     *
     * _.isObject(null);
     * // => false
     */


    function isObject(value) {
      var type = _typeof(value);

      return value != null && (type == 'object' || type == 'function');
    }
    /**
     * Checks if `value` is object-like. A value is object-like if it's not `null`
     * and has a `typeof` result of "object".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
     * @example
     *
     * _.isObjectLike({});
     * // => true
     *
     * _.isObjectLike([1, 2, 3]);
     * // => true
     *
     * _.isObjectLike(_.noop);
     * // => false
     *
     * _.isObjectLike(null);
     * // => false
     */


    function isObjectLike(value) {
      return value != null && _typeof(value) == 'object';
    }
    /**
     * Checks if `value` is classified as a typed array.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     * @example
     *
     * _.isTypedArray(new Uint8Array);
     * // => true
     *
     * _.isTypedArray([]);
     * // => false
     */


    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
    /**
     * Creates an array of the own enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects. See the
     * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
     * for more details.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keys(new Foo);
     * // => ['a', 'b'] (iteration order is not guaranteed)
     *
     * _.keys('hi');
     * // => ['0', '1']
     */

    function keys(object) {
      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
    }
    /**
     * This method returns a new empty array.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {Array} Returns the new empty array.
     * @example
     *
     * var arrays = _.times(2, _.stubArray);
     *
     * console.log(arrays);
     * // => [[], []]
     *
     * console.log(arrays[0] === arrays[1]);
     * // => false
     */


    function stubArray() {
      return [];
    }
    /**
     * This method returns `false`.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {boolean} Returns `false`.
     * @example
     *
     * _.times(2, _.stubFalse);
     * // => [false, false]
     */


    function stubFalse() {
      return false;
    }

    module.exports = isEqual;
  });

  /**
   * We currently support the following sorting states for DataTable headers,
   * namely: `NONE` for no sorting being applied, and then `DESC` and `ASC` for
   * the corresponding direction of the sorting order.
   */
  var sortStates = {
    NONE: 'NONE',
    DESC: 'DESC',
    ASC: 'ASC'
  };

  /**
   * Generic helper used to consolidate all call sites for getting a cell id into
   * one method. The strategy currently is that a "cellId" is just the combination
   * of the row id and the header key used to access this field in a row.
   *
   * @param {string} rowId
   * @param {string} header
   * @returns {string}
   */
  var getCellId = function getCellId(rowId, header) {
    return "".concat(rowId, ":").concat(header);
  };

  /**
   * Compare two primitives to determine which comes first. Initially, this method
   * will try and figure out if both entries are the same type. If so, it will
   * apply the default sort algorithm for those types. Otherwise, it defaults to a
   * string conversion.
   *
   * @param {number|string} a
   * @param {number|string} b
   * @param {string} locale
   * @returns {number}
   */

  var compare = function compare(a, b) {
    var locale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'en';

    if (typeof a === 'number' && typeof b === 'number') {
      return a - b;
    }

    if (typeof a === 'string' && typeof b === 'string') {
      return compareStrings(a, b, locale);
    }

    return compareStrings('' + a, '' + b, locale);
  };
  /**
   * Use the built-in `localeCompare` function available on strings to compare two
   * strings.
   *
   * @param {string} a
   * @param {string} b
   * @param {string} locale
   * @returns {number}
   */

  var compareStrings = function compareStrings(a, b) {
    var locale = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'en';

    // Only set `numeric: true` if the string only contains numbers
    // https://stackoverflow.com/a/175787
    if (!isNaN(a) && !isNaN(parseFloat(a))) {
      return a.localeCompare(b, locale, {
        numeric: true
      });
    }

    return a.localeCompare(b, locale);
  };
  /**
   * Default implementation of how we sort rows internally. The idea behind this
   * implementation is to use the given list of row ids to look up the cells in
   * the row by the given key. We then use the value of these cells and pipe them
   * into our local `compareStrings` method, including the locale where
   * appropriate.
   *
   * @param {object} config
   * @param {Array[string]} config.rowIds array of all the row ids in the table
   * @param {object} config.cellsById object containing a mapping of cell id to
   * cell
   * @param {string} config.key the header key that we use to lookup the cell
   * @param {string} [config.locale] optional locale used in the comparison
   * function
   * @param {string} config.sortDirection the sort direction used to determine the
   * order the comparison is called in
   * @param {Function} config.sortRow
   * @returns {Array[string]} array of sorted rowIds
   */

  var sortRows = function sortRows(_ref) {
    var rowIds = _ref.rowIds,
        cellsById = _ref.cellsById,
        sortDirection = _ref.sortDirection,
        key = _ref.key,
        locale = _ref.locale,
        sortRow = _ref.sortRow;
    return rowIds.slice().sort(function (a, b) {
      var cellA = cellsById[getCellId(a, key)];
      var cellB = cellsById[getCellId(b, key)];
      return sortRow(cellA.value, cellB.value, {
        key: key,
        sortDirection: sortDirection,
        locale: locale,
        sortStates: sortStates,
        compare: compare
      });
    });
  };
  var defaultSortRow = function defaultSortRow(cellA, cellB, _ref2) {
    var sortDirection = _ref2.sortDirection,
        sortStates = _ref2.sortStates,
        locale = _ref2.locale;

    if (sortDirection === sortStates.ASC) {
      return compare(cellA, cellB, locale);
    }

    return compare(cellB, cellA, locale);
  };

  // different initialSortState

  var initialSortState = sortStates.NONE;
  /**
   * Utility used to get the next sort state given the following pieces of
   * information:
   *
   * @param {string} prevHeader the value of the previous header
   * @param {string} header the value of the currently selected header
   * @param {string} prevState the previous sort state of the table
   * @returns {string}
   */

  var getNextSortDirection = function getNextSortDirection(prevHeader, header, prevState) {
    // If the previous header is equivalent to the current header, we know that we
    // have to derive the next sort state from the previous sort state
    if (prevHeader === header) {
      // When transitioning, we know that the sequence of states is as follows:
      // NONE -> ASC -> DESC -> NONE
      if (prevState === 'NONE') {
        return sortStates.ASC;
      }

      if (prevState === 'ASC') {
        return sortStates.DESC;
      }

      return sortStates.NONE;
    } // Otherwise, we have selected a new header and need to start off by sorting
    // in descending order by default


    return sortStates.ASC;
  };
  var getNextSortState = function getNextSortState(props, state, _ref) {
    var key = _ref.key;
    var sortDirection = state.sortDirection,
        sortHeaderKey = state.sortHeaderKey;
    var nextSortDirection = getNextSortDirection(key, sortHeaderKey, sortDirection);
    return getSortedState(props, state, key, nextSortDirection);
  };
  /**
   * Derive the set of sorted state fields from props and state for the given
   * header key and sortDirection
   *
   * @param {object} props
   * @param {string} props.locale The current locale
   * @param {Function} props.sortRows Method to handle sorting a collection of
   * rows
   * @param {object} state
   * @param {Array<string>} state.rowIds Array of row ids
   * @param {object} state.cellsById Lookup object for cells by id
   * @param {Array<string>} state.initialRowOrder Initial row order for the
   * current set of rows
   * @param {string} key The key for the given header we are derving the
   * sorted state for
   * @param {string} sortDirection The sortState that we want to order by
   * @returns {object}
   */

  var getSortedState = function getSortedState(props, state, key, sortDirection) {
    var rowIds = state.rowIds,
        cellsById = state.cellsById,
        initialRowOrder = state.initialRowOrder;
    var locale = props.locale,
        sortRow = props.sortRow;
    var nextRowIds = sortDirection !== sortStates.NONE ? sortRows({
      rowIds: rowIds,
      cellsById: cellsById,
      sortDirection: sortDirection,
      key: key,
      locale: locale,
      sortRow: sortRow
    }) : initialRowOrder;
    return {
      sortHeaderKey: key,
      sortDirection: sortDirection,
      rowIds: nextRowIds
    };
  };

  /**
   * Normalize a collection of rows with the given headers.
   *
   * @param {Array<object>} rows
   * @param {Array<object>} headers
   * @returns {object}
   */

  var normalize = function normalize(rows, headers) {
    var prevState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var prevRowsByIds = prevState.rowsById;
    var rowIds = new Array(rows.length);
    var rowsById = {};
    var cellsById = {};
    rows.forEach(function (row, i) {
      rowIds[i] = row.id; // Initialize the row info and state values, namely for selection and
      // expansion

      var id = row.id,
          _row$isSelected = row.isSelected,
          isSelected = _row$isSelected === void 0 ? false : _row$isSelected,
          _row$isExpanded = row.isExpanded,
          isExpanded = _row$isExpanded === void 0 ? false : _row$isExpanded,
          _row$disabled = row.disabled,
          disabled = _row$disabled === void 0 ? false : _row$disabled;
      rowsById[id] = {
        id: id,
        isSelected: isSelected,
        isExpanded: isExpanded,
        disabled: disabled,
        cells: new Array(headers.length)
      }; // If we have a previous state, and the row existed in that previous state,
      // then we'll set the state values of the row to the previous state values.

      if (prevRowsByIds && prevRowsByIds[row.id] !== undefined) {
        rowsById[row.id].isSelected = prevRowsByIds[row.id].isSelected;
        rowsById[row.id].isExpanded = prevRowsByIds[row.id].isExpanded;
      }

      headers.forEach(function (_ref, i) {
        var key = _ref.key;
        var id = getCellId(row.id, key); // Initialize the cell info and state values, namely for editing

        cellsById[id] = {
          id: id,
          value: row[key],
          isEditable: false,
          isEditing: false,
          isValid: true,
          errors: null,
          info: {
            header: key
          }
        }; // TODO: When working on inline edits, we'll need to derive the state
        // values similarly to rows above.

        rowsById[row.id].cells[i] = id;
      });
    });
    return {
      rowIds: rowIds,
      rowsById: rowsById,
      cellsById: cellsById
    };
  };

  /**
   * Helper to derive the next state from the given props and the
   * prevState. Potential future-facing API hook for React v17.
   *
   * Currently, it's being used as a way to normalize the incoming data that we
   * are receiving for rows
   */

  var getDerivedStateFromProps = function getDerivedStateFromProps(props, prevState) {
    var _normalize = normalize(props.rows, props.headers, prevState),
        rowIds = _normalize.rowIds,
        rowsById = _normalize.rowsById,
        cellsById = _normalize.cellsById;

    var state = {
      rowIds: rowIds,
      rowsById: rowsById,
      cellsById: cellsById,
      sortDirection: prevState.sortDirection || initialSortState,
      sortHeaderKey: prevState.sortHeaderKey || null,
      // Copy over rowIds so the reference doesn't mutate the stored
      // `initialRowOrder`
      initialRowOrder: rowIds.slice(),
      filterInputValue: prevState.filterInputValue || null,
      // Optional state field to indicate whether a consumer should show a
      // batch actions menu
      shouldShowBatchActions: prevState.shouldShowBatchActions || false
    };

    if (prevState.sortDirection && prevState.sortHeaderKey) {
      var _getSortedState = getSortedState(props, state, prevState.sortHeaderKey, prevState.sortDirection),
          _rowIds = _getSortedState.rowIds;

      state.rowIds = _rowIds;
    }

    return state;
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * Counterpart to `normalize` for a collection of rows. This method unravels the
   * normalization step that we use to build the given parameters in order to
   * return a natural interface to working with rows for a consumer.
   *
   * The default heuristic here is to map through all the row ids and return the
   * value of the row for the given id, in addition to adding a `cells` key that
   * contains the results of mapping over the rows cells and getting individual
   * cell info.
   *
   * @param {Array<string>} rowIds array of row ids in the table
   * @param {object} rowsById object containing lookups for rows by id
   * @param {object} cellsById object containing lookups for cells by id
   */
  var denormalize = function denormalize(rowIds, rowsById, cellsById) {
    return rowIds.map(function (id) {
      return _objectSpread2$2(_objectSpread2$2({}, rowsById[id]), {}, {
        cells: rowsById[id].cells.map(function (cellId) {
          return cellsById[cellId];
        })
      });
    });
  };

  /**
   * Default implemention of how we filter rows internally. The idea behind this
   * implementation is to use the given list of row ids and headers to get the
   * individual cell values for a row. Then, we go through each cell value and see
   * if any of them includes the given inputValue.
   *
   * @param {object} config
   * @param {Array<string>} config.rowIds array of all the row ids in the table
   * @param {Array<object>} config.headers
   * @param {object} config.cellsById object containing a map of cell id to cell
   * @param {string} config.inputValue the current input value in the Table Search
   * @param {Function} config.getCellId
   * @returns {Array<string>} rowIds
   */
  var defaultFilterRows = function defaultFilterRows(_ref) {
    var rowIds = _ref.rowIds,
        headers = _ref.headers,
        cellsById = _ref.cellsById,
        inputValue = _ref.inputValue,
        getCellId = _ref.getCellId;
    return rowIds.filter(function (rowId) {
      return headers.some(function (_ref2) {
        var key = _ref2.key;
        var id = getCellId(rowId, key);

        if (typeof cellsById[id].value === 'boolean') {
          return false;
        }

        return ('' + cellsById[id].value).toLowerCase().includes(inputValue.toLowerCase());
      });
    });
  };

  /**
   * Generic utility to initialize a method that will return a unique instance id
   * for a component.
   */
  var setupGetInstanceId = function setupGetInstanceId() {
    var instanceId = 0;
    return function getInstanceId() {
      return ++instanceId;
    };
  };

  var _defaultTranslations$1;
  var getInstanceId$b = setupGetInstanceId();
  var translationKeys$3 = {
    expandRow: 'carbon.table.row.expand',
    collapseRow: 'carbon.table.row.collapse',
    expandAll: 'carbon.table.all.expand',
    collapseAll: 'carbon.table.all.collapse',
    selectAll: 'carbon.table.all.select',
    unselectAll: 'carbon.table.all.unselect',
    selectRow: 'carbon.table.row.select',
    unselectRow: 'carbon.table.row.unselect'
  };
  var defaultTranslations$2 = (_defaultTranslations$1 = {}, _defineProperty$2(_defaultTranslations$1, translationKeys$3.expandAll, 'Expand all rows'), _defineProperty$2(_defaultTranslations$1, translationKeys$3.collapseAll, 'Collapse all rows'), _defineProperty$2(_defaultTranslations$1, translationKeys$3.expandRow, 'Expand current row'), _defineProperty$2(_defaultTranslations$1, translationKeys$3.collapseRow, 'Collapse current row'), _defineProperty$2(_defaultTranslations$1, translationKeys$3.selectAll, 'Select all rows'), _defineProperty$2(_defaultTranslations$1, translationKeys$3.unselectAll, 'Unselect all rows'), _defineProperty$2(_defaultTranslations$1, translationKeys$3.selectRow, 'Select row'), _defineProperty$2(_defaultTranslations$1, translationKeys$3.unselectRow, 'Unselect row'), _defaultTranslations$1);

  var translateWithId$5 = function translateWithId(id) {
    return defaultTranslations$2[id];
  };
  /**
   * Data Tables are used to represent a collection of resources, displaying a
   * subset of their fields in columns, or headers. We prioritize direct updates
   * to the state of what we're rendering, so internally we end up normalizing the
   * given data and then denormalizing it when rendering.
   *
   * As a result, each part of the DataTable is accessible through look-up by id,
   * and updating the state of the single entity will cascade updates to the
   * consumer.
   */


  var DataTable = /*#__PURE__*/function (_React$Component) {
    _inherits(DataTable, _React$Component);

    var _super = _createSuper(DataTable);

    function DataTable(_props) {
      var _this;

      _classCallCheck(this, DataTable);

      _this = _super.call(this, _props);

      _defineProperty$2(_assertThisInitialized$1(_this), "getHeaderProps", function (_ref) {
        var header = _ref.header,
            _onClick = _ref.onClick,
            _ref$isSortable = _ref.isSortable,
            isSortable = _ref$isSortable === void 0 ? _this.props.isSortable : _ref$isSortable,
            rest = _objectWithoutProperties$2(_ref, ["header", "onClick", "isSortable"]);

        var _this$state = _this.state,
            sortDirection = _this$state.sortDirection,
            sortHeaderKey = _this$state.sortHeaderKey;
        return _objectSpread2$2(_objectSpread2$2({}, rest), {}, {
          key: header.key,
          sortDirection: sortDirection,
          isSortable: isSortable,
          isSortHeader: sortHeaderKey === header.key,
          onClick: function onClick(event) {
            var nextSortState = getNextSortState(_this.props, _this.state, {
              key: header.key
            });

            _this.setState(nextSortState, function () {
              _onClick && _this.handleOnHeaderClick(_onClick, {
                sortHeaderKey: header.key,
                sortDirection: nextSortState.sortDirection
              })(event);
            });
          }
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getExpandHeaderProps", function () {
        var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            onClick = _ref2.onClick,
            rest = _objectWithoutProperties$2(_ref2, ["onClick"]);

        var t = _this.props.translateWithId;
        var _this$state2 = _this.state,
            isExpandedAll = _this$state2.isExpandedAll,
            rowIds = _this$state2.rowIds,
            rowsById = _this$state2.rowsById;
        var isExpanded = isExpandedAll || rowIds.every(function (id) {
          return rowsById[id].isExpanded;
        });
        var translationKey = !isExpanded ? translationKeys$3.collapseAll : translationKeys$3.expandAll;
        return _objectSpread2$2(_objectSpread2$2({}, rest), {}, {
          ariaLabel: t(translationKey),
          isExpanded: isExpanded,
          // Compose the event handlers so we don't overwrite a consumer's `onClick`
          // handler
          onExpand: composeEventHandlers([_this.handleOnExpandAll, onClick ? _this.handleOnExpandHeaderClick(onClick, {
            isExpanded: isExpanded
          }) : null])
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOnHeaderClick", function (onClick, sortParams) {
        return function (e) {
          return onClick(e, sortParams);
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOnExpandHeaderClick", function (onClick, expandParams) {
        return function (e) {
          return onClick(e, expandParams);
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getRowProps", function (_ref3) {
        var row = _ref3.row,
            onClick = _ref3.onClick,
            rest = _objectWithoutProperties$2(_ref3, ["row", "onClick"]);

        var t = _this.props.translateWithId;
        var translationKey = row.isExpanded ? translationKeys$3.collapseRow : translationKeys$3.expandRow;
        return _objectSpread2$2(_objectSpread2$2({}, rest), {}, {
          key: row.id,
          // Compose the event handlers so we don't overwrite a consumer's `onClick`
          // handler
          onExpand: composeEventHandlers([_this.handleOnExpandRow(row.id), onClick]),
          isExpanded: row.isExpanded,
          ariaLabel: t(translationKey),
          isSelected: row.isSelected,
          disabled: row.disabled
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getSelectionProps", function () {
        var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            onClick = _ref4.onClick,
            row = _ref4.row,
            rest = _objectWithoutProperties$2(_ref4, ["onClick", "row"]);

        var t = _this.props.translateWithId; // If we're given a row, return the selection state values for that row

        if (row) {
          var _translationKey = row.isSelected ? translationKeys$3.unselectRow : translationKeys$3.selectRow;

          return _objectSpread2$2(_objectSpread2$2({}, rest), {}, {
            checked: row.isSelected,
            onSelect: composeEventHandlers([_this.handleOnSelectRow(row.id), onClick]),
            id: "".concat(_this.getTablePrefix(), "__select-row-").concat(row.id),
            name: "select-row-".concat(row.id),
            ariaLabel: t(_translationKey),
            disabled: row.disabled,
            radio: _this.props.radio || null
          });
        } // Otherwise, we're working on `TableSelectAll` which handles toggling the
        // selection state of all rows.


        var rowCount = _this.state.rowIds.length;

        var selectedRowCount = _this.getSelectedRows().length;

        var checked = rowCount > 0 && selectedRowCount === rowCount;
        var indeterminate = rowCount > 0 && selectedRowCount > 0 && selectedRowCount !== rowCount;
        var translationKey = checked || indeterminate ? translationKeys$3.unselectAll : translationKeys$3.selectAll;
        return _objectSpread2$2(_objectSpread2$2({}, rest), {}, {
          ariaLabel: t(translationKey),
          checked: checked,
          id: "".concat(_this.getTablePrefix(), "__select-all"),
          indeterminate: indeterminate,
          name: 'select-all',
          onSelect: composeEventHandlers([_this.handleSelectAll, onClick])
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getToolbarProps", function () {
        var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var size = _this.props.size; // Remove compact, short in V11

        var isSmall = size === 'compact' || size === 'short' || size === 'xs' || size === 'sm';
        return _objectSpread2$2(_objectSpread2$2({}, props), {}, {
          size: isSmall ? 'small' : 'normal'
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getBatchActionProps", function () {
        var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var shouldShowBatchActions = _this.state.shouldShowBatchActions;

        var totalSelected = _this.getSelectedRows().length;

        return _objectSpread2$2(_objectSpread2$2({}, props), {}, {
          shouldShowBatchActions: shouldShowBatchActions,
          totalSelected: totalSelected,
          onCancel: _this.handleOnCancel
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getTableProps", function () {
        var _this$props = _this.props,
            useZebraStyles = _this$props.useZebraStyles,
            size = _this$props.size,
            isSortable = _this$props.isSortable,
            useStaticWidth = _this$props.useStaticWidth,
            shouldShowBorder = _this$props.shouldShowBorder,
            stickyHeader = _this$props.stickyHeader,
            overflowMenuOnHover = _this$props.overflowMenuOnHover;
        return {
          useZebraStyles: useZebraStyles,
          size: size,
          isSortable: isSortable,
          useStaticWidth: useStaticWidth,
          shouldShowBorder: shouldShowBorder,
          stickyHeader: stickyHeader,
          overflowMenuOnHover: overflowMenuOnHover
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getTableContainerProps", function () {
        var stickyHeader = _this.props.stickyHeader;
        return {
          stickyHeader: stickyHeader
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getSelectedRows", function () {
        return _this.state.rowIds.filter(function (id) {
          var row = _this.state.rowsById[id];
          return row.isSelected && !row.disabled;
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getFilteredRowIds", function () {
        var filteredRowIds = typeof _this.state.filterInputValue === 'string' ? _this.props.filterRows({
          rowIds: _this.state.rowIds,
          headers: _this.props.headers,
          cellsById: _this.state.cellsById,
          inputValue: _this.state.filterInputValue,
          getCellId: getCellId
        }) : _this.state.rowIds;

        if (filteredRowIds.length == 0) {
          return [];
        }

        return filteredRowIds;
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "getTablePrefix", function () {
        return "data-table-".concat(_this.instanceId);
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "setAllSelectedState", function (initialState, isSelected, filteredRowIds) {
        var rowIds = initialState.rowIds;
        return {
          rowsById: rowIds.reduce(function (acc, id) {
            return _objectSpread2$2(_objectSpread2$2({}, acc), {}, _defineProperty$2({}, id, _objectSpread2$2(_objectSpread2$2({}, initialState.rowsById[id]), !initialState.rowsById[id].disabled && {
              isSelected: filteredRowIds.includes(id) && isSelected
            })));
          }, {})
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOnCancel", function () {
        _this.setState(function (state) {
          return _objectSpread2$2({
            shouldShowBatchActions: false
          }, _this.setAllSelectedState(state, false, _this.getFilteredRowIds()));
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleSelectAll", function () {
        _this.setState(function (state) {
          var filteredRowIds = _this.getFilteredRowIds();

          var rowsById = state.rowsById;
          var isSelected = !(Object.values(rowsById).filter(function (row) {
            return row.isSelected && !row.disabled;
          }).length > 0);
          return _objectSpread2$2({
            shouldShowBatchActions: isSelected
          }, _this.setAllSelectedState(state, isSelected, filteredRowIds));
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOnSelectRow", function (rowId) {
        return function () {
          _this.setState(function (state) {
            var row = state.rowsById[rowId];

            if (_this.props.radio) {
              // deselect all radio buttons
              var rowsById = Object.entries(state.rowsById).reduce(function (p, c) {
                var _c = _slicedToArray(c, 2),
                    key = _c[0],
                    val = _c[1];

                val.isSelected = false;
                p[key] = val;
                return p;
              }, {});
              return {
                shouldShowBatchActions: false,
                rowsById: _objectSpread2$2(_objectSpread2$2({}, rowsById), {}, _defineProperty$2({}, rowId, _objectSpread2$2(_objectSpread2$2({}, row), {}, {
                  isSelected: !row.isSelected
                })))
              };
            }

            var selectedRows = state.rowIds.filter(function (id) {
              return state.rowsById[id].isSelected;
            }).length; // Predict the length of the selected rows after this change occurs

            var selectedRowsCount = !row.isSelected ? selectedRows + 1 : selectedRows - 1;
            return {
              // Basic assumption here is that we want to show the batch action bar if
              // the row is being selected. If it's being unselected, then see if we
              // have a non-zero number of selected rows that batch actions could
              // still apply to
              shouldShowBatchActions: !row.isSelected || selectedRowsCount > 0,
              rowsById: _objectSpread2$2(_objectSpread2$2({}, state.rowsById), {}, _defineProperty$2({}, rowId, _objectSpread2$2(_objectSpread2$2({}, row), {}, {
                isSelected: !row.isSelected
              })))
            };
          });
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOnExpandRow", function (rowId) {
        return function () {
          _this.setState(function (state) {
            var row = state.rowsById[rowId];
            var isExpandedAll = state.isExpandedAll;
            return {
              isExpandedAll: row.isExpanded ? false : isExpandedAll,
              rowsById: _objectSpread2$2(_objectSpread2$2({}, state.rowsById), {}, _defineProperty$2({}, rowId, _objectSpread2$2(_objectSpread2$2({}, row), {}, {
                isExpanded: !row.isExpanded
              })))
            };
          });
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOnExpandAll", function () {
        _this.setState(function (state) {
          var rowIds = state.rowIds,
              isExpandedAll = state.isExpandedAll;
          return {
            isExpandedAll: !isExpandedAll,
            rowsById: rowIds.reduce(function (acc, id) {
              return _objectSpread2$2(_objectSpread2$2({}, acc), {}, _defineProperty$2({}, id, _objectSpread2$2(_objectSpread2$2({}, state.rowsById[id]), {}, {
                isExpanded: !isExpandedAll
              })));
            }, {})
          };
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleSortBy", function (headerKey) {
        return function () {
          _this.setState(function (state) {
            return getNextSortState(_this.props, state, {
              key: headerKey
            });
          });
        };
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOnInputValueChange", function (event, defaultValue) {
        if (event.target) {
          _this.setState({
            filterInputValue: event.target.value
          });
        }

        if (defaultValue) {
          _this.setState({
            filterInputValue: defaultValue
          });
        }
      });

      _this.state = _objectSpread2$2(_objectSpread2$2({}, getDerivedStateFromProps(_props, {})), {}, {
        isExpandedAll: false // Start with collapsed state, treat `undefined` as neutral state

      });
      _this.instanceId = getInstanceId$b();
      return _this;
    }

    _createClass(DataTable, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        var _this2 = this;

        if (prevProps === this.props) {
          return;
        }

        var prevRowIds = prevProps.rows.map(function (row) {
          return row.id;
        });
        var rowIds = this.props.rows.map(function (row) {
          return row.id;
        });

        if (!lodash_isequal(prevRowIds, rowIds)) {
          this.setState(function (state) {
            return getDerivedStateFromProps(_this2.props, state);
          });
          return;
        }

        var prevHeaders = prevProps.headers.map(function (header) {
          return header.key;
        });
        var headers = this.props.headers.map(function (header) {
          return header.key;
        });

        if (!lodash_isequal(prevHeaders, headers)) {
          this.setState(function (state) {
            return getDerivedStateFromProps(_this2.props, state);
          });
          return;
        }

        if (!lodash_isequal(prevProps.rows, this.props.rows)) {
          this.setState(function (state) {
            return getDerivedStateFromProps(_this2.props, state);
          });
          return;
        }
      }
      /**
       * Get the props associated with the given header. Mostly used for adding in
       * sorting behavior.
       *
       * @param {object} config
       * @param {string} config.header the header we want the props for
       * @param {Function} config.onClick a custom click handler for the header
       * @param {boolean} config.isSortable
       * @returns {object}
       */

    }, {
      key: "render",
      value: function render() {
        var _this3 = this;

        // eslint-disable-next-line react/prop-types
        var _this$props2 = this.props,
            children = _this$props2.children,
            filterRows = _this$props2.filterRows,
            headers = _this$props2.headers,
            render = _this$props2.render;
        var _this$state3 = this.state,
            filterInputValue = _this$state3.filterInputValue,
            rowIds = _this$state3.rowIds,
            rowsById = _this$state3.rowsById,
            cellsById = _this$state3.cellsById;
        var filteredRowIds = typeof filterInputValue === 'string' ? filterRows({
          rowIds: rowIds,
          headers: headers,
          cellsById: cellsById,
          inputValue: filterInputValue,
          getCellId: getCellId
        }) : rowIds;
        var renderProps = {
          // Data derived from state
          rows: denormalize(filteredRowIds, rowsById, cellsById),
          headers: this.props.headers,
          selectedRows: denormalize(this.getSelectedRows(), rowsById, cellsById),
          // Prop accessors/getters
          getHeaderProps: this.getHeaderProps,
          getExpandHeaderProps: this.getExpandHeaderProps,
          getRowProps: this.getRowProps,
          getSelectionProps: this.getSelectionProps,
          getToolbarProps: this.getToolbarProps,
          getBatchActionProps: this.getBatchActionProps,
          getTableProps: this.getTableProps,
          getTableContainerProps: this.getTableContainerProps,
          // Custom event handlers
          onInputChange: this.handleOnInputValueChange,
          // Expose internal state change actions
          sortBy: function sortBy(headerKey) {
            return _this3.handleSortBy(headerKey)();
          },
          selectAll: this.handleSelectAll,
          selectRow: function selectRow(rowId) {
            return _this3.handleOnSelectRow(rowId)();
          },
          expandRow: function expandRow(rowId) {
            return _this3.handleOnExpandRow(rowId)();
          },
          expandAll: this.handleOnExpandAll,
          radio: this.props.radio
        };

        if (render !== undefined) {
          return render(renderProps);
        }

        if (children !== undefined) {
          return children(renderProps);
        }

        return null;
      }
    }]);

    return DataTable;
  }(React__default['default'].Component);

  _defineProperty$2(DataTable, "propTypes", {
    /**
     * Optional hook to manually control filtering of the rows from the
     * TableToolbarSearch component
     */
    filterRows: PropTypes__default['default'].func,

    /**
     * The `headers` prop represents the order in which the headers should
     * appear in the table. We expect an array of objects to be passed in, where
     * `key` is the name of the key in a row object, and `header` is the name of
     * the header.
     */
    headers: PropTypes__default['default'].arrayOf(PropTypes__default['default'].shape({
      key: PropTypes__default['default'].string.isRequired,
      header: PropTypes__default['default'].node.isRequired
    })).isRequired,

    /**
     * Specify whether the table should be able to be sorted by its headers
     */
    isSortable: PropTypes__default['default'].bool,

    /**
     * Provide a string for the current locale
     */
    locale: PropTypes__default['default'].string,

    /**
     * Specify whether the overflow menu (if it exists) should be shown always, or only on hover
     */
    overflowMenuOnHover: PropTypes__default['default'].bool,

    /**
     * Specify whether the control should be a radio button or inline checkbox
     */
    radio: PropTypes__default['default'].bool,

    /**
     * The `rows` prop is where you provide us with a list of all the rows that
     * you want to render in the table. The only hard requirement is that this
     * is an array of objects, and that each object has a unique `id` field
     * available on it.
     */
    rows: PropTypes__default['default'].arrayOf(PropTypes__default['default'].shape({
      id: PropTypes__default['default'].string.isRequired,
      disabled: PropTypes__default['default'].bool,
      isSelected: PropTypes__default['default'].bool,
      isExpanded: PropTypes__default['default'].bool
    })).isRequired,

    /**
     * `false` If true, will remove the table border
     */
    shouldShowBorder: PropTypes__default['default'].bool,

    /**
     *  Change the row height of table. Currently supports `xs`, `sm`, `md`, `lg`, and `xl`.
     *  The previous terms (`compact`, `short`, `normal`, and `tall`) will be removed in the next major release.
     */
    size: PropTypes__default['default'].oneOf(['compact', 'short', 'normal', 'tall', 'xs', 'sm', 'md', 'lg', 'xl']),

    /**
     * Optional hook to manually control sorting of the rows.
     */
    sortRow: PropTypes__default['default'].func,

    /**
     * Specify whether the header should be sticky.
     * Still experimental: may not work with every combination of table props
     */
    stickyHeader: PropTypes__default['default'].bool,

    /**
     * Optional method that takes in a message id and returns an
     * internationalized string. See `DataTable.translationKeys` for all
     * available message ids.
     */
    translateWithId: PropTypes__default['default'].func,

    /**
     * `false` If true, will use a width of 'auto' instead of 100%
     */
    useStaticWidth: PropTypes__default['default'].bool,

    /**
     * `true` to add useZebraStyles striping.
     */
    useZebraStyles: PropTypes__default['default'].bool
  });

  _defineProperty$2(DataTable, "defaultProps", {
    sortRow: defaultSortRow,
    filterRows: defaultFilterRows,
    locale: 'en',
    size: 'normal',
    overflowMenuOnHover: true,
    translateWithId: translateWithId$5
  });

  _defineProperty$2(DataTable, "translationKeys", Object.values(translationKeys$3));

  var prefix$2c = settings_1.prefix;
  var Table = function Table(_ref) {
    var _cx;

    var className = _ref.className,
        children = _ref.children,
        useZebraStyles = _ref.useZebraStyles,
        size = _ref.size,
        isSortable = _ref.isSortable,
        useStaticWidth = _ref.useStaticWidth,
        shouldShowBorder = _ref.shouldShowBorder,
        stickyHeader = _ref.stickyHeader,
        overflowMenuOnHover = _ref.overflowMenuOnHover,
        other = _objectWithoutProperties$2(_ref, ["className", "children", "useZebraStyles", "size", "isSortable", "useStaticWidth", "shouldShowBorder", "stickyHeader", "overflowMenuOnHover"]);

    var componentClass = classnames("".concat(prefix$2c, "--data-table"), className, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2c, "--data-table--").concat(size), size), _defineProperty$2(_cx, "".concat(prefix$2c, "--data-table--sort"), isSortable), _defineProperty$2(_cx, "".concat(prefix$2c, "--data-table--zebra"), useZebraStyles), _defineProperty$2(_cx, "".concat(prefix$2c, "--data-table--static"), useStaticWidth), _defineProperty$2(_cx, "".concat(prefix$2c, "--data-table--no-border"), !shouldShowBorder), _defineProperty$2(_cx, "".concat(prefix$2c, "--data-table--sticky-header"), stickyHeader), _defineProperty$2(_cx, "".concat(prefix$2c, "--data-table--visible-overflow-menu"), !overflowMenuOnHover), _cx));
    var table = /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2c, "--data-table-content")
    }, /*#__PURE__*/React__default['default'].createElement("table", _extends$3({}, other, {
      className: componentClass
    }), children));
    return stickyHeader ? /*#__PURE__*/React__default['default'].createElement("section", {
      className: "".concat(prefix$2c, "--data-table_inner-container")
    }, table) : table;
  };
  Table.propTypes = {
    /**
     * Pass in the children that will be rendered within the Table
     */
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string,

    /**
     * `false` If true, will apply sorting styles
     */
    isSortable: PropTypes__default['default'].bool,

    /**
     * Specify whether the overflow menu (if it exists) should be shown always, or only on hover
     */
    overflowMenuOnHover: PropTypes__default['default'].bool,

    /**
     * `false` If true, will remove the table border
     */
    shouldShowBorder: PropTypes__default['default'].bool,

    /**
     *  Change the row height of table. Currently supports `xs`, `sm`, `md`, `lg`, and `xl`.
     *  The previous terms (`compact`, `short`, `normal`, and `tall`) will be removed in the next major release.
     */
    size: PropTypes__default['default'].oneOf(['compact', 'short', 'normal', 'tall', 'xs', 'sm', 'md', 'lg', 'xl']),

    /**
     * `false` If true, will keep the header sticky (only data rows will scroll)
     */
    stickyHeader: PropTypes__default['default'].bool,

    /**
     * `false` If true, will use a width of 'auto' instead of 100%
     */
    useStaticWidth: PropTypes__default['default'].bool,

    /**
     * `true` to add useZebraStyles striping.
     */
    useZebraStyles: PropTypes__default['default'].bool
  };
  Table.defaultProps = {
    isSortable: false,
    overflowMenuOnHover: true
  };

  var wrapComponent = function wrapComponent(_ref) {
    var name = _ref.name,
        className = _ref.className,
        type = _ref.type;

    var Component = function Component(_ref2) {
      var baseClassName = _ref2.className,
          other = _objectWithoutProperties$2(_ref2, ["className"]);

      var componentClass = classnames(className, baseClassName);
      return /*#__PURE__*/React__default['default'].createElement(type, _objectSpread2$2(_objectSpread2$2({}, other), {}, {
        // Prevent Weird quirk where `cx` will evaluate to an empty string, '',
        // and so we have empty `class` attributes in the resulting markup
        // eslint-disable-next-line no-extra-boolean-cast
        className: !!componentClass ? componentClass : undefined
      }));
    };

    Component.displayName = name;
    Component.propTypes = {
      className: PropTypes__default['default'].string
    };
    return Component;
  };

  var prefix$2b = settings_1.prefix;
  var TableActionList = wrapComponent({
    name: 'TableActionList',
    type: 'div',
    className: "".concat(prefix$2b, "--action-list")
  });

  var TableBatchAction = function TableBatchAction(props) {
    return /*#__PURE__*/React__default['default'].createElement(Button, props);
  };

  TableBatchAction.propTypes = {
    /**
     * Specify if the button is an icon-only button
     */
    hasIconOnly: PropTypes__default['default'].bool,

    /**
     * If specifying the `renderIcon` prop, provide a description for that icon that can
     * be read by screen readers
     */
    iconDescription: function iconDescription(props) {
      if (props.renderIcon && !props.children && !props.iconDescription) {
        return new Error('renderIcon property specified without also providing an iconDescription property.');
      }

      return undefined;
    },

    /**
     * Optional function to render your own icon in the underlying button
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object])
  };
  TableBatchAction.defaultProps = {
    renderIcon: AddFilled16
  };

  var prefix$2a = settings_1.prefix;
  var translationKeys$2 = {
    'carbon.table.batch.cancel': 'Cancel',
    'carbon.table.batch.items.selected': 'items selected',
    'carbon.table.batch.item.selected': 'item selected'
  };

  var translateWithId$4 = function translateWithId(id, state) {
    if (id === 'carbon.table.batch.cancel') {
      return translationKeys$2[id];
    }

    return "".concat(state.totalSelected, " ").concat(translationKeys$2[id]);
  };

  var TableBatchActions = function TableBatchActions(_ref) {
    var _cx;

    var className = _ref.className,
        children = _ref.children,
        shouldShowBatchActions = _ref.shouldShowBatchActions,
        totalSelected = _ref.totalSelected,
        onCancel = _ref.onCancel,
        t = _ref.translateWithId,
        rest = _objectWithoutProperties$2(_ref, ["className", "children", "shouldShowBatchActions", "totalSelected", "onCancel", "translateWithId"]);

    var batchActionsClasses = classnames((_cx = {}, _defineProperty$2(_cx, "".concat(prefix$2a, "--batch-actions"), true), _defineProperty$2(_cx, "".concat(prefix$2a, "--batch-actions--active"), shouldShowBatchActions), _cx), className);
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, rest, {
      "aria-hidden": !shouldShowBatchActions,
      className: batchActionsClasses
    }), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$2a, "--batch-summary")
    }, /*#__PURE__*/React__default['default'].createElement("p", {
      className: "".concat(prefix$2a, "--batch-summary__para")
    }, /*#__PURE__*/React__default['default'].createElement("span", null, totalSelected > 1 || totalSelected === 0 ? t('carbon.table.batch.items.selected', {
      totalSelected: totalSelected
    }) : t('carbon.table.batch.item.selected', {
      totalSelected: totalSelected
    })))), /*#__PURE__*/React__default['default'].createElement(TableActionList, null, children, /*#__PURE__*/React__default['default'].createElement(Button, {
      className: "".concat(prefix$2a, "--batch-summary__cancel"),
      tabIndex: shouldShowBatchActions ? 0 : -1,
      onClick: onCancel
    }, t('carbon.table.batch.cancel'))));
  };

  TableBatchActions.translationKeys = Object.keys(translationKeys$2);
  TableBatchActions.propTypes = {
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string,

    /**
     * Hook required to listen for when the user initiates a cancel request
     * through this comopnent
     */
    onCancel: PropTypes__default['default'].func.isRequired,

    /**
     * Boolean specifier for whether or not the batch action bar should be
     * displayed
     */
    shouldShowBatchActions: PropTypes__default['default'].bool,

    /**
     * Numeric representation of the total number of items selected in a table.
     * This number is used to derive the selection message
     */
    totalSelected: PropTypes__default['default'].number.isRequired,

    /**
     * Supply a method to translate internal strings with your i18n tool of
     * choice. Translation keys are avabile on the `translationKeys` field for
     * this component.
     */
    translateWithId: PropTypes__default['default'].func
  };
  TableBatchActions.defaultProps = {
    translateWithId: translateWithId$4
  };

  var TableBody = function TableBody(_ref) {
    var children = _ref.children,
        className = _ref.className,
        rest = _objectWithoutProperties$2(_ref, ["children", "className"]);

    return /*#__PURE__*/React__default['default'].createElement("tbody", _extends$3({
      className: className
    }, rest), children);
  };

  TableBody.propTypes = {
    /**
     * `polite` Adjust the notification behavior of screen readers
     */
    'aria-live': PropTypes__default['default'].oneOf(['polite', 'assertive', 'off']),
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string
  };
  TableBody.defaultProps = {
    'aria-live': 'polite'
  };

  var TableCell = wrapComponent({
    name: 'TableCell',
    type: 'td'
  });

  var prefix$29 = settings_1.prefix;

  var TableContainer = function TableContainer(_ref) {
    var className = _ref.className,
        children = _ref.children,
        title = _ref.title,
        description = _ref.description,
        stickyHeader = _ref.stickyHeader,
        rest = _objectWithoutProperties$2(_ref, ["className", "children", "title", "description", "stickyHeader"]);

    var tableContainerClasses = classnames(className, "".concat(prefix$29, "--data-table-container"), _defineProperty$2({}, "".concat(prefix$29, "--data-table--max-width"), stickyHeader));
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({}, rest, {
      className: tableContainerClasses
    }), title && /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$29, "--data-table-header")
    }, /*#__PURE__*/React__default['default'].createElement("h4", {
      className: "".concat(prefix$29, "--data-table-header__title")
    }, title), /*#__PURE__*/React__default['default'].createElement("p", {
      className: "".concat(prefix$29, "--data-table-header__description")
    }, description)), children);
  };

  TableContainer.propTypes = {
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string,

    /**
     * Optional description text for the Table
     */
    description: PropTypes__default['default'].node,

    /**
     * Specify whether the table should have a sticky header
     */
    stickyHeader: PropTypes__default['default'].bool,

    /**
     * Provide a title for the Table
     */
    title: PropTypes__default['default'].node
  };

  var prefix$28 = settings_1.prefix;

  var TableExpandHeader = function TableExpandHeader(_ref) {
    var ariaLabel = _ref.ariaLabel,
        headerClassName = _ref.className,
        enableExpando = _ref.enableExpando,
        isExpanded = _ref.isExpanded,
        onExpand = _ref.onExpand,
        expandIconDescription = _ref.expandIconDescription,
        children = _ref.children,
        rest = _objectWithoutProperties$2(_ref, ["ariaLabel", "className", "enableExpando", "isExpanded", "onExpand", "expandIconDescription", "children"]);

    var className = classnames("".concat(prefix$28, "--table-expand"), headerClassName);
    var previousValue = isExpanded ? 'collapsed' : undefined;
    return /*#__PURE__*/React__default['default'].createElement("th", _extends$3({
      scope: "col",
      className: className,
      "data-previous-value": previousValue
    }, rest), !enableExpando ? null : /*#__PURE__*/React__default['default'].createElement("button", {
      type: "button",
      className: "".concat(prefix$28, "--table-expand__button"),
      onClick: onExpand,
      title: expandIconDescription,
      "aria-label": ariaLabel
    }, /*#__PURE__*/React__default['default'].createElement(ChevronRight16, {
      className: "".concat(prefix$28, "--table-expand__svg"),
      "aria-label": expandIconDescription
    })), children);
  };

  TableExpandHeader.propTypes = {
    /**
     * Specify the string read by a voice reader when the expand trigger is
     * focused
     */
    ariaLabel: requiredIfGivenPropIsTruthy('enableExpando', PropTypes__default['default'].string),
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string,

    /**
     * Specify whether an expand all button should be displayed
     */
    enableExpando: PropTypes__default['default'].bool,

    /**
     * The description of the chevron right icon, to be put in its SVG `<title>` element.
     */
    expandIconDescription: PropTypes__default['default'].string,

    /**
     * Specify whether this row is expanded or not. This helps coordinate data
     * attributes so that `TableExpandRow` and `TableExapndedRow` work together
     */
    isExpanded: requiredIfGivenPropIsTruthy('enableExpando', PropTypes__default['default'].bool),

    /**
     * Hook for when a listener initiates a request to expand the given row
     */
    onExpand: requiredIfGivenPropIsTruthy('enableExpando', PropTypes__default['default'].func)
  };

  var prefix$27 = settings_1.prefix;

  var TableExpandRow = function TableExpandRow(_ref) {
    var _cx;

    var ariaLabel = _ref.ariaLabel,
        rowClassName = _ref.className,
        children = _ref.children,
        isExpanded = _ref.isExpanded,
        onExpand = _ref.onExpand,
        expandIconDescription = _ref.expandIconDescription,
        isSelected = _ref.isSelected,
        expandHeader = _ref.expandHeader,
        rest = _objectWithoutProperties$2(_ref, ["ariaLabel", "className", "children", "isExpanded", "onExpand", "expandIconDescription", "isSelected", "expandHeader"]);

    var className = classnames((_cx = {}, _defineProperty$2(_cx, "".concat(prefix$27, "--parent-row"), true), _defineProperty$2(_cx, "".concat(prefix$27, "--expandable-row"), isExpanded), _defineProperty$2(_cx, "".concat(prefix$27, "--data-table--selected"), isSelected), _cx), rowClassName);
    var previousValue = isExpanded ? 'collapsed' : undefined;
    return /*#__PURE__*/React__default['default'].createElement("tr", _extends$3({}, rest, {
      className: className,
      "data-parent-row": true
    }), /*#__PURE__*/React__default['default'].createElement(TableCell, {
      className: "".concat(prefix$27, "--table-expand"),
      "data-previous-value": previousValue,
      headers: expandHeader
    }, /*#__PURE__*/React__default['default'].createElement("button", {
      type: "button",
      className: "".concat(prefix$27, "--table-expand__button"),
      onClick: onExpand,
      title: expandIconDescription,
      "aria-label": ariaLabel
    }, /*#__PURE__*/React__default['default'].createElement(ChevronRight16, {
      className: "".concat(prefix$27, "--table-expand__svg"),
      "aria-label": expandIconDescription
    }))), children);
  };

  TableExpandRow.propTypes = {
    /**
     * Specify the string read by a voice reader when the expand trigger is
     * focused
     */
    ariaLabel: PropTypes__default['default'].string.isRequired,
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string,

    /**
     * The id of the matching th node in the table head. Addresses a11y concerns outlined here: https://www.ibm.com/able/guidelines/ci162/info_and_relationships.html and https://www.w3.org/TR/WCAG20-TECHS/H43
     */
    expandHeader: PropTypes__default['default'].string,

    /**
     * The description of the chevron right icon, to be put in its SVG `<title>` element.
     */
    expandIconDescription: PropTypes__default['default'].string,

    /**
     * Specify whether this row is expanded or not. This helps coordinate data
     * attributes so that `TableExpandRow` and `TableExapndedRow` work together
     */
    isExpanded: PropTypes__default['default'].bool.isRequired,

    /**
     * Specify if the row is selected
     */
    isSelected: PropTypes__default['default'].bool,

    /**
     * Hook for when a listener initiates a request to expand the given row
     */
    onExpand: PropTypes__default['default'].func.isRequired
  };
  TableExpandRow.defaultProps = {
    expandHeader: 'expand'
  };

  var prefix$26 = settings_1.prefix;

  var TableExpandedRow = function TableExpandedRow(_ref) {
    var customClassName = _ref.className,
        children = _ref.children,
        colSpan = _ref.colSpan,
        rest = _objectWithoutProperties$2(_ref, ["className", "children", "colSpan"]);

    var rowRef = React.useRef(null);
    var className = classnames("".concat(prefix$26, "--expandable-row"), customClassName);

    var toggleParentHoverClass = function toggleParentHoverClass(eventType) {
      if (rowRef && rowRef.current && rowRef.current.previousElementSibling) {
        var parentNode = rowRef.current.previousElementSibling;

        if (eventType === 'enter') {
          parentNode.classList.add("".concat(prefix$26, "--expandable-row--hover"));
        } else {
          parentNode.classList.remove("".concat(prefix$26, "--expandable-row--hover"));
        }
      }
    };

    return /*#__PURE__*/React__default['default'].createElement("tr", _extends$3({
      ref: rowRef,
      onMouseEnter: function onMouseEnter() {
        return toggleParentHoverClass('enter');
      },
      onMouseLeave: function onMouseLeave() {
        return toggleParentHoverClass('leave');
      }
    }, rest, {
      className: className,
      "data-child-row": true
    }), /*#__PURE__*/React__default['default'].createElement(TableCell, {
      colSpan: colSpan
    }, /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$26, "--child-row-inner-container")
    }, children)));
  };

  TableExpandedRow.propTypes = {
    /**
     * Pass in the contents for your TableExpandedRow
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * The width of the expanded row's internal cell
     */
    colSpan: PropTypes__default['default'].number.isRequired
  };

  var TableHead = wrapComponent({
    name: 'TableHead',
    type: 'thead'
  });

  var _sortDirections;
  var prefix$25 = settings_1.prefix;
  var translationKeys$1 = {
    buttonDescription: 'carbon.table.header.icon.description'
  };

  var translateWithId$3 = function translateWithId(key, _ref) {
    var header = _ref.header,
        sortDirection = _ref.sortDirection,
        isSortHeader = _ref.isSortHeader,
        sortStates = _ref.sortStates;

    if (key === translationKeys$1.buttonDescription) {
      if (isSortHeader) {
        // When transitioning, we know that the sequence of states is as follows:
        // NONE -> ASC -> DESC -> NONE
        if (sortDirection === sortStates.NONE) {
          return "Click to sort rows by ".concat(header, " header in ascending order");
        }

        if (sortDirection === sortStates.ASC) {
          return "Click to sort rows by ".concat(header, " header in descending order");
        }

        return "Click to unsort rows by ".concat(header, " header");
      }

      return "Click to sort rows by ".concat(header, " header in ascending order");
    }

    return '';
  };

  var sortDirections = (_sortDirections = {}, _defineProperty$2(_sortDirections, sortStates.NONE, 'none'), _defineProperty$2(_sortDirections, sortStates.ASC, 'ascending'), _defineProperty$2(_sortDirections, sortStates.DESC, 'descending'), _sortDirections);
  var TableHeader = /*#__PURE__*/React__default['default'].forwardRef(function TableHeader(_ref2, ref) {
    var _cx;

    var headerClassName = _ref2.className,
        children = _ref2.children,
        colSpan = _ref2.colSpan,
        isSortable = _ref2.isSortable,
        isSortHeader = _ref2.isSortHeader,
        onClick = _ref2.onClick,
        scope = _ref2.scope,
        sortDirection = _ref2.sortDirection,
        t = _ref2.translateWithId,
        rest = _objectWithoutProperties$2(_ref2, ["className", "children", "colSpan", "isSortable", "isSortHeader", "onClick", "scope", "sortDirection", "translateWithId"]);

    var uniqueId = useId('table-sort');

    if (!isSortable) {
      return /*#__PURE__*/React__default['default'].createElement("th", _extends$3({}, rest, {
        className: headerClassName,
        scope: scope,
        colSpan: colSpan,
        ref: ref
      }), children ? /*#__PURE__*/React__default['default'].createElement("div", {
        className: "".concat(prefix$25, "--table-header-label")
      }, children) : null);
    }

    var className = classnames(headerClassName, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$25, "--table-sort"), true), _defineProperty$2(_cx, "".concat(prefix$25, "--table-sort--active"), isSortHeader && sortDirection !== sortStates.NONE), _defineProperty$2(_cx, "".concat(prefix$25, "--table-sort--ascending"), isSortHeader && sortDirection === sortStates.DESC), _cx));
    var ariaSort = !isSortHeader ? 'none' : sortDirections[sortDirection];
    var sortDescription = t('carbon.table.header.icon.description', {
      header: children,
      sortDirection: sortDirection,
      isSortHeader: isSortHeader,
      sortStates: sortStates
    });
    return /*#__PURE__*/React__default['default'].createElement("th", {
      "aria-sort": ariaSort,
      className: headerClassName,
      colSpan: colSpan,
      ref: ref,
      scope: scope
    }, /*#__PURE__*/React__default['default'].createElement("div", {
      style: {
        display: 'none'
      },
      id: uniqueId
    }, sortDescription), /*#__PURE__*/React__default['default'].createElement("button", _extends$3({
      type: "button",
      "aria-describedby": uniqueId,
      className: className,
      onClick: onClick
    }, rest), /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$25, "--table-sort__flex")
    }, /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$25, "--table-header-label")
    }, children), /*#__PURE__*/React__default['default'].createElement(ArrowUp20, {
      className: "".concat(prefix$25, "--table-sort__icon")
    }), /*#__PURE__*/React__default['default'].createElement(ArrowsVertical20, {
      className: "".concat(prefix$25, "--table-sort__icon-unsorted")
    }))));
  });
  TableHeader.propTypes = {
    /**
     * Pass in children that will be embedded in the table header label
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify `colSpan` as a non-negative integer value to indicate how
     * many columns the TableHeader cell extends in a table
     */
    colSpan: PropTypes__default['default'].number,

    /**
     * Specify whether this header is the header by which a table is being sorted
     * by
     */
    isSortHeader: PropTypes__default['default'].bool,

    /**
     * Specify whether this header is one through which a user can sort the table
     */
    isSortable: PropTypes__default['default'].bool,

    /**
     * Hook that is invoked when the header is clicked
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Specify the scope of this table header. You can find more info about this
     * attribute at the following URL:
     * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-scope
     */
    scope: PropTypes__default['default'].string.isRequired,

    /**
     * Specify which direction we are currently sorting by, should be one of DESC,
     * NONE, or ASC.
     */
    sortDirection: PropTypes__default['default'].oneOf(Object.values(sortStates)),

    /**
     * Supply a method to translate internal strings with your i18n tool of
     * choice. Translation keys are avabile on the `translationKeys` field for
     * this component.
     */
    translateWithId: PropTypes__default['default'].func
  };
  TableHeader.defaultProps = {
    isSortable: false,
    scope: 'col',
    translateWithId: translateWithId$3
  };
  TableHeader.translationKeys = Object.values(translationKeys$1);
  TableHeader.displayName = 'TableHeader';

  /** Used as the size to enable large array optimizations. */

  var LARGE_ARRAY_SIZE = 200;
  /** Used to stand-in for `undefined` hash values. */

  var HASH_UNDEFINED = '__lodash_hash_undefined__';
  /** Used as references for various `Number` constants. */

  var INFINITY = 1 / 0,
      MAX_SAFE_INTEGER = 9007199254740991;
  /** `Object#toString` result references. */

  var argsTag = '[object Arguments]',
      funcTag = '[object Function]',
      genTag = '[object GeneratorFunction]',
      symbolTag$1 = '[object Symbol]';
  /**
   * Used to match `RegExp`
   * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
   */

  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  /** Used to detect host constructors (Safari). */

  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  /** Used to detect unsigned integer values. */

  var reIsUint = /^(?:0|[1-9]\d*)$/;
  /** Detect free variable `global` from Node.js. */

  var freeGlobal$1 = _typeof(commonjsGlobal) == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
  /** Detect free variable `self`. */

  var freeSelf$1 = (typeof self === "undefined" ? "undefined" : _typeof(self)) == 'object' && self && self.Object === Object && self;
  /** Used as a reference to the global object. */

  var root$1 = freeGlobal$1 || freeSelf$1 || Function('return this')();
  /**
   * A faster alternative to `Function#apply`, this function invokes `func`
   * with the `this` binding of `thisArg` and the arguments of `args`.
   *
   * @private
   * @param {Function} func The function to invoke.
   * @param {*} thisArg The `this` binding of `func`.
   * @param {Array} args The arguments to invoke `func` with.
   * @returns {*} Returns the result of `func`.
   */

  function apply(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);

      case 1:
        return func.call(thisArg, args[0]);

      case 2:
        return func.call(thisArg, args[0], args[1]);

      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }

    return func.apply(thisArg, args);
  }
  /**
   * A specialized version of `_.includes` for arrays without support for
   * specifying an index to search from.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */


  function arrayIncludes(array, value) {
    var length = array ? array.length : 0;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }
  /**
   * This function is like `arrayIncludes` except that it accepts a comparator.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @param {Function} comparator The comparator invoked per element.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */


  function arrayIncludesWith(array, value, comparator) {
    var index = -1,
        length = array ? array.length : 0;

    while (++index < length) {
      if (comparator(value, array[index])) {
        return true;
      }
    }

    return false;
  }
  /**
   * A specialized version of `_.map` for arrays without support for iteratee
   * shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the new mapped array.
   */


  function arrayMap(array, iteratee) {
    var index = -1,
        length = array ? array.length : 0,
        result = Array(length);

    while (++index < length) {
      result[index] = iteratee(array[index], index, array);
    }

    return result;
  }
  /**
   * Appends the elements of `values` to `array`.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {Array} values The values to append.
   * @returns {Array} Returns `array`.
   */


  function arrayPush(array, values) {
    var index = -1,
        length = values.length,
        offset = array.length;

    while (++index < length) {
      array[offset + index] = values[index];
    }

    return array;
  }
  /**
   * The base implementation of `_.findIndex` and `_.findLastIndex` without
   * support for iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} predicate The function invoked per iteration.
   * @param {number} fromIndex The index to search from.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length,
        index = fromIndex + (fromRight ? 1 : -1);

    while (fromRight ? index-- : ++index < length) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }

    return -1;
  }
  /**
   * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function baseIndexOf(array, value, fromIndex) {
    if (value !== value) {
      return baseFindIndex(array, baseIsNaN, fromIndex);
    }

    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }

    return -1;
  }
  /**
   * The base implementation of `_.isNaN` without support for number objects.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
   */


  function baseIsNaN(value) {
    return value !== value;
  }
  /**
   * The base implementation of `_.times` without support for iteratee shorthands
   * or max array length checks.
   *
   * @private
   * @param {number} n The number of times to invoke `iteratee`.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the array of results.
   */


  function baseTimes(n, iteratee) {
    var index = -1,
        result = Array(n);

    while (++index < n) {
      result[index] = iteratee(index);
    }

    return result;
  }
  /**
   * The base implementation of `_.unary` without support for storing metadata.
   *
   * @private
   * @param {Function} func The function to cap arguments for.
   * @returns {Function} Returns the new capped function.
   */


  function baseUnary(func) {
    return function (value) {
      return func(value);
    };
  }
  /**
   * Checks if a cache value for `key` exists.
   *
   * @private
   * @param {Object} cache The cache to query.
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function cacheHas(cache, key) {
    return cache.has(key);
  }
  /**
   * Gets the value at `key` of `object`.
   *
   * @private
   * @param {Object} [object] The object to query.
   * @param {string} key The key of the property to get.
   * @returns {*} Returns the property value.
   */


  function getValue(object, key) {
    return object == null ? undefined : object[key];
  }
  /**
   * Checks if `value` is a host object in IE < 9.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
   */


  function isHostObject(value) {
    // Many host objects are `Object` objects that can coerce to strings
    // despite having improperly defined `toString` methods.
    var result = false;

    if (value != null && typeof value.toString != 'function') {
      try {
        result = !!(value + '');
      } catch (e) {}
    }

    return result;
  }
  /**
   * Creates a unary function that invokes `func` with its argument transformed.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {Function} transform The argument transform.
   * @returns {Function} Returns the new function.
   */


  function overArg(func, transform) {
    return function (arg) {
      return func(transform(arg));
    };
  }
  /** Used for built-in method references. */


  var arrayProto = Array.prototype,
      funcProto = Function.prototype,
      objectProto$1 = Object.prototype;
  /** Used to detect overreaching core-js shims. */

  var coreJsData = root$1['__core-js_shared__'];
  /** Used to detect methods masquerading as native. */

  var maskSrcKey = function () {
    var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
    return uid ? 'Symbol(src)_1.' + uid : '';
  }();
  /** Used to resolve the decompiled source of functions. */


  var funcToString = funcProto.toString;
  /** Used to check objects for own properties. */

  var hasOwnProperty = objectProto$1.hasOwnProperty;
  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */

  var objectToString$1 = objectProto$1.toString;
  /** Used to detect if a method is native. */

  var reIsNative = RegExp('^' + funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&').replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$');
  /** Built-in value references. */

  var _Symbol = root$1.Symbol,
      getPrototype = overArg(Object.getPrototypeOf, Object),
      propertyIsEnumerable = objectProto$1.propertyIsEnumerable,
      splice = arrayProto.splice,
      spreadableSymbol = _Symbol ? _Symbol.isConcatSpreadable : undefined;
  /* Built-in method references for those with the same name as other `lodash` methods. */

  var nativeGetSymbols = Object.getOwnPropertySymbols,
      nativeMax$1 = Math.max;
  /* Built-in method references that are verified to be native. */

  var Map$1 = getNative(root$1, 'Map'),
      nativeCreate = getNative(Object, 'create');
  /**
   * Creates a hash object.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function Hash(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the hash.
   *
   * @private
   * @name clear
   * @memberOf Hash
   */


  function hashClear() {
    this.__data__ = nativeCreate ? nativeCreate(null) : {};
  }
  /**
   * Removes `key` and its value from the hash.
   *
   * @private
   * @name delete
   * @memberOf Hash
   * @param {Object} hash The hash to modify.
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function hashDelete(key) {
    return this.has(key) && delete this.__data__[key];
  }
  /**
   * Gets the hash value for `key`.
   *
   * @private
   * @name get
   * @memberOf Hash
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function hashGet(key) {
    var data = this.__data__;

    if (nativeCreate) {
      var result = data[key];
      return result === HASH_UNDEFINED ? undefined : result;
    }

    return hasOwnProperty.call(data, key) ? data[key] : undefined;
  }
  /**
   * Checks if a hash value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf Hash
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function hashHas(key) {
    var data = this.__data__;
    return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
  }
  /**
   * Sets the hash `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf Hash
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the hash instance.
   */


  function hashSet(key, value) {
    var data = this.__data__;
    data[key] = nativeCreate && value === undefined ? HASH_UNDEFINED : value;
    return this;
  } // Add methods to `Hash`.


  Hash.prototype.clear = hashClear;
  Hash.prototype['delete'] = hashDelete;
  Hash.prototype.get = hashGet;
  Hash.prototype.has = hashHas;
  Hash.prototype.set = hashSet;
  /**
   * Creates an list cache object.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function ListCache(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the list cache.
   *
   * @private
   * @name clear
   * @memberOf ListCache
   */


  function listCacheClear() {
    this.__data__ = [];
  }
  /**
   * Removes `key` and its value from the list cache.
   *
   * @private
   * @name delete
   * @memberOf ListCache
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function listCacheDelete(key) {
    var data = this.__data__,
        index = assocIndexOf(data, key);

    if (index < 0) {
      return false;
    }

    var lastIndex = data.length - 1;

    if (index == lastIndex) {
      data.pop();
    } else {
      splice.call(data, index, 1);
    }

    return true;
  }
  /**
   * Gets the list cache value for `key`.
   *
   * @private
   * @name get
   * @memberOf ListCache
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function listCacheGet(key) {
    var data = this.__data__,
        index = assocIndexOf(data, key);
    return index < 0 ? undefined : data[index][1];
  }
  /**
   * Checks if a list cache value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf ListCache
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
  }
  /**
   * Sets the list cache `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf ListCache
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the list cache instance.
   */


  function listCacheSet(key, value) {
    var data = this.__data__,
        index = assocIndexOf(data, key);

    if (index < 0) {
      data.push([key, value]);
    } else {
      data[index][1] = value;
    }

    return this;
  } // Add methods to `ListCache`.


  ListCache.prototype.clear = listCacheClear;
  ListCache.prototype['delete'] = listCacheDelete;
  ListCache.prototype.get = listCacheGet;
  ListCache.prototype.has = listCacheHas;
  ListCache.prototype.set = listCacheSet;
  /**
   * Creates a map cache object to store key-value pairs.
   *
   * @private
   * @constructor
   * @param {Array} [entries] The key-value pairs to cache.
   */

  function MapCache(entries) {
    var index = -1,
        length = entries ? entries.length : 0;
    this.clear();

    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  /**
   * Removes all key-value entries from the map.
   *
   * @private
   * @name clear
   * @memberOf MapCache
   */


  function mapCacheClear() {
    this.__data__ = {
      'hash': new Hash(),
      'map': new (Map$1 || ListCache)(),
      'string': new Hash()
    };
  }
  /**
   * Removes `key` and its value from the map.
   *
   * @private
   * @name delete
   * @memberOf MapCache
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */


  function mapCacheDelete(key) {
    return getMapData(this, key)['delete'](key);
  }
  /**
   * Gets the map value for `key`.
   *
   * @private
   * @name get
   * @memberOf MapCache
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */


  function mapCacheGet(key) {
    return getMapData(this, key).get(key);
  }
  /**
   * Checks if a map value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf MapCache
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */


  function mapCacheHas(key) {
    return getMapData(this, key).has(key);
  }
  /**
   * Sets the map `key` to `value`.
   *
   * @private
   * @name set
   * @memberOf MapCache
   * @param {string} key The key of the value to set.
   * @param {*} value The value to set.
   * @returns {Object} Returns the map cache instance.
   */


  function mapCacheSet(key, value) {
    getMapData(this, key).set(key, value);
    return this;
  } // Add methods to `MapCache`.


  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype['delete'] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;
  /**
   *
   * Creates an array cache object to store unique values.
   *
   * @private
   * @constructor
   * @param {Array} [values] The values to cache.
   */

  function SetCache(values) {
    var index = -1,
        length = values ? values.length : 0;
    this.__data__ = new MapCache();

    while (++index < length) {
      this.add(values[index]);
    }
  }
  /**
   * Adds `value` to the array cache.
   *
   * @private
   * @name add
   * @memberOf SetCache
   * @alias push
   * @param {*} value The value to cache.
   * @returns {Object} Returns the cache instance.
   */


  function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED);

    return this;
  }
  /**
   * Checks if `value` is in the array cache.
   *
   * @private
   * @name has
   * @memberOf SetCache
   * @param {*} value The value to search for.
   * @returns {number} Returns `true` if `value` is found, else `false`.
   */


  function setCacheHas(value) {
    return this.__data__.has(value);
  } // Add methods to `SetCache`.


  SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  SetCache.prototype.has = setCacheHas;
  /**
   * Creates an array of the enumerable property names of the array-like `value`.
   *
   * @private
   * @param {*} value The value to query.
   * @param {boolean} inherited Specify returning inherited property names.
   * @returns {Array} Returns the array of property names.
   */

  function arrayLikeKeys(value, inherited) {
    // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
    // Safari 9 makes `arguments.length` enumerable in strict mode.
    var result = isArray(value) || isArguments(value) ? baseTimes(value.length, String) : [];
    var length = result.length,
        skipIndexes = !!length;

    for (var key in value) {
      if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && (key == 'length' || isIndex(key, length)))) {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * Gets the index at which the `key` is found in `array` of key-value pairs.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} key The key to search for.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */


  function assocIndexOf(array, key) {
    var length = array.length;

    while (length--) {
      if (eq(array[length][0], key)) {
        return length;
      }
    }

    return -1;
  }
  /**
   * The base implementation of methods like `_.difference` without support
   * for excluding multiple arrays or iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Array} values The values to exclude.
   * @param {Function} [iteratee] The iteratee invoked per element.
   * @param {Function} [comparator] The comparator invoked per element.
   * @returns {Array} Returns the new array of filtered values.
   */


  function baseDifference(array, values, iteratee, comparator) {
    var index = -1,
        includes = arrayIncludes,
        isCommon = true,
        length = array.length,
        result = [],
        valuesLength = values.length;

    if (!length) {
      return result;
    }

    if (iteratee) {
      values = arrayMap(values, baseUnary(iteratee));
    }

    if (comparator) {
      includes = arrayIncludesWith;
      isCommon = false;
    } else if (values.length >= LARGE_ARRAY_SIZE) {
      includes = cacheHas;
      isCommon = false;
      values = new SetCache(values);
    }

    outer: while (++index < length) {
      var value = array[index],
          computed = iteratee ? iteratee(value) : value;
      value = comparator || value !== 0 ? value : 0;

      if (isCommon && computed === computed) {
        var valuesIndex = valuesLength;

        while (valuesIndex--) {
          if (values[valuesIndex] === computed) {
            continue outer;
          }
        }

        result.push(value);
      } else if (!includes(values, computed, comparator)) {
        result.push(value);
      }
    }

    return result;
  }
  /**
   * The base implementation of `_.flatten` with support for restricting flattening.
   *
   * @private
   * @param {Array} array The array to flatten.
   * @param {number} depth The maximum recursion depth.
   * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
   * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
   * @param {Array} [result=[]] The initial result value.
   * @returns {Array} Returns the new flattened array.
   */


  function baseFlatten(array, depth, predicate, isStrict, result) {
    var index = -1,
        length = array.length;
    predicate || (predicate = isFlattenable);
    result || (result = []);

    while (++index < length) {
      var value = array[index];

      if (depth > 0 && predicate(value)) {
        if (depth > 1) {
          // Recursively flatten arrays (susceptible to call stack limits).
          baseFlatten(value, depth - 1, predicate, isStrict, result);
        } else {
          arrayPush(result, value);
        }
      } else if (!isStrict) {
        result[result.length] = value;
      }
    }

    return result;
  }
  /**
   * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
   * `keysFunc` and `symbolsFunc` to get the enumerable property names and
   * symbols of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Function} keysFunc The function to get the keys of `object`.
   * @param {Function} symbolsFunc The function to get the symbols of `object`.
   * @returns {Array} Returns the array of property names and symbols.
   */


  function baseGetAllKeys(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
  }
  /**
   * The base implementation of `_.isNative` without bad shim checks.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a native function,
   *  else `false`.
   */


  function baseIsNative(value) {
    if (!isObject$1(value) || isMasked(value)) {
      return false;
    }

    var pattern = isFunction(value) || isHostObject(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value));
  }
  /**
   * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   */


  function baseKeysIn(object) {
    if (!isObject$1(object)) {
      return nativeKeysIn(object);
    }

    var isProto = isPrototype(object),
        result = [];

    for (var key in object) {
      if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * The base implementation of `_.pick` without support for individual
   * property identifiers.
   *
   * @private
   * @param {Object} object The source object.
   * @param {string[]} props The property identifiers to pick.
   * @returns {Object} Returns the new object.
   */


  function basePick(object, props) {
    object = Object(object);
    return basePickBy(object, props, function (value, key) {
      return key in object;
    });
  }
  /**
   * The base implementation of  `_.pickBy` without support for iteratee shorthands.
   *
   * @private
   * @param {Object} object The source object.
   * @param {string[]} props The property identifiers to pick from.
   * @param {Function} predicate The function invoked per property.
   * @returns {Object} Returns the new object.
   */


  function basePickBy(object, props, predicate) {
    var index = -1,
        length = props.length,
        result = {};

    while (++index < length) {
      var key = props[index],
          value = object[key];

      if (predicate(value, key)) {
        result[key] = value;
      }
    }

    return result;
  }
  /**
   * The base implementation of `_.rest` which doesn't validate or coerce arguments.
   *
   * @private
   * @param {Function} func The function to apply a rest parameter to.
   * @param {number} [start=func.length-1] The start position of the rest parameter.
   * @returns {Function} Returns the new function.
   */


  function baseRest(func, start) {
    start = nativeMax$1(start === undefined ? func.length - 1 : start, 0);
    return function () {
      var args = arguments,
          index = -1,
          length = nativeMax$1(args.length - start, 0),
          array = Array(length);

      while (++index < length) {
        array[index] = args[start + index];
      }

      index = -1;
      var otherArgs = Array(start + 1);

      while (++index < start) {
        otherArgs[index] = args[index];
      }

      otherArgs[start] = array;
      return apply(func, this, otherArgs);
    };
  }
  /**
   * Creates an array of own and inherited enumerable property names and
   * symbols of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names and symbols.
   */


  function getAllKeysIn(object) {
    return baseGetAllKeys(object, keysIn, getSymbolsIn);
  }
  /**
   * Gets the data for `map`.
   *
   * @private
   * @param {Object} map The map to query.
   * @param {string} key The reference key.
   * @returns {*} Returns the map data.
   */


  function getMapData(map, key) {
    var data = map.__data__;
    return isKeyable(key) ? data[typeof key == 'string' ? 'string' : 'hash'] : data.map;
  }
  /**
   * Gets the native function at `key` of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {string} key The key of the method to get.
   * @returns {*} Returns the function if it's native, else `undefined`.
   */


  function getNative(object, key) {
    var value = getValue(object, key);
    return baseIsNative(value) ? value : undefined;
  }
  /**
   * Creates an array of the own enumerable symbol properties of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of symbols.
   */


  var getSymbols = nativeGetSymbols ? overArg(nativeGetSymbols, Object) : stubArray;
  /**
   * Creates an array of the own and inherited enumerable symbol properties
   * of `object`.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of symbols.
   */

  var getSymbolsIn = !nativeGetSymbols ? stubArray : function (object) {
    var result = [];

    while (object) {
      arrayPush(result, getSymbols(object));
      object = getPrototype(object);
    }

    return result;
  };
  /**
   * Checks if `value` is a flattenable `arguments` object or array.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
   */

  function isFlattenable(value) {
    return isArray(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
  }
  /**
   * Checks if `value` is a valid array-like index.
   *
   * @private
   * @param {*} value The value to check.
   * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
   * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
   */


  function isIndex(value, length) {
    length = length == null ? MAX_SAFE_INTEGER : length;
    return !!length && (typeof value == 'number' || reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
  }
  /**
   * Checks if `value` is suitable for use as unique object key.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
   */


  function isKeyable(value) {
    var type = _typeof(value);

    return type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean' ? value !== '__proto__' : value === null;
  }
  /**
   * Checks if `func` has its source masked.
   *
   * @private
   * @param {Function} func The function to check.
   * @returns {boolean} Returns `true` if `func` is masked, else `false`.
   */


  function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }
  /**
   * Checks if `value` is likely a prototype object.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
   */


  function isPrototype(value) {
    var Ctor = value && value.constructor,
        proto = typeof Ctor == 'function' && Ctor.prototype || objectProto$1;
    return value === proto;
  }
  /**
   * This function is like
   * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
   * except that it includes inherited enumerable properties.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   */


  function nativeKeysIn(object) {
    var result = [];

    if (object != null) {
      for (var key in Object(object)) {
        result.push(key);
      }
    }

    return result;
  }
  /**
   * Converts `value` to a string key if it's not a string or symbol.
   *
   * @private
   * @param {*} value The value to inspect.
   * @returns {string|symbol} Returns the key.
   */


  function toKey(value) {
    if (typeof value == 'string' || isSymbol$1(value)) {
      return value;
    }

    var result = value + '';
    return result == '0' && 1 / value == -INFINITY ? '-0' : result;
  }
  /**
   * Converts `func` to its source code.
   *
   * @private
   * @param {Function} func The function to process.
   * @returns {string} Returns the source code.
   */


  function toSource(func) {
    if (func != null) {
      try {
        return funcToString.call(func);
      } catch (e) {}

      try {
        return func + '';
      } catch (e) {}
    }

    return '';
  }
  /**
   * Performs a
   * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
   * comparison between two values to determine if they are equivalent.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to compare.
   * @param {*} other The other value to compare.
   * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
   * @example
   *
   * var object = { 'a': 1 };
   * var other = { 'a': 1 };
   *
   * _.eq(object, object);
   * // => true
   *
   * _.eq(object, other);
   * // => false
   *
   * _.eq('a', 'a');
   * // => true
   *
   * _.eq('a', Object('a'));
   * // => false
   *
   * _.eq(NaN, NaN);
   * // => true
   */


  function eq(value, other) {
    return value === other || value !== value && other !== other;
  }
  /**
   * Checks if `value` is likely an `arguments` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an `arguments` object,
   *  else `false`.
   * @example
   *
   * _.isArguments(function() { return arguments; }());
   * // => true
   *
   * _.isArguments([1, 2, 3]);
   * // => false
   */


  function isArguments(value) {
    // Safari 8.1 makes `arguments.callee` enumerable in strict mode.
    return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') && (!propertyIsEnumerable.call(value, 'callee') || objectToString$1.call(value) == argsTag);
  }
  /**
   * Checks if `value` is classified as an `Array` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array, else `false`.
   * @example
   *
   * _.isArray([1, 2, 3]);
   * // => true
   *
   * _.isArray(document.body.children);
   * // => false
   *
   * _.isArray('abc');
   * // => false
   *
   * _.isArray(_.noop);
   * // => false
   */


  var isArray = Array.isArray;
  /**
   * Checks if `value` is array-like. A value is considered array-like if it's
   * not a function and has a `value.length` that's an integer greater than or
   * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
   * @example
   *
   * _.isArrayLike([1, 2, 3]);
   * // => true
   *
   * _.isArrayLike(document.body.children);
   * // => true
   *
   * _.isArrayLike('abc');
   * // => true
   *
   * _.isArrayLike(_.noop);
   * // => false
   */

  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction(value);
  }
  /**
   * This method is like `_.isArrayLike` except that it also checks if `value`
   * is an object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array-like object,
   *  else `false`.
   * @example
   *
   * _.isArrayLikeObject([1, 2, 3]);
   * // => true
   *
   * _.isArrayLikeObject(document.body.children);
   * // => true
   *
   * _.isArrayLikeObject('abc');
   * // => false
   *
   * _.isArrayLikeObject(_.noop);
   * // => false
   */


  function isArrayLikeObject(value) {
    return isObjectLike$1(value) && isArrayLike(value);
  }
  /**
   * Checks if `value` is classified as a `Function` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a function, else `false`.
   * @example
   *
   * _.isFunction(_);
   * // => true
   *
   * _.isFunction(/abc/);
   * // => false
   */


  function isFunction(value) {
    // The use of `Object#toString` avoids issues with the `typeof` operator
    // in Safari 8-9 which returns 'object' for typed array and other constructors.
    var tag = isObject$1(value) ? objectToString$1.call(value) : '';
    return tag == funcTag || tag == genTag;
  }
  /**
   * Checks if `value` is a valid array-like length.
   *
   * **Note:** This method is loosely based on
   * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
   * @example
   *
   * _.isLength(3);
   * // => true
   *
   * _.isLength(Number.MIN_VALUE);
   * // => false
   *
   * _.isLength(Infinity);
   * // => false
   *
   * _.isLength('3');
   * // => false
   */


  function isLength(value) {
    return typeof value == 'number' && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  }
  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */


  function isObject$1(value) {
    var type = _typeof(value);

    return !!value && (type == 'object' || type == 'function');
  }
  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */


  function isObjectLike$1(value) {
    return !!value && _typeof(value) == 'object';
  }
  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */


  function isSymbol$1(value) {
    return _typeof(value) == 'symbol' || isObjectLike$1(value) && objectToString$1.call(value) == symbolTag$1;
  }
  /**
   * Creates an array of the own and inherited enumerable property names of `object`.
   *
   * **Note:** Non-object values are coerced to objects.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category Object
   * @param {Object} object The object to query.
   * @returns {Array} Returns the array of property names.
   * @example
   *
   * function Foo() {
   *   this.a = 1;
   *   this.b = 2;
   * }
   *
   * Foo.prototype.c = 3;
   *
   * _.keysIn(new Foo);
   * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
   */


  function keysIn(object) {
    return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
  }
  /**
   * The opposite of `_.pick`; this method creates an object composed of the
   * own and inherited enumerable string keyed properties of `object` that are
   * not omitted.
   *
   * @static
   * @since 0.1.0
   * @memberOf _
   * @category Object
   * @param {Object} object The source object.
   * @param {...(string|string[])} [props] The property identifiers to omit.
   * @returns {Object} Returns the new object.
   * @example
   *
   * var object = { 'a': 1, 'b': '2', 'c': 3 };
   *
   * _.omit(object, ['a', 'c']);
   * // => { 'b': '2' }
   */


  var omit = baseRest(function (object, props) {
    if (object == null) {
      return {};
    }

    props = arrayMap(baseFlatten(props, 1), toKey);
    return basePick(object, baseDifference(getAllKeysIn(object), props));
  });
  /**
   * This method returns a new empty array.
   *
   * @static
   * @memberOf _
   * @since 4.13.0
   * @category Util
   * @returns {Array} Returns the new empty array.
   * @example
   *
   * var arrays = _.times(2, _.stubArray);
   *
   * console.log(arrays);
   * // => [[], []]
   *
   * console.log(arrays[0] === arrays[1]);
   * // => false
   */

  function stubArray() {
    return [];
  }

  var lodash_omit = omit;

  var prefix$24 = settings_1.prefix;

  var TableRow = function TableRow(props) {
    // Remove unnecessary props if provided to this component, these are
    // only useful in `TableExpandRow`
    var className = classnames(props.className, _defineProperty$2({}, "".concat(prefix$24, "--data-table--selected"), props.isSelected));

    var cleanProps = _objectSpread2$2(_objectSpread2$2({}, lodash_omit(props, ['ariaLabel', 'onExpand', 'isExpanded', 'isSelected'])), {}, {
      className: className || undefined
    });

    return /*#__PURE__*/React__default['default'].createElement("tr", cleanProps);
  };

  TableRow.propTypes = {
    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify if the row is selected
     */
    isSelected: PropTypes__default['default'].bool
  };

  var prefix$23 = settings_1.prefix;

  var InlineCheckbox = /*#__PURE__*/function (_React$Component) {
    _inherits(InlineCheckbox, _React$Component);

    var _super = _createSuper(InlineCheckbox);

    function InlineCheckbox() {
      var _this;

      _classCallCheck(this, InlineCheckbox);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "handleRef", function (el) {
        _this.inputNode = el;
      });

      return _this;
    }

    _createClass(InlineCheckbox, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        if (this.inputNode) {
          this.inputNode.indeterminate = this.props.indeterminate;
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        if (this.inputNode && prevProps.indeterminate !== this.props.indeterminate) {
          this.inputNode.indeterminate = this.props.indeterminate;
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
            id = _this$props.id,
            indeterminate = _this$props.indeterminate,
            checked = _this$props.checked,
            disabled = _this$props.disabled,
            ariaLabel = _this$props.ariaLabel,
            name = _this$props.name,
            _onChange = _this$props.onChange,
            onClick = _this$props.onClick,
            onKeyDown = _this$props.onKeyDown,
            _this$props$title = _this$props.title,
            title = _this$props$title === void 0 ? undefined : _this$props$title,
            ref = _this$props.innerRef;
        var inputProps = {
          id: id,
          name: name,
          onClick: onClick,
          onChange: function onChange(evt) {
            _onChange(evt.target.checked, id, evt);
          },
          onKeyDown: onKeyDown,
          className: "".concat(prefix$23, "--checkbox"),
          type: 'checkbox',
          ref: mergeRefs(ref, this.handleRef),
          checked: false,
          disabled: disabled
        };

        if (checked) {
          inputProps.checked = true;
        }

        if (indeterminate) {
          inputProps.checked = false;
          inputProps['aria-checked'] = 'mixed';
        }

        return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("input", inputProps),
        /*#__PURE__*/

        /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
        React__default['default'].createElement("label", {
          htmlFor: id,
          className: "".concat(prefix$23, "--checkbox-label"),
          "aria-label": ariaLabel,
          title: title
        }));
      }
    }]);

    return InlineCheckbox;
  }(React__default['default'].Component);

  _defineProperty$2(InlineCheckbox, "propTypes", {
    /**
     * Specify the label for the control
     */
    ariaLabel: PropTypes__default['default'].string.isRequired,

    /**
     * Specify whether the underlying control is checked, or not
     */
    checked: PropTypes__default['default'].bool.isRequired,

    /**
     * Specify whether the underlying input control should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Provide an `id` for the underlying input control
     */
    id: PropTypes__default['default'].string.isRequired,

    /**
     * Specify whether the control is in an indterminate state
     */
    indeterminate: PropTypes__default['default'].bool,

    /**
     * Provide a `name` for the underlying input control
     */
    name: PropTypes__default['default'].string.isRequired,

    /**
     * Provide an optional hook that is called each time the input is updated
     */
    onChange: PropTypes__default['default'].func,

    /**
     * Provide a handler that is invoked when a user clicks on the control
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Provide a handler that is invoked on the key down event for the control
     */
    onKeyDown: PropTypes__default['default'].func,

    /**
     * Provide an optional tooltip for the InlineCheckbox
     */
    title: PropTypes__default['default'].string
  });

  _defineProperty$2(InlineCheckbox, "defaultProps", {
    ariaLabel: '',
    checked: false,
    id: 'inline-checkbox',
    name: '',
    onChange: function onChange() {}
  });

  var InlineCheckbox$1 = (function () {
    var forwardRef = function forwardRef(props, ref) {
      return /*#__PURE__*/React__default['default'].createElement(InlineCheckbox, _extends$3({}, props, {
        innerRef: ref
      }));
    };

    forwardRef.displayName = 'InlineCheckbox';
    return /*#__PURE__*/React__default['default'].forwardRef(forwardRef);
  })();

  var prefix$22 = settings_1.prefix;

  var TableSelectAll = function TableSelectAll(_ref) {
    var ariaLabel = _ref.ariaLabel,
        checked = _ref.checked,
        id = _ref.id,
        indeterminate = _ref.indeterminate,
        name = _ref.name,
        onSelect = _ref.onSelect,
        disabled = _ref.disabled,
        className = _ref.className;
    return /*#__PURE__*/React__default['default'].createElement("th", {
      scope: "col",
      className: classnames("".concat(prefix$22, "--table-column-checkbox"), className)
    }, /*#__PURE__*/React__default['default'].createElement(InlineCheckbox$1, {
      ariaLabel: ariaLabel,
      checked: checked,
      id: id,
      indeterminate: indeterminate,
      name: name,
      onClick: onSelect,
      disabled: disabled
    }));
  };

  TableSelectAll.propTypes = {
    /**
     * Specify the aria label for the underlying input control
     */
    ariaLabel: PropTypes__default['default'].string.isRequired,

    /**
     * Specify whether all items are selected, or not
     */
    checked: PropTypes__default['default'].bool.isRequired,

    /**
     * The CSS class names of the cell that wraps the underlying input control
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether the checkbox input should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Provide an `id` for the underlying input control
     */
    id: PropTypes__default['default'].string.isRequired,

    /**
     * Specify whether the selection only has a subset of all items
     */
    indeterminate: PropTypes__default['default'].bool,

    /**
     * Provide a `name` for the underlying input control
     */
    name: PropTypes__default['default'].string.isRequired,

    /**
     * Provide a handler to listen to when a user initiates a selection request
     */
    onSelect: PropTypes__default['default'].func.isRequired
  };
  TableSelectAll.defaultProps = {
    ariaLabel: 'Select all rows in the table'
  };

  var prefix$21 = settings_1.prefix;

  function RadioButtonSkeleton(_ref) {
    var className = _ref.className,
        rest = _objectWithoutProperties$2(_ref, ["className"]);

    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: classnames("".concat(prefix$21, "--radio-button-wrapper"), className)
    }, rest), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$21, "--radio-button ").concat(prefix$21, "--skeleton")
    }), /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$21, "--radio-button__label ").concat(prefix$21, "--skeleton")
    }));
  }

  RadioButtonSkeleton.propTypes = {
    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string
  };

  var prefix$20 = settings_1.prefix;

  var RadioButton = /*#__PURE__*/function (_React$Component) {
    _inherits(RadioButton, _React$Component);

    var _super = _createSuper(RadioButton);

    function RadioButton() {
      var _this;

      _classCallCheck(this, RadioButton);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "uid", _this.props.id || uniqueId());

      _defineProperty$2(_assertThisInitialized$1(_this), "handleChange", function (evt) {
        _this.props.onChange(_this.props.value, _this.props.name, evt);
      });

      return _this;
    }

    _createClass(RadioButton, [{
      key: "render",
      value: function render() {
        var _this$props = this.props,
            className = _this$props.className,
            labelText = _this$props.labelText,
            labelPosition = _this$props.labelPosition,
            ref = _this$props.innerRef,
            hideLabel = _this$props.hideLabel,
            other = _objectWithoutProperties$2(_this$props, ["className", "labelText", "labelPosition", "innerRef", "hideLabel"]);

        {
          warning(labelPosition !== 'top' && labelPosition !== 'bottom', '`top`/`bottom` values for `labelPosition` property in the `RadioButton` component is deprecated ' + 'and being removed in the next release of `carbon-components-react`.') ;
        }

        var innerLabelClasses = classnames(_defineProperty$2({}, "".concat(prefix$20, "--visually-hidden"), hideLabel));
        var wrapperClasses = classnames(className, "".concat(prefix$20, "--radio-button-wrapper"), _defineProperty$2({}, "".concat(prefix$20, "--radio-button-wrapper--label-").concat(labelPosition), labelPosition !== 'right'));
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: wrapperClasses
        }, /*#__PURE__*/React__default['default'].createElement("input", _extends$3({}, other, {
          type: "radio",
          className: "".concat(prefix$20, "--radio-button"),
          onChange: this.handleChange,
          id: this.uid,
          ref: ref
        })), /*#__PURE__*/React__default['default'].createElement("label", {
          htmlFor: this.uid,
          className: "".concat(prefix$20, "--radio-button__label")
        }, /*#__PURE__*/React__default['default'].createElement("span", {
          className: "".concat(prefix$20, "--radio-button__appearance")
        }), labelText && /*#__PURE__*/React__default['default'].createElement("span", {
          className: innerLabelClasses
        }, labelText)));
      }
    }]);

    return RadioButton;
  }(React__default['default'].Component);

  _defineProperty$2(RadioButton, "propTypes", {
    /**
     * Specify whether the <RadioButton> is currently checked
     */
    checked: PropTypes__default['default'].bool,

    /**
     * Provide an optional className to be applied to the containing node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether the <RadioButton> should be checked by default
     */
    defaultChecked: PropTypes__default['default'].bool,

    /**
     * Specify whether the control is disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify whether the label should be hidden, or not
     */
    hideLabel: PropTypes__default['default'].bool,

    /**
     * Provide a unique id for the underlying `<input>` node
     */
    id: PropTypes__default['default'].string,

    /**
     * Provide where label text should be placed
     * NOTE: `top`/`bottom` are deprecated
     */
    labelPosition: PropTypes__default['default'].oneOf(['top', 'right', 'bottom', 'left']),

    /**
     * Provide label text to be read by screen readers when interacting with the
     * control
     */
    labelText: PropTypes__default['default'].node.isRequired,

    /**
     * Provide a name for the underlying `<input>` node
     */
    name: PropTypes__default['default'].string,

    /**
     * Provide an optional `onChange` hook that is called each time the value of
     * the underlying `<input>` changes
     */
    onChange: PropTypes__default['default'].func,

    /**
     * Provide a handler that is invoked when a user clicks on the control
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Specify the value of the <RadioButton>
     */
    value: PropTypes__default['default'].oneOfType([PropTypes__default['default'].string, PropTypes__default['default'].number]).isRequired
  });

  _defineProperty$2(RadioButton, "defaultProps", {
    labelText: '',
    labelPosition: 'right',
    onChange: function onChange() {},
    value: ''
  });
  var RadioButton$1 = (function () {
    var forwardRef = function forwardRef(props, ref) {
      return /*#__PURE__*/React__default['default'].createElement(RadioButton, _extends$3({}, props, {
        innerRef: ref
      }));
    };

    forwardRef.displayName = 'RadioButton';
    return /*#__PURE__*/React__default['default'].forwardRef(forwardRef);
  })();

  var prefix$1$ = settings_1.prefix;

  var TableSelectRow = function TableSelectRow(_ref) {
    var _classNames;

    var ariaLabel = _ref.ariaLabel,
        checked = _ref.checked,
        id = _ref.id,
        name = _ref.name,
        onSelect = _ref.onSelect,
        onChange = _ref.onChange,
        disabled = _ref.disabled,
        radio = _ref.radio,
        className = _ref.className;
    var selectionInputProps = {
      id: id,
      name: name,
      onClick: onSelect,
      onChange: onChange,
      checked: checked,
      disabled: disabled
    };
    var InlineInputComponent = radio ? RadioButton$1 : InlineCheckbox$1;
    var tableSelectRowClasses = classnames("".concat(prefix$1$, "--table-column-checkbox"), (_classNames = {}, _defineProperty$2(_classNames, className, className), _defineProperty$2(_classNames, "".concat(prefix$1$, "--table-column-radio"), radio), _classNames));
    return /*#__PURE__*/React__default['default'].createElement("td", {
      className: tableSelectRowClasses
    }, /*#__PURE__*/React__default['default'].createElement(InlineInputComponent, _extends$3({}, selectionInputProps, radio && {
      labelText: ariaLabel,
      hideLabel: true
    }, !radio && {
      ariaLabel: ariaLabel
    })));
  };

  TableSelectRow.propTypes = {
    /**
     * Specify the aria label for the underlying input control
     */
    ariaLabel: PropTypes__default['default'].string.isRequired,

    /**
     * Specify whether all items are selected, or not
     */
    checked: PropTypes__default['default'].bool.isRequired,

    /**
     * The CSS class names of the cell that wraps the underlying input control
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether the control is disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Provide an `id` for the underlying input control
     */
    id: PropTypes__default['default'].string.isRequired,

    /**
     * Provide a `name` for the underlying input control
     */
    name: PropTypes__default['default'].string.isRequired,

    /**
     * Provide an optional hook that is called each time the input is updated
     */
    onChange: PropTypes__default['default'].func,

    /**
     * Provide a handler to listen to when a user initiates a selection request
     */
    onSelect: PropTypes__default['default'].func.isRequired,

    /**
     * Specify whether the control should be a radio button or inline checkbox
     */
    radio: PropTypes__default['default'].bool
  };

  /**
   * Copyright IBM Corp. 2016, 2018
   *
   * This source code is licensed under the Apache-2.0 license found in the
   * LICENSE file in the root directory of this source tree.
   */

  /**
   * @param {object<string, Function>} propTypes The list of type checkers, keyed by prop names.
   * @returns {object<string, Function>}
   *   The new prop type checkers that checks if one of the given props exist,
   *   in addition to the original type checkings.
   */
  function isRequiredOneOf(propTypes) {
    var names = Object.keys(propTypes);

    var checker = function checker(propType) {
      return function (props, propName, componentName) {
        if (names.every(function (name) {
          return typeof props[name] === 'undefined';
        })) {
          return new Error("".concat(componentName, " requires one of the following props: ").concat(names.join(', ')));
        }

        for (var _len = arguments.length, rest = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
          rest[_key - 3] = arguments[_key];
        }

        return propType.apply(void 0, [props, propName, componentName].concat(rest));
      };
    };

    return names.reduce(function (o, name) {
      return _objectSpread2$2(_objectSpread2$2({}, o), {}, _defineProperty$2({}, name, checker(propTypes[name])));
    }, {});
  }

  var AriaLabelPropType = isRequiredOneOf({
    'aria-label': PropTypes__default['default'].string,
    'aria-labelledby': PropTypes__default['default'].string
  });

  var prefix$1_ = settings_1.prefix;

  var TableToolbar = function TableToolbar(_ref) {
    var _cx;

    var children = _ref.children,
        size = _ref.size,
        rest = _objectWithoutProperties$2(_ref, ["children", "size"]);

    var className = classnames((_cx = {}, _defineProperty$2(_cx, "".concat(prefix$1_, "--table-toolbar"), true), _defineProperty$2(_cx, "".concat(prefix$1_, "--table-toolbar--").concat(size), size), _cx));
    return /*#__PURE__*/React__default['default'].createElement("section", _extends$3({}, rest, {
      className: className
    }), children);
  };

  TableToolbar.propTypes = _objectSpread2$2(_objectSpread2$2({}, AriaLabelPropType), {}, {
    /**
     * Pass in the children that will be rendered inside the TableToolbar
     */
    children: PropTypes__default['default'].node,

    /**
     * `normal` Change the row height of table
     * V11: remove small, normal
     */
    size: PropTypes__default['default'].oneOf(['small', 'sm', 'normal', 'lg'])
  });
  TableToolbar.defaultProps = {
    'aria-label': 'data table toolbar'
  };

  var prefix$1Z = settings_1.prefix;

  var OverflowMenuItem = /*#__PURE__*/function (_React$Component) {
    _inherits(OverflowMenuItem, _React$Component);

    var _super = _createSuper(OverflowMenuItem);

    function OverflowMenuItem() {
      var _this;

      _classCallCheck(this, OverflowMenuItem);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "overflowMenuItem", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "setTabFocus", function (evt) {
        if (match(evt, ArrowDown)) {
          _this.props.handleOverflowMenuItemFocus({
            currentIndex: _this.props.index,
            direction: 1
          });
        }

        if (match(evt, ArrowUp)) {
          _this.props.handleOverflowMenuItemFocus({
            currentIndex: _this.props.index,
            direction: -1
          });
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleClick", function (evt) {
        var _this$props = _this.props,
            onClick = _this$props.onClick,
            closeMenu = _this$props.closeMenu;
        onClick(evt);

        if (closeMenu) {
          closeMenu();
        }
      });

      return _this;
    }

    _createClass(OverflowMenuItem, [{
      key: "render",
      value: function render() {
        var _classNames,
            _this2 = this;

        var _this$props2 = this.props,
            href = _this$props2.href,
            className = _this$props2.className,
            itemText = _this$props2.itemText,
            hasDivider = _this$props2.hasDivider,
            isDelete = _this$props2.isDelete,
            disabled = _this$props2.disabled,
            closeMenu = _this$props2.closeMenu;
            _this$props2.onClick;
            _this$props2.handleOverflowMenuItemFocus;
            var _onKeyDown = _this$props2.onKeyDown,
            primaryFocus = _this$props2.primaryFocus,
            wrapperClassName = _this$props2.wrapperClassName,
            requireTitle = _this$props2.requireTitle,
            index = _this$props2.index,
            title = _this$props2.title,
            other = _objectWithoutProperties$2(_this$props2, ["href", "className", "itemText", "hasDivider", "isDelete", "disabled", "closeMenu", "onClick", "handleOverflowMenuItemFocus", "onKeyDown", "primaryFocus", "wrapperClassName", "requireTitle", "index", "title"]);

        {
          warning(closeMenu, '`<OverflowMenuItem>` detected missing `closeMenu` prop. ' + '`closeMenu` is required to let `<OverflowMenu>` close the menu upon actions on `<OverflowMenuItem>`. ' + 'Please make sure `<OverflowMenuItem>` is a direct child of `<OverflowMenu>.') ;
        }

        var overflowMenuBtnClasses = classnames("".concat(prefix$1Z, "--overflow-menu-options__btn"), className);
        var overflowMenuItemClasses = classnames("".concat(prefix$1Z, "--overflow-menu-options__option"), (_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$1Z, "--overflow-menu--divider"), hasDivider), _defineProperty$2(_classNames, "".concat(prefix$1Z, "--overflow-menu-options__option--danger"), isDelete), _defineProperty$2(_classNames, "".concat(prefix$1Z, "--overflow-menu-options__option--disabled"), disabled), _classNames), wrapperClassName);
        var TagToUse = href ? 'a' : 'button';

        var OverflowMenuItemContent = function () {
          if (typeof itemText !== 'string') {
            return itemText;
          }

          return /*#__PURE__*/React__default['default'].createElement("div", {
            className: "".concat(prefix$1Z, "--overflow-menu-options__option-content")
          }, itemText);
        }();

        return /*#__PURE__*/React__default['default'].createElement("li", {
          className: overflowMenuItemClasses,
          role: "none"
        }, /*#__PURE__*/React__default['default'].createElement(TagToUse, _extends$3({}, other, {
          'data-floating-menu-primary-focus': primaryFocus || null,
          role: "menuitem",
          href: href,
          className: overflowMenuBtnClasses,
          disabled: disabled,
          onClick: this.handleClick,
          onKeyDown: function onKeyDown(evt) {
            _this2.setTabFocus(evt);

            _onKeyDown(evt);
          },
          ref: this.overflowMenuItem,
          title: requireTitle ? title || itemText : null,
          tabIndex: "-1",
          index: index
        }), OverflowMenuItemContent));
      }
    }]);

    return OverflowMenuItem;
  }(React__default['default'].Component);

  _defineProperty$2(OverflowMenuItem, "propTypes", {
    /**
     * The CSS class name to be placed on the button element
     */
    className: PropTypes__default['default'].string,

    /**
     * A callback to tell the parent menu component that the menu should be closed.
     */
    closeMenu: PropTypes__default['default'].func,

    /**
     * `true` to make this menu item disabled.
     */
    disabled: PropTypes__default['default'].bool,
    handleOverflowMenuItemFocus: PropTypes__default['default'].func,

    /**
     * `true` to make this menu item a divider.
     */
    hasDivider: PropTypes__default['default'].bool,

    /**
     * If given, overflow item will render as a link with the given href
     */
    href: PropTypes__default['default'].string,
    index: PropTypes__default['default'].number,

    /**
     * `true` to make this menu item a "danger button".
     */
    isDelete: PropTypes__default['default'].bool,

    /**
     * The text in the menu item.
     */
    itemText: PropTypes__default['default'].node.isRequired,

    /**
     * event handlers
     */
    onBlur: PropTypes__default['default'].func,
    onClick: PropTypes__default['default'].func,
    onFocus: PropTypes__default['default'].func,
    onKeyDown: PropTypes__default['default'].func,
    onKeyUp: PropTypes__default['default'].func,
    onMouseDown: PropTypes__default['default'].func,
    onMouseEnter: PropTypes__default['default'].func,
    onMouseLeave: PropTypes__default['default'].func,
    onMouseUp: PropTypes__default['default'].func,

    /**
     * `true` if this menu item should get focus when the menu gets open.
     */
    primaryFocus: deprecate(PropTypes__default['default'].bool, 'The `primaryFocus` prop has been deprecated as it is no longer used. ' + 'Feel free to remove this prop from <OverflowMenuItem>. This prop will ' + 'be removed in the next major release of `carbon-components-react`. ' + 'Opt for `selectorPrimaryFocus` in `<OverflowMenu>` instead'),

    /**
     * `true` if this menu item has long text and requires a browser tooltip
     */
    requireTitle: PropTypes__default['default'].bool,

    /**
     * Specify a title for the OverflowMenuItem
     */
    title: PropTypes__default['default'].string,

    /**
     * The CSS class name to be placed on the wrapper list item element
     */
    wrapperClassName: PropTypes__default['default'].string
  });

  _defineProperty$2(OverflowMenuItem, "defaultProps", {
    hasDivider: false,
    isDelete: false,
    disabled: false,
    itemText: 'Provide itemText',
    onClick: function onClick() {},
    onKeyDown: function onKeyDown() {}
  });

  var TableToolbarAction = /*#__PURE__*/React__default['default'].forwardRef(function (_ref, ref) {
    var children = _ref.children,
        rest = _objectWithoutProperties$2(_ref, ["children"]);

    return /*#__PURE__*/React__default['default'].createElement(OverflowMenuItem, _extends$3({
      ref: ref,
      itemText: children
    }, rest));
  });
  TableToolbarAction.displayName = 'TableToolbarAction';
  TableToolbarAction.propTypes = {
    children: PropTypes__default['default'].node,
    className: PropTypes__default['default'].string,
    onClick: PropTypes__default['default'].func.isRequired
  };

  var prefix$1Y = settings_1.prefix;
  var TableToolbarContent = wrapComponent({
    name: 'TableToolbarContent',
    type: 'div',
    className: "".concat(prefix$1Y, "--toolbar-content")
  });

  var prefix$1X = settings_1.prefix;

  var SearchSkeleton = function SearchSkeleton(_ref) {
    var _cx;

    var small = _ref.small,
        className = _ref.className,
        rest = _objectWithoutProperties$2(_ref, ["small", "className"]);

    var searchClasses = classnames(className, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$1X, "--skeleton"), true), _defineProperty$2(_cx, "".concat(prefix$1X, "--search--xl"), !small), _defineProperty$2(_cx, "".concat(prefix$1X, "--search--sm"), small), _cx));
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: searchClasses
    }, rest), /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$1X, "--label")
    }), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$1X, "--search-input")
    }));
  };

  SearchSkeleton.propTypes = {
    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether the Search should be a small variant
     */
    small: PropTypes__default['default'].bool
  };
  SearchSkeleton.defaultProps = {
    small: false
  };

  var prefix$1W = settings_1.prefix;

  var Search = /*#__PURE__*/function (_Component) {
    _inherits(Search, _Component);

    var _super = _createSuper(Search);

    function Search() {
      var _this;

      _classCallCheck(this, Search);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "state", {
        hasContent: _this.props.value || _this.props.defaultValue || false,
        prevValue: _this.props.value
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "clearInput", function (evt) {
        if (!_this.props.value) {
          _this.input.value = '';

          _this.props.onChange(evt);
        } else {
          var clearedEvt = Object.assign({}, evt.target, {
            target: {
              value: ''
            }
          });

          _this.props.onChange(clearedEvt);
        }

        _this.setState({
          hasContent: false
        }, function () {
          return _this.input.focus();
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleChange", function (evt) {
        _this.setState({
          hasContent: evt.target.value !== ''
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleKeyDown", function (evt) {
        if (match(evt, Escape)) {
          _this.clearInput(evt);
        }
      });

      return _this;
    }

    _createClass(Search, [{
      key: "render",
      value: function render() {
        var _classNames,
            _classNames2,
            _this2 = this;

        var _this$props = this.props,
            className = _this$props.className,
            type = _this$props.type,
            _this$props$id = _this$props.id,
            id = _this$props$id === void 0 ? this._inputId = this._inputId || "search__input__id_".concat(Math.random().toString(36).substr(2)) : _this$props$id,
            placeHolderText = _this$props.placeHolderText,
            placeholder = _this$props.placeholder,
            labelText = _this$props.labelText,
            closeButtonLabelText = _this$props.closeButtonLabelText,
            small = _this$props.small,
            _this$props$size = _this$props.size,
            size = _this$props$size === void 0 ? !small ? 'xl' : 'sm' : _this$props$size,
            light = _this$props.light,
            disabled = _this$props.disabled,
            onChange = _this$props.onChange,
            onKeyDown = _this$props.onKeyDown,
            renderIcon = _this$props.renderIcon,
            other = _objectWithoutProperties$2(_this$props, ["className", "type", "id", "placeHolderText", "placeholder", "labelText", "closeButtonLabelText", "small", "size", "light", "disabled", "onChange", "onKeyDown", "renderIcon"]);

        var hasContent = this.state.hasContent;
        var scope = this.context;
        var enabled;

        if (scope.enabled) {
          enabled = scope.enabled('enable-v11-release');
        }

        var searchClasses = classnames((_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$1W, "--search"), true), _defineProperty$2(_classNames, "".concat(prefix$1W, "--search--sm"), size === 'sm'), _defineProperty$2(_classNames, "".concat(prefix$1W, "--search--lg"), enabled ? size === 'md' : size === 'lg'), _defineProperty$2(_classNames, "".concat(prefix$1W, "--search--xl"), enabled ? size === 'lg' : size === 'xl'), _defineProperty$2(_classNames, "".concat(prefix$1W, "--search--light"), light), _defineProperty$2(_classNames, "".concat(prefix$1W, "--search--disabled"), disabled), _defineProperty$2(_classNames, className, className), _classNames));
        var clearClasses = classnames((_classNames2 = {}, _defineProperty$2(_classNames2, "".concat(prefix$1W, "--search-close"), true), _defineProperty$2(_classNames2, "".concat(prefix$1W, "--search-close--hidden"), !hasContent), _classNames2));
        var searchId = "".concat(id, "-search");
        var searchIcon = renderIcon ? renderIcon : /*#__PURE__*/React__default['default'].createElement(Search16, {
          className: "".concat(prefix$1W, "--search-magnifier-icon")
        });
        return /*#__PURE__*/React__default['default'].createElement("div", {
          role: "search",
          "aria-labelledby": searchId,
          className: searchClasses
        }, /*#__PURE__*/React__default['default'].createElement("div", {
          className: "".concat(prefix$1W, "--search-magnifier"),
          ref: function ref(magnifier) {
            _this2.magnifier = magnifier;
          }
        }, searchIcon), /*#__PURE__*/React__default['default'].createElement("label", {
          id: searchId,
          htmlFor: id,
          className: "".concat(prefix$1W, "--label")
        }, labelText), /*#__PURE__*/React__default['default'].createElement("input", _extends$3({
          role: "searchbox",
          autoComplete: "off"
        }, other, {
          type: type,
          disabled: disabled,
          className: "".concat(prefix$1W, "--search-input"),
          id: id,
          placeholder: placeHolderText || placeholder,
          onChange: composeEventHandlers([onChange, this.handleChange]),
          onKeyDown: composeEventHandlers([onKeyDown, this.handleKeyDown]),
          ref: function ref(input) {
            _this2.input = input;
          }
        })), /*#__PURE__*/React__default['default'].createElement("button", {
          className: clearClasses,
          disabled: disabled,
          onClick: this.clearInput,
          type: "button",
          "aria-label": closeButtonLabelText
        }, /*#__PURE__*/React__default['default'].createElement(Close16, null)));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref, state) {
        var value = _ref.value;
        var prevValue = state.prevValue;
        return prevValue === value ? null : {
          hasContent: !!value,
          prevValue: value
        };
      }
    }]);

    return Search;
  }(React.Component);

  _defineProperty$2(Search, "propTypes", {
    /**
     * Specify an optional className to be applied to the container node
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify a label to be read by screen readers on the "close" button
     */
    closeButtonLabelText: PropTypes__default['default'].string,

    /**
     * Optionally provide the default value of the `<input>`
     */
    defaultValue: PropTypes__default['default'].oneOfType([PropTypes__default['default'].string, PropTypes__default['default'].number]),

    /**
     * Specify whether the `<input>` should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify a custom `id` for the input
     */
    id: PropTypes__default['default'].string,

    /**
     * Provide the label text for the Search icon
     */
    labelText: PropTypes__default['default'].node.isRequired,

    /**
     * Specify light version or default version of this control
     */
    light: PropTypes__default['default'].bool,

    /**
     * Optional callback called when the search value changes.
     */
    onChange: PropTypes__default['default'].func,

    /**
     * Provide a handler that is invoked on the key down event for the input
     */
    onKeyDown: PropTypes__default['default'].func,

    /**
     * Deprecated in favor of `placeholder`
     */
    placeHolderText: deprecate(PropTypes__default['default'].string, "\nThe prop `placeHolderText` for Search has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

    /**
     * Provide an optional placeholder text for the Search.
     * Note: if the label and placeholder differ,
     * VoiceOver on Mac will read both
     */
    placeholder: PropTypes__default['default'].string,

    /**
     * Rendered icon for the Search.
     * Can be a React component class
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object]),

    /**
     * Specify the search size
     */
    size: PropTypes__default['default'].oneOf(['sm', 'md', 'lg', 'xl']),

    /**
     * Specify whether the Search should be a small variant
     */

    /**
     * Specify whether the load was successful
     */
    small: deprecate(PropTypes__default['default'].bool, "\nThe prop `small` for Search has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

    /**
     * Optional prop to specify the type of the `<input>`
     */
    type: PropTypes__default['default'].string,

    /**
     * Specify the value of the `<input>`
     */
    value: PropTypes__default['default'].oneOfType([PropTypes__default['default'].string, PropTypes__default['default'].number])
  });

  _defineProperty$2(Search, "contextType", FeatureFlagContext);

  _defineProperty$2(Search, "defaultProps", {
    type: 'text',
    placeholder: '',
    closeButtonLabelText: 'Clear search input',
    onChange: function onChange() {}
  });

  var prefix$1V = settings_1.prefix;
  var getInstanceId$a = setupGetInstanceId();
  var translationKeys = {
    'carbon.table.toolbar.search.label': 'Filter table',
    'carbon.table.toolbar.search.placeholder': 'Filter table'
  };

  var translateWithId$2 = function translateWithId(id) {
    return translationKeys[id];
  };

  var TableToolbarSearch = function TableToolbarSearch(_ref) {
    var _cx;

    var className = _ref.className,
        searchContainerClass = _ref.searchContainerClass,
        onChangeProp = _ref.onChange,
        t = _ref.translateWithId,
        placeHolderText = _ref.placeHolderText,
        placeholder = _ref.placeholder,
        labelText = _ref.labelText,
        expandedProp = _ref.expanded,
        defaultExpanded = _ref.defaultExpanded,
        defaultValue = _ref.defaultValue,
        disabled = _ref.disabled,
        onExpand = _ref.onExpand,
        persistent = _ref.persistent,
        persistant = _ref.persistant,
        id = _ref.id,
        rest = _objectWithoutProperties$2(_ref, ["className", "searchContainerClass", "onChange", "translateWithId", "placeHolderText", "placeholder", "labelText", "expanded", "defaultExpanded", "defaultValue", "disabled", "onExpand", "persistent", "persistant", "id"]);

    var _useRef = React.useRef(expandedProp !== undefined),
        controlled = _useRef.current;

    var _useState = React.useState(defaultExpanded || defaultValue),
        _useState2 = _slicedToArray(_useState, 2),
        expandedState = _useState2[0],
        setExpandedState = _useState2[1];

    var expanded = controlled ? expandedProp : expandedState;

    var _useState3 = React.useState(defaultValue || ''),
        _useState4 = _slicedToArray(_useState3, 2),
        value = _useState4[0],
        setValue = _useState4[1];

    var uniqueId = React.useMemo(getInstanceId$a, []);

    var _useState5 = React.useState(null),
        _useState6 = _slicedToArray(_useState5, 2),
        focusTarget = _useState6[0],
        setFocusTarget = _useState6[1];

    React.useEffect(function () {
      if (focusTarget) {
        focusTarget.current.querySelector('input').focus();
        setFocusTarget(null);
      }
    }, [focusTarget]);
    React.useEffect(function () {
      if (defaultValue) {
        onChangeProp('', defaultValue);
      }
    }, //eslint-disable-next-line react-hooks/exhaustive-deps
    []);
    var searchClasses = classnames(className, (_cx = {}, _defineProperty$2(_cx, searchContainerClass, searchContainerClass), _defineProperty$2(_cx, "".concat(prefix$1V, "--toolbar-search-container-active"), expanded), _defineProperty$2(_cx, "".concat(prefix$1V, "--toolbar-search-container-disabled"), disabled), _defineProperty$2(_cx, "".concat(prefix$1V, "--toolbar-search-container-expandable"), !persistent || !persistent && !persistant), _defineProperty$2(_cx, "".concat(prefix$1V, "--toolbar-search-container-persistent"), persistent || persistant), _cx));

    var handleExpand = function handleExpand(event) {
      var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : !expanded;

      if (!disabled) {
        if (!controlled && (!persistent || !persistent && !persistant)) {
          setExpandedState(value);
        }

        if (onExpand) {
          onExpand(event, value);
        }
      }
    };

    var onChange = function onChange(e) {
      setValue(e.target.value);

      if (onChangeProp) {
        onChangeProp(e);
      }
    };

    return /*#__PURE__*/React__default['default'].createElement(Search, _extends$3({
      disabled: disabled,
      className: searchClasses,
      value: value,
      id: typeof id !== 'undefined' ? id : uniqueId.toString(),
      labelText: labelText || t('carbon.table.toolbar.search.label'),
      placeholder: placeHolderText || placeholder || t('carbon.table.toolbar.search.placeholder'),
      onChange: onChange,
      onFocus: function onFocus(event) {
        return handleExpand(event, true);
      },
      onBlur: function onBlur(event) {
        return !value && handleExpand(event, false);
      }
    }, rest));
  };

  TableToolbarSearch.propTypes = {
    children: PropTypes__default['default'].node,

    /**
     * Provide an optional class name for the search container
     */
    className: PropTypes__default['default'].string,

    /**
     * Specifies if the search should initially render in an expanded state
     */
    defaultExpanded: PropTypes__default['default'].bool,

    /**
     * Provide an optional default value for the Search component
     */
    defaultValue: PropTypes__default['default'].string,

    /**
     * Specifies if the search should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specifies if the search should expand
     */
    expanded: PropTypes__default['default'].bool,

    /**
     * Provide an optional id for the search container
     */
    id: PropTypes__default['default'].string,

    /**
     * Provide an optional label text for the Search component icon
     */
    labelText: PropTypes__default['default'].string,

    /**
     * Provide an optional hook that is called each time the input is updated
     */
    onChange: PropTypes__default['default'].func,

    /**
     * Provide an optional hook that is called each time the input is expanded
     */
    onExpand: PropTypes__default['default'].func,
    persistant: deprecate(PropTypes__default['default'].bool, "\nThe prop `persistant` for TableToolbarSearch has been deprecated in favor of `persistent`. Please use `persistent` instead."),

    /**
     * Whether the search should be allowed to expand
     */
    persistent: PropTypes__default['default'].bool,

    /**
     * Deprecated in favor of `placeholder`
     */
    placeHolderText: deprecate(PropTypes__default['default'].string, "\nThe prop `placeHolderText` for TableToolbarSearch has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

    /**
     * Provide an optional placeholder text for the Search component
     */
    placeholder: PropTypes__default['default'].string,

    /**
     * Provide an optional className for the overal container of the Search
     */
    searchContainerClass: PropTypes__default['default'].string,

    /**
     * Optional prop to specify the tabIndex of the <Search> (in expanded state) or the container (in collapsed state)
     */
    tabIndex: PropTypes__default['default'].oneOfType([PropTypes__default['default'].number, PropTypes__default['default'].string]),

    /**
     * Provide custom text for the component for each translation id
     */
    translateWithId: PropTypes__default['default'].func.isRequired
  };
  TableToolbarSearch.defaultProps = {
    tabIndex: '0',
    translateWithId: translateWithId$2,
    persistent: false
  };

  /**
   * Generic component used for reacting to a click event happening outside of a
   * given `children` element.
   */

  var ClickListener = /*#__PURE__*/function (_React$Component) {
    _inherits(ClickListener, _React$Component);

    var _super = _createSuper(ClickListener);

    function ClickListener(props) {
      var _this;

      _classCallCheck(this, ClickListener);

      _this = _super.call(this, props); // We manually bind handlers in this Component, versus using class
      // properties, so that we can properly test the `handleRef` handler with
      // enzyme.

      _this.handleRef = _this.handleRef.bind(_assertThisInitialized$1(_this));
      _this.handleDocumentClick = _this.handleDocumentClick.bind(_assertThisInitialized$1(_this));
      return _this;
    }

    _createClass(ClickListener, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        document.addEventListener('click', this.handleDocumentClick);
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        document.removeEventListener('click', this.handleDocumentClick);
      }
    }, {
      key: "handleDocumentClick",
      value: function handleDocumentClick(evt) {
        if (this.element) {
          if (this.element.contains && !this.element.contains(ClickListener.getEventTarget(evt))) {
            this.props.onClickOutside(evt);
          }
        }
      }
    }, {
      key: "handleRef",
      value: function handleRef(el) {
        var children = this.props.children;
        this.element = el;
        /**
         * One important note, `children.ref` corresponds to a `ref` prop passed in
         * directly to the child, not necessarily a `ref` defined in the component.
         * This means that here we target the following `ref` location:
         *
         * <ClickListener onClickOutside={() => {}}>
         *   <Child ref={targetedRefHere} />
         * </ClickListener>
         */

        if (children.ref && typeof children.ref === 'function') {
          children.ref(el);
        }
      }
    }, {
      key: "render",
      value: function render() {
        return /*#__PURE__*/React__default['default'].cloneElement(this.props.children, {
          ref: this.handleRef
        });
      }
    }], [{
      key: "getEventTarget",
      value: function getEventTarget(evt) {
        // support Shadow DOM
        if (evt.composed && typeof evt.composedPath === 'function') {
          return evt.composedPath()[0];
        }

        return evt.target;
      }
    }]);

    return ClickListener;
  }(React__default['default'].Component);

  _defineProperty$2(ClickListener, "propTypes", {
    children: PropTypes__default['default'].element.isRequired,
    onClickOutside: PropTypes__default['default'].func.isRequired
  });

  var prefix$1U = settings_1.prefix;
  function resetFocus(el) {
    if (el) {
      var _el$querySelectorAll;

      Array.from((_el$querySelectorAll = el.querySelectorAll('[tabindex="0"]')) !== null && _el$querySelectorAll !== void 0 ? _el$querySelectorAll : []).forEach(function (node) {
        node.tabIndex = -1;
      });
    }
  }
  function focusNode(node) {
    if (node) {
      node.tabIndex = 0;
      node.focus();
    }
  }
  function getValidNodes(list) {
    var level = list.dataset.level;
    var nodes = [];

    if (level) {
      var submenus = Array.from(list.querySelectorAll('[data-level]'));
      nodes = Array.from(list.querySelectorAll("li.".concat(prefix$1U, "--menu-option"))).filter(function (child) {
        return !submenus.some(function (submenu) {
          return submenu.contains(child);
        });
      });
    }

    return nodes.filter(function (node) {
      return node.matches(":not(.".concat(prefix$1U, "--menu-option--disabled)"));
    });
  }
  function getNextNode(current, direction) {
    var menu = getParentMenu(current);
    var nodes = getValidNodes(menu);
    var currentIndex = nodes.indexOf(current);
    var nextNode = nodes[currentIndex + direction];
    return nextNode || null;
  }
  function getFirstSubNode(node) {
    var submenu = node.querySelector("ul.".concat(prefix$1U, "--menu"));

    if (submenu) {
      var subnodes = getValidNodes(submenu);
      return subnodes[0] || null;
    }

    return null;
  }
  function getParentNode(node) {
    if (node) {
      var parentNode = node.parentNode.closest("li.".concat(prefix$1U, "--menu-option"));
      return parentNode || null;
    }

    return null;
  }
  function getParentMenu(el) {
    if (el) {
      var parentMenu = el.parentNode.closest("ul.".concat(prefix$1U, "--menu"));
      return parentMenu || null;
    }

    return null;
  }
  function clickedElementHasSubnodes(e) {
    if (e) {
      var closestFocusableElement = e.target.closest('[tabindex]');

      if ((closestFocusableElement === null || closestFocusableElement === void 0 ? void 0 : closestFocusableElement.tagName) === 'LI') {
        return getFirstSubNode(closestFocusableElement) !== null;
      }
    }

    return false;
  }
  /**
   * @param {number} [value] The value to cap
   * @param {number} [min] The minimum of the range
   * @param {number} [max] The maximum of the range
   * @returns {number} Whether or not the element fits inside the boundaries on the given axis
   */

  function capWithinRange(value, min, max) {
    if (value > max) {
      return max;
    }

    if (value < min) {
      return min;
    }

    return value;
  }
  /**
   * @param {number[]} [elementDimensions] The dimensions of the element: [width, height]
   * @param {number[]} [position] The desired position of the element: [x, y]
   * @param {number[]} [boundaries] The boundaries of the container the element should be contained in: [minX, minY, maxX, maxY]
   * @param {string} [axis="x"] Which axis to check. Either "x" or "y"
   * @returns {boolean} Whether or not the element fits inside the boundaries on the given axis
   */

  function elementFits(elementDimensions, position, boundaries) {
    var axis = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'x';
    var index = axis === 'y' ? 1 : 0;
    var min = boundaries[index];
    var max = boundaries[index + 2];
    var start = position[index];
    var end = position[index] + elementDimensions[index];
    return start >= min && end <= max;
  }
  /**
   * @param {number[]} [elementDimensions] The dimensions of the element: [width, height]
   * @param {number[]} [targetBoundaries] The boundaries of the target the element should attach to: [minX, minY, maxX, maxY]
   * @param {number[]} [containerBoundaries] The boundaries of the container the element should be contained in: [minX, minY, maxX, maxY]
   * @param {number} [preferredDirection=1] Which direction is preferred. Either 1 (right right) or -1 (to left)
   * @returns {object} The determined position and direction of the elemnt: { position: [x, y], direction: 1 | -1 }
   */


  function getPosition(elementDimensions, targetBoundaries, containerBoundaries) {
    var preferredDirection = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    var position = [0, 0];
    var direction = preferredDirection; // x

    position[0] = direction === 1 ? targetBoundaries[0] : targetBoundaries[2] - elementDimensions[0];
    var xFits = elementFits(elementDimensions, position, containerBoundaries, 'x');

    if (!xFits) {
      direction = direction * -1;
      position[0] = direction === 1 ? targetBoundaries[0] : targetBoundaries[2] - elementDimensions[0];
    } // y


    position[1] = targetBoundaries[3];
    var yFits = elementFits(elementDimensions, position, containerBoundaries, 'y');

    if (!yFits) {
      position[1] = targetBoundaries[1] - elementDimensions[1];
    }

    return {
      position: position,
      direction: direction
    };
  }

  function MenuGroup(_ref) {
    var label = _ref.label,
        children = _ref.children;
    return /*#__PURE__*/React__default['default'].createElement("li", {
      role: "none"
    }, /*#__PURE__*/React__default['default'].createElement("ul", {
      role: "group",
      "aria-label": label
    }, children));
  }

  MenuGroup.propTypes = {
    /**
     * Specify the children of the MenuGroup
     */
    children: PropTypes__default['default'].node,

    /**
     * Rendered label for the MenuGroup
     */
    label: PropTypes__default['default'].node.isRequired
  };

  var prefix$1T = settings_1.prefix;
  var hoverIntentDelay = 150; // in ms

  function MenuOptionContent(_ref) {
    var label = _ref.label,
        info = _ref.info,
        disabled = _ref.disabled,
        Icon = _ref.icon,
        indented = _ref.indented;
    var classes = classnames("".concat(prefix$1T, "--menu-option__content"), _defineProperty$2({}, "".concat(prefix$1T, "--menu-option__content--disabled"), disabled));
    return /*#__PURE__*/React__default['default'].createElement("div", {
      className: classes
    }, indented && /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$1T, "--menu-option__icon")
    }, Icon && /*#__PURE__*/React__default['default'].createElement(Icon, null)), /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$1T, "--menu-option__label"),
      title: label
    }, label), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$1T, "--menu-option__info")
    }, info));
  }

  function MenuOption(_ref2) {
    var _classnames2;

    var children = _ref2.children,
        disabled = _ref2.disabled,
        indented = _ref2.indented,
        _ref2$kind = _ref2.kind,
        kind = _ref2$kind === void 0 ? 'default' : _ref2$kind,
        label = _ref2.label,
        level = _ref2.level,
        _ref2$onClick = _ref2.onClick,
        onClick = _ref2$onClick === void 0 ? function () {} : _ref2$onClick,
        renderIcon = _ref2.renderIcon,
        shortcut = _ref2.shortcut,
        rest = _objectWithoutProperties$2(_ref2, ["children", "disabled", "indented", "kind", "label", "level", "onClick", "renderIcon", "shortcut"]);

    var _useState = React.useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        submenuOpen = _useState2[0],
        setSubmenuOpen = _useState2[1];

    var _useState3 = React.useState(false),
        _useState4 = _slicedToArray(_useState3, 2),
        submenuOpenedByKeyboard = _useState4[0],
        setSubmenuOpenedByKeyboard = _useState4[1];

    var rootRef = React.useRef(null);
    var hoverIntentTimeout = React.useRef(null);
    var subOptions = React__default['default'].Children.map(children, function (node) {
      if ( /*#__PURE__*/React__default['default'].isValidElement(node)) {
        return /*#__PURE__*/React__default['default'].cloneElement(node);
      }
    });

    function openSubmenu() {
      var openedByKeyboard = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      setSubmenuOpenedByKeyboard(openedByKeyboard);
      setSubmenuOpen(true);
    }

    function handleKeyDown(event) {
      if (clickedElementHasSubnodes(event) && (match(event, ArrowRight) || match(event, Enter) || match(event, Space))) {
        openSubmenu(true);
      } else if ((match(event, Enter) || match(event, Space)) && onClick) {
        onClick(event);
      }
    }

    function handleMouseEnter() {
      hoverIntentTimeout.current = setTimeout(openSubmenu, hoverIntentDelay);
    }

    function handleMouseLeave() {
      clearTimeout(hoverIntentTimeout === null || hoverIntentTimeout === void 0 ? void 0 : hoverIntentTimeout.current);
      setSubmenuOpen(false);
    }

    function getSubmenuPosition() {
      var pos = [0, 0];

      if (subOptions) {
        var parentMenu = getParentMenu(rootRef === null || rootRef === void 0 ? void 0 : rootRef.current);

        if (parentMenu) {
          var _parentMenu$getBoundi = parentMenu.getBoundingClientRect(),
              x = _parentMenu$getBoundi.x,
              width = _parentMenu$getBoundi.width;

          var _rootRef$current$getB = rootRef.current.getBoundingClientRect(),
              y = _rootRef$current$getB.y;

          pos[0] = x + width;
          pos[1] = y;
        }
      }

      return pos;
    }

    React.useEffect(function () {
      if (subOptions && submenuOpenedByKeyboard) {
        var firstSubnode = getFirstSubNode(rootRef === null || rootRef === void 0 ? void 0 : rootRef.current);
        focusNode(firstSubnode);
      } // eslint-disable-next-line react-hooks/exhaustive-deps

    }, [submenuOpen]);
    var classes = classnames("".concat(prefix$1T, "--menu-option"), (_classnames2 = {}, _defineProperty$2(_classnames2, "".concat(prefix$1T, "--menu-option--disabled"), disabled), _defineProperty$2(_classnames2, "".concat(prefix$1T, "--menu-option--active"), subOptions && submenuOpen), _defineProperty$2(_classnames2, "".concat(prefix$1T, "--menu-option--danger"), !subOptions && kind === 'danger'), _classnames2));
    var allowedRoles = ['menuitemradio', 'menuitemcheckbox'];
    var role = rest.role && allowedRoles.includes(rest.role) ? rest.role : 'menuitem';
    var submenuPosition = getSubmenuPosition();
    return (
      /*#__PURE__*/
      // role is either menuitemradio, menuitemcheckbox, or menuitem which are all interactive
      // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
      React__default['default'].createElement("li", _extends$3({}, rest, {
        ref: rootRef,
        className: classes,
        role: role,
        tabIndex: -1,
        "aria-disabled": !subOptions && disabled,
        "aria-haspopup": subOptions ? true : null,
        "aria-expanded": subOptions ? submenuOpen : null,
        onKeyDown: handleKeyDown,
        onMouseEnter: subOptions ? handleMouseEnter : null,
        onMouseLeave: subOptions ? handleMouseLeave : null,
        onClick: onClick
      }), subOptions ? /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement(MenuOptionContent, {
        label: label,
        icon: renderIcon,
        info: /*#__PURE__*/React__default['default'].createElement(CaretRight16, null),
        indented: indented
      }), /*#__PURE__*/React__default['default'].createElement(Menu, {
        level: level + 1,
        open: submenuOpen,
        onClose: function onClose() {
          setSubmenuOpen(false);
        },
        x: submenuPosition[0],
        y: submenuPosition[1]
      }, subOptions)) : /*#__PURE__*/React__default['default'].createElement(MenuOptionContent, {
        label: label,
        disabled: disabled,
        icon: renderIcon,
        info: shortcut,
        indented: indented
      }))
    );
  }

  MenuOptionContent.propTypes = {
    /**
     * Whether this option is disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Icon that is displayed in front of the option
     */
    icon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object]),

    /**
     * Whether the content should be indented
     */
    indented: PropTypes__default['default'].bool,

    /**
     * Additional information such as shortcut or caret
     */
    info: PropTypes__default['default'].node,

    /**
     * Rendered label for the MenuOptionContent
     */
    label: PropTypes__default['default'].node.isRequired
  };
  MenuOption.propTypes = {
    /**
     * Specify the children of the MenuOption
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify whether this MenuOption is disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Whether the content should be indented (for example because it's in a group with options that have icons).
     * Is automatically set by Menu
     */
    indented: PropTypes__default['default'].bool,

    /**
     * Optional prop to specify the kind of the MenuOption
     */
    kind: PropTypes__default['default'].oneOf(['default', 'danger']),

    /**
     * Rendered label for the MenuOption
     */
    label: PropTypes__default['default'].node.isRequired,

    /**
     * Which nested level this option is located in.
     * Is automatically set by Menu
     */
    level: PropTypes__default['default'].number,

    /**
     * The onClick handler
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Rendered icon for the MenuOption.
     * Can be a React component class
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object]),

    /**
     * Rendered shortcut for the MenuOption
     */
    shortcut: PropTypes__default['default'].node
  };

  function MenuRadioGroupOptions(_ref) {
    var items = _ref.items,
        initialSelectedItem = _ref.initialSelectedItem,
        _ref$onChange = _ref.onChange,
        onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;

    var _useState = React.useState(initialSelectedItem),
        _useState2 = _slicedToArray(_useState, 2),
        selected = _useState2[0],
        setSelected = _useState2[1];

    function handleClick(option) {
      setSelected(option);
      onChange(option);
    }

    var options = items.map(function (option, i) {
      var isSelected = selected === option;
      return /*#__PURE__*/React__default['default'].createElement(MenuOption, {
        key: i,
        role: "menuitemradio",
        "aria-checked": isSelected,
        renderIcon: isSelected ? Checkmark16 : null,
        label: option,
        indented: true,
        onClick: function onClick() {
          handleClick(option);
        }
      });
    });
    return options;
  }

  MenuRadioGroupOptions.propTypes = {
    /**
     * Whether the option should be checked by default
     */
    initialSelectedItem: PropTypes__default['default'].string,

    /**
     * Array of the radio options
     */
    items: PropTypes__default['default'].arrayOf(PropTypes__default['default'].string).isRequired,

    /**
     * Callback function when selection the has been changed
     */
    onChange: PropTypes__default['default'].func
  };

  function MenuRadioGroup(_ref) {
    var items = _ref.items,
        initialSelectedItem = _ref.initialSelectedItem,
        label = _ref.label,
        _ref$onChange = _ref.onChange,
        onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;
    return /*#__PURE__*/React__default['default'].createElement(MenuGroup, {
      label: label
    }, /*#__PURE__*/React__default['default'].createElement(MenuRadioGroupOptions, {
      items: items,
      initialSelectedItem: initialSelectedItem,
      onChange: onChange
    }));
  }

  MenuRadioGroup.propTypes = {
    /**
     * Whether the option should be checked by default
     */
    initialSelectedItem: PropTypes__default['default'].string,

    /**
     * Array of the radio options
     */
    items: PropTypes__default['default'].arrayOf(PropTypes__default['default'].string).isRequired,

    /**
     * The radio group label
     */
    label: PropTypes__default['default'].string.isRequired,

    /**
     * Callback function when selection the has been changed
     */
    onChange: PropTypes__default['default'].func
  };

  function MenuSelectableItem(_ref) {
    var label = _ref.label,
        initialChecked = _ref.initialChecked,
        _ref$onChange = _ref.onChange,
        onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange;

    var _useState = React.useState(initialChecked),
        _useState2 = _slicedToArray(_useState, 2),
        checked = _useState2[0],
        setChecked = _useState2[1];

    function handleClick() {
      setChecked(!checked);
      onChange(!checked);
    }

    return /*#__PURE__*/React__default['default'].createElement(MenuOption, {
      role: "menuitemcheckbox",
      "aria-checked": checked,
      renderIcon: checked ? Checkmark16 : null,
      label: label,
      indented: true,
      onClick: handleClick
    });
  }

  MenuSelectableItem.propTypes = {
    /**
     * Whether the option should be checked by default
     */
    initialChecked: PropTypes__default['default'].bool,

    /**
     * Rendered label for the MenuOptionContent
     */
    label: PropTypes__default['default'].node.isRequired,

    /**
     * Callback function when selection the has been changed
     */
    onChange: PropTypes__default['default'].func
  };

  var prefix$1S = settings_1.prefix;
  var margin = 16; // distance to keep to body edges, in px

  var Menu = function Menu(_ref) {
    var _classnames;

    var _ref$autoclose = _ref.autoclose,
        autoclose = _ref$autoclose === void 0 ? true : _ref$autoclose,
        children = _ref.children,
        open = _ref.open,
        _ref$level = _ref.level,
        level = _ref$level === void 0 ? 1 : _ref$level,
        _ref$x = _ref.x,
        x = _ref$x === void 0 ? 0 : _ref$x,
        _ref$y = _ref.y,
        y = _ref$y === void 0 ? 0 : _ref$y,
        _ref$onClose = _ref.onClose,
        onClose = _ref$onClose === void 0 ? function () {} : _ref$onClose,
        rest = _objectWithoutProperties$2(_ref, ["autoclose", "children", "open", "level", "x", "y", "onClose"]);

    var rootRef = React.useRef(null);

    var _useState = React.useState(1),
        _useState2 = _slicedToArray(_useState, 2),
        direction = _useState2[0],
        setDirection = _useState2[1]; // 1 = to right, -1 = to left


    var _useState3 = React.useState([x, y]),
        _useState4 = _slicedToArray(_useState3, 2),
        position = _useState4[0],
        setPosition = _useState4[1];

    var _useState5 = React.useState(false),
        _useState6 = _slicedToArray(_useState5, 2),
        canBeClosed = _useState6[0],
        setCanBeClosed = _useState6[1];

    var isRootMenu = level === 1;

    function getContainerBoundaries() {
      var _document$body = document.body,
          bodyWidth = _document$body.clientWidth,
          bodyHeight = _document$body.clientHeight;
      return [margin, margin, bodyWidth - margin, bodyHeight - margin];
    }

    function getTargetBoundaries() {
      var xIsRange = _typeof(x) === 'object' && x.length === 2;
      var yIsRange = _typeof(y) === 'object' && y.length === 2;
      var targetBoundaries = [xIsRange ? x[0] : x, yIsRange ? y[0] : y, xIsRange ? x[1] : x, yIsRange ? y[1] : y];

      if (!isRootMenu) {
        var _getParentMenu, _rootRef$current;

        var _getParentMenu$getBou = (_getParentMenu = getParentMenu(rootRef === null || rootRef === void 0 ? void 0 : (_rootRef$current = rootRef.current) === null || _rootRef$current === void 0 ? void 0 : _rootRef$current.element)) === null || _getParentMenu === void 0 ? void 0 : _getParentMenu.getBoundingClientRect(),
            parentWidth = _getParentMenu$getBou.width;

        targetBoundaries[2] -= parentWidth;
      }

      var containerBoundaries = getContainerBoundaries();
      return [capWithinRange(targetBoundaries[0], containerBoundaries[0], containerBoundaries[2]), capWithinRange(targetBoundaries[1], containerBoundaries[1], containerBoundaries[3]), capWithinRange(targetBoundaries[2], containerBoundaries[0], containerBoundaries[2]), capWithinRange(targetBoundaries[3], containerBoundaries[1], containerBoundaries[3])];
    }

    function focusNode$1(node) {
      if (node) {
        var _rootRef$current2;

        resetFocus(rootRef === null || rootRef === void 0 ? void 0 : (_rootRef$current2 = rootRef.current) === null || _rootRef$current2 === void 0 ? void 0 : _rootRef$current2.element);
        focusNode(node);
      }
    }

    function handleKeyDown(event) {
      if (event.target.tagName === 'LI' && (match(event, Enter) || match(event, Space))) {
        handleClick(event);
      } else {
        event.stopPropagation();
      }

      if (match(event, Escape) || !isRootMenu && match(event, ArrowLeft)) {
        onClose();
      }

      var nodeToFocus;

      if (event.target.tagName === 'LI') {
        var currentNode = event.target;

        if (match(event, ArrowUp)) {
          nodeToFocus = getNextNode(currentNode, -1);
        } else if (match(event, ArrowDown)) {
          nodeToFocus = getNextNode(currentNode, 1);
        } else if (match(event, ArrowLeft)) {
          nodeToFocus = getParentNode(currentNode);
        }
      } else if (event.target.tagName === 'UL') {
        var validNodes = getValidNodes(event.target);

        if (validNodes.length > 0 && match(event, ArrowUp)) {
          nodeToFocus = validNodes[validNodes.length - 1];
        } else if (validNodes.length > 0 && match(event, ArrowDown)) {
          nodeToFocus = validNodes[0];
        }
      }

      focusNode$1(nodeToFocus);

      if (rest.onKeyDown) {
        rest.onKeyDown(event);
      }
    }

    function handleClick(e) {
      if (!clickedElementHasSubnodes(e) && e.target.tagName !== 'UL') {
        onClose();
      } else {
        e.stopPropagation();
      }
    }

    function handleClickOutside(e) {
      if (!clickedElementHasSubnodes(e) && open && canBeClosed && autoclose) {
        onClose();
      }
    }

    function getCorrectedPosition(preferredDirection) {
      var _rootRef$current3, _rootRef$current3$ele;

      var elementRect = rootRef === null || rootRef === void 0 ? void 0 : (_rootRef$current3 = rootRef.current) === null || _rootRef$current3 === void 0 ? void 0 : (_rootRef$current3$ele = _rootRef$current3.element) === null || _rootRef$current3$ele === void 0 ? void 0 : _rootRef$current3$ele.getBoundingClientRect();
      var elementDimensions = [elementRect.width, elementRect.height];
      var targetBoundaries = getTargetBoundaries();
      var containerBoundaries = getContainerBoundaries();

      var _getPosition = getPosition(elementDimensions, targetBoundaries, containerBoundaries, preferredDirection),
          correctedPosition = _getPosition.position,
          correctedDirection = _getPosition.direction;

      setDirection(correctedDirection);
      return correctedPosition;
    }

    React.useEffect(function () {
      setCanBeClosed(false);

      if (open) {
        var localDirection = 1;

        if (isRootMenu) {
          var _rootRef$current4, _rootRef$current4$ele;

          rootRef === null || rootRef === void 0 ? void 0 : (_rootRef$current4 = rootRef.current) === null || _rootRef$current4 === void 0 ? void 0 : (_rootRef$current4$ele = _rootRef$current4.element) === null || _rootRef$current4$ele === void 0 ? void 0 : _rootRef$current4$ele.focus();
        } else {
          var _rootRef$current5;

          var parentMenu = getParentMenu(rootRef === null || rootRef === void 0 ? void 0 : (_rootRef$current5 = rootRef.current) === null || _rootRef$current5 === void 0 ? void 0 : _rootRef$current5.element);

          if (parentMenu) {
            localDirection = Number(parentMenu.dataset.direction);
          }
        }

        var correctedPosition = getCorrectedPosition(localDirection);
        setPosition(correctedPosition);
        setCanBeClosed(true);
      } else {
        setPosition([0, 0]);
      } // eslint-disable-next-line react-hooks/exhaustive-deps

    }, [open, x, y]);
    var someNodesHaveIcons = React__default['default'].Children.toArray(children).some(function (node) {
      return node.type === MenuSelectableItem || node.type === MenuRadioGroup;
    });
    var options = React__default['default'].Children.map(children, function (node) {
      if ( /*#__PURE__*/React__default['default'].isValidElement(node)) {
        return /*#__PURE__*/React__default['default'].cloneElement(node, {
          indented: someNodesHaveIcons,
          level: level
        });
      }
    });
    var classes = classnames("".concat(prefix$1S, "--menu"), (_classnames = {}, _defineProperty$2(_classnames, "".concat(prefix$1S, "--menu--open"), open), _defineProperty$2(_classnames, "".concat(prefix$1S, "--menu--invisible"), open && position[0] === 0 && position[1] === 0), _defineProperty$2(_classnames, "".concat(prefix$1S, "--menu--root"), isRootMenu), _classnames));
    var ulAttributes = {
      className: classes,
      onKeyDown: handleKeyDown,
      onClick: handleClick,
      role: 'menu',
      tabIndex: -1,
      'data-direction': direction,
      'data-level': level,
      style: {
        left: "".concat(position[0], "px"),
        top: "".concat(position[1], "px")
      }
    };
    var childrenToRender = options; // if the only child is a radiogroup, don't render it as radiogroup component, but
    // only the items to prevent duplicate markup

    if (options && options.length === 1 && options[0].type === MenuRadioGroup) {
      var radioGroupProps = options[0].props;
      ulAttributes['aria-label'] = radioGroupProps.label;
      childrenToRender = /*#__PURE__*/React__default['default'].createElement(MenuRadioGroupOptions, {
        items: radioGroupProps.items,
        initialSelectedItem: radioGroupProps.initialSelectedItem,
        onChange: radioGroupProps.onChange
      });
    } // if the only child is a generic group, don't render it as group component, but
    // only the children to prevent duplicate markup


    if (options && options.length === 1 && options[0].type === MenuGroup) {
      var groupProps = options[0].props;
      ulAttributes['aria-label'] = groupProps.label;
      childrenToRender = React__default['default'].Children.toArray(options[0].props.children);
    }

    return /*#__PURE__*/React__default['default'].createElement(ClickListener, {
      onClickOutside: handleClickOutside,
      ref: rootRef
    }, /*#__PURE__*/React__default['default'].createElement("ul", ulAttributes, childrenToRender));
  };

  Menu.propTypes = {
    /**
     * Whether or not the menu should automatically close when
     * an outside click is registered
     */
    autoclose: PropTypes__default['default'].bool,

    /**
     * Specify the children of the Menu
     */
    children: PropTypes__default['default'].node,

    /**
     * Internal: keeps track of the nesting level of the menu
     */
    level: PropTypes__default['default'].number,

    /**
     * Function called when the menu is closed
     */
    onClose: PropTypes__default['default'].func,

    /**
     * Specify whether the Menu is currently open
     */
    open: PropTypes__default['default'].bool,

    /**
     * Specify the x position where this menu is rendered
     */
    x: PropTypes__default['default'].oneOfType([PropTypes__default['default'].number, PropTypes__default['default'].arrayOf(PropTypes__default['default'].number)]),

    /**
     * Specify the y position where this menu is rendered
     */
    y: PropTypes__default['default'].oneOfType([PropTypes__default['default'].number, PropTypes__default['default'].arrayOf(PropTypes__default['default'].number)])
  };

  var prefix$1R = settings_1.prefix;

  function MenuDivider() {
    return /*#__PURE__*/React__default['default'].createElement("li", {
      role: "separator",
      className: "".concat(prefix$1R, "--menu-divider")
    });
  }

  function MenuItem(_ref) {
    var label = _ref.label,
        children = _ref.children,
        disabled = _ref.disabled,
        kind = _ref.kind,
        shortcut = _ref.shortcut,
        rest = _objectWithoutProperties$2(_ref, ["label", "children", "disabled", "kind", "shortcut"]);

    return /*#__PURE__*/React__default['default'].createElement(MenuOption, _extends$3({}, rest, {
      label: label,
      disabled: disabled,
      kind: kind,
      shortcut: shortcut
    }), children);
  }

  MenuItem.propTypes = {
    /**
     * Specify the children of the MenuItem
     */
    children: PropTypes__default['default'].node,

    /**
     * Specify whether this MenuItem is disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Optional prop to specify the kind of the MenuItem
     */
    kind: PropTypes__default['default'].oneOf(['default', 'danger']),

    /**
     * Rendered label for the MenuItem
     */
    label: PropTypes__default['default'].node.isRequired,

    /**
     * Rendered shortcut for the MenuItem
     */
    shortcut: PropTypes__default['default'].node
  };

  Menu.MenuDivider = MenuDivider;
  Menu.MenuGroup = MenuGroup;
  Menu.MenuItem = MenuItem;
  Menu.MenuRadioGroup = MenuRadioGroup;
  Menu.MenuSelectableItem = MenuSelectableItem;

  var prefix$1Q = settings_1.prefix;

  function OverflowMenu$2(_ref) {
    var children = _ref.children,
        _ref$renderIcon = _ref.renderIcon,
        IconElement = _ref$renderIcon === void 0 ? OverflowMenuVertical16 : _ref$renderIcon,
        rest = _objectWithoutProperties$2(_ref, ["children", "renderIcon"]);

    var _useState = React.useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        open = _useState2[0],
        setOpen = _useState2[1];

    var _useState3 = React.useState([[0, 0], [0, 0]]),
        _useState4 = _slicedToArray(_useState3, 2),
        position = _useState4[0],
        setPosition = _useState4[1];

    var triggerRef = React.useRef(null);

    function openMenu() {
      if (triggerRef.current) {
        var _triggerRef$current$g = triggerRef.current.getBoundingClientRect(),
            left = _triggerRef$current$g.left,
            top = _triggerRef$current$g.top,
            right = _triggerRef$current$g.right,
            bottom = _triggerRef$current$g.bottom;

        setPosition([[left, right], [top, bottom]]);
      }

      setOpen(true);
    }

    function closeMenu() {
      setOpen(false);
    }

    function handleClick() {
      if (open) {
        closeMenu();
      } else {
        openMenu();
      }
    }

    var triggerClasses = classnames("".concat(prefix$1Q, "--overflow-menu"), _defineProperty$2({}, "".concat(prefix$1Q, "--overflow-menu--open"), open));
    return /*#__PURE__*/React__default['default'].createElement(React__default['default'].Fragment, null, /*#__PURE__*/React__default['default'].createElement("button", _extends$3({}, rest, {
      type: "button",
      "aria-haspopup": true,
      "aria-expanded": open,
      className: triggerClasses,
      onClick: handleClick,
      ref: triggerRef
    }), /*#__PURE__*/React__default['default'].createElement(IconElement, null)), /*#__PURE__*/React__default['default'].createElement(Menu, {
      open: open,
      onClose: closeMenu,
      x: position[0],
      y: position[1]
    }, children));
  }

  OverflowMenu$2.propTypes = {
    /**
     * Specify the children of the OverflowMenu
     */
    children: PropTypes__default['default'].node,

    /**
     * Function called to override icon rendering.
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object])
  };

  var invariant = function invariant(condition, format, a, b, c, d, e, f) {
    {
      if (format === undefined) {
        throw new Error('invariant requires an error message argument');
      }
    }

    if (!condition) {
      var error;

      if (format === undefined) {
        error = new Error('Minified exception occurred; use the non-minified dev environment ' + 'for the full error message and additional helpful warnings.');
      } else {
        var args = [a, b, c, d, e, f];
        var argIndex = 0;
        error = new Error(format.replace(/%s/g, function () {
          return args[argIndex++];
        }));
        error.name = 'Invariant Violation';
      }

      error.framesToPop = 1; // we don't care about invariant's own frame

      throw error;
    }
  };

  var invariant_1 = invariant;

  var lib = (typeof self === "undefined" ? "undefined" : _typeof(self)) === 'object' && self.self === self && self || _typeof(commonjsGlobal) === 'object' && commonjsGlobal.global === commonjsGlobal && commonjsGlobal || commonjsGlobal;

  // mdn resize function

  var OptimizedResize = function optimizedResize() {
    var callbacks = [];
    var running = false; // run the actual callbacks

    function runCallbacks() {
      callbacks.forEach(function (callback) {
        callback();
      });
      running = false;
    } // fired on resize event


    function resize() {
      if (!running) {
        running = true;
        lib.requestAnimationFrame(runCallbacks);
      }
    } // adds callback to loop


    function addCallback(callback) {
      if (callback) {
        var index = callbacks.indexOf(callback);

        if (index < 0) {
          callbacks.push(callback);
        }
      }
    }

    return {
      // public method to add additional callback
      add: function add(callback) {
        if (!callbacks.length) {
          lib.addEventListener('resize', resize);
        }

        addCallback(callback);
        return {
          release: function release() {
            var index = callbacks.indexOf(callback);

            if (index >= 0) {
              callbacks.splice(index, 1);
            }
          }
        };
      }
    };
  }();

  var prefix$1P = settings_1.prefix;
  /**
   * The structure for the position of floating menu.
   * @typedef {object} FloatingMenu~position
   * @property {number} left The left position.
   * @property {number} top The top position.
   * @property {number} right The right position.
   * @property {number} bottom The bottom position.
   */

  /**
   * The structure for the size of floating menu.
   * @typedef {object} FloatingMenu~size
   * @property {number} width The width.
   * @property {number} height The height.
   */

  /**
   * The structure for the position offset of floating menu.
   * @typedef {object} FloatingMenu~offset
   * @property {number} top The top position.
   * @property {number} left The left position.
   */

  /**
   * The structure for the target container.
   * @typedef {object} FloatingMenu~container
   * @property {DOMRect} rect Return of element.getBoundingClientRect()
   * @property {string} position Position style (static, absolute, relative...)
   */

  var DIRECTION_LEFT = 'left';
  var DIRECTION_TOP = 'top';
  var DIRECTION_RIGHT = 'right';
  var DIRECTION_BOTTOM = 'bottom';
  /**
   * @param {FloatingMenu~offset} [oldMenuOffset={}] The old value.
   * @param {FloatingMenu~offset} [menuOffset={}] The new value.
   * @returns `true` if the parent component wants to change in the adjustment of the floating menu position.
   * @private
   */

  var hasChangeInOffset = function hasChangeInOffset() {
    var oldMenuOffset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var menuOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if (_typeof(oldMenuOffset) !== _typeof(menuOffset)) {
      return true;
    }

    if (Object(menuOffset) === menuOffset && typeof menuOffset !== 'function') {
      return oldMenuOffset.top !== menuOffset.top || oldMenuOffset.left !== menuOffset.left;
    }

    return oldMenuOffset !== menuOffset;
  };
  /**
   * @param {object} params The parameters.
   * @param {FloatingMenu~size} params.menuSize The size of the menu.
   * @param {FloatingMenu~position} params.refPosition The position of the triggering element.
   * @param {FloatingMenu~offset} [params.offset={ left: 0, top: 0 }] The position offset of the menu.
   * @param {string} [params.direction=bottom] The menu direction.
   * @param {number} [params.scrollX=0] The scroll position of the viewport.
   * @param {number} [params.scrollY=0] The scroll position of the viewport.
   * @param {FloatingMenu~container} [params.container] The size and position type of target element.
   * @returns {FloatingMenu~offset} The position of the menu, relative to the top-left corner of the viewport.
   * @private
   */


  var getFloatingPosition = function getFloatingPosition(_ref) {
    var _DIRECTION_LEFT$DIREC;

    var menuSize = _ref.menuSize,
        _ref$refPosition = _ref.refPosition,
        refPosition = _ref$refPosition === void 0 ? {} : _ref$refPosition,
        _ref$offset = _ref.offset,
        offset = _ref$offset === void 0 ? {} : _ref$offset,
        _ref$direction = _ref.direction,
        direction = _ref$direction === void 0 ? DIRECTION_BOTTOM : _ref$direction,
        _ref$scrollX = _ref.scrollX,
        pageXOffset = _ref$scrollX === void 0 ? 0 : _ref$scrollX,
        _ref$scrollY = _ref.scrollY,
        pageYOffset = _ref$scrollY === void 0 ? 0 : _ref$scrollY,
        container = _ref.container;
    var _refPosition$left = refPosition.left,
        refLeft = _refPosition$left === void 0 ? 0 : _refPosition$left,
        _refPosition$top = refPosition.top,
        refTop = _refPosition$top === void 0 ? 0 : _refPosition$top,
        _refPosition$right = refPosition.right,
        refRight = _refPosition$right === void 0 ? 0 : _refPosition$right,
        _refPosition$bottom = refPosition.bottom,
        refBottom = _refPosition$bottom === void 0 ? 0 : _refPosition$bottom;
    var scrollX = container.position !== 'static' ? 0 : pageXOffset;
    var scrollY = container.position !== 'static' ? 0 : pageYOffset;
    var relativeDiff = {
      top: container.position !== 'static' ? container.rect.top : 0,
      left: container.position !== 'static' ? container.rect.left : 0
    };
    var width = menuSize.width,
        height = menuSize.height;
    var _offset$top = offset.top,
        top = _offset$top === void 0 ? 0 : _offset$top,
        _offset$left = offset.left,
        left = _offset$left === void 0 ? 0 : _offset$left;
    var refCenterHorizontal = (refLeft + refRight) / 2;
    var refCenterVertical = (refTop + refBottom) / 2;
    return (_DIRECTION_LEFT$DIREC = {}, _defineProperty$2(_DIRECTION_LEFT$DIREC, DIRECTION_LEFT, function () {
      return {
        left: refLeft - width + scrollX - left - relativeDiff.left,
        top: refCenterVertical - height / 2 + scrollY + top - 9 - relativeDiff.top
      };
    }), _defineProperty$2(_DIRECTION_LEFT$DIREC, DIRECTION_TOP, function () {
      return {
        left: refCenterHorizontal - width / 2 + scrollX + left - relativeDiff.left,
        top: refTop - height + scrollY - top - relativeDiff.top
      };
    }), _defineProperty$2(_DIRECTION_LEFT$DIREC, DIRECTION_RIGHT, function () {
      return {
        left: refRight + scrollX + left - relativeDiff.left,
        top: refCenterVertical - height / 2 + scrollY + top + 3 - relativeDiff.top
      };
    }), _defineProperty$2(_DIRECTION_LEFT$DIREC, DIRECTION_BOTTOM, function () {
      return {
        left: refCenterHorizontal - width / 2 + scrollX + left - relativeDiff.left,
        top: refBottom + scrollY + top - relativeDiff.top
      };
    }), _DIRECTION_LEFT$DIREC)[direction]();
  };
  /**
   * A menu that is detached from the triggering element.
   * Useful when the container of the triggering element cannot have `overflow:visible` style, etc.
   */


  var FloatingMenu = /*#__PURE__*/function (_React$Component) {
    _inherits(FloatingMenu, _React$Component);

    var _super = _createSuper(FloatingMenu);

    function FloatingMenu() {
      var _this;

      _classCallCheck(this, FloatingMenu);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "_placeInProgress", false);

      _defineProperty$2(_assertThisInitialized$1(_this), "state", {
        /**
         * The position of the menu, relative to the top-left corner of the viewport.
         * @type {FloatingMenu~offset}
         */
        floatingPosition: undefined
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "_menuContainer", null);

      _defineProperty$2(_assertThisInitialized$1(_this), "_menuBody", null);

      _defineProperty$2(_assertThisInitialized$1(_this), "startSentinel", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "endSentinel", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "_updateMenuSize", function () {
        var prevProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var menuBody = _this._menuBody;
        warning(menuBody, 'The DOM node for menu body for calculating its position is not available. Skipping...') ;

        if (!menuBody) {
          return;
        }

        var _prevProps$menuOffset = prevProps.menuOffset,
            oldMenuOffset = _prevProps$menuOffset === void 0 ? {} : _prevProps$menuOffset,
            oldMenuDirection = prevProps.menuDirection;
        var _this$props = _this.props,
            _this$props$menuOffse = _this$props.menuOffset,
            menuOffset = _this$props$menuOffse === void 0 ? {} : _this$props$menuOffse,
            menuDirection = _this$props.menuDirection;

        if (hasChangeInOffset(oldMenuOffset, menuOffset) || oldMenuDirection !== menuDirection) {
          var _this$props2 = _this.props,
              flipped = _this$props2.flipped,
              triggerRef = _this$props2.triggerRef;
          var triggerEl = triggerRef.current;
          var menuSize = menuBody.getBoundingClientRect();
          var refPosition = triggerEl && triggerEl.getBoundingClientRect();
          var offset = typeof menuOffset !== 'function' ? menuOffset : menuOffset(menuBody, menuDirection, triggerEl, flipped); // Skips if either in the following condition:
          // a) Menu body has `display:none`
          // b) `menuOffset` as a callback returns `undefined` (The callback saw that it couldn't calculate the value)

          if (menuSize.width > 0 && menuSize.height > 0 || !offset) {
            _this.setState({
              floatingPosition: getFloatingPosition({
                menuSize: menuSize,
                refPosition: refPosition,
                direction: menuDirection,
                offset: offset,
                scrollX: lib.pageXOffset,
                scrollY: lib.pageYOffset,
                container: {
                  rect: _this.props.target().getBoundingClientRect(),
                  position: getComputedStyle(_this.props.target()).position
                }
              })
            });
          }
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "_focusMenuContent", function (menuBody) {
        var primaryFocusNode = menuBody.querySelector(_this.props.selectorPrimaryFocus || null);
        var tabbableNode = menuBody.querySelector(selectorTabbable);
        var focusableNode = menuBody.querySelector(selectorFocusable);
        var focusTarget = primaryFocusNode || // User defined focusable node
        tabbableNode || // First sequentially focusable node
        focusableNode || // First programmatic focusable node
        menuBody;

        if (_this.props.focusTrap) {
          focusTarget.focus();
        }

        if (focusTarget === menuBody && "development" !== "production") {
          warning(focusableNode === null, 'Floating Menus must have at least a programmatically focusable child. ' + 'This can be accomplished by adding tabIndex="-1" to the content element.') ;
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "_menuRef", function (menuBody) {
        var menuRef = _this.props.menuRef;
        _this._placeInProgress = !!menuBody;
        menuRef && menuRef(_this._menuBody = menuBody);

        if (menuBody) {
          _this._updateMenuSize();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "_getChildrenWithProps", function () {
        var _this$props3 = _this.props,
            styles = _this$props3.styles,
            children = _this$props3.children;
        var pos = _this.state.floatingPosition; // If no pos available, we need to hide the element (offscreen to the left)
        // This is done so we can measure the content before positioning it correctly.

        var positioningStyle = pos ? {
          left: "".concat(pos.left, "px"),
          top: "".concat(pos.top, "px"),
          right: 'auto'
        } : {
          visibility: 'hidden',
          top: '0px'
        };
        return /*#__PURE__*/React__default['default'].cloneElement(children, {
          ref: _this._menuRef,
          style: _objectSpread2$2(_objectSpread2$2(_objectSpread2$2({}, styles), positioningStyle), {}, {
            position: 'absolute',
            opacity: 1
          })
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleBlur", function (_ref2) {
        var oldActiveNode = _ref2.target,
            currentActiveNode = _ref2.relatedTarget;

        if (currentActiveNode && oldActiveNode) {
          var startSentinelNode = _this.startSentinel.current;
          var endSentinelNode = _this.endSentinel.current;
          wrapFocus({
            bodyNode: _this._menuBody,
            startSentinelNode: startSentinelNode,
            endSentinelNode: endSentinelNode,
            currentActiveNode: currentActiveNode,
            oldActiveNode: oldActiveNode
          });
        }
      });

      return _this;
    }

    _createClass(FloatingMenu, [{
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.hResize.release();
      }
    }, {
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this2 = this;

        this.hResize = OptimizedResize.add(function () {
          _this2._updateMenuSize();
        });
      }
      /**
       * Set focus on floating menu content after menu placement.
       * @param {Element} menuBody The DOM element of the menu body.
       * @private
       */

    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        this._updateMenuSize(prevProps);

        var onPlace = this.props.onPlace;

        if (this._placeInProgress && this.state.floatingPosition) {
          if (this._menuBody && !this._menuBody.contains(document.activeElement)) {
            this._focusMenuContent(this._menuBody);
          }

          if (typeof onPlace === 'function') {
            onPlace(this._menuBody);
            this._placeInProgress = false;
          }
        }
      }
      /**
       * A callback for called when menu body is mounted or unmounted.
       * @param {Element} menuBody The menu body being mounted. `null` if the menu body is being unmounted.
       */

    }, {
      key: "render",
      value: function render() {
        if (typeof document !== 'undefined') {
          var _this$props4 = this.props,
              focusTrap = _this$props4.focusTrap,
              target = _this$props4.target;
          return /*#__PURE__*/ReactDOM__default['default'].createPortal( /*#__PURE__*/React__default['default'].createElement("div", {
            onBlur: focusTrap ? this.handleBlur : null
          }, /*#__PURE__*/React__default['default'].createElement("span", {
            ref: this.startSentinel,
            tabIndex: "0",
            role: "link",
            className: "".concat(prefix$1P, "--visually-hidden")
          }, "Focus sentinel"), this._getChildrenWithProps(), /*#__PURE__*/React__default['default'].createElement("span", {
            ref: this.endSentinel,
            tabIndex: "0",
            role: "link",
            className: "".concat(prefix$1P, "--visually-hidden")
          }, "Focus sentinel")), !target ? document.body : target());
        }

        return null;
      }
    }]);

    return FloatingMenu;
  }(React__default['default'].Component);

  _defineProperty$2(FloatingMenu, "propTypes", {
    /**
     * Contents to put into the floating menu.
     */
    children: PropTypes__default['default'].object,

    /**
     * `true` if the menu alignment should be flipped.
     */
    flipped: PropTypes__default['default'].bool,

    /**
     * Enable or disable focus trap behavior
     */
    focusTrap: PropTypes__default['default'].bool,

    /**
     * Where to put the tooltip, relative to the trigger button.
     */
    menuDirection: PropTypes__default['default'].oneOf([DIRECTION_LEFT, DIRECTION_TOP, DIRECTION_RIGHT, DIRECTION_BOTTOM]),

    /**
     * The adjustment of the floating menu position, considering the position of dropdown arrow, etc.
     */
    menuOffset: PropTypes__default['default'].oneOfType([PropTypes__default['default'].shape({
      top: PropTypes__default['default'].number,
      left: PropTypes__default['default'].number
    }), PropTypes__default['default'].func]),

    /**
     * The callback called when the menu body has been mounted to/will be unmounted from the DOM.
     */
    menuRef: PropTypes__default['default'].func,

    /**
     * The callback called when the menu body has been mounted and positioned.
     */
    onPlace: PropTypes__default['default'].func,

    /**
     * Specify a CSS selector that matches the DOM element that should
     * be focused when the Modal opens
     */
    selectorPrimaryFocus: PropTypes__default['default'].string,

    /**
     * The additional styles to put to the floating menu.
     */
    styles: PropTypes__default['default'].object,

    /**
     * The query selector indicating where the floating menu body should be placed.
     */
    target: PropTypes__default['default'].func,

    /**
     * The element ref of the tooltip's trigger button.
     */
    triggerRef: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].shape({
      current: PropTypes__default['default'].any
    })])
  });

  _defineProperty$2(FloatingMenu, "defaultProps", {
    menuOffset: {},
    menuDirection: DIRECTION_BOTTOM
  });

  var _triggerButtonPositio, _triggerButtonPositio2;
  var prefix$1O = settings_1.prefix;

  var on = function on(element) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    element.addEventListener.apply(element, args);
    return {
      release: function release() {
        element.removeEventListener.apply(element, args);
        return null;
      }
    };
  };
  /**
   * The CSS property names of the arrow keyed by the floating menu direction.
   * @type {object<string, string>}
   */


  var triggerButtonPositionProps = (_triggerButtonPositio = {}, _defineProperty$2(_triggerButtonPositio, DIRECTION_TOP, 'bottom'), _defineProperty$2(_triggerButtonPositio, DIRECTION_BOTTOM, 'top'), _triggerButtonPositio);
  /**
   * Determines how the position of arrow should affect the floating menu position.
   * @type {object<string, number>}
   */

  var triggerButtonPositionFactors = (_triggerButtonPositio2 = {}, _defineProperty$2(_triggerButtonPositio2, DIRECTION_TOP, -2), _defineProperty$2(_triggerButtonPositio2, DIRECTION_BOTTOM, -1), _triggerButtonPositio2);
  /**
   * @param {Element} menuBody The menu body with the menu arrow.
   * @param {string} direction The floating menu direction.
   * @returns {FloatingMenu~offset} The adjustment of the floating menu position, upon the position of the menu arrow.
   * @private
   */

  var getMenuOffset$1 = function getMenuOffset(menuBody, direction, trigger, flip) {
    var triggerButtonPositionProp = triggerButtonPositionProps[direction];
    var triggerButtonPositionFactor = triggerButtonPositionFactors[direction];

    {
      !(triggerButtonPositionProp && triggerButtonPositionFactor) ? invariant_1(false, '[OverflowMenu] wrong floating menu direction: `%s`', direction)  : void 0;
    }

    var menuWidth = menuBody.offsetWidth,
        menuHeight = menuBody.offsetHeight;

    switch (triggerButtonPositionProp) {
      case 'top':
      case 'bottom':
        {
          // TODO: Ensure `trigger` is there for `<OverflowMenu open>`
          var triggerWidth = !trigger ? 0 : trigger.offsetWidth;
          return {
            left: (!flip ? 1 : -1) * (menuWidth / 2 - triggerWidth / 2),
            top: 0
          };
        }

      case 'left':
      case 'right':
        {
          // TODO: Ensure `trigger` is there for `<OverflowMenu open>`
          var triggerHeight = !trigger ? 0 : trigger.offsetHeight;
          return {
            left: 0,
            top: (!flip ? 1 : -1) * (menuHeight / 2 - triggerHeight / 2)
          };
        }
    }
  };

  var OverflowMenu$1 = /*#__PURE__*/function (_Component) {
    _inherits(OverflowMenu, _Component);

    var _super = _createSuper(OverflowMenu);

    function OverflowMenu() {
      var _this;

      _classCallCheck(this, OverflowMenu);

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "state", {});

      _defineProperty$2(_assertThisInitialized$1(_this), "_hFocusIn", null);

      _defineProperty$2(_assertThisInitialized$1(_this), "_hBlurTimeout", void 0);

      _defineProperty$2(_assertThisInitialized$1(_this), "_triggerRef", /*#__PURE__*/React__default['default'].createRef());

      _defineProperty$2(_assertThisInitialized$1(_this), "handleClick", function (evt) {
        if (!_this._menuBody || !_this._menuBody.contains(evt.target)) {
          _this.setState({
            open: !_this.state.open
          });

          _this.props.onClick(evt);
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleKeyDown", function (evt) {
        if (matches(evt, [ArrowDown])) {
          _this.setState({
            open: !_this.state.open
          });

          _this.props.onClick(evt);
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleKeyPress", function (evt) {
        if (_this.state.open && matches(evt, [ArrowUp, ArrowRight, ArrowDown, ArrowLeft])) {
          evt.preventDefault();
        } // Close the overflow menu on escape


        if (matches(evt, [Escape])) {
          var wasOpen = _this.state.open;

          _this.closeMenu(function () {
            if (wasOpen) {
              _this.focusMenuEl();
            }
          }); // Stop the esc keypress from bubbling out and closing something it shouldn't


          evt.stopPropagation();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleClickOutside", function (evt) {
        if (_this.state.open && (!_this._menuBody || !_this._menuBody.contains(evt.target))) {
          _this.closeMenu();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "closeMenu", function (onCloseMenu) {
        _this.setState({
          open: false
        }, function () {
          // Optional callback to be executed after the state as been set to close
          if (onCloseMenu) {
            onCloseMenu();
          }

          _this.props.onClose();
        });
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "focusMenuEl", function () {
        var triggerEl = _this._triggerRef.current;

        if (triggerEl) {
          triggerEl.focus();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "handleOverflowMenuItemFocus", function (_ref) {
        var _overflowMenuItem$cur;

        var currentIndex = _ref.currentIndex,
            direction = _ref.direction;
        var enabledIndices = React__default['default'].Children.toArray(_this.props.children).reduce(function (acc, curr, i) {
          if (!curr.props.disabled) {
            acc.push(i);
          }

          return acc;
        }, []);

        var nextValidIndex = function () {
          var nextIndex = enabledIndices.indexOf(currentIndex) + direction;

          switch (enabledIndices.indexOf(currentIndex) + direction) {
            case -1:
              return enabledIndices.length - 1;

            case enabledIndices.length:
              return 0;

            default:
              return nextIndex;
          }
        }();

        var overflowMenuItem = _this["overflowMenuItem".concat(enabledIndices[nextValidIndex])].overflowMenuItem;

        overflowMenuItem === null || overflowMenuItem === void 0 ? void 0 : (_overflowMenuItem$cur = overflowMenuItem.current) === null || _overflowMenuItem$cur === void 0 ? void 0 : _overflowMenuItem$cur.focus();
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "_bindMenuBody", function (menuBody) {
        if (!menuBody) {
          _this._menuBody = menuBody;
        }

        if (!menuBody && _this._hFocusIn) {
          _this._hFocusIn = _this._hFocusIn.release();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "_handlePlace", function (menuBody) {
        if (menuBody) {
          _this._menuBody = menuBody;
          var hasFocusin = ('onfocusin' in window);
          var focusinEventName = hasFocusin ? 'focusin' : 'focus';
          _this._hFocusIn = on(menuBody.ownerDocument, focusinEventName, function (event) {
            var target = ClickListener.getEventTarget(event);
            var triggerEl = _this._triggerRef.current;

            if (typeof target.matches === 'function') {
              if (!menuBody.contains(target) && triggerEl && !target.matches(".".concat(prefix$1O, "--overflow-menu,.").concat(prefix$1O, "--overflow-menu-options"))) {
                _this.closeMenu();
              }
            }
          }, !hasFocusin);

          _this.props.onOpen();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "_getTarget", function () {
        var triggerEl = _this._triggerRef.current;
        return triggerEl && triggerEl.closest('[data-floating-menu-container]') || document.body;
      });

      return _this;
    }

    _createClass(OverflowMenu, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(_, prevState) {
        var onClose = this.props.onClose;

        if (!this.state.open && prevState.open) {
          onClose();
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        if (typeof this._hBlurTimeout === 'number') {
          clearTimeout(this._hBlurTimeout);
          this._hBlurTimeout = undefined;
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames,
            _classNames2,
            _this2 = this;

        var _this$props = this.props,
            id = _this$props.id,
            ariaLabel = _this$props.ariaLabel,
            children = _this$props.children,
            iconDescription = _this$props.iconDescription,
            direction = _this$props.direction,
            flipped = _this$props.flipped,
            menuOffset = _this$props.menuOffset,
            menuOffsetFlip = _this$props.menuOffsetFlip,
            iconClass = _this$props.iconClass;
            _this$props.onClick;
            _this$props.onOpen;
            _this$props.selectorPrimaryFocus;
            var IconElement = _this$props.renderIcon,
            ref = _this$props.innerRef,
            menuOptionsClass = _this$props.menuOptionsClass,
            light = _this$props.light,
            size = _this$props.size,
            other = _objectWithoutProperties$2(_this$props, ["id", "ariaLabel", "children", "iconDescription", "direction", "flipped", "menuOffset", "menuOffsetFlip", "iconClass", "onClick", "onOpen", "selectorPrimaryFocus", "renderIcon", "innerRef", "menuOptionsClass", "light", "size"]);

        var open = this.state.open;
        var overflowMenuClasses = classnames(this.props.className, "".concat(prefix$1O, "--overflow-menu"), (_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$1O, "--overflow-menu--open"), open), _defineProperty$2(_classNames, "".concat(prefix$1O, "--overflow-menu--light"), light), _defineProperty$2(_classNames, "".concat(prefix$1O, "--overflow-menu--").concat(size), size), _classNames));
        var overflowMenuOptionsClasses = classnames(menuOptionsClass, "".concat(prefix$1O, "--overflow-menu-options"), (_classNames2 = {}, _defineProperty$2(_classNames2, "".concat(prefix$1O, "--overflow-menu--flip"), this.props.flipped), _defineProperty$2(_classNames2, "".concat(prefix$1O, "--overflow-menu-options--open"), open), _defineProperty$2(_classNames2, "".concat(prefix$1O, "--overflow-menu-options--light"), light), _defineProperty$2(_classNames2, "".concat(prefix$1O, "--overflow-menu-options--").concat(size), size), _classNames2));
        var overflowMenuIconClasses = classnames("".concat(prefix$1O, "--overflow-menu__icon"), iconClass);
        var childrenWithProps = React__default['default'].Children.toArray(children).map(function (child, index) {
          var _child$props;

          return /*#__PURE__*/React__default['default'].cloneElement(child, {
            closeMenu: (child === null || child === void 0 ? void 0 : (_child$props = child.props) === null || _child$props === void 0 ? void 0 : _child$props.closeMenu) || _this2.closeMenu,
            handleOverflowMenuItemFocus: _this2.handleOverflowMenuItemFocus,
            ref: function ref(e) {
              _this2["overflowMenuItem".concat(index)] = e;
            },
            index: index
          });
        });
        var menuBody = /*#__PURE__*/React__default['default'].createElement("ul", {
          className: overflowMenuOptionsClasses,
          tabIndex: "-1",
          role: "menu",
          "aria-label": ariaLabel
        }, childrenWithProps);
        var wrappedMenuBody = /*#__PURE__*/React__default['default'].createElement(FloatingMenu, {
          focusTrap: true,
          triggerRef: this._triggerRef,
          menuDirection: direction,
          menuOffset: flipped ? menuOffsetFlip : menuOffset,
          menuRef: this._bindMenuBody,
          flipped: this.props.flipped,
          target: this._getTarget,
          onPlace: this._handlePlace,
          selectorPrimaryFocus: this.props.selectorPrimaryFocus
        }, /*#__PURE__*/React__default['default'].cloneElement(menuBody, {
          'data-floating-menu-direction': direction
        }));
        var iconProps = {
          onClick: this.handleClick,
          onKeyDown: this.handleKeyDown,
          className: overflowMenuIconClasses,
          'aria-label': iconDescription
        };
        return /*#__PURE__*/React__default['default'].createElement(ClickListener, {
          onClickOutside: this.handleClickOutside
        }, /*#__PURE__*/React__default['default'].createElement("button", _extends$3({}, other, {
          type: "button",
          "aria-haspopup": true,
          "aria-expanded": this.state.open,
          className: overflowMenuClasses,
          onKeyDown: this.handleKeyPress,
          onClick: this.handleClick,
          "aria-label": ariaLabel,
          id: id,
          ref: mergeRefs(this._triggerRef, ref)
        }), /*#__PURE__*/React__default['default'].createElement(IconElement, iconProps, iconDescription && /*#__PURE__*/React__default['default'].createElement("title", null, iconDescription)), open && wrappedMenuBody));
      }
    }], [{
      key: "getDerivedStateFromProps",
      value: function getDerivedStateFromProps(_ref2, state) {
        var open = _ref2.open;
        var prevOpen = state.prevOpen;
        return prevOpen === open ? null : {
          open: open,
          prevOpen: open
        };
      }
    }]);

    return OverflowMenu;
  }(React.Component);

  _defineProperty$2(OverflowMenu$1, "propTypes", {
    /**
     * The ARIA label.
     */
    ariaLabel: PropTypes__default['default'].string,

    /**
     * The child nodes.
     */
    children: PropTypes__default['default'].node,

    /**
     * The CSS class names.
     */
    className: PropTypes__default['default'].string,

    /**
     * The menu direction.
     */
    direction: PropTypes__default['default'].oneOf([DIRECTION_TOP, DIRECTION_BOTTOM]),

    /**
     * `true` if the menu alignment should be flipped.
     */
    flipped: PropTypes__default['default'].bool,

    /**
     * The CSS class for the icon.
     */
    iconClass: PropTypes__default['default'].string,

    /**
     * The icon description.
     */
    iconDescription: PropTypes__default['default'].string.isRequired,

    /**
     * The element ID.
     */
    id: PropTypes__default['default'].string,

    /**
     * `true` to use the light version. For use on $ui-01 backgrounds only.
     * Don't use this to make OverflowMenu background color same as container background color.
     */
    light: PropTypes__default['default'].bool,

    /**
     * The adjustment in position applied to the floating menu.
     */
    menuOffset: PropTypes__default['default'].oneOfType([PropTypes__default['default'].shape({
      top: PropTypes__default['default'].number,
      left: PropTypes__default['default'].number
    }), PropTypes__default['default'].func]),

    /**
     * The adjustment in position applied to the floating menu.
     */
    menuOffsetFlip: PropTypes__default['default'].oneOfType([PropTypes__default['default'].shape({
      top: PropTypes__default['default'].number,
      left: PropTypes__default['default'].number
    }), PropTypes__default['default'].func]),

    /**
     * The class to apply to the menu options
     */
    menuOptionsClass: PropTypes__default['default'].string,

    /**
     * The event handler for the `click` event.
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Function called when menu is closed
     */
    onClose: PropTypes__default['default'].func,

    /**
     * The event handler for the `focus` event.
     */
    onFocus: PropTypes__default['default'].func,

    /**
     * The event handler for the `keydown` event.
     */
    onKeyDown: PropTypes__default['default'].func,

    /**
     * Function called when menu is opened
     */
    onOpen: PropTypes__default['default'].func,

    /**
     * `true` if the menu should be open.
     */
    open: PropTypes__default['default'].bool,

    /**
     * Function called to override icon rendering.
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object]),

    /**
     * Specify a CSS selector that matches the DOM element that should
     * be focused when the OverflowMenu opens
     */
    selectorPrimaryFocus: PropTypes__default['default'].string,

    /**
     * Specify the size of the OverflowMenu. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
     * TODO V11: remove `xl` (replaced with lg)
     */
    size: PropTypes__default['default'].oneOf(['sm', 'md', 'lg', 'xl'])
  });

  _defineProperty$2(OverflowMenu$1, "defaultProps", {
    ariaLabel: 'open and close list of options',
    iconDescription: 'open and close list of options',
    open: false,
    direction: DIRECTION_BOTTOM,
    flipped: false,
    renderIcon: OverflowMenuVertical16,
    onClick: function onClick() {},
    onKeyDown: function onKeyDown() {},
    onClose: function onClose() {},
    onOpen: function onOpen() {},
    menuOffset: getMenuOffset$1,
    menuOffsetFlip: getMenuOffset$1,
    light: false,
    selectorPrimaryFocus: '[data-overflow-menu-primary-focus]'
  });
  var OverflowMenuClassic = (function () {
    var forwardRef = function forwardRef(props, ref) {
      return /*#__PURE__*/React__default['default'].createElement(OverflowMenu$1, _extends$3({}, props, {
        innerRef: ref
      }));
    };

    forwardRef.displayName = 'OverflowMenu';
    return /*#__PURE__*/React__default['default'].forwardRef(forwardRef);
  })();

  function createComponentToggle(spec) {
    var name = spec.name,
        _spec$flag = spec.flag,
        flag = _spec$flag === void 0 ? 'enable-v11-release' : _spec$flag,
        next = spec.next,
        classic = spec.classic;

    function ComponentToggle(props, ref) {
      var enabled = useFeatureFlag(flag);

      if (enabled) {
        if (next) {
          return /*#__PURE__*/React__default['default'].createElement(next, _objectSpread2$2(_objectSpread2$2({}, props), {}, {
            ref: ref
          }));
        } else {
          return null;
        }
      }

      return /*#__PURE__*/React__default['default'].createElement(classic, _objectSpread2$2(_objectSpread2$2({}, props), {}, {
        ref: ref
      }));
    }

    ComponentToggle.displayName = "FeatureToggle(".concat(name, ")");
    return /*#__PURE__*/React__default['default'].forwardRef(ComponentToggle);
  }

  var OverflowMenu = createComponentToggle({
    name: 'OverflowMenu',
    next: OverflowMenu$2,
    classic: OverflowMenuClassic
  });

  var prefix$1N = settings_1.prefix;

  var TableToolbarMenu = function TableToolbarMenu(_ref) {
    var className = _ref.className,
        renderIcon = _ref.renderIcon,
        iconDescription = _ref.iconDescription,
        children = _ref.children,
        rest = _objectWithoutProperties$2(_ref, ["className", "renderIcon", "iconDescription", "children"]);

    var toolbarActionClasses = classnames(className, "".concat(prefix$1N, "--toolbar-action ").concat(prefix$1N, "--overflow-menu"));
    return /*#__PURE__*/React__default['default'].createElement(OverflowMenu, _extends$3({
      ariaLabel: iconDescription,
      renderIcon: renderIcon,
      className: toolbarActionClasses,
      title: iconDescription,
      iconDescription: iconDescription,
      flipped: true
    }, rest), children);
  };

  TableToolbarMenu.defaultProps = {
    renderIcon: Settings16,
    iconDescription: 'Settings'
  };
  TableToolbarMenu.propTypes = {
    children: PropTypes__default['default'].node.isRequired,

    /**
     * Provide an optional class name for the toolbar menu
     */
    className: PropTypes__default['default'].string,

    /**
     * The description of the menu icon.
     */
    iconDescription: PropTypes__default['default'].string.isRequired,

    /**
     * Optional prop to allow overriding the default menu icon
     */
    renderIcon: PropTypes__default['default'].oneOfType([PropTypes__default['default'].func, PropTypes__default['default'].object])
  };

  DataTable.Table = Table;
  DataTable.TableActionList = TableActionList;
  DataTable.TableBatchAction = TableBatchAction;
  DataTable.TableBatchActions = TableBatchActions;
  DataTable.TableBody = TableBody;
  DataTable.TableCell = TableCell;
  DataTable.TableContainer = TableContainer;
  DataTable.TableExpandHeader = TableExpandHeader;
  DataTable.TableExpandRow = TableExpandRow;
  DataTable.TableExpandedRow = TableExpandedRow;
  DataTable.TableHead = TableHead;
  DataTable.TableHeader = TableHeader;
  DataTable.TableRow = TableRow;
  DataTable.TableSelectAll = TableSelectAll;
  DataTable.TableSelectRow = TableSelectRow;
  DataTable.TableToolbar = TableToolbar;
  DataTable.TableToolbarAction = TableToolbarAction;
  DataTable.TableToolbarContent = TableToolbarContent;
  DataTable.TableToolbarSearch = TableToolbarSearch;
  DataTable.TableToolbarMenu = TableToolbarMenu;

  var prefix$1M = settings_1.prefix;

  var DatePickerSkeleton = function DatePickerSkeleton(_ref) {
    var range = _ref.range,
        id = _ref.id,
        className = _ref.className,
        rest = _objectWithoutProperties$2(_ref, ["range", "id", "className"]);

    var dateInput = /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$1M, "--date-picker-container")
    },
    /*#__PURE__*/

    /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
    React__default['default'].createElement("label", {
      className: "".concat(prefix$1M, "--label"),
      htmlFor: id
    }), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$1M, "--date-picker__input ").concat(prefix$1M, "--skeleton")
    }));

    if (range) {
      return /*#__PURE__*/React__default['default'].createElement("div", {
        className: "".concat(prefix$1M, "--form-item")
      }, /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
        className: classnames("".concat(prefix$1M, "--date-picker"), "".concat(prefix$1M, "--date-picker--range"), "".concat(prefix$1M, "--skeleton"), className)
      }, rest), dateInput, dateInput));
    }

    return /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$1M, "--form-item")
    }, /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: classnames("".concat(prefix$1M, "--date-picker"), "".concat(prefix$1M, "--date-picker--short"), "".concat(prefix$1M, "--date-picker--simple"), "".concat(prefix$1M, "--skeleton"), className)
    }, rest), dateInput));
  };

  DatePickerSkeleton.propTypes = {
    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify the id to add.
     */
    id: PropTypes__default['default'].string,

    /**
     * Specify whether the skeleton should be of range date picker.
     */
    range: PropTypes__default['default'].bool
  };

  const HOOKS = [
      "onChange",
      "onClose",
      "onDayCreate",
      "onDestroy",
      "onKeyDown",
      "onMonthChange",
      "onOpen",
      "onParseConfig",
      "onReady",
      "onValueUpdate",
      "onYearChange",
      "onPreCalendarPosition",
  ];
  const defaults = {
      _disable: [],
      allowInput: false,
      allowInvalidPreload: false,
      altFormat: "F j, Y",
      altInput: false,
      altInputClass: "form-control input",
      animate: typeof window === "object" &&
          window.navigator.userAgent.indexOf("MSIE") === -1,
      ariaDateFormat: "F j, Y",
      autoFillDefaultTime: true,
      clickOpens: true,
      closeOnSelect: true,
      conjunction: ", ",
      dateFormat: "Y-m-d",
      defaultHour: 12,
      defaultMinute: 0,
      defaultSeconds: 0,
      disable: [],
      disableMobile: false,
      enableSeconds: false,
      enableTime: false,
      errorHandler: (err) => typeof console !== "undefined" && console.warn(err),
      getWeek: (givenDate) => {
          const date = new Date(givenDate.getTime());
          date.setHours(0, 0, 0, 0);
          date.setDate(date.getDate() + 3 - ((date.getDay() + 6) % 7));
          var week1 = new Date(date.getFullYear(), 0, 4);
          return (1 +
              Math.round(((date.getTime() - week1.getTime()) / 86400000 -
                  3 +
                  ((week1.getDay() + 6) % 7)) /
                  7));
      },
      hourIncrement: 1,
      ignoredFocusElements: [],
      inline: false,
      locale: "default",
      minuteIncrement: 5,
      mode: "single",
      monthSelectorType: "dropdown",
      nextArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",
      noCalendar: false,
      now: new Date(),
      onChange: [],
      onClose: [],
      onDayCreate: [],
      onDestroy: [],
      onKeyDown: [],
      onMonthChange: [],
      onOpen: [],
      onParseConfig: [],
      onReady: [],
      onValueUpdate: [],
      onYearChange: [],
      onPreCalendarPosition: [],
      plugins: [],
      position: "auto",
      positionElement: undefined,
      prevArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",
      shorthandCurrentMonth: false,
      showMonths: 1,
      static: false,
      time_24hr: false,
      weekNumbers: false,
      wrap: false,
  };

  const english = {
      weekdays: {
          shorthand: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
          longhand: [
              "Sunday",
              "Monday",
              "Tuesday",
              "Wednesday",
              "Thursday",
              "Friday",
              "Saturday",
          ],
      },
      months: {
          shorthand: [
              "Jan",
              "Feb",
              "Mar",
              "Apr",
              "May",
              "Jun",
              "Jul",
              "Aug",
              "Sep",
              "Oct",
              "Nov",
              "Dec",
          ],
          longhand: [
              "January",
              "February",
              "March",
              "April",
              "May",
              "June",
              "July",
              "August",
              "September",
              "October",
              "November",
              "December",
          ],
      },
      daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
      firstDayOfWeek: 0,
      ordinal: (nth) => {
          const s = nth % 100;
          if (s > 3 && s < 21)
              return "th";
          switch (s % 10) {
              case 1:
                  return "st";
              case 2:
                  return "nd";
              case 3:
                  return "rd";
              default:
                  return "th";
          }
      },
      rangeSeparator: " to ",
      weekAbbreviation: "Wk",
      scrollTitle: "Scroll to increment",
      toggleTitle: "Click to toggle",
      amPM: ["AM", "PM"],
      yearAriaLabel: "Year",
      monthAriaLabel: "Month",
      hourAriaLabel: "Hour",
      minuteAriaLabel: "Minute",
      time_24hr: false,
  };

  const pad = (number, length = 2) => `000${number}`.slice(length * -1);
  const int = (bool) => (bool === true ? 1 : 0);
  function debounce$1(fn, wait) {
      let t;
      return function () {
          clearTimeout(t);
          t = setTimeout(() => fn.apply(this, arguments), wait);
      };
  }
  const arrayify = (obj) => obj instanceof Array ? obj : [obj];

  function toggleClass(elem, className, bool) {
      if (bool === true)
          return elem.classList.add(className);
      elem.classList.remove(className);
  }
  function createElement(tag, className, content) {
      const e = window.document.createElement(tag);
      className = className || "";
      content = content || "";
      e.className = className;
      if (content !== undefined)
          e.textContent = content;
      return e;
  }
  function clearNode(node) {
      while (node.firstChild)
          node.removeChild(node.firstChild);
  }
  function findParent(node, condition) {
      if (condition(node))
          return node;
      else if (node.parentNode)
          return findParent(node.parentNode, condition);
      return undefined;
  }
  function createNumberInput(inputClassName, opts) {
      const wrapper = createElement("div", "numInputWrapper"), numInput = createElement("input", "numInput " + inputClassName), arrowUp = createElement("span", "arrowUp"), arrowDown = createElement("span", "arrowDown");
      if (navigator.userAgent.indexOf("MSIE 9.0") === -1) {
          numInput.type = "number";
      }
      else {
          numInput.type = "text";
          numInput.pattern = "\\d*";
      }
      if (opts !== undefined)
          for (const key in opts)
              numInput.setAttribute(key, opts[key]);
      wrapper.appendChild(numInput);
      wrapper.appendChild(arrowUp);
      wrapper.appendChild(arrowDown);
      return wrapper;
  }
  function getEventTarget(event) {
      try {
          if (typeof event.composedPath === "function") {
              const path = event.composedPath();
              return path[0];
          }
          return event.target;
      }
      catch (error) {
          return event.target;
      }
  }

  const doNothing = () => undefined;
  const monthToStr$1 = (monthNumber, shorthand, locale) => locale.months[shorthand ? "shorthand" : "longhand"][monthNumber];
  const revFormat = {
      D: doNothing,
      F: function (dateObj, monthName, locale) {
          dateObj.setMonth(locale.months.longhand.indexOf(monthName));
      },
      G: (dateObj, hour) => {
          dateObj.setHours(parseFloat(hour));
      },
      H: (dateObj, hour) => {
          dateObj.setHours(parseFloat(hour));
      },
      J: (dateObj, day) => {
          dateObj.setDate(parseFloat(day));
      },
      K: (dateObj, amPM, locale) => {
          dateObj.setHours((dateObj.getHours() % 12) +
              12 * int(new RegExp(locale.amPM[1], "i").test(amPM)));
      },
      M: function (dateObj, shortMonth, locale) {
          dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth));
      },
      S: (dateObj, seconds) => {
          dateObj.setSeconds(parseFloat(seconds));
      },
      U: (_, unixSeconds) => new Date(parseFloat(unixSeconds) * 1000),
      W: function (dateObj, weekNum, locale) {
          const weekNumber = parseInt(weekNum);
          const date = new Date(dateObj.getFullYear(), 0, 2 + (weekNumber - 1) * 7, 0, 0, 0, 0);
          date.setDate(date.getDate() - date.getDay() + locale.firstDayOfWeek);
          return date;
      },
      Y: (dateObj, year) => {
          dateObj.setFullYear(parseFloat(year));
      },
      Z: (_, ISODate) => new Date(ISODate),
      d: (dateObj, day) => {
          dateObj.setDate(parseFloat(day));
      },
      h: (dateObj, hour) => {
          dateObj.setHours(parseFloat(hour));
      },
      i: (dateObj, minutes) => {
          dateObj.setMinutes(parseFloat(minutes));
      },
      j: (dateObj, day) => {
          dateObj.setDate(parseFloat(day));
      },
      l: doNothing,
      m: (dateObj, month) => {
          dateObj.setMonth(parseFloat(month) - 1);
      },
      n: (dateObj, month) => {
          dateObj.setMonth(parseFloat(month) - 1);
      },
      s: (dateObj, seconds) => {
          dateObj.setSeconds(parseFloat(seconds));
      },
      u: (_, unixMillSeconds) => new Date(parseFloat(unixMillSeconds)),
      w: doNothing,
      y: (dateObj, year) => {
          dateObj.setFullYear(2000 + parseFloat(year));
      },
  };
  const tokenRegex = {
      D: "(\\w+)",
      F: "(\\w+)",
      G: "(\\d\\d|\\d)",
      H: "(\\d\\d|\\d)",
      J: "(\\d\\d|\\d)\\w+",
      K: "",
      M: "(\\w+)",
      S: "(\\d\\d|\\d)",
      U: "(.+)",
      W: "(\\d\\d|\\d)",
      Y: "(\\d{4})",
      Z: "(.+)",
      d: "(\\d\\d|\\d)",
      h: "(\\d\\d|\\d)",
      i: "(\\d\\d|\\d)",
      j: "(\\d\\d|\\d)",
      l: "(\\w+)",
      m: "(\\d\\d|\\d)",
      n: "(\\d\\d|\\d)",
      s: "(\\d\\d|\\d)",
      u: "(.+)",
      w: "(\\d\\d|\\d)",
      y: "(\\d{2})",
  };
  const formats = {
      Z: (date) => date.toISOString(),
      D: function (date, locale, options) {
          return locale.weekdays.shorthand[formats.w(date, locale, options)];
      },
      F: function (date, locale, options) {
          return monthToStr$1(formats.n(date, locale, options) - 1, false, locale);
      },
      G: function (date, locale, options) {
          return pad(formats.h(date, locale, options));
      },
      H: (date) => pad(date.getHours()),
      J: function (date, locale) {
          return locale.ordinal !== undefined
              ? date.getDate() + locale.ordinal(date.getDate())
              : date.getDate();
      },
      K: (date, locale) => locale.amPM[int(date.getHours() > 11)],
      M: function (date, locale) {
          return monthToStr$1(date.getMonth(), true, locale);
      },
      S: (date) => pad(date.getSeconds()),
      U: (date) => date.getTime() / 1000,
      W: function (date, _, options) {
          return options.getWeek(date);
      },
      Y: (date) => pad(date.getFullYear(), 4),
      d: (date) => pad(date.getDate()),
      h: (date) => (date.getHours() % 12 ? date.getHours() % 12 : 12),
      i: (date) => pad(date.getMinutes()),
      j: (date) => date.getDate(),
      l: function (date, locale) {
          return locale.weekdays.longhand[date.getDay()];
      },
      m: (date) => pad(date.getMonth() + 1),
      n: (date) => date.getMonth() + 1,
      s: (date) => date.getSeconds(),
      u: (date) => date.getTime(),
      w: (date) => date.getDay(),
      y: (date) => String(date.getFullYear()).substring(2),
  };

  const createDateFormatter = ({ config = defaults, l10n = english, isMobile = false, }) => (dateObj, frmt, overrideLocale) => {
      const locale = overrideLocale || l10n;
      if (config.formatDate !== undefined && !isMobile) {
          return config.formatDate(dateObj, frmt, locale);
      }
      return frmt
          .split("")
          .map((c, i, arr) => formats[c] && arr[i - 1] !== "\\"
          ? formats[c](dateObj, locale, config)
          : c !== "\\"
              ? c
              : "")
          .join("");
  };
  const createDateParser = ({ config = defaults, l10n = english }) => (date, givenFormat, timeless, customLocale) => {
      if (date !== 0 && !date)
          return undefined;
      const locale = customLocale || l10n;
      let parsedDate;
      const dateOrig = date;
      if (date instanceof Date)
          parsedDate = new Date(date.getTime());
      else if (typeof date !== "string" &&
          date.toFixed !== undefined)
          parsedDate = new Date(date);
      else if (typeof date === "string") {
          const format = givenFormat || (config || defaults).dateFormat;
          const datestr = String(date).trim();
          if (datestr === "today") {
              parsedDate = new Date();
              timeless = true;
          }
          else if (/Z$/.test(datestr) ||
              /GMT$/.test(datestr))
              parsedDate = new Date(date);
          else if (config && config.parseDate)
              parsedDate = config.parseDate(date, format);
          else {
              parsedDate =
                  !config || !config.noCalendar
                      ? new Date(new Date().getFullYear(), 0, 1, 0, 0, 0, 0)
                      : new Date(new Date().setHours(0, 0, 0, 0));
              let matched, ops = [];
              for (let i = 0, matchIndex = 0, regexStr = ""; i < format.length; i++) {
                  const token = format[i];
                  const isBackSlash = token === "\\";
                  const escaped = format[i - 1] === "\\" || isBackSlash;
                  if (tokenRegex[token] && !escaped) {
                      regexStr += tokenRegex[token];
                      const match = new RegExp(regexStr).exec(date);
                      if (match && (matched = true)) {
                          ops[token !== "Y" ? "push" : "unshift"]({
                              fn: revFormat[token],
                              val: match[++matchIndex],
                          });
                      }
                  }
                  else if (!isBackSlash)
                      regexStr += ".";
                  ops.forEach(({ fn, val }) => (parsedDate = fn(parsedDate, val, locale) || parsedDate));
              }
              parsedDate = matched ? parsedDate : undefined;
          }
      }
      if (!(parsedDate instanceof Date && !isNaN(parsedDate.getTime()))) {
          config.errorHandler(new Error(`Invalid date provided: ${dateOrig}`));
          return undefined;
      }
      if (timeless === true)
          parsedDate.setHours(0, 0, 0, 0);
      return parsedDate;
  };
  function compareDates(date1, date2, timeless = true) {
      if (timeless !== false) {
          return (new Date(date1.getTime()).setHours(0, 0, 0, 0) -
              new Date(date2.getTime()).setHours(0, 0, 0, 0));
      }
      return date1.getTime() - date2.getTime();
  }
  const isBetween = (ts, ts1, ts2) => {
      return ts > Math.min(ts1, ts2) && ts < Math.max(ts1, ts2);
  };
  const duration = {
      DAY: 86400000,
  };
  function getDefaultHours(config) {
      let hours = config.defaultHour;
      let minutes = config.defaultMinute;
      let seconds = config.defaultSeconds;
      if (config.minDate !== undefined) {
          const minHour = config.minDate.getHours();
          const minMinutes = config.minDate.getMinutes();
          const minSeconds = config.minDate.getSeconds();
          if (hours < minHour) {
              hours = minHour;
          }
          if (hours === minHour && minutes < minMinutes) {
              minutes = minMinutes;
          }
          if (hours === minHour && minutes === minMinutes && seconds < minSeconds)
              seconds = config.minDate.getSeconds();
      }
      if (config.maxDate !== undefined) {
          const maxHr = config.maxDate.getHours();
          const maxMinutes = config.maxDate.getMinutes();
          hours = Math.min(hours, maxHr);
          if (hours === maxHr)
              minutes = Math.min(maxMinutes, minutes);
          if (hours === maxHr && minutes === maxMinutes)
              seconds = config.maxDate.getSeconds();
      }
      return { hours, minutes, seconds };
  }

  if (typeof Object.assign !== "function") {
      Object.assign = function (target, ...args) {
          if (!target) {
              throw TypeError("Cannot convert undefined or null to object");
          }
          for (const source of args) {
              if (source) {
                  Object.keys(source).forEach((key) => (target[key] = source[key]));
              }
          }
          return target;
      };
  }

  const DEBOUNCED_CHANGE_MS = 300;
  function FlatpickrInstance(element, instanceConfig) {
      const self = {
          config: Object.assign(Object.assign({}, defaults), flatpickr.defaultConfig),
          l10n: english,
      };
      self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });
      self._handlers = [];
      self.pluginElements = [];
      self.loadedPlugins = [];
      self._bind = bind;
      self._setHoursFromDate = setHoursFromDate;
      self._positionCalendar = positionCalendar;
      self.changeMonth = changeMonth;
      self.changeYear = changeYear;
      self.clear = clear;
      self.close = close;
      self._createElement = createElement;
      self.destroy = destroy;
      self.isEnabled = isEnabled;
      self.jumpToDate = jumpToDate;
      self.open = open;
      self.redraw = redraw;
      self.set = set;
      self.setDate = setDate;
      self.toggle = toggle;
      function setupHelperFunctions() {
          self.utils = {
              getDaysInMonth(month = self.currentMonth, yr = self.currentYear) {
                  if (month === 1 && ((yr % 4 === 0 && yr % 100 !== 0) || yr % 400 === 0))
                      return 29;
                  return self.l10n.daysInMonth[month];
              },
          };
      }
      function init() {
          self.element = self.input = element;
          self.isOpen = false;
          parseConfig();
          setupLocale();
          setupInputs();
          setupDates();
          setupHelperFunctions();
          if (!self.isMobile)
              build();
          bindEvents();
          if (self.selectedDates.length || self.config.noCalendar) {
              if (self.config.enableTime) {
                  setHoursFromDate(self.config.noCalendar ? self.latestSelectedDateObj : undefined);
              }
              updateValue(false);
          }
          setCalendarWidth();
          const isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
          if (!self.isMobile && isSafari) {
              positionCalendar();
          }
          triggerEvent("onReady");
      }
      function bindToInstance(fn) {
          return fn.bind(self);
      }
      function setCalendarWidth() {
          const config = self.config;
          if (config.weekNumbers === false && config.showMonths === 1) {
              return;
          }
          else if (config.noCalendar !== true) {
              window.requestAnimationFrame(function () {
                  if (self.calendarContainer !== undefined) {
                      self.calendarContainer.style.visibility = "hidden";
                      self.calendarContainer.style.display = "block";
                  }
                  if (self.daysContainer !== undefined) {
                      const daysWidth = (self.days.offsetWidth + 1) * config.showMonths;
                      self.daysContainer.style.width = daysWidth + "px";
                      self.calendarContainer.style.width =
                          daysWidth +
                              (self.weekWrapper !== undefined
                                  ? self.weekWrapper.offsetWidth
                                  : 0) +
                              "px";
                      self.calendarContainer.style.removeProperty("visibility");
                      self.calendarContainer.style.removeProperty("display");
                  }
              });
          }
      }
      function updateTime(e) {
          if (self.selectedDates.length === 0) {
              const defaultDate = self.config.minDate === undefined ||
                  compareDates(new Date(), self.config.minDate) >= 0
                  ? new Date()
                  : new Date(self.config.minDate.getTime());
              const defaults = getDefaultHours(self.config);
              defaultDate.setHours(defaults.hours, defaults.minutes, defaults.seconds, defaultDate.getMilliseconds());
              self.selectedDates = [defaultDate];
              self.latestSelectedDateObj = defaultDate;
          }
          if (e !== undefined && e.type !== "blur") {
              timeWrapper(e);
          }
          const prevValue = self._input.value;
          setHoursFromInputs();
          updateValue();
          if (self._input.value !== prevValue) {
              self._debouncedChange();
          }
      }
      function ampm2military(hour, amPM) {
          return (hour % 12) + 12 * int(amPM === self.l10n.amPM[1]);
      }
      function military2ampm(hour) {
          switch (hour % 24) {
              case 0:
              case 12:
                  return 12;
              default:
                  return hour % 12;
          }
      }
      function setHoursFromInputs() {
          if (self.hourElement === undefined || self.minuteElement === undefined)
              return;
          let hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24, minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60, seconds = self.secondElement !== undefined
              ? (parseInt(self.secondElement.value, 10) || 0) % 60
              : 0;
          if (self.amPM !== undefined) {
              hours = ampm2military(hours, self.amPM.textContent);
          }
          const limitMinHours = self.config.minTime !== undefined ||
              (self.config.minDate &&
                  self.minDateHasTime &&
                  self.latestSelectedDateObj &&
                  compareDates(self.latestSelectedDateObj, self.config.minDate, true) ===
                      0);
          const limitMaxHours = self.config.maxTime !== undefined ||
              (self.config.maxDate &&
                  self.maxDateHasTime &&
                  self.latestSelectedDateObj &&
                  compareDates(self.latestSelectedDateObj, self.config.maxDate, true) ===
                      0);
          if (limitMaxHours) {
              const maxTime = self.config.maxTime !== undefined
                  ? self.config.maxTime
                  : self.config.maxDate;
              hours = Math.min(hours, maxTime.getHours());
              if (hours === maxTime.getHours())
                  minutes = Math.min(minutes, maxTime.getMinutes());
              if (minutes === maxTime.getMinutes())
                  seconds = Math.min(seconds, maxTime.getSeconds());
          }
          if (limitMinHours) {
              const minTime = self.config.minTime !== undefined
                  ? self.config.minTime
                  : self.config.minDate;
              hours = Math.max(hours, minTime.getHours());
              if (hours === minTime.getHours() && minutes < minTime.getMinutes())
                  minutes = minTime.getMinutes();
              if (minutes === minTime.getMinutes())
                  seconds = Math.max(seconds, minTime.getSeconds());
          }
          setHours(hours, minutes, seconds);
      }
      function setHoursFromDate(dateObj) {
          const date = dateObj || self.latestSelectedDateObj;
          if (date) {
              setHours(date.getHours(), date.getMinutes(), date.getSeconds());
          }
      }
      function setHours(hours, minutes, seconds) {
          if (self.latestSelectedDateObj !== undefined) {
              self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);
          }
          if (!self.hourElement || !self.minuteElement || self.isMobile)
              return;
          self.hourElement.value = pad(!self.config.time_24hr
              ? ((12 + hours) % 12) + 12 * int(hours % 12 === 0)
              : hours);
          self.minuteElement.value = pad(minutes);
          if (self.amPM !== undefined)
              self.amPM.textContent = self.l10n.amPM[int(hours >= 12)];
          if (self.secondElement !== undefined)
              self.secondElement.value = pad(seconds);
      }
      function onYearInput(event) {
          const eventTarget = getEventTarget(event);
          const year = parseInt(eventTarget.value) + (event.delta || 0);
          if (year / 1000 > 1 ||
              (event.key === "Enter" && !/[^\d]/.test(year.toString()))) {
              changeYear(year);
          }
      }
      function bind(element, event, handler, options) {
          if (event instanceof Array)
              return event.forEach((ev) => bind(element, ev, handler, options));
          if (element instanceof Array)
              return element.forEach((el) => bind(el, event, handler, options));
          element.addEventListener(event, handler, options);
          self._handlers.push({
              remove: () => element.removeEventListener(event, handler),
          });
      }
      function triggerChange() {
          triggerEvent("onChange");
      }
      function bindEvents() {
          if (self.config.wrap) {
              ["open", "close", "toggle", "clear"].forEach((evt) => {
                  Array.prototype.forEach.call(self.element.querySelectorAll(`[data-${evt}]`), (el) => bind(el, "click", self[evt]));
              });
          }
          if (self.isMobile) {
              setupMobile();
              return;
          }
          const debouncedResize = debounce$1(onResize, 50);
          self._debouncedChange = debounce$1(triggerChange, DEBOUNCED_CHANGE_MS);
          if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent))
              bind(self.daysContainer, "mouseover", (e) => {
                  if (self.config.mode === "range")
                      onMouseOver(getEventTarget(e));
              });
          bind(window.document.body, "keydown", onKeyDown);
          if (!self.config.inline && !self.config.static)
              bind(window, "resize", debouncedResize);
          if (window.ontouchstart !== undefined)
              bind(window.document, "touchstart", documentClick);
          else
              bind(window.document, "mousedown", documentClick);
          bind(window.document, "focus", documentClick, { capture: true });
          if (self.config.clickOpens === true) {
              bind(self._input, "focus", self.open);
              bind(self._input, "click", self.open);
          }
          if (self.daysContainer !== undefined) {
              bind(self.monthNav, "click", onMonthNavClick);
              bind(self.monthNav, ["keyup", "increment"], onYearInput);
              bind(self.daysContainer, "click", selectDate);
          }
          if (self.timeContainer !== undefined &&
              self.minuteElement !== undefined &&
              self.hourElement !== undefined) {
              const selText = (e) => getEventTarget(e).select();
              bind(self.timeContainer, ["increment"], updateTime);
              bind(self.timeContainer, "blur", updateTime, { capture: true });
              bind(self.timeContainer, "click", timeIncrement);
              bind([self.hourElement, self.minuteElement], ["focus", "click"], selText);
              if (self.secondElement !== undefined)
                  bind(self.secondElement, "focus", () => self.secondElement && self.secondElement.select());
              if (self.amPM !== undefined) {
                  bind(self.amPM, "click", (e) => {
                      updateTime(e);
                      triggerChange();
                  });
              }
          }
          if (self.config.allowInput) {
              bind(self._input, "blur", onBlur);
          }
      }
      function jumpToDate(jumpDate, triggerChange) {
          const jumpTo = jumpDate !== undefined
              ? self.parseDate(jumpDate)
              : self.latestSelectedDateObj ||
                  (self.config.minDate && self.config.minDate > self.now
                      ? self.config.minDate
                      : self.config.maxDate && self.config.maxDate < self.now
                          ? self.config.maxDate
                          : self.now);
          const oldYear = self.currentYear;
          const oldMonth = self.currentMonth;
          try {
              if (jumpTo !== undefined) {
                  self.currentYear = jumpTo.getFullYear();
                  self.currentMonth = jumpTo.getMonth();
              }
          }
          catch (e) {
              e.message = "Invalid date supplied: " + jumpTo;
              self.config.errorHandler(e);
          }
          if (triggerChange && self.currentYear !== oldYear) {
              triggerEvent("onYearChange");
              buildMonthSwitch();
          }
          if (triggerChange &&
              (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {
              triggerEvent("onMonthChange");
          }
          self.redraw();
      }
      function timeIncrement(e) {
          const eventTarget = getEventTarget(e);
          if (~eventTarget.className.indexOf("arrow"))
              incrementNumInput(e, eventTarget.classList.contains("arrowUp") ? 1 : -1);
      }
      function incrementNumInput(e, delta, inputElem) {
          const target = e && getEventTarget(e);
          const input = inputElem ||
              (target && target.parentNode && target.parentNode.firstChild);
          const event = createEvent("increment");
          event.delta = delta;
          input && input.dispatchEvent(event);
      }
      function build() {
          const fragment = window.document.createDocumentFragment();
          self.calendarContainer = createElement("div", "flatpickr-calendar");
          self.calendarContainer.tabIndex = -1;
          if (!self.config.noCalendar) {
              fragment.appendChild(buildMonthNav());
              self.innerContainer = createElement("div", "flatpickr-innerContainer");
              if (self.config.weekNumbers) {
                  const { weekWrapper, weekNumbers } = buildWeeks();
                  self.innerContainer.appendChild(weekWrapper);
                  self.weekNumbers = weekNumbers;
                  self.weekWrapper = weekWrapper;
              }
              self.rContainer = createElement("div", "flatpickr-rContainer");
              self.rContainer.appendChild(buildWeekdays());
              if (!self.daysContainer) {
                  self.daysContainer = createElement("div", "flatpickr-days");
                  self.daysContainer.tabIndex = -1;
              }
              buildDays();
              self.rContainer.appendChild(self.daysContainer);
              self.innerContainer.appendChild(self.rContainer);
              fragment.appendChild(self.innerContainer);
          }
          if (self.config.enableTime) {
              fragment.appendChild(buildTime());
          }
          toggleClass(self.calendarContainer, "rangeMode", self.config.mode === "range");
          toggleClass(self.calendarContainer, "animate", self.config.animate === true);
          toggleClass(self.calendarContainer, "multiMonth", self.config.showMonths > 1);
          self.calendarContainer.appendChild(fragment);
          const customAppend = self.config.appendTo !== undefined &&
              self.config.appendTo.nodeType !== undefined;
          if (self.config.inline || self.config.static) {
              self.calendarContainer.classList.add(self.config.inline ? "inline" : "static");
              if (self.config.inline) {
                  if (!customAppend && self.element.parentNode)
                      self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);
                  else if (self.config.appendTo !== undefined)
                      self.config.appendTo.appendChild(self.calendarContainer);
              }
              if (self.config.static) {
                  const wrapper = createElement("div", "flatpickr-wrapper");
                  if (self.element.parentNode)
                      self.element.parentNode.insertBefore(wrapper, self.element);
                  wrapper.appendChild(self.element);
                  if (self.altInput)
                      wrapper.appendChild(self.altInput);
                  wrapper.appendChild(self.calendarContainer);
              }
          }
          if (!self.config.static && !self.config.inline)
              (self.config.appendTo !== undefined
                  ? self.config.appendTo
                  : window.document.body).appendChild(self.calendarContainer);
      }
      function createDay(className, date, dayNumber, i) {
          const dateIsEnabled = isEnabled(date, true), dayElement = createElement("span", "flatpickr-day " + className, date.getDate().toString());
          dayElement.dateObj = date;
          dayElement.$i = i;
          dayElement.setAttribute("aria-label", self.formatDate(date, self.config.ariaDateFormat));
          if (className.indexOf("hidden") === -1 &&
              compareDates(date, self.now) === 0) {
              self.todayDateElem = dayElement;
              dayElement.classList.add("today");
              dayElement.setAttribute("aria-current", "date");
          }
          if (dateIsEnabled) {
              dayElement.tabIndex = -1;
              if (isDateSelected(date)) {
                  dayElement.classList.add("selected");
                  self.selectedDateElem = dayElement;
                  if (self.config.mode === "range") {
                      toggleClass(dayElement, "startRange", self.selectedDates[0] &&
                          compareDates(date, self.selectedDates[0], true) === 0);
                      toggleClass(dayElement, "endRange", self.selectedDates[1] &&
                          compareDates(date, self.selectedDates[1], true) === 0);
                      if (className === "nextMonthDay")
                          dayElement.classList.add("inRange");
                  }
              }
          }
          else {
              dayElement.classList.add("flatpickr-disabled");
          }
          if (self.config.mode === "range") {
              if (isDateInRange(date) && !isDateSelected(date))
                  dayElement.classList.add("inRange");
          }
          if (self.weekNumbers &&
              self.config.showMonths === 1 &&
              className !== "prevMonthDay" &&
              dayNumber % 7 === 1) {
              self.weekNumbers.insertAdjacentHTML("beforeend", "<span class='flatpickr-day'>" + self.config.getWeek(date) + "</span>");
          }
          triggerEvent("onDayCreate", dayElement);
          return dayElement;
      }
      function focusOnDayElem(targetNode) {
          targetNode.focus();
          if (self.config.mode === "range")
              onMouseOver(targetNode);
      }
      function getFirstAvailableDay(delta) {
          const startMonth = delta > 0 ? 0 : self.config.showMonths - 1;
          const endMonth = delta > 0 ? self.config.showMonths : -1;
          for (let m = startMonth; m != endMonth; m += delta) {
              const month = self.daysContainer.children[m];
              const startIndex = delta > 0 ? 0 : month.children.length - 1;
              const endIndex = delta > 0 ? month.children.length : -1;
              for (let i = startIndex; i != endIndex; i += delta) {
                  const c = month.children[i];
                  if (c.className.indexOf("hidden") === -1 && isEnabled(c.dateObj))
                      return c;
              }
          }
          return undefined;
      }
      function getNextAvailableDay(current, delta) {
          const givenMonth = current.className.indexOf("Month") === -1
              ? current.dateObj.getMonth()
              : self.currentMonth;
          const endMonth = delta > 0 ? self.config.showMonths : -1;
          const loopDelta = delta > 0 ? 1 : -1;
          for (let m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {
              const month = self.daysContainer.children[m];
              const startIndex = givenMonth - self.currentMonth === m
                  ? current.$i + delta
                  : delta < 0
                      ? month.children.length - 1
                      : 0;
              const numMonthDays = month.children.length;
              for (let i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {
                  const c = month.children[i];
                  if (c.className.indexOf("hidden") === -1 &&
                      isEnabled(c.dateObj) &&
                      Math.abs(current.$i - i) >= Math.abs(delta))
                      return focusOnDayElem(c);
              }
          }
          self.changeMonth(loopDelta);
          focusOnDay(getFirstAvailableDay(loopDelta), 0);
          return undefined;
      }
      function focusOnDay(current, offset) {
          const dayFocused = isInView(document.activeElement || document.body);
          const startElem = current !== undefined
              ? current
              : dayFocused
                  ? document.activeElement
                  : self.selectedDateElem !== undefined && isInView(self.selectedDateElem)
                      ? self.selectedDateElem
                      : self.todayDateElem !== undefined && isInView(self.todayDateElem)
                          ? self.todayDateElem
                          : getFirstAvailableDay(offset > 0 ? 1 : -1);
          if (startElem === undefined) {
              self._input.focus();
          }
          else if (!dayFocused) {
              focusOnDayElem(startElem);
          }
          else {
              getNextAvailableDay(startElem, offset);
          }
      }
      function buildMonthDays(year, month) {
          const firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;
          const prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12, year);
          const daysInMonth = self.utils.getDaysInMonth(month, year), days = window.document.createDocumentFragment(), isMultiMonth = self.config.showMonths > 1, prevMonthDayClass = isMultiMonth ? "prevMonthDay hidden" : "prevMonthDay", nextMonthDayClass = isMultiMonth ? "nextMonthDay hidden" : "nextMonthDay";
          let dayNumber = prevMonthDays + 1 - firstOfMonth, dayIndex = 0;
          for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {
              days.appendChild(createDay(prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));
          }
          for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {
              days.appendChild(createDay("", new Date(year, month, dayNumber), dayNumber, dayIndex));
          }
          for (let dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth &&
              (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {
              days.appendChild(createDay(nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));
          }
          const dayContainer = createElement("div", "dayContainer");
          dayContainer.appendChild(days);
          return dayContainer;
      }
      function buildDays() {
          if (self.daysContainer === undefined) {
              return;
          }
          clearNode(self.daysContainer);
          if (self.weekNumbers)
              clearNode(self.weekNumbers);
          const frag = document.createDocumentFragment();
          for (let i = 0; i < self.config.showMonths; i++) {
              const d = new Date(self.currentYear, self.currentMonth, 1);
              d.setMonth(self.currentMonth + i);
              frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));
          }
          self.daysContainer.appendChild(frag);
          self.days = self.daysContainer.firstChild;
          if (self.config.mode === "range" && self.selectedDates.length === 1) {
              onMouseOver();
          }
      }
      function buildMonthSwitch() {
          if (self.config.showMonths > 1 ||
              self.config.monthSelectorType !== "dropdown")
              return;
          const shouldBuildMonth = function (month) {
              if (self.config.minDate !== undefined &&
                  self.currentYear === self.config.minDate.getFullYear() &&
                  month < self.config.minDate.getMonth()) {
                  return false;
              }
              return !(self.config.maxDate !== undefined &&
                  self.currentYear === self.config.maxDate.getFullYear() &&
                  month > self.config.maxDate.getMonth());
          };
          self.monthsDropdownContainer.tabIndex = -1;
          self.monthsDropdownContainer.innerHTML = "";
          for (let i = 0; i < 12; i++) {
              if (!shouldBuildMonth(i))
                  continue;
              const month = createElement("option", "flatpickr-monthDropdown-month");
              month.value = new Date(self.currentYear, i).getMonth().toString();
              month.textContent = monthToStr$1(i, self.config.shorthandCurrentMonth, self.l10n);
              month.tabIndex = -1;
              if (self.currentMonth === i) {
                  month.selected = true;
              }
              self.monthsDropdownContainer.appendChild(month);
          }
      }
      function buildMonth() {
          const container = createElement("div", "flatpickr-month");
          const monthNavFragment = window.document.createDocumentFragment();
          let monthElement;
          if (self.config.showMonths > 1 ||
              self.config.monthSelectorType === "static") {
              monthElement = createElement("span", "cur-month");
          }
          else {
              self.monthsDropdownContainer = createElement("select", "flatpickr-monthDropdown-months");
              self.monthsDropdownContainer.setAttribute("aria-label", self.l10n.monthAriaLabel);
              bind(self.monthsDropdownContainer, "change", (e) => {
                  const target = getEventTarget(e);
                  const selectedMonth = parseInt(target.value, 10);
                  self.changeMonth(selectedMonth - self.currentMonth);
                  triggerEvent("onMonthChange");
              });
              buildMonthSwitch();
              monthElement = self.monthsDropdownContainer;
          }
          const yearInput = createNumberInput("cur-year", { tabindex: "-1" });
          const yearElement = yearInput.getElementsByTagName("input")[0];
          yearElement.setAttribute("aria-label", self.l10n.yearAriaLabel);
          if (self.config.minDate) {
              yearElement.setAttribute("min", self.config.minDate.getFullYear().toString());
          }
          if (self.config.maxDate) {
              yearElement.setAttribute("max", self.config.maxDate.getFullYear().toString());
              yearElement.disabled =
                  !!self.config.minDate &&
                      self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();
          }
          const currentMonth = createElement("div", "flatpickr-current-month");
          currentMonth.appendChild(monthElement);
          currentMonth.appendChild(yearInput);
          monthNavFragment.appendChild(currentMonth);
          container.appendChild(monthNavFragment);
          return {
              container,
              yearElement,
              monthElement,
          };
      }
      function buildMonths() {
          clearNode(self.monthNav);
          self.monthNav.appendChild(self.prevMonthNav);
          if (self.config.showMonths) {
              self.yearElements = [];
              self.monthElements = [];
          }
          for (let m = self.config.showMonths; m--;) {
              const month = buildMonth();
              self.yearElements.push(month.yearElement);
              self.monthElements.push(month.monthElement);
              self.monthNav.appendChild(month.container);
          }
          self.monthNav.appendChild(self.nextMonthNav);
      }
      function buildMonthNav() {
          self.monthNav = createElement("div", "flatpickr-months");
          self.yearElements = [];
          self.monthElements = [];
          self.prevMonthNav = createElement("span", "flatpickr-prev-month");
          self.prevMonthNav.innerHTML = self.config.prevArrow;
          self.nextMonthNav = createElement("span", "flatpickr-next-month");
          self.nextMonthNav.innerHTML = self.config.nextArrow;
          buildMonths();
          Object.defineProperty(self, "_hidePrevMonthArrow", {
              get: () => self.__hidePrevMonthArrow,
              set(bool) {
                  if (self.__hidePrevMonthArrow !== bool) {
                      toggleClass(self.prevMonthNav, "flatpickr-disabled", bool);
                      self.__hidePrevMonthArrow = bool;
                  }
              },
          });
          Object.defineProperty(self, "_hideNextMonthArrow", {
              get: () => self.__hideNextMonthArrow,
              set(bool) {
                  if (self.__hideNextMonthArrow !== bool) {
                      toggleClass(self.nextMonthNav, "flatpickr-disabled", bool);
                      self.__hideNextMonthArrow = bool;
                  }
              },
          });
          self.currentYearElement = self.yearElements[0];
          updateNavigationCurrentMonth();
          return self.monthNav;
      }
      function buildTime() {
          self.calendarContainer.classList.add("hasTime");
          if (self.config.noCalendar)
              self.calendarContainer.classList.add("noCalendar");
          const defaults = getDefaultHours(self.config);
          self.timeContainer = createElement("div", "flatpickr-time");
          self.timeContainer.tabIndex = -1;
          const separator = createElement("span", "flatpickr-time-separator", ":");
          const hourInput = createNumberInput("flatpickr-hour", {
              "aria-label": self.l10n.hourAriaLabel,
          });
          self.hourElement = hourInput.getElementsByTagName("input")[0];
          const minuteInput = createNumberInput("flatpickr-minute", {
              "aria-label": self.l10n.minuteAriaLabel,
          });
          self.minuteElement = minuteInput.getElementsByTagName("input")[0];
          self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;
          self.hourElement.value = pad(self.latestSelectedDateObj
              ? self.latestSelectedDateObj.getHours()
              : self.config.time_24hr
                  ? defaults.hours
                  : military2ampm(defaults.hours));
          self.minuteElement.value = pad(self.latestSelectedDateObj
              ? self.latestSelectedDateObj.getMinutes()
              : defaults.minutes);
          self.hourElement.setAttribute("step", self.config.hourIncrement.toString());
          self.minuteElement.setAttribute("step", self.config.minuteIncrement.toString());
          self.hourElement.setAttribute("min", self.config.time_24hr ? "0" : "1");
          self.hourElement.setAttribute("max", self.config.time_24hr ? "23" : "12");
          self.hourElement.setAttribute("maxlength", "2");
          self.minuteElement.setAttribute("min", "0");
          self.minuteElement.setAttribute("max", "59");
          self.minuteElement.setAttribute("maxlength", "2");
          self.timeContainer.appendChild(hourInput);
          self.timeContainer.appendChild(separator);
          self.timeContainer.appendChild(minuteInput);
          if (self.config.time_24hr)
              self.timeContainer.classList.add("time24hr");
          if (self.config.enableSeconds) {
              self.timeContainer.classList.add("hasSeconds");
              const secondInput = createNumberInput("flatpickr-second");
              self.secondElement = secondInput.getElementsByTagName("input")[0];
              self.secondElement.value = pad(self.latestSelectedDateObj
                  ? self.latestSelectedDateObj.getSeconds()
                  : defaults.seconds);
              self.secondElement.setAttribute("step", self.minuteElement.getAttribute("step"));
              self.secondElement.setAttribute("min", "0");
              self.secondElement.setAttribute("max", "59");
              self.secondElement.setAttribute("maxlength", "2");
              self.timeContainer.appendChild(createElement("span", "flatpickr-time-separator", ":"));
              self.timeContainer.appendChild(secondInput);
          }
          if (!self.config.time_24hr) {
              self.amPM = createElement("span", "flatpickr-am-pm", self.l10n.amPM[int((self.latestSelectedDateObj
                  ? self.hourElement.value
                  : self.config.defaultHour) > 11)]);
              self.amPM.title = self.l10n.toggleTitle;
              self.amPM.tabIndex = -1;
              self.timeContainer.appendChild(self.amPM);
          }
          return self.timeContainer;
      }
      function buildWeekdays() {
          if (!self.weekdayContainer)
              self.weekdayContainer = createElement("div", "flatpickr-weekdays");
          else
              clearNode(self.weekdayContainer);
          for (let i = self.config.showMonths; i--;) {
              const container = createElement("div", "flatpickr-weekdaycontainer");
              self.weekdayContainer.appendChild(container);
          }
          updateWeekdays();
          return self.weekdayContainer;
      }
      function updateWeekdays() {
          if (!self.weekdayContainer) {
              return;
          }
          const firstDayOfWeek = self.l10n.firstDayOfWeek;
          let weekdays = [...self.l10n.weekdays.shorthand];
          if (firstDayOfWeek > 0 && firstDayOfWeek < weekdays.length) {
              weekdays = [
                  ...weekdays.splice(firstDayOfWeek, weekdays.length),
                  ...weekdays.splice(0, firstDayOfWeek),
              ];
          }
          for (let i = self.config.showMonths; i--;) {
              self.weekdayContainer.children[i].innerHTML = `
      <span class='flatpickr-weekday'>
        ${weekdays.join("</span><span class='flatpickr-weekday'>")}
      </span>
      `;
          }
      }
      function buildWeeks() {
          self.calendarContainer.classList.add("hasWeeks");
          const weekWrapper = createElement("div", "flatpickr-weekwrapper");
          weekWrapper.appendChild(createElement("span", "flatpickr-weekday", self.l10n.weekAbbreviation));
          const weekNumbers = createElement("div", "flatpickr-weeks");
          weekWrapper.appendChild(weekNumbers);
          return {
              weekWrapper,
              weekNumbers,
          };
      }
      function changeMonth(value, isOffset = true) {
          const delta = isOffset ? value : value - self.currentMonth;
          if ((delta < 0 && self._hidePrevMonthArrow === true) ||
              (delta > 0 && self._hideNextMonthArrow === true))
              return;
          self.currentMonth += delta;
          if (self.currentMonth < 0 || self.currentMonth > 11) {
              self.currentYear += self.currentMonth > 11 ? 1 : -1;
              self.currentMonth = (self.currentMonth + 12) % 12;
              triggerEvent("onYearChange");
              buildMonthSwitch();
          }
          buildDays();
          triggerEvent("onMonthChange");
          updateNavigationCurrentMonth();
      }
      function clear(triggerChangeEvent = true, toInitial = true) {
          self.input.value = "";
          if (self.altInput !== undefined)
              self.altInput.value = "";
          if (self.mobileInput !== undefined)
              self.mobileInput.value = "";
          self.selectedDates = [];
          self.latestSelectedDateObj = undefined;
          if (toInitial === true) {
              self.currentYear = self._initialDate.getFullYear();
              self.currentMonth = self._initialDate.getMonth();
          }
          if (self.config.enableTime === true) {
              const { hours, minutes, seconds } = getDefaultHours(self.config);
              setHours(hours, minutes, seconds);
          }
          self.redraw();
          if (triggerChangeEvent)
              triggerEvent("onChange");
      }
      function close() {
          self.isOpen = false;
          if (!self.isMobile) {
              if (self.calendarContainer !== undefined) {
                  self.calendarContainer.classList.remove("open");
              }
              if (self._input !== undefined) {
                  self._input.classList.remove("active");
              }
          }
          triggerEvent("onClose");
      }
      function destroy() {
          if (self.config !== undefined)
              triggerEvent("onDestroy");
          for (let i = self._handlers.length; i--;) {
              self._handlers[i].remove();
          }
          self._handlers = [];
          if (self.mobileInput) {
              if (self.mobileInput.parentNode)
                  self.mobileInput.parentNode.removeChild(self.mobileInput);
              self.mobileInput = undefined;
          }
          else if (self.calendarContainer && self.calendarContainer.parentNode) {
              if (self.config.static && self.calendarContainer.parentNode) {
                  const wrapper = self.calendarContainer.parentNode;
                  wrapper.lastChild && wrapper.removeChild(wrapper.lastChild);
                  if (wrapper.parentNode) {
                      while (wrapper.firstChild)
                          wrapper.parentNode.insertBefore(wrapper.firstChild, wrapper);
                      wrapper.parentNode.removeChild(wrapper);
                  }
              }
              else
                  self.calendarContainer.parentNode.removeChild(self.calendarContainer);
          }
          if (self.altInput) {
              self.input.type = "text";
              if (self.altInput.parentNode)
                  self.altInput.parentNode.removeChild(self.altInput);
              delete self.altInput;
          }
          if (self.input) {
              self.input.type = self.input._type;
              self.input.classList.remove("flatpickr-input");
              self.input.removeAttribute("readonly");
          }
          [
              "_showTimeInput",
              "latestSelectedDateObj",
              "_hideNextMonthArrow",
              "_hidePrevMonthArrow",
              "__hideNextMonthArrow",
              "__hidePrevMonthArrow",
              "isMobile",
              "isOpen",
              "selectedDateElem",
              "minDateHasTime",
              "maxDateHasTime",
              "days",
              "daysContainer",
              "_input",
              "_positionElement",
              "innerContainer",
              "rContainer",
              "monthNav",
              "todayDateElem",
              "calendarContainer",
              "weekdayContainer",
              "prevMonthNav",
              "nextMonthNav",
              "monthsDropdownContainer",
              "currentMonthElement",
              "currentYearElement",
              "navigationCurrentMonth",
              "selectedDateElem",
              "config",
          ].forEach((k) => {
              try {
                  delete self[k];
              }
              catch (_) { }
          });
      }
      function isCalendarElem(elem) {
          if (self.config.appendTo && self.config.appendTo.contains(elem))
              return true;
          return self.calendarContainer.contains(elem);
      }
      function documentClick(e) {
          if (self.isOpen && !self.config.inline) {
              const eventTarget = getEventTarget(e);
              const isCalendarElement = isCalendarElem(eventTarget);
              const isInput = eventTarget === self.input ||
                  eventTarget === self.altInput ||
                  self.element.contains(eventTarget) ||
                  (e.path &&
                      e.path.indexOf &&
                      (~e.path.indexOf(self.input) ||
                          ~e.path.indexOf(self.altInput)));
              const lostFocus = e.type === "blur"
                  ? isInput &&
                      e.relatedTarget &&
                      !isCalendarElem(e.relatedTarget)
                  : !isInput &&
                      !isCalendarElement &&
                      !isCalendarElem(e.relatedTarget);
              const isIgnored = !self.config.ignoredFocusElements.some((elem) => elem.contains(eventTarget));
              if (lostFocus && isIgnored) {
                  if (self.timeContainer !== undefined &&
                      self.minuteElement !== undefined &&
                      self.hourElement !== undefined &&
                      self.input.value !== "" &&
                      self.input.value !== undefined) {
                      updateTime();
                  }
                  self.close();
                  if (self.config &&
                      self.config.mode === "range" &&
                      self.selectedDates.length === 1) {
                      self.clear(false);
                      self.redraw();
                  }
              }
          }
      }
      function changeYear(newYear) {
          if (!newYear ||
              (self.config.minDate && newYear < self.config.minDate.getFullYear()) ||
              (self.config.maxDate && newYear > self.config.maxDate.getFullYear()))
              return;
          const newYearNum = newYear, isNewYear = self.currentYear !== newYearNum;
          self.currentYear = newYearNum || self.currentYear;
          if (self.config.maxDate &&
              self.currentYear === self.config.maxDate.getFullYear()) {
              self.currentMonth = Math.min(self.config.maxDate.getMonth(), self.currentMonth);
          }
          else if (self.config.minDate &&
              self.currentYear === self.config.minDate.getFullYear()) {
              self.currentMonth = Math.max(self.config.minDate.getMonth(), self.currentMonth);
          }
          if (isNewYear) {
              self.redraw();
              triggerEvent("onYearChange");
              buildMonthSwitch();
          }
      }
      function isEnabled(date, timeless = true) {
          var _a;
          const dateToCheck = self.parseDate(date, undefined, timeless);
          if ((self.config.minDate &&
              dateToCheck &&
              compareDates(dateToCheck, self.config.minDate, timeless !== undefined ? timeless : !self.minDateHasTime) < 0) ||
              (self.config.maxDate &&
                  dateToCheck &&
                  compareDates(dateToCheck, self.config.maxDate, timeless !== undefined ? timeless : !self.maxDateHasTime) > 0))
              return false;
          if (!self.config.enable && self.config.disable.length === 0)
              return true;
          if (dateToCheck === undefined)
              return false;
          const bool = !!self.config.enable, array = (_a = self.config.enable) !== null && _a !== void 0 ? _a : self.config.disable;
          for (let i = 0, d; i < array.length; i++) {
              d = array[i];
              if (typeof d === "function" &&
                  d(dateToCheck))
                  return bool;
              else if (d instanceof Date &&
                  dateToCheck !== undefined &&
                  d.getTime() === dateToCheck.getTime())
                  return bool;
              else if (typeof d === "string") {
                  const parsed = self.parseDate(d, undefined, true);
                  return parsed && parsed.getTime() === dateToCheck.getTime()
                      ? bool
                      : !bool;
              }
              else if (typeof d === "object" &&
                  dateToCheck !== undefined &&
                  d.from &&
                  d.to &&
                  dateToCheck.getTime() >= d.from.getTime() &&
                  dateToCheck.getTime() <= d.to.getTime())
                  return bool;
          }
          return !bool;
      }
      function isInView(elem) {
          if (self.daysContainer !== undefined)
              return (elem.className.indexOf("hidden") === -1 &&
                  elem.className.indexOf("flatpickr-disabled") === -1 &&
                  self.daysContainer.contains(elem));
          return false;
      }
      function onBlur(e) {
          const isInput = e.target === self._input;
          if (isInput &&
              (self.selectedDates.length > 0 || self._input.value.length > 0) &&
              !(e.relatedTarget && isCalendarElem(e.relatedTarget))) {
              self.setDate(self._input.value, true, e.target === self.altInput
                  ? self.config.altFormat
                  : self.config.dateFormat);
          }
      }
      function onKeyDown(e) {
          const eventTarget = getEventTarget(e);
          const isInput = self.config.wrap
              ? element.contains(eventTarget)
              : eventTarget === self._input;
          const allowInput = self.config.allowInput;
          const allowKeydown = self.isOpen && (!allowInput || !isInput);
          const allowInlineKeydown = self.config.inline && isInput && !allowInput;
          if (e.keyCode === 13 && isInput) {
              if (allowInput) {
                  self.setDate(self._input.value, true, eventTarget === self.altInput
                      ? self.config.altFormat
                      : self.config.dateFormat);
                  return eventTarget.blur();
              }
              else {
                  self.open();
              }
          }
          else if (isCalendarElem(eventTarget) ||
              allowKeydown ||
              allowInlineKeydown) {
              const isTimeObj = !!self.timeContainer &&
                  self.timeContainer.contains(eventTarget);
              switch (e.keyCode) {
                  case 13:
                      if (isTimeObj) {
                          e.preventDefault();
                          updateTime();
                          focusAndClose();
                      }
                      else
                          selectDate(e);
                      break;
                  case 27:
                      e.preventDefault();
                      focusAndClose();
                      break;
                  case 8:
                  case 46:
                      if (isInput && !self.config.allowInput) {
                          e.preventDefault();
                          self.clear();
                      }
                      break;
                  case 37:
                  case 39:
                      if (!isTimeObj && !isInput) {
                          e.preventDefault();
                          if (self.daysContainer !== undefined &&
                              (allowInput === false ||
                                  (document.activeElement && isInView(document.activeElement)))) {
                              const delta = e.keyCode === 39 ? 1 : -1;
                              if (!e.ctrlKey)
                                  focusOnDay(undefined, delta);
                              else {
                                  e.stopPropagation();
                                  changeMonth(delta);
                                  focusOnDay(getFirstAvailableDay(1), 0);
                              }
                          }
                      }
                      else if (self.hourElement)
                          self.hourElement.focus();
                      break;
                  case 38:
                  case 40:
                      e.preventDefault();
                      const delta = e.keyCode === 40 ? 1 : -1;
                      if ((self.daysContainer &&
                          eventTarget.$i !== undefined) ||
                          eventTarget === self.input ||
                          eventTarget === self.altInput) {
                          if (e.ctrlKey) {
                              e.stopPropagation();
                              changeYear(self.currentYear - delta);
                              focusOnDay(getFirstAvailableDay(1), 0);
                          }
                          else if (!isTimeObj)
                              focusOnDay(undefined, delta * 7);
                      }
                      else if (eventTarget === self.currentYearElement) {
                          changeYear(self.currentYear - delta);
                      }
                      else if (self.config.enableTime) {
                          if (!isTimeObj && self.hourElement)
                              self.hourElement.focus();
                          updateTime(e);
                          self._debouncedChange();
                      }
                      break;
                  case 9:
                      if (isTimeObj) {
                          const elems = [
                              self.hourElement,
                              self.minuteElement,
                              self.secondElement,
                              self.amPM,
                          ]
                              .concat(self.pluginElements)
                              .filter((x) => x);
                          const i = elems.indexOf(eventTarget);
                          if (i !== -1) {
                              const target = elems[i + (e.shiftKey ? -1 : 1)];
                              e.preventDefault();
                              (target || self._input).focus();
                          }
                      }
                      else if (!self.config.noCalendar &&
                          self.daysContainer &&
                          self.daysContainer.contains(eventTarget) &&
                          e.shiftKey) {
                          e.preventDefault();
                          self._input.focus();
                      }
                      break;
              }
          }
          if (self.amPM !== undefined && eventTarget === self.amPM) {
              switch (e.key) {
                  case self.l10n.amPM[0].charAt(0):
                  case self.l10n.amPM[0].charAt(0).toLowerCase():
                      self.amPM.textContent = self.l10n.amPM[0];
                      setHoursFromInputs();
                      updateValue();
                      break;
                  case self.l10n.amPM[1].charAt(0):
                  case self.l10n.amPM[1].charAt(0).toLowerCase():
                      self.amPM.textContent = self.l10n.amPM[1];
                      setHoursFromInputs();
                      updateValue();
                      break;
              }
          }
          if (isInput || isCalendarElem(eventTarget)) {
              triggerEvent("onKeyDown", e);
          }
      }
      function onMouseOver(elem) {
          if (self.selectedDates.length !== 1 ||
              (elem &&
                  (!elem.classList.contains("flatpickr-day") ||
                      elem.classList.contains("flatpickr-disabled"))))
              return;
          const hoverDate = elem
              ? elem.dateObj.getTime()
              : self.days.firstElementChild.dateObj.getTime(), initialDate = self.parseDate(self.selectedDates[0], undefined, true).getTime(), rangeStartDate = Math.min(hoverDate, self.selectedDates[0].getTime()), rangeEndDate = Math.max(hoverDate, self.selectedDates[0].getTime());
          let containsDisabled = false;
          let minRange = 0, maxRange = 0;
          for (let t = rangeStartDate; t < rangeEndDate; t += duration.DAY) {
              if (!isEnabled(new Date(t), true)) {
                  containsDisabled =
                      containsDisabled || (t > rangeStartDate && t < rangeEndDate);
                  if (t < initialDate && (!minRange || t > minRange))
                      minRange = t;
                  else if (t > initialDate && (!maxRange || t < maxRange))
                      maxRange = t;
              }
          }
          for (let m = 0; m < self.config.showMonths; m++) {
              const month = self.daysContainer.children[m];
              for (let i = 0, l = month.children.length; i < l; i++) {
                  const dayElem = month.children[i], date = dayElem.dateObj;
                  const timestamp = date.getTime();
                  const outOfRange = (minRange > 0 && timestamp < minRange) ||
                      (maxRange > 0 && timestamp > maxRange);
                  if (outOfRange) {
                      dayElem.classList.add("notAllowed");
                      ["inRange", "startRange", "endRange"].forEach((c) => {
                          dayElem.classList.remove(c);
                      });
                      continue;
                  }
                  else if (containsDisabled && !outOfRange)
                      continue;
                  ["startRange", "inRange", "endRange", "notAllowed"].forEach((c) => {
                      dayElem.classList.remove(c);
                  });
                  if (elem !== undefined) {
                      elem.classList.add(hoverDate <= self.selectedDates[0].getTime()
                          ? "startRange"
                          : "endRange");
                      if (initialDate < hoverDate && timestamp === initialDate)
                          dayElem.classList.add("startRange");
                      else if (initialDate > hoverDate && timestamp === initialDate)
                          dayElem.classList.add("endRange");
                      if (timestamp >= minRange &&
                          (maxRange === 0 || timestamp <= maxRange) &&
                          isBetween(timestamp, initialDate, hoverDate))
                          dayElem.classList.add("inRange");
                  }
              }
          }
      }
      function onResize() {
          if (self.isOpen && !self.config.static && !self.config.inline)
              positionCalendar();
      }
      function open(e, positionElement = self._positionElement) {
          if (self.isMobile === true) {
              if (e) {
                  e.preventDefault();
                  const eventTarget = getEventTarget(e);
                  if (eventTarget) {
                      eventTarget.blur();
                  }
              }
              if (self.mobileInput !== undefined) {
                  self.mobileInput.focus();
                  self.mobileInput.click();
              }
              triggerEvent("onOpen");
              return;
          }
          else if (self._input.disabled || self.config.inline) {
              return;
          }
          const wasOpen = self.isOpen;
          self.isOpen = true;
          if (!wasOpen) {
              self.calendarContainer.classList.add("open");
              self._input.classList.add("active");
              triggerEvent("onOpen");
              positionCalendar(positionElement);
          }
          if (self.config.enableTime === true && self.config.noCalendar === true) {
              if (self.config.allowInput === false &&
                  (e === undefined ||
                      !self.timeContainer.contains(e.relatedTarget))) {
                  setTimeout(() => self.hourElement.select(), 50);
              }
          }
      }
      function minMaxDateSetter(type) {
          return (date) => {
              const dateObj = (self.config[`_${type}Date`] = self.parseDate(date, self.config.dateFormat));
              const inverseDateObj = self.config[`_${type === "min" ? "max" : "min"}Date`];
              if (dateObj !== undefined) {
                  self[type === "min" ? "minDateHasTime" : "maxDateHasTime"] =
                      dateObj.getHours() > 0 ||
                          dateObj.getMinutes() > 0 ||
                          dateObj.getSeconds() > 0;
              }
              if (self.selectedDates) {
                  self.selectedDates = self.selectedDates.filter((d) => isEnabled(d));
                  if (!self.selectedDates.length && type === "min")
                      setHoursFromDate(dateObj);
                  updateValue();
              }
              if (self.daysContainer) {
                  redraw();
                  if (dateObj !== undefined)
                      self.currentYearElement[type] = dateObj.getFullYear().toString();
                  else
                      self.currentYearElement.removeAttribute(type);
                  self.currentYearElement.disabled =
                      !!inverseDateObj &&
                          dateObj !== undefined &&
                          inverseDateObj.getFullYear() === dateObj.getFullYear();
              }
          };
      }
      function parseConfig() {
          const boolOpts = [
              "wrap",
              "weekNumbers",
              "allowInput",
              "allowInvalidPreload",
              "clickOpens",
              "time_24hr",
              "enableTime",
              "noCalendar",
              "altInput",
              "shorthandCurrentMonth",
              "inline",
              "static",
              "enableSeconds",
              "disableMobile",
          ];
          const userConfig = Object.assign(Object.assign({}, JSON.parse(JSON.stringify(element.dataset || {}))), instanceConfig);
          const formats = {};
          self.config.parseDate = userConfig.parseDate;
          self.config.formatDate = userConfig.formatDate;
          Object.defineProperty(self.config, "enable", {
              get: () => self.config._enable,
              set: (dates) => {
                  self.config._enable = parseDateRules(dates);
              },
          });
          Object.defineProperty(self.config, "disable", {
              get: () => self.config._disable,
              set: (dates) => {
                  self.config._disable = parseDateRules(dates);
              },
          });
          const timeMode = userConfig.mode === "time";
          if (!userConfig.dateFormat && (userConfig.enableTime || timeMode)) {
              const defaultDateFormat = flatpickr.defaultConfig.dateFormat || defaults.dateFormat;
              formats.dateFormat =
                  userConfig.noCalendar || timeMode
                      ? "H:i" + (userConfig.enableSeconds ? ":S" : "")
                      : defaultDateFormat + " H:i" + (userConfig.enableSeconds ? ":S" : "");
          }
          if (userConfig.altInput &&
              (userConfig.enableTime || timeMode) &&
              !userConfig.altFormat) {
              const defaultAltFormat = flatpickr.defaultConfig.altFormat || defaults.altFormat;
              formats.altFormat =
                  userConfig.noCalendar || timeMode
                      ? "h:i" + (userConfig.enableSeconds ? ":S K" : " K")
                      : defaultAltFormat + ` h:i${userConfig.enableSeconds ? ":S" : ""} K`;
          }
          Object.defineProperty(self.config, "minDate", {
              get: () => self.config._minDate,
              set: minMaxDateSetter("min"),
          });
          Object.defineProperty(self.config, "maxDate", {
              get: () => self.config._maxDate,
              set: minMaxDateSetter("max"),
          });
          const minMaxTimeSetter = (type) => (val) => {
              self.config[type === "min" ? "_minTime" : "_maxTime"] = self.parseDate(val, "H:i:S");
          };
          Object.defineProperty(self.config, "minTime", {
              get: () => self.config._minTime,
              set: minMaxTimeSetter("min"),
          });
          Object.defineProperty(self.config, "maxTime", {
              get: () => self.config._maxTime,
              set: minMaxTimeSetter("max"),
          });
          if (userConfig.mode === "time") {
              self.config.noCalendar = true;
              self.config.enableTime = true;
          }
          Object.assign(self.config, formats, userConfig);
          for (let i = 0; i < boolOpts.length; i++)
              self.config[boolOpts[i]] =
                  self.config[boolOpts[i]] === true ||
                      self.config[boolOpts[i]] === "true";
          HOOKS.filter((hook) => self.config[hook] !== undefined).forEach((hook) => {
              self.config[hook] = arrayify(self.config[hook] || []).map(bindToInstance);
          });
          self.isMobile =
              !self.config.disableMobile &&
                  !self.config.inline &&
                  self.config.mode === "single" &&
                  !self.config.disable.length &&
                  !self.config.enable &&
                  !self.config.weekNumbers &&
                  /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
          for (let i = 0; i < self.config.plugins.length; i++) {
              const pluginConf = self.config.plugins[i](self) || {};
              for (const key in pluginConf) {
                  if (HOOKS.indexOf(key) > -1) {
                      self.config[key] = arrayify(pluginConf[key])
                          .map(bindToInstance)
                          .concat(self.config[key]);
                  }
                  else if (typeof userConfig[key] === "undefined")
                      self.config[key] = pluginConf[key];
              }
          }
          if (!userConfig.altInputClass) {
              self.config.altInputClass =
                  getInputElem().className + " " + self.config.altInputClass;
          }
          triggerEvent("onParseConfig");
      }
      function getInputElem() {
          return self.config.wrap
              ? element.querySelector("[data-input]")
              : element;
      }
      function setupLocale() {
          if (typeof self.config.locale !== "object" &&
              typeof flatpickr.l10ns[self.config.locale] === "undefined")
              self.config.errorHandler(new Error(`flatpickr: invalid locale ${self.config.locale}`));
          self.l10n = Object.assign(Object.assign({}, flatpickr.l10ns.default), (typeof self.config.locale === "object"
              ? self.config.locale
              : self.config.locale !== "default"
                  ? flatpickr.l10ns[self.config.locale]
                  : undefined));
          tokenRegex.K = `(${self.l10n.amPM[0]}|${self.l10n.amPM[1]}|${self.l10n.amPM[0].toLowerCase()}|${self.l10n.amPM[1].toLowerCase()})`;
          const userConfig = Object.assign(Object.assign({}, instanceConfig), JSON.parse(JSON.stringify(element.dataset || {})));
          if (userConfig.time_24hr === undefined &&
              flatpickr.defaultConfig.time_24hr === undefined) {
              self.config.time_24hr = self.l10n.time_24hr;
          }
          self.formatDate = createDateFormatter(self);
          self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });
      }
      function positionCalendar(customPositionElement) {
          if (typeof self.config.position === "function") {
              return void self.config.position(self, customPositionElement);
          }
          if (self.calendarContainer === undefined)
              return;
          triggerEvent("onPreCalendarPosition");
          const positionElement = customPositionElement || self._positionElement;
          const calendarHeight = Array.prototype.reduce.call(self.calendarContainer.children, ((acc, child) => acc + child.offsetHeight), 0), calendarWidth = self.calendarContainer.offsetWidth, configPos = self.config.position.split(" "), configPosVertical = configPos[0], configPosHorizontal = configPos.length > 1 ? configPos[1] : null, inputBounds = positionElement.getBoundingClientRect(), distanceFromBottom = window.innerHeight - inputBounds.bottom, showOnTop = configPosVertical === "above" ||
              (configPosVertical !== "below" &&
                  distanceFromBottom < calendarHeight &&
                  inputBounds.top > calendarHeight);
          const top = window.pageYOffset +
              inputBounds.top +
              (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);
          toggleClass(self.calendarContainer, "arrowTop", !showOnTop);
          toggleClass(self.calendarContainer, "arrowBottom", showOnTop);
          if (self.config.inline)
              return;
          let left = window.pageXOffset + inputBounds.left;
          let isCenter = false;
          let isRight = false;
          if (configPosHorizontal === "center") {
              left -= (calendarWidth - inputBounds.width) / 2;
              isCenter = true;
          }
          else if (configPosHorizontal === "right") {
              left -= calendarWidth - inputBounds.width;
              isRight = true;
          }
          toggleClass(self.calendarContainer, "arrowLeft", !isCenter && !isRight);
          toggleClass(self.calendarContainer, "arrowCenter", isCenter);
          toggleClass(self.calendarContainer, "arrowRight", isRight);
          const right = window.document.body.offsetWidth -
              (window.pageXOffset + inputBounds.right);
          const rightMost = left + calendarWidth > window.document.body.offsetWidth;
          const centerMost = right + calendarWidth > window.document.body.offsetWidth;
          toggleClass(self.calendarContainer, "rightMost", rightMost);
          if (self.config.static)
              return;
          self.calendarContainer.style.top = `${top}px`;
          if (!rightMost) {
              self.calendarContainer.style.left = `${left}px`;
              self.calendarContainer.style.right = "auto";
          }
          else if (!centerMost) {
              self.calendarContainer.style.left = "auto";
              self.calendarContainer.style.right = `${right}px`;
          }
          else {
              const doc = getDocumentStyleSheet();
              if (doc === undefined)
                  return;
              const bodyWidth = window.document.body.offsetWidth;
              const centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);
              const centerBefore = ".flatpickr-calendar.centerMost:before";
              const centerAfter = ".flatpickr-calendar.centerMost:after";
              const centerIndex = doc.cssRules.length;
              const centerStyle = `{left:${inputBounds.left}px;right:auto;}`;
              toggleClass(self.calendarContainer, "rightMost", false);
              toggleClass(self.calendarContainer, "centerMost", true);
              doc.insertRule(`${centerBefore},${centerAfter}${centerStyle}`, centerIndex);
              self.calendarContainer.style.left = `${centerLeft}px`;
              self.calendarContainer.style.right = "auto";
          }
      }
      function getDocumentStyleSheet() {
          let editableSheet = null;
          for (let i = 0; i < document.styleSheets.length; i++) {
              const sheet = document.styleSheets[i];
              try {
                  sheet.cssRules;
              }
              catch (err) {
                  continue;
              }
              editableSheet = sheet;
              break;
          }
          return editableSheet != null ? editableSheet : createStyleSheet();
      }
      function createStyleSheet() {
          const style = document.createElement("style");
          document.head.appendChild(style);
          return style.sheet;
      }
      function redraw() {
          if (self.config.noCalendar || self.isMobile)
              return;
          buildMonthSwitch();
          updateNavigationCurrentMonth();
          buildDays();
      }
      function focusAndClose() {
          self._input.focus();
          if (window.navigator.userAgent.indexOf("MSIE") !== -1 ||
              navigator.msMaxTouchPoints !== undefined) {
              setTimeout(self.close, 0);
          }
          else {
              self.close();
          }
      }
      function selectDate(e) {
          e.preventDefault();
          e.stopPropagation();
          const isSelectable = (day) => day.classList &&
              day.classList.contains("flatpickr-day") &&
              !day.classList.contains("flatpickr-disabled") &&
              !day.classList.contains("notAllowed");
          const t = findParent(getEventTarget(e), isSelectable);
          if (t === undefined)
              return;
          const target = t;
          const selectedDate = (self.latestSelectedDateObj = new Date(target.dateObj.getTime()));
          const shouldChangeMonth = (selectedDate.getMonth() < self.currentMonth ||
              selectedDate.getMonth() >
                  self.currentMonth + self.config.showMonths - 1) &&
              self.config.mode !== "range";
          self.selectedDateElem = target;
          if (self.config.mode === "single")
              self.selectedDates = [selectedDate];
          else if (self.config.mode === "multiple") {
              const selectedIndex = isDateSelected(selectedDate);
              if (selectedIndex)
                  self.selectedDates.splice(parseInt(selectedIndex), 1);
              else
                  self.selectedDates.push(selectedDate);
          }
          else if (self.config.mode === "range") {
              if (self.selectedDates.length === 2) {
                  self.clear(false, false);
              }
              self.latestSelectedDateObj = selectedDate;
              self.selectedDates.push(selectedDate);
              if (compareDates(selectedDate, self.selectedDates[0], true) !== 0)
                  self.selectedDates.sort((a, b) => a.getTime() - b.getTime());
          }
          setHoursFromInputs();
          if (shouldChangeMonth) {
              const isNewYear = self.currentYear !== selectedDate.getFullYear();
              self.currentYear = selectedDate.getFullYear();
              self.currentMonth = selectedDate.getMonth();
              if (isNewYear) {
                  triggerEvent("onYearChange");
                  buildMonthSwitch();
              }
              triggerEvent("onMonthChange");
          }
          updateNavigationCurrentMonth();
          buildDays();
          updateValue();
          if (!shouldChangeMonth &&
              self.config.mode !== "range" &&
              self.config.showMonths === 1)
              focusOnDayElem(target);
          else if (self.selectedDateElem !== undefined &&
              self.hourElement === undefined) {
              self.selectedDateElem && self.selectedDateElem.focus();
          }
          if (self.hourElement !== undefined)
              self.hourElement !== undefined && self.hourElement.focus();
          if (self.config.closeOnSelect) {
              const single = self.config.mode === "single" && !self.config.enableTime;
              const range = self.config.mode === "range" &&
                  self.selectedDates.length === 2 &&
                  !self.config.enableTime;
              if (single || range) {
                  focusAndClose();
              }
          }
          triggerChange();
      }
      const CALLBACKS = {
          locale: [setupLocale, updateWeekdays],
          showMonths: [buildMonths, setCalendarWidth, buildWeekdays],
          minDate: [jumpToDate],
          maxDate: [jumpToDate],
          clickOpens: [
              () => {
                  if (self.config.clickOpens === true) {
                      bind(self._input, "focus", self.open);
                      bind(self._input, "click", self.open);
                  }
                  else {
                      self._input.removeEventListener("focus", self.open);
                      self._input.removeEventListener("click", self.open);
                  }
              },
          ],
      };
      function set(option, value) {
          if (option !== null && typeof option === "object") {
              Object.assign(self.config, option);
              for (const key in option) {
                  if (CALLBACKS[key] !== undefined)
                      CALLBACKS[key].forEach((x) => x());
              }
          }
          else {
              self.config[option] = value;
              if (CALLBACKS[option] !== undefined)
                  CALLBACKS[option].forEach((x) => x());
              else if (HOOKS.indexOf(option) > -1)
                  self.config[option] = arrayify(value);
          }
          self.redraw();
          updateValue(true);
      }
      function setSelectedDate(inputDate, format) {
          let dates = [];
          if (inputDate instanceof Array)
              dates = inputDate.map((d) => self.parseDate(d, format));
          else if (inputDate instanceof Date || typeof inputDate === "number")
              dates = [self.parseDate(inputDate, format)];
          else if (typeof inputDate === "string") {
              switch (self.config.mode) {
                  case "single":
                  case "time":
                      dates = [self.parseDate(inputDate, format)];
                      break;
                  case "multiple":
                      dates = inputDate
                          .split(self.config.conjunction)
                          .map((date) => self.parseDate(date, format));
                      break;
                  case "range":
                      dates = inputDate
                          .split(self.l10n.rangeSeparator)
                          .map((date) => self.parseDate(date, format));
                      break;
              }
          }
          else
              self.config.errorHandler(new Error(`Invalid date supplied: ${JSON.stringify(inputDate)}`));
          self.selectedDates = (self.config.allowInvalidPreload
              ? dates
              : dates.filter((d) => d instanceof Date && isEnabled(d, false)));
          if (self.config.mode === "range")
              self.selectedDates.sort((a, b) => a.getTime() - b.getTime());
      }
      function setDate(date, triggerChange = false, format = self.config.dateFormat) {
          if ((date !== 0 && !date) || (date instanceof Array && date.length === 0))
              return self.clear(triggerChange);
          setSelectedDate(date, format);
          self.latestSelectedDateObj =
              self.selectedDates[self.selectedDates.length - 1];
          self.redraw();
          jumpToDate(undefined, triggerChange);
          setHoursFromDate();
          if (self.selectedDates.length === 0) {
              self.clear(false);
          }
          updateValue(triggerChange);
          if (triggerChange)
              triggerEvent("onChange");
      }
      function parseDateRules(arr) {
          return arr
              .slice()
              .map((rule) => {
              if (typeof rule === "string" ||
                  typeof rule === "number" ||
                  rule instanceof Date) {
                  return self.parseDate(rule, undefined, true);
              }
              else if (rule &&
                  typeof rule === "object" &&
                  rule.from &&
                  rule.to)
                  return {
                      from: self.parseDate(rule.from, undefined),
                      to: self.parseDate(rule.to, undefined),
                  };
              return rule;
          })
              .filter((x) => x);
      }
      function setupDates() {
          self.selectedDates = [];
          self.now = self.parseDate(self.config.now) || new Date();
          const preloadedDate = self.config.defaultDate ||
              ((self.input.nodeName === "INPUT" ||
                  self.input.nodeName === "TEXTAREA") &&
                  self.input.placeholder &&
                  self.input.value === self.input.placeholder
                  ? null
                  : self.input.value);
          if (preloadedDate)
              setSelectedDate(preloadedDate, self.config.dateFormat);
          self._initialDate =
              self.selectedDates.length > 0
                  ? self.selectedDates[0]
                  : self.config.minDate &&
                      self.config.minDate.getTime() > self.now.getTime()
                      ? self.config.minDate
                      : self.config.maxDate &&
                          self.config.maxDate.getTime() < self.now.getTime()
                          ? self.config.maxDate
                          : self.now;
          self.currentYear = self._initialDate.getFullYear();
          self.currentMonth = self._initialDate.getMonth();
          if (self.selectedDates.length > 0)
              self.latestSelectedDateObj = self.selectedDates[0];
          if (self.config.minTime !== undefined)
              self.config.minTime = self.parseDate(self.config.minTime, "H:i");
          if (self.config.maxTime !== undefined)
              self.config.maxTime = self.parseDate(self.config.maxTime, "H:i");
          self.minDateHasTime =
              !!self.config.minDate &&
                  (self.config.minDate.getHours() > 0 ||
                      self.config.minDate.getMinutes() > 0 ||
                      self.config.minDate.getSeconds() > 0);
          self.maxDateHasTime =
              !!self.config.maxDate &&
                  (self.config.maxDate.getHours() > 0 ||
                      self.config.maxDate.getMinutes() > 0 ||
                      self.config.maxDate.getSeconds() > 0);
      }
      function setupInputs() {
          self.input = getInputElem();
          if (!self.input) {
              self.config.errorHandler(new Error("Invalid input element specified"));
              return;
          }
          self.input._type = self.input.type;
          self.input.type = "text";
          self.input.classList.add("flatpickr-input");
          self._input = self.input;
          if (self.config.altInput) {
              self.altInput = createElement(self.input.nodeName, self.config.altInputClass);
              self._input = self.altInput;
              self.altInput.placeholder = self.input.placeholder;
              self.altInput.disabled = self.input.disabled;
              self.altInput.required = self.input.required;
              self.altInput.tabIndex = self.input.tabIndex;
              self.altInput.type = "text";
              self.input.setAttribute("type", "hidden");
              if (!self.config.static && self.input.parentNode)
                  self.input.parentNode.insertBefore(self.altInput, self.input.nextSibling);
          }
          if (!self.config.allowInput)
              self._input.setAttribute("readonly", "readonly");
          self._positionElement = self.config.positionElement || self._input;
      }
      function setupMobile() {
          const inputType = self.config.enableTime
              ? self.config.noCalendar
                  ? "time"
                  : "datetime-local"
              : "date";
          self.mobileInput = createElement("input", self.input.className + " flatpickr-mobile");
          self.mobileInput.tabIndex = 1;
          self.mobileInput.type = inputType;
          self.mobileInput.disabled = self.input.disabled;
          self.mobileInput.required = self.input.required;
          self.mobileInput.placeholder = self.input.placeholder;
          self.mobileFormatStr =
              inputType === "datetime-local"
                  ? "Y-m-d\\TH:i:S"
                  : inputType === "date"
                      ? "Y-m-d"
                      : "H:i:S";
          if (self.selectedDates.length > 0) {
              self.mobileInput.defaultValue = self.mobileInput.value = self.formatDate(self.selectedDates[0], self.mobileFormatStr);
          }
          if (self.config.minDate)
              self.mobileInput.min = self.formatDate(self.config.minDate, "Y-m-d");
          if (self.config.maxDate)
              self.mobileInput.max = self.formatDate(self.config.maxDate, "Y-m-d");
          if (self.input.getAttribute("step"))
              self.mobileInput.step = String(self.input.getAttribute("step"));
          self.input.type = "hidden";
          if (self.altInput !== undefined)
              self.altInput.type = "hidden";
          try {
              if (self.input.parentNode)
                  self.input.parentNode.insertBefore(self.mobileInput, self.input.nextSibling);
          }
          catch (_a) { }
          bind(self.mobileInput, "change", (e) => {
              self.setDate(getEventTarget(e).value, false, self.mobileFormatStr);
              triggerEvent("onChange");
              triggerEvent("onClose");
          });
      }
      function toggle(e) {
          if (self.isOpen === true)
              return self.close();
          self.open(e);
      }
      function triggerEvent(event, data) {
          if (self.config === undefined)
              return;
          const hooks = self.config[event];
          if (hooks !== undefined && hooks.length > 0) {
              for (let i = 0; hooks[i] && i < hooks.length; i++)
                  hooks[i](self.selectedDates, self.input.value, self, data);
          }
          if (event === "onChange") {
              self.input.dispatchEvent(createEvent("change"));
              self.input.dispatchEvent(createEvent("input"));
          }
      }
      function createEvent(name) {
          const e = document.createEvent("Event");
          e.initEvent(name, true, true);
          return e;
      }
      function isDateSelected(date) {
          for (let i = 0; i < self.selectedDates.length; i++) {
              if (compareDates(self.selectedDates[i], date) === 0)
                  return "" + i;
          }
          return false;
      }
      function isDateInRange(date) {
          if (self.config.mode !== "range" || self.selectedDates.length < 2)
              return false;
          return (compareDates(date, self.selectedDates[0]) >= 0 &&
              compareDates(date, self.selectedDates[1]) <= 0);
      }
      function updateNavigationCurrentMonth() {
          if (self.config.noCalendar || self.isMobile || !self.monthNav)
              return;
          self.yearElements.forEach((yearElement, i) => {
              const d = new Date(self.currentYear, self.currentMonth, 1);
              d.setMonth(self.currentMonth + i);
              if (self.config.showMonths > 1 ||
                  self.config.monthSelectorType === "static") {
                  self.monthElements[i].textContent =
                      monthToStr$1(d.getMonth(), self.config.shorthandCurrentMonth, self.l10n) + " ";
              }
              else {
                  self.monthsDropdownContainer.value = d.getMonth().toString();
              }
              yearElement.value = d.getFullYear().toString();
          });
          self._hidePrevMonthArrow =
              self.config.minDate !== undefined &&
                  (self.currentYear === self.config.minDate.getFullYear()
                      ? self.currentMonth <= self.config.minDate.getMonth()
                      : self.currentYear < self.config.minDate.getFullYear());
          self._hideNextMonthArrow =
              self.config.maxDate !== undefined &&
                  (self.currentYear === self.config.maxDate.getFullYear()
                      ? self.currentMonth + 1 > self.config.maxDate.getMonth()
                      : self.currentYear > self.config.maxDate.getFullYear());
      }
      function getDateStr(format) {
          return self.selectedDates
              .map((dObj) => self.formatDate(dObj, format))
              .filter((d, i, arr) => self.config.mode !== "range" ||
              self.config.enableTime ||
              arr.indexOf(d) === i)
              .join(self.config.mode !== "range"
              ? self.config.conjunction
              : self.l10n.rangeSeparator);
      }
      function updateValue(triggerChange = true) {
          if (self.mobileInput !== undefined && self.mobileFormatStr) {
              self.mobileInput.value =
                  self.latestSelectedDateObj !== undefined
                      ? self.formatDate(self.latestSelectedDateObj, self.mobileFormatStr)
                      : "";
          }
          self.input.value = getDateStr(self.config.dateFormat);
          if (self.altInput !== undefined) {
              self.altInput.value = getDateStr(self.config.altFormat);
          }
          if (triggerChange !== false)
              triggerEvent("onValueUpdate");
      }
      function onMonthNavClick(e) {
          const eventTarget = getEventTarget(e);
          const isPrevMonth = self.prevMonthNav.contains(eventTarget);
          const isNextMonth = self.nextMonthNav.contains(eventTarget);
          if (isPrevMonth || isNextMonth) {
              changeMonth(isPrevMonth ? -1 : 1);
          }
          else if (self.yearElements.indexOf(eventTarget) >= 0) {
              eventTarget.select();
          }
          else if (eventTarget.classList.contains("arrowUp")) {
              self.changeYear(self.currentYear + 1);
          }
          else if (eventTarget.classList.contains("arrowDown")) {
              self.changeYear(self.currentYear - 1);
          }
      }
      function timeWrapper(e) {
          e.preventDefault();
          const isKeyDown = e.type === "keydown", eventTarget = getEventTarget(e), input = eventTarget;
          if (self.amPM !== undefined && eventTarget === self.amPM) {
              self.amPM.textContent =
                  self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];
          }
          const min = parseFloat(input.getAttribute("min")), max = parseFloat(input.getAttribute("max")), step = parseFloat(input.getAttribute("step")), curValue = parseInt(input.value, 10), delta = e.delta ||
              (isKeyDown ? (e.which === 38 ? 1 : -1) : 0);
          let newValue = curValue + step * delta;
          if (typeof input.value !== "undefined" && input.value.length === 2) {
              const isHourElem = input === self.hourElement, isMinuteElem = input === self.minuteElement;
              if (newValue < min) {
                  newValue =
                      max +
                          newValue +
                          int(!isHourElem) +
                          (int(isHourElem) && int(!self.amPM));
                  if (isMinuteElem)
                      incrementNumInput(undefined, -1, self.hourElement);
              }
              else if (newValue > max) {
                  newValue =
                      input === self.hourElement ? newValue - max - int(!self.amPM) : min;
                  if (isMinuteElem)
                      incrementNumInput(undefined, 1, self.hourElement);
              }
              if (self.amPM &&
                  isHourElem &&
                  (step === 1
                      ? newValue + curValue === 23
                      : Math.abs(newValue - curValue) > step)) {
                  self.amPM.textContent =
                      self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];
              }
              input.value = pad(newValue);
          }
      }
      init();
      return self;
  }
  function _flatpickr(nodeList, config) {
      const nodes = Array.prototype.slice
          .call(nodeList)
          .filter((x) => x instanceof HTMLElement);
      const instances = [];
      for (let i = 0; i < nodes.length; i++) {
          const node = nodes[i];
          try {
              if (node.getAttribute("data-fp-omit") !== null)
                  continue;
              if (node._flatpickr !== undefined) {
                  node._flatpickr.destroy();
                  node._flatpickr = undefined;
              }
              node._flatpickr = FlatpickrInstance(node, config || {});
              instances.push(node._flatpickr);
          }
          catch (e) {
              console.error(e);
          }
      }
      return instances.length === 1 ? instances[0] : instances;
  }
  if (typeof HTMLElement !== "undefined" &&
      typeof HTMLCollection !== "undefined" &&
      typeof NodeList !== "undefined") {
      HTMLCollection.prototype.flatpickr = NodeList.prototype.flatpickr = function (config) {
          return _flatpickr(this, config);
      };
      HTMLElement.prototype.flatpickr = function (config) {
          return _flatpickr([this], config);
      };
  }
  var flatpickr = function (selector, config) {
      if (typeof selector === "string") {
          return _flatpickr(window.document.querySelectorAll(selector), config);
      }
      else if (selector instanceof Node) {
          return _flatpickr([selector], config);
      }
      else {
          return _flatpickr(selector, config);
      }
  };
  flatpickr.defaultConfig = {};
  flatpickr.l10ns = {
      en: Object.assign({}, english),
      default: Object.assign({}, english),
  };
  flatpickr.localize = (l10n) => {
      flatpickr.l10ns.default = Object.assign(Object.assign({}, flatpickr.l10ns.default), l10n);
  };
  flatpickr.setDefaults = (config) => {
      flatpickr.defaultConfig = Object.assign(Object.assign({}, flatpickr.defaultConfig), config);
  };
  flatpickr.parseDate = createDateParser({});
  flatpickr.formatDate = createDateFormatter({});
  flatpickr.compareDates = compareDates;
  if (typeof jQuery !== "undefined" && typeof jQuery.fn !== "undefined") {
      jQuery.fn.flatpickr = function (config) {
          return _flatpickr(this, config);
      };
  }
  Date.prototype.fp_incr = function (days) {
      return new Date(this.getFullYear(), this.getMonth(), this.getDate() + (typeof days === "string" ? parseInt(days, 10) : days));
  };
  if (typeof window !== "undefined") {
      window.flatpickr = flatpickr;
  }

  var l10n = createCommonjsModule(function (module, exports) {
  (function (global, factory) {
      factory(exports) ;
  }(commonjsGlobal, (function (exports) {
      /*! *****************************************************************************
      Copyright (c) Microsoft Corporation.

      Permission to use, copy, modify, and/or distribute this software for any
      purpose with or without fee is hereby granted.

      THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
      REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
      AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
      INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
      LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
      OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
      PERFORMANCE OF THIS SOFTWARE.
      ***************************************************************************** */

      var __assign = function() {
          __assign = Object.assign || function __assign(t) {
              for (var s, i = 1, n = arguments.length; i < n; i++) {
                  s = arguments[i];
                  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
              }
              return t;
          };
          return __assign.apply(this, arguments);
      };

      var fp = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Arabic = {
          weekdays: {
              shorthand: ["أحد", "اثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"],
              longhand: [
                  "الأحد",
                  "الاثنين",
                  "الثلاثاء",
                  "الأربعاء",
                  "الخميس",
                  "الجمعة",
                  "السبت",
              ],
          },
          months: {
              shorthand: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"],
              longhand: [
                  "يناير",
                  "فبراير",
                  "مارس",
                  "أبريل",
                  "مايو",
                  "يونيو",
                  "يوليو",
                  "أغسطس",
                  "سبتمبر",
                  "أكتوبر",
                  "نوفمبر",
                  "ديسمبر",
              ],
          },
          rangeSeparator: " - ",
      };
      fp.l10ns.ar = Arabic;
      fp.l10ns;

      var fp$1 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Austria = {
          weekdays: {
              shorthand: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
              longhand: [
                  "Sonntag",
                  "Montag",
                  "Dienstag",
                  "Mittwoch",
                  "Donnerstag",
                  "Freitag",
                  "Samstag",
              ],
          },
          months: {
              shorthand: [
                  "Jän",
                  "Feb",
                  "Mär",
                  "Apr",
                  "Mai",
                  "Jun",
                  "Jul",
                  "Aug",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dez",
              ],
              longhand: [
                  "Jänner",
                  "Februar",
                  "März",
                  "April",
                  "Mai",
                  "Juni",
                  "Juli",
                  "August",
                  "September",
                  "Oktober",
                  "November",
                  "Dezember",
              ],
          },
          firstDayOfWeek: 1,
          weekAbbreviation: "KW",
          rangeSeparator: " bis ",
          scrollTitle: "Zum Ändern scrollen",
          toggleTitle: "Zum Umschalten klicken",
      };
      fp$1.l10ns.at = Austria;
      fp$1.l10ns;

      var fp$2 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Azerbaijan = {
          weekdays: {
              shorthand: ["B.", "B.e.", "Ç.a.", "Ç.", "C.a.", "C.", "Ş."],
              longhand: [
                  "Bazar",
                  "Bazar ertəsi",
                  "Çərşənbə axşamı",
                  "Çərşənbə",
                  "Cümə axşamı",
                  "Cümə",
                  "Şənbə",
              ],
          },
          months: {
              shorthand: [
                  "Yan",
                  "Fev",
                  "Mar",
                  "Apr",
                  "May",
                  "İyn",
                  "İyl",
                  "Avq",
                  "Sen",
                  "Okt",
                  "Noy",
                  "Dek",
              ],
              longhand: [
                  "Yanvar",
                  "Fevral",
                  "Mart",
                  "Aprel",
                  "May",
                  "İyun",
                  "İyul",
                  "Avqust",
                  "Sentyabr",
                  "Oktyabr",
                  "Noyabr",
                  "Dekabr",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return ".";
          },
          rangeSeparator: " - ",
          weekAbbreviation: "Hf",
          scrollTitle: "Artırmaq üçün sürüşdürün",
          toggleTitle: "Aç / Bağla",
          amPM: ["GƏ", "GS"],
          time_24hr: true,
      };
      fp$2.l10ns.az = Azerbaijan;
      fp$2.l10ns;

      var fp$3 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Belarusian = {
          weekdays: {
              shorthand: ["Нд", "Пн", "Аў", "Ср", "Чц", "Пт", "Сб"],
              longhand: [
                  "Нядзеля",
                  "Панядзелак",
                  "Аўторак",
                  "Серада",
                  "Чацвер",
                  "Пятніца",
                  "Субота",
              ],
          },
          months: {
              shorthand: [
                  "Сту",
                  "Лют",
                  "Сак",
                  "Кра",
                  "Тра",
                  "Чэр",
                  "Ліп",
                  "Жні",
                  "Вер",
                  "Кас",
                  "Ліс",
                  "Сне",
              ],
              longhand: [
                  "Студзень",
                  "Люты",
                  "Сакавік",
                  "Красавік",
                  "Травень",
                  "Чэрвень",
                  "Ліпень",
                  "Жнівень",
                  "Верасень",
                  "Кастрычнік",
                  "Лістапад",
                  "Снежань",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          rangeSeparator: " — ",
          weekAbbreviation: "Тыд.",
          scrollTitle: "Пракруціце для павелічэння",
          toggleTitle: "Націсніце для пераключэння",
          amPM: ["ДП", "ПП"],
          yearAriaLabel: "Год",
          time_24hr: true,
      };
      fp$3.l10ns.be = Belarusian;
      fp$3.l10ns;

      var fp$4 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Bosnian = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"],
              longhand: [
                  "Nedjelja",
                  "Ponedjeljak",
                  "Utorak",
                  "Srijeda",
                  "Četvrtak",
                  "Petak",
                  "Subota",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Maj",
                  "Jun",
                  "Jul",
                  "Avg",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "Januar",
                  "Februar",
                  "Mart",
                  "April",
                  "Maj",
                  "Juni",
                  "Juli",
                  "Avgust",
                  "Septembar",
                  "Oktobar",
                  "Novembar",
                  "Decembar",
              ],
          },
          time_24hr: true,
      };
      fp$4.l10ns.bs = Bosnian;
      fp$4.l10ns;

      var fp$5 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Bulgarian = {
          weekdays: {
              shorthand: ["Нд", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
              longhand: [
                  "Неделя",
                  "Понеделник",
                  "Вторник",
                  "Сряда",
                  "Четвъртък",
                  "Петък",
                  "Събота",
              ],
          },
          months: {
              shorthand: [
                  "Яну",
                  "Фев",
                  "Март",
                  "Апр",
                  "Май",
                  "Юни",
                  "Юли",
                  "Авг",
                  "Сеп",
                  "Окт",
                  "Ное",
                  "Дек",
              ],
              longhand: [
                  "Януари",
                  "Февруари",
                  "Март",
                  "Април",
                  "Май",
                  "Юни",
                  "Юли",
                  "Август",
                  "Септември",
                  "Октомври",
                  "Ноември",
                  "Декември",
              ],
          },
          time_24hr: true,
          firstDayOfWeek: 1,
      };
      fp$5.l10ns.bg = Bulgarian;
      fp$5.l10ns;

      var fp$6 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Bangla = {
          weekdays: {
              shorthand: ["রবি", "সোম", "মঙ্গল", "বুধ", "বৃহস্পতি", "শুক্র", "শনি"],
              longhand: [
                  "রবিবার",
                  "সোমবার",
                  "মঙ্গলবার",
                  "বুধবার",
                  "বৃহস্পতিবার",
                  "শুক্রবার",
                  "শনিবার",
              ],
          },
          months: {
              shorthand: [
                  "জানু",
                  "ফেব্রু",
                  "মার্চ",
                  "এপ্রিল",
                  "মে",
                  "জুন",
                  "জুলাই",
                  "আগ",
                  "সেপ্টে",
                  "অক্টো",
                  "নভে",
                  "ডিসে",
              ],
              longhand: [
                  "জানুয়ারী",
                  "ফেব্রুয়ারী",
                  "মার্চ",
                  "এপ্রিল",
                  "মে",
                  "জুন",
                  "জুলাই",
                  "আগস্ট",
                  "সেপ্টেম্বর",
                  "অক্টোবর",
                  "নভেম্বর",
                  "ডিসেম্বর",
              ],
          },
      };
      fp$6.l10ns.bn = Bangla;
      fp$6.l10ns;

      var fp$7 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Catalan = {
          weekdays: {
              shorthand: ["Dg", "Dl", "Dt", "Dc", "Dj", "Dv", "Ds"],
              longhand: [
                  "Diumenge",
                  "Dilluns",
                  "Dimarts",
                  "Dimecres",
                  "Dijous",
                  "Divendres",
                  "Dissabte",
              ],
          },
          months: {
              shorthand: [
                  "Gen",
                  "Febr",
                  "Març",
                  "Abr",
                  "Maig",
                  "Juny",
                  "Jul",
                  "Ag",
                  "Set",
                  "Oct",
                  "Nov",
                  "Des",
              ],
              longhand: [
                  "Gener",
                  "Febrer",
                  "Març",
                  "Abril",
                  "Maig",
                  "Juny",
                  "Juliol",
                  "Agost",
                  "Setembre",
                  "Octubre",
                  "Novembre",
                  "Desembre",
              ],
          },
          ordinal: function (nth) {
              var s = nth % 100;
              if (s > 3 && s < 21)
                  return "è";
              switch (s % 10) {
                  case 1:
                      return "r";
                  case 2:
                      return "n";
                  case 3:
                      return "r";
                  case 4:
                      return "t";
                  default:
                      return "è";
              }
          },
          firstDayOfWeek: 1,
          time_24hr: true,
      };
      fp$7.l10ns.cat = fp$7.l10ns.ca = Catalan;
      fp$7.l10ns;

      var fp$8 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Czech = {
          weekdays: {
              shorthand: ["Ne", "Po", "Út", "St", "Čt", "Pá", "So"],
              longhand: [
                  "Neděle",
                  "Pondělí",
                  "Úterý",
                  "Středa",
                  "Čtvrtek",
                  "Pátek",
                  "Sobota",
              ],
          },
          months: {
              shorthand: [
                  "Led",
                  "Ún",
                  "Bře",
                  "Dub",
                  "Kvě",
                  "Čer",
                  "Čvc",
                  "Srp",
                  "Zář",
                  "Říj",
                  "Lis",
                  "Pro",
              ],
              longhand: [
                  "Leden",
                  "Únor",
                  "Březen",
                  "Duben",
                  "Květen",
                  "Červen",
                  "Červenec",
                  "Srpen",
                  "Září",
                  "Říjen",
                  "Listopad",
                  "Prosinec",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return ".";
          },
          rangeSeparator: " do ",
          weekAbbreviation: "Týd.",
          scrollTitle: "Rolujte pro změnu",
          toggleTitle: "Přepnout dopoledne/odpoledne",
          amPM: ["dop.", "odp."],
          yearAriaLabel: "Rok",
          time_24hr: true,
      };
      fp$8.l10ns.cs = Czech;
      fp$8.l10ns;

      var fp$9 = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Welsh = {
          weekdays: {
              shorthand: ["Sul", "Llun", "Maw", "Mer", "Iau", "Gwe", "Sad"],
              longhand: [
                  "Dydd Sul",
                  "Dydd Llun",
                  "Dydd Mawrth",
                  "Dydd Mercher",
                  "Dydd Iau",
                  "Dydd Gwener",
                  "Dydd Sadwrn",
              ],
          },
          months: {
              shorthand: [
                  "Ion",
                  "Chwef",
                  "Maw",
                  "Ebr",
                  "Mai",
                  "Meh",
                  "Gorff",
                  "Awst",
                  "Medi",
                  "Hyd",
                  "Tach",
                  "Rhag",
              ],
              longhand: [
                  "Ionawr",
                  "Chwefror",
                  "Mawrth",
                  "Ebrill",
                  "Mai",
                  "Mehefin",
                  "Gorffennaf",
                  "Awst",
                  "Medi",
                  "Hydref",
                  "Tachwedd",
                  "Rhagfyr",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function (nth) {
              if (nth === 1)
                  return "af";
              if (nth === 2)
                  return "ail";
              if (nth === 3 || nth === 4)
                  return "ydd";
              if (nth === 5 || nth === 6)
                  return "ed";
              if ((nth >= 7 && nth <= 10) ||
                  nth == 12 ||
                  nth == 15 ||
                  nth == 18 ||
                  nth == 20)
                  return "fed";
              if (nth == 11 ||
                  nth == 13 ||
                  nth == 14 ||
                  nth == 16 ||
                  nth == 17 ||
                  nth == 19)
                  return "eg";
              if (nth >= 21 && nth <= 39)
                  return "ain";
              // Inconclusive.
              return "";
          },
          time_24hr: true,
      };
      fp$9.l10ns.cy = Welsh;
      fp$9.l10ns;

      var fp$a = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Danish = {
          weekdays: {
              shorthand: ["søn", "man", "tir", "ons", "tors", "fre", "lør"],
              longhand: [
                  "søndag",
                  "mandag",
                  "tirsdag",
                  "onsdag",
                  "torsdag",
                  "fredag",
                  "lørdag",
              ],
          },
          months: {
              shorthand: [
                  "jan",
                  "feb",
                  "mar",
                  "apr",
                  "maj",
                  "jun",
                  "jul",
                  "aug",
                  "sep",
                  "okt",
                  "nov",
                  "dec",
              ],
              longhand: [
                  "januar",
                  "februar",
                  "marts",
                  "april",
                  "maj",
                  "juni",
                  "juli",
                  "august",
                  "september",
                  "oktober",
                  "november",
                  "december",
              ],
          },
          ordinal: function () {
              return ".";
          },
          firstDayOfWeek: 1,
          rangeSeparator: " til ",
          weekAbbreviation: "uge",
          time_24hr: true,
      };
      fp$a.l10ns.da = Danish;
      fp$a.l10ns;

      var fp$b = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var German = {
          weekdays: {
              shorthand: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
              longhand: [
                  "Sonntag",
                  "Montag",
                  "Dienstag",
                  "Mittwoch",
                  "Donnerstag",
                  "Freitag",
                  "Samstag",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mär",
                  "Apr",
                  "Mai",
                  "Jun",
                  "Jul",
                  "Aug",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dez",
              ],
              longhand: [
                  "Januar",
                  "Februar",
                  "März",
                  "April",
                  "Mai",
                  "Juni",
                  "Juli",
                  "August",
                  "September",
                  "Oktober",
                  "November",
                  "Dezember",
              ],
          },
          firstDayOfWeek: 1,
          weekAbbreviation: "KW",
          rangeSeparator: " bis ",
          scrollTitle: "Zum Ändern scrollen",
          toggleTitle: "Zum Umschalten klicken",
          time_24hr: true,
      };
      fp$b.l10ns.de = German;
      fp$b.l10ns;

      var english = {
          weekdays: {
              shorthand: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
              longhand: [
                  "Sunday",
                  "Monday",
                  "Tuesday",
                  "Wednesday",
                  "Thursday",
                  "Friday",
                  "Saturday",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "May",
                  "Jun",
                  "Jul",
                  "Aug",
                  "Sep",
                  "Oct",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "January",
                  "February",
                  "March",
                  "April",
                  "May",
                  "June",
                  "July",
                  "August",
                  "September",
                  "October",
                  "November",
                  "December",
              ],
          },
          daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
          firstDayOfWeek: 0,
          ordinal: function (nth) {
              var s = nth % 100;
              if (s > 3 && s < 21)
                  return "th";
              switch (s % 10) {
                  case 1:
                      return "st";
                  case 2:
                      return "nd";
                  case 3:
                      return "rd";
                  default:
                      return "th";
              }
          },
          rangeSeparator: " to ",
          weekAbbreviation: "Wk",
          scrollTitle: "Scroll to increment",
          toggleTitle: "Click to toggle",
          amPM: ["AM", "PM"],
          yearAriaLabel: "Year",
          monthAriaLabel: "Month",
          hourAriaLabel: "Hour",
          minuteAriaLabel: "Minute",
          time_24hr: false,
      };

      var fp$c = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Esperanto = {
          firstDayOfWeek: 1,
          rangeSeparator: " ĝis ",
          weekAbbreviation: "Sem",
          scrollTitle: "Rulumu por pligrandigi la valoron",
          toggleTitle: "Klaku por ŝalti",
          weekdays: {
              shorthand: ["Dim", "Lun", "Mar", "Mer", "Ĵaŭ", "Ven", "Sab"],
              longhand: [
                  "dimanĉo",
                  "lundo",
                  "mardo",
                  "merkredo",
                  "ĵaŭdo",
                  "vendredo",
                  "sabato",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Maj",
                  "Jun",
                  "Jul",
                  "Aŭg",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "januaro",
                  "februaro",
                  "marto",
                  "aprilo",
                  "majo",
                  "junio",
                  "julio",
                  "aŭgusto",
                  "septembro",
                  "oktobro",
                  "novembro",
                  "decembro",
              ],
          },
          ordinal: function () {
              return "-a";
          },
          time_24hr: true,
      };
      fp$c.l10ns.eo = Esperanto;
      fp$c.l10ns;

      var fp$d = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Spanish = {
          weekdays: {
              shorthand: ["Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"],
              longhand: [
                  "Domingo",
                  "Lunes",
                  "Martes",
                  "Miércoles",
                  "Jueves",
                  "Viernes",
                  "Sábado",
              ],
          },
          months: {
              shorthand: [
                  "Ene",
                  "Feb",
                  "Mar",
                  "Abr",
                  "May",
                  "Jun",
                  "Jul",
                  "Ago",
                  "Sep",
                  "Oct",
                  "Nov",
                  "Dic",
              ],
              longhand: [
                  "Enero",
                  "Febrero",
                  "Marzo",
                  "Abril",
                  "Mayo",
                  "Junio",
                  "Julio",
                  "Agosto",
                  "Septiembre",
                  "Octubre",
                  "Noviembre",
                  "Diciembre",
              ],
          },
          ordinal: function () {
              return "º";
          },
          firstDayOfWeek: 1,
          rangeSeparator: " a ",
          time_24hr: true,
      };
      fp$d.l10ns.es = Spanish;
      fp$d.l10ns;

      var fp$e = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Estonian = {
          weekdays: {
              shorthand: ["P", "E", "T", "K", "N", "R", "L"],
              longhand: [
                  "Pühapäev",
                  "Esmaspäev",
                  "Teisipäev",
                  "Kolmapäev",
                  "Neljapäev",
                  "Reede",
                  "Laupäev",
              ],
          },
          months: {
              shorthand: [
                  "Jaan",
                  "Veebr",
                  "Märts",
                  "Apr",
                  "Mai",
                  "Juuni",
                  "Juuli",
                  "Aug",
                  "Sept",
                  "Okt",
                  "Nov",
                  "Dets",
              ],
              longhand: [
                  "Jaanuar",
                  "Veebruar",
                  "Märts",
                  "Aprill",
                  "Mai",
                  "Juuni",
                  "Juuli",
                  "August",
                  "September",
                  "Oktoober",
                  "November",
                  "Detsember",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return ".";
          },
          weekAbbreviation: "Näd",
          rangeSeparator: " kuni ",
          scrollTitle: "Keri, et suurendada",
          toggleTitle: "Klõpsa, et vahetada",
          time_24hr: true,
      };
      fp$e.l10ns.et = Estonian;
      fp$e.l10ns;

      var fp$f = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Persian = {
          weekdays: {
              shorthand: ["یک", "دو", "سه", "چهار", "پنج", "جمعه", "شنبه"],
              longhand: [
                  "یک‌شنبه",
                  "دوشنبه",
                  "سه‌شنبه",
                  "چهارشنبه",
                  "پنچ‌شنبه",
                  "جمعه",
                  "شنبه",
              ],
          },
          months: {
              shorthand: [
                  "ژانویه",
                  "فوریه",
                  "مارس",
                  "آوریل",
                  "مه",
                  "ژوئن",
                  "ژوئیه",
                  "اوت",
                  "سپتامبر",
                  "اکتبر",
                  "نوامبر",
                  "دسامبر",
              ],
              longhand: [
                  "ژانویه",
                  "فوریه",
                  "مارس",
                  "آوریل",
                  "مه",
                  "ژوئن",
                  "ژوئیه",
                  "اوت",
                  "سپتامبر",
                  "اکتبر",
                  "نوامبر",
                  "دسامبر",
              ],
          },
          firstDayOfWeek: 6,
          ordinal: function () {
              return "";
          },
      };
      fp$f.l10ns.fa = Persian;
      fp$f.l10ns;

      var fp$g = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Finnish = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["Su", "Ma", "Ti", "Ke", "To", "Pe", "La"],
              longhand: [
                  "Sunnuntai",
                  "Maanantai",
                  "Tiistai",
                  "Keskiviikko",
                  "Torstai",
                  "Perjantai",
                  "Lauantai",
              ],
          },
          months: {
              shorthand: [
                  "Tammi",
                  "Helmi",
                  "Maalis",
                  "Huhti",
                  "Touko",
                  "Kesä",
                  "Heinä",
                  "Elo",
                  "Syys",
                  "Loka",
                  "Marras",
                  "Joulu",
              ],
              longhand: [
                  "Tammikuu",
                  "Helmikuu",
                  "Maaliskuu",
                  "Huhtikuu",
                  "Toukokuu",
                  "Kesäkuu",
                  "Heinäkuu",
                  "Elokuu",
                  "Syyskuu",
                  "Lokakuu",
                  "Marraskuu",
                  "Joulukuu",
              ],
          },
          ordinal: function () {
              return ".";
          },
          time_24hr: true,
      };
      fp$g.l10ns.fi = Finnish;
      fp$g.l10ns;

      var fp$h = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Faroese = {
          weekdays: {
              shorthand: ["Sun", "Mán", "Týs", "Mik", "Hós", "Frí", "Ley"],
              longhand: [
                  "Sunnudagur",
                  "Mánadagur",
                  "Týsdagur",
                  "Mikudagur",
                  "Hósdagur",
                  "Fríggjadagur",
                  "Leygardagur",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Mai",
                  "Jun",
                  "Jul",
                  "Aug",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Des",
              ],
              longhand: [
                  "Januar",
                  "Februar",
                  "Mars",
                  "Apríl",
                  "Mai",
                  "Juni",
                  "Juli",
                  "August",
                  "Septembur",
                  "Oktobur",
                  "Novembur",
                  "Desembur",
              ],
          },
          ordinal: function () {
              return ".";
          },
          firstDayOfWeek: 1,
          rangeSeparator: " til ",
          weekAbbreviation: "vika",
          scrollTitle: "Rulla fyri at broyta",
          toggleTitle: "Trýst fyri at skifta",
          yearAriaLabel: "Ár",
          time_24hr: true,
      };
      fp$h.l10ns.fo = Faroese;
      fp$h.l10ns;

      var fp$i = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var French = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["dim", "lun", "mar", "mer", "jeu", "ven", "sam"],
              longhand: [
                  "dimanche",
                  "lundi",
                  "mardi",
                  "mercredi",
                  "jeudi",
                  "vendredi",
                  "samedi",
              ],
          },
          months: {
              shorthand: [
                  "janv",
                  "févr",
                  "mars",
                  "avr",
                  "mai",
                  "juin",
                  "juil",
                  "août",
                  "sept",
                  "oct",
                  "nov",
                  "déc",
              ],
              longhand: [
                  "janvier",
                  "février",
                  "mars",
                  "avril",
                  "mai",
                  "juin",
                  "juillet",
                  "août",
                  "septembre",
                  "octobre",
                  "novembre",
                  "décembre",
              ],
          },
          ordinal: function (nth) {
              if (nth > 1)
                  return "";
              return "er";
          },
          rangeSeparator: " au ",
          weekAbbreviation: "Sem",
          scrollTitle: "Défiler pour augmenter la valeur",
          toggleTitle: "Cliquer pour basculer",
          time_24hr: true,
      };
      fp$i.l10ns.fr = French;
      fp$i.l10ns;

      var fp$j = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Greek = {
          weekdays: {
              shorthand: ["Κυ", "Δε", "Τρ", "Τε", "Πέ", "Πα", "Σά"],
              longhand: [
                  "Κυριακή",
                  "Δευτέρα",
                  "Τρίτη",
                  "Τετάρτη",
                  "Πέμπτη",
                  "Παρασκευή",
                  "Σάββατο",
              ],
          },
          months: {
              shorthand: [
                  "Ιαν",
                  "Φεβ",
                  "Μάρ",
                  "Απρ",
                  "Μάι",
                  "Ιού",
                  "Ιού",
                  "Αύγ",
                  "Σεπ",
                  "Οκτ",
                  "Νοέ",
                  "Δεκ",
              ],
              longhand: [
                  "Ιανουάριος",
                  "Φεβρουάριος",
                  "Μάρτιος",
                  "Απρίλιος",
                  "Μάιος",
                  "Ιούνιος",
                  "Ιούλιος",
                  "Αύγουστος",
                  "Σεπτέμβριος",
                  "Οκτώβριος",
                  "Νοέμβριος",
                  "Δεκέμβριος",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          weekAbbreviation: "Εβδ",
          rangeSeparator: " έως ",
          scrollTitle: "Μετακυλήστε για προσαύξηση",
          toggleTitle: "Κάντε κλικ για αλλαγή",
          amPM: ["ΠΜ", "ΜΜ"],
      };
      fp$j.l10ns.gr = Greek;
      fp$j.l10ns;

      var fp$k = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Hebrew = {
          weekdays: {
              shorthand: ["א", "ב", "ג", "ד", "ה", "ו", "ש"],
              longhand: ["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת"],
          },
          months: {
              shorthand: [
                  "ינו׳",
                  "פבר׳",
                  "מרץ",
                  "אפר׳",
                  "מאי",
                  "יוני",
                  "יולי",
                  "אוג׳",
                  "ספט׳",
                  "אוק׳",
                  "נוב׳",
                  "דצמ׳",
              ],
              longhand: [
                  "ינואר",
                  "פברואר",
                  "מרץ",
                  "אפריל",
                  "מאי",
                  "יוני",
                  "יולי",
                  "אוגוסט",
                  "ספטמבר",
                  "אוקטובר",
                  "נובמבר",
                  "דצמבר",
              ],
          },
          rangeSeparator: " אל ",
          time_24hr: true,
      };
      fp$k.l10ns.he = Hebrew;
      fp$k.l10ns;

      var fp$l = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Hindi = {
          weekdays: {
              shorthand: ["रवि", "सोम", "मंगल", "बुध", "गुरु", "शुक्र", "शनि"],
              longhand: [
                  "रविवार",
                  "सोमवार",
                  "मंगलवार",
                  "बुधवार",
                  "गुरुवार",
                  "शुक्रवार",
                  "शनिवार",
              ],
          },
          months: {
              shorthand: [
                  "जन",
                  "फर",
                  "मार्च",
                  "अप्रेल",
                  "मई",
                  "जून",
                  "जूलाई",
                  "अग",
                  "सित",
                  "अक्ट",
                  "नव",
                  "दि",
              ],
              longhand: [
                  "जनवरी ",
                  "फरवरी",
                  "मार्च",
                  "अप्रेल",
                  "मई",
                  "जून",
                  "जूलाई",
                  "अगस्त ",
                  "सितम्बर",
                  "अक्टूबर",
                  "नवम्बर",
                  "दिसम्बर",
              ],
          },
      };
      fp$l.l10ns.hi = Hindi;
      fp$l.l10ns;

      var fp$m = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Croatian = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"],
              longhand: [
                  "Nedjelja",
                  "Ponedjeljak",
                  "Utorak",
                  "Srijeda",
                  "Četvrtak",
                  "Petak",
                  "Subota",
              ],
          },
          months: {
              shorthand: [
                  "Sij",
                  "Velj",
                  "Ožu",
                  "Tra",
                  "Svi",
                  "Lip",
                  "Srp",
                  "Kol",
                  "Ruj",
                  "Lis",
                  "Stu",
                  "Pro",
              ],
              longhand: [
                  "Siječanj",
                  "Veljača",
                  "Ožujak",
                  "Travanj",
                  "Svibanj",
                  "Lipanj",
                  "Srpanj",
                  "Kolovoz",
                  "Rujan",
                  "Listopad",
                  "Studeni",
                  "Prosinac",
              ],
          },
          time_24hr: true,
      };
      fp$m.l10ns.hr = Croatian;
      fp$m.l10ns;

      var fp$n = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Hungarian = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["V", "H", "K", "Sz", "Cs", "P", "Szo"],
              longhand: [
                  "Vasárnap",
                  "Hétfő",
                  "Kedd",
                  "Szerda",
                  "Csütörtök",
                  "Péntek",
                  "Szombat",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Már",
                  "Ápr",
                  "Máj",
                  "Jún",
                  "Júl",
                  "Aug",
                  "Szep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "Január",
                  "Február",
                  "Március",
                  "Április",
                  "Május",
                  "Június",
                  "Július",
                  "Augusztus",
                  "Szeptember",
                  "Október",
                  "November",
                  "December",
              ],
          },
          ordinal: function () {
              return ".";
          },
          weekAbbreviation: "Hét",
          scrollTitle: "Görgessen",
          toggleTitle: "Kattintson a váltáshoz",
          rangeSeparator: " - ",
          time_24hr: true,
      };
      fp$n.l10ns.hu = Hungarian;
      fp$n.l10ns;

      var fp$o = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Indonesian = {
          weekdays: {
              shorthand: ["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"],
              longhand: ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Mei",
                  "Jun",
                  "Jul",
                  "Agu",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Des",
              ],
              longhand: [
                  "Januari",
                  "Februari",
                  "Maret",
                  "April",
                  "Mei",
                  "Juni",
                  "Juli",
                  "Agustus",
                  "September",
                  "Oktober",
                  "November",
                  "Desember",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          time_24hr: true,
          rangeSeparator: " - ",
      };
      fp$o.l10ns.id = Indonesian;
      fp$o.l10ns;

      var fp$p = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Icelandic = {
          weekdays: {
              shorthand: ["Sun", "Mán", "Þri", "Mið", "Fim", "Fös", "Lau"],
              longhand: [
                  "Sunnudagur",
                  "Mánudagur",
                  "Þriðjudagur",
                  "Miðvikudagur",
                  "Fimmtudagur",
                  "Föstudagur",
                  "Laugardagur",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Maí",
                  "Jún",
                  "Júl",
                  "Ágú",
                  "Sep",
                  "Okt",
                  "Nóv",
                  "Des",
              ],
              longhand: [
                  "Janúar",
                  "Febrúar",
                  "Mars",
                  "Apríl",
                  "Maí",
                  "Júní",
                  "Júlí",
                  "Ágúst",
                  "September",
                  "Október",
                  "Nóvember",
                  "Desember",
              ],
          },
          ordinal: function () {
              return ".";
          },
          firstDayOfWeek: 1,
          rangeSeparator: " til ",
          weekAbbreviation: "vika",
          yearAriaLabel: "Ár",
          time_24hr: true,
      };
      fp$p.l10ns.is = Icelandic;
      fp$p.l10ns;

      var fp$q = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Italian = {
          weekdays: {
              shorthand: ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab"],
              longhand: [
                  "Domenica",
                  "Lunedì",
                  "Martedì",
                  "Mercoledì",
                  "Giovedì",
                  "Venerdì",
                  "Sabato",
              ],
          },
          months: {
              shorthand: [
                  "Gen",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Mag",
                  "Giu",
                  "Lug",
                  "Ago",
                  "Set",
                  "Ott",
                  "Nov",
                  "Dic",
              ],
              longhand: [
                  "Gennaio",
                  "Febbraio",
                  "Marzo",
                  "Aprile",
                  "Maggio",
                  "Giugno",
                  "Luglio",
                  "Agosto",
                  "Settembre",
                  "Ottobre",
                  "Novembre",
                  "Dicembre",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () { return "°"; },
          rangeSeparator: " al ",
          weekAbbreviation: "Se",
          scrollTitle: "Scrolla per aumentare",
          toggleTitle: "Clicca per cambiare",
          time_24hr: true,
      };
      fp$q.l10ns.it = Italian;
      fp$q.l10ns;

      var fp$r = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Japanese = {
          weekdays: {
              shorthand: ["日", "月", "火", "水", "木", "金", "土"],
              longhand: [
                  "日曜日",
                  "月曜日",
                  "火曜日",
                  "水曜日",
                  "木曜日",
                  "金曜日",
                  "土曜日",
              ],
          },
          months: {
              shorthand: [
                  "1月",
                  "2月",
                  "3月",
                  "4月",
                  "5月",
                  "6月",
                  "7月",
                  "8月",
                  "9月",
                  "10月",
                  "11月",
                  "12月",
              ],
              longhand: [
                  "1月",
                  "2月",
                  "3月",
                  "4月",
                  "5月",
                  "6月",
                  "7月",
                  "8月",
                  "9月",
                  "10月",
                  "11月",
                  "12月",
              ],
          },
          time_24hr: true,
          rangeSeparator: " から ",
          monthAriaLabel: "月",
          amPM: ["午前", "午後"],
          yearAriaLabel: "年",
          hourAriaLabel: "時間",
          minuteAriaLabel: "分",
      };
      fp$r.l10ns.ja = Japanese;
      fp$r.l10ns;

      var fp$s = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Georgian = {
          weekdays: {
              shorthand: ["კვ", "ორ", "სა", "ოთ", "ხუ", "პა", "შა"],
              longhand: [
                  "კვირა",
                  "ორშაბათი",
                  "სამშაბათი",
                  "ოთხშაბათი",
                  "ხუთშაბათი",
                  "პარასკევი",
                  "შაბათი",
              ],
          },
          months: {
              shorthand: [
                  "იან",
                  "თებ",
                  "მარ",
                  "აპრ",
                  "მაი",
                  "ივნ",
                  "ივლ",
                  "აგვ",
                  "სექ",
                  "ოქტ",
                  "ნოე",
                  "დეკ",
              ],
              longhand: [
                  "იანვარი",
                  "თებერვალი",
                  "მარტი",
                  "აპრილი",
                  "მაისი",
                  "ივნისი",
                  "ივლისი",
                  "აგვისტო",
                  "სექტემბერი",
                  "ოქტომბერი",
                  "ნოემბერი",
                  "დეკემბერი",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          rangeSeparator: " — ",
          weekAbbreviation: "კვ.",
          scrollTitle: "დასქროლეთ გასადიდებლად",
          toggleTitle: "დააკლიკეთ გადართვისთვის",
          amPM: ["AM", "PM"],
          yearAriaLabel: "წელი",
          time_24hr: true,
      };
      fp$s.l10ns.ka = Georgian;
      fp$s.l10ns;

      var fp$t = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Korean = {
          weekdays: {
              shorthand: ["일", "월", "화", "수", "목", "금", "토"],
              longhand: [
                  "일요일",
                  "월요일",
                  "화요일",
                  "수요일",
                  "목요일",
                  "금요일",
                  "토요일",
              ],
          },
          months: {
              shorthand: [
                  "1월",
                  "2월",
                  "3월",
                  "4월",
                  "5월",
                  "6월",
                  "7월",
                  "8월",
                  "9월",
                  "10월",
                  "11월",
                  "12월",
              ],
              longhand: [
                  "1월",
                  "2월",
                  "3월",
                  "4월",
                  "5월",
                  "6월",
                  "7월",
                  "8월",
                  "9월",
                  "10월",
                  "11월",
                  "12월",
              ],
          },
          ordinal: function () {
              return "일";
          },
          rangeSeparator: " ~ ",
      };
      fp$t.l10ns.ko = Korean;
      fp$t.l10ns;

      var fp$u = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Khmer = {
          weekdays: {
              shorthand: ["អាទិត្យ", "ចន្ទ", "អង្គារ", "ពុធ", "ព្រហស.", "សុក្រ", "សៅរ៍"],
              longhand: [
                  "អាទិត្យ",
                  "ចន្ទ",
                  "អង្គារ",
                  "ពុធ",
                  "ព្រហស្បតិ៍",
                  "សុក្រ",
                  "សៅរ៍",
              ],
          },
          months: {
              shorthand: [
                  "មករា",
                  "កុម្ភះ",
                  "មីនា",
                  "មេសា",
                  "ឧសភា",
                  "មិថុនា",
                  "កក្កដា",
                  "សីហា",
                  "កញ្ញា",
                  "តុលា",
                  "វិច្ឆិកា",
                  "ធ្នូ",
              ],
              longhand: [
                  "មករា",
                  "កុម្ភះ",
                  "មីនា",
                  "មេសា",
                  "ឧសភា",
                  "មិថុនា",
                  "កក្កដា",
                  "សីហា",
                  "កញ្ញា",
                  "តុលា",
                  "វិច្ឆិកា",
                  "ធ្នូ",
              ],
          },
          ordinal: function () {
              return "";
          },
          firstDayOfWeek: 1,
          rangeSeparator: " ដល់ ",
          weekAbbreviation: "សប្តាហ៍",
          scrollTitle: "រំកិលដើម្បីបង្កើន",
          toggleTitle: "ចុចដើម្បីផ្លាស់ប្ដូរ",
          yearAriaLabel: "ឆ្នាំ",
          time_24hr: true,
      };
      fp$u.l10ns.km = Khmer;
      fp$u.l10ns;

      var fp$v = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Kazakh = {
          weekdays: {
              shorthand: ["Жс", "Дс", "Сc", "Ср", "Бс", "Жм", "Сб"],
              longhand: [
                  "Жексенбi",
                  "Дүйсенбi",
                  "Сейсенбi",
                  "Сәрсенбi",
                  "Бейсенбi",
                  "Жұма",
                  "Сенбi",
              ],
          },
          months: {
              shorthand: [
                  "Қаң",
                  "Ақп",
                  "Нау",
                  "Сәу",
                  "Мам",
                  "Мау",
                  "Шiл",
                  "Там",
                  "Қыр",
                  "Қаз",
                  "Қар",
                  "Жел",
              ],
              longhand: [
                  "Қаңтар",
                  "Ақпан",
                  "Наурыз",
                  "Сәуiр",
                  "Мамыр",
                  "Маусым",
                  "Шiлде",
                  "Тамыз",
                  "Қыркүйек",
                  "Қазан",
                  "Қараша",
                  "Желтоқсан",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          rangeSeparator: " — ",
          weekAbbreviation: "Апта",
          scrollTitle: "Үлкейту үшін айналдырыңыз",
          toggleTitle: "Ауыстыру үшін басыңыз",
          amPM: ["ТД", "ТК"],
          yearAriaLabel: "Жыл",
      };
      fp$v.l10ns.kz = Kazakh;
      fp$v.l10ns;

      var fp$w = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Lithuanian = {
          weekdays: {
              shorthand: ["S", "Pr", "A", "T", "K", "Pn", "Š"],
              longhand: [
                  "Sekmadienis",
                  "Pirmadienis",
                  "Antradienis",
                  "Trečiadienis",
                  "Ketvirtadienis",
                  "Penktadienis",
                  "Šeštadienis",
              ],
          },
          months: {
              shorthand: [
                  "Sau",
                  "Vas",
                  "Kov",
                  "Bal",
                  "Geg",
                  "Bir",
                  "Lie",
                  "Rgp",
                  "Rgs",
                  "Spl",
                  "Lap",
                  "Grd",
              ],
              longhand: [
                  "Sausis",
                  "Vasaris",
                  "Kovas",
                  "Balandis",
                  "Gegužė",
                  "Birželis",
                  "Liepa",
                  "Rugpjūtis",
                  "Rugsėjis",
                  "Spalis",
                  "Lapkritis",
                  "Gruodis",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "-a";
          },
          rangeSeparator: " iki ",
          weekAbbreviation: "Sav",
          scrollTitle: "Keisti laiką pelės rateliu",
          toggleTitle: "Perjungti laiko formatą",
          time_24hr: true,
      };
      fp$w.l10ns.lt = Lithuanian;
      fp$w.l10ns;

      var fp$x = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Latvian = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["Sv", "Pr", "Ot", "Tr", "Ce", "Pk", "Se"],
              longhand: [
                  "Svētdiena",
                  "Pirmdiena",
                  "Otrdiena",
                  "Trešdiena",
                  "Ceturtdiena",
                  "Piektdiena",
                  "Sestdiena",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Mai",
                  "Jūn",
                  "Jūl",
                  "Aug",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "Janvāris",
                  "Februāris",
                  "Marts",
                  "Aprīlis",
                  "Maijs",
                  "Jūnijs",
                  "Jūlijs",
                  "Augusts",
                  "Septembris",
                  "Oktobris",
                  "Novembris",
                  "Decembris",
              ],
          },
          rangeSeparator: " līdz ",
          time_24hr: true,
      };
      fp$x.l10ns.lv = Latvian;
      fp$x.l10ns;

      var fp$y = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Macedonian = {
          weekdays: {
              shorthand: ["Не", "По", "Вт", "Ср", "Че", "Пе", "Са"],
              longhand: [
                  "Недела",
                  "Понеделник",
                  "Вторник",
                  "Среда",
                  "Четврток",
                  "Петок",
                  "Сабота",
              ],
          },
          months: {
              shorthand: [
                  "Јан",
                  "Фев",
                  "Мар",
                  "Апр",
                  "Мај",
                  "Јун",
                  "Јул",
                  "Авг",
                  "Сеп",
                  "Окт",
                  "Ное",
                  "Дек",
              ],
              longhand: [
                  "Јануари",
                  "Февруари",
                  "Март",
                  "Април",
                  "Мај",
                  "Јуни",
                  "Јули",
                  "Август",
                  "Септември",
                  "Октомври",
                  "Ноември",
                  "Декември",
              ],
          },
          firstDayOfWeek: 1,
          weekAbbreviation: "Нед.",
          rangeSeparator: " до ",
          time_24hr: true,
      };
      fp$y.l10ns.mk = Macedonian;
      fp$y.l10ns;

      var fp$z = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Mongolian = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["Да", "Мя", "Лх", "Пү", "Ба", "Бя", "Ня"],
              longhand: ["Даваа", "Мягмар", "Лхагва", "Пүрэв", "Баасан", "Бямба", "Ням"],
          },
          months: {
              shorthand: [
                  "1-р сар",
                  "2-р сар",
                  "3-р сар",
                  "4-р сар",
                  "5-р сар",
                  "6-р сар",
                  "7-р сар",
                  "8-р сар",
                  "9-р сар",
                  "10-р сар",
                  "11-р сар",
                  "12-р сар",
              ],
              longhand: [
                  "Нэгдүгээр сар",
                  "Хоёрдугаар сар",
                  "Гуравдугаар сар",
                  "Дөрөвдүгээр сар",
                  "Тавдугаар сар",
                  "Зургаадугаар сар",
                  "Долдугаар сар",
                  "Наймдугаар сар",
                  "Есдүгээр сар",
                  "Аравдугаар сар",
                  "Арваннэгдүгээр сар",
                  "Арванхоёрдугаар сар",
              ],
          },
          rangeSeparator: "-с ",
          time_24hr: true,
      };
      fp$z.l10ns.mn = Mongolian;
      fp$z.l10ns;

      var fp$A = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Malaysian = {
          weekdays: {
              shorthand: ["Min", "Isn", "Sel", "Rab", "Kha", "Jum", "Sab"],
              longhand: [
                  "Minggu",
                  "Isnin",
                  "Selasa",
                  "Rabu",
                  "Khamis",
                  "Jumaat",
                  "Sabtu",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mac",
                  "Apr",
                  "Mei",
                  "Jun",
                  "Jul",
                  "Ogo",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dis",
              ],
              longhand: [
                  "Januari",
                  "Februari",
                  "Mac",
                  "April",
                  "Mei",
                  "Jun",
                  "Julai",
                  "Ogos",
                  "September",
                  "Oktober",
                  "November",
                  "Disember",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
      };
      fp$A.l10ns;

      var fp$B = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Burmese = {
          weekdays: {
              shorthand: ["နွေ", "လာ", "ဂါ", "ဟူး", "ကြာ", "သော", "နေ"],
              longhand: [
                  "တနင်္ဂနွေ",
                  "တနင်္လာ",
                  "အင်္ဂါ",
                  "ဗုဒ္ဓဟူး",
                  "ကြာသပတေး",
                  "သောကြာ",
                  "စနေ",
              ],
          },
          months: {
              shorthand: [
                  "ဇန်",
                  "ဖေ",
                  "မတ်",
                  "ပြီ",
                  "မေ",
                  "ဇွန်",
                  "လိုင်",
                  "သြ",
                  "စက်",
                  "အောက်",
                  "နို",
                  "ဒီ",
              ],
              longhand: [
                  "ဇန်နဝါရီ",
                  "ဖေဖော်ဝါရီ",
                  "မတ်",
                  "ဧပြီ",
                  "မေ",
                  "ဇွန်",
                  "ဇူလိုင်",
                  "သြဂုတ်",
                  "စက်တင်ဘာ",
                  "အောက်တိုဘာ",
                  "နိုဝင်ဘာ",
                  "ဒီဇင်ဘာ",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          time_24hr: true,
      };
      fp$B.l10ns.my = Burmese;
      fp$B.l10ns;

      var fp$C = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Dutch = {
          weekdays: {
              shorthand: ["zo", "ma", "di", "wo", "do", "vr", "za"],
              longhand: [
                  "zondag",
                  "maandag",
                  "dinsdag",
                  "woensdag",
                  "donderdag",
                  "vrijdag",
                  "zaterdag",
              ],
          },
          months: {
              shorthand: [
                  "jan",
                  "feb",
                  "mrt",
                  "apr",
                  "mei",
                  "jun",
                  "jul",
                  "aug",
                  "sept",
                  "okt",
                  "nov",
                  "dec",
              ],
              longhand: [
                  "januari",
                  "februari",
                  "maart",
                  "april",
                  "mei",
                  "juni",
                  "juli",
                  "augustus",
                  "september",
                  "oktober",
                  "november",
                  "december",
              ],
          },
          firstDayOfWeek: 1,
          weekAbbreviation: "wk",
          rangeSeparator: " t/m ",
          scrollTitle: "Scroll voor volgende / vorige",
          toggleTitle: "Klik om te wisselen",
          time_24hr: true,
          ordinal: function (nth) {
              if (nth === 1 || nth === 8 || nth >= 20)
                  return "ste";
              return "de";
          },
      };
      fp$C.l10ns.nl = Dutch;
      fp$C.l10ns;

      var fp$D = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Norwegian = {
          weekdays: {
              shorthand: ["Søn", "Man", "Tir", "Ons", "Tor", "Fre", "Lør"],
              longhand: [
                  "Søndag",
                  "Mandag",
                  "Tirsdag",
                  "Onsdag",
                  "Torsdag",
                  "Fredag",
                  "Lørdag",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Mai",
                  "Jun",
                  "Jul",
                  "Aug",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Des",
              ],
              longhand: [
                  "Januar",
                  "Februar",
                  "Mars",
                  "April",
                  "Mai",
                  "Juni",
                  "Juli",
                  "August",
                  "September",
                  "Oktober",
                  "November",
                  "Desember",
              ],
          },
          firstDayOfWeek: 1,
          rangeSeparator: " til ",
          weekAbbreviation: "Uke",
          scrollTitle: "Scroll for å endre",
          toggleTitle: "Klikk for å veksle",
          time_24hr: true,
          ordinal: function () {
              return ".";
          },
      };
      fp$D.l10ns.no = Norwegian;
      fp$D.l10ns;

      var fp$E = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Punjabi = {
          weekdays: {
              shorthand: ["ਐਤ", "ਸੋਮ", "ਮੰਗਲ", "ਬੁੱਧ", "ਵੀਰ", "ਸ਼ੁੱਕਰ", "ਸ਼ਨਿੱਚਰ"],
              longhand: [
                  "ਐਤਵਾਰ",
                  "ਸੋਮਵਾਰ",
                  "ਮੰਗਲਵਾਰ",
                  "ਬੁੱਧਵਾਰ",
                  "ਵੀਰਵਾਰ",
                  "ਸ਼ੁੱਕਰਵਾਰ",
                  "ਸ਼ਨਿੱਚਰਵਾਰ",
              ],
          },
          months: {
              shorthand: [
                  "ਜਨ",
                  "ਫ਼ਰ",
                  "ਮਾਰ",
                  "ਅਪ੍ਰੈ",
                  "ਮਈ",
                  "ਜੂਨ",
                  "ਜੁਲਾ",
                  "ਅਗ",
                  "ਸਤੰ",
                  "ਅਕ",
                  "ਨਵੰ",
                  "ਦਸੰ",
              ],
              longhand: [
                  "ਜਨਵਰੀ",
                  "ਫ਼ਰਵਰੀ",
                  "ਮਾਰਚ",
                  "ਅਪ੍ਰੈਲ",
                  "ਮਈ",
                  "ਜੂਨ",
                  "ਜੁਲਾਈ",
                  "ਅਗਸਤ",
                  "ਸਤੰਬਰ",
                  "ਅਕਤੂਬਰ",
                  "ਨਵੰਬਰ",
                  "ਦਸੰਬਰ",
              ],
          },
          time_24hr: true,
      };
      fp$E.l10ns.pa = Punjabi;
      fp$E.l10ns;

      var fp$F = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Polish = {
          weekdays: {
              shorthand: ["Nd", "Pn", "Wt", "Śr", "Cz", "Pt", "So"],
              longhand: [
                  "Niedziela",
                  "Poniedziałek",
                  "Wtorek",
                  "Środa",
                  "Czwartek",
                  "Piątek",
                  "Sobota",
              ],
          },
          months: {
              shorthand: [
                  "Sty",
                  "Lut",
                  "Mar",
                  "Kwi",
                  "Maj",
                  "Cze",
                  "Lip",
                  "Sie",
                  "Wrz",
                  "Paź",
                  "Lis",
                  "Gru",
              ],
              longhand: [
                  "Styczeń",
                  "Luty",
                  "Marzec",
                  "Kwiecień",
                  "Maj",
                  "Czerwiec",
                  "Lipiec",
                  "Sierpień",
                  "Wrzesień",
                  "Październik",
                  "Listopad",
                  "Grudzień",
              ],
          },
          rangeSeparator: " do ",
          weekAbbreviation: "tydz.",
          scrollTitle: "Przewiń, aby zwiększyć",
          toggleTitle: "Kliknij, aby przełączyć",
          firstDayOfWeek: 1,
          time_24hr: true,
          ordinal: function () {
              return ".";
          },
      };
      fp$F.l10ns.pl = Polish;
      fp$F.l10ns;

      var fp$G = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Portuguese = {
          weekdays: {
              shorthand: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"],
              longhand: [
                  "Domingo",
                  "Segunda-feira",
                  "Terça-feira",
                  "Quarta-feira",
                  "Quinta-feira",
                  "Sexta-feira",
                  "Sábado",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Fev",
                  "Mar",
                  "Abr",
                  "Mai",
                  "Jun",
                  "Jul",
                  "Ago",
                  "Set",
                  "Out",
                  "Nov",
                  "Dez",
              ],
              longhand: [
                  "Janeiro",
                  "Fevereiro",
                  "Março",
                  "Abril",
                  "Maio",
                  "Junho",
                  "Julho",
                  "Agosto",
                  "Setembro",
                  "Outubro",
                  "Novembro",
                  "Dezembro",
              ],
          },
          rangeSeparator: " até ",
          time_24hr: true,
      };
      fp$G.l10ns.pt = Portuguese;
      fp$G.l10ns;

      var fp$H = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Romanian = {
          weekdays: {
              shorthand: ["Dum", "Lun", "Mar", "Mie", "Joi", "Vin", "Sâm"],
              longhand: [
                  "Duminică",
                  "Luni",
                  "Marți",
                  "Miercuri",
                  "Joi",
                  "Vineri",
                  "Sâmbătă",
              ],
          },
          months: {
              shorthand: [
                  "Ian",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Mai",
                  "Iun",
                  "Iul",
                  "Aug",
                  "Sep",
                  "Oct",
                  "Noi",
                  "Dec",
              ],
              longhand: [
                  "Ianuarie",
                  "Februarie",
                  "Martie",
                  "Aprilie",
                  "Mai",
                  "Iunie",
                  "Iulie",
                  "August",
                  "Septembrie",
                  "Octombrie",
                  "Noiembrie",
                  "Decembrie",
              ],
          },
          firstDayOfWeek: 1,
          time_24hr: true,
          ordinal: function () {
              return "";
          },
      };
      fp$H.l10ns.ro = Romanian;
      fp$H.l10ns;

      var fp$I = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Russian = {
          weekdays: {
              shorthand: ["Вс", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
              longhand: [
                  "Воскресенье",
                  "Понедельник",
                  "Вторник",
                  "Среда",
                  "Четверг",
                  "Пятница",
                  "Суббота",
              ],
          },
          months: {
              shorthand: [
                  "Янв",
                  "Фев",
                  "Март",
                  "Апр",
                  "Май",
                  "Июнь",
                  "Июль",
                  "Авг",
                  "Сен",
                  "Окт",
                  "Ноя",
                  "Дек",
              ],
              longhand: [
                  "Январь",
                  "Февраль",
                  "Март",
                  "Апрель",
                  "Май",
                  "Июнь",
                  "Июль",
                  "Август",
                  "Сентябрь",
                  "Октябрь",
                  "Ноябрь",
                  "Декабрь",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          rangeSeparator: " — ",
          weekAbbreviation: "Нед.",
          scrollTitle: "Прокрутите для увеличения",
          toggleTitle: "Нажмите для переключения",
          amPM: ["ДП", "ПП"],
          yearAriaLabel: "Год",
          time_24hr: true,
      };
      fp$I.l10ns.ru = Russian;
      fp$I.l10ns;

      var fp$J = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Sinhala = {
          weekdays: {
              shorthand: ["ඉ", "ස", "අ", "බ", "බ්‍ර", "සි", "සෙ"],
              longhand: [
                  "ඉරිදා",
                  "සඳුදා",
                  "අඟහරුවාදා",
                  "බදාදා",
                  "බ්‍රහස්පතින්දා",
                  "සිකුරාදා",
                  "සෙනසුරාදා",
              ],
          },
          months: {
              shorthand: [
                  "ජන",
                  "පෙබ",
                  "මාර්",
                  "අප්‍රේ",
                  "මැයි",
                  "ජුනි",
                  "ජූලි",
                  "අගෝ",
                  "සැප්",
                  "ඔක්",
                  "නොවැ",
                  "දෙසැ",
              ],
              longhand: [
                  "ජනවාරි",
                  "පෙබරවාරි",
                  "මාර්තු",
                  "අප්‍රේල්",
                  "මැයි",
                  "ජුනි",
                  "ජූලි",
                  "අගෝස්තු",
                  "සැප්තැම්බර්",
                  "ඔක්තෝබර්",
                  "නොවැම්බර්",
                  "දෙසැම්බර්",
              ],
          },
          time_24hr: true,
      };
      fp$J.l10ns.si = Sinhala;
      fp$J.l10ns;

      var fp$K = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Slovak = {
          weekdays: {
              shorthand: ["Ned", "Pon", "Ut", "Str", "Štv", "Pia", "Sob"],
              longhand: [
                  "Nedeľa",
                  "Pondelok",
                  "Utorok",
                  "Streda",
                  "Štvrtok",
                  "Piatok",
                  "Sobota",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Máj",
                  "Jún",
                  "Júl",
                  "Aug",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "Január",
                  "Február",
                  "Marec",
                  "Apríl",
                  "Máj",
                  "Jún",
                  "Júl",
                  "August",
                  "September",
                  "Október",
                  "November",
                  "December",
              ],
          },
          firstDayOfWeek: 1,
          rangeSeparator: " do ",
          time_24hr: true,
          ordinal: function () {
              return ".";
          },
      };
      fp$K.l10ns.sk = Slovak;
      fp$K.l10ns;

      var fp$L = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Slovenian = {
          weekdays: {
              shorthand: ["Ned", "Pon", "Tor", "Sre", "Čet", "Pet", "Sob"],
              longhand: [
                  "Nedelja",
                  "Ponedeljek",
                  "Torek",
                  "Sreda",
                  "Četrtek",
                  "Petek",
                  "Sobota",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Maj",
                  "Jun",
                  "Jul",
                  "Avg",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "Januar",
                  "Februar",
                  "Marec",
                  "April",
                  "Maj",
                  "Junij",
                  "Julij",
                  "Avgust",
                  "September",
                  "Oktober",
                  "November",
                  "December",
              ],
          },
          firstDayOfWeek: 1,
          rangeSeparator: " do ",
          time_24hr: true,
          ordinal: function () {
              return ".";
          },
      };
      fp$L.l10ns.sl = Slovenian;
      fp$L.l10ns;

      var fp$M = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Albanian = {
          weekdays: {
              shorthand: ["Di", "Hë", "Ma", "Më", "En", "Pr", "Sh"],
              longhand: [
                  "E Diel",
                  "E Hënë",
                  "E Martë",
                  "E Mërkurë",
                  "E Enjte",
                  "E Premte",
                  "E Shtunë",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Shk",
                  "Mar",
                  "Pri",
                  "Maj",
                  "Qer",
                  "Kor",
                  "Gus",
                  "Sht",
                  "Tet",
                  "Nën",
                  "Dhj",
              ],
              longhand: [
                  "Janar",
                  "Shkurt",
                  "Mars",
                  "Prill",
                  "Maj",
                  "Qershor",
                  "Korrik",
                  "Gusht",
                  "Shtator",
                  "Tetor",
                  "Nëntor",
                  "Dhjetor",
              ],
          },
          time_24hr: true,
      };
      fp$M.l10ns.sq = Albanian;
      fp$M.l10ns;

      var fp$N = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Serbian = {
          weekdays: {
              shorthand: ["Ned", "Pon", "Uto", "Sre", "Čet", "Pet", "Sub"],
              longhand: [
                  "Nedelja",
                  "Ponedeljak",
                  "Utorak",
                  "Sreda",
                  "Četvrtak",
                  "Petak",
                  "Subota",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Maj",
                  "Jun",
                  "Jul",
                  "Avg",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "Januar",
                  "Februar",
                  "Mart",
                  "April",
                  "Maj",
                  "Jun",
                  "Jul",
                  "Avgust",
                  "Septembar",
                  "Oktobar",
                  "Novembar",
                  "Decembar",
              ],
          },
          firstDayOfWeek: 1,
          weekAbbreviation: "Ned.",
          rangeSeparator: " do ",
          time_24hr: true,
      };
      fp$N.l10ns.sr = Serbian;
      fp$N.l10ns;

      var fp$O = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Swedish = {
          firstDayOfWeek: 1,
          weekAbbreviation: "v",
          weekdays: {
              shorthand: ["Sön", "Mån", "Tis", "Ons", "Tor", "Fre", "Lör"],
              longhand: [
                  "Söndag",
                  "Måndag",
                  "Tisdag",
                  "Onsdag",
                  "Torsdag",
                  "Fredag",
                  "Lördag",
              ],
          },
          months: {
              shorthand: [
                  "Jan",
                  "Feb",
                  "Mar",
                  "Apr",
                  "Maj",
                  "Jun",
                  "Jul",
                  "Aug",
                  "Sep",
                  "Okt",
                  "Nov",
                  "Dec",
              ],
              longhand: [
                  "Januari",
                  "Februari",
                  "Mars",
                  "April",
                  "Maj",
                  "Juni",
                  "Juli",
                  "Augusti",
                  "September",
                  "Oktober",
                  "November",
                  "December",
              ],
          },
          time_24hr: true,
          ordinal: function () {
              return ".";
          },
      };
      fp$O.l10ns.sv = Swedish;
      fp$O.l10ns;

      var fp$P = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Thai = {
          weekdays: {
              shorthand: ["อา", "จ", "อ", "พ", "พฤ", "ศ", "ส"],
              longhand: [
                  "อาทิตย์",
                  "จันทร์",
                  "อังคาร",
                  "พุธ",
                  "พฤหัสบดี",
                  "ศุกร์",
                  "เสาร์",
              ],
          },
          months: {
              shorthand: [
                  "ม.ค.",
                  "ก.พ.",
                  "มี.ค.",
                  "เม.ย.",
                  "พ.ค.",
                  "มิ.ย.",
                  "ก.ค.",
                  "ส.ค.",
                  "ก.ย.",
                  "ต.ค.",
                  "พ.ย.",
                  "ธ.ค.",
              ],
              longhand: [
                  "มกราคม",
                  "กุมภาพันธ์",
                  "มีนาคม",
                  "เมษายน",
                  "พฤษภาคม",
                  "มิถุนายน",
                  "กรกฎาคม",
                  "สิงหาคม",
                  "กันยายน",
                  "ตุลาคม",
                  "พฤศจิกายน",
                  "ธันวาคม",
              ],
          },
          firstDayOfWeek: 1,
          rangeSeparator: " ถึง ",
          scrollTitle: "เลื่อนเพื่อเพิ่มหรือลด",
          toggleTitle: "คลิกเพื่อเปลี่ยน",
          time_24hr: true,
          ordinal: function () {
              return "";
          },
      };
      fp$P.l10ns.th = Thai;
      fp$P.l10ns;

      var fp$Q = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Turkish = {
          weekdays: {
              shorthand: ["Paz", "Pzt", "Sal", "Çar", "Per", "Cum", "Cmt"],
              longhand: [
                  "Pazar",
                  "Pazartesi",
                  "Salı",
                  "Çarşamba",
                  "Perşembe",
                  "Cuma",
                  "Cumartesi",
              ],
          },
          months: {
              shorthand: [
                  "Oca",
                  "Şub",
                  "Mar",
                  "Nis",
                  "May",
                  "Haz",
                  "Tem",
                  "Ağu",
                  "Eyl",
                  "Eki",
                  "Kas",
                  "Ara",
              ],
              longhand: [
                  "Ocak",
                  "Şubat",
                  "Mart",
                  "Nisan",
                  "Mayıs",
                  "Haziran",
                  "Temmuz",
                  "Ağustos",
                  "Eylül",
                  "Ekim",
                  "Kasım",
                  "Aralık",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return ".";
          },
          rangeSeparator: " - ",
          weekAbbreviation: "Hf",
          scrollTitle: "Artırmak için kaydırın",
          toggleTitle: "Aç/Kapa",
          amPM: ["ÖÖ", "ÖS"],
          time_24hr: true,
      };
      fp$Q.l10ns.tr = Turkish;
      fp$Q.l10ns;

      var fp$R = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Ukrainian = {
          firstDayOfWeek: 1,
          weekdays: {
              shorthand: ["Нд", "Пн", "Вт", "Ср", "Чт", "Пт", "Сб"],
              longhand: [
                  "Неділя",
                  "Понеділок",
                  "Вівторок",
                  "Середа",
                  "Четвер",
                  "П'ятниця",
                  "Субота",
              ],
          },
          months: {
              shorthand: [
                  "Січ",
                  "Лют",
                  "Бер",
                  "Кві",
                  "Тра",
                  "Чер",
                  "Лип",
                  "Сер",
                  "Вер",
                  "Жов",
                  "Лис",
                  "Гру",
              ],
              longhand: [
                  "Січень",
                  "Лютий",
                  "Березень",
                  "Квітень",
                  "Травень",
                  "Червень",
                  "Липень",
                  "Серпень",
                  "Вересень",
                  "Жовтень",
                  "Листопад",
                  "Грудень",
              ],
          },
          time_24hr: true,
      };
      fp$R.l10ns.uk = Ukrainian;
      fp$R.l10ns;

      var fp$S = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Uzbek = {
          weekdays: {
              shorthand: ["Якш", "Душ", "Сеш", "Чор", "Пай", "Жум", "Шан"],
              longhand: [
                  "Якшанба",
                  "Душанба",
                  "Сешанба",
                  "Чоршанба",
                  "Пайшанба",
                  "Жума",
                  "Шанба",
              ],
          },
          months: {
              shorthand: [
                  "Янв",
                  "Фев",
                  "Мар",
                  "Апр",
                  "Май",
                  "Июн",
                  "Июл",
                  "Авг",
                  "Сен",
                  "Окт",
                  "Ноя",
                  "Дек",
              ],
              longhand: [
                  "Январ",
                  "Феврал",
                  "Март",
                  "Апрел",
                  "Май",
                  "Июн",
                  "Июл",
                  "Август",
                  "Сентябр",
                  "Октябр",
                  "Ноябр",
                  "Декабр",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          rangeSeparator: " — ",
          weekAbbreviation: "Ҳафта",
          scrollTitle: "Катталаштириш учун айлантиринг",
          toggleTitle: "Ўтиш учун босинг",
          amPM: ["AM", "PM"],
          yearAriaLabel: "Йил",
          time_24hr: true,
      };
      fp$S.l10ns.uz = Uzbek;
      fp$S.l10ns;

      var fp$T = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var UzbekLatin = {
          weekdays: {
              shorthand: ["Ya", "Du", "Se", "Cho", "Pa", "Ju", "Sha"],
              longhand: [
                  "Yakshanba",
                  "Dushanba",
                  "Seshanba",
                  "Chorshanba",
                  "Payshanba",
                  "Juma",
                  "Shanba",
              ],
          },
          months: {
              shorthand: [
                  "Yan",
                  "Fev",
                  "Mar",
                  "Apr",
                  "May",
                  "Iyun",
                  "Iyul",
                  "Avg",
                  "Sen",
                  "Okt",
                  "Noy",
                  "Dek",
              ],
              longhand: [
                  "Yanvar",
                  "Fevral",
                  "Mart",
                  "Aprel",
                  "May",
                  "Iyun",
                  "Iyul",
                  "Avgust",
                  "Sentabr",
                  "Oktabr",
                  "Noyabr",
                  "Dekabr",
              ],
          },
          firstDayOfWeek: 1,
          ordinal: function () {
              return "";
          },
          rangeSeparator: " — ",
          weekAbbreviation: "Hafta",
          scrollTitle: "Kattalashtirish uchun aylantiring",
          toggleTitle: "O‘tish uchun bosing",
          amPM: ["AM", "PM"],
          yearAriaLabel: "Yil",
          time_24hr: true,
      };
      fp$T.l10ns["uz_latn"] = UzbekLatin;
      fp$T.l10ns;

      var fp$U = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Vietnamese = {
          weekdays: {
              shorthand: ["CN", "T2", "T3", "T4", "T5", "T6", "T7"],
              longhand: [
                  "Chủ nhật",
                  "Thứ hai",
                  "Thứ ba",
                  "Thứ tư",
                  "Thứ năm",
                  "Thứ sáu",
                  "Thứ bảy",
              ],
          },
          months: {
              shorthand: [
                  "Th1",
                  "Th2",
                  "Th3",
                  "Th4",
                  "Th5",
                  "Th6",
                  "Th7",
                  "Th8",
                  "Th9",
                  "Th10",
                  "Th11",
                  "Th12",
              ],
              longhand: [
                  "Tháng một",
                  "Tháng hai",
                  "Tháng ba",
                  "Tháng tư",
                  "Tháng năm",
                  "Tháng sáu",
                  "Tháng bảy",
                  "Tháng tám",
                  "Tháng chín",
                  "Tháng mười",
                  "Tháng mười một",
                  "Tháng mười hai",
              ],
          },
          firstDayOfWeek: 1,
          rangeSeparator: " đến ",
      };
      fp$U.l10ns.vn = Vietnamese;
      fp$U.l10ns;

      var fp$V = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var Mandarin = {
          weekdays: {
              shorthand: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
              longhand: [
                  "星期日",
                  "星期一",
                  "星期二",
                  "星期三",
                  "星期四",
                  "星期五",
                  "星期六",
              ],
          },
          months: {
              shorthand: [
                  "一月",
                  "二月",
                  "三月",
                  "四月",
                  "五月",
                  "六月",
                  "七月",
                  "八月",
                  "九月",
                  "十月",
                  "十一月",
                  "十二月",
              ],
              longhand: [
                  "一月",
                  "二月",
                  "三月",
                  "四月",
                  "五月",
                  "六月",
                  "七月",
                  "八月",
                  "九月",
                  "十月",
                  "十一月",
                  "十二月",
              ],
          },
          rangeSeparator: " 至 ",
          weekAbbreviation: "周",
          scrollTitle: "滚动切换",
          toggleTitle: "点击切换 12/24 小时时制",
      };
      fp$V.l10ns.zh = Mandarin;
      fp$V.l10ns;

      var fp$W = typeof window !== "undefined" && window.flatpickr !== undefined
          ? window.flatpickr
          : {
              l10ns: {},
          };
      var MandarinTraditional = {
          weekdays: {
              shorthand: ["週日", "週一", "週二", "週三", "週四", "週五", "週六"],
              longhand: [
                  "星期日",
                  "星期一",
                  "星期二",
                  "星期三",
                  "星期四",
                  "星期五",
                  "星期六",
              ],
          },
          months: {
              shorthand: [
                  "一月",
                  "二月",
                  "三月",
                  "四月",
                  "五月",
                  "六月",
                  "七月",
                  "八月",
                  "九月",
                  "十月",
                  "十一月",
                  "十二月",
              ],
              longhand: [
                  "一月",
                  "二月",
                  "三月",
                  "四月",
                  "五月",
                  "六月",
                  "七月",
                  "八月",
                  "九月",
                  "十月",
                  "十一月",
                  "十二月",
              ],
          },
          rangeSeparator: " 至 ",
          weekAbbreviation: "週",
          scrollTitle: "滾動切換",
          toggleTitle: "點擊切換 12/24 小時時制",
      };
      fp$W.l10ns.zh_tw = MandarinTraditional;
      fp$W.l10ns;

      var l10n = {
          ar: Arabic,
          at: Austria,
          az: Azerbaijan,
          be: Belarusian,
          bg: Bulgarian,
          bn: Bangla,
          bs: Bosnian,
          ca: Catalan,
          cat: Catalan,
          cs: Czech,
          cy: Welsh,
          da: Danish,
          de: German,
          default: __assign({}, english),
          en: english,
          eo: Esperanto,
          es: Spanish,
          et: Estonian,
          fa: Persian,
          fi: Finnish,
          fo: Faroese,
          fr: French,
          gr: Greek,
          he: Hebrew,
          hi: Hindi,
          hr: Croatian,
          hu: Hungarian,
          id: Indonesian,
          is: Icelandic,
          it: Italian,
          ja: Japanese,
          ka: Georgian,
          ko: Korean,
          km: Khmer,
          kz: Kazakh,
          lt: Lithuanian,
          lv: Latvian,
          mk: Macedonian,
          mn: Mongolian,
          ms: Malaysian,
          my: Burmese,
          nl: Dutch,
          no: Norwegian,
          pa: Punjabi,
          pl: Polish,
          pt: Portuguese,
          ro: Romanian,
          ru: Russian,
          si: Sinhala,
          sk: Slovak,
          sl: Slovenian,
          sq: Albanian,
          sr: Serbian,
          sv: Swedish,
          th: Thai,
          tr: Turkish,
          uk: Ukrainian,
          vn: Vietnamese,
          zh: Mandarin,
          zh_tw: MandarinTraditional,
          uz: Uzbek,
          uz_latn: UzbekLatin,
      };

      exports.default = l10n;

      Object.defineProperty(exports, '__esModule', { value: true });

  })));
  });

  var l10n$1 = /*@__PURE__*/getDefaultExportFromCjs(l10n);

  var prefix$1L = settings_1.prefix;

  var DatePickerInput = /*#__PURE__*/function (_Component) {
    _inherits(DatePickerInput, _Component);

    var _super = _createSuper(DatePickerInput);

    function DatePickerInput() {
      _classCallCheck(this, DatePickerInput);

      return _super.apply(this, arguments);
    }

    _createClass(DatePickerInput, [{
      key: "render",
      value: function render() {
        var _classNames,
            _classNames2,
            _classNames3,
            _this = this;

        var _this$props = this.props,
            id = _this$props.id,
            labelText = _this$props.labelText,
            disabled = _this$props.disabled,
            invalid = _this$props.invalid,
            invalidText = _this$props.invalidText,
            hideLabel = _this$props.hideLabel,
            _onChange = _this$props.onChange,
            _onClick = _this$props.onClick,
            placeholder = _this$props.placeholder,
            type = _this$props.type,
            datePickerType = _this$props.datePickerType,
            pattern = _this$props.pattern,
            iconDescription = _this$props.iconDescription,
            openCalendar = _this$props.openCalendar,
            size = _this$props.size,
            warn = _this$props.warn,
            warnText = _this$props.warnText,
            other = _objectWithoutProperties$2(_this$props, ["id", "labelText", "disabled", "invalid", "invalidText", "hideLabel", "onChange", "onClick", "placeholder", "type", "datePickerType", "pattern", "iconDescription", "openCalendar", "size", "warn", "warnText"]);

        var datePickerInputProps = {
          id: id,
          onChange: function onChange(evt) {
            if (!disabled) {
              _onChange(evt);
            }
          },
          onClick: function onClick(evt) {
            if (!disabled) {
              _onClick(evt);
            }
          },
          placeholder: placeholder,
          type: type,
          pattern: pattern
        };
        var wrapperClasses = classnames("".concat(prefix$1L, "--date-picker-input__wrapper"), (_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$1L, "--date-picker-input__wrapper--invalid"), invalid), _defineProperty$2(_classNames, "".concat(prefix$1L, "--date-picker-input__wrapper--warn"), warn), _classNames));
        var labelClasses = classnames("".concat(prefix$1L, "--label"), (_classNames2 = {}, _defineProperty$2(_classNames2, "".concat(prefix$1L, "--visually-hidden"), hideLabel), _defineProperty$2(_classNames2, "".concat(prefix$1L, "--label--disabled"), disabled), _classNames2));
        var inputClasses = classnames("".concat(prefix$1L, "--date-picker__input"), (_classNames3 = {}, _defineProperty$2(_classNames3, "".concat(prefix$1L, "--date-picker__input--").concat(size), size), _defineProperty$2(_classNames3, "".concat(prefix$1L, "--date-picker__input--invalid"), invalid), _classNames3));

        var datePickerIcon = function () {
          if (datePickerType === 'simple' && !invalid && !warn) {
            return;
          }

          if (invalid) {
            return /*#__PURE__*/React__default['default'].createElement(WarningFilled16, {
              className: "".concat(prefix$1L, "--date-picker__icon ").concat(prefix$1L, "--date-picker__icon--invalid")
            });
          }

          if (!invalid && warn) {
            return /*#__PURE__*/React__default['default'].createElement(WarningAltFilled16, {
              className: "".concat(prefix$1L, "--date-picker__icon ").concat(prefix$1L, "--date-picker__icon--warn")
            });
          }

          return /*#__PURE__*/React__default['default'].createElement(Calendar16, {
            className: "".concat(prefix$1L, "--date-picker__icon"),
            "aria-label": iconDescription,
            onClick: openCalendar,
            role: "img"
          }, iconDescription && /*#__PURE__*/React__default['default'].createElement("title", null, iconDescription));
        }();

        var label = labelText ? /*#__PURE__*/React__default['default'].createElement("label", {
          htmlFor: id,
          className: labelClasses
        }, labelText) : null;
        var error = null;

        if (invalid) {
          error = /*#__PURE__*/React__default['default'].createElement("div", {
            className: "".concat(prefix$1L, "--form-requirement")
          }, invalidText);
        } else if (warn) {
          error = /*#__PURE__*/React__default['default'].createElement("div", {
            className: "".concat(prefix$1L, "--form-requirement")
          }, warnText);
        }

        var containerClasses = classnames("".concat(prefix$1L, "--date-picker-container"), _defineProperty$2({}, "".concat(prefix$1L, "--date-picker--nolabel"), !label));
        var input = invalid ? /*#__PURE__*/React__default['default'].createElement("input", _extends$3({}, other, datePickerInputProps, {
          disabled: disabled,
          ref: function ref(input) {
            _this.input = input;
          },
          "data-invalid": true,
          className: inputClasses
        })) : /*#__PURE__*/React__default['default'].createElement("input", _extends$3({
          ref: function ref(input) {
            _this.input = input;
          }
        }, other, datePickerInputProps, {
          disabled: disabled,
          className: inputClasses
        }));
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: containerClasses
        }, label, /*#__PURE__*/React__default['default'].createElement("div", {
          className: wrapperClasses
        }, input, datePickerIcon), error);
      }
    }]);

    return DatePickerInput;
  }(React.Component);

  _defineProperty$2(DatePickerInput, "propTypes", {
    /**
     * The type of the date picker:
     *
     * * `simple` - Without calendar dropdown.
     * * `single` - With calendar dropdown and single date.
     * * `range` - With calendar dropdown and a date range.
     */
    datePickerType: PropTypes__default['default'].oneOf(['simple', 'single', 'range']),

    /**
     * Specify whether or not the input should be disabled
     */
    disabled: PropTypes__default['default'].bool,

    /**
     * Specify if the label should be hidden
     */
    hideLabel: PropTypes__default['default'].bool,

    /**
     * The description of the calendar icon.
     */
    iconDescription: PropTypes__default['default'].string,

    /**
     * Specify an id that uniquely identifies the `<input>`
     */
    id: PropTypes__default['default'].string.isRequired,

    /**
     * Specify whether or not the input should be invalid
     */
    invalid: PropTypes__default['default'].bool,

    /**
     * Specify the text to be rendered when the input is invalid
     */
    invalidText: PropTypes__default['default'].node,

    /**
     * Provide the text that will be read by a screen reader when visiting this
     * control
     */
    labelText: PropTypes__default['default'].node.isRequired,

    /**
     * Specify an `onChange` handler that is called whenever a change in the
     * input field has occurred
     */
    onChange: PropTypes__default['default'].func,

    /**
     * Provide a function to be called when the input field is clicked
     */
    onClick: PropTypes__default['default'].func,

    /**
     * Provide a function to be called when the input field is clicked
     */
    openCalendar: PropTypes__default['default'].func,

    /**
     * Provide a regular expression that the input value must match
     */
    pattern: function pattern(props, propName, componentName) {
      if (props[propName] === undefined) {
        return;
      }

      try {
        new RegExp(props[propName]);
      } catch (e) {
        return new Error("Invalid value of prop '".concat(propName, "' supplied to '").concat(componentName, "', it should be a valid regular expression"));
      }
    },

    /**
     * Specify the placeholder text
     */
    placeholder: PropTypes__default['default'].string,

    /**
     * Specify the size of the Date Picker Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
     * TODO V11: remove `xl` (replaced with lg)
     */
    size: PropTypes__default['default'].oneOf(['sm', 'md', 'lg', 'xl']),

    /**
     * Specify the type of the `<input>`
     */
    type: PropTypes__default['default'].string,

    /**
     * Specify whether the control is currently in warning state
     */
    warn: PropTypes__default['default'].bool,

    /**
     * Provide the text that is displayed when the control is in warning state
     */
    warnText: PropTypes__default['default'].node
  });

  _defineProperty$2(DatePickerInput, "defaultProps", {
    pattern: '\\d{1,2}\\/\\d{1,2}\\/\\d{4}',
    type: 'text',
    disabled: false,
    invalid: false,
    onClick: function onClick() {},
    onChange: function onChange() {}
  });

  /**
   * @param {object} config Plugin configuration.
   * @returns {Plugin} A Flatpickr plugin to put adjust the position of calendar dropdown.
   */
  var carbonFlatpickrAppendToPlugin = (function (config) {
    return function (fp) {
      /**
       * Adjusts the floating meun position after Flatpicker sets it.
       */
      var handlePreCalendarPosition = function handlePreCalendarPosition() {
        Promise.resolve().then(function () {
          var calendarContainer = fp.calendarContainer,
              fpConfig = fp.config,
              positionElement = fp._positionElement;
          var appendTo = fpConfig.appendTo;

          var _appendTo$getBounding = appendTo.getBoundingClientRect(),
              containerLeft = _appendTo$getBounding.left,
              containerTop = _appendTo$getBounding.top;

          var _positionElement$getB = positionElement.getBoundingClientRect(),
              refLeft = _positionElement$getB.left,
              refBottom = _positionElement$getB.bottom;

          if ((appendTo !== appendTo.ownerDocument.body || containerLeft !== 0 || containerTop !== 0) && appendTo.ownerDocument.defaultView.getComputedStyle(appendTo).getPropertyValue('position') === 'static') {
            throw new Error('Floating menu container must not have `position:static`.');
          } // `2` for negative mergin on calendar dropdown


          calendarContainer.style.top = "".concat(refBottom - containerTop + 2, "px");
          calendarContainer.style.left = "".concat(refLeft - containerLeft, "px");
        });
      };
      /**
       * Registers this Flatpickr plugin.
       */


      var register = function register() {
        fp.loadedPlugins.push('carbonFlatpickrAppendToPlugin');
      };

      return {
        appendTo: config.appendTo,
        onReady: register,
        onPreCalendarPosition: handlePreCalendarPosition
      };
    };
  });

  /**
   * @param {object} config Plugin configuration.
   * @returns {Plugin} A Flatpickr plugin to fix Flatpickr's behavior of certain events.
   */

  var carbonFlatpickrFixEventsPlugin = (function (config) {
    return function (fp) {
      /**
       * Handles `keydown` event.
       */
      var handleKeydown = function handleKeydown(event) {
        var inputFrom = config.inputFrom,
            inputTo = config.inputTo;
        var target = event.target;

        if (inputFrom === target || inputTo === target) {
          if (match(event, Enter)) {
            // Makes sure the hitting enter key picks up pending values of both `<input>`
            // Workaround for: https://github.com/flatpickr/flatpickr/issues/1942
            fp.setDate([inputFrom.value, inputTo && inputTo.value], true, fp.config.dateFormat);
            event.stopPropagation();
          } else if (match(event, ArrowLeft) || match(event, ArrowRight)) {
            // Prevents Flatpickr code from canceling the event if left/right arrow keys are hit on `<input>`,
            // so user can move the keyboard cursor for editing dates
            // Workaround for: https://github.com/flatpickr/flatpickr/issues/1943
            event.stopPropagation();
          } else if (match(event, ArrowDown)) {
            event.preventDefault();
            fp.open();
          }
        }
      };
      /**
       * Releases event listeners used in this Flatpickr plugin.
       */


      var release = function release() {
        var inputFrom = config.inputFrom,
            inputTo = config.inputTo;

        if (inputTo) {
          inputTo.removeEventListener('keydown', handleKeydown, true);
        }

        inputFrom.removeEventListener('keydown', handleKeydown, true);
      };
      /**
       * Sets up event listeners used for this Flatpickr plugin.
       */


      var init = function init() {
        release();
        var inputFrom = config.inputFrom,
            inputTo = config.inputTo;
        inputFrom.addEventListener('keydown', handleKeydown, true);

        if (inputTo) {
          inputTo.addEventListener('keydown', handleKeydown, true);
        }
      };
      /**
       * Registers this Flatpickr plugin.
       */


      var register = function register() {
        fp.loadedPlugins.push('carbonFlatpickrFixEventsPlugin');
      };

      return {
        onReady: [register, init],
        onDestroy: [release]
      };
    };
  });

  var rangePlugin = createCommonjsModule(function (module, exports) {
  (function (global, factory) {
      module.exports = factory() ;
  }(commonjsGlobal, (function () {
      /*! *****************************************************************************
      Copyright (c) Microsoft Corporation.

      Permission to use, copy, modify, and/or distribute this software for any
      purpose with or without fee is hereby granted.

      THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
      REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
      AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
      INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
      LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
      OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
      PERFORMANCE OF THIS SOFTWARE.
      ***************************************************************************** */

      function __spreadArrays() {
          for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
          for (var r = Array(s), k = 0, i = 0; i < il; i++)
              for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                  r[k] = a[j];
          return r;
      }

      function rangePlugin(config) {
          if (config === void 0) { config = {}; }
          return function (fp) {
              var dateFormat = "", secondInput, _secondInputFocused, _prevDates;
              var createSecondInput = function () {
                  if (config.input) {
                      secondInput =
                          config.input instanceof Element
                              ? config.input
                              : window.document.querySelector(config.input);
                      if (!secondInput) {
                          fp.config.errorHandler(new Error("Invalid input element specified"));
                          return;
                      }
                      if (fp.config.wrap) {
                          secondInput = secondInput.querySelector("[data-input]");
                      }
                  }
                  else {
                      secondInput = fp._input.cloneNode();
                      secondInput.removeAttribute("id");
                      secondInput._flatpickr = undefined;
                  }
                  if (secondInput.value) {
                      var parsedDate = fp.parseDate(secondInput.value);
                      if (parsedDate)
                          fp.selectedDates.push(parsedDate);
                  }
                  secondInput.setAttribute("data-fp-omit", "");
                  if (fp.config.clickOpens) {
                      fp._bind(secondInput, ["focus", "click"], function () {
                          if (fp.selectedDates[1]) {
                              fp.latestSelectedDateObj = fp.selectedDates[1];
                              fp._setHoursFromDate(fp.selectedDates[1]);
                              fp.jumpToDate(fp.selectedDates[1]);
                          }
                          _secondInputFocused = true;
                          fp.isOpen = false;
                          fp.open(undefined, config.position === "left" ? fp._input : secondInput);
                      });
                      fp._bind(fp._input, ["focus", "click"], function (e) {
                          e.preventDefault();
                          fp.isOpen = false;
                          fp.open();
                      });
                  }
                  if (fp.config.allowInput)
                      fp._bind(secondInput, "keydown", function (e) {
                          if (e.key === "Enter") {
                              fp.setDate([fp.selectedDates[0], secondInput.value], true, dateFormat);
                              secondInput.click();
                          }
                      });
                  if (!config.input)
                      fp._input.parentNode &&
                          fp._input.parentNode.insertBefore(secondInput, fp._input.nextSibling);
              };
              var plugin = {
                  onParseConfig: function () {
                      fp.config.mode = "range";
                      dateFormat = fp.config.altInput
                          ? fp.config.altFormat
                          : fp.config.dateFormat;
                  },
                  onReady: function () {
                      createSecondInput();
                      fp.config.ignoredFocusElements.push(secondInput);
                      if (fp.config.allowInput) {
                          fp._input.removeAttribute("readonly");
                          secondInput.removeAttribute("readonly");
                      }
                      else {
                          secondInput.setAttribute("readonly", "readonly");
                      }
                      fp._bind(fp._input, "focus", function () {
                          fp.latestSelectedDateObj = fp.selectedDates[0];
                          fp._setHoursFromDate(fp.selectedDates[0]);
                          _secondInputFocused = false;
                          fp.jumpToDate(fp.selectedDates[0]);
                      });
                      if (fp.config.allowInput)
                          fp._bind(fp._input, "keydown", function (e) {
                              if (e.key === "Enter")
                                  fp.setDate([fp._input.value, fp.selectedDates[1]], true, dateFormat);
                          });
                      fp.setDate(fp.selectedDates, false);
                      plugin.onValueUpdate(fp.selectedDates);
                      fp.loadedPlugins.push("range");
                  },
                  onPreCalendarPosition: function () {
                      if (_secondInputFocused) {
                          fp._positionElement = secondInput;
                          setTimeout(function () {
                              fp._positionElement = fp._input;
                          }, 0);
                      }
                  },
                  onChange: function () {
                      if (!fp.selectedDates.length) {
                          setTimeout(function () {
                              if (fp.selectedDates.length)
                                  return;
                              secondInput.value = "";
                              _prevDates = [];
                          }, 10);
                      }
                      if (_secondInputFocused) {
                          setTimeout(function () {
                              secondInput.focus();
                          }, 0);
                      }
                  },
                  onDestroy: function () {
                      if (!config.input)
                          secondInput.parentNode &&
                              secondInput.parentNode.removeChild(secondInput);
                  },
                  onValueUpdate: function (selDates) {
                      var _a, _b, _c;
                      if (!secondInput)
                          return;
                      _prevDates =
                          !_prevDates || selDates.length >= _prevDates.length
                              ? __spreadArrays(selDates) : _prevDates;
                      if (_prevDates.length > selDates.length) {
                          var newSelectedDate = selDates[0];
                          var newDates = _secondInputFocused
                              ? [_prevDates[0], newSelectedDate]
                              : [newSelectedDate, _prevDates[1]];
                          fp.setDate(newDates, false);
                          _prevDates = __spreadArrays(newDates);
                      }
                      _a = fp.selectedDates.map(function (d) { return fp.formatDate(d, dateFormat); }), _b = _a[0], fp._input.value = _b === void 0 ? "" : _b, _c = _a[1], secondInput.value = _c === void 0 ? "" : _c;
                  },
              };
              return plugin;
          };
      }

      return rangePlugin;

  })));
  });

  /**
   * @param {object} config Plugin configuration.
   * @returns {Plugin} An extension of Flatpickr `rangePlugin` that does the following:
   *   * Better ensures the calendar dropdown is always aligned to the `<input>` for the starting date.
   *     Workaround for: https://github.com/flatpickr/flatpickr/issues/1944
   *   * A logic to ensure `fp.setDate()` call won't end up with "startDate to endDate" set to the first `<input>`
   */

  var carbonFlatpickrRangePlugin = (function (config) {
    var factory = rangePlugin(Object.assign({
      position: 'left'
    }, config));
    return function (fp) {
      var origSetDate = fp.setDate;

      var init = function init() {
        fp.setDate = function setDate(dates, triggerChange, format) {
          origSetDate.call(this, dates, triggerChange, format); // If `triggerChange` is `true`, `onValueUpdate` Flatpickr event is fired
          // where Flatpickr's range plugin takes care of fixing the first `<input>`

          if (!triggerChange) {
            var inputFrom = fp._input;
            var inputTo = config.input;
            [inputFrom, inputTo].forEach(function (input, i) {
              if (input) {
                input.value = !dates[i] ? '' : fp.formatDate(new Date(dates[i]), fp.config.dateFormat);
              }
            });
          }
        };
      };

      var origRangePlugin = factory(fp);
      var origOnReady = origRangePlugin.onReady;
      return Object.assign(origRangePlugin, {
        onReady: [init, origOnReady],
        onPreCalendarPosition: function onPreCalendarPosition() {}
      });
    };
  });

  var prefix$1K = settings_1.prefix; // Weekdays shorthand for english locale

  l10n$1.en.weekdays.shorthand.forEach(function (day, index) {
    var currentDay = l10n$1.en.weekdays.shorthand;

    if (currentDay[index] === 'Thu' || currentDay[index] === 'Th') {
      currentDay[index] = 'Th';
    } else {
      currentDay[index] = currentDay[index].charAt(0);
    }
  });
  var forEach = Array.prototype.forEach;
  /**
   * @param {number} monthNumber The month number.
   * @param {boolean} shorthand `true` to use shorthand month.
   * @param {Locale} locale The Flatpickr locale data.
   * @returns {string} The month string.
   */

  var monthToStr = function monthToStr(monthNumber, shorthand, locale) {
    return locale.months[shorthand ? 'shorthand' : 'longhand'][monthNumber];
  };
  /**
   * @param {object} config Plugin configuration.
   * @param {boolean} [config.shorthand] `true` to use shorthand month.
   * @param {string} config.selectorFlatpickrMonthYearContainer The CSS selector for the container of month/year selection UI.
   * @param {string} config.selectorFlatpickrYearContainer The CSS selector for the container of year selection UI.
   * @param {string} config.selectorFlatpickrCurrentMonth The CSS selector for the text-based month selection UI.
   * @param {string} config.classFlatpickrCurrentMonth The CSS class for the text-based month selection UI.
   * @returns {Plugin} A Flatpickr plugin to use text instead of `<select>` for month picker.
   */


  var carbonFlatpickrMonthSelectPlugin = function carbonFlatpickrMonthSelectPlugin(config) {
    return function (fp) {
      var setupElements = function setupElements() {
        var _fp$monthElements;

        if (!fp.monthElements) {
          return;
        }

        fp.monthElements.forEach(function (elem) {
          if (!elem.parentNode) {
            return;
          }

          elem.parentNode.removeChild(elem);
        });

        (_fp$monthElements = fp.monthElements).splice.apply(_fp$monthElements, [0, fp.monthElements.length].concat(_toConsumableArray(fp.monthElements.map(function () {
          // eslint-disable-next-line no-underscore-dangle
          var monthElement = fp._createElement('span', config.classFlatpickrCurrentMonth);

          monthElement.textContent = monthToStr(fp.currentMonth, config.shorthand === true, fp.l10n);
          fp.yearElements[0].closest(config.selectorFlatpickrMonthYearContainer).insertBefore(monthElement, fp.yearElements[0].closest(config.selectorFlatpickrYearContainer));
          return monthElement;
        }))));
      };

      var updateCurrentMonth = function updateCurrentMonth() {
        var monthStr = monthToStr(fp.currentMonth, config.shorthand === true, fp.l10n);
        fp.yearElements.forEach(function (elem) {
          var currentMonthContainer = elem.closest(config.selectorFlatpickrMonthYearContainer);
          Array.prototype.forEach.call(currentMonthContainer.querySelectorAll('.cur-month'), function (monthElement) {
            monthElement.textContent = monthStr;
          });
        });
      };

      var register = function register() {
        fp.loadedPlugins.push('carbonFlatpickrMonthSelectPlugin');
      };

      return {
        onMonthChange: updateCurrentMonth,
        onValueUpdate: updateCurrentMonth,
        onOpen: updateCurrentMonth,
        onReady: [setupElements, updateCurrentMonth, register]
      };
    };
  };

  var DatePicker = /*#__PURE__*/function (_Component) {
    _inherits(DatePicker, _Component);

    var _super = _createSuper(DatePicker);

    function DatePicker() {
      var _this;

      _classCallCheck(this, DatePicker);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty$2(_assertThisInitialized$1(_this), "onChange", function () {
        var _this$cal;

        if (_this.inputField.value === '' && (_this$cal = _this.cal) !== null && _this$cal !== void 0 && _this$cal.selectedDates.length) {
          _this.cal.clear();

          _this.cal.input.focus();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "addRoleAttributeToDialog", function () {
        if (_this.inputField) {
          _this.cal.calendarContainer.setAttribute('role', 'region'); // IBM EAAC requires an aria-label on a role='region'


          _this.cal.calendarContainer.setAttribute('aria-label', 'calendar-container');
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "addKeyboardEvents", function (cal) {
        var initArrowDownListener = function initArrowDownListener(element) {
          if (element) {
            element.addEventListener('keydown', function (e) {
              if (match(e, ArrowDown)) {
                var calendarContainer = cal.calendarContainer,
                    fpSelectedDateElem = cal.selectedDateElem,
                    fptodayDateElem = cal.todayDateElem;
                var selectedDateElem = calendarContainer.querySelector('.selected') && fpSelectedDateElem;
                var todayDateElem = calendarContainer.querySelector('.today') && fptodayDateElem;
                (selectedDateElem || todayDateElem || calendarContainer.querySelector('.flatpickr-day[tabindex]') || calendarContainer).focus();
              }
            });
            element.addEventListener('change', _this.onChange);
          }
        };

        initArrowDownListener(_this.inputField);
        initArrowDownListener(_this.toInputField);
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "openCalendar", function () {
        if (_this.cal) {
          _this.cal.open();
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "updateClassNames", function (calendar) {
        var calendarContainer = calendar.calendarContainer;
        var daysContainer = calendar.days;

        if (calendarContainer && daysContainer) {
          // calendarContainer and daysContainer are undefined if flatpickr detects a mobile device
          calendarContainer.classList.add("".concat(prefix$1K, "--date-picker__calendar"));
          calendarContainer.querySelector('.flatpickr-month').classList.add("".concat(prefix$1K, "--date-picker__month"));
          calendarContainer.querySelector('.flatpickr-weekdays').classList.add("".concat(prefix$1K, "--date-picker__weekdays"));
          calendarContainer.querySelector('.flatpickr-days').classList.add("".concat(prefix$1K, "--date-picker__days"));
          forEach.call(calendarContainer.querySelectorAll('.flatpickr-weekday'), function (item) {
            var currentItem = item;
            currentItem.innerHTML = currentItem.innerHTML.replace(/\s+/g, '');
            currentItem.classList.add("".concat(prefix$1K, "--date-picker__weekday"));
          });
          forEach.call(daysContainer.querySelectorAll('.flatpickr-day'), function (item) {
            item.classList.add("".concat(prefix$1K, "--date-picker__day"));

            if (item.classList.contains('today') && calendar.selectedDates.length > 0) {
              item.classList.add('no-border');
            } else if (item.classList.contains('today') && calendar.selectedDates.length === 0) {
              item.classList.remove('no-border');
            }
          });
        }
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "assignInputFieldRef", function (node) {
        _this.inputField = !node ? null : // Child is a regular DOM node, seen in tests
        node.nodeType === Node.ELEMENT_NODE ? node.querySelector(".".concat(prefix$1K, "--date-picker__input")) : // Child is a React component
        node.input && node.input.nodeType === Node.ELEMENT_NODE ? node.input : null;
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "assignToInputFieldRef", function (node) {
        _this.toInputField = !node ? null : // Child is a regular DOM node, seen in tests
        node.nodeType === Node.ELEMENT_NODE ? node.querySelector(".".concat(prefix$1K, "--date-picker__input")) : // Child is a React component
        node.input && node.input.nodeType === Node.ELEMENT_NODE ? node.input : null;
      });

      _defineProperty$2(_assertThisInitialized$1(_this), "isLabelTextEmpty", function (children) {
        return children.every(function (child) {
          return !child.props.labelText;
        });
      });

      return _this;
    }

    _createClass(DatePicker, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this2 = this;

        var _this$props = this.props,
            allowInput = _this$props.allowInput,
            appendTo = _this$props.appendTo,
            datePickerType = _this$props.datePickerType,
            dateFormat = _this$props.dateFormat,
            locale = _this$props.locale,
            minDate = _this$props.minDate,
            maxDate = _this$props.maxDate,
            value = _this$props.value,
            onClose = _this$props.onClose,
            disable = _this$props.disable,
            enable = _this$props.enable;

        if (datePickerType === 'single' || datePickerType === 'range') {
          var onHook = function onHook(electedDates, dateStr, instance) {
            _this2.updateClassNames(instance);
          }; // Logic to determine if `enable` or `disable` will be passed down. If neither
          // is provided, we return the default empty disabled array, allowing all dates.


          var enableOrDisable = enable ? 'enable' : 'disable';
          var enableOrDisableArr;

          if (!enable && !disable) {
            enableOrDisableArr = [];
          } else if (enable) {
            enableOrDisableArr = enable;
          } else {
            enableOrDisableArr = disable;
          }

          var localeData;

          if (_typeof(locale) === 'object') {
            var location = locale.locale ? locale.locale : 'en';
            localeData = _objectSpread2$2(_objectSpread2$2({}, l10n$1[location]), locale);
          } else {
            localeData = l10n$1[locale];
          } // inputField ref might not be set in enzyme tests


          if (this.inputField) {
            var _flatpickr;

            this.cal = new flatpickr(this.inputField, (_flatpickr = {
              disableMobile: true,
              defaultDate: value,
              mode: datePickerType,
              allowInput: allowInput !== null && allowInput !== void 0 ? allowInput : true,
              dateFormat: dateFormat,
              locale: localeData
            }, _defineProperty$2(_flatpickr, enableOrDisable, enableOrDisableArr), _defineProperty$2(_flatpickr, "minDate", minDate), _defineProperty$2(_flatpickr, "maxDate", maxDate), _defineProperty$2(_flatpickr, "plugins", [datePickerType === 'range' ? new carbonFlatpickrRangePlugin({
              input: this.toInputField
            }) : function () {}, appendTo ? carbonFlatpickrAppendToPlugin({
              appendTo: appendTo
            }) : function () {}, carbonFlatpickrMonthSelectPlugin({
              selectorFlatpickrMonthYearContainer: '.flatpickr-current-month',
              selectorFlatpickrYearContainer: '.numInputWrapper',
              selectorFlatpickrCurrentMonth: '.cur-month',
              classFlatpickrCurrentMonth: 'cur-month'
            }), carbonFlatpickrFixEventsPlugin({
              inputFrom: this.inputField,
              inputTo: this.toInputField
            })]), _defineProperty$2(_flatpickr, "clickOpens", true), _defineProperty$2(_flatpickr, "nextArrow", this.rightArrowHTML()), _defineProperty$2(_flatpickr, "prevArrow", this.leftArrowHTML()), _defineProperty$2(_flatpickr, "onChange", function onChange() {
              var onChange = _this2.props.onChange;

              if (onChange) {
                onChange.apply(void 0, arguments);
              }
            }), _defineProperty$2(_flatpickr, "onClose", onClose), _defineProperty$2(_flatpickr, "onReady", onHook), _defineProperty$2(_flatpickr, "onMonthChange", onHook), _defineProperty$2(_flatpickr, "onYearChange", onHook), _defineProperty$2(_flatpickr, "onOpen", function onOpen() {
              var onOpen = _this2.props.onOpen;
              onHook.apply(void 0, arguments);

              if (onOpen) {
                onOpen.apply(void 0, arguments);
              }
            }), _defineProperty$2(_flatpickr, "onValueUpdate", onHook), _flatpickr));
            this.addKeyboardEvents(this.cal);
            this.addRoleAttributeToDialog();
          }
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(_ref) {
        var prevDateFormat = _ref.dateFormat,
            prevMinDate = _ref.minDate,
            prevMaxDate = _ref.maxDate,
            prevValue = _ref.value,
            prevDisable = _ref.disable,
            prevEnable = _ref.enable;
        var _this$props2 = this.props,
            dateFormat = _this$props2.dateFormat,
            minDate = _this$props2.minDate,
            maxDate = _this$props2.maxDate,
            value = _this$props2.value,
            disable = _this$props2.disable,
            enable = _this$props2.enable;

        if (this.cal) {
          if (prevDateFormat !== dateFormat) {
            this.cal.set({
              dateFormat: dateFormat
            });
          }

          if (prevMinDate !== minDate) {
            this.cal.set('minDate', minDate);
          }

          if (prevMaxDate !== maxDate) {
            this.cal.set('maxDate', maxDate);
          }

          if (disable !== prevDisable) {
            this.cal.set('disable', disable);
          }

          if (enable !== prevEnable) {
            this.cal.set('enable', enable);
          }
        } // Coordinate when the given `value` prop changes. When this happens, we
        // should update the calendar to the new value.


        if (prevValue !== value) {
          if (this.cal) {
            this.cal.setDate(this.props.value);
            this.updateClassNames(this.cal);
          } else if (this.inputField) {
            this.inputField.value = this.props.value;
          }
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        if (this.cal) {
          this.cal.destroy();
        }

        if (this.inputField) {
          this.inputField.removeEventListener('change', this.onChange);
        }

        if (this.toInputField) {
          this.toInputField.removeEventListener('change', this.onChange);
        }
      }
    }, {
      key: "rightArrowHTML",
      value: function rightArrowHTML() {
        return "\n      <svg width=\"16px\" height=\"16px\" viewBox=\"0 0 16 16\">\n        <polygon points=\"11,8 6,13 5.3,12.3 9.6,8 5.3,3.7 6,3 \"/>\n        <rect width=\"16\" height=\"16\" style=\"fill:none\" />\n      </svg>";
      }
    }, {
      key: "leftArrowHTML",
      value: function leftArrowHTML() {
        return "\n      <svg width=\"16px\" height=\"16px\" viewBox=\"0 0 16 16\">\n        <polygon points=\"5,8 10,3 10.7,3.7 6.4,8 10.7,12.3 10,13 \"/>\n        <rect width=\"16\" height=\"16\" style=\"fill:none\" />\n      </svg>";
      }
    }, {
      key: "render",
      value: function render() {
        var _classNames,
            _this3 = this;

        var _this$props3 = this.props;
            _this$props3.allowInput;
            _this$props3.appendTo;
            var children = _this$props3.children,
            className = _this$props3.className,
            short = _this$props3.short,
            light = _this$props3.light,
            datePickerType = _this$props3.datePickerType;
            _this$props3.minDate;
            _this$props3.maxDate;
            _this$props3.dateFormat;
            _this$props3.onChange;
            _this$props3.locale;
            _this$props3.value;
            var other = _objectWithoutProperties$2(_this$props3, ["allowInput", "appendTo", "children", "className", "short", "light", "datePickerType", "minDate", "maxDate", "dateFormat", "onChange", "locale", "value"]);

        var datePickerClasses = classnames("".concat(prefix$1K, "--date-picker"), className, (_classNames = {}, _defineProperty$2(_classNames, "".concat(prefix$1K, "--date-picker--short"), short), _defineProperty$2(_classNames, "".concat(prefix$1K, "--date-picker--light"), light), _defineProperty$2(_classNames, "".concat(prefix$1K, "--date-picker--simple"), datePickerType === 'simple'), _defineProperty$2(_classNames, "".concat(prefix$1K, "--date-picker--single"), datePickerType === 'single'), _defineProperty$2(_classNames, "".concat(prefix$1K, "--date-picker--range"), datePickerType === 'range'), _defineProperty$2(_classNames, "".concat(prefix$1K, "--date-picker--nolabel"), datePickerType === 'range' && this.isLabelTextEmpty(children)), _classNames));
        var childArray = React__default['default'].Children.toArray(children);
        var childrenWithProps = childArray.map(function (child, index) {
          if (index === 0 && child.type === /*#__PURE__*/React__default['default'].createElement(DatePickerInput, child.props).type) {
            return /*#__PURE__*/React__default['default'].cloneElement(child, {
              datePickerType: datePickerType,
              ref: _this3.assignInputFieldRef,
              openCalendar: _this3.openCalendar
            });
          }

          if (index === 1 && child.type === /*#__PURE__*/React__default['default'].createElement(DatePickerInput, child.props).type) {
            return /*#__PURE__*/React__default['default'].cloneElement(child, {
              datePickerType: datePickerType,
              ref: _this3.assignToInputFieldRef,
              openCalendar: _this3.openCalendar
            });
          }

          if (index === 0) {
            return /*#__PURE__*/React__default['default'].cloneElement(child, {
              ref: _this3.assignInputFieldRef
            });
          }

          if (index === 1) {
            return /*#__PURE__*/React__default['default'].cloneElement(child, {
              ref: _this3.assignToInputFieldRef
            });
          }
        });
        return /*#__PURE__*/React__default['default'].createElement("div", {
          className: "".concat(prefix$1K, "--form-item")
        }, /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
          className: datePickerClasses
        }, other), childrenWithProps));
      }
    }]);

    return DatePicker;
  }(React.Component);

  _defineProperty$2(DatePicker, "propTypes", {
    /**
     * flatpickr prop passthrough. Allows the user to enter a date directly
     * into the input field
     */
    allowInput: PropTypes__default['default'].bool,

    /**
     * The DOM element the Flatpicker should be inserted into. `<body>` by default.
     */
    appendTo: PropTypes__default['default'].object,

    /**
     * The child nodes.
     */
    children: PropTypes__default['default'].node,

    /**
     * The CSS class names.
     */
    className: PropTypes__default['default'].string,

    /**
     * The date format.
     */
    dateFormat: PropTypes__default['default'].string,

    /**
     * The type of the date picker:
     *
     * * `simple` - Without calendar dropdown.
     * * `single` - With calendar dropdown and single date.
     * * `range` - With calendar dropdown and a date range.
     */
    datePickerType: PropTypes__default['default'].oneOf(['simple', 'single', 'range']),

    /**
     * The flatpickr `disable` option that allows a user to disable certain dates.
     */
    disable: PropTypes__default['default'].array,

    /**
     * The flatpickr `enable` option that allows a user to enable certain dates.
     */
    enable: PropTypes__default['default'].array,

    /**
     * `true` to use the light version.
     */
    light: PropTypes__default['default'].bool,

    /**
     *  The language locale used to format the days of the week, months, and numbers. The full list of supported locales can be found here https://github.com/flatpickr/flatpickr/tree/master/src/l10n
     */
    locale: PropTypes__default['default'].oneOfType([PropTypes__default['default'].object, PropTypes__default['default'].oneOf(['ar', // Arabic
    'at', // Austria
    'az', // Azerbaijan
    'be', // Belarusian
    'bg', // Bulgarian
    'bn', // Bangla
    'bs', // Bosnia
    'cat', // Catalan
    'cs', // Czech
    'cy', // Welsh
    'da', // Danish
    'de', // German
    'en', // English
    'eo', // Esperanto
    'es', // Spanish
    'et', // Estonian
    'fa', // Persian
    'fi', // Finnish
    'fo', // Faroese
    'fr', // French
    'ga', // Gaelic
    'gr', // Greek
    'he', // Hebrew
    'hi', // Hindi
    'hr', // Croatian
    'hu', // Hungarian
    'id', // Indonesian
    'is', // Icelandic
    'it', // Italian
    'ja', // Japanese
    'ka', // Georgian
    'km', // Khmer
    'ko', // Korean
    'kz', // Kazakh
    'lt', // Lithuanian
    'lv', // Latvian
    'mk', // Macedonian
    'mn', // Mongolian
    'ms', // Malaysian
    'my', // Burmese
    'nl', // Dutch
    'no', // Norwegian
    'pa', // Punjabi
    'pl', // Polish
    'pt', // Portuguese
    'ro', // Romanian
    'ru', // Russian
    'si', // Sinhala
    'sk', // Slovak
    'sl', // Slovenian
    'sq', // Albanian
    'sr', // Serbian
    'sv', // Swedish
    'th', // Thai
    'tr', // Turkish
    'uk', // Ukrainian
    'uz', // Uzbek
    'uz_latn', // Uzbek Latin
    'vn', // Vietnamese
    'zh_tw', // Mandarin Traditional
    'zh' // Mandarin
    ])]),

    /**
     * The maximum date that a user can pick to.
     */
    maxDate: PropTypes__default['default'].string,

    /**
     * The minimum date that a user can start picking from.
     */
    minDate: PropTypes__default['default'].string,

    /**
     * The `change` event handler.
     */
    onChange: PropTypes__default['default'].func,

    /**
     * The `close` event handler.
     */
    onClose: PropTypes__default['default'].func,

    /**
     * The `open` event handler.
     */
    onOpen: PropTypes__default['default'].func,

    /**
     * `true` to use the short version.
     */
    short: PropTypes__default['default'].bool,

    /**
     * The value of the date value provided to flatpickr, could
     * be a date, a date number, a date string, an array of dates.
     */
    value: PropTypes__default['default'].oneOfType([PropTypes__default['default'].string, PropTypes__default['default'].arrayOf(PropTypes__default['default'].oneOfType([PropTypes__default['default'].string, PropTypes__default['default'].number, PropTypes__default['default'].object])), PropTypes__default['default'].object, PropTypes__default['default'].number])
  });

  _defineProperty$2(DatePicker, "defaultProps", {
    short: false,
    light: false,
    dateFormat: 'm/d/Y',
    locale: 'en'
  });

  var prefix$1J = settings_1.prefix;

  var DropdownSkeleton = function DropdownSkeleton(_ref) {
    var _cx;

    var className = _ref.className,
        size = _ref.size;
        _ref.inline;
        var rest = _objectWithoutProperties$2(_ref, ["className", "size", "inline"]);

    var wrapperClasses = classnames(className, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$1J, "--skeleton"), true), _defineProperty$2(_cx, "".concat(prefix$1J, "--dropdown-v2"), true), _defineProperty$2(_cx, "".concat(prefix$1J, "--list-box"), true), _defineProperty$2(_cx, "".concat(prefix$1J, "--form-item"), true), _defineProperty$2(_cx, "".concat(prefix$1J, "--list-box--").concat(size), size), _cx));
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: wrapperClasses
    }, rest), /*#__PURE__*/React__default['default'].createElement("div", {
      className: "".concat(prefix$1J, "--list-box__field")
    }, /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$1J, "--list-box__label")
    })));
  };

  DropdownSkeleton.propTypes = {
    /**
     * Specify an optional className to add.
     */
    className: PropTypes__default['default'].string,

    /**
     * Specify whether you want the inline version of this control
     */
    inline: deprecate(PropTypes__default['default'].bool, "The `inline` prop has been deprecated and will\n    be removed in the next major release. To specify the inline variant of Dropdown, please use the `type` prop."),

    /**
     * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
     */
    size: ListBoxSize
  };

  var prefix$1I = settings_1.prefix;

  var defaultItemToString$1 = function defaultItemToString(item) {
    if (typeof item === 'string') {
      return item;
    }

    return item ? item.label : '';
  };

  var Dropdown = /*#__PURE__*/React__default['default'].forwardRef(function Dropdown(_ref, ref) {
    var _cx, _cx2, _cx4;

    var containerClassName = _ref.className,
        disabled = _ref.disabled,
        direction = _ref.direction,
        items = _ref.items,
        label = _ref.label,
        ariaLabel = _ref.ariaLabel,
        itemToString = _ref.itemToString,
        itemToElement = _ref.itemToElement,
        type = _ref.type,
        size = _ref.size,
        onChange = _ref.onChange,
        id = _ref.id,
        titleText = _ref.titleText,
        hideLabel = _ref.hideLabel,
        helperText = _ref.helperText,
        translateWithId = _ref.translateWithId,
        light = _ref.light,
        invalid = _ref.invalid,
        invalidText = _ref.invalidText,
        warn = _ref.warn,
        warnText = _ref.warnText,
        initialSelectedItem = _ref.initialSelectedItem,
        controlledSelectedItem = _ref.selectedItem,
        downshiftProps = _ref.downshiftProps,
        other = _objectWithoutProperties$2(_ref, ["className", "disabled", "direction", "items", "label", "ariaLabel", "itemToString", "itemToElement", "type", "size", "onChange", "id", "titleText", "hideLabel", "helperText", "translateWithId", "light", "invalid", "invalidText", "warn", "warnText", "initialSelectedItem", "selectedItem", "downshiftProps"]);

    var selectProps = mapDownshiftProps(_objectSpread2$2(_objectSpread2$2({}, downshiftProps), {}, {
      items: items,
      itemToString: itemToString,
      initialSelectedItem: initialSelectedItem,
      onSelectedItemChange: onSelectedItemChange
    })); // only set selectedItem if the prop is defined. Setting if it is undefined
    // will overwrite default selected items from useSelect

    if (controlledSelectedItem !== undefined) {
      selectProps.selectedItem = controlledSelectedItem;
    }

    var _useSelect = useSelect(selectProps),
        isOpen = _useSelect.isOpen,
        getToggleButtonProps = _useSelect.getToggleButtonProps,
        getLabelProps = _useSelect.getLabelProps,
        getMenuProps = _useSelect.getMenuProps,
        getItemProps = _useSelect.getItemProps,
        highlightedIndex = _useSelect.highlightedIndex,
        selectedItem = _useSelect.selectedItem;

    var inline = type === 'inline';
    var showWarning = !invalid && warn;
    var className = classnames("".concat(prefix$1I, "--dropdown"), containerClassName, (_cx = {}, _defineProperty$2(_cx, "".concat(prefix$1I, "--dropdown--invalid"), invalid), _defineProperty$2(_cx, "".concat(prefix$1I, "--dropdown--warning"), showWarning), _defineProperty$2(_cx, "".concat(prefix$1I, "--dropdown--open"), isOpen), _defineProperty$2(_cx, "".concat(prefix$1I, "--dropdown--inline"), inline), _defineProperty$2(_cx, "".concat(prefix$1I, "--dropdown--disabled"), disabled), _defineProperty$2(_cx, "".concat(prefix$1I, "--dropdown--light"), light), _defineProperty$2(_cx, "".concat(prefix$1I, "--dropdown--").concat(size), size), _defineProperty$2(_cx, "".concat(prefix$1I, "--list-box--up"), direction === 'top'), _cx));
    var titleClasses = classnames("".concat(prefix$1I, "--label"), (_cx2 = {}, _defineProperty$2(_cx2, "".concat(prefix$1I, "--label--disabled"), disabled), _defineProperty$2(_cx2, "".concat(prefix$1I, "--visually-hidden"), hideLabel), _cx2));
    var helperClasses = classnames("".concat(prefix$1I, "--form__helper-text"), _defineProperty$2({}, "".concat(prefix$1I, "--form__helper-text--disabled"), disabled));
    var wrapperClasses = classnames("".concat(prefix$1I, "--dropdown__wrapper"), "".concat(prefix$1I, "--list-box__wrapper"), (_cx4 = {}, _defineProperty$2(_cx4, "".concat(prefix$1I, "--dropdown__wrapper--inline"), inline), _defineProperty$2(_cx4, "".concat(prefix$1I, "--list-box__wrapper--inline"), inline), _defineProperty$2(_cx4, "".concat(prefix$1I, "--dropdown__wrapper--inline--invalid"), inline && invalid), _defineProperty$2(_cx4, "".concat(prefix$1I, "--list-box__wrapper--inline--invalid"), inline && invalid), _cx4)); // needs to be Capitalized for react to render it correctly

    var ItemToElement = itemToElement;
    var toggleButtonProps = getToggleButtonProps();
    var helper = helperText ? /*#__PURE__*/React__default['default'].createElement("div", {
      className: helperClasses
    }, helperText) : null;

    function onSelectedItemChange(_ref2) {
      var selectedItem = _ref2.selectedItem;

      if (onChange) {
        onChange({
          selectedItem: selectedItem
        });
      }
    }

    var menuItemOptionRefs = React.useRef(items.map(function (_) {
      return /*#__PURE__*/React__default['default'].createRef();
    }));
    return /*#__PURE__*/React__default['default'].createElement("div", _extends$3({
      className: wrapperClasses
    }, other), titleText && /*#__PURE__*/React__default['default'].createElement("label", _extends$3({
      className: titleClasses
    }, getLabelProps()), titleText), /*#__PURE__*/React__default['default'].createElement(ListBox, {
      "aria-label": ariaLabel,
      size: size,
      className: className,
      invalid: invalid,
      invalidText: invalidText,
      warn: warn,
      warnText: warnText,
      light: light,
      isOpen: isOpen,
      id: id
    }, invalid && /*#__PURE__*/React__default['default'].createElement(WarningFilled16, {
      className: "".concat(prefix$1I, "--list-box__invalid-icon")
    }), showWarning && /*#__PURE__*/React__default['default'].createElement(WarningAltFilled16, {
      className: "".concat(prefix$1I, "--list-box__invalid-icon ").concat(prefix$1I, "--list-box__invalid-icon--warning")
    }), /*#__PURE__*/React__default['default'].createElement("button", _extends$3({
      type: "button",
      className: "".concat(prefix$1I, "--list-box__field"),
      disabled: disabled,
      "aria-disabled": disabled
    }, toggleButtonProps, {
      ref: mergeRefs(toggleButtonProps.ref, ref)
    }), /*#__PURE__*/React__default['default'].createElement("span", {
      className: "".concat(prefix$1I, "--list-box__label")
    }, selectedItem ? itemToString(selectedItem) : label), /*#__PURE__*/React__default['default'].createElement(ListBox.MenuIcon, {
      isOpen: isOpen,
      translateWi