"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createComponentToggle = createComponentToggle;

var _react = _interopRequireDefault(require("react"));

var _FeatureFlags = require("../components/FeatureFlags");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function createComponentToggle(spec) {
  var name = spec.name,
      _spec$flag = spec.flag,
      flag = _spec$flag === void 0 ? 'enable-v11-release' : _spec$flag,
      next = spec.next,
      classic = spec.classic;

  function ComponentToggle(props, ref) {
    var enabled = (0, _FeatureFlags.useFeatureFlag)(flag);

    if (enabled) {
      if (next) {
        return /*#__PURE__*/_react.default.createElement(next, _objectSpread(_objectSpread({}, props), {}, {
          ref: ref
        }));
      } else {
        return null;
      }
    }

    return /*#__PURE__*/_react.default.createElement(classic, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref
    }));
  }

  ComponentToggle.displayName = "FeatureToggle(".concat(name, ")");
  return /*#__PURE__*/_react.default.forwardRef(ComponentToggle);
}