"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Nested = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ListItem = _interopRequireDefault(require("../ListItem"));

var _UnorderedList = _interopRequireDefault(require("../UnorderedList"));

var _addonKnobs = require("@storybook/addon-knobs");

var _UnorderedList2 = _interopRequireDefault(require("./UnorderedList.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = {
  regular: function regular() {
    return {
      isExpressive: (0, _addonKnobs.boolean)('Expressive', false)
    };
  }
};
var _default = {
  title: 'Components/UnorderedList',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _UnorderedList.default,
    docs: {
      page: _UnorderedList2.default
    },
    subcomponents: {
      ListItem: _ListItem.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_UnorderedList.default, null, /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 1"), /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 1"), /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 1"));
};

exports.Default = Default;
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: 'Lists consist of related content grouped together and organized ' + 'vertically. Unordered lists are used to present content of equal ' + 'status or value.'
  }
};

var Nested = function Nested() {
  var regularProps = props.regular();
  return /*#__PURE__*/_react.default.createElement(_UnorderedList.default, regularProps, /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 1", /*#__PURE__*/_react.default.createElement(_UnorderedList.default, {
    nested: true
  }, /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 2"), /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 2", /*#__PURE__*/_react.default.createElement(_UnorderedList.default, {
    nested: true
  }, /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 2"), /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 2"))))), /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 1"), /*#__PURE__*/_react.default.createElement(_ListItem.default, null, "Unordered List level 1"));
};

exports.Nested = Nested;
Nested.storyName = 'nested';
Nested.parameters = {
  info: {
    text: 'Lists consist of related content grouped together and organized ' + 'vertically. Unordered lists are used to present content of equal ' + 'status or value.'
  }
};