"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithControlledExpansion = exports.WithIcons = exports.Default = exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Notification = require("../Notification");

var _TreeView = _interopRequireWildcard(require("../TreeView"));

require("./story.scss");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var sizes = {
  default: 'default',
  compact: 'compact'
};

var props = function props() {
  return {
    active: (0, _addonKnobs.text)('Active node ID (active)', '5'),
    hideLabel: (0, _addonKnobs.boolean)('Visible label (hideLabel)', false),
    label: (0, _addonKnobs.text)('Label (label)', 'Tree view'),
    multiselect: (0, _addonKnobs.boolean)('Allow selection of multiple tree nodes (multiselect)', false),
    onSelect: (0, _addonActions.action)('onSelect (TreeView onSelect)'),
    selected: (0, _addonKnobs.object)('Array of selected node IDs (selected)', ['5']),
    size: (0, _addonKnobs.select)('Tree size (sizes)', sizes, 'default')
  };
};

var nodes = [{
  id: '1',
  value: 'Artificial intelligence',
  label: /*#__PURE__*/_react.default.createElement("span", null, "Artificial intelligence"),
  renderIcon: _iconsReact.Document16,
  onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
  onToggle: (0, _addonActions.action)('onToggle')
}, {
  id: '2',
  value: 'Blockchain',
  label: 'Blockchain',
  renderIcon: _iconsReact.Document16,
  onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
  onToggle: (0, _addonActions.action)('onToggle')
}, {
  id: '3',
  value: 'Business automation',
  label: 'Business automation',
  renderIcon: _iconsReact.Folder16,
  onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
  onToggle: (0, _addonActions.action)('onToggle'),
  children: [{
    id: '3-1',
    value: 'Business process automation',
    label: 'Business process automation',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }, {
    id: '3-2',
    value: 'Business process mapping',
    label: 'Business process mapping',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }]
}, {
  id: '4',
  value: 'Business operations',
  label: 'Business operations',
  renderIcon: _iconsReact.Document16,
  onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
  onToggle: (0, _addonActions.action)('onToggle')
}, {
  id: '5',
  value: 'Cloud computing',
  label: 'Cloud computing',
  isExpanded: true,
  renderIcon: _iconsReact.Folder16,
  onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
  onToggle: (0, _addonActions.action)('onToggle'),
  children: [{
    id: '5-1',
    value: 'Containers',
    label: 'Containers',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }, {
    id: '5-2',
    value: 'Databases',
    label: 'Databases',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }, {
    id: '5-3',
    value: 'DevOps',
    label: 'DevOps',
    isExpanded: true,
    renderIcon: _iconsReact.Folder16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle'),
    children: [{
      id: '5-4',
      value: 'Solutions',
      label: 'Solutions',
      renderIcon: _iconsReact.Document16,
      onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
      onToggle: (0, _addonActions.action)('onToggle')
    }, {
      id: '5-5',
      value: 'Case studies',
      label: 'Case studies',
      isExpanded: true,
      renderIcon: _iconsReact.Folder16,
      onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
      onToggle: (0, _addonActions.action)('onToggle'),
      children: [{
        id: '5-6',
        value: 'Resources',
        label: 'Resources',
        renderIcon: _iconsReact.Document16,
        onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
        onToggle: (0, _addonActions.action)('onToggle')
      }]
    }]
  }]
}, {
  id: '6',
  value: 'Data & Analytics',
  label: 'Data & Analytics',
  renderIcon: _iconsReact.Folder16,
  onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
  onToggle: (0, _addonActions.action)('onToggle'),
  children: [{
    id: '6-1',
    value: 'Big data',
    label: 'Big data',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }, {
    id: '6-2',
    value: 'Business intelligence',
    label: 'Business intelligence',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }]
}, {
  id: '7',
  value: 'IT infrastructure',
  label: 'IT infrastructure',
  isExpanded: true,
  disabled: true,
  renderIcon: _iconsReact.Folder16,
  onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
  onToggle: (0, _addonActions.action)('onToggle'),
  children: [{
    id: '7-1',
    value: 'Data storage',
    label: 'Data storage',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }, {
    id: '7-2',
    value: 'Enterprise servers',
    label: 'Enterprise servers',
    renderIcon: _iconsReact.Document16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle')
  }, {
    id: '8',
    value: 'Hybrid cloud infrastructure',
    label: 'Hybrid cloud infrastructure',
    isExpanded: true,
    renderIcon: _iconsReact.Folder16,
    onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
    onToggle: (0, _addonActions.action)('onToggle'),
    children: [{
      id: '8-1',
      value: 'Insights',
      label: 'Insights',
      renderIcon: _iconsReact.Document16,
      onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
      onToggle: (0, _addonActions.action)('onToggle')
    }, {
      id: '8-2',
      value: 'Benefits',
      label: 'Benefits',
      renderIcon: _iconsReact.Document16,
      onSelect: (0, _addonActions.action)('onSelect (TreeNode onSelect)'),
      onToggle: (0, _addonActions.action)('onToggle')
    }]
  }]
}];

function renderTree(_ref) {
  var nodes = _ref.nodes,
      expanded = _ref.expanded,
      _ref$withIcons = _ref.withIcons,
      withIcons = _ref$withIcons === void 0 ? false : _ref$withIcons;

  if (!nodes) {
    return;
  }

  return nodes.map(function (_ref2) {
    var children = _ref2.children,
        renderIcon = _ref2.renderIcon,
        isExpanded = _ref2.isExpanded,
        nodeProps = _objectWithoutProperties(_ref2, ["children", "renderIcon", "isExpanded"]);

    return /*#__PURE__*/_react.default.createElement(_TreeView.TreeNode, _extends({
      key: nodeProps.id,
      renderIcon: withIcons ? renderIcon : null,
      isExpanded: expanded !== null && expanded !== void 0 ? expanded : isExpanded
    }, nodeProps), renderTree({
      nodes: children,
      expanded: expanded,
      withIcons: withIcons
    }));
  });
}

var _default = {
  title: 'Experimental/unstable_TreeView',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _TreeView.default
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/_react.default.createElement(_TreeView.default, props(), renderTree({
    nodes: nodes
  })));
};

exports.Default = Default;
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: ""
  }
};

var WithIcons = function WithIcons() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/_react.default.createElement(_TreeView.default, props(), renderTree({
    nodes: nodes,
    withIcons: true
  })));
};

exports.WithIcons = WithIcons;
WithIcons.storyName = 'with icons';

var WithControlledExpansion = function WithControlledExpansion() {
  var _useState = (0, _react.useState)(undefined),
      _useState2 = _slicedToArray(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
    kind: "info",
    title: "Experimental component",
    subtitle: "An accessibility review of this component is in progress"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginBottom: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setExpanded(true);
    }
  }, "expand all"), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setExpanded(false);
    }
  }, "collapse all")), /*#__PURE__*/_react.default.createElement(_TreeView.default, props(), renderTree({
    nodes: nodes,
    expanded: expanded
  })));
};

exports.WithControlledExpansion = WithControlledExpansion;