"use strict";

var _react = _interopRequireDefault(require("react"));

var _Toggle = _interopRequireDefault(require("../Toggle"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var prefix = _carbonComponents.settings.prefix;
describe('Toggle', function () {
  var commonProps = {
    'aria-label': 'Toggle label',
    labelA: 'Off',
    labelB: 'On',
    labelText: 'Toggle label'
  };
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Toggle.default, _extends({}, commonProps, {
      id: "toggle-1"
    })));
    var input = wrapper.find('input');
    it('Switch and label Ids should match', function () {
      var toggleLabel = wrapper.find(".".concat(prefix, "--toggle__label"));
      expect(input.id).toEqual(toggleLabel.htmlFor);
    });
    it('should set defaultChecked as expected', function () {
      expect(input.props().defaultChecked).toEqual(false);
      wrapper.setProps({
        defaultToggled: true
      });
      expect(wrapper.find('input').props().defaultChecked).toEqual(true);
    });
    it('Can set defaultToggled state', function () {
      wrapper.setProps({
        defaultToggled: true
      });
      expect(wrapper.find(".".concat(prefix, "--toggle-input")).props().defaultChecked).toEqual(true);
    });
    it('Should add extra classes that are passed via className', function () {
      wrapper.setProps({
        className: 'extra-class'
      });
      expect(wrapper.find('div').hasClass('extra-class')).toEqual(true);
    });
    it('Can be disabled', function () {
      wrapper.setProps({
        disabled: true
      });
      expect(wrapper.find(".".concat(prefix, "--toggle-input")).props().disabled).toEqual(true);
    });
    it('Can have a labelA', function () {
      wrapper.setProps({
        labelA: 'labelA-test'
      });
      expect(wrapper.find(".".concat(prefix, "--toggle__text--off")).text()).toEqual('labelA-test');
    });
    it('Can have a labelB', function () {
      wrapper.setProps({
        labelB: 'labelB-test'
      });
      expect(wrapper.find(".".concat(prefix, "--toggle__text--on")).text()).toEqual('labelB-test');
    });
  });
  it('toggled prop sets checked prop on input', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Toggle.default, _extends({}, commonProps, {
      id: "test",
      toggled: true
    })));

    var input = function input() {
      return wrapper.find('input');
    };

    expect(input().props().checked).toEqual(true);
    wrapper.setProps({
      toggled: false
    });
    expect(input().props().checked).toEqual(false);
  });
  describe('events', function () {
    it('passes along onChange to <input>', function () {
      var onChange = jest.fn();
      var id = 'test-input';
      var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Toggle.default, _extends({}, commonProps, {
        id: id,
        onChange: onChange
      })));
      var input = wrapper.find('input');
      var inputElement = input.instance();
      inputElement.checked = true;
      wrapper.find('input').simulate('change');
      expect(onChange.mock.calls.map(function (call) {
        return call.map(function (arg, i) {
          return i > 0 ? arg : arg.target;
        });
      })).toEqual([[inputElement]]);
    });
    it('should invoke onToggle with expected arguments', function () {
      var onToggle = jest.fn();
      var id = 'test-input';
      var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Toggle.default, _extends({}, commonProps, {
        id: id,
        onToggle: onToggle
      })));
      var input = wrapper.find('input');
      var inputElement = input.instance();
      inputElement.checked = true;
      wrapper.find('input').simulate('change');
      var call = onToggle.mock.calls[0];
      expect(call[0]).toEqual(true);
      expect(call[1]).toEqual(id);
      expect(call[2].target).toBe(inputElement);
    });
  });
  describe('ToggleSmall', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Toggle.default, _extends({}, commonProps, {
      id: "toggle-1",
      size: "sm"
    })));
    it('Sets the `ToggleSmall` className', function () {
      var input = wrapper.find('input');
      expect(input.hasClass("".concat(prefix, "--toggle-input--small"))).toEqual(true);
    });
    it('Renders a checkmark SVG', function () {
      var svg = wrapper.find(".".concat(prefix, "--toggle__check"));
      expect(svg.length).toBe(1);
    });
  });
});