"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StructuredListWrapper = StructuredListWrapper;
exports.StructuredListHead = StructuredListHead;
exports.StructuredListBody = StructuredListBody;
exports.StructuredListRow = StructuredListRow;
exports.StructuredListInput = StructuredListInput;
exports.StructuredListCell = StructuredListCell;
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _useId = require("../../../internal/useId");

var _deprecate = _interopRequireDefault(require("../../../prop-types/deprecate"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

var GridSelectedRowStateContext = /*#__PURE__*/_react.default.createContext(null);

var GridSelectedRowDispatchContext = /*#__PURE__*/_react.default.createContext(null);

function StructuredListWrapper(props) {
  var children = props.children,
      selection = props.selection,
      className = props.className,
      ariaLabel = props.ariaLabel,
      _border = props.border,
      other = _objectWithoutProperties(props, ["children", "selection", "className", "ariaLabel", "border"]);

  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list"), className, _defineProperty({}, "".concat(prefix, "--structured-list--selection"), selection));

  var _React$useState = _react.default.useState(null),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      selectedRow = _React$useState2[0],
      setSelectedRow = _React$useState2[1];

  return /*#__PURE__*/_react.default.createElement(GridSelectedRowStateContext.Provider, {
    value: selectedRow
  }, /*#__PURE__*/_react.default.createElement(GridSelectedRowDispatchContext.Provider, {
    value: setSelectedRow
  }, /*#__PURE__*/_react.default.createElement("div", _extends({
    role: "grid",
    className: classes
  }, other, {
    "aria-label": ariaLabel
  }), children)));
}

StructuredListWrapper.propTypes = {
  /**
   * Specify a label to be read by screen readers on the container node
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify whether a border should be added to your StructuredListWrapper
   */
  border: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `border` will be removed in the next major version of Carbon."),

  /**
   * Provide the contents of your StructuredListWrapper
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether your StructuredListWrapper should have selections
   */
  selection: _propTypes.default.bool
};
StructuredListWrapper.defaultProps = {
  selection: false,
  ariaLabel: 'Structured list section'
};

function StructuredListHead(props) {
  var children = props.children,
      className = props.className,
      other = _objectWithoutProperties(props, ["children", "className"]);

  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-thead"), className);
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    role: "rowgroup",
    className: classes
  }, other), children);
}

StructuredListHead.propTypes = {
  /**
   * Provide the contents of your StructuredListHead
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the node
   */
  className: _propTypes.default.string
};

function StructuredListBody(props) {
  var children = props.children,
      className = props.className,
      other = _objectWithoutProperties(props, ["children", "className"]);

  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-tbody"), className);
  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: classes,
    role: "rowgroup"
  }, other), children);
}

StructuredListBody.propTypes = {
  /**
   * Provide the contents of your StructuredListBody
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,
  head: _propTypes.default.bool,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: _propTypes.default.func
};
StructuredListBody.defaultProps = {
  onKeyDown: function onKeyDown() {}
};

var GridRowContext = /*#__PURE__*/_react.default.createContext(null);

function StructuredListRow(props) {
  var _classNames2;

  var onKeyDown = props.onKeyDown,
      children = props.children,
      className = props.className,
      head = props.head,
      other = _objectWithoutProperties(props, ["onKeyDown", "children", "className", "head"]);

  var _useState = (0, _react.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      hasFocusWithin = _useState2[0],
      setHasFocusWithin = _useState2[1];

  var id = (0, _useId.useId)('grid-input');

  var setSelectedRow = _react.default.useContext(GridSelectedRowDispatchContext);

  var value = {
    id: id
  };
  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-row"), className, (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--structured-list-row--header-row"), head), _defineProperty(_classNames2, "".concat(prefix, "--structured-list-row--focused-within"), hasFocusWithin), _classNames2));
  return head ? /*#__PURE__*/_react.default.createElement("div", _extends({
    role: "row"
  }, other, {
    className: classes
  }), children) :
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/interactive-supports-focus
  _react.default.createElement("div", _extends({}, other, {
    role: "row",
    className: classes,
    onClick: function onClick() {
      return setSelectedRow(id);
    },
    onFocus: function onFocus() {
      setHasFocusWithin(true);
    },
    onBlur: function onBlur() {
      setHasFocusWithin(false);
    },
    onKeyDown: onKeyDown
  }), /*#__PURE__*/_react.default.createElement(GridRowContext.Provider, {
    value: value
  }, children));
}

StructuredListRow.propTypes = {
  /**
   * Provide the contents of your StructuredListRow
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether your StructuredListRow should be used as a header row
   */
  head: _propTypes.default.bool,

  /**
   * Specify whether a `<label>` should be used
   */
  label: (0, _deprecate.default)(_propTypes.default.bool, "\nThe `label` prop is no longer needed and will be removed in the next major version of Carbon."),

  /**
   * Provide a handler that is invoked on the key down event for the control,
   */
  onKeyDown: _propTypes.default.func
};
StructuredListRow.defaultProps = {
  head: false,
  onKeyDown: function onKeyDown() {}
};

function StructuredListInput(props) {
  var defaultId = (0, _useId.useId)('structureListInput');

  var className = props.className,
      _props$name = props.name,
      name = _props$name === void 0 ? "structured-list-input-".concat(defaultId) : _props$name,
      title = props.title,
      id = props.id,
      other = _objectWithoutProperties(props, ["className", "name", "title", "id"]);

  var classes = (0, _classnames.default)("".concat(prefix, "--structured-list-input"), "".concat(prefix, "--visually-hidden"), className);

  var row = _react.default.useContext(GridRowContext);

  var selectedRow = _react.default.useContext(GridSelectedRowStateContext);

  var setSelectedRow = _react.default.useContext(GridSelectedRowDispatchContext);

  return /*#__PURE__*/_react.default.createElement("input", _extends({}, other, {
    type: "radio",
    tabIndex: 0,
    checked: row && row.id === selectedRow,
    value: row ? row.id : '',
    onChange: function onChange(event) {
      setSelectedRow(event.target.value);
    },
    id: !id && defaultId,
    className: classes,
    name: name,
    title: title
  }));
}

StructuredListInput.propTypes = {
  /**
   * Specify an optional className to be applied to the input
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `defaultChecked` is no longer needed and will be removed in the next major version of Carbon."),

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string,

  /**
   * Provide a `name` for the input
   */
  name: _propTypes.default.string,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: (0, _deprecate.default)(_propTypes.default.func, "\nThe prop `onChange` will be removed in the next major version of Carbon."),

  /**
   * Provide a `title` for the input
   */
  title: _propTypes.default.string,

  /**
   * Specify the value of the input
   */
  value: (0, _deprecate.default)(_propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired, "\nThe prop `value` will be removed in the next major version of Carbon.")
};
StructuredListInput.defaultProps = {
  title: 'title'
};

function StructuredListCell(props) {
  var _classNames3;

  var children = props.children,
      className = props.className,
      head = props.head,
      noWrap = props.noWrap,
      other = _objectWithoutProperties(props, ["children", "className", "head", "noWrap"]);

  var classes = (0, _classnames.default)(className, (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--structured-list-th"), head), _defineProperty(_classNames3, "".concat(prefix, "--structured-list-td"), !head), _defineProperty(_classNames3, "".concat(prefix, "--structured-list-content--nowrap"), noWrap), _classNames3));

  if (head) {
    return /*#__PURE__*/_react.default.createElement("span", _extends({
      className: classes,
      role: "columnheader"
    }, other), children);
  }

  return /*#__PURE__*/_react.default.createElement("div", _extends({
    className: classes,
    role: "cell"
  }, other), children);
}

StructuredListCell.propTypes = {
  /**
   * Provide the contents of your StructuredListCell
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether your StructuredListCell should be used as a header cell
   */
  head: _propTypes.default.bool,

  /**
   * Specify whether your StructuredListCell should have text wrapping
   */
  noWrap: _propTypes.default.bool
};
StructuredListCell.defaultProps = {
  head: false,
  noWrap: false
};
var _default = {
  StructuredListWrapper: StructuredListWrapper,
  StructuredListHead: StructuredListHead,
  StructuredListBody: StructuredListBody,
  StructuredListRow: StructuredListRow,
  StructuredListInput: StructuredListInput,
  StructuredListCell: StructuredListCell
};
exports.default = _default;