"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Select = _interopRequireDefault(require("../Select"));

var _SelectItem = _interopRequireDefault(require("../SelectItem"));

var _SelectItemGroup = _interopRequireDefault(require("../SelectItemGroup"));

var _Select2 = _interopRequireDefault(require("../Select/Select.Skeleton"));

var _Select3 = _interopRequireDefault(require("./Select.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  select: function select() {
    return {
      className: 'some-class',
      light: (0, _addonKnobs.boolean)('Light variant (light in <Select>)', false),
      inline: (0, _addonKnobs.boolean)('Put control in-line with label (inline in <Select>)', false),
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <Select>)', false),
      hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel in <Select>)', false),
      invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid in <Select>)', false),
      invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText in <Select>)', 'A valid value is required'),
      labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Select'),
      helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text.'),
      onChange: (0, _addonActions.action)('onChange'),
      warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
      warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'This will overwrite your current settings')
    };
  },
  group: function group() {
    return {
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <SelectItemGroup>)', false)
    };
  }
};
var _default = {
  title: 'Components/Select',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Select.default,
    docs: {
      page: _Select3.default
    },
    subcomponents: {
      SelectItem: _SelectItem.default,
      SelectItemGroup: _SelectItemGroup.default,
      SelectSkeleton: _Select2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  var groupProps = props.group();
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_Select.default, _extends({}, props.select(), {
    id: "select-1",
    defaultValue: "placeholder-item"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, _extends({
    label: "Category 1"
  }, groupProps), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, _extends({
    label: "Category 2"
  }, groupProps), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  }))));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        Select displays a list below its title when selected. They are used primarily in forms,\n        where a user chooses one option from a list. Once the user selects an item, the dropdown will\n        disappear and the field will reflect the user's choice. Create Select Item components for each\n        option in the list. The example below shows an enabled Select component with three items.\n      "
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    },
    "aria-label": "loading select",
    "aria-live": "assertive",
    role: "status",
    tabIndex: "0" // eslint-disable-line jsx-a11y/no-noninteractive-tabindex

  }, /*#__PURE__*/_react.default.createElement(_Select2.default, null));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n      "
  }
};