"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Popover = Popover;
exports.PopoverContent = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function Popover(_ref) {
  var _cx;

  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      _ref$caret = _ref.caret,
      caret = _ref$caret === void 0 ? true : _ref$caret,
      customClassName = _ref.className,
      children = _ref.children,
      _ref$align = _ref.align,
      align = _ref$align === void 0 ? 'bottom' : _ref$align,
      _ref$highContrast = _ref.highContrast,
      highContrast = _ref$highContrast === void 0 ? false : _ref$highContrast,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light,
      open = _ref.open,
      relative = _ref.relative,
      rest = _objectWithoutProperties(_ref, ["as", "caret", "className", "children", "align", "highContrast", "light", "open", "relative"]);

  var className = (0, _classnames.default)((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--popover"), true), _defineProperty(_cx, "".concat(prefix, "--popover--caret"), caret), _defineProperty(_cx, "".concat(prefix, "--popover--light"), light), _defineProperty(_cx, "".concat(prefix, "--popover--high-contrast"), highContrast), _defineProperty(_cx, "".concat(prefix, "--popover--").concat(align), true), _defineProperty(_cx, "".concat(prefix, "--popover--open"), open), _defineProperty(_cx, "".concat(prefix, "--popover--relative"), relative), _defineProperty(_cx, customClassName, !!customClassName), _cx));
  return /*#__PURE__*/_react.default.createElement(BaseComponent, _extends({}, rest, {
    className: className
  }), children);
}

Popover.propTypes = {
  /**
   * Specify how the popover should align with the trigger element
   */
  align: _propTypes.default.oneOf(['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top']),

  /**
   * Provide a custom element or component to render the top-level node for the
   * component.
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Specify whether a caret should be rendered
   */
  caret: _propTypes.default.bool,

  /**
   * Provide elements to be rendered inside of the component
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom class name to be added to the outermost node in the
   * component
   */
  className: _propTypes.default.string,

  /**
   * Render the component using the high-contrast variant
   */
  highContrast: _propTypes.default.bool,

  /**
   * Render the component using the light variant
   */
  light: _propTypes.default.bool,

  /**
   * Specify whether the component is currently open or closed
   */
  open: _propTypes.default.bool.isRequired,

  /**
   * Specify whether the component should be positioned using position:
   * relative. By default, it will use position: absolute
   */
  relative: _propTypes.default.bool
};

var PopoverContent = /*#__PURE__*/_react.default.forwardRef(function PopoverContent(_ref2, ref) {
  var _ref2$as = _ref2.as,
      BaseComponent = _ref2$as === void 0 ? 'div' : _ref2$as,
      className = _ref2.className,
      children = _ref2.children,
      rest = _objectWithoutProperties(_ref2, ["as", "className", "children"]);

  return /*#__PURE__*/_react.default.createElement(BaseComponent, _extends({}, rest, {
    className: (0, _classnames.default)("".concat(prefix, "--popover-contents"), className),
    ref: ref
  }), children);
});

exports.PopoverContent = PopoverContent;
PopoverContent.propTypes = {
  /**
   * Provide a custom element or component to render the top-level node for the
   * component.
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide elements to be rendered inside of the component
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom class name to be added to the outermost node in the
   * component
   */
  className: _propTypes.default.string
};