"use strict";

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _Notification = require("../next/Notification");

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

require("@testing-library/jest-dom");

var _carbonComponents = require("carbon-components");

var _windowOrGlobal = require("window-or-global");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var prefix = _carbonComponents.settings.prefix;
describe('NotificationButton', function () {
  (0, _windowOrGlobal.it)('should place the `className` prop on the outermost DOM node', function () {
    var _render = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, {
      className: "test"
    })),
        container = _render.container;

    expect(container.firstChild).toHaveClass('test');
  });
  (0, _windowOrGlobal.it)('renders only one icon', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, null));
    expect(_react2.screen.queryAllByRole('img').length).toEqual(1);
  });
  (0, _windowOrGlobal.it)('supports custom icon', function () {
    var _render2 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, null)),
        rerender = _render2.rerender;

    var defaultIcon = _react2.screen.queryByRole('img').innerHTML;

    rerender( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, {
      renderIcon: _iconsReact.ErrorFilled20
    }));

    var customIcon = _react2.screen.queryByRole('img').innerHTML;

    expect(defaultIcon).not.toEqual(customIcon);
  });
  (0, _windowOrGlobal.it)('interpolates matching className based on notificationType prop', function () {
    var _render3 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, null)),
        rerender = _render3.rerender,
        container = _render3.container;

    var notificationTypes = ['toast', 'inline'];
    notificationTypes.forEach(function (notificationType) {
      rerender( /*#__PURE__*/_react.default.createElement(_Notification.NotificationButton, {
        notificationType: notificationType
      }));
      expect(container.firstChild).toHaveClass("".concat(prefix, "--").concat(notificationType, "-notification__close-button"));
      expect(_react2.screen.queryByRole('img')).toHaveClass("".concat(prefix, "--").concat(notificationType, "-notification__close-icon"));
    });
  });
});
describe('ToastNotification', function () {
  (0, _windowOrGlobal.it)('should have role=status by default', function () {
    var _render4 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null)),
        container = _render4.container;

    expect(container.firstChild).toHaveAttribute('role', 'status');
  });
  (0, _windowOrGlobal.it)('should place the `className` prop on the outermost DOM node', function () {
    var _render5 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      className: "test"
    })),
        container = _render5.container;

    expect(container.firstChild).toHaveClass('test');
  });
  (0, _windowOrGlobal.it)('interpolates matching className based on kind prop', function () {
    var _render6 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null)),
        rerender = _render6.rerender;

    var kinds = ['error', 'info', 'info-square', 'success', 'warning', 'warning-alt'];
    kinds.forEach(function (kind) {
      rerender( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
        kind: kind
      }));
      expect(_react2.screen.queryByRole('status')).toHaveClass("".concat(prefix, "--toast-notification--").concat(kind));
    });
  });
  (0, _windowOrGlobal.it)('allows non-interactive elements as children', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null, /*#__PURE__*/_react.default.createElement("p", null, "Sample text")));
    expect(_react2.screen.queryByText(/Sample text/i)).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('does not allow interactive elements as children', function () {
    var spy = jest.spyOn(console, 'error').mockImplementation(function () {});
    expect(function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null, /*#__PURE__*/_react.default.createElement("button", {
        type: "button"
      }, "Sample text")));
    }).toThrow();
    expect(spy).toHaveBeenCalled();
    spy.mockRestore();
  });
  (0, _windowOrGlobal.it)('close button is rendered by default and includes aria-hidden=true', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, null));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).toBeInTheDocument();
    expect(closeButton).toHaveAttribute('aria-hidden', 'true');
  });
  (0, _windowOrGlobal.it)('does not render close button when `hideCloseButton` is provided', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      hideCloseButton: true
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).not.toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onClose` when notification is closed', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    var onClose, closeButton;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
              onClose: onClose
            }));
            closeButton = _react2.screen.queryByRole('button', {
              hidden: true
            });

            _userEvent.default.click(closeButton);

            expect(onClose).toHaveBeenCalledTimes(1);
            _context.next = 7;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 7:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
  (0, _windowOrGlobal.it)('keeps notification open if `onClose` returns false', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      onClose: function onClose() {
        return false;
      }
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(_react2.screen.queryByRole('status')).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onCloseButtonClick` when notification is closed', function () {
    var onCloseButtonClick = jest.fn();
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
      onCloseButtonClick: onCloseButtonClick
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
  });
  (0, _windowOrGlobal.it)('closes notification via escape button', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
    var onCloseButtonClick, onClose;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            onCloseButtonClick = jest.fn();
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.ToastNotification, {
              onClose: onClose,
              onCloseButtonClick: onCloseButtonClick
            }));

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
            expect(onClose).toHaveBeenCalledTimes(1);
            _context2.next = 8;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 8:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  })));
});
describe('InlineNotification', function () {
  (0, _windowOrGlobal.it)('should have role=status by default', function () {
    var _render7 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null)),
        container = _render7.container;

    expect(container.firstChild).toHaveAttribute('role', 'status');
  });
  (0, _windowOrGlobal.it)('should place the `className` prop on the outermost DOM node', function () {
    var _render8 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      className: "test"
    })),
        container = _render8.container;

    expect(container.firstChild).toHaveClass('test');
  });
  (0, _windowOrGlobal.it)('interpolates matching className based on kind prop', function () {
    var _render9 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null)),
        rerender = _render9.rerender;

    var kinds = ['error', 'info', 'info-square', 'success', 'warning', 'warning-alt'];
    kinds.forEach(function (kind) {
      rerender( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
        kind: kind
      }));
      expect(_react2.screen.queryByRole('status')).toHaveClass("".concat(prefix, "--inline-notification--").concat(kind));
    });
  });
  (0, _windowOrGlobal.it)('allows non-interactive elements as children', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null, /*#__PURE__*/_react.default.createElement("p", null, "Sample text")));
    expect(_react2.screen.queryByText(/Sample text/i)).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('allows interactive elements as children', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null, /*#__PURE__*/_react.default.createElement("button", {
      type: "button"
    }, "Sample text")));
    expect(_react2.screen.queryByText(/Sample text/i)).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('close button is rendered by default and includes aria-hidden=true', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, null));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).toBeInTheDocument();
    expect(closeButton).toHaveAttribute('aria-hidden', 'true');
  });
  (0, _windowOrGlobal.it)('does not render close button when `hideCloseButton` is provided', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      hideCloseButton: true
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    expect(closeButton).not.toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onClose` when notification is closed', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
    var onClose, closeButton;
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
              onClose: onClose
            }));
            closeButton = _react2.screen.queryByRole('button', {
              hidden: true
            });

            _userEvent.default.click(closeButton);

            expect(onClose).toHaveBeenCalledTimes(1);
            _context3.next = 7;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 7:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  })));
  (0, _windowOrGlobal.it)('keeps notification open if `onClose` returns false', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      onClose: function onClose() {
        return false;
      }
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(_react2.screen.queryByRole('status')).toBeInTheDocument();
  });
  (0, _windowOrGlobal.it)('calls `onCloseButtonClick` when notification is closed', function () {
    var onCloseButtonClick = jest.fn();
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      onCloseButtonClick: onCloseButtonClick
    }));

    var closeButton = _react2.screen.queryByRole('button', {
      hidden: true
    });

    _userEvent.default.click(closeButton);

    expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
  });
  (0, _windowOrGlobal.it)('closes notification via escape button', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
    var onCloseButtonClick, onClose;
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            onCloseButtonClick = jest.fn();
            onClose = jest.fn();
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
              onClose: onClose,
              onCloseButtonClick: onCloseButtonClick
            }));

            _userEvent.default.keyboard('{Escape}');

            expect(onCloseButtonClick).toHaveBeenCalledTimes(1);
            expect(onClose).toHaveBeenCalledTimes(1);
            _context4.next = 8;
            return (0, _react2.waitFor)(function () {
              expect(_react2.screen.queryByRole('status')).not.toBeInTheDocument();
            });

          case 8:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  })));
  (0, _windowOrGlobal.it)('renders actions when provided, and overrides role to be alertdialog', function () {
    var _render10 = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Notification.InlineNotification, {
      actions: /*#__PURE__*/_react.default.createElement(_Notification.NotificationActionButton, null, "Button text")
    })),
        container = _render10.container;

    var actionButton = _react2.screen.queryByRole('button', {
      name: 'Button text'
    });

    expect(actionButton).toBeInTheDocument();
    expect(container.firstChild).toHaveAttribute('role', 'alertdialog');
  });
});