"use strict";

require("carbon-components/scss/components/modal/_modal.scss");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@cypress/react");

var _Modal = _interopRequireDefault(require("../Modal"));

var _Select = _interopRequireDefault(require("../Select"));

var _SelectItem = _interopRequireDefault(require("../SelectItem"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

var _layout = require("@carbon/layout");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('Modal', function () {
  beforeEach(function () {
    (0, _react2.mount)( /*#__PURE__*/_react.default.createElement(_Modal.default, {
      open: true,
      modalHeading: "Add a custom domain",
      modalLabel: "Account resources",
      primaryButtonText: "Add",
      secondaryButtonText: "Cancel"
    }, /*#__PURE__*/_react.default.createElement("p", {
      style: {
        marginBottom: '1rem'
      }
    }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
      "data-modal-primary-focus": true,
      id: "text-input-1",
      labelText: "Domain name",
      placeholder: "e.g. github.com",
      style: {
        marginBottom: '1rem'
      }
    }), /*#__PURE__*/_react.default.createElement(_Select.default, {
      id: "select-1",
      defaultValue: "us-south",
      labelText: "Region"
    }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
      value: "us-south",
      text: "US South"
    }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
      value: "us-east",
      text: "US East"
    }))));
  });
  Object.keys(_layout.breakpoints).forEach(function (breakpoint) {
    // make assertions on the modal using
    // the array of different breakpoints
    it("should render at ".concat(breakpoint, " breakpoint"), function () {
      // convert rem value from breakpoints into a raw number representation of pixels.
      // cy.viewport() only accepts numbers that equate to pixel values
      var width = parseInt(_layout.breakpoints[breakpoint].width.replace('rem', '')) * _layout.baseFontSize;

      cy.viewport(width, 500);
      cy.findByText(/Add a custom domain/).should('be.visible');
      cy.findByText(/Account resources/).should('be.visible');
      cy.findByText(/^Add$/).should('be.visible'); // full string match to prevent collisions

      cy.findByText(/Cancel/).should('be.visible');
      cy.findByLabelText(/Domain name/).should('be.visible');
      cy.findByLabelText(/Region/).should('be.visible'); // snapshots should always be taken _after_ an assertion that
      // a element/component should be visible. This is to ensure
      // the DOM has settled and the element has fully loaded.
      //
      // only take snapshots at two primary widths to be mindful of our snapshot quota limit

      if (breakpoint === 'sm' || breakpoint === 'lg') {
        cy.percySnapshot();
      }
    });
  });
});