"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function MenuGroup(_ref) {
  var label = _ref.label,
      children = _ref.children;
  return /*#__PURE__*/_react.default.createElement("li", {
    role: "none"
  }, /*#__PURE__*/_react.default.createElement("ul", {
    role: "group",
    "aria-label": label
  }, children));
}

MenuGroup.propTypes = {
  /**
   * Specify the children of the MenuGroup
   */
  children: _propTypes.default.node,

  /**
   * Rendered label for the MenuGroup
   */
  label: _propTypes.default.node.isRequired
};
var _default = MenuGroup;
exports.default = _default;