"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _FeatureFlags = require("../FeatureFlags");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function Column(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      children = _ref.children,
      containerClassName = _ref.className,
      sm = _ref.sm,
      md = _ref.md,
      lg = _ref.lg,
      xlg = _ref.xlg,
      max = _ref.max,
      rest = _objectWithoutProperties(_ref, ["as", "children", "className", "sm", "md", "lg", "xlg", "max"]);

  var hasCSSGrid = (0, _FeatureFlags.useFeatureFlag)('enable-css-grid');
  var columnClassName = hasCSSGrid ? getClassNameForBreakpoints([sm, md, lg, xlg, max]) : getClassNameForFlexGridBreakpoints([sm, md, lg, xlg, max]);
  var className = (0, _classnames.default)(containerClassName, columnClassName, _defineProperty({}, "".concat(prefix, "--col"), columnClassName.length === 0));
  return /*#__PURE__*/_react.default.createElement(BaseComponent, _extends({
    className: className
  }, rest), children);
}

var spanPropType = _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.number, _propTypes.default.shape({
  span: _propTypes.default.number,
  offset: _propTypes.default.number
})]);

Column.propTypes = {
  /**
   * Provide a custom element to render instead of the default <div>
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Pass in content that will be rendered within the `Column`
   */
  children: _propTypes.default.node,

  /**
   * Specify a custom className to be applied to the `Column`
   */
  className: _propTypes.default.string,

  /**
   * Specify column span for the `lg` breakpoint (Default breakpoint up to 1312px)
   * This breakpoint supports 16 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  lg: spanPropType,

  /**
   * Specify column span for the `max` breakpoint. This breakpoint supports 16
   * columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  max: spanPropType,

  /**
   * Specify column span for the `md` breakpoint (Default breakpoint up to 1056px)
   * This breakpoint supports 8 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  md: spanPropType,

  /**
   * Specify column span for the `sm` breakpoint (Default breakpoint up to 672px)
   * This breakpoint supports 4 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  sm: spanPropType,

  /**
   * Specify column span for the `xlg` breakpoint (Default breakpoint up to
   * 1584px) This breakpoint supports 16 columns by default.
   *
   * @see https://www.carbondesignsystem.com/guidelines/layout#breakpoints
   */
  xlg: spanPropType
};
var breakpointNames = ['sm', 'md', 'lg', 'xlg', 'max'];
/**
 * @typedef {object} Breakpoint
 * @property {boolean|number} [span]
 * @property {number} [offset]
 */

/**
 * Build the appropriate className for the given set of breakpoints.
 * @param {Array<boolean|number|Breakpoint>} breakpoints
 * @returns {string}
 */

function getClassNameForBreakpoints(breakpoints) {
  var classNames = [];

  for (var i = 0; i < breakpoints.length; i++) {
    var breakpoint = breakpoints[i];

    if (breakpoint === undefined || breakpoint === null) {
      continue;
    }

    var name = breakpointNames[i]; // If our breakpoint is a boolean, the user has specified that the column
    // should be "auto" at this size

    if (breakpoint === true) {
      classNames.push("".concat(prefix, "--").concat(name, ":col-span-auto"));
      continue;
    } // If our breakpoint is a number, the user has specified the number of
    // columns they'd like this column to span


    if (typeof breakpoint === 'number') {
      classNames.push("".concat(prefix, "--").concat(name, ":col-span-").concat(breakpoint));
      continue;
    }

    var span = breakpoint.span,
        offset = breakpoint.offset;

    if (typeof offset === 'number' && offset > 0) {
      classNames.push("".concat(prefix, "--").concat(name, ":col-start-").concat(offset + 1));
    }

    if (typeof span === 'number') {
      if (typeof offset === 'number' && offset > 0) {
        classNames.push("".concat(prefix, "--").concat(name, ":col-end-").concat(offset + span + 1));
      } else {
        classNames.push("".concat(prefix, "--").concat(name, ":col-span-").concat(span));
      }
    }

    if (span === true) {
      classNames.push("".concat(prefix, "--").concat(name, ":col-span-auto"));
    }
  }

  return classNames.join(' ');
}
/**
 * Build the appropriate className for the given set of breakpoints.
 * @param {Array<boolean|number|Breakpoint>} breakpoints
 * @returns {string}
 */


function getClassNameForFlexGridBreakpoints(breakpoints) {
  var classNames = [];

  for (var i = 0; i < breakpoints.length; i++) {
    var breakpoint = breakpoints[i];

    if (breakpoint === undefined || breakpoint === null) {
      continue;
    }

    var name = breakpointNames[i]; // If our breakpoint is a boolean, the user has specified that the column
    // should be "auto" at this size

    if (breakpoint === true) {
      classNames.push("".concat(prefix, "--col-").concat(name));
      continue;
    } // If our breakpoint is a number, the user has specified the number of
    // columns they'd like this column to span


    if (typeof breakpoint === 'number') {
      classNames.push("".concat(prefix, "--col-").concat(name, "-").concat(breakpoint));
      continue;
    }

    var span = breakpoint.span,
        offset = breakpoint.offset;

    if (typeof span === 'number') {
      classNames.push("".concat(prefix, "--col-").concat(name, "-").concat(span));
    }

    if (span === true) {
      classNames.push("".concat(prefix, "--col-").concat(name));
    }

    if (typeof offset === 'number') {
      classNames.push("".concat(prefix, "--offset-").concat(name, "-").concat(offset));
    }
  }

  return classNames.join(' ');
}

var _default = Column;
exports.default = _default;