"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _FluidForm = _interopRequireDefault(require("../FluidForm"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var additionalProps = {
  className: 'some-class',
  onSubmit: function onSubmit(e) {
    e.preventDefault();
    (0, _addonActions.action)('FormSubmitted')(e);
  }
};
var TextInputProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Text Input label',
  placeholder: 'Placeholder text'
};
var InvalidPasswordProps = {
  className: 'some-class',
  id: 'test4',
  labelText: 'Password',
  invalid: true,
  invalidText: 'Your password must be at least 6 characters as well as contain at least one uppercase, one lowercase, and one number.'
};
var _default = {
  title: 'Experimental/FluidForm',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _FluidForm.default
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_FluidForm.default, additionalProps, /*#__PURE__*/_react.default.createElement(_TextInput.default, TextInputProps), /*#__PURE__*/_react.default.createElement(_TextInput.default, _extends({
    type: "password",
    required: true,
    pattern: "(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{6,}"
  }, InvalidPasswordProps)));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        Forms are widely used to collect user input.\n\n        Form can have any number of react components enclosed within FormGroup component. FormGroup component\n        is a wrapper for legend and fieldset component.\n\n      "
  }
};