"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.DragAndDropUploadContainerExampleApplication = exports._FileUploaderDropContainer = exports._FileUploaderItem = exports._FileUploader = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _carbonComponents = require("carbon-components");

var _FileUploader2 = _interopRequireWildcard(require("../FileUploader"));

var _FileUploader3 = _interopRequireDefault(require("../FileUploader/FileUploader.Skeleton"));

var _FileUploaderItem2 = _interopRequireDefault(require("./FileUploaderItem"));

var _FileUploaderDropContainer2 = _interopRequireDefault(require("./FileUploaderDropContainer"));

var _FileUploader4 = _interopRequireDefault(require("./FileUploader.mdx"));

require("./FileUploader-story.scss");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
var prefix = _carbonComponents.settings.prefix;
var buttonKinds = {
  'Primary (primary)': 'primary',
  'Secondary (secondary)': 'secondary',
  'Danger (danger)': 'danger',
  'Ghost (ghost)': 'ghost',
  'Danger Primary (danger--primary)': 'danger--primary',
  'Tertiary (tertiary)': 'tertiary'
};
var sizes = {
  'Compat check - Field': 'field',
  'Compat check - Small': 'small',
  'Compat check - default': 'default',
  'Small  (sm)': 'sm',
  'Medium (md)': 'md',
  'Large (lg) - Default': 'lg'
};
var filenameStatuses = {
  'Edit (edit)': 'edit',
  'Complete (complete)': 'complete',
  'Uploading (uploading)': 'uploading'
};
var props = {
  fileUploaderButton: function fileUploaderButton() {
    var buttonKind = (0, _addonKnobs.select)('Button kind (buttonKind)', buttonKinds, '');
    return {
      className: 'bob',
      labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Add files'),
      name: (0, _addonKnobs.text)('Form item name: (name)', ''),
      multiple: (0, _addonKnobs.boolean)('Supports multiple files (multiple)', true),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      buttonKind: buttonKind || 'primary',
      size: (0, _addonKnobs.select)('Button size (size)', sizes, 'default'),
      disableLabelChanges: (0, _addonKnobs.boolean)('Prevent the label from being replaced with file selected file (disableLabelChanges)', false),
      role: (0, _addonKnobs.text)('ARIA role of the button (role)', 'button'),
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex)', 0),
      onChange: (0, _addonActions.action)('onChange')
    };
  },
  fileUploader: function fileUploader() {
    var buttonKind = (0, _addonKnobs.select)('Button kind (buttonKind)', {
      'Primary (primary)': 'primary',
      'Tertiary (tertiary)': 'tertiary'
    }, '');
    return {
      labelTitle: (0, _addonKnobs.text)('The label title (labelTitle)', 'Upload files'),
      labelDescription: (0, _addonKnobs.text)('The label description (labelDescription)', 'Max file size is 500mb. Only .jpg files are supported.'),
      buttonLabel: (0, _addonKnobs.text)('The button label (buttonLabel)', 'Add file'),
      buttonKind: buttonKind || 'primary',
      size: (0, _addonKnobs.select)('Button size (size)', sizes, 'default'),
      filenameStatus: (0, _addonKnobs.select)('Status for file name (filenameStatus)', filenameStatuses, 'edit'),
      accept: (0, _addonKnobs.array)('Accepted file extensions (accept)', ['.jpg', '.png'], ','),
      name: (0, _addonKnobs.text)('Form item name: (name)', ''),
      multiple: (0, _addonKnobs.boolean)('Supports multiple files (multiple)', true),
      iconDescription: (0, _addonKnobs.text)('Close button icon description (iconDescription)', 'Clear file'),
      onChange: (0, _addonActions.action)('onChange'),
      onClick: (0, _addonActions.action)('onClick'),
      onDelete: (0, _addonActions.action)('onDelete')
    };
  },
  fileUploaderItem: function fileUploaderItem() {
    return {
      name: (0, _addonKnobs.text)('Filename (name)', 'README.md'),
      status: (0, _addonKnobs.select)('Status for file name (status)', filenameStatuses, 'edit'),
      iconDescription: (0, _addonKnobs.text)('Close button icon description (iconDescription)', 'Clear file'),
      onDelete: (0, _addonActions.action)('onDelete'),
      invalid: (0, _addonKnobs.boolean)('Invalid (invalid)', false),
      errorSubject: (0, _addonKnobs.text)('Error subject (errorSubject)', 'File size exceeds limit'),
      errorBody: (0, _addonKnobs.text)('Error body (errorBody)', '500kb max file size. Select a new file and try again.'),
      size: (0, _addonKnobs.select)('FileUploaderItem height (size)', sizes, 'default')
    };
  },
  fileUploaderDropContainer: function fileUploaderDropContainer() {
    return {
      size: (0, _addonKnobs.select)('Filename height (size)', sizes, 'default'),
      labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Drag and drop files here or click to upload'),
      name: (0, _addonKnobs.text)('Form item name (name)', ''),
      multiple: (0, _addonKnobs.boolean)('Supports multiple files (multiple)', true),
      accept: (0, _addonKnobs.array)('Accepted MIME types or file extensions (accept)', ['image/jpeg', 'image/png'], ','),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      role: (0, _addonKnobs.text)('ARIA role of the button (role)', ''),
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex)', 0),
      onChange: (0, _addonActions.action)('onChange')
    };
  }
};
var _default = {
  title: 'Components/FileUploader',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _FileUploader2.default,
    docs: {
      page: _FileUploader4.default
    },
    subcomponents: {
      FileUploaderButton: _FileUploader2.FileUploaderButton,
      FileUploaderSkeleton: _FileUploader3.default,
      FileUploaderItem: _FileUploaderItem2.default,
      FileUploaderDropContainer: _FileUploaderDropContainer2.default
    }
  }
};
exports.default = _default;

var _FileUploader = function _FileUploader() {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--file__container")
  }, /*#__PURE__*/_react.default.createElement(_FileUploader2.default, props.fileUploader()));
};

exports._FileUploader = _FileUploader;
_FileUploader.storyName = 'FileUploader';
_FileUploader.parameters = {
  info: {
    text: "\n        The FileUploader components allow the user to upload any necessary files. This uses the FileUploaderButton and Filename components. Filename components will appear below the FileUploaderButton when files are added. Use the filenameStatus prop to control what icon appears in Filename ('edit', 'complete', or 'uploading').\n      "
  }
};

var _FileUploaderItem = function _FileUploaderItem() {
  return /*#__PURE__*/_react.default.createElement(_FileUploaderItem2.default, props.fileUploaderItem());
};

exports._FileUploaderItem = _FileUploaderItem;
_FileUploaderItem.storyName = 'FileUploaderItem';
_FileUploaderItem.parameters = {
  info: {
    text: "\n      <FileUploaderItem /> represents an item that has been uploaded to the file uploader component. Use the `status` prop to control which icon appears ('edit', 'complete', or 'uploading').\n    "
  }
};

var _FileUploaderDropContainer = function _FileUploaderDropContainer() {
  return /*#__PURE__*/_react.default.createElement(_FileUploaderDropContainer2.default, props.fileUploaderDropContainer());
};

exports._FileUploaderDropContainer = _FileUploaderDropContainer;
_FileUploaderDropContainer.storyName = 'FileUploaderDropContainer';
_FileUploaderDropContainer.parameters = {
  info: {
    text: '<FileUploaderDropContainer /> is a drag and drop file uploader which allows users to upload files via both the normal file selection dialog and by dragging and dropping files.'
  }
};

var DragAndDropUploadContainerExampleApplication = function DragAndDropUploadContainerExampleApplication() {
  return require('./stories/drop-container').default(props.fileUploaderDropContainer());
};

exports.DragAndDropUploadContainerExampleApplication = DragAndDropUploadContainerExampleApplication;
DragAndDropUploadContainerExampleApplication.storyName = 'Drag and drop upload container example application';
DragAndDropUploadContainerExampleApplication.parameters = {
  info: {
    text: 'Example application with drag and drop file uploader'
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '500px'
    }
  }, /*#__PURE__*/_react.default.createElement(_FileUploader3.default, null));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\nPlaceholder skeleton state to use when content is loading.\n"
  }
};