"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;

var DatePickerInput = /*#__PURE__*/function (_Component) {
  _inherits(DatePickerInput, _Component);

  var _super = _createSuper(DatePickerInput);

  function DatePickerInput() {
    _classCallCheck(this, DatePickerInput);

    return _super.apply(this, arguments);
  }

  _createClass(DatePickerInput, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _classNames3,
          _this = this;

      var _this$props = this.props,
          id = _this$props.id,
          labelText = _this$props.labelText,
          disabled = _this$props.disabled,
          invalid = _this$props.invalid,
          invalidText = _this$props.invalidText,
          hideLabel = _this$props.hideLabel,
          _onChange = _this$props.onChange,
          _onClick = _this$props.onClick,
          placeholder = _this$props.placeholder,
          type = _this$props.type,
          datePickerType = _this$props.datePickerType,
          pattern = _this$props.pattern,
          iconDescription = _this$props.iconDescription,
          openCalendar = _this$props.openCalendar,
          size = _this$props.size,
          warn = _this$props.warn,
          warnText = _this$props.warnText,
          other = _objectWithoutProperties(_this$props, ["id", "labelText", "disabled", "invalid", "invalidText", "hideLabel", "onChange", "onClick", "placeholder", "type", "datePickerType", "pattern", "iconDescription", "openCalendar", "size", "warn", "warnText"]);

      var datePickerInputProps = {
        id: id,
        onChange: function onChange(evt) {
          if (!disabled) {
            _onChange(evt);
          }
        },
        onClick: function onClick(evt) {
          if (!disabled) {
            _onClick(evt);
          }
        },
        placeholder: placeholder,
        type: type,
        pattern: pattern
      };
      var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--date-picker-input__wrapper"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--date-picker-input__wrapper--invalid"), invalid), _defineProperty(_classNames, "".concat(prefix, "--date-picker-input__wrapper--warn"), warn), _classNames));
      var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_classNames2, "".concat(prefix, "--label--disabled"), disabled), _classNames2));
      var inputClasses = (0, _classnames.default)("".concat(prefix, "--date-picker__input"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--date-picker__input--").concat(size), size), _defineProperty(_classNames3, "".concat(prefix, "--date-picker__input--invalid"), invalid), _classNames3));

      var datePickerIcon = function () {
        if (datePickerType === 'simple' && !invalid && !warn) {
          return;
        }

        if (invalid) {
          return /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
            className: "".concat(prefix, "--date-picker__icon ").concat(prefix, "--date-picker__icon--invalid")
          });
        }

        if (!invalid && warn) {
          return /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
            className: "".concat(prefix, "--date-picker__icon ").concat(prefix, "--date-picker__icon--warn")
          });
        }

        return /*#__PURE__*/_react.default.createElement(_iconsReact.Calendar16, {
          className: "".concat(prefix, "--date-picker__icon"),
          "aria-label": iconDescription,
          onClick: openCalendar,
          role: "img"
        }, iconDescription && /*#__PURE__*/_react.default.createElement("title", null, iconDescription));
      }();

      var label = labelText ? /*#__PURE__*/_react.default.createElement("label", {
        htmlFor: id,
        className: labelClasses
      }, labelText) : null;
      var error = null;

      if (invalid) {
        error = /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--form-requirement")
        }, invalidText);
      } else if (warn) {
        error = /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--form-requirement")
        }, warnText);
      }

      var containerClasses = (0, _classnames.default)("".concat(prefix, "--date-picker-container"), _defineProperty({}, "".concat(prefix, "--date-picker--nolabel"), !label));
      var input = invalid ? /*#__PURE__*/_react.default.createElement("input", _extends({}, other, datePickerInputProps, {
        disabled: disabled,
        ref: function ref(input) {
          _this.input = input;
        },
        "data-invalid": true,
        className: inputClasses
      })) : /*#__PURE__*/_react.default.createElement("input", _extends({
        ref: function ref(input) {
          _this.input = input;
        }
      }, other, datePickerInputProps, {
        disabled: disabled,
        className: inputClasses
      }));
      return /*#__PURE__*/_react.default.createElement("div", {
        className: containerClasses
      }, label, /*#__PURE__*/_react.default.createElement("div", {
        className: wrapperClasses
      }, input, datePickerIcon), error);
    }
  }]);

  return DatePickerInput;
}(_react.Component);

exports.default = DatePickerInput;

_defineProperty(DatePickerInput, "propTypes", {
  /**
   * The type of the date picker:
   *
   * * `simple` - Without calendar dropdown.
   * * `single` - With calendar dropdown and single date.
   * * `range` - With calendar dropdown and a date range.
   */
  datePickerType: _propTypes.default.oneOf(['simple', 'single', 'range']),

  /**
   * Specify whether or not the input should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify if the label should be hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * The description of the calendar icon.
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify an id that uniquely identifies the `<input>`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify whether or not the input should be invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Specify the text to be rendered when the input is invalid
   */
  invalidText: _propTypes.default.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Specify an `onChange` handler that is called whenever a change in the
   * input field has occurred
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a function to be called when the input field is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide a function to be called when the input field is clicked
   */
  openCalendar: _propTypes.default.func,

  /**
   * Provide a regular expression that the input value must match
   */
  pattern: function pattern(props, propName, componentName) {
    if (props[propName] === undefined) {
      return;
    }

    try {
      new RegExp(props[propName]);
    } catch (e) {
      return new Error("Invalid value of prop '".concat(propName, "' supplied to '").concat(componentName, "', it should be a valid regular expression"));
    }
  },

  /**
   * Specify the placeholder text
   */
  placeholder: _propTypes.default.string,

  /**
   * Specify the size of the Date Picker Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify the type of the `<input>`
   */
  type: _propTypes.default.string,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
});

_defineProperty(DatePickerInput, "defaultProps", {
  pattern: '\\d{1,2}\\/\\d{1,2}\\/\\d{4}',
  type: 'text',
  disabled: false,
  invalid: false,
  onClick: function onClick() {},
  onChange: function onChange() {}
});