"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CopyButton;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _Copy = _interopRequireDefault(require("../Copy"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function CopyButton(_ref) {
  var iconDescription = _ref.iconDescription,
      className = _ref.className,
      other = _objectWithoutProperties(_ref, ["iconDescription", "className"]);

  return /*#__PURE__*/_react.default.createElement(_Copy.default, _extends({
    className: (0, _classnames.default)(className, "".concat(prefix, "--copy-btn")),
    "aria-label": iconDescription,
    title: iconDescription
  }, other), /*#__PURE__*/_react.default.createElement(_iconsReact.Copy16, {
    className: "".concat(prefix, "--snippet__icon")
  }));
}

CopyButton.propTypes = {
  /**
   * Specify an optional className to be applied to the underlying `<button>`
   */
  className: _propTypes.default.string,

  /**
   * Specify the string that is displayed when the button is clicked and the
   * content is copied
   */
  feedback: _propTypes.default.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: _propTypes.default.number,

  /**
   * Provide a description for the icon representing the copy action that can
   * be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * `<button>` is clicked
   */
  onClick: _propTypes.default.func
};
CopyButton.defaultProps = {
  iconDescription: 'Copy to clipboard',
  feedback: 'Copied!',
  feedbackTimeout: 2000,
  onClick: function onClick() {}
};