"use strict";

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _Button = _interopRequireDefault(require("../Button"));

var _Link = _interopRequireDefault(require("../Link"));

var _Button2 = _interopRequireDefault(require("../Button/Button.Skeleton"));

var _enzyme = require("enzyme");

var _carbonComponents = require("carbon-components");

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

require("@testing-library/jest-dom");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var prefix = _carbonComponents.settings.prefix;
describe('Button', function () {
  describe('Renders common props as expected', function () {
    var wrapper = (0, _enzyme.shallow)(
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/tabindex-no-positive
    _react.default.createElement(_Button.default, {
      tabIndex: 2,
      className: "extra-class"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child"), /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child")));
    var wrapperHref = (0, _enzyme.shallow)(
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/tabindex-no-positive
    _react.default.createElement(_Button.default, {
      tabIndex: 2,
      className: "extra-class",
      href: "/home"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child"), /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child")));
    it('renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(2);
      expect(wrapperHref.find('.child').length).toBe(2);
    });
    it('should set tabIndex if one is passed via props', function () {
      expect(wrapper.props().tabIndex).toEqual(2);
      expect(wrapperHref.props().tabIndex).toEqual(2);
    });
    it('should add extra classes via className', function () {
      expect(wrapper.hasClass('extra-class')).toBe(true);
      expect(wrapperHref.hasClass('extra-class')).toBe(true);
    });
  });
  describe('Renders <button> props as expected', function () {
    var wrapper = (0, _enzyme.shallow)(
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/tabindex-no-positive
    _react.default.createElement(_Button.default, {
      tabIndex: 2
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child"), /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child")));
    it('renders as a <button> element without an href', function () {
      expect(wrapper.is('button')).toBe(true);
    });
    it('should set disabled to false by default', function () {
      expect(wrapper.props().disabled).toBe(false);
    });
    it('should set disabled if one is passed via props', function () {
      wrapper.setProps({
        disabled: true
      });
      expect(wrapper.props().disabled).toBe(true);
    });
    it('should set type to button by default', function () {
      expect(wrapper.props().type).toEqual('button');
    });
    it('should only set type to [button, reset or submit] if one is passed via props', function () {
      wrapper.setProps({
        type: 'reset'
      });
      expect(wrapper.props().type).toEqual('reset');
      wrapper.setProps({
        type: 'submit'
      });
      expect(wrapper.props().type).toEqual('submit');
    });
  });
  describe('Renders <a> props as expected', function () {
    var wrapper = (0, _enzyme.shallow)(
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/tabindex-no-positive
    _react.default.createElement(_Button.default, {
      href: "#",
      tabIndex: 2
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child"), /*#__PURE__*/_react.default.createElement("div", {
      className: "child"
    }, "child")));
    it('renders as an <a> element with an href', function () {
      expect(wrapper.is('a')).toBe(true);
    });
  });
  describe('Renders arbitrary component with correct props', function () {
    var wrapper;
    beforeEach(function () {
      wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
        as: _Link.default,
        "data-foo": "foo"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "child"), /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "child")));
    });
    it('renders as a Link with data attribute', function () {
      expect(wrapper.is(_Link.default)).toBe(true);
      expect(wrapper.is('[data-foo="foo"]')).toBe(true);
    });
  });
  describe('Renders icon buttons', function () {
    var iconButton = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      renderIcon: _iconsReact.Search16,
      iconDescription: "Search"
    }, "Search"));
    var icon = iconButton.find('svg');
    it('should have the appropriate icon', function () {
      expect(icon.hasClass("".concat(prefix, "--btn__icon"))).toBe(true);
    });
    it('should return error if icon given without description', function () {
      var props = {
        renderIcon: _iconsReact.Search16
      }; // eslint-disable-next-line quotes

      var error = new Error('renderIcon property specified without also providing an iconDescription property.');
      expect(_Button.default.propTypes.iconDescription(props)).toEqual(error);
    });
  });
  describe('Renders custom icon buttons', function () {
    var iconButton = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      renderIcon: _iconsReact.Search16,
      iconDescription: "Search"
    }, "Search"));
    var originalIcon = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_iconsReact.Search16, null)).find('svg');
    var icon = iconButton.find('svg');
    it('should have the appropriate icon', function () {
      expect(icon.hasClass("".concat(prefix, "--btn__icon"))).toBe(true);
      expect(icon.find(':not(svg):not(title)').html()).toBe(originalIcon.children().html());
    });
    it('should return error if icon given without description', function () {
      var props = {
        renderIcon: _iconsReact.Search16
      }; // eslint-disable-next-line quotes

      var error = new Error('renderIcon property specified without also providing an iconDescription property.');
      expect(_Button.default.propTypes.iconDescription(props)).toEqual(error);
    });
  });
});
describe('Primary Button', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});
describe('Secondary Button', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "secondary",
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--secondary"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});
describe('Ghost Button', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "ghost",
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--ghost"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
}); // V11: update this to `Extra Large Button`

describe('Large Button', function () {
  describe('Renders as expected', function () {
    // V11: update this size to `xl`
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "lg",
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      // V11: update this to `xl`
      expect(wrapper.hasClass("".concat(prefix, "--btn--lg"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
}); // V11: update this to `Extra Extra Large Button`

describe('Extra Large Button', function () {
  describe('Renders as expected', function () {
    // V11: update this size to `2xl`
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "xl",
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      // V11: update to 2xl
      expect(wrapper.hasClass("".concat(prefix, "--btn--xl"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});
describe('Small Button', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "small",
      className: "extra-class"
    }));
    it('has the expected classes for small', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--sm"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
  describe('deprecated prop `small`', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "sm",
      className: "extra-class"
    }));
    it('has the expected classes for small', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--sm"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});
describe('DangerButton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "danger",
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--danger"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
  describe('Renders tertiary variation as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "danger--tertiary"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--danger--tertiary"))).toEqual(true);
    });
  });
  describe('Renders ghost variation as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "danger--ghost"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--danger--ghost"))).toEqual(true);
    });
  });
});
describe('danger--primaryButton', function () {
  describe('Renders as exptected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "danger--primary",
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--danger--primary"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});
describe('TertiaryButton', function () {
  describe('Renders as exptected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "tertiary",
      className: "extra-class"
    }));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--tertiary"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});
describe('Icon-only button', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      hasIconOnly: true
    }));
    it('has the expected classes', function () {
      expect(wrapper.find('button').hasClass("".concat(prefix, "--btn--icon-only"))).toEqual(true);
      expect(wrapper.find('button').hasClass("".concat(prefix, "--tooltip__trigger"))).toEqual(true);
      expect(wrapper.find('button').hasClass("".concat(prefix, "--tooltip--a11y"))).toEqual(true);
    });
    it('should only set tooltip position and alignment if passed via props', function () {
      wrapper.setProps({
        tooltipPosition: 'bottom'
      });
      expect(wrapper.props().tooltipPosition).toEqual('bottom');
      wrapper.setProps({
        tooltipAlignment: 'center'
      });
      expect(wrapper.props().tooltipAlignment).toEqual('center');
    });
    it('should contain assistive text', function () {
      wrapper.setProps({
        tooltipPosition: 'bottom'
      });
      wrapper.setProps({
        tooltipAlignment: 'center'
      });
      expect(wrapper.find(".".concat(prefix, "--assistive-text")).length).toEqual(1);
    });
  });
});
describe('ButtonSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button2.default, null));
    it('has the expected classes', function () {
      expect(wrapper.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
      expect(wrapper.hasClass("".concat(prefix, "--btn"))).toEqual(true);
    });
  });
  describe('Renders <a> props as expected', function () {
    var wrapper = (0, _enzyme.shallow)(
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/tabindex-no-positive
    _react.default.createElement(_Button2.default, {
      href: "#"
    }));
    it('renders as an <a> element with an href', function () {
      expect(wrapper.is('a')).toBe(true);
    });
    it('should always render with [role="button"] by default', function () {
      expect(wrapper.props().role).toEqual('button');
    });
  });
});
describe('Small ButtonSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button2.default, {
      small: true
    }));
    it('has the expected classes for small', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--sm"))).toEqual(true);
      expect(wrapper.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
    });
  });
});
describe('Small ButtonSkeleton', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_Button2.default, {
      small: true
    }));
    it('has the expected classes for small', function () {
      expect(wrapper.hasClass("".concat(prefix, "--btn--sm"))).toEqual(true);
      expect(wrapper.hasClass("".concat(prefix, "--skeleton"))).toEqual(true);
    });
  });
});
describe('Button accessibility', function () {
  afterEach(_react2.cleanup);
  it('should have no Axe violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Button.default, null, "Button Label"));
            _context.next = 3;
            return expect(_react2.screen.getByRole('button')).toHaveNoAxeViolations();

          case 3:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
  it('should have no Accessibility Checker violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            (0, _react2.render)( /*#__PURE__*/_react.default.createElement("main", null, /*#__PURE__*/_react.default.createElement(_Button.default, null, "Button Label")));
            _context2.next = 3;
            return expect(_react2.screen.getByRole('button')).toHaveNoACViolations('Button');

          case 3:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  })));
  it('is keyboard accessible', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Button.default, null, "Button Label"));

    _userEvent.default.tab();

    expect(_react2.screen.getByText('Button Label')).toHaveFocus();
  });
  it('should have an accessible label', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Button.default, null, "Button Label"));
    expect(function () {
      return _react2.screen.getByText('Button Label');
    }).not.toThrow();
  });
  it('should have the role of button', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Button.default, null, "Button Label"));
    expect(function () {
      return _react2.screen.getByRole('button');
    }).not.toThrow();
  });
  it('is not keyboard accessible when disabled', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Button.default, {
      disabled: true
    }, "Button Label"));

    _userEvent.default.tab();

    expect(document.body).toHaveFocus();
  });
});