"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.ExpressiveButtons = exports.SetOfButtons = exports.IconButton = exports.Playground = exports.Ghost = exports.Danger = exports.Tertiary = exports.Secondary = exports._Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _carbonIcons = require("carbon-icons");

var _iconsReact = require("@carbon/icons-react");

var _Button = _interopRequireDefault(require("../Button"));

var _Button2 = _interopRequireDefault(require("../Button/Button.Skeleton"));

var _ButtonSet = _interopRequireDefault(require("../ButtonSet"));

var _Button3 = _interopRequireDefault(require("./Button.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var icons = {
  None: 'None',
  'Add (Add16 from `@carbon/icons-react`)': 'Add16',
  'Add (Filled) (AddFilled16 from `@carbon/icons-react`)': 'AddFilled16',
  'Search (Search16 from `@carbon/icons-react`)': 'Search16',
  'PlayOutlineFilled16 (PlayOutlineFilled16 from `@carbon/icons-react`)': 'PlayOutlineFilled16',
  'PlayOutlineFilled32 (PlayOutlineFilled32 from `@carbon/icons-react`)': 'PlayOutlineFilled32'
};
var iconMap = {
  iconAddSolid: _carbonIcons.iconAddSolid,
  iconSearch: _carbonIcons.iconSearch,
  Add16: _iconsReact.Add16,
  AddFilled16: _iconsReact.AddFilled16,
  Search16: _iconsReact.Search16,
  PlayOutlineFilled16: _iconsReact.PlayOutlineFilled16,
  PlayOutlineFilled32: _iconsReact.PlayOutlineFilled32
};
var kinds = {
  'Primary button (primary)': 'primary',
  'Secondary button (secondary)': 'secondary',
  'Tertiary button (tertiary)': 'tertiary',
  'Danger button (danger)': 'danger',
  'Danger tertiary button (danger--tertiary)': 'danger--tertiary',
  'Danger ghost button (danger--ghost)': 'danger--ghost',
  'Ghost button (ghost)': 'ghost'
}; // V11: New size table
// const sizes = {
//   'Small  (sm)': 'sm',
//   'Medium (md)': 'md',
//   'Large  (lg)  - default': null,
//   'Extra Large (xl)': 'xl',
//   'Extra Extra Large (2xl)': '2xl',
// };

var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md)': 'md',
  Default: null,
  'Large (lg)': 'lg',
  'Extra Large (xl)': 'xl'
};
var props = {
  regular: function regular() {
    var iconToUse = iconMap[(0, _addonKnobs.select)('Icon (icon)', icons, 'none')];
    return {
      className: 'some-class',
      isExpressive: (0, _addonKnobs.boolean)('Expressive', false),
      kind: (0, _addonKnobs.select)('Button kind (kind)', kinds, 'primary'),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      size: (0, _addonKnobs.select)('Button size (size)', sizes, 'default'),
      renderIcon: !iconToUse || iconToUse.svgData ? undefined : iconToUse,
      iconDescription: (0, _addonKnobs.text)('Icon description (iconDescription)', 'Button icon'),
      onClick: (0, _addonActions.action)('onClick'),
      onFocus: (0, _addonActions.action)('onFocus')
    };
  },
  iconOnly: function iconOnly() {
    var iconToUse;

    if (iconMap[(0, _addonKnobs.select)('Icon (icon)', icons, 'Add16')] == undefined) {
      iconToUse = _iconsReact.Add16;
    } else {
      iconToUse = iconMap[(0, _addonKnobs.select)('Icon (icon)', icons, 'Add16')];
    }

    return {
      className: 'some-class',
      isExpressive: (0, _addonKnobs.boolean)('Expressive', false),
      kind: (0, _addonKnobs.select)('Button kind (kind)', kinds, 'primary'),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      isSelected: (0, _addonKnobs.boolean)('Selected (isSelected)', false),
      size: (0, _addonKnobs.select)('Button size (size)', sizes, 'default'),
      renderIcon: !iconToUse || iconToUse.svgData ? undefined : iconToUse,
      iconDescription: (0, _addonKnobs.text)('Icon description (iconDescription)', 'Button icon'),
      tooltipPosition: (0, _addonKnobs.select)('Tooltip position (tooltipPosition)', ['top', 'right', 'bottom', 'left'], 'bottom'),
      tooltipAlignment: (0, _addonKnobs.select)('Tooltip alignment (tooltipAlignment)', ['start', 'center', 'end'], 'center'),
      onClick: (0, _addonActions.action)('onClick'),
      onFocus: (0, _addonActions.action)('onFocus')
    };
  },
  set: function set() {
    var iconToUse = iconMap[(0, _addonKnobs.select)('Icon (icon)', icons, 'none')];
    return {
      className: 'some-class',
      isExpressive: (0, _addonKnobs.boolean)('Expressive', false),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      size: (0, _addonKnobs.select)('Button size (size)', sizes, 'default'),
      renderIcon: !iconToUse || iconToUse.svgData ? undefined : iconToUse,
      iconDescription: (0, _addonKnobs.text)('Icon description (iconDescription)', 'Button icon'),
      stacked: (0, _addonKnobs.boolean)('Stack buttons vertically (stacked)', false),
      onClick: (0, _addonActions.action)('onClick'),
      onFocus: (0, _addonActions.action)('onFocus')
    };
  }
};
var _default = {
  title: 'Components/Button',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Button.default,
    subcomponents: {
      ButtonSet: _ButtonSet.default,
      ButtonSkeleton: _Button2.default
    },
    docs: {
      page: _Button3.default
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_Button.default, null, "Button");
};

exports._Default = _Default;
_Default.story = {
  name: 'Button'
};

var Secondary = function Secondary() {
  return /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "secondary"
  }, "Button");
};

exports.Secondary = Secondary;

var Tertiary = function Tertiary() {
  return /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "tertiary"
  }, "Button");
};

exports.Tertiary = Tertiary;

var Danger = function Danger() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "danger"
  }, "Button"), "\xA0", /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "danger--tertiary"
  }, "Tertiary Danger Button"), "\xA0", /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "danger--ghost"
  }, "Ghost Danger Button"));
};

exports.Danger = Danger;

var Ghost = function Ghost() {
  return /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "ghost"
  }, "Button");
};

exports.Ghost = Ghost;

var Playground = function Playground() {
  var regularProps = props.regular();
  var iconOnly = props.iconOnly();

  var _props$set = props.set(),
      stacked = _props$set.stacked,
      buttonProps = _objectWithoutProperties(_props$set, ["stacked"]);

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      alignItems: 'center',
      flexWrap: 'wrap'
    }
  }, /*#__PURE__*/_react.default.createElement(_Button.default, regularProps, "Buttons"), "\xA0", !regularProps.kind.includes('danger') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Button.default, _extends({
    hasIconOnly: true
  }, iconOnly)), "\xA0", /*#__PURE__*/_react.default.createElement(_Button.default, _extends({
    hasIconOnly: true
  }, iconOnly, {
    kind: "ghost"
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginTop: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_ButtonSet.default, {
    stacked: stacked
  }, /*#__PURE__*/_react.default.createElement(_Button.default, _extends({
    kind: "secondary"
  }, buttonProps), "Secondary button"), /*#__PURE__*/_react.default.createElement(_Button.default, _extends({
    kind: "primary"
  }, buttonProps), "Primary button"))));
};

exports.Playground = Playground;

var IconButton = function IconButton() {
  return /*#__PURE__*/_react.default.createElement(_Button.default, {
    renderIcon: _iconsReact.Add16,
    iconDescription: "Icon Description",
    hasIconOnly: true,
    onClick: (0, _addonActions.action)('onClick')
  });
};

exports.IconButton = IconButton;
IconButton.story = {
  name: 'Icon Button'
};

var SetOfButtons = function SetOfButtons() {
  return /*#__PURE__*/_react.default.createElement(_ButtonSet.default, null, /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "secondary"
  }, "Secondary button"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "primary"
  }, "Primary button"));
};

exports.SetOfButtons = SetOfButtons;

var ExpressiveButtons = function ExpressiveButtons() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_Button.default, {
    isExpressive: true,
    size: "default"
  }, "Button")), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_Button.default, {
    isExpressive: true,
    size: "lg"
  }, "Button")), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_Button.default, {
    isExpressive: true,
    size: "xl"
  }, "Button")), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_Button.default, {
    isExpressive: true,
    size: "default",
    renderIcon: _iconsReact.Add16
  }, "Button")), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_Button.default, {
    isExpressive: true,
    renderIcon: _iconsReact.Add16,
    hasIconOnly: true,
    iconDescription: "Icon description"
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginTop: '1rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_ButtonSet.default, null, /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "secondary",
    isExpressive: true
  }, "Secondary button"), /*#__PURE__*/_react.default.createElement(_Button.default, {
    kind: "primary",
    isExpressive: true
  }, "Primary button"))));
};

exports.ExpressiveButtons = ExpressiveButtons;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_Button2.default, null), "\xA0", /*#__PURE__*/_react.default.createElement(_Button2.default, {
    small: true
  }));
};

exports.Skeleton = Skeleton;