/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { Add24 } from '@carbon/icons-react';
import { select } from '@storybook/addon-knobs';
import React from 'react';
import { Tooltip } from './Tooltip';
export default {
  title: 'Experimental/unstable_Tooltip',
  component: Tooltip,
  includeStories: []
};
export var Default = function Default() {
  var sizes = ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-top', 'left-bottom', 'right', 'right-top', 'right-bottom'];
  return /*#__PURE__*/React.createElement(Tooltip, {
    align: select('Specify where the target should be relative to the tooltip', sizes, 'top'),
    label: "Close"
  }, /*#__PURE__*/React.createElement("button", {
    type: "button"
  }, /*#__PURE__*/React.createElement(Add24, null)));
};
export var Description = function Description() {
  return /*#__PURE__*/React.createElement(Tooltip, {
    description: "Modify account settings"
  }, /*#__PURE__*/React.createElement("button", {
    type: "button"
  }, "Edit"));
};
export var Duration = function Duration() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Tooltip, {
    label: "Close",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/React.createElement("button", {
    type: "button"
  }, /*#__PURE__*/React.createElement(Add24, null))), /*#__PURE__*/React.createElement(Tooltip, {
    label: "Close",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/React.createElement("button", {
    type: "button"
  }, /*#__PURE__*/React.createElement(Add24, null))), /*#__PURE__*/React.createElement(Tooltip, {
    label: "Close",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/React.createElement("button", {
    type: "button"
  }, /*#__PURE__*/React.createElement(Add24, null))));
};