function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, text, boolean, select } from '@storybook/addon-knobs';
import Toggle from '../Toggle';
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined
};

var toggleProps = function toggleProps() {
  return {
    labelText: text('Label toggle input control (labelText)', 'Toggle element label'),
    className: 'some-class',
    labelA: text('Label for untoggled state (labelA)', 'Off'),
    labelB: text('Label for toggled state (labelB)', 'On'),
    disabled: boolean('Disabled (disabled)', false),
    onChange: action('onChange'),
    onToggle: action('onToggle'),
    size: select('Field size (size)', sizes, undefined) || undefined
  };
};

export default {
  title: 'Components/Toggle',
  decorators: [withKnobs],
  parameters: {
    component: Toggle,
    subcomponents: {}
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Toggle, _extends({
    defaultToggled: true
  }, toggleProps(), {
    className: "some-class",
    id: "toggle-1"
  }));
};
Default.storyName = 'Toggle';
Default.parameters = {
  info: {
    text: "\n        Toggles are controls that are used to quickly switch between two possible states. The example below shows\n        an uncontrolled Toggle component. To use the Toggle component as a controlled component, set the toggled property.\n        Setting the toggled property will allow you to change the value dynamically, whereas setting the defaultToggled\n        prop will only set the value initially. This example has defaultToggled set to true.\n      "
  }
};