/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import TabContent from '../TabContent';
import { render, screen } from '@testing-library/react';
import '@testing-library/jest-dom';
describe('TabContent', function () {
  describe('renders as expected', function () {
    it('renders children as expected', function () {
      render( /*#__PURE__*/React.createElement(TabContent, {
        selected: true
      }, /*#__PURE__*/React.createElement("div", {
        className: "child"
      }, "content"), /*#__PURE__*/React.createElement("div", {
        className: "child"
      }, "content")));
      expect(screen.getByRole('tabpanel').children.length).toEqual(2);
    });
    it('sets selected and hidden props with opposite boolean values', function () {
      var _render = render( /*#__PURE__*/React.createElement(TabContent, null, /*#__PURE__*/React.createElement("div", {
        className: "child"
      }, "content"), /*#__PURE__*/React.createElement("div", {
        className: "child"
      }, "content"))),
          rerender = _render.rerender;

      expect(screen.queryByRole('tabpanel')).not.toBeInTheDocument();
      rerender( /*#__PURE__*/React.createElement(TabContent, {
        selected: true
      }, /*#__PURE__*/React.createElement("div", {
        className: "child"
      }, "content"), /*#__PURE__*/React.createElement("div", {
        className: "child"
      }, "content")));
      expect(screen.getByRole('tabpanel')).toBeVisible();
    });
    it('includes the content container in the tabbable index when no tabble contents is provided', function () {
      render( /*#__PURE__*/React.createElement(TabContent, {
        selected: true
      }, /*#__PURE__*/React.createElement("p", null, "content")));
      expect(screen.getByRole('tabpanel')).toHaveAttribute('tabindex', '0');
    });
    it('does not include the content container in the tabbable index when tabble contents is provided', function () {
      render( /*#__PURE__*/React.createElement(TabContent, {
        selected: true
      }, /*#__PURE__*/React.createElement("a", {
        href: "https://www.ibm.com/"
      }, "content")));
      expect(screen.getByRole('tabpanel')).not.toHaveAttribute('tabindex', '0');
    });
  });
});