function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useEffect } from 'react';
import { withKnobs, text, boolean, number } from '@storybook/addon-knobs';
import ProgressBar from '../ProgressBar';

var props = function props() {
  return {
    label: text('Label text (label)', 'Progress bar label'),
    helperText: text('Helper text (helperText)', 'Optional helper text'),
    hideLabel: boolean('Hide the label (hideLabel)', false),
    value: number('Current value (value)', 75),
    max: number('Maximum value (max)', 100)
  };
};

export default {
  title: 'Experimental/unstable_ProgressBar',
  decorators: [withKnobs],
  parameters: {
    component: ProgressBar
  }
};
export var _ProgressBar = function _ProgressBar() {
  return /*#__PURE__*/React.createElement(ProgressBar, {
    label: "Progress bar label",
    helperText: "Optional helper text",
    value: 75
  });
};
_ProgressBar.storyName = 'ProgressBar';
export var Indeterminate = function Indeterminate() {
  return /*#__PURE__*/React.createElement(ProgressBar, {
    label: "Progress bar label",
    helperText: "Optional helper text"
  });
};
export var Example = function Example() {
  var size = 728;

  var _useState = useState(0),
      _useState2 = _slicedToArray(_useState, 2),
      progress = _useState2[0],
      setProgress = _useState2[1];

  useEffect(function () {
    setTimeout(function () {
      var interval = setInterval(function () {
        setProgress(function (currentProgress) {
          var advancement = Math.random() * 8;

          if (currentProgress + advancement < size) {
            return currentProgress + advancement;
          } else {
            clearInterval(interval);
            return size;
          }
        });
      }, 50);
    }, 3000);
  }, []);
  var running = progress > 0;
  var helperText = running ? "".concat(progress.toFixed(1), "MB of ").concat(size, "MB") : 'Fetching assets...';

  if (progress >= size) {
    helperText = 'Done';
  }

  return /*#__PURE__*/React.createElement(ProgressBar, {
    value: running ? progress : null,
    max: size,
    label: "Export data",
    helperText: helperText
  });
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(ProgressBar, props());
};