function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
import SkeletonText from '../SkeletonText';
var prefix = settings.prefix;

function PaginationSkeleton(_ref) {
  var className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["className"]);

  return /*#__PURE__*/React.createElement("div", _extends({
    className: cx("".concat(prefix, "--pagination"), "".concat(prefix, "--skeleton"), className)
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--pagination__left")
  }, /*#__PURE__*/React.createElement(SkeletonText, {
    width: "70px"
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    width: "35px"
  }), /*#__PURE__*/React.createElement(SkeletonText, {
    width: "105px"
  })), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--pagination__right ").concat(prefix, "--pagination--inline")
  }, /*#__PURE__*/React.createElement(SkeletonText, {
    width: "70px"
  })));
}

PaginationSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string
};
export default PaginationSkeleton;